/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;
import com.businesslogic.ireport.*;
import java.util.*;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "VariableForm"
 * non viene creato nel metodo main().
 */
public class VariableForm extends Form
{
	String name="";
	String classType ="";
	String resetType ="";
	String calcType ="";
	String resetGroup ="";
	String expression ="";
	String initVal ="";
	Report report = null;
	
	public VariableForm(Report rf)
	{
		super();

		this.report = rf;
		updateGroups(report);
		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		comboBoxType.setSelectedIndex(0);
		comboBoxResetType.setSelectedItem("Report");
		comboBoxCalcType.setSelectedItem("Nothing");
	}
	
	public void updateGroups(Report rf)
	{
		comboBoxGroups.removeAll();
		Enumeration enum  = rf.groups.elements();
		comboBoxGroups.addItem("");
		while (enum.hasMoreElements())
		{
		    comboBoxGroups.addItem( ((Group)enum.nextElement()).name );
		}
	}

	/**
	 * VariableForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}
	
	
	public void setFieldName(String name)
	{
		this.name = name;
		editName.setText(name);
	}
	public void setClassType(String type)
	{
		this.classType = type;
		comboBoxType.setSelectedItem(type);
	}
	public String getFieldName()
	{
		return name;
	}
	public String getClassType()
	{
		return classType;
	}
	
	
	public void setResetType(String type)
	{
		this.resetType = type;
		comboBoxResetType.setSelectedItem(type);
		comboBoxResetType_selectedIndexChanged(comboBoxResetType,new Event());
	}
	public String getResetType()
	{
		return resetType;
	}
	
	public void setCalcType(String type)
	{
		this.calcType = type;
		comboBoxCalcType.setSelectedItem(type);
	}
	public String getCalcType()
	{
		return calcType;
	}
	
	public void setResetGroup(String type)
	{
		this.resetGroup = type;
		comboBoxGroups.setSelectedItem(type);
		comboBoxResetType_selectedIndexChanged(comboBoxResetType,new Event());
	}
	public String getResetGroup()
	{
		return resetGroup;
	}
	
	public void setExpression(String type)
	{
		this.expression = type;
		editExpression.setText(type);
	}
	public String getExpression()
	{
		return expression ;
	}
	
	public void setInitVal(String type)
	{
		this.initVal  = type;
		editInitVal.setText(type);
	}
	public String getInitVal()
	{
		return initVal ;
	}
	

	private void button2_click(Object source, Event e)
	{
		if (editName.getText().trim().length() == 0)
		{
			MessageBox.show("Please, insert a valid variable name!","Error!",MessageBox.ICONEXCLAMATION);
			return;
		}
		
		name = this.editName.getText();
		classType = this.comboBoxType.getText();
		initVal = this.editInitVal.getText();
		expression = this.editExpression.getText();
		resetType = this.comboBoxResetType.getText();
		calcType = this.comboBoxCalcType.getText();
		resetGroup  = (String)this.comboBoxGroups.getSelectedItem();
		
		if ((resetGroup == null || resetGroup.length() == 0) && resetType.equals("Group"))
		{
			MessageBox.show("You must select a reset group!");
			return;
		}
		
		this.setDialogResult(DialogResult.OK);
		this.dispose();
	}

	private void editExpression_textChanged(Object source, Event e)
	{
		expression = editExpression.getText();
		if ( ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editExpression.getSelectionStart();
		editExpression.setRTF(report.formatExpression( editExpression.getText()));
		editExpression.setSelectionStart(pos);
	}

	private void editExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editExpression, new Point(e.x,e.y));
	}

	private void menuItem4_click(Object source, Event e)
	{
		source = this.getActiveControl();
		if (source instanceof RichEdit)
		{
			ExpressionGeneratorForm ef = new ExpressionGeneratorForm(report );
			ef.setExpression(((RichEdit)source).getText());
			if (ef.showDialog() == DialogResult.OK)
			{
				((RichEdit)source).setRTF(report.formatExpression(ef.getExpression()));
			}
		}
	}

	private void comboBoxGroups_selectedIndexChanged(Object source, Event e)
	{
		resetGroup = (String)comboBoxGroups.getSelectedItem();
	}

	private void comboBoxResetType_selectedIndexChanged(Object source, Event e)
	{
		if (!this.comboBoxResetType.getText().equals("Group"))
		{
			comboBoxGroups.setSelectedIndex(0);
		}
	}

	private void editInitVal_textChanged(Object source, Event e)
	{
		if ( ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.report.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editInitVal.getSelectionStart();
		editInitVal.setRTF(report.formatExpression( editInitVal.getText()));
		editInitVal.setSelectionStart(pos);
	}

	private void editInitVal_keyUp(Object source, KeyEvent e)
	{
		
	}

	private void editInitVal_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editInitVal, new Point(e.x,e.y));
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Label label4 = new Label();
	Label label1 = new Label();
	Edit editName = new Edit();
	Label label2 = new Label();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button button2 = new Button();
	Label label3 = new Label();
	ComboBox comboBoxType = new ComboBox();
	ComboBox comboBoxResetType = new ComboBox();
	Label label5 = new Label();
	ComboBox comboBoxCalcType = new ComboBox();
	Label label6 = new Label();
	RichEdit editExpression = new RichEdit();
	RichEdit editInitVal = new RichEdit();
	Label label7 = new Label();
	ComboBox comboBoxGroups = new ComboBox();
	Label label9 = new Label();
	ContextMenu contextMenu2 = new ContextMenu();
	MenuItem menuItem4 = new MenuItem();

	private void initForm()
	{
		this.setText("VariableForm");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(307, 308));

		label4.setLocation(new Point(4, 92));
		label4.setSize(new Point(100, 16));
		label4.setTabIndex(12);
		label4.setTabStop(false);
		label4.setText("Reset type");

		label1.setLocation(new Point(4, 4));
		label1.setSize(new Point(72, 16));
		label1.setTabIndex(17);
		label1.setTabStop(false);
		label1.setText("Name");

		editName.setLocation(new Point(4, 20));
		editName.setSize(new Point(296, 20));
		editName.setTabIndex(0);
		editName.setText("");

		label2.setLocation(new Point(4, 4));
		label2.setSize(new Point(100, 16));
		label2.setTabIndex(15);
		label2.setTabStop(false);
		label2.setText("Variable name");

		groupBox1.setLocation(new Point(4, 268));
		groupBox1.setSize(new Point(292, 4));
		groupBox1.setTabIndex(16);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		button1.setLocation(new Point(228, 280));
		button1.setSize(new Point(68, 24));
		button1.setTabIndex(8);
		button1.setText("Cancel");
		button1.setDialogResult(DialogResult.CANCEL);

		button2.setLocation(new Point(156, 280));
		button2.setSize(new Point(64, 24));
		button2.setTabIndex(7);
		button2.setText("Ok");
		button2.addOnClick(new EventHandler(this.button2_click));

		label3.setLocation(new Point(4, 48));
		label3.setSize(new Point(100, 16));
		label3.setTabIndex(14);
		label3.setTabStop(false);
		label3.setText("Variable type");

		comboBoxType.setLocation(new Point(4, 64));
		comboBoxType.setSize(new Point(156, 21));
		comboBoxType.setTabIndex(1);
		comboBoxType.setText("");
		comboBoxType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxType.setItems(new Object[] {
							  "java.lang.String", 
							  "java.lang.Object", 
							  "java.lang.Boolean", 
							  "java.lang.Byte", 
							  "java.util.Date", 
							  "java.sql.Timestamp", 
							  "java.lang.Double", 
							  "java.lang.Float", 
							  "java.lang.Integer", 
							  "java.io.InputStream", 
							  "java.lang.Long", 
							  "java.lang.Short", 
							  "java.math.BigDecimal"});

		comboBoxResetType.setLocation(new Point(4, 108));
		comboBoxResetType.setSize(new Point(132, 21));
		comboBoxResetType.setTabIndex(3);
		comboBoxResetType.setText("");
		comboBoxResetType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxResetType.setItems(new Object[] {
								   "None", 
								   "Report", 
								   "Page", 
								   "Column", 
								   "Group"});
		comboBoxResetType.addOnSelectedIndexChanged(new EventHandler(this.comboBoxResetType_selectedIndexChanged));

		label5.setLocation(new Point(168, 48));
		label5.setSize(new Point(100, 16));
		label5.setTabIndex(9);
		label5.setTabStop(false);
		label5.setText("Calculation type");

		comboBoxCalcType.setLocation(new Point(168, 64));
		comboBoxCalcType.setSize(new Point(132, 21));
		comboBoxCalcType.setTabIndex(2);
		comboBoxCalcType.setText("");
		comboBoxCalcType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxCalcType.setItems(new Object[] {
								  "Nothing", 
								  "Count", 
								  "Sum", 
								  "Average", 
								  "Lowest", 
								  "Highest", 
								  "StandardDeviation", 
								  "Variance", 
								  "System"});

		label6.setLocation(new Point(4, 136));
		label6.setSize(new Point(100, 16));
		label6.setTabIndex(11);
		label6.setTabStop(false);
		label6.setText("Expression");

		editExpression.setFont(Font.DEFAULT_GUI);
		editExpression.setForeColor(Color.WINDOWTEXT);
		editExpression.setLocation(new Point(4, 152));
		editExpression.setSize(new Point(296, 44));
		editExpression.setTabIndex(5);
		editExpression.setText("");
		editExpression.addOnMouseUp(new MouseEventHandler(this.editExpression_mouseUp));
		editExpression.addOnTextChanged(new EventHandler(this.editExpression_textChanged));

		editInitVal.setFont(Font.DEFAULT_GUI);
		editInitVal.setForeColor(Color.WINDOWTEXT);
		editInitVal.setLocation(new Point(4, 216));
		editInitVal.setSize(new Point(296, 44));
		editInitVal.setTabIndex(6);
		editInitVal.setText("");
		editInitVal.addOnKeyUp(new KeyEventHandler(this.editInitVal_keyUp));
		editInitVal.addOnMouseUp(new MouseEventHandler(this.editInitVal_mouseUp));
		editInitVal.addOnTextChanged(new EventHandler(this.editInitVal_textChanged));

		label7.setLocation(new Point(4, 200));
		label7.setSize(new Point(132, 16));
		label7.setTabIndex(10);
		label7.setTabStop(false);
		label7.setText("Inital value expression");

		comboBoxGroups.setLocation(new Point(144, 108));
		comboBoxGroups.setSize(new Point(152, 21));
		comboBoxGroups.setTabIndex(4);
		comboBoxGroups.setText("");
		comboBoxGroups.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxGroups.addOnSelectedIndexChanged(new EventHandler(this.comboBoxGroups_selectedIndexChanged));

		label9.setLocation(new Point(144, 92));
		label9.setSize(new Point(100, 16));
		label9.setTabIndex(13);
		label9.setTabStop(false);
		label9.setText("Reset group");

		menuItem4.setText("Edit with JasperExpression editor...");
		menuItem4.addOnClick(new EventHandler(this.menuItem4_click));

		contextMenu2.setMenuItems(new MenuItem[] {
								  menuItem4});
		/* @designTimeOnly contextMenu2.setLocation(new Point(116, 68)); */

		this.setNewControls(new Control[] {
							comboBoxGroups, 
							label9, 
							label7, 
							editInitVal, 
							editExpression, 
							label6, 
							comboBoxCalcType, 
							label5, 
							comboBoxResetType, 
							label4, 
							comboBoxType, 
							label3, 
							button2, 
							button1, 
							groupBox1, 
							label2, 
							editName, 
							label1});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new VariableForm(null));
	}
}
