/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.design;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.design.JRClassGenerator;
import dori.jasper.engine.design.JRVerifier;
import dori.jasper.engine.design.JasperDesign;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;

public class JRCompiler {
    private static boolean wasWarning = false;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        File classFile;
        JasperReport jasperReport;
        block13: {
            File tempDirFile;
            jasperReport = null;
            Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
            if (brokenRules != null && brokenRules.size() > 0) {
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append("Report design not valid : ");
                int i = 1;
                Iterator it = brokenRules.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        throw new JRException(sbuffer.toString());
                    }
                    sbuffer.append("\n\t " + i + ". " + (String)it.next());
                    ++i;
                }
            }
            String tempDirStr = System.getProperty("jasper.reports.compile.temp");
            if (tempDirStr == null || tempDirStr.length() == 0) {
                tempDirStr = System.getProperty("user.dir");
            }
            if (!(tempDirFile = new File(tempDirStr)).exists()) throw new JRException("Temporary directory not found : " + tempDirStr);
            if (!tempDirFile.isDirectory()) {
                throw new JRException("Temporary directory not found : " + tempDirStr);
            }
            boolean isKeepJavaFile = Boolean.valueOf(System.getProperty("jasper.reports.compile.keep.java.file"));
            File javaFile = new File(tempDirFile, jasperDesign.getName() + ".java");
            classFile = new File(tempDirFile, jasperDesign.getName() + ".class");
            String sourceCode = JRClassGenerator.generateClass(jasperDesign);
            JRCompiler.saveClass(sourceCode, javaFile);
            try {
                try {
                    String compileErrors = JRCompiler.compileClass(javaFile);
                    if (compileErrors != null) {
                        throw new JRException("Errors were encountered when compiling report design:\n" + compileErrors);
                    }
                    jasperReport = new JasperReport(jasperDesign, JRCompiler.readClassBytecodes(classFile));
                }
                catch (JRException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JRException("Error compiling report design.", e);
                }
                Object var12_14 = null;
                if (isKeepJavaFile) break block13;
                javaFile.delete();
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (!isKeepJavaFile) {
                    javaFile.delete();
                }
                classFile.delete();
                throw throwable;
            }
        }
        classFile.delete();
        return jasperReport;
    }

    protected static void saveClass(String source, File file) throws JRException {
        try {
            FileWriter fwriter = new FileWriter(file);
            fwriter.write(source);
            fwriter.flush();
            fwriter.close();
        }
        catch (IOException e) {
            throw new JRException("Error saving expressions class file : " + file, e);
        }
    }

    protected static String compileClass(File sourceFile) throws JRException {
        String compiler;
        String classpath = System.getProperty("jasper.reports.compile.class.path");
        if (classpath == null || classpath.length() == 0) {
            classpath = System.getProperty("java.class.path");
        }
        if ((compiler = System.getProperty("jasper.reports.compiler")) == null || classpath.length() == 0) {
            try {
                Class<?> javacClass = Class.forName("sun.tools.javac.Main");
            }
            catch (Exception e) {
                if (!wasWarning) {
                    System.out.println("********************************************************************");
                    System.out.println("* WARNING: Unable to compile with \"sun.tools.javac.Main\" compiler. *");
                    System.out.println("* Cause  : " + e.getClass().getName() + " : " + e.getMessage() + " *");
                    System.out.println("* Compiling with command line \"javac\" compiler.                    *");
                    System.out.println("********************************************************************");
                    wasWarning = true;
                }
                compiler = "javac";
            }
        }
        if (compiler == null || classpath.length() == 0) {
            return JRCompiler.compileClass(sourceFile, classpath);
        }
        return JRCompiler.compileClassWithExeCompiler(sourceFile, classpath, compiler);
    }

    protected static String compileClass(File sourceFile, String classpath) throws JRException {
        String[] source = new String[]{sourceFile.getPath(), "-classpath", classpath};
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Class<?> javacClass = Class.forName("sun.tools.javac.Main");
            Constructor<?> constructor = javacClass.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = JRCompiler.class$("java.io.OutputStream")) : class$java$io$OutputStream, class$java$lang$String == null ? (class$java$lang$String = JRCompiler.class$("java.lang.String")) : class$java$lang$String);
            Method compileMethod = javacClass.getMethod("compile", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JRCompiler.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            Object javac = constructor.newInstance(baos, source[0]);
            compileMethod.invoke(javac, new Object[]{source});
        }
        catch (Exception e) {
            throw new JRException("Error compiling report java source file : " + sourceFile, e);
        }
        if (baos.toString().indexOf("error") != -1) {
            return baos.toString();
        }
        return null;
    }

    protected static String compileClassWithExeCompiler(File sourceFile, String classpath, String compiler) throws JRException {
        String[] source = new String[]{compiler, "-classpath", classpath, sourceFile.getPath()};
        try {
            Process compile = Runtime.getRuntime().exec(source);
            InputStream errFile = compile.getErrorStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int count = 0;
            do {
                if ((count = errFile.read(buffer)) <= 0) continue;
                baos.write(buffer, 0, count);
            } while (count >= 0);
            if (baos.toString().indexOf("error") != -1) {
                return baos.toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new JRException("Error compiling report java source file : " + sourceFile, e);
        }
    }

    protected static byte[] readClassBytecodes(File classFile) throws JRException {
        try {
            FileInputStream fis = new FileInputStream(classFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytecodes = new byte[10000];
            int ln = 0;
            while ((ln = fis.read(bytecodes)) > 0) {
                baos.write(bytecodes, 0, ln);
            }
            baos.flush();
            baos.close();
            fis.close();
            bytecodes = baos.toByteArray();
            return bytecodes;
        }
        catch (Exception e) {
            throw new JRException("Error reading class byte codes from compiled class file : " + classFile, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

