/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;

public class TextFieldReportElement extends TextReportElement 
{
	public boolean isStretchWithOverflow=false;
	public String pattern="";
	public boolean isBlankWhenNull=false;
	public String fieldClass;
	
	public String hyperlinkType="None";
	public String evaluationTime="Now";
	public String evaluationGroup="";
	
	public String anchorNameExpression="";
	public String hyperlinkReferenceExpression="";
	public String hyperlinkAnchorExpression="";
	public String hyperlinkPageExpression="";
	
	public TextFieldReportElement(int x, int y, int width, int height, Brush hached)
	{
		super(x,y,width,height,hached);
		evaluationTime = "Now";
		isStretchWithOverflow = false;
		evaluationGroup="";
		pattern="";
		isBlankWhenNull = false;
		fieldClass = "java.lang.String";
		this.text = "$F{Field}";
	}
	
	public ReportElement cloneMe()
	{
		TextFieldReportElement newReportElement = new TextFieldReportElement(position.x, position.y, width, height, hached);
		newReportElement.name = new String(name);
		copyElementPropertiesTo(newReportElement);
		copyTextPropertiesTo(newReportElement);
		return newReportElement;
	}

	public void copyElementPropertiesTo(ReportElement newReportElement)
	{
		super.copyElementPropertiesTo( newReportElement );
	
		TextFieldReportElement textFieldReportElement = (TextFieldReportElement)newReportElement;
		textFieldReportElement.evaluationTime = evaluationTime;
		textFieldReportElement.evaluationGroup = evaluationGroup;
		textFieldReportElement.isStretchWithOverflow = isStretchWithOverflow;
		textFieldReportElement.pattern = pattern;
		textFieldReportElement.isBlankWhenNull = isBlankWhenNull;
		textFieldReportElement.fieldClass = fieldClass;
		textFieldReportElement.hyperlinkType = hyperlinkType;

		textFieldReportElement.anchorNameExpression = anchorNameExpression;
		textFieldReportElement.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
		textFieldReportElement.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
		textFieldReportElement.hyperlinkPageExpression = hyperlinkPageExpression;

	}

	
}
