/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport;

import com.businesslogic.ireport.ui.*;
import com.businesslogic.ireport.util.*;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;

public class TextReportElement extends ReportElement 
{
	public String text;
	public Font   font;
	public String align;
	public String lineSpacing;
	public String pdfFontName;
	public String fontName;
	public String reportFont="";
	public boolean isPdfEmbedded;
	public String  pdfEncoding;
	public int size;
	public boolean bold;
	public boolean italic;
	public boolean stroke;
	public boolean underline;
	
	public static MainForm mf;
	public String verticalAlignment="Top";
	
	
	public TextReportElement(int x, int y, int width, int height, Brush hached)
	{
		super(x,y,width,height,hached);
		text = "Text";
		pdfFontName = "Helvetica";
		fontName = "Helvetica";
		size = 10;
		bold = false;
		italic = false;
		stroke = false;
		underline = false;
		font = new Font("Helvetica",(float)( 10*0.76),FontSize.POINTS);
		align = "Left";
		lineSpacing = "Single";
		mode= "Transparent";
		pdfEncoding = "";
		isPdfEmbedded = false;
	}
	
	public void setFontFile(String fontName)
	{
		this.fontName = fontName;
		font = null;
		//font = new Font( fontName,(float)(this.size*0.76),FontSize.POINTS,(( bold )? FontWeight.BOLD  : FontWeight.NORMAL),italic,underline,stroke);  
	}	
	
	public void drawObject(Graphics g, double zoom_factor, int x_shift_origin, int y_shift_origin)
	{
		this.zoom_factor = zoom_factor;
		Font f = g.getFont();
		
		if (this.font == null)
		{
			String theFontName = pdfFontName;
			theFontName = FontUtil.getWinFontName( pdfFontName );
			if (mf != null && this.fontName != null && mf.getFontName(fontName) != null)
			{
				theFontName = mf.getFontName(fontName);
			}
			//text = theFontName;
			font = new Font( theFontName,(float)size*(float)0.76,FontSize.POINTS,(( bold )? FontWeight.BOLD  : FontWeight.NORMAL),italic,underline,stroke);  
		}
		
		
		Font f2 = new Font(((font != null) ? font : f), (float)(zoom_factor* font.getSize()), font.getUnits()); 
	
		Bitmap b = new Bitmap(10,10);
		b.getGraphics().setFont(f2);
		b.getGraphics().drawString("X",new Point(0,0));
		
		
		g.setFont(f2);
		g.setTextColor(this.fgcolor);
		int style=0;
		
		if (align.equalsIgnoreCase("Left"))
			style |= TextFormat.LEFT;
		else if (align.equalsIgnoreCase("Right"))
			style |= TextFormat.RIGHT;
		else if (align.equalsIgnoreCase("Center"))
			style |= TextFormat.HORIZONTALCENTER;
		else if (align.equalsIgnoreCase("Justify"))
			style |= TextFormat.HORIZONTALCENTER;
		
		com.ms.win32.SIZE s = new com.ms.win32.SIZE();
		com.ms.win32.Gdi32.GetTextExtentPoint32(b.getGraphics().getHandle(), this.text, this.text.length(),s);
		
		if (!mode.equalsIgnoreCase("Transparent"))
			g.fill( getZoomedDim(position.x-10)+10-x_shift_origin,getZoomedDim(position.y-10)+10-y_shift_origin,getZoomedDim(width),getZoomedDim(height),new Brush(bgcolor, BrushStyle.SOLID));
		
		
		
		//if (s!= null && s.cx <=  getZoomedDim(width)) 
		if (verticalAlignment.equalsIgnoreCase("Bottom"))
			style |= TextFormat.BOTTOM ;
		else if (verticalAlignment.equalsIgnoreCase("Middle"))
			style |= TextFormat.VERTICALCENTER;
		//else
		//	style |= TextFormat.TOP;
		
		style |= TextFormat.WORDBREAK;
		style |= TextFormat.EDITCONTROL;
		g.drawString( text, new Rectangle(getZoomedDim(position.x-10)+10-x_shift_origin,getZoomedDim(position.y-10)+10-y_shift_origin,getZoomedDim(width),getZoomedDim(height)),style   | TextFormat.WORDBREAK );
		
		g.setFont(f);
		drawBorder(g,zoom_factor, x_shift_origin, y_shift_origin);
		
	}
	
	public void copyTextPropertiesTo(TextReportElement t)
	{
		t.text = new String(text);
		t.font = null;
		t.align = new String(align);
		t.lineSpacing = new String(lineSpacing);
		t.pdfFontName = new String(pdfFontName);
		t.fontName = new String(fontName);
		t.reportFont = new String(reportFont);
		t.isPdfEmbedded = isPdfEmbedded;
		t.pdfEncoding = new String(pdfEncoding);
		t.size = size;
		t.bold = bold;
		t.italic = italic;
		t.stroke = stroke;
		t.underline = underline;
		t.verticalAlignment = verticalAlignment;
	}
}
