/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.businesslogic.ireport.util.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ElementProperties"
 * non viene creato nel metodo main().
 * 
 * zovi
 * ----
 * 
 * - Change the way of the element type are detected.. Via the Class object and not the instanceof
 * - Accept several reportElement... will select the base type ... 
 * - Short cut to open a subreport
 * 
 */

public class ElementProperties extends Form
{
	Color backcolor;
	Color forecolor;
	String lastSelectedPage;
	ReportForm reportForm = null;
	ReportElement reportElement[] = null;
	int y_relative;
	boolean init = false;
	
	public ElementProperties()
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		backcolor = Color.WHITE;
		forecolor = Color.BLACK;
		
		numberComboBoxFontSize.addItem(new NumberComboValue("8", 8));
		numberComboBoxFontSize.addItem(new NumberComboValue("9", 9));
		numberComboBoxFontSize.addItem(new NumberComboValue("10", 10));
		numberComboBoxFontSize.addItem(new NumberComboValue("11", 11));
		numberComboBoxFontSize.addItem(new NumberComboValue("12", 12));
		numberComboBoxFontSize.addItem(new NumberComboValue("14", 14));
		numberComboBoxFontSize.addItem(new NumberComboValue("16", 16));
		numberComboBoxFontSize.addItem(new NumberComboValue("18", 18));
		numberComboBoxFontSize.addItem(new NumberComboValue("20", 20));
		numberComboBoxFontSize.addItem(new NumberComboValue("22", 22));
		numberComboBoxFontSize.addItem(new NumberComboValue("24", 24));
		numberComboBoxFontSize.addItem(new NumberComboValue("26", 26));
		numberComboBoxFontSize.addItem(new NumberComboValue("28", 28));
		numberComboBoxFontSize.addItem(new NumberComboValue("36", 36));
		numberComboBoxFontSize.addItem(new NumberComboValue("48", 48));
		numberComboBoxFontSize.addItem(new NumberComboValue("72", 72));
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
	}

	public void updateGroups(ReportForm rf)
	{
		comboBoxGroup.removeAll();
		comboBoxImgEvalGroup.removeAll();
		comboBoxTextFieldEvalGroup.removeAll();
		Enumeration enum  = rf.getReport().groups.elements();
		comboBoxGroup.addItem("");
		comboBoxImgEvalGroup.addItem("");
		comboBoxTextFieldEvalGroup.addItem("");
		while (enum.hasMoreElements())
		{
			String grp  =((Group)enum.nextElement()).name;
		    comboBoxGroup.addItem(grp);
			comboBoxImgEvalGroup.addItem(grp );
			comboBoxTextFieldEvalGroup.addItem(grp);
		}
		
	}
	
	public void updateFonts(ReportForm rf)
	{
		comboBoxReportFonts.removeAll();
		Enumeration enum  = rf.getReport().fonts.elements();
		comboBoxReportFonts.addItem("");
		while (enum.hasMoreElements())
		{
			IFont font  =(IFont)enum.nextElement();
		    comboBoxReportFonts.addItem(font);
		}
		
	}
	
	public void setEelement(ReportForm rf, ReportElement re[])
	{
	  // the selection is not the same ?
	  if ( ( re != null ) && ( reportElement != null ) && ( re.length == reportElement.length ))
	  {
		  boolean allEquals = false;
		  for ( int i =0; i < re.length; i++ )
		  {
			  if ( re[i] == reportElement[i] )
			  {
				  allEquals = true;
			  }
		  }
		  if ( allEquals )
			  return;
	  }
	  if (( re == null ) || ( re.length == 0 ))
	  {
		  if (( reportElement == null ) || (reportElement.length == 0) )
			  return;
	  }
	  
	  try
	  {
		init = true;
		if (rf==null)
		{
			this.dispose();
			return;
		}
		updateGroups(rf);
		updateFonts(rf);
		

		// Save selected tab for restore if possible...
		TabPage selectedtp = tabControl1.getSelectedTab(); 
		int index = tabControl1.getSelectedIndex();
		
		reportElement = re;
		reportForm = rf;
			
		if (tabControl1.getTabCount() > 0)
		{
			TabPage[] tp = tabControl1.getTabs();
			
			for (int i=1; i<tp.length; ++i)
			{
				if (tp[i] != tabPage1) 
				tabControl1.remove(tp[i]);
			}
		}
		
		if ((reportElement == null ) || ( reportElement.length == 0 ))
		{
            this.tabPage1.setVisible(false);
			this.setText("No element selected!");
			return;
		}
		else
			this.tabPage1.setVisible(true);
		
		if ( reportElement.length == 1 )
		{
 		  this.setText("Properties of "+reportElement[0].name);
		} else
		{
 		  this.setText("Properties of " + reportElement.length + " elements ");
		}
		
		//Load bands...
		updateBands();

		setReportElement( reportElement );
		
		
		Class editingClass = getBaseClass( reportElement );
		if ( (reportElement.length > 1) && (editingClass == SubReportElement.class ))
		{
			editingClass = ReportElement.class; // editing multiple sub report if too complex .. only one at a time is allowed ...
		}

		if ( TextReportElement.class.isAssignableFrom( editingClass ) )
		{
			setTextReportElement(reportElement);
			if (StaticTextReportElement.class.isAssignableFrom( editingClass ))
			{	
			  setStaticTextReportElement(reportElement);
			}
			else if (TextFieldReportElement.class.isAssignableFrom( editingClass ))
			{
    		  setTextFieldReportElement(reportElement);
			} else
			{
		      tabControl1.add(tabPageTextProperties);
			}
		} else	
		if ( GraphicReportElement.class.isAssignableFrom( editingClass ) )
		{
		  setGraphicReportElement(reportElement);
		  if (LineReportElement.class.isAssignableFrom( editingClass ))
  		  {
			tabControl1.add(tabPageLine);
			tabControl1.add(tabPageGraphicElement);
			LineReportElement lre = (LineReportElement)reportElement[0];
			comboBoxPen.setSelectedItem(lre.graphicElementPen);
			comboBoxDirection.setSelectedItem(lre.direction);
		  } else if (EllipseReportElement.class.isAssignableFrom( editingClass ))
		  {
			tabControl1.add(tabPageGraphicElement);
			EllipseReportElement rre = (EllipseReportElement)reportElement[0];
			comboBoxPen.setSelectedItem(rre.graphicElementPen);
		  } else if (ImageReportElement.class.isAssignableFrom( editingClass ))
		  {
			setImageReportElement(reportElement);
		  } else if (RectangleReportElement.class.isAssignableFrom( editingClass ))
		  {
			setRectangleReportElement(reportElement);
	  	  } else
		  {
 	        tabControl1.add(tabPageGraphicElement);
		  }
		} else
		if ( SubReportElement.class.isAssignableFrom( editingClass ))
		{
			setSubReportElement((SubReportElement)reportElement[0]);
		}
		TabPage pages[] = tabControl1.getTabs();
		TabPage page = null;
		if ( lastSelectedPage != null )
		{
		  for ( int i = 0; i < pages.length; i ++ )
		  {
		    if ( safeEquals( pages[i].getText(), lastSelectedPage ))
		    {
			  page = pages[i];
 	          tabControl1.setSelectedIndex( i );
			  return;
		    }
		  }
		}
		lastSelectedPage = null;		
			
 	    //tabControl1.setSelectedIndex( 2 );
		// if (( page != null ) )
		//{			
		//	tabControl1.setSelectedIndex( 2 );
		//		
	  	//tabControl1.setSelectedTab(page); 
		//} else
		//{
		//  tabControl1.setSelectedTab(tabPage1); 
		//}
	  } finally
	  {
		init = false;
	  }
	}
	
	
	public void updateBands()
	{
		this.comboBoxBands.removeAll();
		if (reportForm != null)
		{
			Enumeration enum = reportForm.getReport().bands.elements();
			while (enum.hasMoreElements())
			{
				Band b = (Band)enum.nextElement();
				comboBoxBands.addItem(b);
			}
		}
	}
	
	private Class getBaseClass( Object[] reportElement )
	{
		Class result = null;
		for ( int i = 0; i < reportElement.length ; i++ )
		{
			// MessageBox.show("Class : " + (result == null ? "null" : ""+result));
				
			if ( result == null )
			{
				result = reportElement[i].getClass();
			    continue;	
			}	
			while ( !result.isAssignableFrom(reportElement[i].getClass())  )
			{
				result = result.getSuperclass();
			}
		}
		// MessageBox.show("Final Class : " + (result == null ? "null" : ""+result));
		return result;
	}
	
	private void setElementCheckBox( boolean firstTime, boolean value, CheckBox checkBox )
	{
	  if (( !firstTime ) && (!(checkBox.getChecked() == value )))	  
	  {
		checkBox.setThreeState( true );
		checkBox.setCheckState( CheckState.INDETERMINATE );
	  } else			
	  {
		checkBox.setThreeState( false );
	    checkBox.setChecked( value );
	  }
	}
	private boolean safeEquals( Object o1, Object o2 )
	{
		if ( o1 == o2 )
			return true;
		if ( o1 == null )
			return false;
		if ( o2 == null )
			return false;
		return o1.equals( o2 );
	}
	
	private void setElementComboBox( boolean firstTime, Object value, ComboBox comboBox )
	{
	  if (( !firstTime ) && (!(safeEquals(comboBox.getSelectedItem(), value) )))	  
	  {
		comboBox.setSelectedIndex( -1 );
	  } else			
	  {
		if ( firstTime ) 
  		  comboBox.setSelectedItem( value );
	  }
	}
	
	private void setElementNumber( boolean firstTime, double value, NumberEdit numberEdit )
	{
	  if (( ! firstTime ) && (!(numberEdit.getValue() == value)))
	    numberEdit.setText("");
	  else
	    numberEdit.setValue( value );		  
	}

	private void setElementNumber( boolean firstTime, double value, NumberComboBox numberEdit )
	{
	  if (( ! firstTime ) && (!(numberEdit.getValue() == value)))
	    numberEdit.setText("");
	  else
	    numberEdit.setValue( value );		  
	}
	
	private void setElementColor( boolean firstTime, Color value, Panel panel )
	{
	  if (( !firstTime ) && (!safeEquals(panel.getBackColor(),value)))
	  {
        panel.setBackColor(Color.LIGHTGRAY);
   	  } else	  
	  {
		if ( firstTime ) 
  	      panel.setBackColor(value);
	  }
	}
	
	private void setElementText( boolean firstTime, String value, Edit richEdit )
	{
	  if (( !firstTime ) && (!safeEquals(richEdit.getText(),value)))
	  {
        richEdit.setText("");
   	  } else	  
	  {
		if ( firstTime ) 
  	      richEdit.setText( value );
	  }
	}
	
	private void setElementRTF( boolean firstTime, String value, RichEdit richEdit )
	{
	  if (( !firstTime ) && (!safeEquals(richEdit.getText(),value)))
	  {
        richEdit.setText("");
   	  } else	  
	  {
		if ( firstTime ) 
  	      richEdit.setRTF(reportForm.getReport().formatExpression( value ));
	  }
	}
									   
	
	private void setReportElement(ReportElement[] re)
    {
	  for ( int i = 0; i < re.length; i++ )
	  {
 	    boolean firstTime = i == 0;
		setElementColor( firstTime, re[i].fgcolor, panel1 );
		setElementColor( firstTime, re[i].bgcolor, panel2 );
		
		// Calculate y relative...
  	    y_relative = reportForm.getReport().getBandYLocation(re[i].band);
	    double left = re[i].position.x-10- reportForm.getReport().leftMargin;		
		setElementNumber( firstTime, left, this.numberEditLeft);

  	    int top = re[i].position.y-y_relative-10;
		setElementNumber( firstTime, top, this.numberEditTop);
	  
		setElementNumber( firstTime, re[i].height, this.numberEditHeight);
		setElementNumber( firstTime, re[i].width, this.numberEditWidth);
		setElementComboBox( firstTime, re[i].band, this.comboBoxBands );
  	    setElementCheckBox( firstTime, re[i].mode.equalsIgnoreCase("Transparent"), this.checkBoxTransparent );
  	    setElementComboBox( firstTime, re[i].printWhenGroupChanges, this.comboBoxGroup );
  	    setElementComboBox( firstTime, re[i].positionType, this.comboBoxPositionType );
	  
		setElementRTF( firstTime, re[i].printWhenExpression, this.editPrintWhenExpression);
	    setElementCheckBox( firstTime, re[i].isPrintInFirstWholeBand, this.checkBoxPrintFirstWholeBand );
        setElementCheckBox( firstTime, re[i].isPrintWhenDetailOverflows, this.checkBoxPrintWhenDetailOverflow );
   	    setElementCheckBox( firstTime, re[i].isRemoveLineWhenBlank, this.checkBoxRemoveLineWhenBlank );
        setElementCheckBox( firstTime, re[i].isPrintRepeatedValues, this.checkBoxPrintRepeatedValues );
 	  }
	}

	private void setSubReportElement(SubReportElement sre)
	{
		tabControl1.add(tabPageSR1);
		tabControl1.add(tabPageSR2);
			
		//this.comboBoxSRConnection.setSelectedIndex(0);
		
		editParametersMapExpression.setText( sre.parametersMapExpression );
		//editSRConection.setText( (sre.useConnection) ? sre.connectionExpression : sre.dataSourceExpression );
			
			
		if (!sre.useConnection && sre.dataSourceExpression.length() == 0)
		{
			this.comboBoxSRConnection.setSelectedIndex(0);
			editSRConection.setEnabled(false);
			editSRConection.setBackColor( Color.INACTIVEBORDER);	
		}
		else if (sre.useConnection) 
		{
			editSRConection.setEnabled(true);
			editSRConection.setBackColor( Color.WINDOW );
			this.comboBoxSRConnection.setSelectedIndex(1);
			this.editSRConection.setText(sre.connectionExpression);
		}
		else
		{
			editSRConection.setEnabled(true);
			editSRConection.setBackColor( Color.WINDOW );
			this.comboBoxSRConnection.setSelectedIndex(2);
			this.editSRConection.setText(sre.dataSourceExpression);
		}

		checkBoxIsUsingCache.setChecked( sre.isUsingCache);
		comboBoxSRExpressionClass.setSelectedItem( sre.subreportExpressionClass);
		editSRExpression.setText(sre.subreportExpression);
			
		// Load properties...
		Enumeration enum = sre.subreportParameters.elements();
		listViewSRParameters.removeAllItems();
		while (enum.hasMoreElements())
		{
			JRParameter jp = (JRParameter)enum.nextElement();
			DataListItem dli = new DataListItem(jp,jp.name,0);
			dli.setSubItem(0,jp.classType);
			listViewSRParameters.addItem(dli);
		}	
	}
	
	private void setTextReportElement(ReportElement[] reportElement) 
	{
		for ( int i = 0; i < reportElement.length; i++ )
		{
			boolean firstTime = i == 0;
			TextReportElement tre = (TextReportElement)reportElement[i];
			setElementCheckBox( firstTime, tre.isPdfEmbedded, checkBoxIsPdfEmbedded );
			setElementNumber( firstTime, tre.size, numberComboBoxFontSize );
			setElementCheckBox( firstTime, tre.bold, checkBoxBold );
			setElementCheckBox( firstTime, tre.italic, checkBoxItalic );
			setElementCheckBox( firstTime, tre.underline, checkBoxUnderline );
			setElementCheckBox( firstTime, tre.stroke, checkBoxStrike );
			setElementText( firstTime, tre.text, editStaticText );
			setElementComboBox( firstTime, tre.pdfFontName, editFont );
		
		}
		String pdfEncoding = null ;
		for ( int i = 0; i < reportElement.length; i ++ )
		{
		  TextReportElement tre = (TextReportElement)reportElement[i];
		  if ( pdfEncoding == null )
		  {
			pdfEncoding = tre.pdfEncoding.toUpperCase();
		    continue;
		  }
		  if ( ! pdfEncoding.equals(tre.pdfEncoding.toUpperCase()) )
		  {
			  pdfEncoding = "";
			  break;
		  }		  			  
		}
		if ( pdfEncoding.equals("") )
		{
		  comboBoxPdfEncoding.setSelectedIndex(-1);
		} else
		{		
		  for (int i=0; i< comboBoxPdfEncoding.getItemCount(); ++i)
		  {
			if ( ((String)comboBoxPdfEncoding.getItem(i)).toUpperCase().startsWith( pdfEncoding ) )
			{
				comboBoxPdfEncoding.setSelectedIndex(i);
				break;
			}
		  }
		}
				
		String reportFont = null ;
		for ( int i = 0; i < reportElement.length; i ++ )
		{
		  TextReportElement tre = (TextReportElement)reportElement[i];
		  if ( reportFont == null )
		  {
			reportFont = ""+tre.reportFont;
		    continue;
		  }
		  if ( ! reportFont.equals(""+tre.reportFont) )
		  {
			  reportFont = "";
			  break;
		  }				
		}
		
		if ( reportFont.equals("") )
		{
		  comboBoxReportFonts.setSelectedIndex(-1);
		} else
		{
		  for (int fn=1; fn < comboBoxReportFonts.getItemCount(); ++fn)
		  { 
			if ( ((IFont)comboBoxReportFonts.getItem(fn)).name.equalsIgnoreCase(reportFont) )
			{
				comboBoxReportFonts.setSelectedIndex(fn);
				break;
			}
 		  } 
		}

		
		String fontName = null ;
		for ( int i = 0; i < reportElement.length; i ++ )
		{
		  TextReportElement tre = (TextReportElement)reportElement[i];
		  if ( fontName == null )
		  {
			fontName = ""+tre.fontName;
		    continue;
		  }
		  if ( ! fontName.equals(""+tre.fontName) )
		  {
			  fontName = "";
			  break;
		  }				
		}		

		if (fontName.equals("External TTF font") ||editFont.getSelectedIndex()<=0 )
		{
			for (int fn=1; fn < comboBoxTTF.getItemCount(); ++fn)
			{
				if ( ((FontFile)comboBoxTTF.getItem(fn)).filename.equalsIgnoreCase(""+fontName) )
				{
					comboBoxTTF.setSelectedIndex(fn);
					break;
				}
			}
		}	
	}

	private void setStaticTextReportElement(ReportElement[] reportElement)
	{
		tabControl1.add(tabPageStaticText);
		tabControl1.add(tabPageTextProperties);
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  StaticTextReportElement stre = (StaticTextReportElement)reportElement[i];
		  boolean firstTime = i == 0; 	
		  setElementText( firstTime, stre.text, editStaticText );
		  setElementComboBox(firstTime, stre.lineSpacing, comboBoxLineSpacing );
		  setElementComboBox(firstTime, stre.align, comboBoxAlign );
		  setElementComboBox(firstTime, stre.verticalAlignment, comboBoxVerticalAlign );
		}
	}

	private void setTextFieldReportElement( ReportElement[] reportElement )
	{
		tabControl1.add(tabPageTextField);
		tabControl1.add(tabPageTextProperties);
		tabControl1.add(tabPageHL);
		
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  boolean firstTime = i == 0; 	
		  TextFieldReportElement tfre = (TextFieldReportElement) reportElement[i];
		  setElementText( firstTime, (tfre.font == null ? "" : ""+tfre.font), editStaticText );
		  setElementText( firstTime, tfre.text, editTextFieldExpression );
		  
		  setElementComboBox( firstTime, tfre.fieldClass, comboBoxExpressionClass ); 
		  setElementComboBox( firstTime, tfre.evaluationTime, comboBoxTextTime ); 
		  setElementComboBox( firstTime, tfre.lineSpacing, comboBoxLineSpacing ); 
		  setElementComboBox( firstTime, tfre.align, comboBoxAlign ); 
		  setElementComboBox( firstTime, tfre.verticalAlignment, comboBoxVerticalAlign ); 
			
		  setElementComboBox( firstTime, tfre.hyperlinkType, comboBoxImgLinkType ); 

		  setElementText( firstTime, tfre.hyperlinkAnchorExpression, editImgHyperAnchorExpression );
		  setElementText( firstTime, tfre.hyperlinkPageExpression, editImgHyperPageExpression );
		  setElementText( firstTime, tfre.hyperlinkReferenceExpression, editImgHyperReferenceExpression );
		  setElementText( firstTime, tfre.anchorNameExpression, editAnchorNameExpression );

		  setElementCheckBox( firstTime, tfre.isBlankWhenNull, checkBoxIsBlankWhenNull );
		  setElementCheckBox( firstTime, tfre.isStretchWithOverflow, checkBoxIsStretchWithOverflow );
		
		  setElementText( firstTime, tfre.pattern, editPattern );
		  setElementComboBox( firstTime, tfre.evaluationGroup, comboBoxTextFieldEvalGroup );
		}
	}
	
	private void setGraphicReportElement( ReportElement[] reportElement )
	{
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  boolean firstTime = i == 0; 	
		  GraphicReportElement gre = (GraphicReportElement) reportElement[i];
		  setElementComboBox( firstTime, gre.graphicElementPen, comboBoxPen );
		  setElementComboBox( firstTime, gre.fill, comboBoxFill );
		  setElementComboBox( firstTime, gre.stretchType, comboBoxStretchType );
		}
	}
	
	private void setRectangleReportElement( ReportElement[] reportElement )
	{
	  tabControl1.add(tabPageGraphicElement);
	  tabControl1.add(tabPageRectangle);

	  for ( int i = 0; i < reportElement.length; i++ )
	  {
	    boolean firstTime = i == 0; 	
	    RectangleReportElement rre = (RectangleReportElement) reportElement[i];
		setElementComboBox( firstTime, rre.graphicElementPen, comboBoxPen );
		setElementNumber( firstTime, rre.radius, numberEditRadius );
	  }
	}
	
	private void setImageReportElement(ReportElement[] reportElement)
	{
  	  tabControl1.add(tabPageImage);
	  tabControl1.add(tabPageGraphicElement);

	  for ( int i = 0; i < reportElement.length; i++ )
	  {
	    boolean firstTime = i == 0; 	
	    ImageReportElement ire = (ImageReportElement) reportElement[i];

		setElementText( firstTime, ire.imageExpression, editImageExpression );

		setElementComboBox( firstTime, ire.imageClass, comboBoxImageClass );
		
		setElementComboBox( firstTime, ire.scaleImage, comboBoxScaleImage );
		setElementCheckBox( firstTime, ire.isUsingCache, checkBoxUsingCache );
		setElementComboBox( firstTime, ire.graphicElementPen, comboBoxPen );
		setElementComboBox( firstTime, ire.evaluationGroup, comboBoxImgEvalGroup );
		setElementComboBox( firstTime, ire.evaluationTime, comboBoxImgEvalTime );

		setElementComboBox( firstTime, ire.hyperlinkType, comboBoxImgLinkType );
			
		// TODO check this
	    if (ire.evaluationTime.equals("Group"))
	    {
	  	  this.comboBoxImgEvalGroup.setEnabled(true);
	  	  this.comboBoxImgEvalGroup.setBackColor(Color.WINDOW);
	    } else
	    {
	      ire.evaluationGroup ="";
		  comboBoxImgEvalGroup.setSelectedItem("");
		  this.comboBoxImgEvalGroup.setEnabled(false);
		  this.comboBoxImgEvalGroup.setBackColor(Color.INACTIVEBORDER);
	    }
		// ENDTODO check this

		setElementText( firstTime, ire.hyperlinkAnchorExpression, editImgHyperAnchorExpression );
		setElementText( firstTime, ire.hyperlinkPageExpression, editImgHyperPageExpression );
		setElementText( firstTime, ire.hyperlinkReferenceExpression, editImgHyperReferenceExpression );
		setElementText( firstTime, ire.anchorNameExpression, editAnchorNameExpression );
		
	  }
	  tabControl1.add(tabPageHL);
	}
	/**
	 * ElementProperties esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}




	private void panel1_click(Object source, Event e)
	{
		ColorDialog cd = new ColorDialog();
		cd.setColor(forecolor);
		if (cd.showDialog() == DialogResult.OK)
		{
			forecolor = cd.getColor();
			panel1.setBackColor(forecolor);
			for ( int i = 0; i < reportElement.length; i++ )
			{
			  reportElement[i].fgcolor = forecolor;
			  reportForm.updateElement(reportElement[i],null);
			}
		}
	}

	private void panel2_click(Object source, Event e)
	{
		ColorDialog cd = new ColorDialog();
		cd.setColor(backcolor);
		if (cd.showDialog() == DialogResult.OK)
		{
			backcolor = cd.getColor();
			panel2.setBackColor(backcolor);
			
			for ( int i = 0; i < reportElement.length; i++ )
			{
			  reportElement[i].bgcolor = backcolor;
			  reportForm.updateElement(reportElement[i],null);
			}
		}
	}


	private Rectangle createOldRect( ReportElement reportElement )
	{
		return new Rectangle(reportElement.position.x-5,reportElement.position.y-5,reportElement.width+10, reportElement.height+10);
	}

	private void comboBoxBands_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  reportElement[i].band =  (Band)comboBoxBands.getSelectedItem();
		  // recalculate top coord
		  y_relative = reportForm.getReport().getBandYLocation(reportElement[i].band);
		  Rectangle rect = createOldRect(reportElement[i]);
		  reportElement[i].trasform(new Point(0 ,(reportElement[i].position.y-y_relative-10)+y_relative+10-reportElement[i].position.y),
						  	        TransformationType.TRANSFORMATION_MOVE);
		  setElementNumber( i == 0, reportElement[i].position.y-y_relative-10, numberEditTop );
		}
		reportForm.refreshAll();
	}

	private void numberEditTop_valueChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
 		  Rectangle rect = createOldRect(reportElement[i]);
		  reportElement[i].trasform(new Point(0 ,(int)numberEditTop.getValue()+y_relative+10-reportElement[i].position.y),
							        TransformationType.TRANSFORMATION_MOVE); 
		}
		reportForm.refreshAll();
	}

	private void buttonSelectFont_click(Object source, Event e)
	{

	}

	private void editStaticText_textChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  if (reportElement[i] instanceof StaticTextReportElement) // is this needed ?
		  {	
		    ((StaticTextReportElement)reportElement[i]).text=  editStaticText.getText();	
		    reportForm.updateElement(reportElement[i],null);
		  }
		}
	}

	private void comboBoxAlign_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  if (reportElement[i] instanceof TextReportElement)
		  {	
				((TextReportElement)reportElement[i]).align=  (String)comboBoxAlign.getSelectedItem();	
		  }
		  reportForm.updateElement(reportElement[i],null);
		}
	}

	private void comboBoxLineSpacing_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  if (reportElement[i] instanceof StaticTextReportElement)
		  {	
				((StaticTextReportElement)reportElement[i]).lineSpacing=  (String)comboBoxLineSpacing.getSelectedItem();	
		  }
		  reportForm.updateElement(reportElement[i],null);
		}
	}

	private void editImageExpression_textChanged(Object source, Event e)
	{
        if ( init ) 
			return;
//		if (reportElement[0] instanceof ImageReportElement)
		{	
              if ( ! init ) 
			    for ( int i = 0; i < reportElement.length; i++ )
		        {
				  ((ImageReportElement)reportElement[i]).imageExpression  =  (String)editImageExpression.getText();
				}
				try {
					String fname = editImageExpression.getText();
					if (fname.length()>0 && fname.charAt(0)=='\"' &&
						 fname.charAt(fname.length()-1 ) == '\"')
					{
						// Could be a file...
						fname = string_replace("\\","\\\\",fname);
						fname = string_replace("","\"",fname);
					}
					if (com.ms.wfc.io.File.exists(fname))
					{
						Bitmap bmp = new Bitmap(fname);
						if (bmp != null)
						{
			              for ( int i = 0; i < reportElement.length; i++ )
		                  {
							((ImageReportElement)reportElement[i]).img  =  bmp;		
							((ImageReportElement)reportElement[i]).imageClass = "java.lang.String";
						  }
  						  comboBoxImageClass.setSelectedItem("java.lang.String");
						}
					}
					else
						((ImageReportElement)reportElement[0]).img  = null;
					reportForm.updateElement(reportElement[0],null);
				} catch (Exception ex) {}
		}
		if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editImageExpression.getSelectionStart();
		editImageExpression.setRTF(reportForm.getReport().formatExpression( editImageExpression.getText()));
		editImageExpression.setSelectionStart(pos);
		//reportForm.updateElement(reportElement[0],null);
	}

	private void comboBoxImageClass_selectedIndexChanged(Object source, Event e)
	{
		if ( init )
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  if (reportElement[i] instanceof ImageReportElement)
		  {	
				((ImageReportElement)reportElement[i]).imageClass  =  (String)comboBoxImageClass.getSelectedItem();		
		  }
		}
													 
	}

	private void comboBoxScaleImage_selectedIndexChanged(Object source, Event e)
	{
		if ( init )
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  if (reportElement[i] instanceof ImageReportElement)
		  {	
				((ImageReportElement)reportElement[i]).scaleImage  =  (String)comboBoxScaleImage.getSelectedItem();		
		  }
		  reportForm.updateElement(reportElement[i],null);
		}
	}

	private void checkBoxUsingCache_click(Object source, Event e)
	{
		if ( init )
			return;
		checkBoxUsingCache.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  if (reportElement[i] instanceof ImageReportElement)
		  {	
				((ImageReportElement)reportElement[i]).isUsingCache  =  checkBoxUsingCache.getChecked();		
		  }
		}
	}

	private void button1_click(Object source, Event e)
	{
		OpenFileDialog ofd = new OpenFileDialog();
		ofd.setFilter("Jpeg (*.jpg)|*.jpg|Gif (*.gif)|*.gif|Bitmap (*.bmp)|*.bmp|All files (*.*)|*.*");
		ofd.setDefaultExt("jpg");
		if (ofd.showDialog() == DialogResult.OK)
		{
			String filename = ofd.getFileName();
			editImageExpression.setText( filename );
			((ImageReportElement)reportElement[0]).imageExpression = string_replace("\\\\","\\", filename) ; 
			try {
				Bitmap bmp = new Bitmap(filename);
				if (bmp != null)
				{
					for ( int i = 0; i < reportElement.length; i++ )
					{
					  if (reportElement[i] instanceof ImageReportElement)
					  {	
						((ImageReportElement)reportElement[i]).img  =  bmp;		
						((ImageReportElement)reportElement[i]).imageClass = "java.lang.String";
						comboBoxImageClass.setSelectedItem("java.lang.String");
						reportForm.updateElement(reportElement[i],null);
					  }
					}
				}
			} catch (Exception ex) {}
			
		}
	}
	
public static String string_replace(String s1, String s2, String s3)
 {
	   String string="";
	   string = "";

    	if (s2 == null || s3 == null || s2.length() == 0) return s3;
	   
	   int pos_i = 0; // posizione corrente.
	   int pos_f = 0; // posizione corrente finale
	   
	   int len = s2.length();
	   while ( (pos_f = s3.indexOf(s2, pos_i)) >= 0)
	   {
		   string += s3.substring(pos_i,pos_f)+s1;
		   //+string.substring(pos+ s2.length());
		   pos_f = pos_i = pos_f + len;

	   }

	   string += s3.substring(pos_i);

	   return string;
    }

    private void comboBoxPen_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
			if (reportElement[i] instanceof ImageReportElement)
			{	
					((ImageReportElement)reportElement[i]).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
			}
			else if (reportElement[i] instanceof RectangleReportElement)
			{	
					((RectangleReportElement)reportElement[i]).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
			}
			else if (reportElement[i] instanceof LineReportElement)
			{	
					((LineReportElement)reportElement[i]).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
			}
			else if (reportElement[i] instanceof EllipseReportElement)
			{	
					((EllipseReportElement)reportElement[i]).graphicElementPen  =  (String)comboBoxPen.getSelectedItem(); 		
			}
			reportForm.updateElement(reportElement[i],null);
		}
	}


	private void comboBoxDirection_selectedIndexChanged(Object source, Event e)
	{
      if ( init ) 
		return;
	  for ( int i = 0; i < reportElement.length; i++ )
	  {
		if (reportElement[i] instanceof LineReportElement)
		{	
				((LineReportElement)reportElement[i]).direction  =  (String)comboBoxDirection.getSelectedItem(); 		
		}
		reportForm.updateElement(reportElement[i],null);
	  }
	}

	private void checkBoxTransparent_click(Object source, Event e)
	{
      if ( init ) 
		return;
		checkBoxTransparent.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  reportElement[i].mode = (checkBoxTransparent.getChecked()) ? "Transparent" : "Opaque";
		  reportForm.updateElement(reportElement[i],null);
		}
	}

	private void label18_click(Object source, Event e)
	{
		
	}

	private void comboBoxTextTime_selectedIndexChanged(Object source, Event e)
	{
      if ( init ) 
		return;
		
		if (((String)comboBoxTextTime.getSelectedItem()).equals("Group"))
		{
			this.comboBoxTextFieldEvalGroup.setEnabled(true);
			this.comboBoxTextFieldEvalGroup.setBackColor(Color.WINDOW);
		}
		else
		{
		    for ( int i = 0; i < reportElement.length; i++ )
		    {
			  ((TextFieldReportElement)reportElement[i]).evaluationGroup ="";
			}
			comboBoxTextFieldEvalGroup.setSelectedItem("");
			this.comboBoxTextFieldEvalGroup.setEnabled(false);
			this.comboBoxTextFieldEvalGroup.setBackColor(Color.INACTIVEBORDER);
		}
	    for ( int i = 0; i < reportElement.length; i++ )
	    {
	  	  ((TextFieldReportElement)reportElement[i]).evaluationTime  =  (String)comboBoxTextTime.getSelectedItem() ; 		
		}
	}

	private void editTextFieldExpression_textChanged(Object source, Event e)
	{
      if ( init ) 
		return;
//		if (reportElement[0] instanceof TextFieldReportElement)
		{	
		  for ( int i = 0; i < reportElement.length; i++ )
		  {
			((TextFieldReportElement)reportElement[i]).text  =  (String)editTextFieldExpression.getText(); 		
		    reportForm.updateElement(reportElement[i],null);
		  }
		}
		if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editTextFieldExpression.getSelectionStart();
		editTextFieldExpression.setRTF(reportForm.getReport().formatExpression( editTextFieldExpression.getText()));
		editTextFieldExpression.setSelectionStart(pos);
			
	}

	private void comboBoxExpressionClass_selectedIndexChanged(Object source, Event e)
	{
      if ( init ) 
		return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  ((TextFieldReportElement)reportElement[i]).fieldClass =  (String)comboBoxExpressionClass.getSelectedItem() ; 		
		}
	}

	private void tabPageTextProperties_paint(Object source, PaintEvent e)
	{
		
	}

	private void editFont_leave(Object source, Event e)
	{
  	  
	  String pdfFont =  (String)this.editFont.getSelectedItem();
	  updatePdfFont(pdfFont);	

	  if (pdfFont.equals("External TTF font"))
	  {
		this.comboBoxTTF.setEnabled(true);
		this.comboBoxTTF.setBackColor(Color.WINDOW);
	  }
	  else
	  {
		this.comboBoxTTF.setSelectedIndex(0);
		this.comboBoxTTF.setEnabled(false);
		this.comboBoxTTF.setBackColor(Color.INACTIVEBORDER);
	  }
	  
	  checkBoxBold.setThreeState( false );
	  checkBoxItalic.setThreeState( false );
	  checkBoxUnderline.setThreeState( false );
	  checkBoxStrike.setThreeState( false );
	  
	  for ( int i = 0; i < reportElement.length; i++ )
	  {
		if (reportElement[i] instanceof TextReportElement)
		{	
				TextReportElement re = (TextReportElement)reportElement[i];
				re.bold = checkBoxBold.getChecked();
				re.italic = checkBoxItalic.getChecked();
				re.underline = checkBoxUnderline.getChecked();
				re.stroke = checkBoxStrike.getChecked();
				if (!pdfFont.equals("External TTF font"))
				{
 			      re.fontName = "";
				}
				re.pdfFontName = (String)editFont.getSelectedItem();
				re.size = (int)numberComboBoxFontSize.getValue();
				re.font = null;
		  reportForm.updateElement(reportElement[i],null);
		}
		
	  }
	}


	public void updatePdfFont(String pdfFont)
	{
		if (pdfFont.startsWith("Courier") && checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Courier-BoldOblique";
		else if (pdfFont.startsWith("Courier") && !checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Courier-Bold"; 
		else if (pdfFont.startsWith("Courier") && checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Courier-Oblique";
		else if (pdfFont.startsWith("Courier") && !checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Courier";
		
		else if (pdfFont.startsWith("Helvetica") && checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Helvetica-BoldOblique";
		else if (pdfFont.startsWith("Helvetica") && !checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Helvetica-Bold"; 
		else if (pdfFont.startsWith("Helvetica") && checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Helvetica-Oblique";
		else if (pdfFont.startsWith("Helvetica") && !checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Helvetica";
		
		else if (pdfFont.startsWith("Times") && checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Times-BoldItalic";
		else if (pdfFont.startsWith("Times") && !checkBoxItalic.getChecked() && checkBoxBold.getChecked())
				pdfFont = "Times-Bold"; 
		else if (pdfFont.startsWith("Times") && checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Times-Italic";
		else if (pdfFont.startsWith("Times") && !checkBoxItalic.getChecked() && !checkBoxBold.getChecked())
				pdfFont = "Times-Roman";
		
		editFont.setSelectedItem(pdfFont);
	}

	private void listView1_click(Object source, Event e)
	{
		if (listViewSRParameters.getSelectedItems().length > 0)
		{
			menuItem2.setEnabled( true);
			menuItem3.setEnabled( true);
		}
		else
		{
			menuItem2.setEnabled( false);
			menuItem3.setEnabled( false);
		}
		
	}

	private void editSRExpression_textChanged(Object source, Event e)
	{
		if (reportElement[0] instanceof SubReportElement)
		{	
			SubReportElement re = (SubReportElement)reportElement[0];
			re.subreportExpression = editSRExpression.getText();
			if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
				 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
			{	
				return;
			}
			int pos = editSRExpression.getSelectionStart();
			editSRExpression.setRTF(reportForm.getReport().formatExpression( editSRExpression.getText()));
			editSRExpression.setSelectionStart(pos);
			if ( Utils.isAStringClass( re.subreportExpressionClass ) && (!Utils.isAnExpression ( re.subreportExpression ) ))
			{
				btnOpenSubReport.setEnabled( true );				
			} else
			{
				btnOpenSubReport.setEnabled( false );				
			}
		}
	}

	private void editParametersMapExpression_textChanged(Object source, Event e)
	{
		if (reportElement[0] instanceof SubReportElement)
		{	
				SubReportElement re = (SubReportElement)reportElement[0];
				re.parametersMapExpression = editParametersMapExpression.getText();
				if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
					 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
				{
					return;
				}
				int pos = editParametersMapExpression.getSelectionStart();
				editParametersMapExpression.setRTF(reportForm.getReport().formatExpression( editParametersMapExpression.getText()));
				editParametersMapExpression.setSelectionStart(pos);
		}
	}

	private void checkBoxIsUsingCache_click(Object source, Event e)
	{
		if (reportElement[0] instanceof SubReportElement)
		{	
				SubReportElement re = (SubReportElement)reportElement[0];
				re.isUsingCache = checkBoxIsUsingCache.getChecked();
		}
	}

	private void comboBoxSRExpressionClass_selectedIndexChanged(Object source, Event e)
	{
		
		if (reportElement[0] instanceof SubReportElement)
		{	
			SubReportElement re = (SubReportElement)reportElement[0];
			re.subreportExpressionClass  = comboBoxSRExpressionClass.getSelectedItem()+"";
			if ( Utils.isAStringClass(re.subreportExpressionClass) )
			{
			  btnOpenSubReport.setVisible(true);
			  comboBoxSRExpressionClass.setWidth( 240 );				 
			} else
			{
			  btnOpenSubReport.setVisible(false);
			  comboBoxSRExpressionClass.setWidth( 280 );
			}
		}
	}

	private void comboBoxSRConnection_selectedIndexChanged(Object source, Event e)
	{
		if (reportElement[0] instanceof SubReportElement)
		{	
				SubReportElement re = (SubReportElement)reportElement[0];
				if ( comboBoxSRConnection.getSelectedIndex() == 0)
				{
					re.connectionExpression = "";
					re.dataSourceExpression = "";
					re.useConnection = false;
					editSRConection.setEnabled(false);
					editSRConection.setBackColor( Color.INACTIVEBORDER);
				}
				else if ( comboBoxSRConnection.getSelectedIndex() == 1)
				{
					editSRConection.setEnabled(true);
					editSRConection.setBackColor( Color.WINDOW);
					re.dataSourceExpression="";
					re.useConnection = true;
					editSRConection.setText(re.connectionExpression); 	
				}
				else if ( comboBoxSRConnection.getSelectedIndex() == 2)
				{
					editSRConection.setEnabled(true);
					re.useConnection = false;
					editSRConection.setBackColor( Color.WINDOW);					re.connectionExpression="";
					editSRConection.setText(re.dataSourceExpression);
				}
		}
	}

	private void listViewSRParameters_keyDown(Object source, KeyEvent e)
	{
		if (e.getKeyCode() == Key.DELETE)
		{
			SubReportElement re = (SubReportElement)reportElement[0];
			while (listViewSRParameters.getSelectedItems().length > 0)
			{
				DataListItem dli = (DataListItem)(listViewSRParameters.getSelectedItems()[0]);
				JRParameter p = (JRParameter)dli.getData();
				re.subreportParameters.removeElement(p);
				listViewSRParameters.removeItem(dli);
			}
		}
	}

	private void menuItem1_click(Object source, Event e)
	{
		SRParamForm pf = new SRParamForm(this.reportForm.getReport(), "","");
		if (pf.showDialog() == DialogResult.OK)
		{
			JRParameter p = new JRParameter( pf.name,pf.expression);
			SubReportElement re = (SubReportElement)reportElement[0];
			re.subreportParameters.addElement(p);
			DataListItem dli = new DataListItem(p,p.name,0);
			dli.setSubItem(0,p.classType);
			listViewSRParameters.addItem(dli);
		}
	}

	private void menuItem3_click(Object source, Event e)
	{
		SubReportElement re = (SubReportElement)reportElement[0];
		if (listViewSRParameters.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewSRParameters.getSelectedItems()[0]);
			JRParameter p = (JRParameter)dli.getData();
			SRParamForm pf = new SRParamForm(this.reportForm.getReport(), p.name , p.classType);
			if (pf.showDialog() == DialogResult.OK)
			{
				p.name = pf.name;
				p.classType = pf.expression;
				dli.setText(p.name);
				dli.setSubItem(0,p.classType);
			}
		}
	}

	private void menuItem2_click(Object source, Event e)
	{
		SubReportElement re = (SubReportElement)reportElement[0];
		while (listViewSRParameters.getSelectedItems().length > 0)
		{
			DataListItem dli = (DataListItem)(listViewSRParameters.getSelectedItems()[0]);
			JRParameter p = (JRParameter)dli.getData();
			re.subreportParameters.removeElement(p);
			listViewSRParameters.removeItem(dli);
		}
	}

	private void listViewSRParameters_doubleClick(Object source, Event e)
	{
		menuItem3_click(source, e);
	}

	private void numberEditLeft_valueChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  Rectangle rect = createOldRect(reportElement[i]);
		  reportElement[i].trasform(new Point((int)numberEditLeft.getValue()+ reportForm.getReport().leftMargin +10-reportElement[i].position.x,0),
							   TransformationType.TRANSFORMATION_MOVE); 
		}
		reportForm.refreshAll();
	}

	private void numberEditWidth_valueChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  Rectangle rect = createOldRect(reportElement[i]);
		  reportElement[i].trasform(new Point((int)numberEditWidth.getValue()-reportElement[i].width,0), TransformationType.TRANSFORMATION_RESIZE_E); 
		}
		reportForm.refreshAll();
	}

	private void numberEditHeight_valueChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
  		  Rectangle rect = createOldRect(reportElement[i]);
		  reportElement[i].trasform(new Point(0,(int)numberEditHeight.getValue()-reportElement[i].height  ), TransformationType.TRANSFORMATION_RESIZE_S); 
		}
		reportForm.refreshAll();
	}

	private void checkBoxRemoveLineWhenBlank_click(Object source, Event e)
	{
		checkBoxRemoveLineWhenBlank.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
 		  reportElement[i].isRemoveLineWhenBlank = checkBoxRemoveLineWhenBlank.getChecked();
		}
	}

	private void checkBoxPrintFirstWholeBand_click(Object source, Event e)
	{
		checkBoxPrintFirstWholeBand.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  reportElement[i].isPrintInFirstWholeBand = checkBoxPrintFirstWholeBand.getChecked();
		}
	}

	private void checkBoxPrintWhenDetailOverflow_click(Object source, Event e)
	{
		checkBoxPrintWhenDetailOverflow.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
 		  reportElement[i].isPrintWhenDetailOverflows = checkBoxPrintWhenDetailOverflow.getChecked();
		}
	}

	private void comboBoxPositionType_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
  		  reportElement[i].positionType = ""+comboBoxPositionType.getSelectedItem();
		}
	}

	private void comboBoxGroup_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  reportElement[i].printWhenGroupChanges = ""+comboBoxGroup.getSelectedItem();
		}
	}

	private void editPrintWhenExpression_textChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  reportElement[i].printWhenExpression = editPrintWhenExpression.getText();
		}
		if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
			 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
		{
			return;
		}
		int pos = editPrintWhenExpression.getSelectionStart();
		editPrintWhenExpression.setRTF(reportForm.getReport().formatExpression( editPrintWhenExpression.getText()));
		editPrintWhenExpression.setSelectionStart(pos);
	}


	
	public void setFonts(Vector fonts)
	{
		Enumeration enum = fonts.elements();
		comboBoxTTF.addItem("");
		while (enum.hasMoreElements())
		{
			FontFile f = (FontFile)enum.nextElement();
			comboBoxTTF.addItem(f);
		}
	}

	private void comboBoxTTF_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		if (comboBoxTTF.getSelectedIndex()>0)
		{
			FontFile f = (FontFile)comboBoxTTF.getSelectedItem();
		    for ( int i = 0; i < reportElement.length; i++ )
		    { 
		      ((TextReportElement)reportElement[i]).setFontFile(f.filename );
			  ((TextReportElement)reportElement[i]).font = null;
			  reportForm.updateElement(reportElement[i],null);
			}
		}
	}


	private void checkBoxIsPdfEmbedded_click(Object source, Event e)
	{
		if ( init ) 
			return;
		checkBoxIsPdfEmbedded.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{		
		  ((TextReportElement)reportElement[i]).isPdfEmbedded =checkBoxIsPdfEmbedded.getChecked();
		}
	}

	private void comboBoxPdfEncoding_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{		
  		  String enc = (String)comboBoxPdfEncoding.getSelectedItem();
		  ((TextReportElement)reportElement[i]).pdfEncoding = enc.substring(0,enc.indexOf(" "));
		}
	}

	private void checkBoxPrintRepeatedValues_click(Object source, Event e)
	{
		if ( init ) 
			return;
		checkBoxPrintRepeatedValues.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  reportElement[i].isPrintRepeatedValues = checkBoxPrintRepeatedValues.getChecked(); 
		}
	}

	private void comboBoxFill_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
  		  ((GraphicReportElement)reportElement[i]).fill = (String)comboBoxFill.getSelectedItem();
		}
	}

	private void comboBoxStretchType_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  ((GraphicReportElement)reportElement[i]).stretchType = (String)comboBoxStretchType.getSelectedItem();
		}
	}



	private void comboBoxImgEvalTime_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
		if (((String)comboBoxImgEvalTime.getSelectedItem()).equals("Group"))
		{
			this.comboBoxImgEvalGroup.setEnabled(true);
			this.comboBoxImgEvalGroup.setBackColor(Color.WINDOW);
		}
		else
		{
		    for ( int i = 0; i < reportElement.length; i++ )
		    {
			  ((ImageReportElement)reportElement[i]).evaluationGroup ="";
			}
			comboBoxImgEvalGroup.setSelectedItem("");
			this.comboBoxImgEvalGroup.setEnabled(false);
			this.comboBoxImgEvalGroup.setBackColor(Color.INACTIVEBORDER);
		}
	    for ( int i = 0; i < reportElement.length; i++ )
	    {
	 	  ((ImageReportElement)reportElement[i]).evaluationTime = (String)comboBoxImgEvalTime.getSelectedItem();
		}
	}

	private void comboBoxImgEvalGroup_selectedIndexChanged(Object source, Event e)
	{
		if ( init ) 
			return;
	    for ( int i = 0; i < reportElement.length; i++ )
	    {
		  ((ImageReportElement)reportElement[i]).evaluationGroup = (String)comboBoxImgEvalGroup.getSelectedItem();
		}
	}

	private void comboBoxImgLinkType_selectedIndexChanged(Object source, Event e)
	{
		if ( ! init ) 
	    for ( int i = 0; i < reportElement.length; i++ )
	    {
		  if (reportElement[i] instanceof ImageReportElement)
		  {
			((ImageReportElement)reportElement[i]).hyperlinkType = (String)comboBoxImgLinkType.getSelectedItem();					
		  }
		  else if (reportElement[i] instanceof TextFieldReportElement )
		  {
			((TextFieldReportElement)reportElement[i]).hyperlinkType = (String)comboBoxImgLinkType.getSelectedItem();			
		  }
		}
		
		if ((comboBoxImgLinkType.getSelectedItem() == null ) || (((String)comboBoxImgLinkType.getSelectedItem()).equals("None")))
		{
				this.editImgHyperAnchorExpression.setEnabled(false);
				this.editImgHyperAnchorExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperPageExpression.setEnabled(false);
				this.editImgHyperPageExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperReferenceExpression.setEnabled(false);
				this.editImgHyperReferenceExpression.setBackColor(Color.INACTIVEBORDER);
				this.labelHL2.setEnabled(false);
				this.labelHL3.setEnabled(false);
				this.labelHL1.setEnabled(false);
		}
		else if (((String)comboBoxImgLinkType.getSelectedItem()).equals("Reference"))
		{
				this.editImgHyperAnchorExpression.setEnabled(false);
				this.editImgHyperAnchorExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperPageExpression.setEnabled(false);
				this.editImgHyperPageExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperReferenceExpression.setEnabled(true);
				this.editImgHyperReferenceExpression.setBackColor(Color.WINDOW);
				this.labelHL2.setEnabled(false);
				this.labelHL3.setEnabled(false);
				this.labelHL1.setEnabled(true);
		}
		else if (((String)comboBoxImgLinkType.getSelectedItem()).equals("LocalAnchor"))
		{
				this.editImgHyperAnchorExpression.setEnabled(true);
				this.editImgHyperAnchorExpression.setBackColor(Color.WINDOW);
				this.editImgHyperPageExpression.setEnabled(false);
				this.editImgHyperPageExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperReferenceExpression.setEnabled(false);
				this.editImgHyperReferenceExpression.setBackColor(Color.INACTIVEBORDER);
				this.labelHL2.setEnabled(true);
				this.labelHL3.setEnabled(false);
				this.labelHL1.setEnabled(false);
		}
		else if (((String)comboBoxImgLinkType.getSelectedItem()).equals("LocalPage"))
		{
				this.editImgHyperAnchorExpression.setEnabled(false);
				this.editImgHyperAnchorExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperPageExpression.setEnabled(true);
				this.editImgHyperPageExpression.setBackColor(Color.WINDOW);
				this.editImgHyperReferenceExpression.setEnabled(false);
				this.editImgHyperReferenceExpression.setBackColor(Color.INACTIVEBORDER);
				this.labelHL2.setEnabled(false);
				this.labelHL3.setEnabled(true);
				this.labelHL1.setEnabled(false);
		}
		else if (((String)comboBoxImgLinkType.getSelectedItem()).equals("RemoteAnchor"))
		{
				this.editImgHyperAnchorExpression.setEnabled(true);
				this.editImgHyperAnchorExpression.setBackColor(Color.WINDOW);
				this.editImgHyperPageExpression.setEnabled(false);
				this.editImgHyperPageExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperReferenceExpression.setEnabled(true);
				this.editImgHyperReferenceExpression.setBackColor(Color.WINDOW);
				this.labelHL2.setEnabled(true);
				this.labelHL3.setEnabled(false);
				this.labelHL1.setEnabled(true);
		}
		else if (((String)comboBoxImgLinkType.getSelectedItem()).equals("RemotePage"))
		{
				this.editImgHyperAnchorExpression.setEnabled(false);
				this.editImgHyperAnchorExpression.setBackColor(Color.INACTIVEBORDER);
				this.editImgHyperPageExpression.setEnabled(true);
				this.editImgHyperPageExpression.setBackColor(Color.WINDOW);
				this.editImgHyperReferenceExpression.setEnabled(true);
				this.editImgHyperReferenceExpression.setBackColor(Color.WINDOW);
				this.labelHL2.setEnabled(false);
				this.labelHL3.setEnabled(true);
				this.labelHL1.setEnabled(true);
		}
	}


	private void editAnchorNameExpression_textChanged(Object source, Event e)
	{
      if ( init ) 
		return;
      for ( int i = 0; i < reportElement.length; i++ )
	  {
		if (reportElement[i] instanceof ImageReportElement )
		{
			ImageReportElement ire = (ImageReportElement)reportElement[i];
			ire.anchorNameExpression = editAnchorNameExpression.getText();
		}
		else if (reportElement[i] instanceof TextFieldReportElement  )
		{
			TextFieldReportElement tfre = (TextFieldReportElement)reportElement[i];
			tfre.anchorNameExpression = editAnchorNameExpression.getText();
		}
	  }
	  if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
		 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
	  {
	    return;
	  }
	  int pos = editAnchorNameExpression.getSelectionStart();
	  editAnchorNameExpression.setRTF(reportForm.getReport().formatExpression( editAnchorNameExpression.getText()));
	  editAnchorNameExpression.setSelectionStart(pos);
	}

	private void editImgHyperReferenceExpression_textChanged(Object source, Event e)
	{
      if ( init ) 
		return;
      for ( int i = 0; i < reportElement.length; i++ )
	  {
		if (reportElement[i] instanceof ImageReportElement )
		{
			ImageReportElement ire = (ImageReportElement)reportElement[i];
			ire.hyperlinkReferenceExpression = editImgHyperReferenceExpression.getText();
		}
		else if (reportElement[i] instanceof TextFieldReportElement  )
		{
			TextFieldReportElement tfre = (TextFieldReportElement)reportElement[i];
			tfre.hyperlinkReferenceExpression = editImgHyperReferenceExpression.getText();
		}
	  }
	  if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
		 ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
	  {
	 	return;
	  }
	  int pos = editImgHyperReferenceExpression.getSelectionStart();
	  editImgHyperReferenceExpression.setRTF(reportForm.getReport().formatExpression( editImgHyperReferenceExpression.getText()));
	  editImgHyperReferenceExpression.setSelectionStart(pos);
	}

	private void editImgHyperAnchorExpression_textChanged(Object source, Event e)
	{
      if ( init ) 
		return;
      for ( int i = 0; i < reportElement.length; i++ )
	  {
		if (reportElement[i] instanceof ImageReportElement )
		{
			ImageReportElement ire = (ImageReportElement)reportElement[i];
			ire.hyperlinkAnchorExpression  = editImgHyperAnchorExpression.getText();
		}
		else if (reportElement[i] instanceof TextFieldReportElement  )
		{
			TextFieldReportElement tfre = (TextFieldReportElement)reportElement[i];
			tfre.hyperlinkAnchorExpression = editImgHyperAnchorExpression.getText();
		}
	  }
	  if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
	   	   ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
	  {
	 	return;
	  }
	  int pos = editImgHyperAnchorExpression.getSelectionStart();
	  editImgHyperAnchorExpression.setRTF(reportForm.getReport().formatExpression( editImgHyperAnchorExpression.getText()));
	  editImgHyperAnchorExpression.setSelectionStart(pos);
	}

	private void editImgHyperPageExpression_textChanged(Object source, Event e)
	{
      if ( init ) 
		return;
      for ( int i = 0; i < reportElement.length; i++ )
	  {
		if (reportElement[i] instanceof ImageReportElement )
		{
			ImageReportElement ire = (ImageReportElement)reportElement[i];
			ire.hyperlinkPageExpression  = editImgHyperPageExpression.getText();
		}
		else if (reportElement[i] instanceof TextFieldReportElement  )
		{
			TextFieldReportElement tfre = (TextFieldReportElement)reportElement[i];
			tfre.hyperlinkPageExpression = editImgHyperPageExpression.getText();
		}
	  }
  	  if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
	  	   ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
	  {
	 	return;
	  }  
	  int pos = editImgHyperPageExpression.getSelectionStart();
	  editImgHyperPageExpression.setRTF(reportForm.getReport().formatExpression( editImgHyperPageExpression.getText()));
	  editImgHyperPageExpression.setSelectionStart(pos);
	}

	private void comboBoxTextFieldEvalGroup_selectedIndexChanged(Object source, Event e)
	{
      if ( init ) 
		return;
	    for ( int i = 0; i < reportElement.length; i++ )
	    {
	  	  ((TextFieldReportElement)reportElement[i]).evaluationGroup = (String)comboBoxTextFieldEvalGroup.getSelectedItem();
		}
	}

	private void checkBoxIsStretchWithOverflow_click(Object source, Event e)
	{
      if ( init ) 
		return;
	  checkBoxIsStretchWithOverflow.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
  		  ((TextFieldReportElement)reportElement[i]).isStretchWithOverflow = checkBoxIsStretchWithOverflow.getChecked();
		}
	}



	private void editPattern_textChanged(Object source, Event e)
	{
      if ( init ) 
		return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  ((TextFieldReportElement)reportElement[i]).pattern = editPattern.getText();
		}
	}

	private void checkBoxIsBlankWhenNull_click(Object source, Event e)
	{
      if ( init ) 
		return;
	  checkBoxIsBlankWhenNull.setThreeState( false );
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  ((TextFieldReportElement)reportElement[i]).isBlankWhenNull = checkBoxIsBlankWhenNull.getChecked();
		}
	}

	private void comboBoxReportFonts_selectedIndexChanged(Object source, Event e)
	{
      if ( init ) 
		return;
		if (comboBoxReportFonts.getSelectedIndex()>0)
		{
			TextReportElement tre = (TextReportElement)reportElement[0];
			IFont font = (IFont)comboBoxReportFonts.getSelectedItem();
			if (tre.reportFont == font.name) return;
			tre.reportFont = font.name;
			tre.size = font.size;
			tre.bold = font.isBold;
			tre.fontName = font.fontName;
			tre.pdfFontName = font.pdfFontName;
			tre.isPdfEmbedded = font.isPdfEmbedded;
			tre.italic = font.isItalic;
			tre.pdfEncoding = font.pdfEncoding;
			tre.stroke = font.isStrikeThrough;
			tre.underline = font.isUnderline;
			
			checkBoxIsPdfEmbedded.setChecked( tre.isPdfEmbedded);
			for (int i=0; i< comboBoxPdfEncoding.getItemCount(); ++i)
			{
				if ( ((String)comboBoxPdfEncoding.getItem(i)).toUpperCase().startsWith( tre.pdfEncoding.toUpperCase()))
				{
					comboBoxPdfEncoding.setSelectedIndex(i);
					break;
				}
			}
			
			numberComboBoxFontSize.setValue( tre.size);
			checkBoxBold.setChecked( tre.bold);
			checkBoxItalic.setChecked( tre.italic);
			checkBoxUnderline.setChecked( tre.underline);
			checkBoxStrike.setChecked( tre.stroke);
			editStaticText.setText(tre.text);
			String s=  (String)editFont.getSelectedItem();
			editFont.setSelectedItem(tre.pdfFontName);
			if (!s.equalsIgnoreCase( tre.pdfFontName) && s.equals((String)editFont.getSelectedItem()))
			{
				editFont.setSelectedIndex(0);
			}
			
			if (tre.pdfFontName.equals("External TTF font") ||editFont.getSelectedIndex()<=0 ||((String)editFont.getSelectedItem()).equals("External TTF font") )
			{
				for (int fn=1; fn < comboBoxTTF.getItemCount(); ++fn)
				{
					if ( ((FontFile)comboBoxTTF.getItem(fn)).filename.equalsIgnoreCase(""+tre.fontName) )
					{
						comboBoxTTF.setSelectedIndex(fn);
						break;
					}
					if ( ((FontFile)comboBoxTTF.getItem(fn)).fontname.equalsIgnoreCase(""+tre.fontName) )
					{
						comboBoxTTF.setSelectedIndex(fn);
						break;
					}
				}
			}
			
		}
		reportForm.updateElement(reportElement[0],null);
	}

	private void editPrintWhenExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editPrintWhenExpression, new Point(e.x,e.y));
	}

	private void menuItem4_click(Object source, Event e)
	{
		source = this.getActiveControl();
		if (source instanceof RichEdit)
		{
			ExpressionGeneratorForm ef = new ExpressionGeneratorForm(this.reportForm.getReport() );
			ef.setExpression(((RichEdit)source).getText());
			if (ef.showDialog() == DialogResult.OK)
			{
				((RichEdit)source).setRTF(this.reportForm.getReport().formatExpression(ef.getExpression()));
			}
		}
	}

	private void editImageExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editImageExpression, new Point(e.x,e.y));
	}

	private void editTextFieldExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editTextFieldExpression, new Point(e.x,e.y));
	}

	private void editParametersMapExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editParametersMapExpression, new Point(e.x,e.y));
	}

	private void editSRConection_textChanged(Object source, Event e)
	{
		if (reportElement[0] instanceof SubReportElement)
		{	
				SubReportElement re = (SubReportElement)reportElement[0];
				if ( comboBoxSRConnection.getSelectedIndex() == 1)
				{
					editSRConection.setEnabled(true);
					editSRConection.setBackColor( Color.WINDOW);
					re.dataSourceExpression="";
					re.connectionExpression = editSRConection.getText();
					
				}
				else if ( comboBoxSRConnection.getSelectedIndex() == 2)
				{
					editSRConection.setEnabled(true);
					editSRConection.setBackColor( Color.WINDOW);
					re.connectionExpression="";
					re.dataSourceExpression = editSRConection.getText();
				}
				if ( ((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING")!=null &&
					((MainForm)this.reportForm.getMDIParent()).ireportProperties.getProperty("SYNTAX_HIGHLIGHTING").equalsIgnoreCase("false"))
				{
					return;
				}
				int pos = editSRConection.getSelectionStart();
				editSRConection.setRTF(reportForm.getReport().formatExpression( editSRConection.getText()));
				editSRConection.setSelectionStart(pos);
		}
	}

	private void editSRExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editSRExpression, new Point(e.x,e.y));
	}

	private void editAnchorNameExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editAnchorNameExpression, new Point(e.x,e.y));
	}

	private void editImgHyperReferenceExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editImgHyperReferenceExpression, new Point(e.x,e.y));
	}

	private void editImgHyperAnchorExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editImgHyperAnchorExpression, new Point(e.x,e.y));
	}

	private void editImgHyperPageExpression_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editImgHyperPageExpression, new Point(e.x,e.y));
	}

	private void editSRConection_mouseUp(Object source, MouseEvent e)
	{
		if (e.button == MouseButton.RIGHT)
			this.contextMenu2.show(editSRConection, new Point(e.x,e.y));
	}

	private void ElementProperties_deactivate(Object source, Event e)
	{
		if (this.reportForm != null)
		this.reportForm.focus();
	}

	private void ElementProperties_closing(Object source, CancelEvent e)
	{
		if (this.reportForm != null)
		this.reportForm.focus();
	}

	private void numberEditRadius_valueChanged(Object source, Event e)
	{
      if ( init ) 
		return;
		for ( int i = 0; i < reportElement.length; i++ )
		{
		  Rectangle rect = createOldRect(reportElement[i]);
		  ((RectangleReportElement)reportElement[i]).radius = (int)numberEditRadius.getValue(); 
		  reportForm.refreshAll();
		}					 
	}

	private void comboBoxVerticalAlign_selectedIndexChanged(Object source, Event e)
	{
      if ( init ) 
		return;
		for ( int i = 0; i < reportElement.length; i++ )
		{		
		  if (reportElement[i] instanceof TextReportElement)
		  {	
				((TextReportElement)reportElement[i]).verticalAlignment=  (String)comboBoxVerticalAlign.getSelectedItem();	
		  }
		  reportForm.updateElement(reportElement[i],null);
		}
	}


	private void tabControl1_selectedIndexChanged(Object source, Event e)
	{
		if (( reportElement != null ) && (reportElement.length != 0) )
		{
			TabPage page = tabControl1.getSelectedTab();
		    lastSelectedPage = page.getText();				
		}
	}

	private void btnOpenSubReport_click(Object source, Event e)
	{
		MainForm mf = (MainForm)reportForm.getMDIParent();
		SubReportElement re = (SubReportElement)reportElement[0];
		String fileName = editSRExpression.getText().trim();
		if ( fileName.startsWith("\"") )
		  fileName = fileName.substring( 1 );						 
		if ( fileName.endsWith("\"") )
		  fileName = fileName.substring( 0, fileName.length() - 1 );						 
		if ( fileName.endsWith(".jasper") )
		  fileName = fileName.substring( 0, fileName.indexOf(".jasper") );
		fileName += ".xml";
		if ( com.ms.wfc.io.File.exists( fileName ) )
		{
		  if ( com.ms.wfc.io.File.getDirectory(fileName).equals("") )
		  { 
			  fileName = com.ms.wfc.io.File.getCurrentDirectory() + "\\" +  fileName;
		  }
 		  mf.openDocument( fileName );	
		  return;
		}
		if ( reportForm.getReport().filename == null )
		{
		  MessageBox.show("You need to save this report first, to resolve the local directory !","", MessageBox.ICONERROR );
		  return;
		}
		fileName = com.ms.wfc.io.File.getDirectory(reportForm.getReport().filename) + "\\" + fileName;
 	    mf.openDocument( fileName );	
			 
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	TabControl tabControl1 = new TabControl();
	TabPage tabPage1 = new TabPage();
	ComboBox comboBoxBands = new ComboBox();
	Label label1 = new Label();
	NumberEdit numberEditTop = new NumberEdit();
	Label label7 = new Label();
	NumberEdit numberEditWidth = new NumberEdit();
	Label label6 = new Label();
	NumberEdit numberEditLeft = new NumberEdit();
	Label label4 = new Label();
	NumberEdit numberEditHeight = new NumberEdit();
	Label label5 = new Label();
	CheckBox checkBoxTransparent = new CheckBox();
	Panel panel1 = new Panel();
	Label label3 = new Label();
	Label label2 = new Label();
	Panel panel2 = new Panel();
	ToolTip toolTip1 = new ToolTip(components);
	TabPage tabPageStaticText = new TabPage();
	Edit editStaticText = new Edit();
	Label label9 = new Label();
	TabPage tabPageTextProperties = new TabPage();
	Label label10 = new Label();
	ComboBox editFont = new ComboBox();
	NumberComboBox numberComboBoxFontSize = new NumberComboBox();
	Label label11 = new Label();
	ComboBox comboBoxAlign = new ComboBox();
	Label label12 = new Label();
	ComboBox comboBoxLineSpacing = new ComboBox();
	TabPage tabPageImage = new TabPage();
	RichEdit editImageExpression = new RichEdit();
	Label label13 = new Label();
	Label label14 = new Label();
	ComboBox comboBoxImageClass = new ComboBox();
	Button button1 = new Button();
	Label label15 = new Label();
	ComboBox comboBoxScaleImage = new ComboBox();
	CheckBox checkBoxUsingCache = new CheckBox();
	TabPage tabPageGraphicElement = new TabPage();
	Label label16 = new Label();
	ComboBox comboBoxPen = new ComboBox();
	TabPage tabPageLine = new TabPage();
	Label label17 = new Label();
	ComboBox comboBoxDirection = new ComboBox();
	TabPage tabPageTextField = new TabPage();
	Label label18 = new Label();
	ComboBox comboBoxTextTime = new ComboBox();
	Label label19 = new Label();
	RichEdit editTextFieldExpression = new RichEdit();
	ComboBox comboBoxExpressionClass = new ComboBox();
	Label label20 = new Label();
	CheckBox checkBoxBold = new CheckBox();
	CheckBox checkBoxItalic = new CheckBox();
	CheckBox checkBoxUnderline = new CheckBox();
	CheckBox checkBoxStrike = new CheckBox();
	ComboBox comboBoxTTF = new ComboBox();
	TabPage tabPageSR1 = new TabPage();
	TabPage tabPageSR2 = new TabPage();
	RichEdit editParametersMapExpression = new RichEdit();
	Label label21 = new Label();
	ColumnHeader columnHeader2 = new ColumnHeader();
	ColumnHeader columnHeader1 = new ColumnHeader();
	Label label22 = new Label();
	ListView listViewSRParameters = new ListView();
	ContextMenu contextMenu1 = new ContextMenu();
	MenuItem menuItem1 = new MenuItem();
	MenuItem menuItem2 = new MenuItem();
	RichEdit editSRConection = new RichEdit();
	Label label23 = new Label();
	RichEdit editSRExpression = new RichEdit();
	ComboBox comboBoxSRConnection = new ComboBox();
	Label label24 = new Label();
	CheckBox checkBoxIsUsingCache = new CheckBox();
	ComboBox comboBoxSRExpressionClass = new ComboBox();
	MenuItem menuItem3 = new MenuItem();
	CheckBox checkBoxPrintWhenDetailOverflow = new CheckBox();
	CheckBox checkBoxPrintFirstWholeBand = new CheckBox();
	Label label8 = new Label();
	CheckBox checkBoxRemoveLineWhenBlank = new CheckBox();
	Label label27 = new Label();
	ComboBox comboBoxPositionType = new ComboBox();
	GroupBox groupBox1 = new GroupBox();
	ComboBox comboBoxGroup = new ComboBox();
	RichEdit editPrintWhenExpression = new RichEdit();
	Label label25 = new Label();
	Label label26 = new Label();
	Label label28 = new Label();
	CheckBox checkBoxIsPdfEmbedded = new CheckBox();
	GroupBox groupBox2 = new GroupBox();
	Label label29 = new Label();
	ComboBox comboBoxPdfEncoding = new ComboBox();
	CheckBox checkBoxPrintRepeatedValues = new CheckBox();
	Label label30 = new Label();
	ComboBox comboBoxImgEvalGroup = new ComboBox();
	ComboBox comboBoxImgEvalTime = new ComboBox();
	ComboBox comboBoxImgLinkType = new ComboBox();
	Label label32 = new Label();
	Label label31 = new Label();
	TabPage tabPageHL = new TabPage();
	Label label33 = new Label();
	ComboBox comboBoxFill = new ComboBox();
	Label label34 = new Label();
	ComboBox comboBoxStretchType = new ComboBox();
	GroupBox groupBox3 = new GroupBox();
	RichEdit editAnchorNameExpression = new RichEdit();
	Label label36 = new Label();
	RichEdit editImgHyperReferenceExpression = new RichEdit();
	Label labelHL1 = new Label();
	RichEdit editImgHyperAnchorExpression = new RichEdit();
	Label labelHL2 = new Label();
	GroupBox groupBox4 = new GroupBox();
	Label labelHL3 = new Label();
	RichEdit editImgHyperPageExpression = new RichEdit();
	Edit editPattern = new Edit();
	ComboBox comboBoxTextFieldEvalGroup = new ComboBox();
	CheckBox checkBoxIsStretchWithOverflow = new CheckBox();
	Label label37 = new Label();
	CheckBox checkBoxIsBlankWhenNull = new CheckBox();
	Label label35 = new Label();
	ComboBox comboBoxReportFonts = new ComboBox();
	Label label38 = new Label();
	ContextMenu contextMenu2 = new ContextMenu();
	MenuItem menuItem4 = new MenuItem();
	TabPage tabPageRectangle = new TabPage();
	Label label39 = new Label();
	NumberEdit numberEditRadius = new NumberEdit();
	GroupBox groupBox5 = new GroupBox();
	Label label40 = new Label();
	ComboBox comboBoxVerticalAlign = new ComboBox();
	Button btnOpenSubReport = new Button();

	private void initForm()
	{
		// REMARQUE: cette feuille stocke des informations sur les ressources
		// dans un fichier externe. Ne modifiez le paramtre de chane d'aucun
		// appel de fonction resources.getObject(). Par exemple,
		// ne modifiez pas "foo1_location" dans la ligne de code
		// suivante, mme si le nom de l'objet Foo change: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "ElementProperties");
		this.setText("Element properties");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_DIALOG);
		this.setClientSize(new Point(304, 305));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.setShowInTaskbar(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);
		this.addOnDeactivate(new EventHandler(this.ElementProperties_deactivate));
		this.addOnClosing(new CancelEventHandler(this.ElementProperties_closing));

		tabControl1.setDock(ControlDock.FILL);
		tabControl1.setSize(new Point(304, 305));
		tabControl1.setTabIndex(0);
		tabControl1.setText("tabControl1");
		tabControl1.setSelectedIndex(2);
		tabControl1.addOnSelectedIndexChanged(new EventHandler(this.tabControl1_selectedIndexChanged));

		tabPage1.setLocation(new Point(4, 25));
		tabPage1.setSize(new Point(296, 276));
		tabPage1.setTabIndex(0);
		tabPage1.setText("Common");

		comboBoxBands.setLocation(new Point(44, 8));
		comboBoxBands.setSize(new Point(244, 21));
		comboBoxBands.setTabIndex(0);
		comboBoxBands.setText("");
		comboBoxBands.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxBands.addOnSelectedIndexChanged(new EventHandler(this.comboBoxBands_selectedIndexChanged));

		label1.setLocation(new Point(4, 12));
		label1.setSize(new Point(36, 12));
		label1.setTabIndex(19);
		label1.setTabStop(false);
		label1.setText("Band");
		label1.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditTop.setLocation(new Point(44, 36));
		numberEditTop.setSize(new Point(40, 20));
		numberEditTop.setTabIndex(2);
		numberEditTop.setText("0");
		numberEditTop.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditTop.setIsDouble(false);
		numberEditTop.setDecimals(0);
		numberEditTop.setValue(0.0d);
		numberEditTop.setViewPlus(false);
		numberEditTop.setSeparatoreMigliaia(true);
		numberEditTop.addOnValueChanged(new EventHandler(this.numberEditTop_valueChanged));

		label7.setLocation(new Point(188, 40));
		label7.setSize(new Point(56, 16));
		label7.setTabIndex(18);
		label7.setTabStop(false);
		label7.setText("Forecolor");
		label7.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditWidth.setLocation(new Point(132, 36));
		numberEditWidth.setSize(new Point(40, 20));
		numberEditWidth.setTabIndex(3);
		numberEditWidth.setText("0");
		numberEditWidth.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditWidth.setIsDouble(false);
		numberEditWidth.setDecimals(0);
		numberEditWidth.setValue(0.0d);
		numberEditWidth.setViewPlus(false);
		numberEditWidth.setSeparatoreMigliaia(true);
		numberEditWidth.addOnValueChanged(new EventHandler(this.numberEditWidth_valueChanged));

		label6.setLocation(new Point(188, 64));
		label6.setSize(new Point(56, 16));
		label6.setTabIndex(25);
		label6.setTabStop(false);
		label6.setText("Backcolor");
		label6.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditLeft.setLocation(new Point(44, 60));
		numberEditLeft.setSize(new Point(40, 20));
		numberEditLeft.setTabIndex(4);
		numberEditLeft.setText("0");
		numberEditLeft.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditLeft.setIsDouble(false);
		numberEditLeft.setDecimals(0);
		numberEditLeft.setValue(0.0d);
		numberEditLeft.setViewPlus(false);
		numberEditLeft.setSeparatoreMigliaia(true);
		numberEditLeft.addOnValueChanged(new EventHandler(this.numberEditLeft_valueChanged));

		label4.setLocation(new Point(88, 40));
		label4.setSize(new Point(40, 16));
		label4.setTabIndex(24);
		label4.setTabStop(false);
		label4.setText("Width");
		label4.setTextAlign(HorizontalAlignment.RIGHT);

		numberEditHeight.setLocation(new Point(132, 60));
		numberEditHeight.setSize(new Point(40, 20));
		numberEditHeight.setTabIndex(5);
		numberEditHeight.setText("0");
		numberEditHeight.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditHeight.setIsDouble(false);
		numberEditHeight.setDecimals(0);
		numberEditHeight.setValue(0.0d);
		numberEditHeight.setViewPlus(false);
		numberEditHeight.setSeparatoreMigliaia(true);
		numberEditHeight.addOnValueChanged(new EventHandler(this.numberEditHeight_valueChanged));

		label5.setLocation(new Point(88, 60));
		label5.setSize(new Point(40, 16));
		label5.setTabIndex(23);
		label5.setTabStop(false);
		label5.setText("Height");
		label5.setTextAlign(HorizontalAlignment.RIGHT);

		checkBoxTransparent.setLocation(new Point(4, 96));
		checkBoxTransparent.setSize(new Point(88, 16));
		checkBoxTransparent.setTabIndex(6);
		checkBoxTransparent.setText("Transparent");
		checkBoxTransparent.addOnClick(new EventHandler(this.checkBoxTransparent_click));

		panel1.setBackColor(Color.WINDOWTEXT);
		panel1.setLocation(new Point(248, 36));
		panel1.setSize(new Point(40, 20));
		panel1.setTabIndex(1);
		panel1.setText("panel1");
		panel1.setBorderStyle(BorderStyle.FIXED_3D);
		panel1.addOnClick(new EventHandler(this.panel1_click));

		label3.setLocation(new Point(4, 64));
		label3.setSize(new Point(32, 16));
		label3.setTabIndex(21);
		label3.setTabStop(false);
		label3.setText("Left");
		label3.setTextAlign(HorizontalAlignment.RIGHT);

		label2.setLocation(new Point(4, 40));
		label2.setSize(new Point(32, 16));
		label2.setTabIndex(22);
		label2.setTabStop(false);
		label2.setText("Top");
		label2.setTextAlign(HorizontalAlignment.RIGHT);

		panel2.setBackColor(Color.INFO);
		panel2.setLocation(new Point(248, 60));
		panel2.setSize(new Point(40, 20));
		panel2.setTabIndex(20);
		panel2.setText("panel1");
		panel2.setBorderStyle(BorderStyle.FIXED_3D);
		panel2.addOnClick(new EventHandler(this.panel2_click));

		toolTip1.setActivate(true);
		/* @designTimeOnly toolTip1.setLocation(new Point(116, 100)); */

		tabPageStaticText.setLocation(new Point(4, 25));
		tabPageStaticText.setSize(new Point(296, 276));
		tabPageStaticText.setTabIndex(1);
		tabPageStaticText.setText("Static Text");

		editStaticText.setLocation(new Point(4, 25));
		editStaticText.setSize(new Point(288, 244));
		editStaticText.setTabIndex(1);
		editStaticText.setText("");
		editStaticText.setMultiline(true);
		editStaticText.addOnTextChanged(new EventHandler(this.editStaticText_textChanged));

		label9.setLocation(new Point(4, 8));
		label9.setSize(new Point(68, 16));
		label9.setTabIndex(0);
		label9.setTabStop(false);
		label9.setText("Text");

		tabPageTextProperties.setLocation(new Point(4, 25));
		tabPageTextProperties.setSize(new Point(296, 276));
		tabPageTextProperties.setTabIndex(2);
		tabPageTextProperties.setText("Text properties");
		tabPageTextProperties.addOnPaint(new PaintEventHandler(this.tabPageTextProperties_paint));

		label10.setLocation(new Point(8, 44));
		label10.setSize(new Point(100, 16));
		label10.setTabIndex(21);
		label10.setTabStop(false);
		label10.setText("PDF Font name");

		editFont.setLocation(new Point(8, 60));
		editFont.setSize(new Point(224, 21));
		editFont.setTabIndex(2);
		editFont.setText("");
		editFont.setStyle(ComboBoxStyle.DROPDOWNLIST);
		editFont.setItems(new Object[] {
						  "Helvetica", 
						  "Helvetica-Bold", 
						  "Helvetica-BoldOblique", 
						  "Helvetica-Oblique", 
						  "Courier", 
						  "Courier-Bold", 
						  "Courier-BoldOblique", 
						  "Courier-Oblique", 
						  "Symbol", 
						  "Times-Roman", 
						  "Times-Bold", 
						  "Times-BoldItalic", 
						  "Times-Italic", 
						  "ZapfDingbats", 
						  "STSong-Light", 
						  "MHei-Medium", 
						  "MSung-Light", 
						  "HeiseiKakuGo-W5", 
						  "HeiseiMin-W3", 
						  "HYGoThic-Medium", 
						  "HYSMyeongJo-Medium", 
						  "External TTF font"});
		editFont.addOnLeave(new EventHandler(this.editFont_leave));
		editFont.addOnSelectedIndexChanged(new EventHandler(this.editFont_leave));

		numberComboBoxFontSize.setCursor(Cursor.DEFAULT);
		numberComboBoxFontSize.setLocation(new Point(236, 60));
		numberComboBoxFontSize.setSize(new Point(52, 21));
		numberComboBoxFontSize.setTabIndex(3);
		numberComboBoxFontSize.setText("0");
		numberComboBoxFontSize.setIsDouble(false);
		numberComboBoxFontSize.setDecimals(0);
		numberComboBoxFontSize.setValue(0.0d);
		numberComboBoxFontSize.setViewPlus(false);
		numberComboBoxFontSize.setSeparatoreMigliaia(false);
		numberComboBoxFontSize.addOnLeave(new EventHandler(this.editFont_leave));
		numberComboBoxFontSize.addOnValueChanged(new EventHandler(this.editFont_leave));

		label11.setLocation(new Point(108, 172));
		label11.setSize(new Point(100, 16));
		label11.setTabIndex(20);
		label11.setTabStop(false);
		label11.setText("Align");

		comboBoxAlign.setLocation(new Point(108, 188));
		comboBoxAlign.setSize(new Point(88, 21));
		comboBoxAlign.setTabIndex(10);
		comboBoxAlign.setText("");
		comboBoxAlign.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxAlign.setItems(new Object[] {
							   "Left", 
							   "Right", 
							   "Center", 
							   "Justified"});
		comboBoxAlign.addOnSelectedIndexChanged(new EventHandler(this.comboBoxAlign_selectedIndexChanged));

		label12.setLocation(new Point(108, 128));
		label12.setSize(new Point(100, 16));
		label12.setTabIndex(18);
		label12.setTabStop(false);
		label12.setText("Line spacing");

		comboBoxLineSpacing.setLocation(new Point(108, 144));
		comboBoxLineSpacing.setSize(new Point(180, 21));
		comboBoxLineSpacing.setTabIndex(9);
		comboBoxLineSpacing.setText("");
		comboBoxLineSpacing.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxLineSpacing.setItems(new Object[] {
									 "Single", 
									 "1_1_2", 
									 "Double"});
		comboBoxLineSpacing.addOnSelectedIndexChanged(new EventHandler(this.comboBoxLineSpacing_selectedIndexChanged));

		tabPageImage.setLocation(new Point(4, 25));
		tabPageImage.setSize(new Point(296, 276));
		tabPageImage.setTabIndex(3);
		tabPageImage.setText("Image properties");

		editImageExpression.setFont(Font.DEFAULT_GUI);
		editImageExpression.setForeColor(Color.WINDOWTEXT);
		editImageExpression.setLocation(new Point(8, 24));
		editImageExpression.setSize(new Point(204, 20));
		editImageExpression.setTabIndex(1);
		editImageExpression.setText("");
		editImageExpression.addOnMouseUp(new MouseEventHandler(this.editImageExpression_mouseUp));
		editImageExpression.addOnTextChanged(new EventHandler(this.editImageExpression_textChanged));

		label13.setLocation(new Point(8, 8));
		label13.setSize(new Point(88, 16));
		label13.setTabIndex(12);
		label13.setTabStop(false);
		label13.setText("Image expression");

		label14.setLocation(new Point(8, 48));
		label14.setSize(new Point(128, 16));
		label14.setTabIndex(11);
		label14.setTabStop(false);
		label14.setText("Image expression class");

		comboBoxImageClass.setLocation(new Point(8, 64));
		comboBoxImageClass.setSize(new Point(280, 21));
		comboBoxImageClass.setTabIndex(3);
		comboBoxImageClass.setText("");
		comboBoxImageClass.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxImageClass.setItems(new Object[] {
									"java.lang.String", 
									"java.io.File", 
									"java.net.URL", 
									"java.io.InputStream", 
									"java.awt.Image"});
		comboBoxImageClass.addOnSelectedIndexChanged(new EventHandler(this.comboBoxImageClass_selectedIndexChanged));

		button1.setLocation(new Point(216, 20));
		button1.setSize(new Point(72, 24));
		button1.setTabIndex(2);
		button1.setText("Find...");
		button1.addOnClick(new EventHandler(this.button1_click));

		label15.setLocation(new Point(8, 88));
		label15.setSize(new Point(128, 16));
		label15.setTabIndex(10);
		label15.setTabStop(false);
		label15.setText("Scale image");

		comboBoxScaleImage.setLocation(new Point(8, 104));
		comboBoxScaleImage.setSize(new Point(172, 21));
		comboBoxScaleImage.setTabIndex(4);
		comboBoxScaleImage.setText("");
		comboBoxScaleImage.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxScaleImage.setItems(new Object[] {
									"Clip", 
									"FillFrame", 
									"RetainShape"});
		comboBoxScaleImage.addOnSelectedIndexChanged(new EventHandler(this.comboBoxScaleImage_selectedIndexChanged));

		checkBoxUsingCache.setLocation(new Point(200, 96));
		checkBoxUsingCache.setSize(new Point(88, 23));
		checkBoxUsingCache.setTabIndex(5);
		checkBoxUsingCache.setText("Using chache");
		checkBoxUsingCache.addOnClick(new EventHandler(this.checkBoxUsingCache_click));

		tabPageGraphicElement.setLocation(new Point(4, 25));
		tabPageGraphicElement.setSize(new Point(296, 276));
		tabPageGraphicElement.setTabIndex(4);
		tabPageGraphicElement.setText("Graphics Element");

		label16.setLocation(new Point(8, 8));
		label16.setSize(new Point(72, 16));
		label16.setTabIndex(5);
		label16.setTabStop(false);
		label16.setText("Pen");

		comboBoxPen.setLocation(new Point(8, 24));
		comboBoxPen.setSize(new Point(284, 21));
		comboBoxPen.setTabIndex(0);
		comboBoxPen.setText("");
		comboBoxPen.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxPen.setItems(new Object[] {
							 "None", 
							 "Thin", 
							 "1Point", 
							 "2Point", 
							 "4Point", 
							 "Dotted"});
		comboBoxPen.addOnSelectedIndexChanged(new EventHandler(this.comboBoxPen_selectedIndexChanged));

		tabPageLine.setLocation(new Point(4, 25));
		tabPageLine.setSize(new Point(296, 276));
		tabPageLine.setTabIndex(5);
		tabPageLine.setText("Line");

		label17.setLocation(new Point(8, 8));
		label17.setSize(new Point(72, 16));
		label17.setTabIndex(0);
		label17.setTabStop(false);
		label17.setText("Line direction");

		comboBoxDirection.setLocation(new Point(8, 24));
		comboBoxDirection.setSize(new Point(284, 21));
		comboBoxDirection.setTabIndex(1);
		comboBoxDirection.setText("");
		comboBoxDirection.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxDirection.setItems(new Object[] {
								   "TopDown", 
								   "BottomUp"});
		comboBoxDirection.addOnSelectedIndexChanged(new EventHandler(this.comboBoxDirection_selectedIndexChanged));

		tabPageTextField.setLocation(new Point(4, 25));
		tabPageTextField.setSize(new Point(296, 276));
		tabPageTextField.setTabIndex(6);
		tabPageTextField.setText("Text Field");

		label18.setLocation(new Point(8, 48));
		label18.setSize(new Point(136, 12));
		label18.setTabIndex(11);
		label18.setTabStop(false);
		label18.setText("Evaluation time");
		label18.addOnClick(new EventHandler(this.label18_click));

		comboBoxTextTime.setLocation(new Point(8, 64));
		comboBoxTextTime.setSize(new Point(128, 21));
		comboBoxTextTime.setTabIndex(2);
		comboBoxTextTime.setText("");
		comboBoxTextTime.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxTextTime.setItems(new Object[] {
								  "Now", 
								  "Report", 
								  "Page", 
								  "Column", 
								  "Group"});
		comboBoxTextTime.addOnSelectedIndexChanged(new EventHandler(this.comboBoxTextTime_selectedIndexChanged));

		label19.setLocation(new Point(8, 152));
		label19.setSize(new Point(144, 16));
		label19.setTabIndex(10);
		label19.setTabStop(false);
		label19.setText("Textfield Expression");

		editTextFieldExpression.setFont(Font.DEFAULT_GUI);
		editTextFieldExpression.setForeColor(Color.WINDOWTEXT);
		editTextFieldExpression.setLocation(new Point(8, 168));
		editTextFieldExpression.setSize(new Point(276, 104));
		editTextFieldExpression.setTabIndex(7);
		editTextFieldExpression.setText("");
		editTextFieldExpression.addOnMouseUp(new MouseEventHandler(this.editTextFieldExpression_mouseUp));
		editTextFieldExpression.addOnTextChanged(new EventHandler(this.editTextFieldExpression_textChanged));

		comboBoxExpressionClass.setLocation(new Point(8, 24));
		comboBoxExpressionClass.setSize(new Point(276, 21));
		comboBoxExpressionClass.setTabIndex(1);
		comboBoxExpressionClass.setText("");
		comboBoxExpressionClass.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxExpressionClass.setItems(new Object[] {
										 "", 
										 "java.lang.Boolean", 
										 "java.lang.Byte", 
										 "java.util.Date", 
										 "java.sql.Timestamp", 
										 "java.lang.Double", 
										 "java.lang.Float", 
										 "java.lang.Integer", 
										 "java.lang.Long", 
										 "java.lang.Short", 
										 "java.math.BigDecimal", 
										 "java.lang.String"});
		comboBoxExpressionClass.addOnSelectedIndexChanged(new EventHandler(this.comboBoxExpressionClass_selectedIndexChanged));

		label20.setLocation(new Point(8, 8));
		label20.setSize(new Point(136, 12));
		label20.setTabIndex(9);
		label20.setTabStop(false);
		label20.setText("Expression Class");
		label20.addOnClick(new EventHandler(this.label18_click));

		checkBoxBold.setLocation(new Point(12, 132));
		checkBoxBold.setSize(new Point(48, 20));
		checkBoxBold.setTabIndex(5);
		checkBoxBold.setText("Bold");
		checkBoxBold.addOnClick(new EventHandler(this.editFont_leave));

		checkBoxItalic.setLocation(new Point(12, 152));
		checkBoxItalic.setSize(new Point(52, 20));
		checkBoxItalic.setTabIndex(6);
		checkBoxItalic.setText("Italic");
		checkBoxItalic.addOnClick(new EventHandler(this.editFont_leave));

		checkBoxUnderline.setLocation(new Point(12, 172));
		checkBoxUnderline.setSize(new Point(68, 20));
		checkBoxUnderline.setTabIndex(7);
		checkBoxUnderline.setText("Underline");
		checkBoxUnderline.addOnClick(new EventHandler(this.editFont_leave));

		checkBoxStrike.setLocation(new Point(12, 192));
		checkBoxStrike.setSize(new Point(92, 20));
		checkBoxStrike.setTabIndex(8);
		checkBoxStrike.setText("Strike Through");
		checkBoxStrike.addOnClick(new EventHandler(this.editFont_leave));

		comboBoxTTF.setLocation(new Point(8, 100));
		comboBoxTTF.setSize(new Point(280, 21));
		comboBoxTTF.setTabIndex(4);
		comboBoxTTF.setText("");
		comboBoxTTF.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxTTF.addOnSelectedIndexChanged(new EventHandler(this.comboBoxTTF_selectedIndexChanged));

		tabPageSR1.setLocation(new Point(4, 25));
		tabPageSR1.setSize(new Point(296, 276));
		tabPageSR1.setTabIndex(7);
		tabPageSR1.setText("Subreport 1");

		tabPageSR2.setLocation(new Point(4, 25));
		tabPageSR2.setSize(new Point(296, 276));
		tabPageSR2.setTabIndex(8);
		tabPageSR2.setText("Subreport 2");

		editParametersMapExpression.setFont(Font.DEFAULT_GUI);
		editParametersMapExpression.setForeColor(Color.WINDOWTEXT);
		editParametersMapExpression.setLocation(new Point(0, 24));
		editParametersMapExpression.setSize(new Point(292, 72));
		editParametersMapExpression.setTabIndex(0);
		editParametersMapExpression.setText("");
		editParametersMapExpression.addOnMouseUp(new MouseEventHandler(this.editParametersMapExpression_mouseUp));
		editParametersMapExpression.addOnTextChanged(new EventHandler(this.editParametersMapExpression_textChanged));

		label21.setLocation(new Point(0, 8));
		label21.setSize(new Point(184, 16));
		label21.setTabIndex(5);
		label21.setTabStop(false);
		label21.setText("Parameters Map Expression");

		columnHeader2.setText("Expression");
		columnHeader2.setWidth(188);

		columnHeader1.setText("Name");
		columnHeader1.setWidth(99);

		label22.setLocation(new Point(4, 124));
		label22.setSize(new Point(184, 16));
		label22.setTabIndex(2);
		label22.setTabStop(false);
		label22.setText("Subreport Parameters ");

		menuItem1.setText("Add parameter");
		menuItem1.addOnClick(new EventHandler(this.menuItem1_click));

		menuItem2.setEnabled(false);
		menuItem2.setText("Rem parameter");
		menuItem2.addOnClick(new EventHandler(this.menuItem2_click));

		editSRConection.setFont(Font.DEFAULT_GUI);
		editSRConection.setForeColor(Color.WINDOWTEXT);
		editSRConection.setLocation(new Point(0, 144));
		editSRConection.setSize(new Point(292, 92));
		editSRConection.setTabIndex(2);
		editSRConection.setText("");
		editSRConection.addOnMouseUp(new MouseEventHandler(this.editSRConection_mouseUp));
		editSRConection.addOnTextChanged(new EventHandler(this.editSRConection_textChanged));

		label23.setLocation(new Point(0, 104));
		label23.setSize(new Point(184, 16));
		label23.setTabIndex(3);
		label23.setTabStop(false);
		label23.setText("Connection/Datasource Expression");

		editSRExpression.setFont(Font.DEFAULT_GUI);
		editSRExpression.setForeColor(Color.WINDOWTEXT);
		editSRExpression.setLocation(new Point(4, 60));
		editSRExpression.setSize(new Point(288, 56));
		editSRExpression.setTabIndex(1);
		editSRExpression.setText("");
		editSRExpression.addOnMouseUp(new MouseEventHandler(this.editSRExpression_mouseUp));
		editSRExpression.addOnTextChanged(new EventHandler(this.editSRExpression_textChanged));

		comboBoxSRConnection.setLocation(new Point(0, 120));
		comboBoxSRConnection.setSize(new Point(292, 21));
		comboBoxSRConnection.setTabIndex(1);
		comboBoxSRConnection.setText("");
		comboBoxSRConnection.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxSRConnection.setItems(new Object[] {
									  "Don\'t use connection or datasource", 
									  "Use connection expression", 
									  "Use datasource expression"});
		comboBoxSRConnection.addOnSelectedIndexChanged(new EventHandler(this.comboBoxSRConnection_selectedIndexChanged));

		label24.setLocation(new Point(4, 4));
		label24.setSize(new Point(184, 16));
		label24.setTabIndex(4);
		label24.setTabStop(false);
		label24.setText("Subreport Expression");

		checkBoxIsUsingCache.setLocation(new Point(8, 240));
		checkBoxIsUsingCache.setSize(new Point(88, 16));
		checkBoxIsUsingCache.setTabIndex(4);
		checkBoxIsUsingCache.setText("Using cache");
		checkBoxIsUsingCache.addOnClick(new EventHandler(this.checkBoxIsUsingCache_click));

		comboBoxSRExpressionClass.setLocation(new Point(4, 20));
		comboBoxSRExpressionClass.setSize(new Point(240, 21));
		comboBoxSRExpressionClass.setTabIndex(0);
		comboBoxSRExpressionClass.setText("");
		comboBoxSRExpressionClass.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxSRExpressionClass.setItems(new Object[] {
										   "java.lang.String", 
										   "java.io.File", 
										   "java.net.URL", 
										   "java.io.InputStream", 
										   "dori.jasper.engine.JasperReport"});
		comboBoxSRExpressionClass.addOnSelectedIndexChanged(new EventHandler(this.comboBoxSRExpressionClass_selectedIndexChanged));

		menuItem3.setEnabled(false);
		menuItem3.setText("Modify parameter");
		menuItem3.addOnClick(new EventHandler(this.menuItem3_click));

		contextMenu1.setMenuItems(new MenuItem[] {
								  menuItem1, 
								  menuItem3, 
								  menuItem2});
		/* @designTimeOnly contextMenu1.setLocation(new Point(152, -20)); */

		listViewSRParameters.setContextMenu(contextMenu1);
		listViewSRParameters.setLocation(new Point(0, 144));
		listViewSRParameters.setSize(new Point(292, 136));
		listViewSRParameters.setTabIndex(3);
		listViewSRParameters.setText("listView1");
		listViewSRParameters.setFullRowSelect(true);
		listViewSRParameters.setView(ViewEnum.REPORT);
		listViewSRParameters.setColumns(new ColumnHeader[] {
										columnHeader1, 
										columnHeader2});
		listViewSRParameters.addOnClick(new EventHandler(this.listView1_click));
		listViewSRParameters.addOnDoubleClick(new EventHandler(this.listViewSRParameters_doubleClick));
		listViewSRParameters.addOnKeyDown(new KeyEventHandler(this.listViewSRParameters_keyDown));

		checkBoxPrintWhenDetailOverflow.setLocation(new Point(4, 156));
		checkBoxPrintWhenDetailOverflow.setSize(new Point(164, 16));
		checkBoxPrintWhenDetailOverflow.setTabIndex(9);
		checkBoxPrintWhenDetailOverflow.setText("Print when detail overflows");
		checkBoxPrintWhenDetailOverflow.addOnClick(new EventHandler(this.checkBoxPrintWhenDetailOverflow_click));

		checkBoxPrintFirstWholeBand.setLocation(new Point(4, 136));
		checkBoxPrintFirstWholeBand.setSize(new Point(164, 16));
		checkBoxPrintFirstWholeBand.setTabIndex(8);
		checkBoxPrintFirstWholeBand.setText("Print in first whole band");
		checkBoxPrintFirstWholeBand.addOnClick(new EventHandler(this.checkBoxPrintFirstWholeBand_click));

		label8.setLocation(new Point(156, 132));
		label8.setSize(new Point(136, 16));
		label8.setTabIndex(15);
		label8.setTabStop(false);
		label8.setText("Print when group changes");

		checkBoxRemoveLineWhenBlank.setLocation(new Point(4, 116));
		checkBoxRemoveLineWhenBlank.setSize(new Point(160, 16));
		checkBoxRemoveLineWhenBlank.setTabIndex(7);
		checkBoxRemoveLineWhenBlank.setText("Remove line when blank");
		checkBoxRemoveLineWhenBlank.addOnClick(new EventHandler(this.checkBoxRemoveLineWhenBlank_click));

		label27.setLocation(new Point(156, 92));
		label27.setSize(new Point(76, 16));
		label27.setTabIndex(17);
		label27.setTabStop(false);
		label27.setText("Position type");

		comboBoxPositionType.setLocation(new Point(156, 108));
		comboBoxPositionType.setSize(new Point(136, 21));
		comboBoxPositionType.setTabIndex(11);
		comboBoxPositionType.setText("");
		comboBoxPositionType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxPositionType.setItems(new Object[] {
									  "FixRelativeToTop", 
									  "Float", 
									  "FixRelativeToBottom"});
		comboBoxPositionType.addOnSelectedIndexChanged(new EventHandler(this.comboBoxPositionType_selectedIndexChanged));

		groupBox1.setLocation(new Point(8, 84));
		groupBox1.setSize(new Point(280, 4));
		groupBox1.setTabIndex(16);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		comboBoxGroup.setLocation(new Point(156, 148));
		comboBoxGroup.setSize(new Point(136, 21));
		comboBoxGroup.setTabIndex(12);
		comboBoxGroup.setText("");
		comboBoxGroup.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxGroup.addOnSelectedIndexChanged(new EventHandler(this.comboBoxGroup_selectedIndexChanged));

		editPrintWhenExpression.setFont(new Font("Courier New", 9.0f, FontSize.POINTS, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		editPrintWhenExpression.setForeColor(Color.WINDOWTEXT);
		editPrintWhenExpression.setLocation(new Point(0, 216));
		editPrintWhenExpression.setSize(new Point(292, 60));
		editPrintWhenExpression.setTabIndex(13);
		editPrintWhenExpression.setText("");
		editPrintWhenExpression.setHideSelection(false);
		editPrintWhenExpression.setWordWrap(false);
		editPrintWhenExpression.setWordBreak(false);
		editPrintWhenExpression.addOnMouseUp(new MouseEventHandler(this.editPrintWhenExpression_mouseUp));
		editPrintWhenExpression.addOnTextChanged(new EventHandler(this.editPrintWhenExpression_textChanged));

		label25.setLocation(new Point(0, 200));
		label25.setSize(new Point(140, 16));
		label25.setTabIndex(14);
		label25.setTabStop(false);
		label25.setText("Print When Expression");

		label26.setLocation(new Point(236, 44));
		label26.setSize(new Point(52, 16));
		label26.setTabIndex(17);
		label26.setTabStop(false);
		label26.setText("Size");

		label28.setLocation(new Point(8, 84));
		label28.setSize(new Point(144, 16));
		label28.setTabIndex(16);
		label28.setTabStop(false);
		label28.setText("TrueType font");

		checkBoxIsPdfEmbedded.setLocation(new Point(12, 236));
		checkBoxIsPdfEmbedded.setSize(new Point(108, 23));
		checkBoxIsPdfEmbedded.setTabIndex(12);
		checkBoxIsPdfEmbedded.setText("Pdf Embedded");
		checkBoxIsPdfEmbedded.addOnClick(new EventHandler(this.checkBoxIsPdfEmbedded_click));

		groupBox2.setLocation(new Point(8, 216));
		groupBox2.setSize(new Point(280, 4));
		groupBox2.setTabIndex(15);
		groupBox2.setTabStop(false);
		groupBox2.setText("");

		label29.setLocation(new Point(120, 224));
		label29.setSize(new Point(148, 16));
		label29.setTabIndex(14);
		label29.setTabStop(false);
		label29.setText("Pdf encoding");

		comboBoxPdfEncoding.setLocation(new Point(120, 240));
		comboBoxPdfEncoding.setSize(new Point(168, 21));
		comboBoxPdfEncoding.setTabIndex(13);
		comboBoxPdfEncoding.setText("");
		comboBoxPdfEncoding.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxPdfEncoding.setItems(new Object[] {
									 "Cp1250 (Central European)", 
									 "Cp1251 (Cyrillic)", 
									 "Cp1252 (Western European ANSI aka WinAnsi)", 
									 "Cp1253 (Greek)", 
									 "Cp1254 (Turkish)", 
									 "Cp1255 (Hebrew)", 
									 "Cp1256 (Arabic)", 
									 "Cp1257 (Baltic)", 
									 "Cp1258 (Vietnamese)", 
									 "UniGB-UCS2-H (Chinese Simplified)", 
									 "UniGB-UCS2-V (Chinese Simplified)", 
									 "UniCNS-UCS2-H (Chinese traditional)", 
									 "UniCNS-UCS2-V (Chinese traditional)", 
									 "UniJIS-UCS2-H (Japanese)", 
									 "UniJIS-UCS2-V (Japanese)", 
									 "UniJIS-UCS2-HW-H (Japanese)", 
									 "UniJIS-UCS2-HW-V (Japanese)", 
									 "UniKS-UCS2-H (Korean)", 
									 "UniKS-UCS2-V (Korean)", 
									 "Identity-H (Unicode with horizontal writing)", 
									 "Identity-V (Unicode with vertical writing)"});
		comboBoxPdfEncoding.addOnSelectedIndexChanged(new EventHandler(this.comboBoxPdfEncoding_selectedIndexChanged));

		checkBoxPrintRepeatedValues.setLocation(new Point(4, 176));
		checkBoxPrintRepeatedValues.setSize(new Point(164, 16));
		checkBoxPrintRepeatedValues.setTabIndex(10);
		checkBoxPrintRepeatedValues.setText("Print repeated values");
		checkBoxPrintRepeatedValues.addOnClick(new EventHandler(this.checkBoxPrintRepeatedValues_click));

		label30.setLocation(new Point(8, 156));
		label30.setSize(new Point(128, 16));
		label30.setTabIndex(9);
		label30.setTabStop(false);
		label30.setText("Evaluation time");

		comboBoxImgEvalGroup.setBackColor(Color.INACTIVEBORDER);
		comboBoxImgEvalGroup.setEnabled(false);
		comboBoxImgEvalGroup.setLocation(new Point(144, 172));
		comboBoxImgEvalGroup.setSize(new Point(144, 21));
		comboBoxImgEvalGroup.setTabIndex(7);
		comboBoxImgEvalGroup.setText("");
		comboBoxImgEvalGroup.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxImgEvalGroup.addOnSelectedIndexChanged(new EventHandler(this.comboBoxImgEvalGroup_selectedIndexChanged));

		comboBoxImgEvalTime.setLocation(new Point(8, 172));
		comboBoxImgEvalTime.setSize(new Point(132, 21));
		comboBoxImgEvalTime.setTabIndex(6);
		comboBoxImgEvalTime.setText("");
		comboBoxImgEvalTime.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxImgEvalTime.setItems(new Object[] {
									 "Now", 
									 "Report", 
									 "Page", 
									 "Column", 
									 "Group"});
		comboBoxImgEvalTime.addOnSelectedIndexChanged(new EventHandler(this.comboBoxImgEvalTime_selectedIndexChanged));

		comboBoxImgLinkType.setLocation(new Point(88, 80));
		comboBoxImgLinkType.setSize(new Point(196, 21));
		comboBoxImgLinkType.setTabIndex(1);
		comboBoxImgLinkType.setText("");
		comboBoxImgLinkType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxImgLinkType.setItems(new Object[] {
									 "None", 
									 "Reference", 
									 "LocalAnchor", 
									 "LocalPage", 
									 "RemoteAnchor", 
									 "RemotePage"});
		comboBoxImgLinkType.addOnSelectedIndexChanged(new EventHandler(this.comboBoxImgLinkType_selectedIndexChanged));

		label32.setLocation(new Point(144, 156));
		label32.setSize(new Point(100, 16));
		label32.setTabIndex(8);
		label32.setTabStop(false);
		label32.setText("Evaluation group");

		label31.setLocation(new Point(8, 84));
		label31.setSize(new Point(76, 16));
		label31.setTabIndex(10);
		label31.setTabStop(false);
		label31.setText("Hyperlink type");

		tabPageHL.setLocation(new Point(4, 25));
		tabPageHL.setSize(new Point(296, 276));
		tabPageHL.setTabIndex(9);
		tabPageHL.setText("Hyper Link");

		label33.setLocation(new Point(8, 88));
		label33.setSize(new Point(100, 16));
		label33.setTabIndex(4);
		label33.setTabStop(false);
		label33.setText("Fill");

		comboBoxFill.setLocation(new Point(8, 104));
		comboBoxFill.setSize(new Point(280, 21));
		comboBoxFill.setTabIndex(3);
		comboBoxFill.setText("");
		comboBoxFill.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxFill.setItems(new Object[] {
							  "Solid"});
		comboBoxFill.addOnSelectedIndexChanged(new EventHandler(this.comboBoxFill_selectedIndexChanged));

		label34.setLocation(new Point(8, 48));
		label34.setSize(new Point(100, 16));
		label34.setTabIndex(1);
		label34.setTabStop(false);
		label34.setText("Stretch Type");

		comboBoxStretchType.setLocation(new Point(8, 64));
		comboBoxStretchType.setSize(new Point(280, 21));
		comboBoxStretchType.setTabIndex(2);
		comboBoxStretchType.setText("");
		comboBoxStretchType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxStretchType.setItems(new Object[] {
									 "NoStretch", 
									 "RelativeToTallestObject", 
									 "RelativeToBandHeight"});
		comboBoxStretchType.addOnSelectedIndexChanged(new EventHandler(this.comboBoxStretchType_selectedIndexChanged));

		groupBox3.setLocation(new Point(4, 68));
		groupBox3.setSize(new Point(284, 4));
		groupBox3.setTabIndex(6);
		groupBox3.setTabStop(false);
		groupBox3.setText("");

		editAnchorNameExpression.setFont(Font.DEFAULT_GUI);
		editAnchorNameExpression.setForeColor(Color.WINDOWTEXT);
		editAnchorNameExpression.setLocation(new Point(8, 20));
		editAnchorNameExpression.setSize(new Point(280, 36));
		editAnchorNameExpression.setTabIndex(0);
		editAnchorNameExpression.setText("");
		editAnchorNameExpression.addOnMouseUp(new MouseEventHandler(this.editAnchorNameExpression_mouseUp));
		editAnchorNameExpression.addOnTextChanged(new EventHandler(this.editAnchorNameExpression_textChanged));

		label36.setLocation(new Point(8, 4));
		label36.setSize(new Point(176, 16));
		label36.setTabIndex(9);
		label36.setTabStop(false);
		label36.setText("Anchor Name Expression");

		editImgHyperReferenceExpression.setFont(Font.DEFAULT_GUI);
		editImgHyperReferenceExpression.setForeColor(Color.WINDOWTEXT);
		editImgHyperReferenceExpression.setLocation(new Point(8, 124));
		editImgHyperReferenceExpression.setSize(new Point(280, 36));
		editImgHyperReferenceExpression.setTabIndex(2);
		editImgHyperReferenceExpression.setText("");
		editImgHyperReferenceExpression.addOnMouseUp(new MouseEventHandler(this.editImgHyperReferenceExpression_mouseUp));
		editImgHyperReferenceExpression.addOnTextChanged(new EventHandler(this.editImgHyperReferenceExpression_textChanged));

		labelHL1.setLocation(new Point(8, 108));
		labelHL1.setSize(new Point(164, 16));
		labelHL1.setTabIndex(8);
		labelHL1.setTabStop(false);
		labelHL1.setText("Hyperlink Reference Expression");

		editImgHyperAnchorExpression.setFont(Font.DEFAULT_GUI);
		editImgHyperAnchorExpression.setForeColor(Color.WINDOWTEXT);
		editImgHyperAnchorExpression.setLocation(new Point(8, 180));
		editImgHyperAnchorExpression.setSize(new Point(280, 36));
		editImgHyperAnchorExpression.setTabIndex(3);
		editImgHyperAnchorExpression.setText("");
		editImgHyperAnchorExpression.addOnMouseUp(new MouseEventHandler(this.editImgHyperAnchorExpression_mouseUp));
		editImgHyperAnchorExpression.addOnTextChanged(new EventHandler(this.editImgHyperAnchorExpression_textChanged));

		labelHL2.setLocation(new Point(8, 164));
		labelHL2.setSize(new Point(164, 16));
		labelHL2.setTabIndex(7);
		labelHL2.setTabStop(false);
		labelHL2.setText("Hyperlink Anchor Expression");

		groupBox4.setLocation(new Point(8, 140));
		groupBox4.setSize(new Point(280, 4));
		groupBox4.setTabIndex(0);
		groupBox4.setTabStop(false);
		groupBox4.setText("");

		labelHL3.setLocation(new Point(8, 220));
		labelHL3.setSize(new Point(164, 16));
		labelHL3.setTabIndex(4);
		labelHL3.setTabStop(false);
		labelHL3.setText("Hyperlink Page Expression");

		editImgHyperPageExpression.setFont(Font.DEFAULT_GUI);
		editImgHyperPageExpression.setForeColor(Color.WINDOWTEXT);
		editImgHyperPageExpression.setLocation(new Point(0, 240));
		editImgHyperPageExpression.setSize(new Point(280, 36));
		editImgHyperPageExpression.setTabIndex(5);
		editImgHyperPageExpression.setText("");
		editImgHyperPageExpression.addOnMouseUp(new MouseEventHandler(this.editImgHyperPageExpression_mouseUp));
		editImgHyperPageExpression.addOnTextChanged(new EventHandler(this.editImgHyperPageExpression_textChanged));

		editPattern.setLocation(new Point(8, 128));
		editPattern.setSize(new Point(280, 20));
		editPattern.setTabIndex(6);
		editPattern.setText("editPattern");
		editPattern.addOnTextChanged(new EventHandler(this.editPattern_textChanged));

		comboBoxTextFieldEvalGroup.setBackColor(Color.INACTIVEBORDER);
		comboBoxTextFieldEvalGroup.setEnabled(false);
		comboBoxTextFieldEvalGroup.setLocation(new Point(140, 64));
		comboBoxTextFieldEvalGroup.setSize(new Point(144, 21));
		comboBoxTextFieldEvalGroup.setTabIndex(3);
		comboBoxTextFieldEvalGroup.setText("");
		comboBoxTextFieldEvalGroup.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxTextFieldEvalGroup.addOnSelectedIndexChanged(new EventHandler(this.comboBoxTextFieldEvalGroup_selectedIndexChanged));

		checkBoxIsStretchWithOverflow.setLocation(new Point(8, 88));
		checkBoxIsStretchWithOverflow.setSize(new Point(120, 23));
		checkBoxIsStretchWithOverflow.setTabIndex(4);
		checkBoxIsStretchWithOverflow.setText("Stretch with overflow");
		checkBoxIsStretchWithOverflow.addOnClick(new EventHandler(this.checkBoxIsStretchWithOverflow_click));

		label37.setLocation(new Point(140, 48));
		label37.setSize(new Point(100, 16));
		label37.setTabIndex(8);
		label37.setTabStop(false);
		label37.setText("Evaluation group");

		checkBoxIsBlankWhenNull.setLocation(new Point(176, 88));
		checkBoxIsBlankWhenNull.setSize(new Point(108, 23));
		checkBoxIsBlankWhenNull.setTabIndex(5);
		checkBoxIsBlankWhenNull.setText("Blank when Null");
		checkBoxIsBlankWhenNull.addOnClick(new EventHandler(this.checkBoxIsBlankWhenNull_click));

		label35.setLocation(new Point(8, 112));
		label35.setSize(new Point(144, 16));
		label35.setTabIndex(0);
		label35.setTabStop(false);
		label35.setText("Pattern");

		comboBoxReportFonts.setLocation(new Point(8, 20));
		comboBoxReportFonts.setSize(new Point(280, 21));
		comboBoxReportFonts.setTabIndex(1);
		comboBoxReportFonts.setText("");
		comboBoxReportFonts.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxReportFonts.addOnSelectedIndexChanged(new EventHandler(this.comboBoxReportFonts_selectedIndexChanged));

		label38.setLocation(new Point(8, 4));
		label38.setSize(new Point(100, 16));
		label38.setTabIndex(0);
		label38.setTabStop(false);
		label38.setText("Report font");

		menuItem4.setText("Edit with JasperExpression editor...");
		menuItem4.addOnClick(new EventHandler(this.menuItem4_click));

		contextMenu2.setMenuItems(new MenuItem[] {
								  menuItem4});
		/* @designTimeOnly contextMenu2.setLocation(new Point(192, 100)); */

		tabPageRectangle.setLocation(new Point(4, 25));
		tabPageRectangle.setSize(new Point(296, 276));
		tabPageRectangle.setTabIndex(10);
		tabPageRectangle.setText("Rectangle");

		label39.setLocation(new Point(12, 24));
		label39.setSize(new Point(44, 16));
		label39.setTabIndex(0);
		label39.setTabStop(false);
		label39.setText("Radius");

		numberEditRadius.setLocation(new Point(56, 20));
		numberEditRadius.setSize(new Point(32, 20));
		numberEditRadius.setTabIndex(1);
		numberEditRadius.setText("0");
		numberEditRadius.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditRadius.setIsDouble(false);
		numberEditRadius.setDecimals(0);
		numberEditRadius.setValue(0.0d);
		numberEditRadius.setViewPlus(false);
		numberEditRadius.setSeparatoreMigliaia(true);
		numberEditRadius.addOnValueChanged(new EventHandler(this.numberEditRadius_valueChanged));

		groupBox5.setLocation(new Point(8, 8));
		groupBox5.setSize(new Point(280, 56));
		groupBox5.setTabIndex(0);
		groupBox5.setTabStop(false);
		groupBox5.setText("Rectangle radius");

		label40.setLocation(new Point(204, 172));
		label40.setSize(new Point(84, 16));
		label40.setTabIndex(19);
		label40.setTabStop(false);
		label40.setText("Vertical align");

		comboBoxVerticalAlign.setLocation(new Point(204, 188));
		comboBoxVerticalAlign.setSize(new Point(84, 21));
		comboBoxVerticalAlign.setTabIndex(11);
		comboBoxVerticalAlign.setText("");
		comboBoxVerticalAlign.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxVerticalAlign.setItems(new Object[] {
									   "Top", 
									   "Middle", 
									   "Bottom"});
		comboBoxVerticalAlign.addOnSelectedIndexChanged(new EventHandler(this.comboBoxVerticalAlign_selectedIndexChanged));

		btnOpenSubReport.setLocation(new Point(250, 20));
		btnOpenSubReport.setSize(new Point(40, 21));
		btnOpenSubReport.setTabIndex(5);
		btnOpenSubReport.setText("Open");
		btnOpenSubReport.setVisible(false);
		btnOpenSubReport.addOnClick(new EventHandler(this.btnOpenSubReport_click));

		this.setNewControls(new Control[] {
							tabControl1});
		tabControl1.setNewControls(new Control[] {
								   tabPage1, 
								   tabPageStaticText, 
								   tabPageTextProperties, 
								   tabPageImage, 
								   tabPageGraphicElement, 
								   tabPageLine, 
								   tabPageTextField, 
								   tabPageSR1, 
								   tabPageSR2, 
								   tabPageHL, 
								   tabPageRectangle});
		tabPage1.setNewControls(new Control[] {
								checkBoxPrintRepeatedValues, 
								label25, 
								editPrintWhenExpression, 
								comboBoxGroup, 
								label8, 
								checkBoxPrintWhenDetailOverflow, 
								groupBox1, 
								comboBoxPositionType, 
								label27, 
								checkBoxRemoveLineWhenBlank, 
								checkBoxPrintFirstWholeBand, 
								checkBoxTransparent, 
								label7, 
								label1, 
								panel2, 
								label3, 
								label2, 
								panel1, 
								label5, 
								numberEditHeight, 
								label4, 
								numberEditLeft, 
								numberEditWidth, 
								numberEditTop, 
								comboBoxBands, 
								label6});
		tabPageStaticText.setNewControls(new Control[] {
										 label9, 
										 editStaticText});
		tabPageTextProperties.setNewControls(new Control[] {
											 comboBoxVerticalAlign, 
											 label40, 
											 label38, 
											 comboBoxReportFonts, 
											 comboBoxPdfEncoding, 
											 label29, 
											 groupBox2, 
											 checkBoxIsPdfEmbedded, 
											 label28, 
											 comboBoxTTF, 
											 label26, 
											 numberComboBoxFontSize, 
											 checkBoxStrike, 
											 checkBoxUnderline, 
											 checkBoxItalic, 
											 checkBoxBold, 
											 editFont, 
											 comboBoxLineSpacing, 
											 label12, 
											 comboBoxAlign, 
											 label11, 
											 label10});
		tabPageImage.setNewControls(new Control[] {
									groupBox4, 
									label32, 
									comboBoxImgEvalTime, 
									comboBoxImgEvalGroup, 
									label30, 
									checkBoxUsingCache, 
									comboBoxScaleImage, 
									label15, 
									button1, 
									comboBoxImageClass, 
									label14, 
									label13, 
									editImageExpression});
		tabPageGraphicElement.setNewControls(new Control[] {
											 comboBoxStretchType, 
											 label34, 
											 comboBoxFill, 
											 label33, 
											 comboBoxPen, 
											 label16});
		tabPageLine.setNewControls(new Control[] {
								   comboBoxDirection, 
								   label17});
		tabPageTextField.setNewControls(new Control[] {
										label35, 
										editPattern, 
										checkBoxIsBlankWhenNull, 
										checkBoxIsStretchWithOverflow, 
										label37, 
										comboBoxTextFieldEvalGroup, 
										label20, 
										comboBoxExpressionClass, 
										editTextFieldExpression, 
										label19, 
										label18, 
										comboBoxTextTime});
		tabPageSR1.setNewControls(new Control[] {
								  checkBoxIsUsingCache, 
								  comboBoxSRConnection, 
								  label23, 
								  editSRConection, 
								  label21, 
								  editParametersMapExpression});
		tabPageSR2.setNewControls(new Control[] {
								  btnOpenSubReport, 
								  comboBoxSRExpressionClass, 
								  listViewSRParameters, 
								  label22, 
								  editSRExpression, 
								  label24});
		tabPageHL.setNewControls(new Control[] {
								 editImgHyperPageExpression, 
								 labelHL3, 
								 groupBox3, 
								 editImgHyperAnchorExpression, 
								 labelHL2, 
								 editImgHyperReferenceExpression, 
								 labelHL1, 
								 label36, 
								 editAnchorNameExpression, 
								 comboBoxImgLinkType, 
								 label31});
		tabPageRectangle.setNewControls(new Control[] {
										groupBox5});
		groupBox5.setNewControls(new Control[] {
								 label39, 
								 numberEditRadius});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ElementProperties());
	}
}
