/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 */
package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.businesslogic.ireport.util.*;

import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ReportPropertiesForm"
 * non viene creato nel metodo main().
 */
public class ReportPropertiesForm extends Form
{
	
	int unit = 0;
	public Point size;
	public String name;
	public String format;
	public int	   margin_top;
	public int    margin_bottom;
	public int    margin_left;
	public int    margin_right;
	public int    columns;
	public int    column_width;
	public int    column_spacig;
	
	public String    orientation;
	public String    whenNoDataType;
	public String	 printOrder;
	public String	 scriptletClass;
	public String	 encoding;
	public boolean   isTitleNewPage;
	public boolean   isSummaryNewPage;
	
	MainForm mf=null;
	
	
	public Point getPageSize() { return size; }
	public void setPageSize(Point new_size) { size = new_size; }
	public String getReportName() { return name; }
	public void setReportName(String new_name) { if (new_name==null) return; name = new_name; this.editName.setText(new_name); }
	public String getReportFormat() { return comboBoxSize.getText(); }
	
	
	public ReportPropertiesForm(MainForm mf)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		
		comboBoxSize.setSelectedItem("A4");
		encoding="";
		size = new Point( PageSize.A4);
		
		this.editWidth.setValue(size.x);
		this.editHeight.setValue(size.y);
		
		this.comboBoxWUnit.setSelectedIndex(0);
		this.comboBoxHUnit.setSelectedIndex(0);
		this.comboBoxMTop.setSelectedIndex(0);
		this.comboBoxMBottom.setSelectedIndex(0);
		this.comboBoxMLeft.setSelectedIndex(0);
		this.comboBoxMRight.setSelectedIndex(0);
		this.comboBoxCWidth.setSelectedIndex(0);
		this.comboBoxCSpacing.setSelectedIndex(0);
		
		margin_top = 20;
		margin_bottom = 20;
		margin_left = 30;
		margin_right = 30;
		columns = 1;
		column_width= size.x - margin_left - margin_right;
		column_spacig=0;
		
		this.numberEditMTop.setValue(margin_top);
		this.numberEditMBottom.setValue(margin_bottom);
		this.numberEditMLeft.setValue(margin_left);
		this.numberEditMRight.setValue(margin_right);
		this.numberEditCWidth.setValue(column_width);
		this.numberEditColumns.setValue(columns);
		this.numberEditCSpacing.setValue(column_spacig);
		
		this.setText("New report");
		// TODO: aggiungere il codice del costruttore dopo la chiamata di initForm.
		this.mf = mf;
		if ( mf.ireportProperties.getProperty("DEFAULT_UNITS") != null && mf.ireportProperties.getProperty("DEFAULT_UNITS").equals("cm"))
			unit = 2;
		else if ( mf.ireportProperties.getProperty("DEFAULT_UNITS") != null && mf.ireportProperties.getProperty("DEFAULT_UNITS").equals("pixels"))
			unit = 0;
		else if ( mf.ireportProperties.getProperty("DEFAULT_UNITS") != null && mf.ireportProperties.getProperty("DEFAULT_UNITS").equals("inches"))
			unit = 1;
		
		changeUM();
		
		comboBoxOrientation.setSelectedIndex(0);
		comboBoxPrintOrder.setSelectedIndex(0);
		comboBoxWhenNoDataType.setSelectedIndex(0);
		checkBoxTitleNewPage.setChecked(false);
		checkBoxSummaryNewPage.setChecked(false);
		editScriptlet.setText("");
	}
	
	public void changeUM()
	{
		this.comboBoxCSpacing.setSelectedIndex(unit);
		setMisureValue(comboBoxCSpacing, numberEditCSpacing, column_spacig);
		this.comboBoxCWidth.setSelectedIndex(unit);
		setMisureValue(comboBoxCWidth, numberEditCWidth,column_width);
		this.comboBoxMBottom.setSelectedIndex(unit);
		setMisureValue(comboBoxMBottom, numberEditMBottom, margin_bottom  );
		this.comboBoxMLeft.setSelectedIndex(unit);
		setMisureValue(comboBoxMLeft, numberEditMLeft, margin_left );
		this.comboBoxMRight.setSelectedIndex(unit);
		setMisureValue(comboBoxMRight, numberEditMRight, margin_right );
		this.comboBoxMTop.setSelectedIndex(unit);
		setMisureValue(comboBoxMTop, numberEditMTop, margin_top );
		this.comboBoxWUnit.setSelectedIndex(unit);
		setMisureValue(comboBoxWUnit, editWidth , size.x );
		this.comboBoxHUnit.setSelectedIndex(unit);
		setMisureValue(comboBoxHUnit, editHeight, size.y );
	}

	public void setReport(Report report)
	{
		this.size =  new Point(report.getPagesize());
		this.margin_top = report.topMargin;
		this.margin_left = report.leftMargin;
		this.margin_bottom = report.bottomMargin;
		this.margin_right = report.rightMargin;
		this.columns = report.columnCount;
		this.column_spacig = report.columnSpacing;
		this.column_width = report.columnWidth;
		this.format = report.getReportFormat();
		this.scriptletClass = report.scriptletClass;
		this.orientation = report.orientation;
		this.isSummaryNewPage = report.isSummaryNewPage;
		this.isTitleNewPage  = report.isTitleNewPage;
		this.printOrder = report.printOrder;
		this.whenNoDataType = report.whenNoDataType;
		this.encoding = report.encoding;


		this.editWidth.setValue(size.x);
		this.editHeight.setValue(size.y);
		
		comboBoxSize.setSelectedItem(format);
		this.comboBoxWUnit.setSelectedIndex(0);
		this.comboBoxHUnit.setSelectedIndex(0);
		this.comboBoxMTop.setSelectedIndex(0);
		this.comboBoxMBottom.setSelectedIndex(0);
		this.comboBoxMLeft.setSelectedIndex(0);
		this.comboBoxMRight.setSelectedIndex(0);
		this.comboBoxCWidth.setSelectedIndex(0);
		this.comboBoxCSpacing.setSelectedIndex(0);
		
		this.numberEditMTop.setValue(margin_top);
		this.numberEditMBottom.setValue(margin_bottom);
		this.numberEditMLeft.setValue(margin_left);
		this.numberEditMRight.setValue(margin_right);
		this.numberEditCWidth.setValue(column_width);
		this.numberEditColumns.setValue(columns);
		this.numberEditCSpacing.setValue(column_spacig);
		
		editName.setText(report.getReportName());
		this.setText("Report properties...");
		
		changeUM();
		editScriptlet.setText(scriptletClass);
		comboBoxOrientation.setSelectedItem(orientation);
		comboBoxPrintOrder.setSelectedItem(printOrder);
		comboBoxWhenNoDataType.setSelectedItem(whenNoDataType );
		checkBoxTitleNewPage.setChecked(isTitleNewPage);
		checkBoxSummaryNewPage.setChecked(isSummaryNewPage);
		
		comboBoxEncoding.setText(encoding);
	}
	
	
	/**
	 * ReportPropertiesForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void comboBoxWUnit_selectedIndexChanged(Object source, Event e)
	{
		// Convert misure...
		if (comboBoxWUnit.getSelectedIndex() == 0)
		{
			editWidth.setDecimals(0);
			editWidth.setIsDouble(false);
			editWidth.setValue( this.size.x);
		}
		else if (comboBoxWUnit.getSelectedIndex() == 1)
		{
			editWidth.setDecimals(3);
			editWidth.setIsDouble(true);
			editWidth.setValue( UnitConverter.convertPixelsToInches( this.size.x) );
		}
		else if (comboBoxWUnit.getSelectedIndex() == 2)
		{
			editWidth.setDecimals(3);
			editWidth.setIsDouble(true);
			editWidth.setValue( UnitConverter.convertPixelsToCentimeters( this.size.x) );
		}
		else if (comboBoxWUnit.getSelectedIndex() == 3)
		{
			editWidth.setDecimals(3);
			editWidth.setIsDouble(true);
			editWidth.setValue( UnitConverter.convertPixelsToMillimeters( this.size.x) );
		}
	}

	private void editWidth_valueChanged(Object source, Event e)
	{
		this.comboBoxSize.setSelectedItem("Custom");
		double convert = 1.0;
		if (comboBoxWUnit.getSelectedIndex() == 1)
		{
			convert = UnitConverter.INCHES;
		}
		else if (comboBoxWUnit.getSelectedIndex() == 2)
		{
			convert = UnitConverter.CENTIMETERS;
		}
		else if (comboBoxWUnit.getSelectedIndex() == 3)
		{
			convert = UnitConverter.MILLIMETERS;
		}
		
		size.x = (int)UnitConverter.convertToPixels(editWidth.getValue(),convert);
	}
	
	private void comboBoxHUnit_selectedIndexChanged(Object source, Event e)
	{
		// Convert misure...
		
		if (comboBoxHUnit.getSelectedIndex() == 0)
		{
			editHeight.setDecimals(0);
			editHeight.setIsDouble(false);
			editHeight.setValue( this.size.y);
		}
		else if (comboBoxHUnit.getSelectedIndex() == 1)
		{
			editHeight.setDecimals(3);
			editHeight.setIsDouble(true);
			editHeight.setValue( UnitConverter.convertPixelsToInches( this.size.y) );
		}
		else if (comboBoxHUnit.getSelectedIndex() == 2)
		{
			editHeight.setDecimals(3);
			editHeight.setIsDouble(true);
			editHeight.setValue( UnitConverter.convertPixelsToCentimeters( this.size.y) );
		}
		else if (comboBoxHUnit.getSelectedIndex() == 3)
		{
			editHeight.setDecimals(3);
			editHeight.setIsDouble(true);
			editHeight.setValue( UnitConverter.convertPixelsToMillimeters( this.size.y) );
		}
	}

	private void editHeight_valueChanged(Object source, Event e)
	{
		this.comboBoxSize.setSelectedItem("Custom");
		double convert = 1.0;
		if (comboBoxHUnit.getSelectedIndex() == 1)
		{
			convert = UnitConverter.INCHES;
		}
		else if (comboBoxHUnit.getSelectedIndex() == 2)
		{
			convert = UnitConverter.CENTIMETERS;
		}
		else if (comboBoxHUnit.getSelectedIndex() == 3)
		{
			convert = UnitConverter.MILLIMETERS;
		}
		
		size.y = (int)UnitConverter.convertToPixels(editHeight.getValue(),convert);
	}

	private void comboBoxSize_selectedIndexChanged(Object source, Event e)
	{
		String format = comboBoxSize.getText();
		if (format.equals("LETTER")){
			this.size = PageSize.LETTER;
		}
		else if (format.equals("NOTE")){
			this.size = PageSize.NOTE;
		}
		else if (format.equals("LEGAL")){
			this.size = PageSize.LEGAL;
		}
		else if (format.equals("A0")){
			this.size = PageSize.A0;
		}
		else if (format.equals("A1")){
			this.size = PageSize.A1;
		}
		else if (format.equals("A2")){
			this.size = PageSize.A2;
		}
		else if (format.equals("A3")){
			this.size = PageSize.A3;
		}
		else if (format.equals("A4")){
			this.size = PageSize.A4;
		}
		else if (format.equals("A5")){
			this.size = PageSize.A5;
		}
		else if (format.equals("A6")){
			this.size = PageSize.A6;
		}
		else if (format.equals("A7")){
				this.size = PageSize.A7;
		}
		else if (format.equals("A8")){
			this.size = PageSize.A8;	
			}
		else if (format.equals("A9")){
			this.size = PageSize.A9;
		}
		else if (format.equals("A10")){
			this.size = PageSize.A10;
		}
		else if (format.equals("B0")){
			this.size = PageSize.B0;
		}
		else if (format.equals("B1")){	
			this.size = PageSize.B1;
		}
		else if (format.equals("B2")){
			this.size = PageSize.B2;
		}
		else if (format.equals("B3")){
			this.size = PageSize.B2;
		}
		else if (format.equals("B4")){
			this.size = PageSize.B4;
		}
		else if (format.equals("B5")){
			this.size = PageSize.B5;
		}
		else if (format.equals("ARCH_E")){
			this.size = PageSize.ARCH_E;
		}
		else if (format.equals("ARCH_D")){
			this.size = PageSize.ARCH_D;
		}
		else if (format.equals("ARCH_C")){
			this.size = PageSize.ARCH_C;
		}
		else if (format.equals("ARCH_B")){	
			this.size = PageSize.ARCH_B;
		}
		else if (format.equals("ARCH_A")){
			this.size = PageSize.ARCH_A;
		}
		else if (format.equals("FLSA")){
			this.size = PageSize.FLSA;
		}
		else if (format.equals("FLSE")){
			this.size = PageSize.FLSE;
		}
		else if (format.equals("HALFLETTER")){
			this.size = PageSize.HALFLETTER;
		}
		else if (format.equals("11x17")){
			this.size = PageSize._11X17;	
		}
		else if (format.equals("LEDGER")){
			this.size = PageSize.LEDGER;
		}
		/*
		if (orientation!=null &&  orientation.equals("Landscape"))
		{
			int k= size.x;
			size.x = size.y;
			size.y = k;
		}
		*/

		this.comboBoxWUnit_selectedIndexChanged(comboBoxWUnit,new Event());
		this.comboBoxHUnit_selectedIndexChanged(comboBoxHUnit,new Event());
		
	}



	private void comboBoxMTop_selectedIndexChanged(Object source, Event e)
	{
		// Convert misure...
		 setMisureValue(comboBoxMTop, numberEditMTop, margin_top );
	}
	
	public void setMisureValue(ComboBox unitCombo, NumberEdit numerEdit, int store_value)
	{
		if (unitCombo.getSelectedIndex() == 0)
		{
			numerEdit.setDecimals(0);
			numerEdit.setIsDouble(false);
			numerEdit.setValue(store_value);
		}
		else if (unitCombo.getSelectedIndex() == 1)
		{
			numerEdit.setDecimals(3);
			numerEdit.setIsDouble(true);
			numerEdit.setValue( UnitConverter.convertPixelsToInches(store_value) );
		}
		else if (unitCombo.getSelectedIndex() == 2)
		{
			numerEdit.setDecimals(3);
			numerEdit.setIsDouble(true);
			numerEdit.setValue( UnitConverter.convertPixelsToCentimeters( store_value) );
		}
		else if (unitCombo.getSelectedIndex() == 3)
		{
			numerEdit.setDecimals(3);
			numerEdit.setIsDouble(true);
			numerEdit.setValue( UnitConverter.convertPixelsToMillimeters( store_value) );
		}
	}
	

	private void comboBoxMBottom_selectedIndexChanged(Object source, Event e)
	{
		 setMisureValue(comboBoxMBottom , numberEditMBottom, margin_bottom );
	}

	private void comboBoxMLeft_selectedIndexChanged(Object source, Event e)
	{
		 setMisureValue(comboBoxMLeft, numberEditMLeft, margin_left );
	}

	private void comboBoxMRight_selectedIndexChanged(Object source, Event e)
	{
		 setMisureValue(comboBoxMRight , numberEditMRight, margin_right );
	}

	public double getUnitIndex(ComboBox combo)
	{
		if (combo.getSelectedIndex() == 1)
		{
			return UnitConverter.INCHES;
		}
		else if (combo.getSelectedIndex() == 2)
		{
			return UnitConverter.CENTIMETERS;
		}
		else if (combo.getSelectedIndex() == 3)
		{
			return UnitConverter.MILLIMETERS;
		}
		return 1.0;
	}
	
	private void numberEditMTop_valueChanged(Object source, Event e)
	{
		double convert = 1.0;
		convert = getUnitIndex(comboBoxMTop );
		margin_top  = (int)UnitConverter.convertToPixels(numberEditMTop.getValue(),convert);
	}

	private void numberEditMBottom_valueChanged(Object source, Event e)
	{
		double convert = 1.0;
		convert = getUnitIndex(comboBoxMBottom);
		margin_bottom  = (int)UnitConverter.convertToPixels(numberEditMBottom.getValue(),convert);
	}

	private void numberEditMLeft_valueChanged(Object source, Event e)
	{
		double convert = 1.0;
		convert = getUnitIndex(comboBoxMLeft);
		margin_left  = (int)UnitConverter.convertToPixels(numberEditMLeft.getValue(),convert);
	}

	private void numberEditMRight_valueChanged(Object source, Event e)
	{
		double convert = 1.0;
		convert = getUnitIndex(comboBoxMRight);
		margin_right  = (int)UnitConverter.convertToPixels(numberEditMRight.getValue(),convert);
	}

	private void numberEditColumns_valueChanged(Object source, Event e)
	{
		
		// calculate space...
		columns = (int)numberEditColumns.getValue();
		int avail = this.getPageSize().x - this.margin_left - this.margin_right;
		int dim = avail;
		dim -= (columns-1)*this.column_spacig;
		dim = (int)( (double)dim/(double)columns);
		while ( (dim*columns)+(column_spacig*(columns-1)) > avail)
		{
			dim--;
		}
		
		this.column_width = dim;
		setMisureValue(comboBoxCWidth   , numberEditCWidth , column_width  );setMisureValue(comboBoxCWidth   , numberEditCWidth , column_width  );
	}

	private void numberEditCWidth_valueChanged(Object source, Event e)
	{
		double convert = 1.0;
		convert = getUnitIndex(comboBoxCWidth);
		column_width  = (int)UnitConverter.convertToPixels(numberEditCWidth.getValue(),convert);
	}

	private void numberEditCSpacing_valueChanged(Object source, Event e)
	{
		double convert = 1.0;
		convert = getUnitIndex(comboBoxCSpacing);
		
		int old_spacing = column_spacig;
		
		column_spacig  = (int)UnitConverter.convertToPixels(numberEditCSpacing.getValue(),convert);
		
		int avail = this.getPageSize().x - this.margin_left - this.margin_right;
		int dim = avail;
		
		// calculate space...
		if ((column_spacig*(columns-1)) > avail)
		{
			MessageBox.show("WARNING: Column spacing too big!","",MessageBox.ICONWARNING);
		}
		while (dim>0 && (dim*columns)+(column_spacig*(columns-1)) > avail)
		{
			dim--;
		}
		
		this.column_width = dim;
		setMisureValue(comboBoxCWidth   , numberEditCWidth , column_width  );
		
	}

	private void comboBoxCWidth_selectedIndexChanged(Object source, Event e)
	{
		 setMisureValue(comboBoxCWidth  , numberEditCWidth , column_width );
	}

	private void comboBoxCSpacing_selectedIndexChanged(Object source, Event e)
	{
		setMisureValue(comboBoxCSpacing   , numberEditCSpacing , column_spacig  );
	}

	private void buttonOK_click(Object source, Event e)
	{
		
	}

	private void editName_textChanged(Object source, Event e)
	{
		this.name = editName.getText();
	}

	private void comboBoxWhenNoDataType_selectedIndexChanged(Object source, Event e)
	{
		this.whenNoDataType = (String)comboBoxWhenNoDataType.getSelectedItem();
	}

	private void comboBoxPrintOrder_selectedIndexChanged(Object source, Event e)
	{
		this.printOrder = (String)comboBoxPrintOrder.getSelectedItem();
	}

	private void checkBoxTitleNewPage_click(Object source, Event e)
	{
		isTitleNewPage = checkBoxTitleNewPage.getChecked();
	}

	private void checkBoxSummaryNewPage_click(Object source, Event e)
	{
		isSummaryNewPage = checkBoxSummaryNewPage.getChecked();
	}

	private void editScriptlet_textChanged(Object source, Event e)
	{
		this.scriptletClass = editScriptlet.getText();
	}

	private void comboBoxOrientation_selectedIndexChanged(Object source, Event e)
	{
		if (orientation != null && !this.orientation.equals( (String)comboBoxOrientation.getSelectedItem()))
		{
			
			int k = this.size.x;
			this.size.x = this.size.y;
			this.size.y = k;
		
			comboBoxWUnit_selectedIndexChanged(source, e);
			comboBoxHUnit_selectedIndexChanged(source, e);
		}
		
		this.orientation = (String)comboBoxOrientation.getSelectedItem();
	}

	private void comboBoxEncoding_selectedIndexChanged(Object source, Event e)
	{
		encoding = (String)comboBoxEncoding.getSelectedItem();
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	GroupBox groupBox1 = new GroupBox();
	Label label1 = new Label();
	Label label2 = new Label();
	ComboBox comboBoxWUnit = new ComboBox();
	Label label3 = new Label();
	ComboBox comboBoxHUnit = new ComboBox();
	ComboBox comboBoxSize = new ComboBox();
	Edit editName = new Edit();
	Label label4 = new Label();
	Button buttonOK = new Button();
	Button buttonCancel = new Button();
	NumberEdit editWidth = new NumberEdit();
	NumberEdit editHeight = new NumberEdit();
	GroupBox groupBox2 = new GroupBox();
	NumberEdit numberEditMRight = new NumberEdit();
	NumberEdit numberEditMLeft = new NumberEdit();
	ComboBox comboBoxMTop = new ComboBox();
	ComboBox comboBoxMRight = new ComboBox();
	Label label5 = new Label();
	ComboBox comboBoxMLeft = new ComboBox();
	Label label8 = new Label();
	Label label7 = new Label();
	Label label6 = new Label();
	ComboBox comboBoxMBottom = new ComboBox();
	NumberEdit numberEditMTop = new NumberEdit();
	NumberEdit numberEditMBottom = new NumberEdit();
	GroupBox groupBox3 = new GroupBox();
	Label label9 = new Label();
	Label label10 = new Label();
	ComboBox comboBoxCWidth = new ComboBox();
	NumberEdit numberEditColumns = new NumberEdit();
	NumberEdit numberEditCWidth = new NumberEdit();
	Label label11 = new Label();
	ComboBox comboBoxCSpacing = new ComboBox();
	NumberEdit numberEditCSpacing = new NumberEdit();
	TabControl tabControl1 = new TabControl();
	TabPage tabPage1 = new TabPage();
	TabPage tabPage2 = new TabPage();
	TabPage tabPage3 = new TabPage();
	CheckBox checkBoxTitleNewPage = new CheckBox();
	CheckBox checkBoxSummaryNewPage = new CheckBox();
	Label label12 = new Label();
	ComboBox comboBoxOrientation = new ComboBox();
	Label label13 = new Label();
	ComboBox comboBoxPrintOrder = new ComboBox();
	Label label14 = new Label();
	ComboBox comboBoxWhenNoDataType = new ComboBox();
	TabPage tabPage4 = new TabPage();
	Label label15 = new Label();
	Edit editScriptlet = new Edit();
	Label label16 = new Label();
	ComboBox comboBoxEncoding = new ComboBox();

	private void initForm()
	{
		this.setText("");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_TOOLWINDOW);
		this.setClientSize(new Point(358, 354));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.setShowInTaskbar(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		groupBox1.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		groupBox1.setLocation(new Point(8, 32));
		groupBox1.setSize(new Point(268, 136));
		groupBox1.setTabIndex(1);
		groupBox1.setTabStop(false);
		groupBox1.setText("Page Size");

		label1.setLocation(new Point(76, 52));
		label1.setSize(new Point(48, 16));
		label1.setTabIndex(8);
		label1.setTabStop(false);
		label1.setText("Width:");
		label1.setTextAlign(HorizontalAlignment.RIGHT);

		label2.setLocation(new Point(8, 24));
		label2.setSize(new Point(64, 24));
		label2.setTabIndex(9);
		label2.setTabStop(false);
		label2.setText("Preset Sizes:");
		label2.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxWUnit.setLocation(new Point(180, 48));
		comboBoxWUnit.setSize(new Point(80, 21));
		comboBoxWUnit.setTabIndex(2);
		comboBoxWUnit.setText("");
		comboBoxWUnit.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxWUnit.setItems(new Object[] {
							   "pixels", 
							   "inches", 
							   "cm", 
							   "mm"});
		comboBoxWUnit.addOnSelectedIndexChanged(new EventHandler(this.comboBoxWUnit_selectedIndexChanged));

		label3.setLocation(new Point(76, 84));
		label3.setSize(new Point(48, 16));
		label3.setTabIndex(7);
		label3.setTabStop(false);
		label3.setText("Height:");
		label3.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxHUnit.setLocation(new Point(180, 80));
		comboBoxHUnit.setSize(new Point(80, 21));
		comboBoxHUnit.setTabIndex(4);
		comboBoxHUnit.setText("");
		comboBoxHUnit.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxHUnit.setItems(new Object[] {
							   "pixels", 
							   "inches", 
							   "cm", 
							   "mm"});
		comboBoxHUnit.addOnSelectedIndexChanged(new EventHandler(this.comboBoxHUnit_selectedIndexChanged));

		comboBoxSize.setLocation(new Point(76, 20));
		comboBoxSize.setSize(new Point(184, 21));
		comboBoxSize.setTabIndex(0);
		comboBoxSize.setText("");
		comboBoxSize.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxSize.setItems(new Object[] {
							  "Custom", 
							  "LETTER", 
							  "NOTE", 
							  "LEGAL", 
							  "A0 ", 
							  "A1", 
							  "A2", 
							  "A3", 
							  "A4", 
							  "A5", 
							  "A6", 
							  "A7", 
							  "A8", 
							  "A9", 
							  "A10", 
							  "B0", 
							  "B1", 
							  "B2", 
							  "B3  ", 
							  "B4", 
							  "B5", 
							  "ARCH_E", 
							  "ARCH_D", 
							  "ARCH_C", 
							  "ARCH_B", 
							  "ARCH_A", 
							  "FLSA", 
							  "FLSE", 
							  "HALFLETTER", 
							  "11x17", 
							  "LEDGER "});
		comboBoxSize.addOnSelectedIndexChanged(new EventHandler(this.comboBoxSize_selectedIndexChanged));

		editName.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		editName.setLocation(new Point(80, 8));
		editName.setSize(new Point(196, 20));
		editName.setTabIndex(0);
		editName.setText("Untitled-1");
		editName.addOnTextChanged(new EventHandler(this.editName_textChanged));

		label4.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		label4.setLocation(new Point(4, 12));
		label4.setSize(new Point(72, 16));
		label4.setTabIndex(5);
		label4.setTabStop(false);
		label4.setText("Report name:");
		label4.setTextAlign(HorizontalAlignment.RIGHT);

		buttonOK.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		buttonOK.setLocation(new Point(284, 8));
		buttonOK.setSize(new Point(68, 24));
		buttonOK.setTabIndex(3);
		buttonOK.setText("OK");
		buttonOK.setDialogResult(DialogResult.OK);
		buttonOK.addOnClick(new EventHandler(this.buttonOK_click));

		buttonCancel.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		buttonCancel.setLocation(new Point(284, 36));
		buttonCancel.setSize(new Point(68, 24));
		buttonCancel.setTabIndex(4);
		buttonCancel.setText("Cancel");
		buttonCancel.setDialogResult(DialogResult.CANCEL);

		editWidth.setLocation(new Point(128, 48));
		editWidth.setSize(new Point(48, 20));
		editWidth.setTabIndex(1);
		editWidth.setText("0");
		editWidth.setTextAlign(HorizontalAlignment.RIGHT);
		editWidth.setIsDouble(false);
		editWidth.setDecimals(0);
		editWidth.setValue(0.0d);
		editWidth.setViewPlus(false);
		editWidth.setSeparatoreMigliaia(true);
		editWidth.addOnValueChanged(new EventHandler(this.editWidth_valueChanged));

		editHeight.setLocation(new Point(128, 80));
		editHeight.setSize(new Point(48, 20));
		editHeight.setTabIndex(3);
		editHeight.setText("0");
		editHeight.setTextAlign(HorizontalAlignment.RIGHT);
		editHeight.setIsDouble(false);
		editHeight.setDecimals(0);
		editHeight.setValue(0.0d);
		editHeight.setViewPlus(false);
		editHeight.setSeparatoreMigliaia(true);
		editHeight.addOnValueChanged(new EventHandler(this.editHeight_valueChanged));

		groupBox2.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		groupBox2.setLocation(new Point(4, 4));
		groupBox2.setSize(new Point(252, 140));
		groupBox2.setTabIndex(0);
		groupBox2.setTabStop(false);
		groupBox2.setText("Page Margin");

		numberEditMRight.setLocation(new Point(104, 92));
		numberEditMRight.setSize(new Point(48, 20));
		numberEditMRight.setTabIndex(6);
		numberEditMRight.setText("0");
		numberEditMRight.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditMRight.setIsDouble(false);
		numberEditMRight.setDecimals(0);
		numberEditMRight.setValue(0.0d);
		numberEditMRight.setViewPlus(false);
		numberEditMRight.setSeparatoreMigliaia(true);
		numberEditMRight.addOnValueChanged(new EventHandler(this.numberEditMRight_valueChanged));

		numberEditMLeft.setLocation(new Point(104, 68));
		numberEditMLeft.setSize(new Point(48, 20));
		numberEditMLeft.setTabIndex(4);
		numberEditMLeft.setText("0");
		numberEditMLeft.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditMLeft.setIsDouble(false);
		numberEditMLeft.setDecimals(0);
		numberEditMLeft.setValue(0.0d);
		numberEditMLeft.setViewPlus(false);
		numberEditMLeft.setSeparatoreMigliaia(true);
		numberEditMLeft.addOnValueChanged(new EventHandler(this.numberEditMLeft_valueChanged));

		comboBoxMTop.setLocation(new Point(156, 16));
		comboBoxMTop.setSize(new Point(80, 21));
		comboBoxMTop.setTabIndex(1);
		comboBoxMTop.setText("");
		comboBoxMTop.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxMTop.setItems(new Object[] {
							  "pixels", 
							  "inches", 
							  "cm", 
							  "mm"});
		comboBoxMTop.addOnSelectedIndexChanged(new EventHandler(this.comboBoxMTop_selectedIndexChanged));

		comboBoxMRight.setLocation(new Point(156, 92));
		comboBoxMRight.setSize(new Point(80, 21));
		comboBoxMRight.setTabIndex(7);
		comboBoxMRight.setText("");
		comboBoxMRight.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxMRight.setItems(new Object[] {
								"pixels", 
								"inches", 
								"cm", 
								"mm"});
		comboBoxMRight.addOnSelectedIndexChanged(new EventHandler(this.comboBoxMRight_selectedIndexChanged));

		label5.setLocation(new Point(52, 96));
		label5.setSize(new Point(48, 16));
		label5.setTabIndex(8);
		label5.setTabStop(false);
		label5.setText("Right:");
		label5.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxMLeft.setLocation(new Point(156, 68));
		comboBoxMLeft.setSize(new Point(80, 21));
		comboBoxMLeft.setTabIndex(5);
		comboBoxMLeft.setText("");
		comboBoxMLeft.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxMLeft.setItems(new Object[] {
							   "pixels", 
							   "inches", 
							   "cm", 
							   "mm"});
		comboBoxMLeft.addOnSelectedIndexChanged(new EventHandler(this.comboBoxMLeft_selectedIndexChanged));

		label8.setLocation(new Point(52, 20));
		label8.setSize(new Point(48, 16));
		label8.setTabIndex(11);
		label8.setTabStop(false);
		label8.setText("Top:");
		label8.setTextAlign(HorizontalAlignment.RIGHT);

		label7.setLocation(new Point(52, 72));
		label7.setSize(new Point(48, 16));
		label7.setTabIndex(9);
		label7.setTabStop(false);
		label7.setText("Left:");
		label7.setTextAlign(HorizontalAlignment.RIGHT);

		label6.setLocation(new Point(52, 44));
		label6.setSize(new Point(48, 16));
		label6.setTabIndex(10);
		label6.setTabStop(false);
		label6.setText("Bottom:");
		label6.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxMBottom.setLocation(new Point(156, 40));
		comboBoxMBottom.setSize(new Point(80, 21));
		comboBoxMBottom.setTabIndex(3);
		comboBoxMBottom.setText("");
		comboBoxMBottom.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxMBottom.setItems(new Object[] {
								 "pixels", 
								 "inches", 
								 "cm", 
								 "mm"});
		comboBoxMBottom.addOnSelectedIndexChanged(new EventHandler(this.comboBoxMBottom_selectedIndexChanged));

		numberEditMTop.setLocation(new Point(104, 16));
		numberEditMTop.setSize(new Point(48, 20));
		numberEditMTop.setTabIndex(0);
		numberEditMTop.setText("0");
		numberEditMTop.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditMTop.setIsDouble(false);
		numberEditMTop.setDecimals(0);
		numberEditMTop.setValue(0.0d);
		numberEditMTop.setViewPlus(false);
		numberEditMTop.setSeparatoreMigliaia(true);
		numberEditMTop.addOnValueChanged(new EventHandler(this.numberEditMTop_valueChanged));

		numberEditMBottom.setLocation(new Point(104, 40));
		numberEditMBottom.setSize(new Point(48, 20));
		numberEditMBottom.setTabIndex(2);
		numberEditMBottom.setText("0");
		numberEditMBottom.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditMBottom.setIsDouble(false);
		numberEditMBottom.setDecimals(0);
		numberEditMBottom.setValue(0.0d);
		numberEditMBottom.setViewPlus(false);
		numberEditMBottom.setSeparatoreMigliaia(true);
		numberEditMBottom.addOnValueChanged(new EventHandler(this.numberEditMBottom_valueChanged));

		groupBox3.setFont(new Font("MS Shell Dlg", 12.0f, FontSize.CHARACTERHEIGHT, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		groupBox3.setLocation(new Point(4, 4));
		groupBox3.setSize(new Point(252, 140));
		groupBox3.setTabIndex(0);
		groupBox3.setTabStop(false);
		groupBox3.setText("Columns");

		label9.setLocation(new Point(56, 20));
		label9.setSize(new Point(48, 16));
		label9.setTabIndex(5);
		label9.setTabStop(false);
		label9.setText("Columns:");
		label9.setTextAlign(HorizontalAlignment.RIGHT);

		label10.setLocation(new Point(56, 44));
		label10.setSize(new Point(48, 16));
		label10.setTabIndex(6);
		label10.setTabStop(false);
		label10.setText("Width:");
		label10.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxCWidth.setLocation(new Point(160, 40));
		comboBoxCWidth.setSize(new Point(80, 21));
		comboBoxCWidth.setTabIndex(2);
		comboBoxCWidth.setText("");
		comboBoxCWidth.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxCWidth.setItems(new Object[] {
								"pixels", 
								"inches", 
								"cm", 
								"mm"});
		comboBoxCWidth.addOnSelectedIndexChanged(new EventHandler(this.comboBoxCWidth_selectedIndexChanged));

		numberEditColumns.setLocation(new Point(108, 16));
		numberEditColumns.setSize(new Point(36, 20));
		numberEditColumns.setTabIndex(0);
		numberEditColumns.setText("0");
		numberEditColumns.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditColumns.setIsDouble(false);
		numberEditColumns.setDecimals(0);
		numberEditColumns.setValue(0.0d);
		numberEditColumns.setViewPlus(false);
		numberEditColumns.setSeparatoreMigliaia(true);
		numberEditColumns.addOnValueChanged(new EventHandler(this.numberEditColumns_valueChanged));

		numberEditCWidth.setLocation(new Point(108, 40));
		numberEditCWidth.setSize(new Point(48, 20));
		numberEditCWidth.setTabIndex(1);
		numberEditCWidth.setText("0");
		numberEditCWidth.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditCWidth.setIsDouble(false);
		numberEditCWidth.setDecimals(0);
		numberEditCWidth.setValue(0.0d);
		numberEditCWidth.setViewPlus(false);
		numberEditCWidth.setSeparatoreMigliaia(true);
		numberEditCWidth.addOnValueChanged(new EventHandler(this.numberEditCWidth_valueChanged));

		label11.setLocation(new Point(56, 72));
		label11.setSize(new Point(48, 16));
		label11.setTabIndex(7);
		label11.setTabStop(false);
		label11.setText("Spacing:");
		label11.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxCSpacing.setLocation(new Point(160, 68));
		comboBoxCSpacing.setSize(new Point(80, 21));
		comboBoxCSpacing.setTabIndex(4);
		comboBoxCSpacing.setText("");
		comboBoxCSpacing.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxCSpacing.setItems(new Object[] {
								  "pixels", 
								  "inches", 
								  "cm", 
								  "mm"});
		comboBoxCSpacing.addOnSelectedIndexChanged(new EventHandler(this.comboBoxCSpacing_selectedIndexChanged));

		numberEditCSpacing.setLocation(new Point(108, 68));
		numberEditCSpacing.setSize(new Point(48, 20));
		numberEditCSpacing.setTabIndex(3);
		numberEditCSpacing.setText("0");
		numberEditCSpacing.setTextAlign(HorizontalAlignment.RIGHT);
		numberEditCSpacing.setIsDouble(false);
		numberEditCSpacing.setDecimals(0);
		numberEditCSpacing.setValue(0.0d);
		numberEditCSpacing.setViewPlus(false);
		numberEditCSpacing.setSeparatoreMigliaia(true);
		numberEditCSpacing.addOnValueChanged(new EventHandler(this.numberEditCSpacing_valueChanged));

		tabControl1.setLocation(new Point(8, 176));
		tabControl1.setSize(new Point(268, 176));
		tabControl1.setTabIndex(2);
		tabControl1.setText("tabControl1");
		tabControl1.setSelectedIndex(3);

		tabPage1.setLocation(new Point(4, 25));
		tabPage1.setSize(new Point(260, 147));
		tabPage1.setTabIndex(0);
		tabPage1.setText("Page Margin");

		tabPage2.setLocation(new Point(4, 25));
		tabPage2.setSize(new Point(260, 147));
		tabPage2.setTabIndex(1);
		tabPage2.setText("Columns");

		tabPage3.setLocation(new Point(4, 25));
		tabPage3.setSize(new Point(260, 147));
		tabPage3.setTabIndex(3);
		tabPage3.setText("More...");

		checkBoxTitleNewPage.setLocation(new Point(12, 8));
		checkBoxTitleNewPage.setSize(new Point(116, 23));
		checkBoxTitleNewPage.setTabIndex(0);
		checkBoxTitleNewPage.setText("Title on a new page");
		checkBoxTitleNewPage.addOnClick(new EventHandler(this.checkBoxTitleNewPage_click));

		checkBoxSummaryNewPage.setLocation(new Point(12, 28));
		checkBoxSummaryNewPage.setSize(new Point(148, 23));
		checkBoxSummaryNewPage.setTabIndex(1);
		checkBoxSummaryNewPage.setText("Summary on a new page");
		checkBoxSummaryNewPage.addOnClick(new EventHandler(this.checkBoxSummaryNewPage_click));

		label12.setLocation(new Point(64, 112));
		label12.setSize(new Point(60, 16));
		label12.setTabIndex(6);
		label12.setTabStop(false);
		label12.setText("Orientation:");
		label12.setTextAlign(HorizontalAlignment.RIGHT);

		comboBoxOrientation.setLocation(new Point(128, 108));
		comboBoxOrientation.setSize(new Point(132, 21));
		comboBoxOrientation.setTabIndex(5);
		comboBoxOrientation.setText("");
		comboBoxOrientation.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxOrientation.setItems(new Object[] {
									 "Portrait", 
									 "Landscape"});
		comboBoxOrientation.addOnSelectedIndexChanged(new EventHandler(this.comboBoxOrientation_selectedIndexChanged));

		label13.setLocation(new Point(8, 52));
		label13.setSize(new Point(100, 16));
		label13.setTabIndex(7);
		label13.setTabStop(false);
		label13.setText("Print order");

		comboBoxPrintOrder.setLocation(new Point(112, 48));
		comboBoxPrintOrder.setSize(new Point(140, 21));
		comboBoxPrintOrder.setTabIndex(2);
		comboBoxPrintOrder.setText("");
		comboBoxPrintOrder.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxPrintOrder.setItems(new Object[] {
									"Vertical", 
									"Horizontal"});
		comboBoxPrintOrder.addOnSelectedIndexChanged(new EventHandler(this.comboBoxPrintOrder_selectedIndexChanged));

		label14.setLocation(new Point(8, 76));
		label14.setSize(new Point(100, 16));
		label14.setTabIndex(6);
		label14.setTabStop(false);
		label14.setText("When no data type...");

		comboBoxWhenNoDataType.setLocation(new Point(112, 72));
		comboBoxWhenNoDataType.setSize(new Point(140, 21));
		comboBoxWhenNoDataType.setTabIndex(3);
		comboBoxWhenNoDataType.setText("");
		comboBoxWhenNoDataType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxWhenNoDataType.setItems(new Object[] {
										"NoPages", 
										"BlankPage", 
										"AllSectionsNoDetail"});
		comboBoxWhenNoDataType.addOnSelectedIndexChanged(new EventHandler(this.comboBoxWhenNoDataType_selectedIndexChanged));

		tabPage4.setLocation(new Point(4, 25));
		tabPage4.setSize(new Point(260, 147));
		tabPage4.setTabIndex(2);
		tabPage4.setText("Scriptlet");

		label15.setLocation(new Point(8, 12));
		label15.setSize(new Point(108, 16));
		label15.setTabIndex(1);
		label15.setTabStop(false);
		label15.setText("Scriptlet class");

		editScriptlet.setLocation(new Point(8, 28));
		editScriptlet.setSize(new Point(240, 20));
		editScriptlet.setTabIndex(0);
		editScriptlet.setText("");
		editScriptlet.addOnTextChanged(new EventHandler(this.editScriptlet_textChanged));

		label16.setLocation(new Point(8, 108));
		label16.setSize(new Point(100, 16));
		label16.setTabIndex(4);
		label16.setTabStop(false);
		label16.setText("XML encoding");

		comboBoxEncoding.setLocation(new Point(112, 104));
		comboBoxEncoding.setSize(new Point(140, 21));
		comboBoxEncoding.setTabIndex(5);
		comboBoxEncoding.setText("");
		comboBoxEncoding.setItems(new Object[] {
								  "ISO-8859-1", 
								  "UTF-8"});
		comboBoxEncoding.addOnSelectedIndexChanged(new EventHandler(this.comboBoxEncoding_selectedIndexChanged));

		this.setNewControls(new Control[] {
							tabControl1, 
							buttonCancel, 
							buttonOK, 
							label4, 
							editName, 
							groupBox1});
		groupBox1.setNewControls(new Control[] {
								 comboBoxOrientation, 
								 label12, 
								 editHeight, 
								 editWidth, 
								 comboBoxSize, 
								 comboBoxHUnit, 
								 label3, 
								 comboBoxWUnit, 
								 label2, 
								 label1});
		groupBox2.setNewControls(new Control[] {
								 numberEditMRight, 
								 numberEditMLeft, 
								 comboBoxMRight, 
								 label5, 
								 comboBoxMLeft, 
								 label7, 
								 numberEditMBottom, 
								 numberEditMTop, 
								 comboBoxMBottom, 
								 label6, 
								 comboBoxMTop, 
								 label8});
		groupBox3.setNewControls(new Control[] {
								 label9, 
								 label10, 
								 comboBoxCWidth, 
								 numberEditColumns, 
								 numberEditCWidth, 
								 label11, 
								 comboBoxCSpacing, 
								 numberEditCSpacing});
		tabControl1.setNewControls(new Control[] {
								   tabPage1, 
								   tabPage2, 
								   tabPage4, 
								   tabPage3});
		tabPage1.setNewControls(new Control[] {
								groupBox2});
		tabPage2.setNewControls(new Control[] {
								groupBox3});
		tabPage3.setNewControls(new Control[] {
								comboBoxEncoding, 
								label16, 
								comboBoxWhenNoDataType, 
								label14, 
								comboBoxPrintOrder, 
								label13, 
								checkBoxSummaryNewPage, 
								checkBoxTitleNewPage});
		tabPage4.setNewControls(new Control[] {
								editScriptlet, 
								label15});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ReportPropertiesForm(null));
	}
}
