package com.businesslogic.ireport.ui;

import com.businesslogic.ireport.*;
import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;

import java.util.*;

/**
 * Questa classe pu accettare un numero variabile di parametri sulla riga
 * di comando. L'esecuzione del programma inizia con il metodo main(). Il costruttore
 * della classe non viene richiamato fino a quando un oggetto di tipo "ReportWizardForm"
 * non viene creato nel metodo main().
 */
public class ReportWizardForm extends Form
{
	Panel[] panels;
	int active_status=0;
	MainForm mf=null;
	
	
	public ReportWizardForm(MainForm mf)
	{
		super();

		// Necessario per il supporto della finestra di progettazione form di Visual J++
		initForm();		
		
		this.mf = mf;
		
		panels = new Panel[5];
		
		panels[0] = panel1;
		panels[1] = panel2;
		panels[2] = panel3;
		panels[3] = panel4;
		panels[4] = panel5;
		
		setStatus(active_status=0, -1);
		
		// Load templates...
		
		//MessageBox.show(filenames.length +" "+this.mf.programDir+" --- "+com.ms.wfc.io.File.combine(  mf.programDir, "templates"));
		
		comboBoxLayoutType.setSelectedIndex(0);
	}
	
	public void setLayoutImage()
	{
		String filename = com.ms.wfc.io.File.combine(  mf.programDir, "templates\\" + this.listBoxLayouts.getSelectedItem()  + ((comboBoxLayoutType.getSelectedIndex()==0) ? "C" :"T") + ".gif");
		if (com.ms.wfc.io.File.exists(filename ))
		{
			Bitmap bmp = new Bitmap(filename); 
			if (bmp != null)
			{
				this.pictureBoxLayout.setImage(bmp);
			}
		}
		else
			this.pictureBoxLayout.setImage(null);
	}
	
	
	public void setPanel(int num_panel)
	{
		for (int i=0; i<panels.length ; ++i)
		{
			panels[i].setVisible( i == num_panel);
		}
	}

	/**
	 * ReportWizardForm esegue l'overriding di dispose e quindi pu svuotare
	 * l'elenco dei componenti.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
	}

	private void button1_click(Object source, Event e)
	{
		int prev_status = active_status;
		if (active_status<4)
		{
			active_status++;
		}
		else
		{
			if (comboBoxLayoutType.getSelectedIndex()==1 && createReportTabular()!=null)
			{
				this.dispose();
			}
			else if (comboBoxLayoutType.getSelectedIndex()==0 && createReportColumnar()!=null)
			{
				this.dispose();
			}
		}
		setStatus(active_status,prev_status);
	}

	public void fillConnectionCombo(Vector v)
	{
		if (v == null) return;
		Enumeration enum = v.elements();
		while (enum.hasMoreElements())
		{
			comboBoxConnections.addItem( enum.nextElement() );
		}
		
		if (comboBoxConnections.getItemCount()>0)
			comboBoxConnections.setSelectedIndex(0);
	}
	
	private void button3_click(Object source, Event e)
	{
		int prev_status = active_status;
		if (active_status>0)
		{
			active_status--;
			setStatus(active_status,prev_status);
		}	
	}
	
	/**************************************************************
	 * SET STATUS....
	 */ 
	public void setStatus(int new_status, int prev_status)
	{
		switch (new_status)
		{
			case 0:
			{
				this.button3.setEnabled(false);
				if (comboBoxConnections.getSelectedIndex()>=0 &&
					editQuery.getText().trim().length()>0)
					this.button1.setEnabled(true);
				else
					this.button1.setEnabled(false);
				setPanel(0);
				active_status = 0;
			}
			break;
			case 1:
			{
				// try retrive fields...
				if (prev_status == 2 || retriveFields())
				{
					this.button3.setEnabled(true);
					if (listBoxSelectedFields.getItemCount()>0)
						this.button1.setEnabled(true);
					else
						this.button1.setEnabled(false);
					setPanel(1);
					active_status = 1;
				}
				else
					active_status = prev_status;
					
			}
			break;
			case 2:
			{
				// try retrive fields...
				intiPanel3();
				this.button3.setEnabled(true);
				this.button1.setEnabled(true);
				setPanel(2);
				active_status = 2;
			}
			break;
			case 3:
			{
				// try retrive fields...
				this.button3.setEnabled(true);
				this.button1.setEnabled(true);
				setPanel(3);
				active_status = 3;
			}
			break;
			case 4:
			{
				// try retrive fields...
				this.button3.setEnabled(true);
				this.button1.setEnabled(true);
				setPanel(4);
				active_status = 4;
			}
			break;
			
		}
	}

	private void comboBoxConnections_selectedIndexChanged(Object source, Event e)
	{
		if (comboBoxConnections.getSelectedIndex()>=0 &&
					editQuery.getText().trim().length()>0)
					this.button1.setEnabled(true);
				else
					this.button1.setEnabled(false);
	}

	private void editQuery_textChanged(Object source, Event e)
	{
		if (comboBoxConnections.getSelectedIndex()>=0 &&
					editQuery.getText().trim().length()>0)
					this.button1.setEnabled(true);
				else
					this.button1.setEnabled(false);
	}
	
	public boolean retriveFields()
	{
	
		ConnectionEntry ce = (ConnectionEntry)comboBoxConnections.getSelectedItem(); 
		String password = ce.password;
		if (password == null || password.trim().length() == 0)
		{
			PasswordForm pf = new PasswordForm();
			pf.setUsername(ce.username);
			if (pf.showDialog() == DialogResult.OK)
			{
				password = pf.getPassword();	
			}
			else
				return false;
		}
			
		ElaborationForm ef = new ElaborationForm( this.mf );
		ef.setConnectionEntry(ce);
		ef.setPassword(password);
		ef.setQuery(editQuery.getText());
		if (ef.showDialog() == DialogResult.OK)
		{
			
			this.listBoxQueryFields.removeAll();
			this.listBoxSelectedFields.removeAll();
			
			Vector v = ef.getFields();
			Enumeration enum = v.elements();
			while (enum.hasMoreElements())
			{
				JRField f = (JRField)enum.nextElement();
				listBoxQueryFields.addItem(f);
			}
			return true;
		}
		return false;
	}

	private void button4_click(Object source, Event e)
	{
		if (listBoxQueryFields.getSelectedIndex() >= 0)
		{
			int i = listBoxQueryFields.getSelectedIndex();
			Object obj = listBoxQueryFields.getSelectedItem();
			listBoxSelectedFields.addItem(obj);
			listBoxQueryFields.removeItem(obj);
			if (listBoxQueryFields.getItemCount()>i)
				listBoxQueryFields.setSelectedIndex(i);
			else if (listBoxQueryFields.getItemCount()>0)
				listBoxQueryFields.setSelectedIndex(0);
		}
		
		if (listBoxSelectedFields.getItemCount()>0)
			this.button1.setEnabled(true);
		else
			this.button1.setEnabled(false);
	}

	private void button5_click(Object source, Event e)
	{
		if (listBoxSelectedFields.getSelectedIndex() >= 0)
		{
			
			Object obj = listBoxSelectedFields.getSelectedItem();
			listBoxQueryFields.addItem(obj);
			listBoxSelectedFields.removeItem(obj);
		}
		if (listBoxSelectedFields.getItemCount()>0)
			this.button1.setEnabled(true);
		else
			this.button1.setEnabled(false);
	}

	private void button6_click(Object source, Event e)
	{
		while ( listBoxQueryFields.getItemCount() > 0 )
		{
			Object obj = listBoxQueryFields.getItem(0);
			listBoxSelectedFields.addItem(obj);
			listBoxQueryFields.removeItem(0);
		}
		if (listBoxSelectedFields.getItemCount()>0)
			this.button1.setEnabled(true);
		else
			this.button1.setEnabled(false);
	}

	private void button7_click(Object source, Event e)
	{
		while ( listBoxSelectedFields.getItemCount() > 0 )
		{
			Object obj = listBoxSelectedFields.getItem(0);
			listBoxQueryFields.addItem(obj);
			listBoxSelectedFields.removeItem(0);
		}
		if (listBoxSelectedFields.getItemCount()>0)
			this.button1.setEnabled(true);
		else
			this.button1.setEnabled(false);
	}
	
	public void intiPanel3()
	{
		comboBoxG1.removeAll();
		setGroupComboEnabled(2, false);

		comboBoxG1.addItem("");
		comboBoxG1.setSelectedIndex(0);
		for (int i=0; i<this.listBoxSelectedFields.getItemCount(); ++i)
		{
			comboBoxG1.addItem(listBoxSelectedFields.getItem(i));
		}
	}
	
	void setGroupComboEnabled(int i, boolean b)
	{
		switch (i)
		{
			case 2:
				comboBoxG2.setEnabled(b);
				if (!b) comboBoxG2.removeAll();
				else setGroupComboItems(i);
				labelG2.setEnabled(b);
				comboBoxG2.setBackColor((b)? Color.WINDOW : Color.INACTIVEBORDER); 
				if (b) break;
			case 3:
				comboBoxG3.setEnabled(b);
				if (!b) comboBoxG3.removeAll();
				else setGroupComboItems(i);
				labelG3.setEnabled(b);
				comboBoxG3.setBackColor((b)? Color.WINDOW : Color.INACTIVEBORDER); 
				if (b) break;
			case 4:
				comboBoxG4.setEnabled(b);
				if (!b) comboBoxG4.removeAll();
				else setGroupComboItems(i);
				labelG4.setEnabled(b);
				comboBoxG4.setBackColor((b)? Color.WINDOW : Color.INACTIVEBORDER); 
				if (b) break;
		}
	}
	
	void setGroupComboItems(int combo)
	{
		int i=0;
		switch (combo)
		{
			case 2:
				comboBoxG2.removeAll();
				comboBoxG2.addItem("");
				for ( i=0; i<this.listBoxSelectedFields.getItemCount(); ++i)
				{
					if (comboBoxG1.getSelectedItem() != listBoxSelectedFields.getItem(i))
					comboBoxG2.addItem(listBoxSelectedFields.getItem(i));
				}
				break;
			case 3:
				comboBoxG3.removeAll();
				comboBoxG3.addItem("");
				for ( i=0; i<this.listBoxSelectedFields.getItemCount(); ++i)
				{
					if (comboBoxG1.getSelectedItem() != listBoxSelectedFields.getItem(i) &&
						comboBoxG2.getSelectedItem() != listBoxSelectedFields.getItem(i))
					comboBoxG3.addItem(listBoxSelectedFields.getItem(i));
				}
				break;
			case 4:
				comboBoxG4.removeAll();
				comboBoxG4.addItem("");
				for ( i=0; i<this.listBoxSelectedFields.getItemCount(); ++i)
				{
					if (comboBoxG1.getSelectedItem() != listBoxSelectedFields.getItem(i) &&
						comboBoxG2.getSelectedItem() != listBoxSelectedFields.getItem(i) &&
						comboBoxG3.getSelectedItem() != listBoxSelectedFields.getItem(i))
					comboBoxG4.addItem(listBoxSelectedFields.getItem(i));
				}
				break;
		}
	}

	private void comboBoxG1_selectedIndexChanged(Object source, Event e)
	{
		if (comboBoxG1.getSelectedIndex() == 0)
			setGroupComboEnabled(2,false);
		else
			setGroupComboEnabled(2,true);
	}

	private void comboBoxG2_selectedIndexChanged(Object source, Event e)
	{
		if (comboBoxG2.getSelectedIndex() == 0)
			setGroupComboEnabled(3,false);
		else
			setGroupComboEnabled(3,true);
	}

	private void comboBoxG3_selectedIndexChanged(Object source, Event e)
	{
		if (comboBoxG3.getSelectedIndex() == 0)
			setGroupComboEnabled(4,false);
		else
			setGroupComboEnabled(4,true);
	}

	private void comboBoxG4_selectedIndexChanged(Object source, Event e)
	{

	}

	private void listBoxLayouts_selectedIndexChanged(Object source, Event e)
	{
		setLayoutImage();
	}
	
	public ReportForm createReportTabular()
	{
			String filename = com.ms.wfc.io.File.combine(  mf.programDir, "templates\\" + this.listBoxLayouts.getSelectedItem()  + "T.xml");
			this.setCursor(Cursor.WAIT);
			try {
				java.io.FileInputStream fis = new java.io.FileInputStream(filename);
				// Modify intestation...
				String xml_file  = "";
				byte[] buffer = new byte[1024*512];
				int dim=0;
				while ((dim = fis.read(buffer))>0)
				{
					xml_file += new String(buffer,0,dim);
				}
				fis.close();
				// Strip <!DOCTYPE...> directive....
				int begin = xml_file.indexOf("<!DOCTYPE");
				if (begin > -1)
				{
					int end  = xml_file.substring(begin+1).indexOf(">");
				
					xml_file = xml_file.substring(0,begin)+xml_file.substring(begin+end+2);
					//MessageBox.show(xml_file.substring(0,300));
				}
				
				java.io.StringBufferInputStream sbis = new java.io.StringBufferInputStream(xml_file);
				
				com.ms.xml.om.Document doc = new com.ms.xml.om.Document();
				doc.load( sbis);
				//loadXMLTree(doc);	
				Report r = new Report(doc,null);
				r.setReportName( mf.getUntitledName());
				
				/*  Begin Processing... */
				
				//2. Fing detail band...
				Band detail=null;
				Band columns=null;
				
				Enumeration enum = r.bands.elements();
				while (enum.hasMoreElements())
				{
					Band band = (Band)enum.nextElement();
					if (band.name.equals("detail"))
					{
						detail = band;
					}
					else if (band.name.equals("columnHeader"))
					{
						columns = band;
					}
				}
				
				// 1. Normalize position to band...
				enum = r.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					rElement.trasform(new Point(0,- r.getBandYLocation( rElement.band )),TransformationType.TRANSFORMATION_MOVE );  
				}
				//1. Adding groups...
				if (this.comboBoxG1.getSelectedIndex() > 0)
				{
					Group g = r.getGroupByName("Group1");
					Group g1 = new Group( r, ""+comboBoxG1.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
					g1.groupExpression = "$F{"+ comboBoxG1.getSelectedItem() + "}";
					r.addGroup(g1);
					
					// Add to g1 all elements attached to g.header and g.footer...
					enum = r.getElements().elements();
					while (enum.hasMoreElements())
					{
						ReportElement rElement = (ReportElement)enum.nextElement();
						if (rElement.band == g.groupHeader)
							rElement.band = g1.groupHeader;
						else if (rElement.band == g.groupFooter)
							rElement.band = g1.groupFooter;
						
						// Set text to Group1 label...
						if (rElement instanceof StaticTextReportElement)
						{
							StaticTextReportElement stre = (StaticTextReportElement)rElement;
							if (stre.text.equals("G1Label"))
								stre.text =  ""+comboBoxG1.getSelectedItem();
						}
						else if (rElement instanceof TextFieldReportElement)
						{
							TextFieldReportElement tfre = (TextFieldReportElement)rElement;
							if (tfre.text.equals("G1Field"))
								tfre.text =  "$F{"+comboBoxG1.getSelectedItem()+"}";
						}
					}
				}
				
				// Group 2...
				if (this.comboBoxG2.getSelectedIndex()> 0)
				{
					Group g = r.getGroupByName("Group2");
					if (g != null)
					{
						Group g2 = new Group(r, ""+comboBoxG2.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
						g2.groupExpression = "$F{"+ comboBoxG2.getSelectedItem() + "}";
						r.addGroup(g2);
						
						// Add to g2 all elements attached to g.header and g.footer...
						enum = r.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement rElement = (ReportElement)enum.nextElement();
							if (rElement.band == g.groupHeader)
								rElement.band = g2.groupHeader;
							else if (rElement.band == g.groupFooter)
								rElement.band = g2.groupFooter;
							
							// Set text to Group1 label...
							if (rElement instanceof StaticTextReportElement)
							{
								StaticTextReportElement stre = (StaticTextReportElement)rElement;
								if (stre.text.equals("G2Label"))
									stre.text =  ""+comboBoxG2.getSelectedItem();
							}
							else if (rElement instanceof TextFieldReportElement)
							{
								TextFieldReportElement tfre = (TextFieldReportElement)rElement;
								if (tfre.text.equals("G2Field"))
									tfre.text =  "$F{"+comboBoxG2.getSelectedItem()+"}";
							}
						}
					}
				}
				
				
				// Group 3...
				if (this.comboBoxG3.getSelectedIndex() > 0)
				{
					Group g = r.getGroupByName("Group3");
					if (g != null)
					{
						Group g3 = new Group(r, ""+comboBoxG3.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
						g3.groupExpression = "$F{"+ comboBoxG3.getSelectedItem() + "}";
						r.addGroup(g3);
						
						// Add to g3 all elements attached to g.header and g.footer...
						enum = r.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement rElement = (ReportElement)enum.nextElement();
							if (rElement.band == g.groupHeader)
								rElement.band = g3.groupHeader;
							else if (rElement.band == g.groupFooter)
								rElement.band = g3.groupFooter;
							
							// Set text to Group1 label...
							if (rElement instanceof StaticTextReportElement)
							{
								StaticTextReportElement stre = (StaticTextReportElement)rElement;
								if (stre.text.equals("G3Label"))
									stre.text =  ""+comboBoxG3.getSelectedItem();
							}
							else if (rElement instanceof TextFieldReportElement)
							{
								TextFieldReportElement tfre = (TextFieldReportElement)rElement;
								if (tfre.text.equals("G3Field"))
									tfre.text =  "$F{"+comboBoxG3.getSelectedItem()+"}";
							}
						}
					}
				}
				
				// Group 4...
				if (this.comboBoxG4.getSelectedIndex() > 0)
				{
					Group g = r.getGroupByName("Group4");
					if (g != null)
					{
						Group g4 = new Group( r, ""+comboBoxG4.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
						g4.groupExpression = "$F{"+ comboBoxG4.getSelectedItem() + "}";
						r.addGroup(g4);
						
						// Add to g4 all elements attached to g.header and g.footer...
						enum = r.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement rElement = (ReportElement)enum.nextElement();
							if (rElement.band == g.groupHeader)
								rElement.band = g4.groupHeader;
							else if (rElement.band == g.groupFooter)
								rElement.band = g4.groupFooter;
							
							// Set text to Group1 label...
							if (rElement instanceof StaticTextReportElement)
							{
								StaticTextReportElement stre = (StaticTextReportElement)rElement;
								if (stre.text.equals("G4Label"))
									stre.text =  ""+comboBoxG4.getSelectedItem();
							}
							else if (rElement instanceof TextFieldReportElement)
							{
								TextFieldReportElement tfre = (TextFieldReportElement)rElement;
								if (tfre.text.equals("G4Field"))
									tfre.text =  "$F{"+comboBoxG4.getSelectedItem()+"}";
							}
						}
					}
				}
				
				//1. Adding fields...
				int currentx = r.leftMargin+10;
				int currenty = 10;
				
				enum = r.getElements().elements();
				StaticTextReportElement detailLabel = null;
				TextFieldReportElement detailField = null;
				while (enum.hasMoreElements() && (detailLabel==null || detailField == null) )
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					if (rElement instanceof StaticTextReportElement)
					{
						StaticTextReportElement stre = (StaticTextReportElement)rElement;
						if (stre.text.equalsIgnoreCase("DetailLabel"))
							detailLabel =stre;
					}
					else if (rElement instanceof TextFieldReportElement)
					{
							TextFieldReportElement tfre = (TextFieldReportElement)rElement;
							if (tfre.text.equalsIgnoreCase("DetailField"))
								detailField = tfre;
					}
				}
				if (detailField != null)
				r.getElements().removeElement(detailField);
				if (detailLabel != null)
				r.getElements().removeElement(detailLabel);
	
				if (detailField == null)
					detailField = new TextFieldReportElement(0,0,100,20,null); 
				if (detailLabel == null)
					detailLabel = new StaticTextReportElement(0,0,100,18,null); 
				
				int nfields = listBoxSelectedFields.getItemCount();
				if (comboBoxG1.getSelectedIndex()>0) nfields--;
				if (comboBoxG2.getSelectedIndex()>0) nfields--;
				if (comboBoxG3.getSelectedIndex()>0) nfields--;
				if (comboBoxG4.getSelectedIndex()>0) nfields--;
				
				int fwidth = r.columnWidth/nfields;
				
				
				for (int i=0; i<listBoxSelectedFields.getItemCount(); ++i)
				{
					// FIELD
					JRField f = (JRField)listBoxSelectedFields.getItem(i);
					r.fields.addElement(f);
					
					if (comboBoxG1.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG1.getSelectedItem()))
						continue;
					if (comboBoxG2.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG2.getSelectedItem()))
						continue;
					if (comboBoxG3.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG3.getSelectedItem()))
						continue;
					if (comboBoxG4.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG4.getSelectedItem()))
						continue;
					
					TextFieldReportElement re = new TextFieldReportElement(currentx,detailField.position.y ,fwidth ,detailField.height ,null);
					re.align = detailField.align;
					re.pdfFontName = detailField.pdfFontName;
					re.fontName = detailField.fontName;
					re.size  = detailField.size;
					re.bgcolor = detailField.bgcolor;
					re.fgcolor = detailField.fgcolor;
					re.text = "$F{"+ f.name +"}";
					re.band = detail;
					re.fieldClass = f.classType;
					r.getElements().addElement(re);
					
					// COLUMN LABEL...
					StaticTextReportElement sre = new StaticTextReportElement(currentx,detailLabel.position.y ,fwidth ,detailLabel.height ,null);
					sre.align = detailLabel.align;
					sre.pdfFontName = detailLabel.pdfFontName;
					sre.fontName = detailLabel.fontName;
					sre.size  = detailLabel.size;
					sre.bgcolor = detailLabel.bgcolor;
					sre.fgcolor = detailLabel.fgcolor;
					sre.text = ""+ f.name +"";
					sre.band = columns;
					r.getElements().addElement(sre);
					
					
					currentx += fwidth;
					currentx = Math.min(r.getPagesize().x-r.rightMargin+10-30, currentx);
				}
				
				// Remove template groups...****************
				enum = r.getElements().elements();
				Vector elements_to_delete = new Vector();
				while (enum.hasMoreElements())
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					Group g = null;
					if ((g=r.getGroupByName("Group1"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
					else if ((g=r.getGroupByName("Group2"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
					else if ((g=r.getGroupByName("Group3"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
					else if ((g=r.getGroupByName("Group4"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
				}
				enum =elements_to_delete.elements();
				while (enum.hasMoreElements())
				{
					r.getElements().removeElement(enum.nextElement());
				}
				Group g;
				if ((g=r.getGroupByName("Group1"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				if ((g=r.getGroupByName("Group2"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				if ((g=r.getGroupByName("Group3"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				if ((g=r.getGroupByName("Group4"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				
				// Positioning columns band...
				if ((g=r.getGroupByName("Columns"))!=null)
				{
					r.groups.removeElement(g);
					r.bands.removeElement(g.groupHeader);
					r.bands.removeElement(g.groupFooter);
					r.addGroup(g);
					// we must adjust band position...
					
					
				}
				
				// Adjust vertical position of elements
				enum = r.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					rElement.trasform(new Point(0,+ r.getBandYLocation( rElement.band )),TransformationType.TRANSFORMATION_MOVE );
				}
				
				r.query = editQuery.getText();
				
				ReportForm rf = new ReportForm(r);
				rf.setMDIParent(mf);
				rf.show();
				rf.refreshAll();
				fis.close();
				this.setCursor(Cursor.DEFAULT);
				return rf;
			} catch (Exception ex)
			{
				this.setCursor(Cursor.DEFAULT);
				MessageBox.show(ex.getMessage());
				java.io.StringWriter s = new java.io.StringWriter();
				ex.printStackTrace(new java.io.PrintWriter(s));
				MessageBox.show(ex.getMessage()+" "+s);
				
			}
			this.setCursor(Cursor.DEFAULT);
		return null;
	}
	
	
	public ReportForm createReportColumnar()
	{
			String filename = com.ms.wfc.io.File.combine(  mf.programDir, "templates\\" + this.listBoxLayouts.getSelectedItem()  + "C.xml");
			this.setCursor(Cursor.WAIT);
			try {
				java.io.FileInputStream fis = new java.io.FileInputStream(filename);
				// Modify intestation...
				String xml_file  = "";
				byte[] buffer = new byte[1024*512];
				int dim=0;
				while ((dim = fis.read(buffer))>0)
				{
					xml_file += new String(buffer,0,dim);
				}
				fis.close();
				// Strip <!DOCTYPE...> directive....
				int begin = xml_file.indexOf("<!DOCTYPE");
				if (begin > -1)
				{
					int end  = xml_file.substring(begin+1).indexOf(">");
				
					xml_file = xml_file.substring(0,begin)+xml_file.substring(begin+end+2);
					//MessageBox.show(xml_file.substring(0,300));
				}
				
				java.io.StringBufferInputStream sbis = new java.io.StringBufferInputStream(xml_file);
				
				com.ms.xml.om.Document doc = new com.ms.xml.om.Document();
				doc.load( sbis);
				//loadXMLTree(doc);	
				Report r = new Report(doc,null);
				r.setReportName( mf.getUntitledName());
				r.encoding = doc.getEncoding();
				
				/*  Begin Processing... */
				
				//2. Fing detail band...
				Band detail=null;
				Band columns=null;
				
				Enumeration enum = r.bands.elements();
				while (enum.hasMoreElements())
				{
					Band band = (Band)enum.nextElement();
					if (band.name.equals("detail"))
					{
						detail = band;
					}
					else if (band.name.equals("columnHeader"))
					{
						columns = band;
					}
				}
				
				// 1. Normalize position to band...
				enum = r.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					rElement.trasform(new Point(0,- r.getBandYLocation( rElement.band )),TransformationType.TRANSFORMATION_MOVE );  
				}
				//1. Adding groups...
				if (this.comboBoxG1.getSelectedIndex() > 0)
				{
					Group g = r.getGroupByName("Group1");
					Group g1 = new Group( r, ""+comboBoxG1.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
					g1.groupExpression = "$F{"+ comboBoxG1.getSelectedItem() + "}";
					r.addGroup(g1);
					
					// Add to g1 all elements attached to g.header and g.footer...
					enum = r.getElements().elements();
					while (enum.hasMoreElements())
					{
						ReportElement rElement = (ReportElement)enum.nextElement();
						if (rElement.band == g.groupHeader)
							rElement.band = g1.groupHeader;
						else if (rElement.band == g.groupFooter)
							rElement.band = g1.groupFooter;
						
						// Set text to Group1 label...
						if (rElement instanceof StaticTextReportElement)
						{
							StaticTextReportElement stre = (StaticTextReportElement)rElement;
							if (stre.text.equals("G1Label"))
								stre.text =  ""+comboBoxG1.getSelectedItem();
						}
						else if (rElement instanceof TextFieldReportElement)
						{
							TextFieldReportElement tfre = (TextFieldReportElement)rElement;
							if (tfre.text.equals("G1Field"))
								tfre.text =  "$F{"+comboBoxG1.getSelectedItem()+"}";
						}
					}
				}
				
				// Group 2...
				if (this.comboBoxG2.getSelectedIndex()> 0)
				{
					Group g = r.getGroupByName("Group2");
					if (g != null)
					{
						Group g2 = new Group( r, ""+comboBoxG2.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
						g2.groupExpression = "$F{"+ comboBoxG2.getSelectedItem() + "}";
						r.addGroup(g2);
						
						// Add to g2 all elements attached to g.header and g.footer...
						enum = r.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement rElement = (ReportElement)enum.nextElement();
							if (rElement.band == g.groupHeader)
								rElement.band = g2.groupHeader;
							else if (rElement.band == g.groupFooter)
								rElement.band = g2.groupFooter;
							
							// Set text to Group1 label...
							if (rElement instanceof StaticTextReportElement)
							{
								StaticTextReportElement stre = (StaticTextReportElement)rElement;
								if (stre.text.equals("G2Label"))
									stre.text =  ""+comboBoxG2.getSelectedItem();
							}
							else if (rElement instanceof TextFieldReportElement)
							{
								TextFieldReportElement tfre = (TextFieldReportElement)rElement;
								if (tfre.text.equals("G2Field"))
									tfre.text =  "$F{"+comboBoxG2.getSelectedItem()+"}";
							}
						}
					}
				}
				
				
				// Group 3...
				if (this.comboBoxG3.getSelectedIndex() > 0)
				{
					Group g = r.getGroupByName("Group3");
					if (g != null)
					{
						Group g3 = new Group( r, ""+comboBoxG3.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
						g3.groupExpression = "$F{"+ comboBoxG3.getSelectedItem() + "}";
						r.addGroup(g3);
						
						// Add to g3 all elements attached to g.header and g.footer...
						enum = r.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement rElement = (ReportElement)enum.nextElement();
							if (rElement.band == g.groupHeader)
								rElement.band = g3.groupHeader;
							else if (rElement.band == g.groupFooter)
								rElement.band = g3.groupFooter;
							
							// Set text to Group1 label...
							if (rElement instanceof StaticTextReportElement)
							{
								StaticTextReportElement stre = (StaticTextReportElement)rElement;
								if (stre.text.equals("G3Label"))
									stre.text =  ""+comboBoxG3.getSelectedItem();
							}
							else if (rElement instanceof TextFieldReportElement)
							{
								TextFieldReportElement tfre = (TextFieldReportElement)rElement;
								if (tfre.text.equals("G3Field"))
									tfre.text =  "$F{"+comboBoxG3.getSelectedItem()+"}";
							}
						}
					}
				}
				
				// Group 4...
				if (this.comboBoxG4.getSelectedIndex() > 0)
				{
					Group g = r.getGroupByName("Group4");
					if (g != null)
					{
						Group g4 = new Group( r, ""+comboBoxG4.getSelectedItem(),  g.groupFooter.height,g.groupHeader.height);
						g4.groupExpression = "$F{"+ comboBoxG4.getSelectedItem() + "}";
						r.addGroup(g4);
						
						// Add to g4 all elements attached to g.header and g.footer...
						enum = r.getElements().elements();
						while (enum.hasMoreElements())
						{
							ReportElement rElement = (ReportElement)enum.nextElement();
							if (rElement.band == g.groupHeader)
								rElement.band = g4.groupHeader;
							else if (rElement.band == g.groupFooter)
								rElement.band = g4.groupFooter;
							
							// Set text to Group1 label...
							if (rElement instanceof StaticTextReportElement)
							{
								StaticTextReportElement stre = (StaticTextReportElement)rElement;
								if (stre.text.equals("G4Label"))
									stre.text =  ""+comboBoxG4.getSelectedItem();
							}
							else if (rElement instanceof TextFieldReportElement)
							{
								TextFieldReportElement tfre = (TextFieldReportElement)rElement;
								if (tfre.text.equals("G4Field"))
									tfre.text =  "$F{"+comboBoxG4.getSelectedItem()+"}";
							}
						}
					}
				}
				
				//1. Adding fields...
				int currentx = r.leftMargin+10;
				int currenty = 10;
				
				enum = r.getElements().elements();
				StaticTextReportElement detailLabel = null;
				TextFieldReportElement detailField = null;
				while (enum.hasMoreElements() && (detailLabel==null || detailField == null) )
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					if (rElement instanceof StaticTextReportElement)
					{
						StaticTextReportElement stre = (StaticTextReportElement)rElement;
						if (stre.text.equalsIgnoreCase("DetailLabel"))
							detailLabel =stre;
					}
					else if (rElement instanceof TextFieldReportElement)
					{
							TextFieldReportElement tfre = (TextFieldReportElement)rElement;
							if (tfre.text.equalsIgnoreCase("DetailField"))
								detailField = tfre;
					}
				}
				if (detailField != null)
				r.getElements().removeElement(detailField);
				if (detailLabel != null)
				r.getElements().removeElement(detailLabel);
	
				if (detailField == null)
					detailField = new TextFieldReportElement(0,0,100,20,null); 
				if (detailLabel == null)
					detailLabel = new StaticTextReportElement(0,0,100,18,null); 
				
				int nfields = listBoxSelectedFields.getItemCount();
				if (comboBoxG1.getSelectedIndex()>0) nfields--;
				if (comboBoxG2.getSelectedIndex()>0) nfields--;
				if (comboBoxG3.getSelectedIndex()>0) nfields--;
				if (comboBoxG4.getSelectedIndex()>0) nfields--;
				
				int fwidth = r.columnWidth/nfields;
				
				int ffheight =  detailField.position.y;
				for (int i=0; i<listBoxSelectedFields.getItemCount(); ++i)
				{
					// FIELD
					JRField f = (JRField)listBoxSelectedFields.getItem(i);
					r.fields.addElement(f);
					
					if (comboBoxG1.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG1.getSelectedItem()))
						continue;
					if (comboBoxG2.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG2.getSelectedItem()))
						continue;
					if (comboBoxG3.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG3.getSelectedItem()))
						continue;
					if (comboBoxG4.getSelectedIndex()>0 && f.name.equalsIgnoreCase( ""+comboBoxG4.getSelectedItem()))
						continue;
					
					TextFieldReportElement re = new TextFieldReportElement(detailField.position.x,ffheight ,detailField.width,detailField.height ,null);
					re.align = detailField.align;
					re.pdfFontName = detailField.pdfFontName;
					re.fontName = detailField.fontName;
					re.bold = detailField.bold;
					re.stroke = detailField.stroke;
					re.italic = detailField.italic;
					re.underline = detailField.underline;
					re.size  = detailField.size;
					re.pdfEncoding = detailField.pdfEncoding;
					re.bgcolor = detailField.bgcolor;
					re.fgcolor = detailField.fgcolor;
					re.text = "$F{"+ f.name +"}";
					re.band = detail;
					re.fieldClass = f.classType;
					re.font = null;
					r.getElements().addElement(re);
					
					// COLUMN LABEL...
					StaticTextReportElement sre = new StaticTextReportElement(detailLabel.position.x,ffheight ,detailLabel.width ,detailLabel.height ,null);
					sre.align = detailLabel.align;
					sre.pdfFontName = detailLabel.pdfFontName;
					sre.fontName = detailLabel.fontName;
					sre.bold = detailLabel.bold;
					sre.stroke = detailLabel.stroke;
					sre.italic = detailLabel.italic;
					sre.underline = detailLabel.underline;
					sre.size  = detailLabel.size;
					sre.pdfEncoding = detailLabel.pdfEncoding;
					sre.bgcolor = detailLabel.bgcolor;
					sre.fgcolor = detailLabel.fgcolor;
					sre.text = ""+ f.name +"";
					sre.band = detail;
					sre.font = null;
					r.getElements().addElement(sre);
					
					ffheight +=  detailField.position.y+detailField.height-10;		
				}
				
				detail.height = ffheight;
				
				// Remove template groups...****************
				enum = r.getElements().elements();
				Vector elements_to_delete = new Vector();
				while (enum.hasMoreElements())
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					Group g = null;
					if ((g=r.getGroupByName("Group1"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
					else if ((g=r.getGroupByName("Group2"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
					else if ((g=r.getGroupByName("Group3"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
					else if ((g=r.getGroupByName("Group4"))!=null && (rElement.band == g.groupHeader || rElement.band == g.groupFooter))
						elements_to_delete.addElement(rElement);
				}
				enum =elements_to_delete.elements();
				while (enum.hasMoreElements())
				{
					r.getElements().removeElement(enum.nextElement());
				}
				Group g;
				if ((g=r.getGroupByName("Group1"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				if ((g=r.getGroupByName("Group2"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				if ((g=r.getGroupByName("Group3"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				if ((g=r.getGroupByName("Group4"))!=null)
				{
						r.bands.removeElement(g.groupFooter);
						r.bands.removeElement(g.groupHeader);
						r.groups.removeElement(g);
				}
				
				
				// Adjust vertical position of elements
				enum = r.getElements().elements();
				while (enum.hasMoreElements())
				{
					ReportElement rElement = (ReportElement)enum.nextElement();
					rElement.trasform(new Point(0,+ r.getBandYLocation( rElement.band )),TransformationType.TRANSFORMATION_MOVE );
				}
				
				r.query = editQuery.getText();
				
				ReportForm rf = new ReportForm(r);
				rf.setMDIParent(mf);
				rf.show();
				rf.refreshAll();
				fis.close();
				this.setCursor(Cursor.DEFAULT);
				return rf;
			} catch (Exception ex)
			{
				this.setCursor(Cursor.DEFAULT);
				MessageBox.show(ex.getMessage());
				java.io.StringWriter s = new java.io.StringWriter();
				ex.printStackTrace(new java.io.PrintWriter(s));
				MessageBox.show(ex.getMessage()+" "+s);
				
			}
			this.setCursor(Cursor.DEFAULT);
		return null;
	}
	

	private void label1_click(Object source, Event e)
	{
		
	}

	private void comboBoxLayoutType_selectedIndexChanged(Object source, Event e)
	{
		String[] filenames =  com.ms.wfc.io.File.getFiles( com.ms.wfc.io.File.combine(  this.mf.programDir, "templates\\*.xml"));
		listBoxLayouts.removeAll();
		for (int i=0; i<filenames.length ; ++i)
		{
			String fname = com.ms.wfc.io.File.getName(filenames[i]);
			if (comboBoxLayoutType.getSelectedIndex()==0 &&  fname.length()>5 &&  fname.substring(filenames[i].length()-5).equalsIgnoreCase("C.xml"))
			{
				fname = fname.substring(0,filenames[i].length()-5);
				this.listBoxLayouts.addItem(fname);
			}
			else if (comboBoxLayoutType.getSelectedIndex()==1 &&  fname.length()>5 &&  fname.substring(filenames[i].length()-5).equalsIgnoreCase("T.xml"))
			{
				fname = fname.substring(0,filenames[i].length()-5);
				this.listBoxLayouts.addItem(fname);
			}
		}
		if (listBoxLayouts.getItemCount() > 0)
			listBoxLayouts.setSelectedIndex(0);
	}

	/**
	 * NOTA: il seguente codice  richiesto dalla finestra di progettazione form 
	 * di Visual J++.  possibile modificarlo con l'Editor di form.  Non modificarlo
	 * con l'Editor del codice.
	 */
	Container components = new Container();
	Label label3 = new Label();
	PictureBox pictureBox1 = new PictureBox();
	Edit editQuery = new Edit();
	ComboBox comboBoxConnections = new ComboBox();
	Label label2 = new Label();
	Label label1 = new Label();
	Panel panel1 = new Panel();
	GroupBox groupBox1 = new GroupBox();
	Button button1 = new Button();
	Button button2 = new Button();
	Button button3 = new Button();
	Label label4 = new Label();
	Panel panel2 = new Panel();
	Label label5 = new Label();
	ListBox listBoxLayouts = new ListBox();
	ListBox listBoxSelectedFields = new ListBox();
	Button button4 = new Button();
	Button button5 = new Button();
	Panel panel3 = new Panel();
	Label label6 = new Label();
	ComboBox comboBoxG1 = new ComboBox();
	Label label7 = new Label();
	Label labelG2 = new Label();
	ComboBox comboBoxG2 = new ComboBox();
	Label labelG3 = new Label();
	ComboBox comboBoxG3 = new ComboBox();
	Label labelG4 = new Label();
	ComboBox comboBoxG4 = new ComboBox();
	Panel panel4 = new Panel();
	Label label11 = new Label();
	PictureBox pictureBoxLayout = new PictureBox();
	ListBox listBoxQueryFields = new ListBox();
	Panel panel5 = new Panel();
	Label label12 = new Label();
	Label label13 = new Label();
	Label label14 = new Label();
	Button button6 = new Button();
	Button button7 = new Button();
	ComboBox comboBoxLayoutType = new ComboBox();

	private void initForm()
	{
		// NOTA: questo form contiene informazioni relative alle risorse in
		// un file esterno. Non modificare il parametro di tipo String delle
		// chiamate alla funzione resources.getObject(). Ad esempio, non
		// modificare"foo1_location" nella seguente riga di codice,
		// nemmeno se il nome dell'oggetto Foo viene modificato: 
		//	 foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "ReportWizardForm");
		this.setText("iReport wizard (New report)");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_DIALOG);
		this.setClientSize(new Point(378, 326));
		this.setMaximizeBox(false);
		this.setMinimizeBox(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		label3.setLocation(new Point(0, 100));
		label3.setSize(new Point(152, 16));
		label3.setTabIndex(4);
		label3.setTabStop(false);
		label3.setText("Connection");

		pictureBox1.setLocation(new Point(8, 8));
		pictureBox1.setSize(new Point(80, 280));
		pictureBox1.setTabIndex(0);
		pictureBox1.setTabStop(false);
		pictureBox1.setText("pictureBox1");
		pictureBox1.setBorderStyle(BorderStyle.FIXED_3D);
		pictureBox1.setImage((Bitmap)resources.getObject("pictureBox1_image"));

		editQuery.setLocation(new Point(0, 160));
		editQuery.setSize(new Point(272, 112));
		editQuery.setTabIndex(3);
		editQuery.setText("");
		editQuery.setMultiline(true);
		editQuery.addOnTextChanged(new EventHandler(this.editQuery_textChanged));

		comboBoxConnections.setLocation(new Point(0, 116));
		comboBoxConnections.setSize(new Point(272, 21));
		comboBoxConnections.setTabIndex(2);
		comboBoxConnections.setText("");
		comboBoxConnections.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxConnections.addOnSelectedIndexChanged(new EventHandler(this.comboBoxConnections_selectedIndexChanged));

		label2.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		label2.setLocation(new Point(0, 64));
		label2.setSize(new Point(272, 16));
		label2.setTabIndex(1);
		label2.setTabStop(false);
		label2.setText("Step 1: select a connection and insert a query string....");

		label1.setFont(new Font("Microsoft Sans Serif", 11.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		label1.setLocation(new Point(52, 0));
		label1.setSize(new Point(220, 20));
		label1.setTabIndex(0);
		label1.setTabStop(false);
		label1.setText("Welcome to iReport wizard...");
		label1.addOnClick(new EventHandler(this.label1_click));

		panel1.setLocation(new Point(100, 8));
		panel1.setSize(new Point(272, 272));
		panel1.setTabIndex(5);
		panel1.setText("panel1");

		groupBox1.setLocation(new Point(96, 284));
		groupBox1.setSize(new Point(272, 4));
		groupBox1.setTabIndex(1);
		groupBox1.setTabStop(false);
		groupBox1.setText("");

		button1.setLocation(new Point(236, 296));
		button1.setSize(new Point(64, 24));
		button1.setTabIndex(4);
		button1.setText("Next >");
		button1.addOnClick(new EventHandler(this.button1_click));

		button2.setLocation(new Point(308, 296));
		button2.setSize(new Point(64, 24));
		button2.setTabIndex(2);
		button2.setText("Cancel");
		button2.setDialogResult(DialogResult.CANCEL);

		button3.setLocation(new Point(168, 296));
		button3.setSize(new Point(64, 24));
		button3.setTabIndex(3);
		button3.setText("< Prev");
		button3.addOnClick(new EventHandler(this.button3_click));

		label4.setLocation(new Point(0, 144));
		label4.setSize(new Point(164, 16));
		label4.setTabIndex(5);
		label4.setTabStop(false);
		label4.setText("Query string");

		panel2.setLocation(new Point(100, 8));
		panel2.setSize(new Point(272, 272));
		panel2.setTabIndex(6);
		panel2.setText("panel2");

		label5.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		label5.setLocation(new Point(0, 64));
		label5.setSize(new Point(272, 16));
		label5.setTabIndex(0);
		label5.setTabStop(false);
		label5.setText("Step 2: select fields...");

		listBoxLayouts.setLocation(new Point(0, 120));
		listBoxLayouts.setSize(new Point(120, 150));
		listBoxLayouts.setTabIndex(2);
		listBoxLayouts.setText("listBox1");
		listBoxLayouts.setIntegralHeight(false);
		listBoxLayouts.setUseTabStops(true);
		listBoxLayouts.addOnSelectedIndexChanged(new EventHandler(this.listBoxLayouts_selectedIndexChanged));

		listBoxSelectedFields.setLocation(new Point(148, 96));
		listBoxSelectedFields.setSize(new Point(124, 173));
		listBoxSelectedFields.setTabIndex(2);
		listBoxSelectedFields.setText("listBox1");
		listBoxSelectedFields.setUseTabStops(true);

		button4.setLocation(new Point(128, 120));
		button4.setSize(new Point(20, 28));
		button4.setTabIndex(6);
		button4.setText(">");
		button4.addOnClick(new EventHandler(this.button4_click));

		button5.setLocation(new Point(128, 184));
		button5.setSize(new Point(20, 28));
		button5.setTabIndex(4);
		button5.setText("<");
		button5.addOnClick(new EventHandler(this.button5_click));

		panel3.setLocation(new Point(100, 8));
		panel3.setSize(new Point(272, 272));
		panel3.setTabIndex(7);
		panel3.setText("panel3");

		label6.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		label6.setLocation(new Point(0, 64));
		label6.setSize(new Point(272, 16));
		label6.setTabIndex(0);
		label6.setTabStop(false);
		label6.setText("Step 3: group by...");

		comboBoxG1.setLocation(new Point(0, 108));
		comboBoxG1.setSize(new Point(264, 21));
		comboBoxG1.setTabIndex(8);
		comboBoxG1.setText("");
		comboBoxG1.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxG1.addOnSelectedIndexChanged(new EventHandler(this.comboBoxG1_selectedIndexChanged));

		label7.setLocation(new Point(0, 92));
		label7.setSize(new Point(124, 16));
		label7.setTabIndex(7);
		label7.setTabStop(false);
		label7.setText("Group 1");

		labelG2.setEnabled(false);
		labelG2.setLocation(new Point(0, 136));
		labelG2.setSize(new Point(124, 16));
		labelG2.setTabIndex(5);
		labelG2.setTabStop(false);
		labelG2.setText("Group 2");

		comboBoxG2.setBackColor(Color.INACTIVEBORDER);
		comboBoxG2.setEnabled(false);
		comboBoxG2.setLocation(new Point(0, 152));
		comboBoxG2.setSize(new Point(264, 21));
		comboBoxG2.setTabIndex(6);
		comboBoxG2.setText("");
		comboBoxG2.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxG2.addOnSelectedIndexChanged(new EventHandler(this.comboBoxG2_selectedIndexChanged));

		labelG3.setEnabled(false);
		labelG3.setLocation(new Point(0, 180));
		labelG3.setSize(new Point(124, 16));
		labelG3.setTabIndex(3);
		labelG3.setTabStop(false);
		labelG3.setText("Group 3");

		comboBoxG3.setBackColor(Color.INACTIVEBORDER);
		comboBoxG3.setEnabled(false);
		comboBoxG3.setLocation(new Point(0, 196));
		comboBoxG3.setSize(new Point(264, 21));
		comboBoxG3.setTabIndex(4);
		comboBoxG3.setText("");
		comboBoxG3.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxG3.addOnSelectedIndexChanged(new EventHandler(this.comboBoxG3_selectedIndexChanged));

		labelG4.setEnabled(false);
		labelG4.setLocation(new Point(0, 228));
		labelG4.setSize(new Point(124, 16));
		labelG4.setTabIndex(1);
		labelG4.setTabStop(false);
		labelG4.setText("Group 4");

		comboBoxG4.setBackColor(Color.INACTIVEBORDER);
		comboBoxG4.setEnabled(false);
		comboBoxG4.setLocation(new Point(0, 244));
		comboBoxG4.setSize(new Point(264, 21));
		comboBoxG4.setTabIndex(2);
		comboBoxG4.setText("");
		comboBoxG4.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxG4.addOnSelectedIndexChanged(new EventHandler(this.comboBoxG4_selectedIndexChanged));

		panel4.setLocation(new Point(100, 8));
		panel4.setSize(new Point(272, 272));
		panel4.setTabIndex(8);
		panel4.setText("panel4");

		label11.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		label11.setLocation(new Point(0, 64));
		label11.setSize(new Point(272, 16));
		label11.setTabIndex(0);
		label11.setTabStop(false);
		label11.setText("Step 4: select layout...");

		pictureBoxLayout.setLocation(new Point(120, 120));
		pictureBoxLayout.setSize(new Point(150, 150));
		pictureBoxLayout.setTabIndex(1);
		pictureBoxLayout.setTabStop(false);
		pictureBoxLayout.setText("pictureBox2");
		pictureBoxLayout.setSizeMode(PictureBoxSizeMode.CENTER_IMAGE);

		listBoxQueryFields.setLocation(new Point(0, 96));
		listBoxQueryFields.setSize(new Point(124, 173));
		listBoxQueryFields.setTabIndex(1);
		listBoxQueryFields.setText("listBox1");
		listBoxQueryFields.setUseTabStops(true);

		panel5.setLocation(new Point(100, 8));
		panel5.setSize(new Point(272, 272));
		panel5.setTabIndex(9);
		panel5.setText("panel5");

		label12.setFont(new Font("Microsoft Sans Serif", 8.0f, FontSize.POINTS, FontWeight.BOLD, false, false, false, CharacterSet.DEFAULT, 0));
		label12.setLocation(new Point(0, 64));
		label12.setSize(new Point(272, 16));
		label12.setTabIndex(0);
		label12.setTabStop(false);
		label12.setText("Step 5: finished!");

		label13.setLocation(new Point(16, 168));
		label13.setSize(new Point(212, 24));
		label13.setTabIndex(1);
		label13.setTabStop(false);
		label13.setText("Press \'Next\' to generate the new report!");

		label14.setFont(new Font("Microsoft Sans Serif", 12.0f, FontSize.POINTS, FontWeight.NORMAL, false, false, false, CharacterSet.DEFAULT, 0));
		label14.setLocation(new Point(16, 112));
		label14.setSize(new Point(208, 48));
		label14.setTabIndex(2);
		label14.setTabStop(false);
		label14.setText("Congratulation,                    you have finished!");

		button6.setLocation(new Point(128, 148));
		button6.setSize(new Point(20, 28));
		button6.setTabIndex(5);
		button6.setText(">>");
		button6.addOnClick(new EventHandler(this.button6_click));

		button7.setLocation(new Point(128, 212));
		button7.setSize(new Point(20, 28));
		button7.setTabIndex(3);
		button7.setText("<<");
		button7.addOnClick(new EventHandler(this.button7_click));

		comboBoxLayoutType.setLocation(new Point(0, 88));
		comboBoxLayoutType.setSize(new Point(120, 21));
		comboBoxLayoutType.setTabIndex(3);
		comboBoxLayoutType.setText("");
		comboBoxLayoutType.setStyle(ComboBoxStyle.DROPDOWNLIST);
		comboBoxLayoutType.setItems(new Object[] {
									"Columnar", 
									"Tabular"});
		comboBoxLayoutType.addOnSelectedIndexChanged(new EventHandler(this.comboBoxLayoutType_selectedIndexChanged));

		this.setNewControls(new Control[] {
							panel4, 
							panel5, 
							panel1, 
							panel3, 
							panel2, 
							button3, 
							button2, 
							button1, 
							groupBox1, 
							pictureBox1});
		panel1.setNewControls(new Control[] {
							  label4, 
							  label3, 
							  editQuery, 
							  comboBoxConnections, 
							  label2, 
							  label1});
		panel2.setNewControls(new Control[] {
							  button7, 
							  button6, 
							  listBoxQueryFields, 
							  button5, 
							  button4, 
							  listBoxSelectedFields, 
							  label5});
		panel3.setNewControls(new Control[] {
							  comboBoxG4, 
							  labelG4, 
							  comboBoxG3, 
							  labelG3, 
							  comboBoxG2, 
							  labelG2, 
							  comboBoxG1, 
							  label7, 
							  label6});
		panel4.setNewControls(new Control[] {
							  comboBoxLayoutType, 
							  listBoxLayouts, 
							  pictureBoxLayout, 
							  label11});
		panel5.setNewControls(new Control[] {
							  label14, 
							  label13, 
							  label12});
	}

	/**
	 * Punto di ingresso principale per l'applicazione. 
	 *
	 * @param args Matrice di parametri passata all'applicazione
	 * tramite la riga di comando.
	 */
	public static void main(String args[])
	{
		Application.run(new ReportWizardForm(null));
	}
}
