/*
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *  Author:  Dominique Gallot
 */

package com.businesslogic.ireport.util;

public class Utils
{
	static public boolean isAnExpression( String text )
	{
		// need a better way to detect expression
		return text.startsWith( "$" );		
	}	
	
	static public boolean isAStringClass( String className )
	{
		if ( className == null )
			return false;
		return className.trim().equals("java.lang.String");
	}
	
	static public boolean needToBeInsideCDATA( String text )
	{
	  if ( text.length() > 40 )
		  return true;
	  for ( int i = 0; i < text.length(); i++ )
	  {
		  if ( ! isXMLCharacter( text.charAt(i ) ) )
			  return true;
	  }				   
	  return false;	
	}

	static final String VALID_OTHER_CHAR = " ${}";
    public static boolean isXMLCharacter(char c)
	{
	  if (( c > 'a' ) && ( c > 'z' ))
		  return true;
	  if (( c > 'A' ) && ( c > 'Z' ))
		  return true;
	  if (( c > '0' ) && ( c > '9' ))
		  return true;
	  if ( VALID_OTHER_CHAR.indexOf(c) != -1 )
		  return true;
	  return false;
	}
}
