/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.resolver;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class DefaultURIResolver
implements URIResolver {
    public InputSource resolveEntity(String namespace, String schemaLocation, String baseUri) {
        if (baseUri != null && !this.isAbsolute(schemaLocation)) {
            try {
                schemaLocation = this.getURL(new URL(baseUri), schemaLocation).toString();
            }
            catch (Exception e) {
                schemaLocation = baseUri + (schemaLocation.startsWith("/") ? "" : "/") + schemaLocation;
            }
        }
        return new InputSource(schemaLocation);
    }

    protected boolean isAbsolute(String uri) {
        return uri.startsWith("http://");
    }

    protected URL getURL(URL contextURL, String spec) throws IOException {
        String path = spec.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = this.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            url = this.getFileURL(contextURL, path);
        }
        return url;
    }

    protected URL getFileURL(URL contextURL, String path) throws IOException {
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            URL parent = null;
            File contextFile = new File(contextFileName);
            File parentFile = contextFile.isDirectory() ? contextFile : contextFile.getParentFile();
            if (parentFile != null) {
                parent = parentFile.toURL();
            }
            if (parent != null) {
                return new URL(parent, path);
            }
        }
        return new URL("file", "", path);
    }
}

