/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.irplugin.gui.explorer;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.gui.RepositoryTreeCellRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 *
 * @author gtoffoli
 */
public class ExplorerCellRenderer extends DefaultListCellRenderer  {
    
    final static ImageIcon longIcon = new ImageIcon("long.gif");
    final static ImageIcon shortIcon = new ImageIcon("short.gif");

    boolean comboboxMode = false;
    /* This is the only method defined by ListCellRenderer.  We just
     * reconfigure the Jlabel each time we're called.
     */
    public ExplorerCellRenderer(boolean mode)
    {
        super();
        this.comboboxMode = mode;
    }
    
    public ExplorerCellRenderer()
    {
        super();
    }
    
    public Component getListCellRendererComponent(
        JList list,
	Object value,   // value to display
	int index,      // cell index
	boolean iss,    // is the cell selected
	boolean chf)    // the list and the cell have the focus
    {
        /* The DefaultListCellRenderer class will take care of
         * the JLabels text property, it's foreground and background
         * colors, and so on.
         */
        super.getListCellRendererComponent(list, value, index, iss, chf);

        /* We additionally set the JLabels icon property here.
         */
        if (value instanceof ResourceDescriptor)
        {
            ResourceDescriptor rd = (ResourceDescriptor)value;
            
            if (rd.getUriString().equals("/"))
            {
                setIcon(RepositoryTreeCellRenderer.getResourceIcon( null ) );
                
                setText( IRPlugin.getString("misc.labelRepositoryRoot","Repository root (/)") );
            }
            else
            {
                
                ImageIcon iconImage = RepositoryTreeCellRenderer.getResourceIcon( rd );
                
                if (comboboxMode && index > 0)
                {
                    Image image = new java.awt.image.BufferedImage(iconImage.getIconWidth() + 8*index, iconImage.getIconHeight(), java.awt.image.BufferedImage.TYPE_INT_RGB );
                    
                    Graphics g = image.getGraphics();
                    
                    g.setColor( (iss) ? list.getSelectionBackground() : list.getBackground() );
                    g.fillRect(0,0,image.getWidth(null), image.getHeight(null));
                    g.drawImage(iconImage.getImage(), 8*index,0,null);
                    
                    
                    setIcon(new ImageIcon(image));
                }
                else
                {
                  setIcon(iconImage);  
                }
                setText( rd.getName() );
            }
        }
	return this;
    }
}
