/*
 * Copyright (C) 2005 - 2007 JasperSoft Corporation.  All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 */
package com.jaspersoft.jasperserver.irplugin.gui.jrxmlvalidator;

import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryReportUnit;
import it.businesslogic.ireport.JRProperty;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.text.NumberFormat;
import java.text.DecimalFormat;
import java.util.List;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

/**
 *
 * @author  gtoffoli
 */
public class JrxmlValidationDialog extends javax.swing.JDialog {
    
    private JServer server = null;
    private RepositoryReportUnit reportUnit = null;
    private java.util.List elementVelidationItems = null;
    private Report report = null;
    
    private int dialogResult = JOptionPane.CANCEL_OPTION;
    
    /** Creates new form JrxmlValidationDialog */
    public JrxmlValidationDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        
        // 450...
        TableColumn dtcm = jTable1.getColumnModel().getColumn(0);
        dtcm.setMinWidth(22);
        dtcm.setMaxWidth(22);
        dtcm.setPreferredWidth(20);
        dtcm.setResizable(false);
        jTable1.getModel().addTableModelListener(new TableModelListener() {
            public void tableChanged(TableModelEvent e) {
                updateContinue();
            }
        } );
        
        dtcm = jTable1.getColumnModel().getColumn(1);
        dtcm.setMinWidth(100);
        dtcm.setPreferredWidth(100);
        dtcm.setCellRenderer(new AlignedTableCellRenderer(JLabel.LEFT) );
        
        dtcm = jTable1.getColumnModel().getColumn(2);
        dtcm.setMinWidth(100);
        dtcm.setPreferredWidth(300);
        
        dtcm = jTable1.getColumnModel().getColumn(3);
        dtcm.setMinWidth(100);
        dtcm.setPreferredWidth(300);
        
        
        dtcm = jTable1.getColumnModel().getColumn(4);
        dtcm.setMinWidth(50);
        dtcm.setMaxWidth(100);
        dtcm.setPreferredWidth(80);
        dtcm.setCellRenderer(new AlignedTableCellRenderer(JLabel.RIGHT));
        
        applyI18n();
        this.pack();
        Misc.centerFrame(this);
    }
    
    
    public void applyI18n()
    {
        jButtonCancel.setText( IRPlugin.getString("jrxmlValidationDialog.buttonCancel","Cancel"));
        jButtonDeselectAll.setText( IRPlugin.getString("jrxmlValidationDialog.buttonDeselectAll","Deselect all"));
        jButtonOk.setText( IRPlugin.getString("jrxmlValidationDialog.buttonOk","Continue"));
        jButtonSelectAll.setText( IRPlugin.getString("jrxmlValidationDialog.buttonSelectAll","Select all"));
        jButtonSkip.setText( IRPlugin.getString("jrxmlValidationDialog.buttonSkip","Skip this step"));
        jCheckBoxDoNotShowAgain.setText( IRPlugin.getString("jrxmlValidationDialog.checkDoNotShowAgain","Do not show this window again"));
    
        jLabel1.setText(IRPlugin.getString("jrxmlValidationDialog.message","<html>JasperServer Plugin has detected some locally referenced images in your report.<br>\n"+
                            "You can choose to attach these images to the Report Unit importing them into the repository "+
                            "and replace the relative image expressions with an url like \"repo:myImage.jpg\".<br>" +
                            "<b>Please check the images you want attach to this Report Unit</b>.</html>"));
        
        try {
        jTable1.getColumn("Image").setHeaderValue( IRPlugin.getString("jrxmlValidationDialog.table.image","Image") ); 
        jTable1.getColumn("Local file").setHeaderValue( IRPlugin.getString("jrxmlValidationDialog.table.localFile","Local file") ); 
        jTable1.getColumn("Proposed exp").setHeaderValue( IRPlugin.getString("jrxmlValidationDialog.table.proposedExpression","Proposed exp") );
        jTable1.getColumn("File size").setHeaderValue( IRPlugin.getString("jrxmlValidationDialog.table.fileSize","File size") );
        } catch (Exception ex) {}
        jTable1.updateUI();
    }

    
    
    public void updateContinue()
    {
        DefaultTableModel dtm = (DefaultTableModel)jTable1.getModel();
        for (int i=0; i< dtm.getRowCount(); ++i)
        {
            if ( ((Boolean)jTable1.getValueAt(i,0)).booleanValue())
            {
                jButtonOk.setEnabled(true);
                return;
            }
        }
        jButtonOk.setEnabled(false);
    }
    
    public void setElementVelidationItems(java.util.List items)
    {
        DefaultTableModel dtm = (DefaultTableModel)jTable1.getModel();
        dtm.setRowCount(0);
        
        NumberFormat formatter = new DecimalFormat("#,##0");
        for (int i=0; i<items.size(); ++i)
        {
            ElementValidationItem iev = (ElementValidationItem)items.get(i);
            String filesize = "";
            if (iev.getOriginalFileName().length() < 1024)
            {
                filesize = formatter.format(iev.getOriginalFileName().length())+" bytes";
            }
            else
            {
                filesize = formatter.format(iev.getOriginalFileName().length() / 1024)+" KB";
            }
            
            dtm.addRow(new Object[]{ Boolean.TRUE, iev, iev.getOriginalFileName()+"", iev.getProposedExpression(), filesize});
        }
        this.elementVelidationItems = items;
    }

    public java.util.List getElementVelidationItems() {
        return elementVelidationItems;
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();
        jPanel1 = new javax.swing.JPanel();
        jButtonSelectAll = new javax.swing.JButton();
        jButtonDeselectAll = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel2 = new javax.swing.JPanel();
        jCheckBoxDoNotShowAgain = new javax.swing.JCheckBox();
        jButtonOk = new javax.swing.JButton();
        jButtonSkip = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("JRXML validation");
        setModal(true);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("<html>JasperServer Plugin has detected some locally referenced images in your report.<br>\nYou can choose to attach these images to the Report Unit importing them into the repository and replace the relative image expressions with an url like \"repo:myImage.jpg\".<br>\n<b>Please check the images you want attach to this Report Unit</b>.</html>");
        jLabel1.setMinimumSize(new java.awt.Dimension(64, 60));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        getContentPane().add(jLabel1, gridBagConstraints);

        jScrollPane2.setPreferredSize(new java.awt.Dimension(452, 200));

        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                " ", "Image", "Local file", "Proposed exp", "File size"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Boolean.class, java.lang.String.class, java.lang.String.class, java.lang.String.class, java.lang.String.class
            };
            boolean[] canEdit = new boolean [] {
                true, false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane2.setViewportView(jTable1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        getContentPane().add(jScrollPane2, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButtonSelectAll.setMnemonic('a');
        jButtonSelectAll.setText("Select all");
        jButtonSelectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectAllActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonSelectAll, new java.awt.GridBagConstraints());

        jButtonDeselectAll.setMnemonic('d');
        jButtonDeselectAll.setText("Deselect all");
        jButtonDeselectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeselectAllActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonDeselectAll, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        getContentPane().add(jPanel1, gridBagConstraints);

        jSeparator1.setPreferredSize(new java.awt.Dimension(2, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        getContentPane().add(jSeparator1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jCheckBoxDoNotShowAgain.setMnemonic('n');
        jCheckBoxDoNotShowAgain.setText("Do not show this window again for this report");
        jCheckBoxDoNotShowAgain.setActionCommand("Do not show this window again");
        jCheckBoxDoNotShowAgain.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxDoNotShowAgain.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxDoNotShowAgain.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxDoNotShowAgainActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jCheckBoxDoNotShowAgain, gridBagConstraints);

        jButtonOk.setMnemonic('O');
        jButtonOk.setText("Continue");
        jButtonOk.setEnabled(false);
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 4);
        jPanel2.add(jButtonOk, gridBagConstraints);

        jButtonSkip.setMnemonic('O');
        jButtonSkip.setText("Skip this step");
        jButtonSkip.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed1(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 4);
        jPanel2.add(jButtonSkip, gridBagConstraints);

        jButtonCancel.setMnemonic('C');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 4, 4);
        jPanel2.add(jButtonCancel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        getContentPane().add(jPanel2, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed1(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed1

        this.setDialogResult( JOptionPane.OK_OPTION );
        this.setVisible(false);
        this.dispose();
        
    }//GEN-LAST:event_jButtonOkActionPerformed1

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed

        this.setDialogResult( JOptionPane.CANCEL_OPTION );
        this.setVisible(false);
        this.dispose();
        
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        DefaultTableModel dtm = (DefaultTableModel)jTable1.getModel();
        
        List selectedItems = new ArrayList();
        for (int i=0; i< dtm.getRowCount(); ++i)
        {
            if ( ((Boolean)jTable1.getValueAt(i,0)).booleanValue())
            {
                selectedItems.add(jTable1.getValueAt(i,1));
            }
        }
        
        if (selectedItems.size() > 0)
        {
             UploadResourcesDialog urd = new UploadResourcesDialog(MainFrame.getMainInstance(), true);
             urd.setResourceItems( selectedItems );
             urd.setValidationDialog( this );
             urd.setVisible(true);

             return;
        }
        
        elaborationFinished(true);
          
        
        
    }//GEN-LAST:event_jButtonOkActionPerformed

    
    public void elaborationFinished(boolean result)
    {
        this.dialogResult = (result) ? JOptionPane.OK_OPTION : JOptionPane.CANCEL_OPTION;
        this.setVisible(false);
        this.dispose();
    }
    
    
    private void jCheckBoxDoNotShowAgainActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxDoNotShowAgainActionPerformed

        if (getReport() != null)
        {
            boolean found = false;
            for (int i=0; i< getReport().getJRproperties().size(); ++i)
            {
                JRProperty prop = (JRProperty)getReport().getJRproperties().get(i);
                if (prop.getName() != null && prop.getName().equals("com.jaspersoft.irplugin.validation"))
                {
                    prop.setValue("0");
                    found = true;
                }
            }
            
            if (!found)
            {
                JRProperty prop = new JRProperty();
                prop.setName("com.jaspersoft.irplugin.validation");
                prop.setValue("0");
                getReport().getJRproperties().add(prop);
            }
            
            getReport().saveXMLFile();
        }
    }//GEN-LAST:event_jCheckBoxDoNotShowAgainActionPerformed

    private void jButtonDeselectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeselectAllActionPerformed

        DefaultTableModel dtm = (DefaultTableModel)jTable1.getModel();
        for (int i=0; i< dtm.getRowCount(); ++i)
        {
            jTable1.setValueAt(Boolean.FALSE,i,0);
        }
        
        jTable1.updateUI();
        
    }//GEN-LAST:event_jButtonDeselectAllActionPerformed

    private void jButtonSelectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectAllActionPerformed

        DefaultTableModel dtm = (DefaultTableModel)jTable1.getModel();
        for (int i=0; i< dtm.getRowCount(); ++i)
        {
            jTable1.setValueAt(Boolean.TRUE,i,0);
        }
        
        jTable1.updateUI();
        
    }//GEN-LAST:event_jButtonSelectAllActionPerformed
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new JrxmlValidationDialog(new javax.swing.JFrame(), true).setVisible(true);
            }
        });
    }

    public JServer getServer() {
        return server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public RepositoryReportUnit getReportUnit() {
        return reportUnit;
    }

    public void setReportUnit(RepositoryReportUnit reportUnit) {
        this.reportUnit = reportUnit;
    }

    public Report getReport() {
        return report;
    }

    public void setReport(Report report) {
        this.report = report;
    }

    public int getDialogResult() {
        return dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonDeselectAll;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JButton jButtonSelectAll;
    private javax.swing.JButton jButtonSkip;
    private javax.swing.JCheckBox jCheckBoxDoNotShowAgain;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTable jTable1;
    // End of variables declaration//GEN-END:variables
    
}
