/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.design;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperReport;
import dori.jasper.engine.design.JRClassCompiler;
import dori.jasper.engine.design.JRClassGenerator;
import dori.jasper.engine.design.JRJavacCompiler;
import dori.jasper.engine.design.JRJdk12Compiler;
import dori.jasper.engine.design.JRJdk13Compiler;
import dori.jasper.engine.design.JRVerifier;
import dori.jasper.engine.design.JasperDesign;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;

public class JRCompiler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        File classFile;
        JasperReport jasperReport;
        block13: {
            File tempDirFile;
            jasperReport = null;
            Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
            if (brokenRules != null && brokenRules.size() > 0) {
                StringBuffer sbuffer = new StringBuffer();
                sbuffer.append("Report design not valid : ");
                int i = 1;
                Iterator it = brokenRules.iterator();
                while (true) {
                    if (!it.hasNext()) {
                        throw new JRException(sbuffer.toString());
                    }
                    sbuffer.append("\n\t " + i + ". " + (String)it.next());
                    ++i;
                }
            }
            String tempDirStr = System.getProperty("jasper.reports.compile.temp");
            if (tempDirStr == null || tempDirStr.length() == 0) {
                tempDirStr = System.getProperty("user.dir");
            }
            if (!(tempDirFile = new File(tempDirStr)).exists()) throw new JRException("Temporary directory not found : " + tempDirStr);
            if (!tempDirFile.isDirectory()) {
                throw new JRException("Temporary directory not found : " + tempDirStr);
            }
            boolean isKeepJavaFile = Boolean.valueOf(System.getProperty("jasper.reports.compile.keep.java.file"));
            File javaFile = new File(tempDirFile, jasperDesign.getName() + ".java");
            classFile = new File(tempDirFile, jasperDesign.getName() + ".class");
            String sourceCode = JRClassGenerator.generateClass(jasperDesign);
            JRCompiler.saveClass(sourceCode, javaFile);
            try {
                try {
                    String compileErrors = JRCompiler.compileClass(javaFile);
                    if (compileErrors != null) {
                        throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compileErrors);
                    }
                    jasperReport = new JasperReport(jasperDesign, JRCompiler.readClassBytecodes(classFile));
                }
                catch (JRException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JRException("Error compiling report design.", e);
                }
                Object var12_14 = null;
                if (isKeepJavaFile) break block13;
                javaFile.delete();
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (!isKeepJavaFile) {
                    javaFile.delete();
                }
                classFile.delete();
                throw throwable;
            }
        }
        classFile.delete();
        return jasperReport;
    }

    protected static String compileClass(File sourceFile) throws JRException {
        String classpath = System.getProperty("jasper.reports.compile.class.path");
        if (classpath == null || classpath.length() == 0) {
            classpath = System.getProperty("java.class.path");
        }
        JRClassCompiler jrClassCompiler = null;
        String compiler = System.getProperty("jasper.reports.compiler.class");
        if (compiler == null || compiler.length() == 0) {
            Class<?> javacClass;
            try {
                javacClass = Class.forName("com.sun.tools.javac.Main");
                jrClassCompiler = new JRJdk13Compiler();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (jrClassCompiler == null) {
                try {
                    javacClass = Class.forName("sun.tools.javac.Main");
                    jrClassCompiler = new JRJdk12Compiler();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (jrClassCompiler == null) {
                jrClassCompiler = new JRJavacCompiler();
            }
        } else {
            try {
                Class<?> clazz = Class.forName(compiler);
                jrClassCompiler = (JRClassCompiler)clazz.newInstance();
            }
            catch (Exception e) {
                throw new JRException("Could not instantiate compiler class : " + compiler, e);
            }
        }
        return jrClassCompiler.compileClass(sourceFile, classpath);
    }

    protected static void saveClass(String source, File file) throws JRException {
        try {
            FileWriter fwriter = new FileWriter(file);
            fwriter.write(source);
            fwriter.flush();
            fwriter.close();
        }
        catch (IOException e) {
            throw new JRException("Error saving expressions class file : " + file, e);
        }
    }

    protected static byte[] readClassBytecodes(File classFile) throws JRException {
        try {
            FileInputStream fis = new FileInputStream(classFile);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] bytecodes = new byte[10000];
            int ln = 0;
            while ((ln = fis.read(bytecodes)) > 0) {
                baos.write(bytecodes, 0, ln);
            }
            baos.flush();
            baos.close();
            fis.close();
            bytecodes = baos.toByteArray();
            return bytecodes;
        }
        catch (Exception e) {
            throw new JRException("Error reading class byte codes from compiled class file : " + classFile, e);
        }
    }
}

