/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.engine.export;

import dori.jasper.engine.JRAbstractExporter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExporterParameter;
import dori.jasper.engine.JRFont;
import dori.jasper.engine.JRPrintElement;
import dori.jasper.engine.JRPrintEllipse;
import dori.jasper.engine.JRPrintImage;
import dori.jasper.engine.JRPrintLine;
import dori.jasper.engine.JRPrintPage;
import dori.jasper.engine.JRPrintRectangle;
import dori.jasper.engine.JRPrintText;
import dori.jasper.engine.JRReportFont;
import dori.jasper.engine.JasperPrint;
import dori.jasper.engine.design.JRDesignReportFont;
import dori.jasper.engine.export.JRGraphics2DExporterParameter;
import dori.jasper.engine.util.JRImageLoader;
import dori.jasper.engine.util.JRLoader;
import dori.jasper.engine.util.JRStringUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class JRGraphics2DExporter
extends JRAbstractExporter {
    private JasperPrint jasperPrint = null;
    private Graphics2D grx = null;
    private int pageIndex = 0;
    private float zoom = 1.0f;
    private JRReportFont defaultFont = null;

    private JRReportFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRDesignReportFont();
            }
        }
        return this.defaultFont;
    }

    public void exportReport() throws JRException {
        Float zoomRatio;
        Integer index;
        this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
        if (this.jasperPrint == null) {
            InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
            if (is != null) {
                this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
            } else {
                URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                if (url != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                } else {
                    File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                    if (file != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                    } else {
                        String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                        if (fileName != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                        } else {
                            throw new JRException("No input source supplied to the exporter.");
                        }
                    }
                }
            }
        }
        this.grx = (Graphics2D)this.parameters.get(JRGraphics2DExporterParameter.GRAPHICS_2D);
        if (this.grx == null) {
            throw new JRException("No output specified for the exporter. java.awt.Graphics2D object expected.");
        }
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX)) != null) {
            this.pageIndex = index;
            if (this.pageIndex < 0 || this.pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + this.pageIndex + " of " + lastPageIndex);
            }
        }
        if ((zoomRatio = (Float)this.parameters.get(JRGraphics2DExporterParameter.ZOOM_RATIO)) != null) {
            this.zoom = zoomRatio.floatValue();
            if (this.zoom <= 0.0f) {
                throw new JRException("Invalid zoom ratio : " + this.zoom);
            }
        }
        this.exportReportToGraphics2D();
    }

    public void exportReportToGraphics2D() {
        this.grx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.grx.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform atrans = new AffineTransform();
        atrans.scale(this.zoom, this.zoom);
        this.grx.transform(atrans);
        List pages = this.jasperPrint.getPages();
        if (pages != null) {
            JRPrintPage page = (JRPrintPage)pages.get(this.pageIndex);
            this.exportPage(page);
        }
    }

    private void exportPage(JRPrintPage page) {
        this.grx.setColor(Color.white);
        this.grx.fillRect(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
        this.grx.setColor(Color.black);
        this.grx.setStroke(new BasicStroke(1.0f));
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
    }

    private void exportLine(JRPrintLine line) {
        this.grx.setColor(line.getForecolor());
        BasicStroke stroke = null;
        switch (line.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 0: {
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            this.grx.setStroke(stroke);
            if (line.getDirection() == 1) {
                this.grx.drawLine(line.getX(), line.getY(), line.getX() + line.getWidth() - 1, line.getY() + line.getHeight() - 1);
            } else {
                this.grx.drawLine(line.getX(), line.getY() + line.getHeight() - 1, line.getX() + line.getWidth() - 1, line.getY());
            }
        }
    }

    private void exportRectangle(JRPrintRectangle rectangle) {
        if (rectangle.getMode() == 1) {
            this.grx.setColor(rectangle.getBackcolor());
            this.grx.fillRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
        this.grx.setColor(rectangle.getForecolor());
        BasicStroke stroke = null;
        switch (rectangle.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 0: {
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.drawRoundRect(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight(), 2 * rectangle.getRadius(), 2 * rectangle.getRadius());
        }
    }

    private void exportEllipse(JRPrintEllipse ellipse) {
        if (ellipse.getMode() == 1) {
            this.grx.setColor(ellipse.getBackcolor());
            this.grx.fillOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
        this.grx.setColor(ellipse.getForecolor());
        BasicStroke stroke = null;
        switch (ellipse.getPen()) {
            case 4: {
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 5: {
                stroke = new BasicStroke(0.5f);
                break;
            }
            case 0: {
                break;
            }
            default: {
                stroke = new BasicStroke(1.0f);
            }
        }
        if (stroke != null) {
            this.grx.setStroke(stroke);
            this.grx.drawOval(ellipse.getX(), ellipse.getY(), ellipse.getWidth(), ellipse.getHeight());
        }
    }

    private void exportImage(JRPrintImage printImage) {
        if (printImage.getMode() == 1) {
            this.grx.setColor(printImage.getBackcolor());
            this.grx.fillRect(printImage.getX(), printImage.getY(), printImage.getWidth(), printImage.getHeight());
        }
        int borderOffset = 0;
        BasicStroke stroke = null;
        switch (printImage.getPen()) {
            case 4: {
                borderOffset = 0;
                stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{5.0f, 3.0f}, 0.0f);
                break;
            }
            case 3: {
                borderOffset = 2;
                stroke = new BasicStroke(4.0f);
                break;
            }
            case 2: {
                borderOffset = 1;
                stroke = new BasicStroke(2.0f);
                break;
            }
            case 0: {
                break;
            }
            case 5: {
                borderOffset = 0;
                stroke = new BasicStroke(0.5f);
                break;
            }
            default: {
                borderOffset = 0;
                stroke = new BasicStroke(1.0f);
            }
        }
        int availableImageWidth = printImage.getWidth() - 2 * borderOffset;
        availableImageWidth = availableImageWidth < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - 2 * borderOffset;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        byte[] imageData = printImage.getImageData();
        if (availableImageWidth > 0 && availableImageHeight > 0 && imageData != null && imageData.length > 0) {
            Image awtImage = JRImageLoader.loadImage(imageData);
            int awtWidth = awtImage.getWidth(null);
            int awtHeight = awtImage.getHeight(null);
            float xalignFactor = 0.0f;
            switch (printImage.getHorizontalAlignment()) {
                case 3: {
                    xalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    xalignFactor = 0.5f;
                    break;
                }
                default: {
                    xalignFactor = 0.0f;
                }
            }
            float yalignFactor = 0.0f;
            switch (printImage.getVerticalAlignment()) {
                case 3: {
                    yalignFactor = 1.0f;
                    break;
                }
                case 2: {
                    yalignFactor = 0.5f;
                    break;
                }
                default: {
                    yalignFactor = 0.0f;
                }
            }
            switch (printImage.getScaleImage()) {
                case 1: {
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                    this.grx.setClip(printImage.getX() + borderOffset, printImage.getY() + borderOffset, availableImageWidth, availableImageHeight);
                    this.grx.drawImage(awtImage, printImage.getX() + xoffset + borderOffset, printImage.getY() + yoffset + borderOffset, awtWidth, awtHeight, null);
                    this.grx.setClip(0, 0, this.jasperPrint.getPageWidth(), this.jasperPrint.getPageHeight());
                    break;
                }
                case 2: {
                    this.grx.drawImage(awtImage, printImage.getX() + borderOffset, printImage.getY() + borderOffset, availableImageWidth, availableImageHeight, null);
                    break;
                }
                default: {
                    if (printImage.getHeight() <= 0) break;
                    double ratio = (double)awtWidth / (double)awtHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        awtWidth = availableImageWidth;
                        awtHeight = (int)((double)availableImageWidth / ratio);
                    } else {
                        awtWidth = (int)((double)availableImageHeight * ratio);
                        awtHeight = availableImageHeight;
                    }
                    int xoffset = (int)(xalignFactor * (float)(availableImageWidth - awtWidth));
                    int yoffset = (int)(yalignFactor * (float)(availableImageHeight - awtHeight));
                    this.grx.drawImage(awtImage, printImage.getX() + xoffset + borderOffset, printImage.getY() + yoffset + borderOffset, awtWidth, awtHeight, null);
                }
            }
        }
        if (stroke != null) {
            this.grx.setColor(printImage.getForecolor());
            this.grx.setStroke(stroke);
            this.grx.drawRect(printImage.getX(), printImage.getY(), printImage.getWidth(), printImage.getHeight());
        }
    }

    private void exportText(JRPrintText text) {
        String allText = text.getText();
        if (allText == null) {
            return;
        }
        if (text.getMode() == 1) {
            this.grx.setColor(text.getBackcolor());
            this.grx.fillRect(text.getX(), text.getY(), text.getWidth(), text.getHeight());
        }
        if (allText.length() == 0) {
            return;
        }
        this.grx.setColor(text.getForecolor());
        allText = JRStringUtil.treatNewLineChars(allText);
        float formatWidth = text.getWidth();
        float verticalOffset = 0.0f;
        switch (text.getVerticalAlignment()) {
            case 1: {
                verticalOffset = 0.0f;
                break;
            }
            case 2: {
                verticalOffset = ((float)text.getHeight() - text.getTextHeight()) / 2.0f;
                break;
            }
            case 3: {
                verticalOffset = (float)text.getHeight() - text.getTextHeight();
                break;
            }
            default: {
                verticalOffset = 0.0f;
            }
        }
        float lineSpacing = 1.0f;
        switch (text.getLineSpacing()) {
            case 0: {
                lineSpacing = 1.0f;
                break;
            }
            case 1: {
                lineSpacing = 1.5f;
                break;
            }
            case 2: {
                lineSpacing = 2.0f;
                break;
            }
            default: {
                lineSpacing = 1.0f;
            }
        }
        int maxHeight = text.getHeight();
        FontRenderContext fontRenderContext = this.grx.getFontRenderContext();
        JRFont font = text.getFont();
        if (font == null) {
            font = this.getDefaultFont();
        }
        Map fontAttributes = font.getAttributes();
        float drawPosY = 0.0f;
        float drawPosX = 0.0f;
        String paragr_text = "";
        boolean isMaxHeightReached = false;
        StringTokenizer tkzer = new StringTokenizer(allText, "\n");
        while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
            paragr_text = tkzer.nextToken();
            AttributedString atext = new AttributedString(paragr_text, fontAttributes);
            AttributedCharacterIterator paragraph = atext.getIterator();
            int paragraphStart = paragraph.getBeginIndex();
            int paragraphEnd = paragraph.getEndIndex();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
            lineMeasurer.setPosition(paragraphStart);
            TextLayout layout = null;
            while (lineMeasurer.getPosition() < paragraphEnd && !isMaxHeightReached) {
                layout = lineMeasurer.nextLayout(formatWidth);
                if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)maxHeight) {
                    switch (text.getTextAlignment()) {
                        case 4: {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                            if (lineMeasurer.getPosition() >= paragraphEnd) break;
                            layout = layout.getJustifiedLayout(formatWidth);
                            break;
                        }
                        case 3: {
                            if (layout.isLeftToRight()) {
                                drawPosX = formatWidth - layout.getAdvance();
                                break;
                            }
                            drawPosX = formatWidth;
                            break;
                        }
                        case 2: {
                            drawPosX = (formatWidth - layout.getAdvance()) / 2.0f;
                            break;
                        }
                        default: {
                            drawPosX = layout.isLeftToRight() ? 0.0f : formatWidth - layout.getAdvance();
                        }
                    }
                    layout.draw(this.grx, drawPosX + (float)text.getX(), drawPosY + (float)text.getY() + verticalOffset);
                    drawPosY += layout.getDescent();
                    continue;
                }
                drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                isMaxHeightReached = true;
            }
        }
    }

    static {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = gEnv.getAvailableFontFamilyNames();
    }
}

