/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.Spacer;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.event.TitleChangeListener;
import org.jfree.util.ObjectUtils;

public abstract class AbstractTitle
implements Cloneable,
Serializable {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    public static final int CENTER = 4;
    public static final int MIDDLE = 4;
    public static final int DEFAULT_POSITION = 0;
    public static final int DEFAULT_HORIZONTAL_ALIGNMENT = 4;
    public static final int DEFAULT_VERTICAL_ALIGNMENT = 4;
    public static final Spacer DEFAULT_SPACER = new Spacer(0, 0.01, 0.3, 0.01, 0.15);
    private int position;
    private int horizontalAlignment;
    private int verticalAlignment;
    private Spacer spacer;
    private transient EventListenerList listenerList;
    private boolean notify;
    static /* synthetic */ Class class$org$jfree$chart$event$TitleChangeListener;

    protected AbstractTitle() {
        this(0, 4, 4, DEFAULT_SPACER);
    }

    protected AbstractTitle(int n, int n2, int n3) {
        this(n, n2, n3, DEFAULT_SPACER);
    }

    protected AbstractTitle(int n, int n2, int n3, Spacer spacer) {
        if (!this.isValidPosition(n)) {
            throw new IllegalArgumentException("AbstractTitle(): invalid position.");
        }
        if (!AbstractTitle.isValidHorizontalAlignment(n2)) {
            throw new IllegalArgumentException("AbstractTitle(): invalid horizontal alignment.");
        }
        if (!AbstractTitle.isValidVerticalAlignment(n3)) {
            throw new IllegalArgumentException("AbstractTitle(): invalid vertical alignment.");
        }
        this.position = n;
        this.horizontalAlignment = n2;
        this.verticalAlignment = n3;
        this.spacer = spacer;
        this.listenerList = new EventListenerList();
        this.notify = true;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        if (this.position != n) {
            this.position = n;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n) {
        if (this.horizontalAlignment != n) {
            this.horizontalAlignment = n;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int n) {
        if (this.verticalAlignment != n) {
            this.verticalAlignment = n;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Spacer getSpacer() {
        return this.spacer;
    }

    public void setSpacer(Spacer spacer) {
        if (!this.spacer.equals(spacer)) {
            this.spacer = spacer;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        this.notify = bl;
    }

    public abstract boolean isValidPosition(int var1);

    public abstract double getPreferredWidth(Graphics2D var1);

    public abstract double getPreferredHeight(Graphics2D var1);

    public abstract void draw(Graphics2D var1, Rectangle2D var2);

    public Object clone() {
        AbstractTitle abstractTitle = null;
        try {
            abstractTitle = (AbstractTitle)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("AbstractTitle.clone()");
        }
        return abstractTitle;
    }

    public void addChangeListener(TitleChangeListener titleChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$TitleChangeListener == null ? (class$org$jfree$chart$event$TitleChangeListener = AbstractTitle.class$("org.jfree.chart.event.TitleChangeListener")) : class$org$jfree$chart$event$TitleChangeListener, titleChangeListener);
    }

    public void removeChangeListener(TitleChangeListener titleChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$TitleChangeListener == null ? (class$org$jfree$chart$event$TitleChangeListener = AbstractTitle.class$("org.jfree.chart.event.TitleChangeListener")) : class$org$jfree$chart$event$TitleChangeListener, titleChangeListener);
    }

    protected void notifyListeners(TitleChangeEvent titleChangeEvent) {
        if (this.notify) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$org$jfree$chart$event$TitleChangeListener == null ? AbstractTitle.class$("org.jfree.chart.event.TitleChangeListener") : class$org$jfree$chart$event$TitleChangeListener)) {
                    ((TitleChangeListener)objectArray[n + 1]).titleChanged(titleChangeEvent);
                }
                n -= 2;
            }
        }
    }

    protected static boolean isValidHorizontalAlignment(int n) {
        switch (n) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    protected static boolean isValidVerticalAlignment(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractTitle) {
            AbstractTitle abstractTitle = (AbstractTitle)object;
            boolean bl = this.position == abstractTitle.position;
            boolean bl2 = this.horizontalAlignment == abstractTitle.horizontalAlignment;
            boolean bl3 = this.verticalAlignment == abstractTitle.verticalAlignment;
            boolean bl4 = ObjectUtils.equalOrBothNull((Object)this.spacer, (Object)abstractTitle.spacer);
            boolean bl5 = this.notify == abstractTitle.notify;
            return bl && bl2 && bl3 && bl4 && bl5;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

