/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.io.SerialUtilities;

public class Marker
implements Serializable {
    private double value;
    private transient Paint outlinePaint;
    private transient Stroke outlineStroke;
    private transient Paint paint;
    private float alpha;

    public Marker(double d) {
        this(d, Color.gray, new BasicStroke(0.5f), Color.gray, 0.8f);
    }

    public Marker(double d, Paint paint) {
        this(d, paint, new BasicStroke(0.5f), Color.red, 0.8f);
    }

    public Marker(double d, Paint paint, Stroke stroke, Paint paint2, float f) {
        this.value = d;
        this.outlinePaint = paint;
        this.outlineStroke = stroke;
        this.paint = paint2;
        this.alpha = f;
    }

    public double getValue() {
        return this.value;
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public Paint getPaint() {
        return this.paint;
    }

    public float getAlpha() {
        return this.alpha;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.paint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.paint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
    }
}

