/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.annotations;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.annotations.TextAnnotation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.data.CategoryDataset;

public class CategoryTextAnnotation
extends TextAnnotation
implements CategoryAnnotation,
Serializable {
    private Comparable category;
    private double value;

    public CategoryTextAnnotation(String string, Comparable comparable, double d) {
        this(string, TextAnnotation.DEFAULT_FONT, comparable, d);
    }

    public CategoryTextAnnotation(String string, Font font, Comparable comparable, double d) {
        this(string, font, TextAnnotation.DEFAULT_PAINT, comparable, d);
    }

    public CategoryTextAnnotation(String string, Font font, Paint paint, Comparable comparable, double d) {
        super(string, font, paint);
        this.category = comparable;
        this.value = d;
    }

    public void draw(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, CategoryAxis categoryAxis, ValueAxis valueAxis) {
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        int n = categoryDataset.getColumnIndex(this.category);
        int n2 = categoryDataset.getColumnCount();
        float f = (float)categoryAxis.getCategoryMiddle(n, n2, rectangle2D);
        float f2 = (float)valueAxis.translateValueToJava2D(this.value, rectangle2D);
        graphics2D.setFont(this.getFont());
        graphics2D.setPaint(this.getPaint());
        graphics2D.drawString(this.getText(), f, f2);
    }
}

