/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.data.Range;

public abstract class ValueAxis
extends Axis
implements Serializable {
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 1.0E-7;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    private boolean inverted = false;
    private Range range = DEFAULT_RANGE;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 1.0E-7;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double minimumRangeLength = Double.MIN_VALUE;
    private double maximumRangeLength = Double.MAX_VALUE;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnits standardTickUnits;
    private int autoTickIndex;
    private double anchorValue;

    protected ValueAxis(String string, TickUnits tickUnits) {
        super(string);
        this.standardTickUnits = tickUnits;
        this.anchorValue = 0.0;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl) {
        if (this.inverted != bl) {
            this.inverted = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl) {
        this.setAutoRange(bl, true);
    }

    protected void setAutoRange(boolean bl, boolean bl2) {
        if (this.autoRange != bl) {
            this.autoRange = bl;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double d) {
        this.setAutoRangeMinimumSize(d, true);
    }

    public void setAutoRangeMinimumSize(double d, boolean bl) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != d) {
            this.autoRangeMinimumSize = d;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d) {
        this.upperMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d) {
        this.lowerMargin = d;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d) {
        this.fixedAutoRange = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getMinimumAxisValue() {
        return this.range.getLowerBound();
    }

    public void setMinimumAxisValue(double d) {
        this.setRange(new Range(d, this.range.getUpperBound()));
    }

    public double getMaximumAxisValue() {
        return this.range.getUpperBound();
    }

    public void setMaximumAxisValue(double d) {
        this.setRange(new Range(this.range.getLowerBound(), d));
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("ValueAxis.setRange(...): null not permitted.");
        }
        this.autoRange = false;
        this.range = range;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void setRangeAttribute(Range range) {
        this.range = range;
    }

    public void setRange(double d, double d2) {
        this.setRange(new Range(d, d2));
    }

    public void setRangeAboutValue(double d, double d2) {
        this.setRange(new Range(d - d2 / 2.0, d + d2 / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl) {
        this.setAutoTickUnitSelection(bl, true);
    }

    public void setAutoTickUnitSelection(boolean bl, boolean bl2) {
        if (this.autoTickUnitSelection != bl) {
            this.autoTickUnitSelection = bl;
            if (bl2) {
                this.notifyListeners(new AxisChangeEvent(this));
            }
        }
    }

    public TickUnits getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnits tickUnits) {
        this.standardTickUnits = tickUnits;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d) {
        this.anchorValue = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    protected void setAnchorValueAttribute(double d) {
        this.anchorValue = d;
    }

    public abstract double translateValueToJava2D(double var1, Rectangle2D var3);

    public abstract double translateJava2DtoValue(float var1, Rectangle2D var2);

    protected abstract void autoAdjustRange();

    public void setAnchoredRange(double d) {
        double d2 = this.anchorValue - d / 2.0;
        double d3 = this.anchorValue + d / 2.0;
        this.setRange(new Range(d2, d3));
    }

    public void centerRange(double d) {
        double d2 = this.range.getCentralValue();
        Range range = new Range(this.range.getLowerBound() + d - d2, this.range.getUpperBound() + d - d2);
        this.setRange(range);
    }

    public void resizeRange(double d) {
        this.resizeRange(d, this.range.getCentralValue());
    }

    public void resizeRange(double d, double d2) {
        double d3 = this.range.getLength() * d / 2.0;
        Range range = new Range(d2 - d3, d2 + d3);
        this.setRange(range);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int n) {
        this.autoTickIndex = n;
    }
}

