/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;
import org.jfree.chart.Effect3D;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.VerticalNumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.ui.RefineryUtilities;

public class VerticalNumberAxis3D
extends VerticalNumberAxis
implements Serializable {
    public VerticalNumberAxis3D(String string) {
        super(string);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        Cloneable cloneable;
        Object object;
        Serializable serializable;
        if (!this.isVisible()) {
            return;
        }
        String string = this.getLabel();
        if (string != null && !string.equals("")) {
            double d;
            double d2;
            serializable = this.getLabelFont();
            graphics2D.setFont((Font)serializable);
            graphics2D.setPaint(this.getLabelPaint());
            object = ((Font)serializable).getStringBounds(string, graphics2D.getFontRenderContext());
            cloneable = this.getLabelInsets();
            if (this.isVerticalLabel()) {
                d2 = rectangle2D.getX() + (double)cloneable.left + ((RectangularShape)object).getHeight();
                d = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + ((RectangularShape)object).getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d2), (float)((float)d), (double)-1.5707963267948966);
            } else {
                d2 = rectangle2D.getX() + (double)cloneable.left;
                d = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - ((RectangularShape)object).getHeight() / 2.0;
                graphics2D.drawString(string, (float)d2, (float)d);
            }
        }
        serializable = (CategoryPlot)this.getPlot();
        object = (Effect3D)((Object)((CategoryPlot)serializable).getRenderer());
        cloneable = new Rectangle2D.Double(rectangle2D2.getMinX(), rectangle2D2.getMinY() + object.getYOffset(), rectangle2D2.getWidth() - object.getXOffset(), rectangle2D2.getHeight() - object.getYOffset());
        this.refreshTicks(graphics2D, rectangle2D, (Rectangle2D)cloneable, n);
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), (Rectangle2D)cloneable);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            Line2D.Double double_ = new Line2D.Double(rectangle2D2.getX() - (double)this.getTickMarkOutsideLength(), f, rectangle2D2.getX(), f);
            graphics2D.draw(double_);
        }
    }

    private double get3DXOffset() {
        CategoryPlot categoryPlot;
        CategoryItemRenderer categoryItemRenderer;
        double d = 0.0;
        Plot plot = this.getPlot();
        if (plot != null && plot instanceof CategoryPlot && (categoryItemRenderer = (categoryPlot = (CategoryPlot)plot).getRenderer()) instanceof Effect3D) {
            Effect3D effect3D = (Effect3D)((Object)categoryItemRenderer);
            d = effect3D.getXOffset();
        }
        return d;
    }

    private double get3DYOffset() {
        CategoryPlot categoryPlot;
        CategoryItemRenderer categoryItemRenderer;
        double d = 0.0;
        Plot plot = this.getPlot();
        if (plot != null && plot instanceof CategoryPlot && (categoryItemRenderer = (categoryPlot = (CategoryPlot)plot).getRenderer()) instanceof Effect3D) {
            Effect3D effect3D = (Effect3D)((Object)categoryItemRenderer);
            d = effect3D.getYOffset();
        }
        return d;
    }
}

