/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.HorizontalAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.VerticalAxis;
import org.jfree.chart.axis.VerticalCategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.HorizontalValuePlot;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.Range;

public class HorizontalCategoryPlot
extends CategoryPlot
implements HorizontalValuePlot,
Serializable {
    public HorizontalCategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        super(categoryDataset, categoryAxis, valueAxis, categoryItemRenderer);
        this.setDomainAxisLocation(3, false);
        this.setRangeAxisLocation(1, false);
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis instanceof HorizontalAxis && axis instanceof ValueAxis;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalCategoryAxis;
    }

    public boolean isCompatibleDomainAxis(CategoryAxis categoryAxis) {
        if (categoryAxis == null) {
            return true;
        }
        return this.isCompatibleVerticalAxis(categoryAxis);
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return this.isCompatibleHorizontalAxis(valueAxis);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        CategoryItemRenderer categoryItemRenderer;
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        double d = 0.0;
        VerticalAxis verticalAxis = (VerticalAxis)((Object)this.getDomainAxis());
        if (verticalAxis != null) {
            d = verticalAxis.reserveWidth(graphics2D, this, rectangle2D, this.getDomainAxisLocation());
        }
        double d2 = 0.0;
        HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.getRangeAxis());
        if (horizontalAxis != null) {
            d2 = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D, this.getRangeAxisLocation(), d, this.getDomainAxisLocation());
        }
        double d3 = 0.0;
        int n = this.getOppositeAxisLocation(this.getRangeAxisLocation());
        HorizontalAxis horizontalAxis2 = (HorizontalAxis)((Object)this.getSecondaryRangeAxis());
        if (horizontalAxis2 != null) {
            d3 = horizontalAxis2.reserveHeight(graphics2D, this, rectangle2D, n, d, this.getDomainAxisLocation());
        }
        double d4 = this.getRectX(rectangle2D.getX(), d, 0.0, this.getDomainAxisLocation());
        double d5 = this.getRectY(rectangle2D.getY(), d2, d3, this.getRangeAxisLocation());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, rectangle2D.getWidth() - d, rectangle2D.getHeight() - d2 - d3);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea(double_);
        }
        if ((categoryItemRenderer = this.getRenderer()) != null) {
            categoryItemRenderer.drawBackground(graphics2D, this, double_);
        } else {
            this.drawBackground(graphics2D, double_);
        }
        this.getDomainAxis().draw(graphics2D, rectangle2D, double_, this.getDomainAxisLocation());
        this.getRangeAxis().draw(graphics2D, rectangle2D, double_, this.getRangeAxisLocation());
        ValueAxis valueAxis = this.getSecondaryRangeAxis();
        if (valueAxis != null) {
            int n2 = this.getOppositeAxisLocation(this.getRangeAxisLocation());
            valueAxis.draw(graphics2D, rectangle2D, double_, n2);
        }
        if (categoryItemRenderer != null) {
            Serializable serializable;
            Object object2;
            if (this.isDomainGridlinesVisible()) {
                Stroke stroke = this.getDomainGridlineStroke();
                object = this.getDomainGridlinePaint();
                if (stroke != null && object != null && (object2 = this.getCategoryDataset()) != null) {
                    serializable = this.getDomainAxis();
                    int n3 = object2.getColumnCount();
                    int n4 = 0;
                    while (n4 < n3) {
                        double d6 = ((CategoryAxis)serializable).getCategoryMiddle(n4, n3, double_);
                        categoryItemRenderer.drawDomainGridline(graphics2D, this, double_, d6);
                        ++n4;
                    }
                }
            }
            if (this.isRangeGridlinesVisible()) {
                Stroke stroke = this.getRangeGridlineStroke();
                object = this.getRangeGridlinePaint();
                if (stroke != null && object != null) {
                    object2 = this.getRangeAxis().getTicks().iterator();
                    while (object2.hasNext()) {
                        serializable = (Tick)object2.next();
                        categoryItemRenderer.drawRangeGridline(graphics2D, this, this.getRangeAxis(), double_, ((Tick)serializable).getNumericalValue());
                    }
                }
            }
        }
        if (this.getRangeMarkers() != null && this.getRenderer() != null) {
            Iterator iterator = this.getRangeMarkers().iterator();
            while (iterator.hasNext()) {
                object = (Marker)iterator.next();
                this.getRenderer().drawRangeMarker(graphics2D, this, this.getRangeAxis(), (Marker)object, double_);
            }
        }
        this.render(graphics2D, double_, chartRenderingInfo);
        this.render2(graphics2D, double_, chartRenderingInfo);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.drawOutline(graphics2D, this, double_);
        } else {
            this.drawOutline(graphics2D, double_);
        }
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        CategoryDataset categoryDataset = this.getCategoryDataset();
        if (categoryDataset != null) {
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            CategoryItemRenderer categoryItemRenderer = this.getRenderer();
            categoryItemRenderer.initialise(graphics2D, rectangle2D, this, chartRenderingInfo);
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    categoryItemRenderer.drawItem(graphics2D, rectangle2D, this, this.getDomainAxis(), this.getRangeAxis(), categoryDataset, 0, n4, n3);
                    ++n4;
                }
                ++n3;
            }
            ValueAxis valueAxis = this.getRangeAxis();
            if (this.isRangeCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
    }

    public void render2(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        CategoryDataset categoryDataset = this.getSecondaryCategoryDataset();
        if (categoryDataset != null) {
            CategoryItemRenderer categoryItemRenderer;
            Shape shape = graphics2D.getClip();
            graphics2D.clip(rectangle2D);
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            ValueAxis valueAxis = this.getSecondaryRangeAxis();
            if (valueAxis == null) {
                valueAxis = this.getRangeAxis();
            }
            if ((categoryItemRenderer = this.getSecondaryRenderer()) == null) {
                categoryItemRenderer = this.getRenderer();
            }
            categoryItemRenderer.initialise(graphics2D, rectangle2D, this, chartRenderingInfo);
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            int n3 = 0;
            while (n3 < n) {
                int n4 = 0;
                while (n4 < n2) {
                    categoryItemRenderer.drawItem(graphics2D, rectangle2D, this, this.getDomainAxis(), valueAxis, categoryDataset, 1, n4, n3);
                    ++n4;
                }
                ++n3;
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
    }

    public String getPlotType() {
        return "Horizontal Category Plot";
    }

    public Range getHorizontalDataRange(ValueAxis valueAxis) {
        Range range = null;
        CategoryDataset categoryDataset = this.getCategoryDataset();
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        if (valueAxis.equals(this.getSecondaryRangeAxis())) {
            categoryDataset = this.getSecondaryCategoryDataset();
            if (this.getSecondaryRenderer() != null) {
                categoryItemRenderer = this.getSecondaryRenderer();
            }
        }
        if (categoryDataset != null && categoryItemRenderer != null) {
            switch (categoryItemRenderer.getRangeType()) {
                case 1: {
                    range = DatasetUtilities.getStackedRangeExtent(categoryDataset);
                    break;
                }
                default: {
                    range = DatasetUtilities.getRangeExtent(categoryDataset);
                }
            }
        }
        return range;
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getRangeAxis();
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis = this.getRangeAxis();
        double d = valueAxis.translateJava2DtoValue(n, chartRenderingInfo.getDataArea());
        valueAxis.setAnchorValue(d);
        this.setRangeCrosshairValue(d);
    }

    private void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }
}

