/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisConstants;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.data.Dataset;
import org.jfree.data.DatasetChangeEvent;
import org.jfree.data.DatasetChangeListener;
import org.jfree.data.DatasetGroup;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Align;
import org.jfree.util.ObjectUtils;

public abstract class Plot
implements AxisChangeListener,
DatasetChangeListener,
AxisConstants,
Serializable {
    public static final Number ZERO = new Integer(0);
    public static final Insets DEFAULT_INSETS = new Insets(4, 8, 4, 8);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final float DEFAULT_FOREGROUND_ALPHA = 1.0f;
    public static final float DEFAULT_BACKGROUND_ALPHA = 1.0f;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final int MINIMUM_WIDTH_TO_DRAW = 10;
    public static final int MINIMUM_HEIGHT_TO_DRAW = 10;
    private Plot parent;
    private DatasetGroup datasetGroup;
    private Dataset dataset;
    private Dataset secondaryDataset;
    private String noDataMessage;
    private Font noDataMessageFont;
    private transient Paint noDataMessagePaint;
    private Insets insets;
    private transient Stroke outlineStroke;
    private transient Paint outlinePaint;
    private transient Paint backgroundPaint;
    private transient Image backgroundImage;
    private int backgroundImageAlignment = 15;
    private float foregroundAlpha;
    private float backgroundAlpha;
    private transient EventListenerList listenerList;
    private double dataAreaRatio = 0.0;
    static /* synthetic */ Class class$org$jfree$chart$event$PlotChangeListener;

    protected Plot(Dataset dataset) {
        this.dataset = dataset;
        if (dataset != null) {
            this.datasetGroup = dataset.getGroup();
            dataset.addChangeListener(this);
        }
        this.parent = null;
        this.secondaryDataset = null;
        this.insets = DEFAULT_INSETS;
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.backgroundAlpha = 1.0f;
        this.backgroundImage = null;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.foregroundAlpha = 1.0f;
        this.noDataMessage = null;
        this.noDataMessageFont = new Font("SansSerif", 0, 12);
        this.noDataMessagePaint = Color.black;
        this.listenerList = new EventListenerList();
    }

    public DatasetGroup getDatasetGroup() {
        return this.datasetGroup;
    }

    protected void setDatasetGroup(DatasetGroup datasetGroup) {
        this.datasetGroup = datasetGroup;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        Dataset dataset2 = this.dataset;
        if (dataset2 != null) {
            dataset2.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.datasetGroup = dataset.getGroup();
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public Dataset getSecondaryDataset() {
        return this.secondaryDataset;
    }

    public void setSecondaryDataset(Dataset dataset) {
        Dataset dataset2 = this.secondaryDataset;
        if (dataset2 != null) {
            dataset2.removeChangeListener(this);
        }
        this.secondaryDataset = dataset;
        if (dataset != null) {
            this.datasetGroup = dataset.getGroup();
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String string) {
        this.noDataMessage = string;
    }

    public Font getNoDataMessageFont() {
        return this.noDataMessageFont;
    }

    public void setNoDataMessageFont(Font font) {
        this.noDataMessageFont = font;
    }

    public Paint getNoDataMessagePaint() {
        return this.noDataMessagePaint;
    }

    public void setNoDataMessagePaint(Paint paint) {
        this.noDataMessagePaint = paint;
    }

    public abstract String getPlotType();

    public Plot getParent() {
        return this.parent;
    }

    public void setParent(Plot plot) {
        this.parent = plot;
    }

    public Plot getRootPlot() {
        Plot plot = this.getParent();
        if (plot == null) {
            return this;
        }
        return plot.getRootPlot();
    }

    public boolean isSubplot() {
        return this.getParent() != null;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.setInsets(insets, true);
    }

    public void setInsets(Insets insets, boolean bl) {
        if (!this.insets.equals(insets)) {
            this.insets = insets;
            if (bl) {
                this.notifyListeners(new PlotChangeEvent(this));
            }
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (paint == null) {
            if (this.backgroundPaint != null) {
                this.backgroundPaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.backgroundPaint != null && this.backgroundPaint.equals(paint)) {
                return;
            }
            this.backgroundPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float f) {
        if (this.backgroundAlpha != f) {
            this.backgroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int n) {
        if (this.backgroundImageAlignment != n) {
            this.backgroundImageAlignment = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            if (this.outlineStroke != null) {
                this.outlineStroke = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlineStroke != null && this.outlineStroke.equals(stroke)) {
                return;
            }
            this.outlineStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        if (paint == null) {
            if (this.outlinePaint != null) {
                this.outlinePaint = null;
                this.notifyListeners(new PlotChangeEvent(this));
            }
        } else {
            if (this.outlinePaint != null && this.outlinePaint.equals(paint)) {
                return;
            }
            this.outlinePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public float getForegroundAlpha() {
        return this.foregroundAlpha;
    }

    public void setForegroundAlpha(float f) {
        if (this.foregroundAlpha != f) {
            this.foregroundAlpha = f;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void addChangeListener(PlotChangeListener plotChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$PlotChangeListener == null ? (class$org$jfree$chart$event$PlotChangeListener = Plot.class$("org.jfree.chart.event.PlotChangeListener")) : class$org$jfree$chart$event$PlotChangeListener, plotChangeListener);
    }

    public void removeChangeListener(PlotChangeListener plotChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$PlotChangeListener == null ? (class$org$jfree$chart$event$PlotChangeListener = Plot.class$("org.jfree.chart.event.PlotChangeListener")) : class$org$jfree$chart$event$PlotChangeListener, plotChangeListener);
    }

    public void notifyListeners(PlotChangeEvent plotChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$jfree$chart$event$PlotChangeListener == null ? Plot.class$("org.jfree.chart.event.PlotChangeListener") : class$org$jfree$chart$event$PlotChangeListener)) {
                ((PlotChangeListener)objectArray[n + 1]).plotChanged(plotChangeEvent);
            }
            n -= 2;
        }
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, ChartRenderingInfo var3);

    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Composite composite;
        if (this.backgroundPaint != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundAlpha));
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
            graphics2D.setComposite(composite);
        }
        if (this.backgroundImage != null) {
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, this.backgroundAlpha));
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
            Align.align((Rectangle2D)double_, (Rectangle2D)rectangle2D, (int)this.backgroundImageAlignment);
            graphics2D.drawImage(this.backgroundImage, (int)((RectangularShape)double_).getX(), (int)((RectangularShape)double_).getY(), (int)((RectangularShape)double_).getWidth() + 1, (int)((RectangularShape)double_).getHeight() + 1, null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.outlineStroke != null && this.outlinePaint != null) {
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.draw(rectangle2D);
        }
    }

    protected void drawNoDataMessage(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        String string = this.noDataMessage;
        if (string != null) {
            graphics2D.setFont(this.noDataMessageFont);
            graphics2D.setPaint(this.noDataMessagePaint);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D2 = this.noDataMessageFont.getStringBounds(string, fontRenderContext);
            float f = (float)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - rectangle2D2.getWidth() / 2.0);
            float f2 = (float)(rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0 - rectangle2D2.getHeight() / 2.0);
            graphics2D.drawString(string, f, f2);
        }
        graphics2D.clip(shape);
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
    }

    public void zoom(double d) {
    }

    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }

    protected double getRectX(double d, double d2, double d3, int n) {
        double d4 = d;
        if (n == 3) {
            d4 += d2;
        } else if (n == 2) {
            d4 += d3;
        }
        return d4;
    }

    protected double getRectY(double d, double d2, double d3, int n) {
        double d4 = d;
        if (n == 0) {
            d4 += d2;
        } else if (n == 1) {
            d4 += d3;
        }
        return d4;
    }

    protected int getOppositeAxisLocation(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 0;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 3;
            }
        }
        return n2;
    }

    public double getDataAreaRatio() {
        return this.dataAreaRatio;
    }

    public void setDataAreaRatio(double d) {
        this.dataAreaRatio = d;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Plot) {
            Plot plot = (Plot)object;
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = ObjectUtils.equalOrBothNull((Object)this.dataset, (Object)plot.dataset);
            boolean bl4 = ObjectUtils.equalOrBothNull((Object)this.secondaryDataset, (Object)plot.secondaryDataset);
            boolean bl5 = ObjectUtils.equalOrBothNull((Object)this.noDataMessage, (Object)plot.noDataMessage);
            boolean bl6 = ObjectUtils.equalOrBothNull((Object)this.noDataMessageFont, (Object)plot.noDataMessageFont);
            boolean bl7 = ObjectUtils.equalOrBothNull((Object)this.noDataMessagePaint, (Object)plot.noDataMessagePaint);
            boolean bl8 = ObjectUtils.equalOrBothNull((Object)this.insets, (Object)plot.insets);
            boolean bl9 = ObjectUtils.equalOrBothNull((Object)this.outlineStroke, (Object)plot.outlineStroke);
            boolean bl10 = ObjectUtils.equalOrBothNull((Object)this.outlinePaint, (Object)plot.outlinePaint);
            boolean bl11 = ObjectUtils.equalOrBothNull((Object)this.backgroundPaint, (Object)plot.backgroundPaint);
            boolean bl12 = ObjectUtils.equalOrBothNull((Object)this.backgroundImage, (Object)plot.backgroundImage);
            boolean bl13 = this.backgroundImageAlignment == plot.backgroundImageAlignment;
            boolean bl14 = this.foregroundAlpha == plot.foregroundAlpha;
            boolean bl15 = this.backgroundAlpha == plot.backgroundAlpha;
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.noDataMessagePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.outlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.outlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.backgroundPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.noDataMessagePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.outlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.outlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.listenerList = new EventListenerList();
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
        }
        if (this.secondaryDataset != null) {
            this.secondaryDataset.addChangeListener(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

