/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;

public class AreaXYRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int AREA = 4;
    public static final int AREA_AND_SHAPES = 5;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotArea;
    private double shapeScale = 6.0;
    private boolean showOutline;
    private double zeroToJava2D;
    private transient Line2D line;
    private transient Polygon pArea = null;

    public AreaXYRenderer() {
        this(4);
    }

    public AreaXYRenderer(int n) {
        this(n, null, null);
    }

    public AreaXYRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
        if (n == 1) {
            this.plotShapes = true;
        }
        if (n == 2) {
            this.plotLines = true;
        }
        if (n == 3) {
            this.plotShapes = true;
            this.plotLines = true;
        }
        if (n == 4) {
            this.plotArea = true;
        }
        if (n == 5) {
            this.plotArea = true;
            this.plotShapes = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
        this.showOutline = false;
    }

    public boolean isOutline() {
        return this.showOutline;
    }

    public void setOutline(boolean bl) {
        this.showOutline = bl;
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public boolean getPlotArea() {
        return this.plotArea;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.zeroToJava2D = valueAxis.translateValueToJava2D(0.0, rectangle2D);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Object object;
        Object object2;
        int n4 = xYDataset.getItemCount(n2);
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getItemStroke(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n2, n3);
        Number number2 = xYDataset.getYValue(n2, n3);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        if (n3 == 0) {
            this.pArea = new Polygon();
            double d3 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            this.pArea.addPoint((int)d, (int)d3);
        }
        this.pArea.addPoint((int)d, (int)d2);
        Shape shape = null;
        if (this.plotShapes) {
            shape = this.getItemShape(n, n2, n3);
            shape = this.createTransformedShape(shape, d, d2);
            graphics2D.draw(shape);
        } else {
            shape = new Rectangle2D.Double(d - 2.0, d2 - 2.0, 4.0, 4.0);
        }
        if (this.plotLines && n3 > 0) {
            object2 = xYDataset.getXValue(n2, n3 - 1);
            object = xYDataset.getYValue(n2, n3 - 1);
            double d4 = valueAxis.translateValueToJava2D(((Number)object2).doubleValue(), rectangle2D);
            double d5 = valueAxis2.translateValueToJava2D(((Number)object).doubleValue(), rectangle2D);
            this.line.setLine(d4, d5, d, d2);
            graphics2D.draw(this.line);
        }
        if (this.plotArea && n3 > 0 && n3 == n4 - 1) {
            double d6 = valueAxis2.translateValueToJava2D(0.0, rectangle2D);
            this.pArea.addPoint((int)d, (int)d6);
            graphics2D.fill(this.pArea);
            if (this.showOutline) {
                graphics2D.setStroke(xYPlot.getOutlineStroke());
                graphics2D.setPaint(xYPlot.getOutlinePaint());
                graphics2D.draw(this.pArea);
            }
        }
        if (xYPlot.isDomainCrosshairLockedOnData()) {
            if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairPoint(number.doubleValue(), number2.doubleValue());
            } else {
                crosshairInfo.updateCrosshairX(number.doubleValue());
            }
        } else if (xYPlot.isRangeCrosshairLockedOnData()) {
            crosshairInfo.updateCrosshairY(number2.doubleValue());
        }
        if (this.getInfo() != null && (object2 = this.getInfo().getEntityCollection()) != null && shape != null) {
            object = null;
            if (this.getToolTipGenerator() != null) {
                object = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(shape, (String)object, string, n2, n3);
            object2.addEntity(xYItemEntity);
        }
    }
}

