/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.StandardXYToolTipGenerator;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.XYDataset;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean plotShapes;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private double gapThreshold = 1.0;
    private boolean defaultShapeFilled;
    private transient Line2D line;

    public StandardXYItemRenderer() {
        this(2, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n) {
        this(n, new StandardXYToolTipGenerator());
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
        if ((n & 1) != 0) {
            this.plotShapes = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if ((n & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    public boolean getPlotShapes() {
        return this.plotShapes;
    }

    public void setPlotShapes(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        if (this.plotShapes != bl) {
            this.plotShapes = bl;
            this.firePropertyChanged("renderer.PlotShapes", bl2, new Boolean(bl));
        }
    }

    public boolean getDefaultShapeFilled() {
        return this.defaultShapeFilled;
    }

    public void setDefaultShapeFilled(boolean bl) {
        Boolean bl2 = new Boolean(this.defaultShapeFilled);
        this.defaultShapeFilled = bl;
        this.firePropertyChanged("renderer.DefaultShapeFilled", bl2, new Boolean(bl));
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        if (this.plotLines != bl) {
            this.plotLines = bl;
            this.firePropertyChanged("renderer.PlotLines", bl2, new Boolean(bl));
        }
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d) {
        Double d2 = new Double(this.gapThreshold);
        this.gapThreshold = d;
        this.firePropertyChanged("renderer.GapThreshold", d2, new Double(d));
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl) {
        Boolean bl2 = new Boolean(bl);
        if (this.plotImages != bl) {
            this.plotImages = bl;
            this.firePropertyChanged("renderer.PlotImages", bl2, new Boolean(bl));
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Object object = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getItemStroke(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getXValue(n2, n3);
        Number number2 = xYDataset.getYValue(n2, n3);
        if (number2 != null) {
            Object object2;
            Object object3;
            double d;
            double d2 = number.doubleValue();
            double d3 = number2.doubleValue();
            double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            Paint paint2 = this.getPaint(xYPlot, n2, n3, d4, d = valueAxis2.translateValueToJava2D(d3, rectangle2D));
            if (paint2 != null) {
                graphics2D.setPaint(paint2);
            }
            if (this.plotLines && n3 > 0) {
                object3 = xYDataset.getXValue(n2, n3 - 1);
                object2 = xYDataset.getYValue(n2, n3 - 1);
                if (object2 != null) {
                    double d5 = ((Number)object3).doubleValue();
                    double d6 = ((Number)object2).doubleValue();
                    boolean bl = true;
                    if (this.plotDiscontinuous) {
                        int n4 = xYDataset.getItemCount(n2);
                        double d7 = xYDataset.getXValue(n2, 0).doubleValue();
                        double d8 = xYDataset.getXValue(n2, n4 - 1).doubleValue();
                        boolean bl2 = bl = d2 - d5 <= (d8 - d7) / (double)n4 * this.gapThreshold;
                    }
                    if (bl) {
                        double d9 = valueAxis.translateValueToJava2D(d5, rectangle2D);
                        double d10 = valueAxis2.translateValueToJava2D(d6, rectangle2D);
                        this.line.setLine(d9, d10, d4, d);
                        if (this.line.intersects(rectangle2D)) {
                            graphics2D.draw(this.line);
                        }
                    }
                }
            }
            if (this.plotShapes) {
                object3 = this.getItemShape(n, n2, n3);
                if ((object3 = this.createTransformedShape((Shape)object3, d4, d)).intersects(rectangle2D)) {
                    if (this.isShapeFilled(xYPlot, n2, n3, d4, d)) {
                        graphics2D.fill((Shape)object3);
                    } else {
                        graphics2D.draw((Shape)object3);
                    }
                }
                object = object3;
            }
            if (this.plotImages && (object3 = this.getImage(xYPlot, n2, n3, d4, d)) != null) {
                object2 = this.getImageHotspot(xYPlot, n2, n3, d4, d, (Image)object3);
                graphics2D.drawImage((Image)object3, (int)(d4 - ((Point)object2).getX()), (int)(d - ((Point)object2).getY()), null);
                object = new Rectangle2D.Double(d4 - ((Point)object2).getX(), d - ((Point)object2).getY(), ((Image)object3).getWidth(null), ((Image)object3).getHeight(null));
            }
            if (entityCollection != null) {
                if (object == null) {
                    object = new Rectangle2D.Double(d4 - 2.0, d - 2.0, 4.0, 4.0);
                }
                object3 = null;
                if (this.getToolTipGenerator() != null) {
                    object3 = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
                }
                object2 = null;
                if (this.getURLGenerator() != null) {
                    object2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
                }
                XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, (String)object3, (String)object2, n2, n3);
                entityCollection.addEntity(xYItemEntity);
            }
            if (xYPlot.isDomainCrosshairLockedOnData()) {
                if (xYPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d2, d3);
                } else {
                    crosshairInfo.updateCrosshairX(d2);
                }
            } else if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d3);
            }
        }
    }

    protected boolean isShapeFilled(Plot plot, int n, int n2, double d, double d2) {
        return this.defaultShapeFilled;
    }

    protected Paint getPaint(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Image getImage(Plot plot, int n, int n2, double d, double d2) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d, double d2, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof StandardXYItemRenderer) {
            StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)object;
            if (super.equals(object)) {
                boolean bl = this.plotShapes == standardXYItemRenderer.plotShapes;
                boolean bl2 = this.plotLines == standardXYItemRenderer.plotLines;
                boolean bl3 = this.plotImages == standardXYItemRenderer.plotImages;
                boolean bl4 = this.plotDiscontinuous == standardXYItemRenderer.plotDiscontinuous;
                boolean bl5 = this.gapThreshold == standardXYItemRenderer.gapThreshold;
                boolean bl6 = this.defaultShapeFilled == standardXYItemRenderer.defaultShapeFilled;
                return bl && bl2 && bl3 && bl4 && bl5 && bl6;
            }
        }
        return false;
    }
}

