/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.jfree.data.DefaultPieDataset;

public class JDBCPieDataset
extends DefaultPieDataset {
    private Connection connection;
    private Statement statement;
    private ResultSet resultSet;
    private ResultSetMetaData metaData;

    public JDBCPieDataset(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            this.connection = DriverManager.getConnection(string, string3, string4);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("JDBCPieDataset: cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("JDBCPieDataset: cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public JDBCPieDataset(Connection connection) {
        this.connection = connection;
    }

    public JDBCPieDataset(Connection connection, String string) {
        this(connection);
        this.executeQuery(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String string) {
        if (this.connection == null) {
            System.err.println("There is no database to execute the query.");
            return;
        }
        try {
            this.statement = this.connection.createStatement();
            this.resultSet = this.statement.executeQuery(string);
            this.metaData = this.resultSet.getMetaData();
            int n = this.metaData.getColumnCount();
            if (n != 2) {
                System.err.println("Invalid sql generated.  PieDataSet requires 2 columns only");
            }
            while (this.resultSet.next()) {
                String string2 = this.resultSet.getString(1);
                Number number = null;
                int n2 = this.metaData.getColumnType(2);
                switch (n2) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: {
                        number = (Number)this.resultSet.getObject(2);
                        this.setValue((Comparable)((Object)string2), number);
                        break;
                    }
                    case 91: 
                    case 93: {
                        Date date = (Date)this.resultSet.getObject(2);
                        number = new Long(date.getTime());
                        break;
                    }
                    default: {
                        System.err.println("JDBCPieDataset - unknown data type");
                    }
                }
            }
            this.fireDatasetChanged();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
        }
        finally {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (Exception exception) {
                    System.err.println("JDBCPieDataset: swallowing exception.");
                }
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception exception) {
                    System.err.println("JDBCPieDataset: swallowing exception.");
                }
            }
        }
    }
}

