/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.jfree.data.AbstractSeriesDataset;
import org.jfree.data.DomainInfo;
import org.jfree.data.IntervalXYDataset;
import org.jfree.data.Range;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;
import org.jfree.data.time.TimePeriodValues;

public class TimePeriodValuesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset,
DomainInfo,
Serializable {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private List data = new ArrayList();
    private Calendar workingCalendar;
    private int position;
    private boolean domainIsPointsInTime;

    public TimePeriodValuesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimePeriodValuesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimePeriodValuesCollection(TimePeriodValues timePeriodValues) {
        this(timePeriodValues, TimeZone.getDefault());
    }

    public TimePeriodValuesCollection(TimePeriodValues timePeriodValues, TimeZone timeZone) {
        if (timePeriodValues != null) {
            this.data.add(timePeriodValues);
            timePeriodValues.addChangeListener(this);
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.position = 1;
        this.domainIsPointsInTime = true;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl) {
        this.domainIsPointsInTime = bl;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimePeriodValues getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimePeriodValuesCollection.getSeries(...): index outside valid range.");
        }
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        return timePeriodValues;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public void addSeries(TimePeriodValues timePeriodValues) {
        if (timePeriodValues == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.add(timePeriodValues);
        timePeriodValues.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimePeriodValues timePeriodValues) {
        if (timePeriodValues == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.remove(timePeriodValues);
        timePeriodValues.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        TimePeriodValues timePeriodValues = this.getSeries(n);
        if (timePeriodValues != null) {
            this.removeSeries(timePeriodValues);
        }
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        TimePeriod timePeriod = timePeriodValue.getPeriod();
        return new Long(this.getX(timePeriod));
    }

    private long getX(TimePeriod timePeriod) {
        long l = 0L;
        switch (this.position) {
            case 0: {
                l = timePeriod.getStart().getTime();
                break;
            }
            case 1: {
                l = timePeriod.getStart().getTime() / 2L + timePeriod.getEnd().getTime() / 2L;
                break;
            }
            case 2: {
                l = timePeriod.getEnd().getTime();
                break;
            }
            default: {
                l = timePeriod.getStart().getTime() / 2L + timePeriod.getEnd().getTime() / 2L;
            }
        }
        return l;
    }

    public Number getStartXValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        return new Long(timePeriodValue.getPeriod().getStart().getTime());
    }

    public Number getEndXValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        return new Long(timePeriodValue.getPeriod().getEnd().getTime());
    }

    public Number getYValue(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)this.data.get(n);
        TimePeriodValue timePeriodValue = timePeriodValues.getDataItem(n2);
        return timePeriodValue.getValue();
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getMinimumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getLowerBound());
    }

    public Number getMaximumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getUpperBound());
    }

    public Range getDomainRange() {
        Range range = null;
        Range range2 = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimePeriodValues timePeriodValues = (TimePeriodValues)iterator.next();
            int n = timePeriodValues.getItemCount();
            if (n <= 0) continue;
            TimePeriod timePeriod = timePeriodValues.getTimePeriod(0);
            TimePeriod timePeriod2 = timePeriodValues.getTimePeriod(n - 1);
            range2 = this.domainIsPointsInTime ? new Range(this.getX(timePeriod), this.getX(timePeriod2)) : new Range(timePeriod.getStart().getTime(), timePeriod2.getEnd().getTime());
            range = Range.combine(range, range2);
        }
        return range;
    }
}

