/*
 * DocumentTreeEntry.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 0.43
 */

package it.businesslogic.ireport;
import it.businesslogic.ireport.gui.*;
/**
 *
 * @author  Administrator
 */
public class DocumentTreeEntry {
    
    private JReportFrame jrf;
    private String filename; // used only if the report is closed (jrf == null)
    
    /** Creates a new instance of DocumentTreeEntry */
    public DocumentTreeEntry(JReportFrame jrf, String filename) {
        this.jrf = jrf;
        this.filename = filename;
    }
    
    public String toString()
    {
        if (filename == null && jrf == null) return "Unknow doc";
        
        if (jrf == null)
        {
            java.io.File file = new java.io.File(filename);
            return file.getName();
        } 

        if (jrf.getReport().getFilename() == null || jrf.getReport().getFilename().equals(""))
            return "["+jrf.getReport().getName()+"]";
        else
        {
            java.io.File file = new java.io.File(jrf.getReport().getFilename());
           return file.getName();
        }
    }
    
    /** Getter for property filename.
     * @return Value of property filename.
     *
     */
    public java.lang.String getFilename() {
        return filename;
    }
    
    /** Setter for property filename.
     * @param filename New value of property filename.
     *
     */
    public void setFilename(java.lang.String filename) {
        this.filename = filename;
    }
    
    /** Getter for property jrf.
     * @return Value of property jrf.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJrf() {
        return jrf;
    }
    
    /** Setter for property jrf.
     * @param jrf New value of property jrf.
     *
     */
    public void setJrf(it.businesslogic.ireport.gui.JReportFrame jrf) {
        this.jrf = jrf;
    }
    
}
