/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.connection.*;
import java.sql.*;
import javax.swing.*;
/**
 *
 * @author  Administrator
 */
public class ConnectionDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    JRParameter tmpParameter = null;
    private boolean init = false;
    
    public ConnectionDialog(java.awt.Frame parent, boolean modal) {
        
        super(parent, modal);
        initComponents();
        this.setSize(400, 300);           
        Misc.centerFrame(this);
        init = true;
        jComboBoxConnectionType.addItem( "Database JDBC connection"); // Type 0
        jComboBoxConnectionType.addItem( "XML file datasource"); // Type 1
        jComboBoxConnectionType.addItem( "JavaBeans set datasource"); // Type 2
        jComboBoxConnectionType.addItem( "Custom JRDataSource"); // Type 3        
        
        jComboBoxJDBCDriver.addItem("com.mysql.jdbc.Driver");
        jComboBoxJDBCDriver.addItem("org.gjt.mm.mysql.Driver");
        jComboBoxJDBCDriver.addItem("com.internetcds.jdbc.tds.Driver");
	jComboBoxJDBCDriver.addItem("com.microsoft.jdbc.sqlserver.SQLServerDriver");
	jComboBoxJDBCDriver.addItem("sun.jdbc.odbc.JdbcOdbcDriver");
	jComboBoxJDBCDriver.addItem("com.ms.jdbc.odbc.JdbcOdbcDriver");
	jComboBoxJDBCDriver.addItem("oracle.jdbc.driver.OracleDriver");
	jComboBoxJDBCDriver.addItem("COM.ibm.db2.jdbc.app.DB2Driver");
	jComboBoxJDBCDriver.addItem("com.informix.jdbc.IfxDriver");
	jComboBoxJDBCDriver.addItem("com.sybase.jdbc2.jdbc.SybDriver");
	jComboBoxJDBCDriver.addItem("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver");
	jComboBoxJDBCDriver.addItem("com.inet.tds.TdsDriver");
	jComboBoxJDBCDriver.addItem("org.postgresql.Driver");
	jComboBoxJDBCDriver.addItem("org.hsqldb.jdbcDriver");
	jComboBoxJDBCDriver.addItem("COM.cloudscape.JDBCDriver");
        
        
        init = false;
        
        jComboBoxConnectionType.setSelectedIndex(0);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroupBeansSetType = new javax.swing.ButtonGroup();
        jPanel1 = new javax.swing.JPanel();
        jPanelConnectionType = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxConnectionType = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jPanelButtons = new javax.swing.JPanel();
        jSeparator1 = new javax.swing.JSeparator();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jButtonOK1 = new javax.swing.JButton();
        jPanelConnectionRoot = new javax.swing.JPanel();
        jPanelXML = new javax.swing.JPanel();
        jLabel9 = new javax.swing.JLabel();
        jTextFieldName5 = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jPanelBeansSet = new javax.swing.JPanel();
        jLabel12 = new javax.swing.JLabel();
        jTextFieldJBSetFactoryClass = new javax.swing.JTextField();
        jRadioButtonJBSetCollection = new javax.swing.JRadioButton();
        jRadioButtonJBSetArray = new javax.swing.JRadioButton();
        jLabel13 = new javax.swing.JLabel();
        jTextFieldName9 = new javax.swing.JTextField();
        jPanelJDBC = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jCheckBoxSavePassword = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        jComboBoxJDBCDriver = new javax.swing.JComboBox();
        jTextFieldJDBCUrl = new javax.swing.JTextField();
        jButtonWizard = new javax.swing.JButton();
        jLabel5 = new javax.swing.JLabel();
        jTextFieldDBName = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jTextFieldUsername = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jTextArea1 = new javax.swing.JTextArea();
        jTextFieldPassword = new javax.swing.JPasswordField();
        jPanelCustomDataSourceFactory = new javax.swing.JPanel();
        jLabel10 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceFactoryClass = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        jTextFieldJRCustomDataSourceMethod = new javax.swing.JTextField();

        setTitle("Connections properties");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.BorderLayout());

        jPanelConnectionType.setLayout(null);

        jPanelConnectionType.setPreferredSize(new java.awt.Dimension(10, 70));
        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setText("Type of connection / datasource");
        jPanelConnectionType.add(jLabel4);
        jLabel4.setBounds(8, 2, 260, 15);

        jComboBoxConnectionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxConnectionTypeActionPerformed(evt);
            }
        });

        jPanelConnectionType.add(jComboBoxConnectionType);
        jComboBoxConnectionType.setBounds(6, 20, 378, 22);

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Name");
        jPanelConnectionType.add(jLabel1);
        jLabel1.setBounds(6, 48, 44, 15);

        jTextFieldName.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelConnectionType.add(jTextFieldName);
        jTextFieldName.setBounds(52, 46, 332, 22);

        jPanel1.add(jPanelConnectionType, java.awt.BorderLayout.NORTH);

        jPanelButtons.setLayout(null);

        jPanelButtons.setPreferredSize(new java.awt.Dimension(0, 40));
        jPanelButtons.add(jSeparator1);
        jSeparator1.setBounds(4, 4, 382, 2);

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('s');
        jButtonOK.setText("Save");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonOK);
        jButtonOK.setBounds(232, 12, 70, 25);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonCancel);
        jButtonCancel.setBounds(312, 12, 70, 25);

        jButtonOK1.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK1.setMnemonic('t');
        jButtonOK1.setText("Test");
        jButtonOK1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOK1ActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonOK1);
        jButtonOK1.setBounds(156, 12, 70, 25);

        jPanel1.add(jPanelButtons, java.awt.BorderLayout.SOUTH);

        jPanelConnectionRoot.setLayout(new java.awt.BorderLayout());

        jPanelXML.setLayout(null);

        jPanelXML.setPreferredSize(new java.awt.Dimension(1, 30));
        jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel9.setText("XML file");
        jPanelXML.add(jLabel9);
        jLabel9.setBounds(6, 10, 62, 15);

        jTextFieldName5.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelXML.add(jTextFieldName5);
        jTextFieldName5.setBounds(68, 6, 238, 22);

        jButton2.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton2.setText("Browse");
        jButton2.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jPanelXML.add(jButton2);
        jButton2.setBounds(310, 6, 74, 22);

        jPanelConnectionRoot.add(jPanelXML, java.awt.BorderLayout.CENTER);

        jPanelBeansSet.setLayout(null);

        jLabel12.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel12.setText("Factory class (the class that will produce the set)");
        jPanelBeansSet.add(jLabel12);
        jLabel12.setBounds(8, 2, 296, 15);

        jTextFieldJBSetFactoryClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJBSetFactoryClass.setText("it.businesslogic.ireport.connections.SampleBeanFactory");
        jPanelBeansSet.add(jTextFieldJBSetFactoryClass);
        jTextFieldJBSetFactoryClass.setBounds(8, 18, 354, 22);

        jRadioButtonJBSetCollection.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonJBSetCollection.setText(" Collection of javaBeans");
        buttonGroupBeansSetType.add(jRadioButtonJBSetCollection);
        jPanelBeansSet.add(jRadioButtonJBSetCollection);
        jRadioButtonJBSetCollection.setBounds(10, 82, 288, 23);

        jRadioButtonJBSetArray.setFont(new java.awt.Font("Dialog", 0, 11));
        jRadioButtonJBSetArray.setSelected(true);
        jRadioButtonJBSetArray.setText("Array of javaBeans");
        buttonGroupBeansSetType.add(jRadioButtonJBSetArray);
        jRadioButtonJBSetArray.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButtonJBSetArrayActionPerformed(evt);
            }
        });

        jPanelBeansSet.add(jRadioButtonJBSetArray);
        jRadioButtonJBSetArray.setBounds(10, 100, 288, 23);

        jLabel13.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel13.setText("The static method to call to retrive the array or the the collection of javaBeans");
        jPanelBeansSet.add(jLabel13);
        jLabel13.setBounds(10, 42, 382, 15);

        jTextFieldName9.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldName9.setText("getSampleBeansArray");
        jPanelBeansSet.add(jTextFieldName9);
        jTextFieldName9.setBounds(8, 58, 354, 22);

        jPanelConnectionRoot.add(jPanelBeansSet, java.awt.BorderLayout.CENTER);

        jPanelJDBC.setLayout(null);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setText("JDBC Driver");
        jPanelJDBC.add(jLabel2);
        jLabel2.setBounds(4, 8, 62, 15);

        jCheckBoxSavePassword.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxSavePassword.setText("Save password");
        jPanelJDBC.add(jCheckBoxSavePassword);
        jCheckBoxSavePassword.setBounds(248, 102, 140, 23);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setText("JDBC URL");
        jPanelJDBC.add(jLabel3);
        jLabel3.setBounds(4, 32, 62, 15);

        jComboBoxJDBCDriver.setEditable(true);
        jComboBoxJDBCDriver.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelJDBC.add(jComboBoxJDBCDriver);
        jComboBoxJDBCDriver.setBounds(68, 6, 316, 22);

        jTextFieldJDBCUrl.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelJDBC.add(jTextFieldJDBCUrl);
        jTextFieldJDBCUrl.setBounds(68, 30, 242, 22);

        jButtonWizard.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonWizard.setText("Wizard");
        jButtonWizard.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonWizard.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonWizardActionPerformed(evt);
            }
        });

        jPanelJDBC.add(jButtonWizard);
        jButtonWizard.setBounds(312, 30, 72, 22);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setText("Database");
        jPanelJDBC.add(jLabel5);
        jLabel5.setBounds(4, 56, 62, 15);

        jTextFieldDBName.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelJDBC.add(jTextFieldDBName);
        jTextFieldDBName.setBounds(68, 54, 160, 22);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setText("Username");
        jPanelJDBC.add(jLabel6);
        jLabel6.setBounds(4, 80, 62, 15);

        jTextFieldUsername.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelJDBC.add(jTextFieldUsername);
        jTextFieldUsername.setBounds(68, 78, 160, 22);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setText("Password");
        jPanelJDBC.add(jLabel7);
        jLabel7.setBounds(4, 104, 62, 15);

        jLabel8.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel8.setText("Required only for DB browsing");
        jPanelJDBC.add(jLabel8);
        jLabel8.setBounds(230, 56, 166, 15);

        jTextArea1.setBackground(new java.awt.Color(204, 204, 204));
        jTextArea1.setEditable(false);
        jTextArea1.setFont(new java.awt.Font("Dialog", 0, 10));
        jTextArea1.setLineWrap(true);
        jTextArea1.setRows(3);
        jTextArea1.setText("ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it.");
        jTextArea1.setWrapStyleWord(true);
        jPanelJDBC.add(jTextArea1);
        jTextArea1.setBounds(4, 134, 380, 30);

        jTextFieldPassword.setFont(new java.awt.Font("Dialog", 0, 11));
        jPanelJDBC.add(jTextFieldPassword);
        jTextFieldPassword.setBounds(68, 102, 160, 22);

        jPanelConnectionRoot.add(jPanelJDBC, java.awt.BorderLayout.CENTER);

        jPanelCustomDataSourceFactory.setLayout(null);

        jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel10.setText("Factory class");
        jPanelCustomDataSourceFactory.add(jLabel10);
        jLabel10.setBounds(10, 14, 296, 15);

        jTextFieldJRCustomDataSourceFactoryClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJRCustomDataSourceFactoryClass.setText("it.businesslogic.ireport.connections.SampleJRDataSourceFactory");
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceFactoryClass);
        jTextFieldJRCustomDataSourceFactoryClass.setBounds(8, 32, 354, 22);

        jLabel11.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel11.setText("The static method to call to retrive the JRDataSource");
        jPanelCustomDataSourceFactory.add(jLabel11);
        jLabel11.setBounds(10, 62, 350, 15);

        jTextFieldJRCustomDataSourceMethod.setFont(new java.awt.Font("Dialog", 0, 11));
        jTextFieldJRCustomDataSourceMethod.setText("getSampleCustomJRDataSource");
        jPanelCustomDataSourceFactory.add(jTextFieldJRCustomDataSourceMethod);
        jTextFieldJRCustomDataSourceMethod.setBounds(8, 80, 354, 22);

        jPanelConnectionRoot.add(jPanelCustomDataSourceFactory, java.awt.BorderLayout.CENTER);

        jPanel1.add(jPanelConnectionRoot, java.awt.BorderLayout.CENTER);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jRadioButtonJBSetArrayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonJBSetArrayActionPerformed
        // Add your handling code here:
    }//GEN-LAST:event_jRadioButtonJBSetArrayActionPerformed

    private void jButtonOK1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOK1ActionPerformed
        // 
        if (jComboBoxConnectionType.getSelectedIndex() == 0)
        {
            // Try the java connection...
            try {
                        Class.forName((String)jComboBoxJDBCDriver.getSelectedItem() ).newInstance();;
				Connection conn = DriverManager.getConnection(this.jTextFieldJDBCUrl.getText(),
				this.jTextFieldUsername.getText(),
				this.jTextFieldPassword.getText()); 
				Statement stmt = conn.createStatement();
			}catch (NoClassDefFoundError ex)
			{
				JOptionPane.showMessageDialog(null,"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (ClassNotFoundException ex)
			{
				JOptionPane.showMessageDialog(null,"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (java.sql.SQLException ex)
			{
				JOptionPane.showMessageDialog(null,"SQL problems:\n"+ex.getMessage()+"\n"+this.jTextFieldJDBCUrl.getText() ,"Error",JOptionPane.ERROR_MESSAGE);
				return;					
			} 
			catch (Exception ex)
			{
				JOptionPane.showMessageDialog(null,"General problem:\n"+ex.getMessage()+"\n\nPlease chack your username and password. The DBMS is running?!","Error",JOptionPane.ERROR_MESSAGE);
				return;					
			}
			JOptionPane.showMessageDialog(null,"Connection tested succesfully!","",JOptionPane.INFORMATION_MESSAGE);
			return;
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3)
        {
            try {
                Object obj = Class.forName((String)jTextFieldJRCustomDataSourceFactoryClass.getText().trim()).newInstance();
                obj.getClass().getMethod( (String)jTextFieldJRCustomDataSourceMethod.getText().trim(), new Class[0]).invoke(obj,new Object[0]);                
            } catch (NoClassDefFoundError ex)
	    {
		JOptionPane.showMessageDialog(null,"NoClassDefFoundError!!\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
	    catch (ClassNotFoundException ex)
	    {
		JOptionPane.showMessageDialog(null,"ClassNotFoundError:\n"+ ex.getMessage() +"\n\nCheck your classpath!","Error",JOptionPane.ERROR_MESSAGE);
		return;					
	    } 
            catch (Exception ex)
            {
                JOptionPane.showMessageDialog(null,"Exception:\n"+ ex.getMessage() +"\n","Error",JOptionPane.ERROR_MESSAGE);
		return;	
            }
            JOptionPane.showMessageDialog(null,"Connection tested succesfully!","",JOptionPane.INFORMATION_MESSAGE);
	    return;
        }
    }//GEN-LAST:event_jButtonOK1ActionPerformed

    private void jButtonWizardActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonWizardActionPerformed
          
          if (jComboBoxJDBCDriver.getSelectedIndex() < 0) return;
          String driver = ""+jComboBoxJDBCDriver.getSelectedItem();
          driver = driver.trim();
          if (driver.equals("")) return;
        
          
          if (driver.equalsIgnoreCase("org.gjt.mm.mysql.Driver"))
			{
				String url = "jdbc:mysql://localhost/";
				if (((String)jTextFieldDBName.getText()).trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
                        else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver"))
			{
				String url = "jdbc:mysql://localhost/";
				if (((String)jTextFieldDBName.getText()).trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.internetcds.jdbc.tds.Driver"))
			{
				String url = "jdbc:freetds:sqlserver://localhost/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.microsoft.jdbc.sqlserver.SQLServerDriver"))
			{
				String url = "jdbc:microsoft:sqlserver://localhost:1433;DatabaseName=";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("sun.jdbc.odbc.JdbcOdbcDriver"))
			{
				String url = "jdbc:odbc:";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "DSNAME";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.ms.jdbc.odbc.JdbcOdbcDriver"))
			{
				String url = "jdbc:odbc:";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "DSNAME";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("oracle.jdbc.driver.OracleDriver"))
			{
				String url = "jdbc:oracle:thin:@localhost:1521:";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("COM.ibm.db2.jdbc.app.DB2Driver"))
			{
				String url = "jdbc:db2:";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.informix.jdbc.IfxDriver"))
			{
				String url = "jdbc:informix-sqli://localhost:port/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				
				url += ":informixserver=SERVERNAME";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.sybase.jdbc2.jdbc.SybDriver"))
			{
				String url = "jdbc:sybase:Tds:localhost:2638";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.mysql.jdbc.Driver"))
			{
				String url = "jdbc:mysql://localhost/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("com.merant.datadirect.jdbc.sqlserver.SQLServerDriver"))
			{
				String url = "jdbc:sqlserver://localhost:1433/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
					else if (driver.equalsIgnoreCase("com.inet.tds.TdsDriver"))
			{
				String url = "jdbc:inetdae7:localhost:1433/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("org.postgresql.Driver"))
			{
				String url = "jdbc:postgresql://localhost:5432/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("org.hsqldb.jdbcDriver"))
			{
				String url = "jdbc:hsqldb:[PATH_TO_DB_FILES]/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
			else if (driver.equalsIgnoreCase("COM.cloudscape.JDBCDriver "))
			{
				String url = "jdbc:cloudscape:/cloudscape/";
				if (jTextFieldDBName.getText().trim().length()>0)
					url += jTextFieldDBName.getText();
				else
					url += "MYDATABASE";
				jTextFieldJDBCUrl.setText(url);
			}
    }//GEN-LAST:event_jButtonWizardActionPerformed

    private void jComboBoxConnectionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxConnectionTypeActionPerformed
        if (init) return;
        jPanelConnectionRoot.removeAll();
        if (jComboBoxConnectionType.getSelectedIndex() == 0)
        {
            jPanelConnectionRoot.add("Center", jPanelJDBC);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 1)
        {
            jPanelConnectionRoot.add("Center", jPanelXML);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 2)
        {
            jPanelConnectionRoot.add("Center", jPanelBeansSet);
        }
        else if (jComboBoxConnectionType.getSelectedIndex() == 3)
        {
            jPanelConnectionRoot.add("Center", jPanelCustomDataSourceFactory);
        }
        
        jPanelConnectionRoot.updateUI();
    }//GEN-LAST:event_jComboBoxConnectionTypeActionPerformed

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
         if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid connection name!","Invalid parameter!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
         if (jComboBoxConnectionType.getSelectedIndex() == 0)
         {
            iReportConnection = new JDBCConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JDBCConnection)iReportConnection).setDatabase( this.jTextFieldName.getText().trim() );
            ((JDBCConnection)iReportConnection).setUsername( this.jTextFieldUsername.getText().trim() );
            if (!jCheckBoxSavePassword.isSelected())
                ((JDBCConnection)iReportConnection).setPassword( this.jTextFieldPassword.getText());
            else
                 ((JDBCConnection)iReportConnection).setPassword("");
            ((JDBCConnection)iReportConnection).setSavePassword( jCheckBoxSavePassword.isSelected() );
            ((JDBCConnection)iReportConnection).setJDBCDriver( (this.jComboBoxJDBCDriver.getSelectedItem()+"").trim() );
            if ((this.jComboBoxJDBCDriver.getSelectedItem()+"").trim().length() == 0)
            {
                javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid JDBC driver!","Invalid driver!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            
            if (this.jTextFieldJDBCUrl.getText().trim().length() == 0)
            {
                javax.swing.JOptionPane.showMessageDialog(this,"Please insert a valid JDBC URL!","Invalid url!",javax.swing.JOptionPane.WARNING_MESSAGE );
                return;
            }
            ((JDBCConnection)iReportConnection).setUrl(this.jTextFieldJDBCUrl.getText().trim());
            ((JDBCConnection)iReportConnection).setDatabase( this.jTextFieldName.getText().trim() );
         }
         else if (jComboBoxConnectionType.getSelectedIndex() == 3)
         {
            iReportConnection = new JRCustomDataSourceConnection();
            iReportConnection.setName( this.jTextFieldName.getText().trim() );
            ((JRCustomDataSourceConnection)iReportConnection).setFactoryClass( this.jTextFieldJRCustomDataSourceFactoryClass.getText().trim() );
            ((JRCustomDataSourceConnection)iReportConnection).setMethodToCall( this.jTextFieldJRCustomDataSourceMethod.getText().trim() );
         }
         
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public it.businesslogic.ireport.JRParameter getParameter() {
        return tmpParameter;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setParameter(it.businesslogic.ireport.JRParameter tmpParameter) {
       }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property iReportConnection.
     * @return Value of property iReportConnection.
     *
     */
    public it.businesslogic.ireport.IReportConnection getIReportConnection() {
        return iReportConnection;
    }
    
    /** Setter for property iReportConnection.
     * @param iReportConnection New value of property iReportConnection.
     *
     */
    public void setIReportConnection(it.businesslogic.ireport.IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
        
        this.jTextFieldName.setText( iReportConnection.getName());
        if (iReportConnection instanceof JDBCConnection)
        {
            JDBCConnection con = (JDBCConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(0);
            this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            this.jTextFieldJDBCUrl.setText( con.getUrl());
            this.jTextFieldDBName.setText( con.getDatabase() );
            this.jTextFieldUsername.setText( con.getUsername());
            this.jTextFieldPassword.setText( con.getPassword());
            this.jCheckBoxSavePassword.setSelected( con.isSavePassword());
        }
        else if (iReportConnection instanceof JRCustomDataSourceConnection)
        {
            JRCustomDataSourceConnection con = (JRCustomDataSourceConnection)iReportConnection;
            this.jComboBoxConnectionType.setSelectedIndex(3);
            this.jTextFieldJRCustomDataSourceFactoryClass.setText( con.getFactoryClass());
            this.jTextFieldJRCustomDataSourceMethod.setText(con.getMethodToCall());
        }
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel8;
    private javax.swing.JPanel jPanelJDBC;
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceMethod;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel12;
    private javax.swing.ButtonGroup buttonGroupBeansSetType;
    private javax.swing.JRadioButton jRadioButtonJBSetCollection;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JTextField jTextFieldName5;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JPanel jPanelBeansSet;
    private javax.swing.JButton jButtonOK1;
    private javax.swing.JPanel jPanelConnectionRoot;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanelXML;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanelConnectionType;
    private javax.swing.JRadioButton jRadioButtonJBSetArray;
    private javax.swing.JComboBox jComboBoxConnectionType;
    private javax.swing.JTextField jTextFieldDBName;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JTextField jTextFieldJBSetFactoryClass;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JCheckBox jCheckBoxSavePassword;
    private javax.swing.JTextField jTextFieldName9;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTextField jTextFieldJRCustomDataSourceFactoryClass;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JComboBox jComboBoxJDBCDriver;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JTextField jTextFieldUsername;
    private javax.swing.JPanel jPanelCustomDataSourceFactory;
    private javax.swing.JButton jButtonWizard;
    private javax.swing.JPasswordField jTextFieldPassword;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JTextField jTextFieldJDBCUrl;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    private IReportConnection iReportConnection;
    
}
