/*
 * ElementPropertiesDialog.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * How this window work.
 * This form has an attribute that rappresents the JReportForm active.
 * If the jrf is null, this frame hides.
 * When something changes, the program can call "updateSelection". This
 * class retrive from jrf the selected elements and update all
 * interface.
 *  
 * Created on 28 aprile 2003, 23.53
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.chart.*;
import java.util.*;
import java.awt.*;
import javax.swing.table.*;
import it.businesslogic.ireport.*;
/**
 *
 * @author  Administrator
 */
public class ElementPropertiesDialog extends javax.swing.JDialog {
    
    public static final int GRAPHICS_TAB = 1;
    public static final int RECTANGLE_TAB = 2;
    public static final int LINE_TAB = 3;
    public static final int IMAGE_TAB = 4;
    public static final int FONT_TAB = 5;
    public static final int STATITEXT_TAB = 6;
    public static final int TEXTFIELD_TAB = 7;
    public static final int HYPERLINK_TAB = 8;
    public static final int SUBREPORT1_TAB = 9;
    public static final int SUBREPORT2_TAB = 10;
    public static final int CHART_TAB = 11;
    public static final int COMMON_TAB = 12;
                       
    
    private JReportFrame jrf = null;
    private String lastSelectedPaneName = "Common";
    private javax.swing.JPanel lastSelectedPanel = null;
    
    
    /** Creates new form ElementPropertiesDialog */
    public ElementPropertiesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        jTabbedPane.removeAll();
        this.setSize(324, 360);
        
        // Position types...
        jComboBoxPositionType.addItem("FixRelativeToTop");
        jComboBoxPositionType.addItem("Float");
        jComboBoxPositionType.addItem("FixRelativeToBottom");
        
        // Pens...
        jComboBoxPen.addItem("None");
        jComboBoxPen.addItem("Thin");
        jComboBoxPen.addItem("1Point");
        jComboBoxPen.addItem("2Point");
        jComboBoxPen.addItem("4Point");
        jComboBoxPen.addItem("Dotted");
        
        // StretchTypes...
        jComboBoxStretchType.addItem("NoStretch");
        jComboBoxStretchType.addItem("RelativeToTallestObject");
        jComboBoxStretchType.addItem("RelativeToBandHeight");
        
        // Fill...
        jComboBoxFill.addItem("Solid");
        
        // Line...
        jComboBoxLineDirection.addItem("TopDown");
        jComboBoxLineDirection.addItem("BottomUp");
        
        // Scale Image...
        jComboBoxScale.addItem("Clip");
        jComboBoxScale.addItem("FillFrame");
        jComboBoxScale.addItem("RetainShape");
        
        // Image Evaluation Time...
        jComboBoxEvaluationTime.addItem("Now");
        jComboBoxEvaluationTime.addItem("Report");
        jComboBoxEvaluationTime.addItem("Page");
        jComboBoxEvaluationTime.addItem("Column");
        jComboBoxEvaluationTime.addItem("Group");
        
        // Image Expression Classes...
        jComboBoxImageExpressionClass.addItem("java.lang.String");
        jComboBoxImageExpressionClass.addItem("java.io.File");
        jComboBoxImageExpressionClass.addItem("java.net.URL");
        jComboBoxImageExpressionClass.addItem("java.io.InputStream");
        jComboBoxImageExpressionClass.addItem("java.awt.Image");
        
        // Image Vertical Alignments...
        jComboBoxVerticalAlignment.addItem("Top");
        jComboBoxVerticalAlignment.addItem("Middle");
        jComboBoxVerticalAlignment.addItem("Bottom");
        
        // Image Horizontal Alignments...
        jComboBoxHorizontalAlignment.addItem("Left");
        jComboBoxHorizontalAlignment.addItem("Center");
        jComboBoxHorizontalAlignment.addItem("Right");
        
        // Image Horizontal Alignments...
        jComboBoxPDFFontName.addItem("Helvetica");
        jComboBoxPDFFontName.addItem("Helvetica-Bold");
        jComboBoxPDFFontName.addItem("Helvetica-BoldOblique");
        jComboBoxPDFFontName.addItem("Helvetica-Oblique");
        jComboBoxPDFFontName.addItem("Courier");
        jComboBoxPDFFontName.addItem("Courier-Bold");
        jComboBoxPDFFontName.addItem("Courier-BoldOblique");
        jComboBoxPDFFontName.addItem("Courier-Oblique");
        jComboBoxPDFFontName.addItem("Symbol");
        jComboBoxPDFFontName.addItem("Times-Roman");
        jComboBoxPDFFontName.addItem("Times-Bold");
        jComboBoxPDFFontName.addItem("Times-BoldItalic");
        jComboBoxPDFFontName.addItem("Times-Italic");
        jComboBoxPDFFontName.addItem("ZapfDingbats");
        jComboBoxPDFFontName.addItem("STSong-Light");
        jComboBoxPDFFontName.addItem("MHei-Medium");
        jComboBoxPDFFontName.addItem("MSung-Light");
        jComboBoxPDFFontName.addItem("HeiseiKakuGo-W5");
        jComboBoxPDFFontName.addItem("HeiseiMin-W3");
        jComboBoxPDFFontName.addItem("HYGoThic-Medium");
        jComboBoxPDFFontName.addItem("HYSMyeongJo-Medium");
        jComboBoxPDFFontName.addItem("External TTF font...");
        
        // Text Vertical Alignments...
        jComboBoxVAlign.addItem("Top");
        jComboBoxVAlign.addItem("Middle");
        jComboBoxVAlign.addItem("Bottom");
        
        // Image Horizontal Alignments...
        jComboBoxHAlign.addItem("Left");
        jComboBoxHAlign.addItem("Center");
        jComboBoxHAlign.addItem("Right");
        jComboBoxHAlign.addItem("Justified");
        
        jNumberComboBoxSize.addEntry("3",3);
        jNumberComboBoxSize.addEntry("5",5);
        jNumberComboBoxSize.addEntry("8",8);
        jNumberComboBoxSize.addEntry("10",10);
        jNumberComboBoxSize.addEntry("12",12);
        jNumberComboBoxSize.addEntry("14",14);
        jNumberComboBoxSize.addEntry("18",18);
        jNumberComboBoxSize.addEntry("24",24);
        jNumberComboBoxSize.addEntry("36",36);
        jNumberComboBoxSize.addEntry("48",48);
        
        jComboBoxLineSpacing.addItem("Single");
        jComboBoxLineSpacing.addItem("1_1_2");
        jComboBoxLineSpacing.addItem("Double");
        
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1250","CP1250 (Central European)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1251","CP1251 (Cyrillic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1252","CP1252 (Western European ANSI aka WinAnsi)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1253","CP1253 (Greek)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1254","CP1254 (Turkish)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1255","CP1255 (Hebrew)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1256","CP1256 (Arabic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1257","CP1257 (Baltic)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("CP1258","CP1258 (Vietnamese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-H","UniGB-UCS2-H (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniGB-UCS2-V","UniGB-UCS2-V (Chinese Simplified)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-H","UniCNS-UCS2-H (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniCNS-UCS2-V","UniCNS-UCS2-V (Chinese traditional)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-H","UniJIS-UCS2-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-V","UniJIS-UCS2-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-H","UniJIS-UCS2-HW-H (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniJIS-UCS2-HW-V","UniJIS-UCS2-HW-V (Japanese)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-H","UniKS-UCS2-H (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("UniKS-UCS2-V","UniKS-UCS2-V (Korean)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-H","Identity-H (Unicode with horizontal writing)"));
        jComboBoxPdfEncoding.addItem(new PdfEncoding("Identity-V","Identity-V (Unicode with vertical writing)"));
        
        jComboBoxPattern.addItem(new PdfEncoding("#,##0.00"," #,##0.00 (example 1,234.56)"));
        
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Boolean");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Byte");
        jComboBoxTextFieldExpressionClass.addItem("java.util.Date");
        jComboBoxTextFieldExpressionClass.addItem("java.sql.Timestamp");
        jComboBoxTextFieldExpressionClass.addItem("java.sql.Time");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Double");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Float");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Integer");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Long");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.Short");
        jComboBoxTextFieldExpressionClass.addItem("java.math.BigDecimal");
        jComboBoxTextFieldExpressionClass.addItem("java.lang.String");
        
        // Text field Evaluation Time...
        jComboBoxTextFieldEvaluationTime.addItem("Now");
        jComboBoxTextFieldEvaluationTime.addItem("Report");
        jComboBoxTextFieldEvaluationTime.addItem("Page");
        jComboBoxTextFieldEvaluationTime.addItem("Column");
        jComboBoxTextFieldEvaluationTime.addItem("Group");
        
        jComboBoxSubreportConnectionType.addItem("Don't use connection or datasource");
        jComboBoxSubreportConnectionType.addItem("Use connection expression");
        jComboBoxSubreportConnectionType.addItem("Use datasource expression");
        
        
        jComboBoxSubreportExpressionClass.addItem("java.lang.String");
        jComboBoxSubreportExpressionClass.addItem("java.io.File");
        jComboBoxSubreportExpressionClass.addItem("java.net.URL");
        jComboBoxSubreportExpressionClass.addItem("java.io.InputStream");
        jComboBoxSubreportExpressionClass.addItem("dori.jasper.engine.JasperReport");
        
        jComboBoxLinkType.addItem("None");
        jComboBoxLinkType.addItem("Reference");
        jComboBoxLinkType.addItem("LocalAnchor");
        jComboBoxLinkType.addItem("LocalPage");
        jComboBoxLinkType.addItem("RemoteAnchor");
        jComboBoxLinkType.addItem("RemotePage");
                
        // Load Fonts...
        String[] fontFamilies = java.awt.GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i=0; i<fontFamilies.length; ++i)
        {
            jComboBoxFontName.addItem(fontFamilies[i]); 
        }
        java.awt.Font f;
        
        this.jRTextExpressionAreaPrintWhenExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaPrintWhenExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionTextChanged();
            }
        });   
        
        
        
        this.jTextAreaText.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jTextAreaTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jTextAreaTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jTextAreaTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaTextFieldExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaTextFieldExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextFieldExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextFieldExpressionTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaSubreportExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaSubreportExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportExpressionTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaTextConnectionExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaTextConnectionExpressionTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaSubreportMapExpression.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaSubreportMapExpressionTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportMapExpressionTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaSubreportMapExpressionTextChanged();
            }
        }); 
        
        
        javax.swing.DefaultListSelectionModel dlsm =  (javax.swing.DefaultListSelectionModel)this.jTableSubreportParameters.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent e)  {
                jTableSubreportParametersListSelectionValueChanged(e);
            }
        });
        
        
        this.jRTextExpressionAreaAnchorName.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaAnchorNameTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorNameTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorNameTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaAnchor.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaAnchorTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaAnchorTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaPage.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaPageTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPageTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaPageTextChanged();
            }
        }); 
        
        this.jRTextExpressionAreaReference.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jRTextExpressionAreaReferenceTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaReferenceTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jRTextExpressionAreaReferenceTextChanged();
            }
        }); 
        
        this.jTextFieldChartTitle.getDocument().addDocumentListener( new javax.swing.event.DocumentListener() {
            public void changedUpdate(javax.swing.event.DocumentEvent evt)
            {
                jTextFieldChartTitleTextChanged();
            }
            public void insertUpdate(javax.swing.event.DocumentEvent evt) {
                jTextFieldChartTitleTextChanged();
            }
            public void removeUpdate(javax.swing.event.DocumentEvent evt) {
                jTextFieldChartTitleTextChanged();
            }
        }); 
    }
    
    
    
    
    public void jTableSubreportParametersListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableSubreportParameters.getSelectedRowCount() > 0) {
            this.jButtonModParameter.setEnabled(true);
            this.jButtonRemParameter.setEnabled(true);
        }
        else {
            this.jButtonModParameter.setEnabled(false);
            this.jButtonRemParameter.setEnabled(false);
        }
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonGroupCharts = new javax.swing.ButtonGroup();
        jTabbedPane = new javax.swing.JTabbedPane();
        jPanelCommon = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBoxGroups = new javax.swing.JComboBox();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jButtonBackground = new javax.swing.JButton();
        jButtonForeground = new javax.swing.JButton();
        jCheckBoxTransparent = new javax.swing.JCheckBox();
        jCheckBoxRemoveLineWhenBlank = new javax.swing.JCheckBox();
        jCheckBoxPrintInFirstWholeBand = new javax.swing.JCheckBox();
        jCheckBoxPrintWhenDetailOverflows = new javax.swing.JCheckBox();
        jCheckBoxPrintRepeatedValues = new javax.swing.JCheckBox();
        jLabel8 = new javax.swing.JLabel();
        jComboBoxBand = new javax.swing.JComboBox();
        jLabel9 = new javax.swing.JLabel();
        jComboBoxPositionType = new javax.swing.JComboBox();
        jLabel10 = new javax.swing.JLabel();
        jNumberFieldTop = new it.businesslogic.ireport.gui.JNumberField();
        jNumberFieldLeft = new it.businesslogic.ireport.gui.JNumberField();
        jNumberFieldWidth = new it.businesslogic.ireport.gui.JNumberField();
        jNumberFieldHeight = new it.businesslogic.ireport.gui.JNumberField();
        jRTextExpressionAreaPrintWhenExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jPanelGraphicselement = new javax.swing.JPanel();
        jComboBoxFill = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jComboBoxPen = new javax.swing.JComboBox();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        jComboBoxStretchType = new javax.swing.JComboBox();
        jPanelRectangle = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        jNumberFieldRadius = new it.businesslogic.ireport.gui.JNumberField();
        jPanelLine = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        jComboBoxLineDirection = new javax.swing.JComboBox();
        jPanelImage = new javax.swing.JPanel();
        jRTextExpressionAreaImageExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel16 = new javax.swing.JLabel();
        jButtonFindImage = new javax.swing.JButton();
        jLabel17 = new javax.swing.JLabel();
        jComboBoxImageExpressionClass = new javax.swing.JComboBox();
        jLabel18 = new javax.swing.JLabel();
        jComboBoxScale = new javax.swing.JComboBox();
        jCheckBoxImageCache = new javax.swing.JCheckBox();
        jLabel19 = new javax.swing.JLabel();
        jComboBoxVerticalAlignment = new javax.swing.JComboBox();
        jLabel20 = new javax.swing.JLabel();
        jComboBoxHorizontalAlignment = new javax.swing.JComboBox();
        jLabel21 = new javax.swing.JLabel();
        jComboBoxEvaluationTime = new javax.swing.JComboBox();
        jLabel22 = new javax.swing.JLabel();
        jComboBoxImageGroup = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        jPanelText = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextAreaText = new javax.swing.JTextArea();
        jPanelFont = new javax.swing.JPanel();
        jLabel23 = new javax.swing.JLabel();
        jComboBoxPDFFontName = new javax.swing.JComboBox();
        jLabel24 = new javax.swing.JLabel();
        jLabel25 = new javax.swing.JLabel();
        jComboBoxFontName = new javax.swing.JComboBox();
        jNumberComboBoxSize = new it.businesslogic.ireport.gui.JNumberComboBox();
        jLabel27 = new javax.swing.JLabel();
        jLabelTTF = new javax.swing.JLabel();
        jComboBoxTTFFont = new javax.swing.JComboBox();
        jCheckBoxBold = new javax.swing.JCheckBox();
        jCheckBoxItalic = new javax.swing.JCheckBox();
        jCheckBoxUnderline = new javax.swing.JCheckBox();
        jCheckBoxStrokeTrough = new javax.swing.JCheckBox();
        jLabel29 = new javax.swing.JLabel();
        jComboBoxLineSpacing = new javax.swing.JComboBox();
        jLabel30 = new javax.swing.JLabel();
        jComboBoxHAlign = new javax.swing.JComboBox();
        jLabel31 = new javax.swing.JLabel();
        jComboBoxVAlign = new javax.swing.JComboBox();
        jSeparator2 = new javax.swing.JSeparator();
        jCheckBoxPDFEmbedded = new javax.swing.JCheckBox();
        jComboBoxPdfEncoding = new javax.swing.JComboBox();
        jLabel32 = new javax.swing.JLabel();
        jComboBoxReportFont = new javax.swing.JComboBox();
        jPanelTextField = new javax.swing.JPanel();
        jLabel28 = new javax.swing.JLabel();
        jComboBoxTextFieldExpressionClass = new javax.swing.JComboBox();
        jLabel37 = new javax.swing.JLabel();
        jComboBoxTextFieldEvaluationTime = new javax.swing.JComboBox();
        jLabel38 = new javax.swing.JLabel();
        jComboBoxTextFieldGroup = new javax.swing.JComboBox();
        jCheckBoxStretchWithOverflow = new javax.swing.JCheckBox();
        jCheckBoxBlankWhenNull = new javax.swing.JCheckBox();
        jLabel39 = new javax.swing.JLabel();
        jLabel40 = new javax.swing.JLabel();
        jRTextExpressionAreaTextFieldExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jComboBoxPattern = new javax.swing.JComboBox();
        jPanelSubreport1 = new javax.swing.JPanel();
        jLabel41 = new javax.swing.JLabel();
        jLabel42 = new javax.swing.JLabel();
        jRTextExpressionAreaSubreportMapExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jComboBoxSubreportConnectionType = new javax.swing.JComboBox();
        jRTextExpressionAreaTextConnectionExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jCheckBoxSubreportCache = new javax.swing.JCheckBox();
        jPanelSubreport2 = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        jRTextExpressionAreaSubreportExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel33 = new javax.swing.JLabel();
        jComboBoxSubreportExpressionClass = new javax.swing.JComboBox();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableSubreportParameters = new javax.swing.JTable();
        jLabel34 = new javax.swing.JLabel();
        jButtonAddParameter = new javax.swing.JButton();
        jButtonModParameter = new javax.swing.JButton();
        jButtonRemParameter = new javax.swing.JButton();
        jPanelHyperLink = new javax.swing.JPanel();
        jRTextExpressionAreaAnchorName = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel35 = new javax.swing.JLabel();
        jSeparator3 = new javax.swing.JSeparator();
        jComboBoxLinkType = new javax.swing.JComboBox();
        jLabel36 = new javax.swing.JLabel();
        jRTextExpressionAreaReference = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelReference = new javax.swing.JLabel();
        jRTextExpressionAreaAnchor = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelAnchor = new javax.swing.JLabel();
        jRTextExpressionAreaPage = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabelPage = new javax.swing.JLabel();
        jPanelChart = new javax.swing.JPanel();
        jPanel2 = new javax.swing.JPanel();
        jToggleButtonVerticalBar = new javax.swing.JToggleButton();
        jToggleButtonVerticalBar3D = new javax.swing.JToggleButton();
        jToggleButtonPie = new javax.swing.JToggleButton();
        jToggleButtonPie3D = new javax.swing.JToggleButton();
        jLabel43 = new javax.swing.JLabel();
        jTextFieldChartTitle = new javax.swing.JTextField();
        jCheckBoxChartLegend = new javax.swing.JCheckBox();
        jLabel44 = new javax.swing.JLabel();
        jNumberFieldChartWidth = new it.businesslogic.ireport.gui.JNumberField();
        jLabel45 = new javax.swing.JLabel();
        jNumberFieldChartHeight = new it.businesslogic.ireport.gui.JNumberField();
        jButtonChartW11 = new javax.swing.JButton();
        jButtonChartH11 = new javax.swing.JButton();
        jButtonChartW21 = new javax.swing.JButton();
        jButtonChartH21 = new javax.swing.JButton();
        jButtonChartW41 = new javax.swing.JButton();
        jButtonChartH41 = new javax.swing.JButton();

        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jTabbedPane.setFont(new java.awt.Font("Dialog", 0, 11));
        jTabbedPane.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jTabbedPaneStateChanged(evt);
            }
        });

        jPanelCommon.setLayout(null);

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel1.setText("Band ");
        jPanelCommon.add(jLabel1);
        jLabel1.setBounds(0, 10, 60, 15);

        jComboBoxGroups.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxGroups.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxGroupsActionPerformed(evt);
            }
        });

        jPanelCommon.add(jComboBoxGroups);
        jComboBoxGroups.setBounds(165, 160, 140, 20);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel2.setText("Top ");
        jPanelCommon.add(jLabel2);
        jLabel2.setBounds(0, 36, 60, 15);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel3.setText("Left ");
        jPanelCommon.add(jLabel3);
        jLabel3.setBounds(0, 60, 60, 15);

        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel4.setText("Width ");
        jPanelCommon.add(jLabel4);
        jLabel4.setBounds(100, 36, 40, 15);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel5.setText("Height ");
        jPanelCommon.add(jLabel5);
        jLabel5.setBounds(100, 60, 40, 15);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel6.setText("Foreground ");
        jPanelCommon.add(jLabel6);
        jLabel6.setBounds(180, 36, 70, 15);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel7.setText("Background ");
        jPanelCommon.add(jLabel7);
        jLabel7.setBounds(180, 60, 70, 15);

        jButtonBackground.setBackground(new java.awt.Color(255, 255, 255));
        jButtonBackground.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonBackground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBackgroundActionPerformed(evt);
            }
        });

        jPanelCommon.add(jButtonBackground);
        jButtonBackground.setBounds(250, 60, 55, 20);

        jButtonForeground.setBackground(new java.awt.Color(0, 0, 0));
        jButtonForeground.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonForeground.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonForegroundActionPerformed(evt);
            }
        });

        jPanelCommon.add(jButtonForeground);
        jButtonForeground.setBounds(250, 36, 55, 20);

        jCheckBoxTransparent.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxTransparent.setText("Transparent");
        jCheckBoxTransparent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxTransparentActionPerformed(evt);
            }
        });

        jPanelCommon.add(jCheckBoxTransparent);
        jCheckBoxTransparent.setBounds(5, 90, 160, 24);

        jCheckBoxRemoveLineWhenBlank.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxRemoveLineWhenBlank.setText("Remove line when blank");
        jCheckBoxRemoveLineWhenBlank.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxRemoveLineWhenBlankActionPerformed(evt);
            }
        });

        jPanelCommon.add(jCheckBoxRemoveLineWhenBlank);
        jCheckBoxRemoveLineWhenBlank.setBounds(5, 110, 160, 24);

        jCheckBoxPrintInFirstWholeBand.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintInFirstWholeBand.setText("Print in first whole band");
        jCheckBoxPrintInFirstWholeBand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPrintInFirstWholeBandActionPerformed(evt);
            }
        });

        jPanelCommon.add(jCheckBoxPrintInFirstWholeBand);
        jCheckBoxPrintInFirstWholeBand.setBounds(5, 130, 160, 24);

        jCheckBoxPrintWhenDetailOverflows.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintWhenDetailOverflows.setText("Print when detail overflows");
        jCheckBoxPrintWhenDetailOverflows.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPrintWhenDetailOverflowsActionPerformed(evt);
            }
        });

        jPanelCommon.add(jCheckBoxPrintWhenDetailOverflows);
        jCheckBoxPrintWhenDetailOverflows.setBounds(5, 150, 158, 24);

        jCheckBoxPrintRepeatedValues.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPrintRepeatedValues.setText("Print repeated values");
        jCheckBoxPrintRepeatedValues.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPrintRepeatedValuesActionPerformed(evt);
            }
        });

        jPanelCommon.add(jCheckBoxPrintRepeatedValues);
        jCheckBoxPrintRepeatedValues.setBounds(5, 170, 160, 24);

        jLabel8.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel8.setText("Position type");
        jPanelCommon.add(jLabel8);
        jLabel8.setBounds(165, 90, 100, 15);

        jComboBoxBand.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxBand.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxBandActionPerformed(evt);
            }
        });

        jPanelCommon.add(jComboBoxBand);
        jComboBoxBand.setBounds(60, 10, 245, 20);

        jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel9.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel9.setText("Print when group changes");
        jPanelCommon.add(jLabel9);
        jLabel9.setBounds(165, 140, 150, 15);

        jComboBoxPositionType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPositionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPositionTypeActionPerformed(evt);
            }
        });

        jPanelCommon.add(jComboBoxPositionType);
        jComboBoxPositionType.setBounds(165, 110, 140, 20);

        jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel10.setText("Print when expression");
        jPanelCommon.add(jLabel10);
        jLabel10.setBounds(5, 200, 130, 15);

        jNumberFieldTop.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldTop.setText("0");
        try {
            jNumberFieldTop.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldTop.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldTop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldTopActionPerformed(evt);
            }
        });

        jPanelCommon.add(jNumberFieldTop);
        jNumberFieldTop.setBounds(62, 34, 38, 20);

        jNumberFieldLeft.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldLeft.setText("0");
        try {
            jNumberFieldLeft.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldLeft.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldLeft.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldLeftActionPerformed(evt);
            }
        });

        jPanelCommon.add(jNumberFieldLeft);
        jNumberFieldLeft.setBounds(62, 58, 38, 20);

        jNumberFieldWidth.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldWidth.setText("0");
        try {
            jNumberFieldWidth.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldWidth.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldWidth.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldWidthActionPerformed(evt);
            }
        });

        jPanelCommon.add(jNumberFieldWidth);
        jNumberFieldWidth.setBounds(140, 34, 38, 20);

        jNumberFieldHeight.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldHeight.setText("0");
        try {
            jNumberFieldHeight.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldHeight.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldHeight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldHeightActionPerformed(evt);
            }
        });

        jPanelCommon.add(jNumberFieldHeight);
        jNumberFieldHeight.setBounds(140, 58, 38, 20);

        jRTextExpressionAreaPrintWhenExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaPrintWhenExpression.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged(evt);
            }
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
        });

        jPanelCommon.add(jRTextExpressionAreaPrintWhenExpression);
        jRTextExpressionAreaPrintWhenExpression.setBounds(6, 220, 300, 82);

        jTabbedPane.addTab("Common", jPanelCommon);

        jPanelGraphicselement.setLayout(null);

        jComboBoxFill.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxFill.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFillActionPerformed(evt);
            }
        });

        jPanelGraphicselement.add(jComboBoxFill);
        jComboBoxFill.setBounds(6, 120, 300, 22);

        jLabel11.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel11.setText("Pen");
        jPanelGraphicselement.add(jLabel11);
        jLabel11.setBounds(8, 12, 278, 15);

        jComboBoxPen.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPenActionPerformed(evt);
            }
        });

        jPanelGraphicselement.add(jComboBoxPen);
        jComboBoxPen.setBounds(6, 28, 300, 22);

        jLabel12.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel12.setText("Stretch Type");
        jPanelGraphicselement.add(jLabel12);
        jLabel12.setBounds(8, 58, 278, 15);

        jLabel13.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel13.setText("Fill");
        jPanelGraphicselement.add(jLabel13);
        jLabel13.setBounds(8, 104, 278, 15);

        jComboBoxStretchType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxStretchType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxStretchTypeActionPerformed(evt);
            }
        });

        jPanelGraphicselement.add(jComboBoxStretchType);
        jComboBoxStretchType.setBounds(6, 74, 300, 22);

        jTabbedPane.addTab("Graphics Element", jPanelGraphicselement);

        jPanelRectangle.setLayout(null);

        jPanel1.setLayout(null);

        jPanel1.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Rectangle radius", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jLabel14.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel14.setText("Radius");
        jPanel1.add(jLabel14);
        jLabel14.setBounds(18, 28, 44, 15);

        jNumberFieldRadius.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        try {
            jNumberFieldRadius.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldRadius.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldRadiusActionPerformed(evt);
            }
        });

        jPanel1.add(jNumberFieldRadius);
        jNumberFieldRadius.setBounds(64, 26, 40, 20);

        jPanelRectangle.add(jPanel1);
        jPanel1.setBounds(10, 12, 294, 64);

        jTabbedPane.addTab("Rectangle", jPanelRectangle);

        jPanelLine.setLayout(null);

        jLabel15.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel15.setText("Line direction");
        jPanelLine.add(jLabel15);
        jLabel15.setBounds(8, 12, 278, 15);

        jComboBoxLineDirection.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLineDirection.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLineDirectionActionPerformed(evt);
            }
        });

        jPanelLine.add(jComboBoxLineDirection);
        jComboBoxLineDirection.setBounds(6, 28, 300, 22);

        jTabbedPane.addTab("Line", jPanelLine);

        jPanelImage.setLayout(null);

        jRTextExpressionAreaImageExpression.setBorder(new javax.swing.border.EtchedBorder());
        jPanelImage.add(jRTextExpressionAreaImageExpression);
        jRTextExpressionAreaImageExpression.setBounds(6, 26, 300, 46);

        jLabel16.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel16.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel16.setText("Image Expression");
        jPanelImage.add(jLabel16);
        jLabel16.setBounds(8, 10, 130, 15);

        jButtonFindImage.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonFindImage.setText("Find...");
        jButtonFindImage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonFindImageActionPerformed(evt);
            }
        });

        jPanelImage.add(jButtonFindImage);
        jButtonFindImage.setBounds(222, 76, 82, 25);

        jLabel17.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel17.setText("Image Expression Class");
        jPanelImage.add(jLabel17);
        jLabel17.setBounds(10, 87, 150, 16);

        jComboBoxImageExpressionClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxImageExpressionClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxImageExpressionClassActionPerformed(evt);
            }
        });

        jPanelImage.add(jComboBoxImageExpressionClass);
        jComboBoxImageExpressionClass.setBounds(8, 104, 300, 22);

        jLabel18.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel18.setText("Scale Image");
        jPanelImage.add(jLabel18);
        jLabel18.setBounds(10, 130, 150, 16);

        jComboBoxScale.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxScale.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxScaleActionPerformed(evt);
            }
        });

        jPanelImage.add(jComboBoxScale);
        jComboBoxScale.setBounds(8, 146, 142, 22);

        jCheckBoxImageCache.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxImageCache.setText("Using cache");
        jCheckBoxImageCache.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxImageCacheActionPerformed(evt);
            }
        });

        jPanelImage.add(jCheckBoxImageCache);
        jCheckBoxImageCache.setBounds(162, 146, 142, 23);

        jLabel19.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel19.setText("Vertical alignment");
        jPanelImage.add(jLabel19);
        jLabel19.setBounds(12, 172, 122, 16);

        jComboBoxVerticalAlignment.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxVerticalAlignment.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxVerticalAlignmentActionPerformed(evt);
            }
        });

        jPanelImage.add(jComboBoxVerticalAlignment);
        jComboBoxVerticalAlignment.setBounds(10, 188, 142, 22);

        jLabel20.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel20.setText("Horizontal alignment");
        jPanelImage.add(jLabel20);
        jLabel20.setBounds(162, 172, 122, 16);

        jComboBoxHorizontalAlignment.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxHorizontalAlignment.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxHorizontalAlignmentActionPerformed(evt);
            }
        });

        jPanelImage.add(jComboBoxHorizontalAlignment);
        jComboBoxHorizontalAlignment.setBounds(160, 188, 142, 22);

        jLabel21.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel21.setText("Evaluation time");
        jPanelImage.add(jLabel21);
        jLabel21.setBounds(12, 236, 122, 16);

        jComboBoxEvaluationTime.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxEvaluationTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxEvaluationTimeActionPerformed(evt);
            }
        });

        jPanelImage.add(jComboBoxEvaluationTime);
        jComboBoxEvaluationTime.setBounds(10, 252, 142, 22);

        jLabel22.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel22.setText("Evaluation group");
        jPanelImage.add(jLabel22);
        jLabel22.setBounds(162, 236, 122, 16);

        jComboBoxImageGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxImageGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxImageGroupActionPerformed(evt);
            }
        });

        jPanelImage.add(jComboBoxImageGroup);
        jComboBoxImageGroup.setBounds(160, 252, 142, 22);

        jPanelImage.add(jSeparator1);
        jSeparator1.setBounds(10, 232, 290, 4);

        jTabbedPane.addTab("Image", jPanelImage);

        jPanelText.setLayout(new java.awt.BorderLayout(15, 15));

        jTextAreaText.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                jTextAreaTextInputMethodTextChanged(evt);
            }
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
        });

        jScrollPane1.setViewportView(jTextAreaText);

        jPanelText.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jTabbedPane.addTab("Text", jPanelText);

        jPanelFont.setLayout(null);

        jLabel23.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel23.setText("Report font");
        jPanelFont.add(jLabel23);
        jLabel23.setBounds(8, 8, 142, 15);

        jComboBoxPDFFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPDFFontName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPDFFontNameActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxPDFFontName);
        jComboBoxPDFFontName.setBounds(6, 106, 300, 22);

        jLabel24.setFont(new java.awt.Font("Dialog", 1, 11));
        jLabel24.setText("Font name");
        jPanelFont.add(jLabel24);
        jLabel24.setBounds(8, 48, 220, 15);

        jLabel25.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel25.setText("PDF font name");
        jPanelFont.add(jLabel25);
        jLabel25.setBounds(8, 90, 74, 15);

        jComboBoxFontName.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxFontName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFontNameActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxFontName);
        jComboBoxFontName.setBounds(6, 64, 232, 22);

        jNumberComboBoxSize.setFont(new java.awt.Font("Dialog", 0, 12));
        jNumberComboBoxSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberComboBoxSizeActionPerformed(evt);
            }
        });

        jNumberComboBoxSize.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jNumberComboBoxSizeItemStateChanged(evt);
            }
        });

        jPanelFont.add(jNumberComboBoxSize);
        jNumberComboBoxSize.setBounds(242, 64, 62, 22);

        jLabel27.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel27.setText("Size");
        jPanelFont.add(jLabel27);
        jLabel27.setBounds(242, 48, 60, 15);

        jLabelTTF.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelTTF.setText("TrueType font");
        jLabelTTF.setEnabled(false);
        jPanelFont.add(jLabelTTF);
        jLabelTTF.setBounds(8, 134, 142, 15);

        jComboBoxTTFFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTTFFont.setEnabled(false);
        jComboBoxTTFFont.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTTFFontActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxTTFFont);
        jComboBoxTTFFont.setBounds(6, 150, 298, 22);

        jCheckBoxBold.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxBold.setText("Bold");
        jCheckBoxBold.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxBoldActionPerformed(evt);
            }
        });

        jPanelFont.add(jCheckBoxBold);
        jCheckBoxBold.setBounds(8, 172, 100, 23);

        jCheckBoxItalic.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxItalic.setText("Italic");
        jCheckBoxItalic.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxItalicActionPerformed(evt);
            }
        });

        jPanelFont.add(jCheckBoxItalic);
        jCheckBoxItalic.setBounds(8, 192, 100, 23);

        jCheckBoxUnderline.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxUnderline.setText("Underline");
        jCheckBoxUnderline.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxUnderlineActionPerformed(evt);
            }
        });

        jPanelFont.add(jCheckBoxUnderline);
        jCheckBoxUnderline.setBounds(8, 212, 100, 23);

        jCheckBoxStrokeTrough.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStrokeTrough.setText("Strike Trough");
        jCheckBoxStrokeTrough.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxStrokeTroughActionPerformed(evt);
            }
        });

        jPanelFont.add(jCheckBoxStrokeTrough);
        jCheckBoxStrokeTrough.setBounds(8, 232, 100, 23);

        jLabel29.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel29.setText("Line spacing");
        jPanelFont.add(jLabel29);
        jLabel29.setBounds(124, 174, 178, 15);

        jComboBoxLineSpacing.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLineSpacing.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLineSpacingActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxLineSpacing);
        jComboBoxLineSpacing.setBounds(124, 190, 180, 22);

        jLabel30.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel30.setText("Horizontal align");
        jPanelFont.add(jLabel30);
        jLabel30.setBounds(124, 218, 90, 15);

        jComboBoxHAlign.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxHAlign.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxHAlignActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxHAlign);
        jComboBoxHAlign.setBounds(124, 234, 92, 22);

        jLabel31.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel31.setText("Vertical align");
        jPanelFont.add(jLabel31);
        jLabel31.setBounds(220, 218, 80, 15);

        jComboBoxVAlign.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxVAlign.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxVAlignActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxVAlign);
        jComboBoxVAlign.setBounds(220, 234, 84, 22);

        jPanelFont.add(jSeparator2);
        jSeparator2.setBounds(8, 260, 294, 4);

        jCheckBoxPDFEmbedded.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxPDFEmbedded.setText("PDF Embedded");
        jCheckBoxPDFEmbedded.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxPDFEmbeddedActionPerformed(evt);
            }
        });

        jPanelFont.add(jCheckBoxPDFEmbedded);
        jCheckBoxPDFEmbedded.setBounds(8, 262, 100, 23);

        jComboBoxPdfEncoding.setEditable(true);
        jComboBoxPdfEncoding.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxPdfEncoding.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPdfEncodingActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxPdfEncoding);
        jComboBoxPdfEncoding.setBounds(126, 278, 174, 22);

        jLabel32.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel32.setText("PDF Encoding");
        jPanelFont.add(jLabel32);
        jLabel32.setBounds(126, 262, 110, 15);

        jComboBoxReportFont.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxReportFont.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxReportFontActionPerformed(evt);
            }
        });

        jPanelFont.add(jComboBoxReportFont);
        jComboBoxReportFont.setBounds(6, 24, 298, 22);

        jTabbedPane.addTab("Font", jPanelFont);

        jPanelTextField.setLayout(null);

        jLabel28.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel28.setText("Textfield Expression Class");
        jPanelTextField.add(jLabel28);
        jLabel28.setBounds(8, 10, 150, 16);

        jComboBoxTextFieldExpressionClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTextFieldExpressionClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTextFieldExpressionClassActionPerformed(evt);
            }
        });

        jPanelTextField.add(jComboBoxTextFieldExpressionClass);
        jComboBoxTextFieldExpressionClass.setBounds(6, 28, 300, 22);

        jLabel37.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel37.setText("Evaluation time");
        jPanelTextField.add(jLabel37);
        jLabel37.setBounds(8, 56, 122, 16);

        jComboBoxTextFieldEvaluationTime.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTextFieldEvaluationTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTextFieldEvaluationTimeActionPerformed(evt);
            }
        });

        jPanelTextField.add(jComboBoxTextFieldEvaluationTime);
        jComboBoxTextFieldEvaluationTime.setBounds(6, 74, 142, 22);

        jLabel38.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel38.setText("Evaluation group");
        jPanelTextField.add(jLabel38);
        jLabel38.setBounds(158, 56, 122, 16);

        jComboBoxTextFieldGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxTextFieldGroup.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxTextFieldGroupActionPerformed(evt);
            }
        });

        jPanelTextField.add(jComboBoxTextFieldGroup);
        jComboBoxTextFieldGroup.setBounds(156, 74, 150, 22);

        jCheckBoxStretchWithOverflow.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxStretchWithOverflow.setText("Stretch with overflow");
        jCheckBoxStretchWithOverflow.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxStretchWithOverflowActionPerformed(evt);
            }
        });

        jPanelTextField.add(jCheckBoxStretchWithOverflow);
        jCheckBoxStretchWithOverflow.setBounds(6, 102, 148, 24);

        jCheckBoxBlankWhenNull.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxBlankWhenNull.setText("Blank when null");
        jCheckBoxBlankWhenNull.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxBlankWhenNullActionPerformed(evt);
            }
        });

        jPanelTextField.add(jCheckBoxBlankWhenNull);
        jCheckBoxBlankWhenNull.setBounds(156, 102, 148, 24);

        jLabel39.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel39.setText("Pattern");
        jPanelTextField.add(jLabel39);
        jLabel39.setBounds(8, 130, 122, 16);

        jLabel40.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel40.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel40.setText("Textfield expression");
        jPanelTextField.add(jLabel40);
        jLabel40.setBounds(8, 176, 130, 15);

        jRTextExpressionAreaTextFieldExpression.setBorder(new javax.swing.border.EtchedBorder());
        jPanelTextField.add(jRTextExpressionAreaTextFieldExpression);
        jRTextExpressionAreaTextFieldExpression.setBounds(6, 192, 300, 110);

        jComboBoxPattern.setEditable(true);
        jComboBoxPattern.setFont(new java.awt.Font("Dialog", 0, 12));
        jComboBoxPattern.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxPatternActionPerformed(evt);
            }
        });

        jComboBoxPattern.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                jComboBoxPatternInputMethodTextChanged(evt);
            }
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
        });

        jPanelTextField.add(jComboBoxPattern);
        jComboBoxPattern.setBounds(8, 146, 296, 22);

        jTabbedPane.addTab("Text Field", jPanelTextField);

        jPanelSubreport1.setLayout(null);

        jLabel41.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel41.setText("Connection / Datasource Expression");
        jPanelSubreport1.add(jLabel41);
        jLabel41.setBounds(8, 120, 296, 16);

        jLabel42.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel42.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel42.setText("Parameters Map Expression");
        jPanelSubreport1.add(jLabel42);
        jLabel42.setBounds(8, 8, 298, 15);

        jRTextExpressionAreaSubreportMapExpression.setBorder(new javax.swing.border.EtchedBorder());
        jPanelSubreport1.add(jRTextExpressionAreaSubreportMapExpression);
        jRTextExpressionAreaSubreportMapExpression.setBounds(8, 26, 296, 88);

        jComboBoxSubreportConnectionType.setFont(new java.awt.Font("Dialog", 0, 12));
        jComboBoxSubreportConnectionType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxSubreportConnectionTypeActionPerformed(evt);
            }
        });

        jPanelSubreport1.add(jComboBoxSubreportConnectionType);
        jComboBoxSubreportConnectionType.setBounds(8, 138, 296, 22);

        jRTextExpressionAreaTextConnectionExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
        jPanelSubreport1.add(jRTextExpressionAreaTextConnectionExpression);
        jRTextExpressionAreaTextConnectionExpression.setBounds(8, 162, 296, 106);

        jCheckBoxSubreportCache.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxSubreportCache.setSelected(true);
        jCheckBoxSubreportCache.setText("Using cache");
        jCheckBoxSubreportCache.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxSubreportCacheActionPerformed(evt);
            }
        });

        jPanelSubreport1.add(jCheckBoxSubreportCache);
        jCheckBoxSubreportCache.setBounds(8, 274, 294, 23);

        jTabbedPane.addTab("Subreport", jPanelSubreport1);

        jPanelSubreport2.setLayout(null);

        jLabel26.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel26.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel26.setText("Subreport Expression");
        jPanelSubreport2.add(jLabel26);
        jLabel26.setBounds(8, 54, 130, 15);

        jRTextExpressionAreaSubreportExpression.setBorder(new javax.swing.border.EtchedBorder());
        jPanelSubreport2.add(jRTextExpressionAreaSubreportExpression);
        jRTextExpressionAreaSubreportExpression.setBounds(6, 70, 300, 66);

        jLabel33.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel33.setText("Image Expression Class");
        jPanelSubreport2.add(jLabel33);
        jLabel33.setBounds(8, 6, 150, 16);

        jComboBoxSubreportExpressionClass.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxSubreportExpressionClass.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxSubreportExpressionClassActionPerformed(evt);
            }
        });

        jPanelSubreport2.add(jComboBoxSubreportExpressionClass);
        jComboBoxSubreportExpressionClass.setBounds(6, 22, 300, 22);

        jTableSubreportParameters.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Parameter", "Expression"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jScrollPane2.setViewportView(jTableSubreportParameters);

        jPanelSubreport2.add(jScrollPane2);
        jScrollPane2.setBounds(6, 158, 298, 116);

        jLabel34.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel34.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel34.setText("Subreport parameters");
        jPanelSubreport2.add(jLabel34);
        jLabel34.setBounds(8, 140, 296, 15);

        jButtonAddParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonAddParameter.setText("Add");
        jButtonAddParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonAddParameterActionPerformed(evt);
            }
        });

        jPanelSubreport2.add(jButtonAddParameter);
        jButtonAddParameter.setBounds(6, 278, 98, 20);

        jButtonModParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModParameter.setText("Modify");
        jButtonModParameter.setEnabled(false);
        jButtonModParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModParameterActionPerformed(evt);
            }
        });

        jPanelSubreport2.add(jButtonModParameter);
        jButtonModParameter.setBounds(106, 278, 98, 20);

        jButtonRemParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonRemParameter.setText("Remove");
        jButtonRemParameter.setEnabled(false);
        jButtonRemParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonRemParameterActionPerformed(evt);
            }
        });

        jPanelSubreport2.add(jButtonRemParameter);
        jButtonRemParameter.setBounds(206, 278, 98, 20);

        jTabbedPane.addTab("Subreport (Other)", jPanelSubreport2);

        jPanelHyperLink.setLayout(null);

        jRTextExpressionAreaAnchorName.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaAnchorName.setViewScrollbars(false);
        jPanelHyperLink.add(jRTextExpressionAreaAnchorName);
        jRTextExpressionAreaAnchorName.setBounds(6, 26, 300, 46);

        jLabel35.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel35.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel35.setText("Anchor Name Expression");
        jPanelHyperLink.add(jLabel35);
        jLabel35.setBounds(8, 10, 298, 15);

        jPanelHyperLink.add(jSeparator3);
        jSeparator3.setBounds(6, 76, 300, 2);

        jComboBoxLinkType.setFont(new java.awt.Font("Dialog", 0, 11));
        jComboBoxLinkType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxLinkTypeActionPerformed(evt);
            }
        });

        jPanelHyperLink.add(jComboBoxLinkType);
        jComboBoxLinkType.setBounds(104, 84, 202, 22);

        jLabel36.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel36.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel36.setText("Hyperlink type");
        jPanelHyperLink.add(jLabel36);
        jLabel36.setBounds(8, 86, 90, 15);

        jRTextExpressionAreaReference.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaReference.setViewScrollbars(false);
        jRTextExpressionAreaReference.setEnabled(false);
        jPanelHyperLink.add(jRTextExpressionAreaReference);
        jRTextExpressionAreaReference.setBounds(6, 126, 300, 46);

        jLabelReference.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelReference.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelReference.setText("Hyperlink Reference Expression");
        jLabelReference.setEnabled(false);
        jPanelHyperLink.add(jLabelReference);
        jLabelReference.setBounds(6, 110, 296, 15);

        jRTextExpressionAreaAnchor.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaAnchor.setViewScrollbars(false);
        jRTextExpressionAreaAnchor.setEnabled(false);
        jPanelHyperLink.add(jRTextExpressionAreaAnchor);
        jRTextExpressionAreaAnchor.setBounds(6, 190, 300, 46);

        jLabelAnchor.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelAnchor.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelAnchor.setText("Hyperlink Anchor Expression");
        jLabelAnchor.setEnabled(false);
        jPanelHyperLink.add(jLabelAnchor);
        jLabelAnchor.setBounds(6, 174, 296, 15);

        jRTextExpressionAreaPage.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaPage.setViewScrollbars(false);
        jRTextExpressionAreaPage.setEnabled(false);
        jPanelHyperLink.add(jRTextExpressionAreaPage);
        jRTextExpressionAreaPage.setBounds(6, 254, 300, 46);

        jLabelPage.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabelPage.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabelPage.setText("Hyperlink Page Expression");
        jLabelPage.setEnabled(false);
        jPanelHyperLink.add(jLabelPage);
        jLabelPage.setBounds(6, 238, 298, 15);

        jTabbedPane.addTab("Hyper Link", jPanelHyperLink);

        jPanelChart.setLayout(null);

        jPanel2.setLayout(new java.awt.GridLayout(2, 2));

        jPanel2.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Chart type", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
        jToggleButtonVerticalBar.setFont(new java.awt.Font("Dialog", 0, 11));
        jToggleButtonVerticalBar.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/charts/verticalBar.gif")));
        jToggleButtonVerticalBar.setSelected(true);
        buttonGroupCharts.add(jToggleButtonVerticalBar);
        jToggleButtonVerticalBar.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonVerticalBarActionPerformed(evt);
            }
        });

        jPanel2.add(jToggleButtonVerticalBar);

        jToggleButtonVerticalBar3D.setFont(new java.awt.Font("Dialog", 0, 11));
        jToggleButtonVerticalBar3D.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/charts/verticalBar3D.gif")));
        buttonGroupCharts.add(jToggleButtonVerticalBar3D);
        jToggleButtonVerticalBar3D.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonVerticalBar3DActionPerformed(evt);
            }
        });

        jPanel2.add(jToggleButtonVerticalBar3D);

        jToggleButtonPie.setFont(new java.awt.Font("Dialog", 0, 11));
        jToggleButtonPie.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/charts/pie.gif")));
        buttonGroupCharts.add(jToggleButtonPie);
        jToggleButtonPie.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonPieActionPerformed(evt);
            }
        });

        jPanel2.add(jToggleButtonPie);

        jToggleButtonPie3D.setFont(new java.awt.Font("Dialog", 0, 11));
        jToggleButtonPie3D.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/charts/pie3D.gif")));
        buttonGroupCharts.add(jToggleButtonPie3D);
        jToggleButtonPie3D.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jToggleButtonPie3DActionPerformed(evt);
            }
        });

        jPanel2.add(jToggleButtonPie3D);

        jPanelChart.add(jPanel2);
        jPanel2.setBounds(8, 10, 290, 114);

        jLabel43.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel43.setText("Chart Title");
        jPanelChart.add(jLabel43);
        jLabel43.setBounds(12, 124, 122, 15);

        jPanelChart.add(jTextFieldChartTitle);
        jTextFieldChartTitle.setBounds(10, 140, 284, 20);

        jCheckBoxChartLegend.setFont(new java.awt.Font("Dialog", 0, 11));
        jCheckBoxChartLegend.setText("Show legend");
        jCheckBoxChartLegend.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCheckBoxChartLegendItemStateChanged(evt);
            }
        });

        jPanelChart.add(jCheckBoxChartLegend);
        jCheckBoxChartLegend.setBounds(10, 166, 278, 23);

        jLabel44.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel44.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel44.setText("Logical chart width");
        jPanelChart.add(jLabel44);
        jLabel44.setBounds(8, 200, 108, 15);

        jNumberFieldChartWidth.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldChartWidth.setText("0");
        try {
            jNumberFieldChartWidth.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldChartWidth.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldChartWidth.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldChartWidthActionPerformed(evt);
            }
        });

        jPanelChart.add(jNumberFieldChartWidth);
        jNumberFieldChartWidth.setBounds(122, 198, 38, 20);

        jLabel45.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel45.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel45.setText("Logical chart height");
        jPanelChart.add(jLabel45);
        jLabel45.setBounds(14, 224, 104, 15);

        jNumberFieldChartHeight.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
        jNumberFieldChartHeight.setText("0");
        try {
            jNumberFieldChartHeight.setDecimals(0);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        try {
            jNumberFieldChartHeight.setInteger(true);
        } catch (java.beans.PropertyVetoException e1) {
            e1.printStackTrace();
        }
        jNumberFieldChartHeight.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jNumberFieldChartHeightActionPerformed(evt);
            }
        });

        jPanelChart.add(jNumberFieldChartHeight);
        jNumberFieldChartHeight.setBounds(122, 222, 38, 20);

        jButtonChartW11.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonChartW11.setText("1:1");
        jButtonChartW11.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonChartW11.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChartW11ActionPerformed(evt);
            }
        });

        jPanelChart.add(jButtonChartW11);
        jButtonChartW11.setBounds(166, 198, 34, 20);

        jButtonChartH11.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonChartH11.setText("1:1");
        jButtonChartH11.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonChartH11.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChartH11ActionPerformed(evt);
            }
        });

        jPanelChart.add(jButtonChartH11);
        jButtonChartH11.setBounds(166, 222, 34, 20);

        jButtonChartW21.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonChartW21.setText("2:1");
        jButtonChartW21.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonChartW21.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChartW21ActionPerformed(evt);
            }
        });

        jPanelChart.add(jButtonChartW21);
        jButtonChartW21.setBounds(204, 198, 34, 20);

        jButtonChartH21.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonChartH21.setText("2:1");
        jButtonChartH21.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonChartH21.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChartH21ActionPerformed(evt);
            }
        });

        jPanelChart.add(jButtonChartH21);
        jButtonChartH21.setBounds(204, 222, 34, 20);

        jButtonChartW41.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonChartW41.setText("4:1");
        jButtonChartW41.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonChartW41.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChartW41ActionPerformed(evt);
            }
        });

        jPanelChart.add(jButtonChartW41);
        jButtonChartW41.setBounds(242, 198, 34, 20);

        jButtonChartH41.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonChartH41.setText("4:1");
        jButtonChartH41.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButtonChartH41.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonChartH41ActionPerformed(evt);
            }
        });

        jPanelChart.add(jButtonChartH41);
        jButtonChartH41.setBounds(242, 222, 34, 20);

        jTabbedPane.addTab("Chart", jPanelChart);

        getContentPane().add(jTabbedPane, java.awt.BorderLayout.CENTER);

        pack();
    }//GEN-END:initComponents

    private void jComboBoxReportFontActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxReportFontActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxReportFont.getSelectedItem() == null) return;
        
        
        // Set the new value for all selected elements...
        // Looking for the selected report font...
        Enumeration fonts = jrf.getReport().getFonts().elements();
        IReportFont font = null;
        while (fonts.hasMoreElements())
        {
            font = (IReportFont)fonts.nextElement();
            if (font != null && font.getReportFont().equals(""+ jComboBoxReportFont.getSelectedItem() ) )
	    {
	 	break;
	    }
	    else
		font = null;
        }
        
        String reportFontName = "";
        if (font==null)
            reportFontName = "";
        else
            reportFontName = font.getReportFont();
        
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setReportFont(reportFontName); 
            if (font != null)
            {
                element.setFontName( font.getFontName());
                element.setBold( font.isBold());
                element.setItalic( font.isItalic());
                element.setUnderline( font.isUnderline());
                element.setStrikeTrought( font.isStrikeTrought());
                element.setPDFFontName( font.getPDFFontName());
                element.setPdfEmbedded( font.isPdfEmbedded());
                element.setPdfEncoding( font.getPdfEncoding());
                element.setTTFFont( font.getTTFFont());
            } 
        }  
        
        this.updateSelection();
        this.jrf.getReportPanel().repaint();
        
        this.jComboBoxFontName.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxReportFontActionPerformed

    private void jButtonChartH41ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChartH41ActionPerformed
         if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
        try {
        jNumberFieldChartHeight.setValue(element.getHeight()*4);
        } catch (Exception ex){}
        if (element.getHeight()*4!= element.getChartHeight())
        {
            element.setChartHeight( element.getHeight()*4);
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonChartH41ActionPerformed

    private void jButtonChartH21ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChartH21ActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
        try {
        jNumberFieldChartHeight.setValue(element.getHeight()*2);
        } catch (Exception ex){}
        if (element.getHeight()*2!= element.getChartHeight())
        {
            element.setChartHeight( element.getHeight()*2);
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonChartH21ActionPerformed

    private void jButtonChartH11ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChartH11ActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
        try {
        jNumberFieldChartHeight.setValue(element.getHeight());
        } catch (Exception ex){}
        if (element.getHeight()!= element.getChartHeight())
        {
            element.setChartHeight( element.getHeight());
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonChartH11ActionPerformed

    private void jButtonChartW41ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChartW41ActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
        try {
        jNumberFieldChartWidth.setValue(element.getWidth()*4);
        } catch (Exception ex){}
        if (element.getWidth()*4 != element.getChartWidth())
        {
            element.setChartWidth( element.getWidth()*4 );
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonChartW41ActionPerformed

    private void jButtonChartW21ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChartW21ActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
        try {
        jNumberFieldChartWidth.setValue(element.getWidth()*2);
        } catch (Exception ex){}
        if (element.getWidth()*2 != element.getChartWidth())
        {
            element.setChartWidth( element.getWidth()*2 );
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonChartW21ActionPerformed

    private void jButtonChartW11ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonChartW11ActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
        try {
        jNumberFieldChartWidth.setValue(element.getWidth());
        } catch (Exception ex){}
        if (element.getWidth() != element.getChartWidth())
        {
            element.setChartWidth( element.getWidth() );
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonChartW11ActionPerformed

    private void jNumberFieldChartHeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldChartHeightActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setChartHeight( (int)jNumberFieldChartHeight.getValue() );
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldChartHeightActionPerformed

    private void jNumberFieldChartWidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldChartWidthActionPerformed
         if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setChartWidth( (int)jNumberFieldChartWidth.getValue() );
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldChartWidthActionPerformed

    private void jToggleButtonPie3DActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonPie3DActionPerformed
             if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setChartType( IReportChartFactory.PIE_CHART_3D );
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jToggleButtonPie3DActionPerformed

    private void jToggleButtonPieActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonPieActionPerformed
               if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setChartType( IReportChartFactory.PIE_CHART );
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jToggleButtonPieActionPerformed

    private void jToggleButtonVerticalBar3DActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonVerticalBar3DActionPerformed
               if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setChartType( IReportChartFactory.VERTICAL_BAR_CHART_3D );
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jToggleButtonVerticalBar3DActionPerformed

    private void jToggleButtonVerticalBarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonVerticalBarActionPerformed
        
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setChartType( IReportChartFactory.VERTICAL_BAR_CHART );
        jrf.getJPanelReport().repaint();
        
    }//GEN-LAST:event_jToggleButtonVerticalBarActionPerformed

    private void jCheckBoxChartLegendItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxChartLegendItemStateChanged
         if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setLegend( jCheckBoxChartLegend.isSelected());
        jrf.getJPanelReport().repaint();

    }//GEN-LAST:event_jCheckBoxChartLegendItemStateChanged

    private void jComboBoxLinkTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLinkTypeActionPerformed
        if (this.isInit()) return;
         
        if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLinkType.getSelectedItem() == null || (jComboBoxLinkType.getSelectedItem()+"").equals("")) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("None"))
        {
            // Set to blank all link fields...
             while (enum.hasMoreElements())
             {
                
                HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
             }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("Reference"))
        {
            // Set to blank all link fields...
             while (enum.hasMoreElements())
             {
                HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
             }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalAnchor"))
        {
            // Set to blank all link fields...
             while (enum.hasMoreElements())
             {
                HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
             }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalPage"))
        {
            // Set to blank all link fields...
             while (enum.hasMoreElements())
             {
                HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
             }
        }
        
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemoteAnchor"))
        {
            // Set to blank all link fields...
             while (enum.hasMoreElements())
             {
                HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
             }
        }
        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemotePage"))
        {
            // Set to blank all link fields...
             while (enum.hasMoreElements())
             {
                HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
                element.setHyperlinkType( ""+jComboBoxLinkType.getSelectedItem());
                element.setHyperlinkReferenceExpression("");
                element.setHyperlinkAnchorExpression("");
                element.setHyperlinkPageExpression("");
                this.jRTextExpressionAreaAnchor.setText("");
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setText("");
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setText("");
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
             }
        }
        
        jComboBoxLinkType.removeItem("");
    }//GEN-LAST:event_jComboBoxLinkTypeActionPerformed

    private void jButtonRemParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRemParameterActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)enum.nextElement();
                    
        jTableSubreportParameters.getSelectedRows();
        int[]  rows= jTableSubreportParameters.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i)
        {
            element.getSubreportParameters().removeElement( jTableSubreportParameters.getValueAt( rows[i], 0) );
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        
        javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
        dtm.setRowCount(0);
                        
        java.util.Enumeration enum_parameters = element.getSubreportParameters().elements();
         while (enum_parameters.hasMoreElements())
         {
              it.businesslogic.ireport.JRSubreportParameter parameter = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
              Vector row = new Vector();
              row.addElement(parameter);
              row.addElement(parameter.getExpression());
              dtm.addRow(row);
         }
    }//GEN-LAST:event_jButtonRemParameterActionPerformed

    private void jButtonModParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModParameterActionPerformed
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)enum.nextElement();
        
        JRSubreportParameter parameter = (JRSubreportParameter)jTableSubreportParameters.getValueAt( jTableSubreportParameters.getSelectedRow(), 0);
        
        JRSubreportParameterDialog jrpd = new JRSubreportParameterDialog(null, true);
        jrpd.setParameter( parameter );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            parameter.setName( jrpd.getParameter().getName() );
            parameter.setExpression( jrpd.getParameter().getExpression());
            javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
             dtm.setRowCount(0);
                        
            java.util.Enumeration enum_parameters = element.getSubreportParameters().elements();
             while (enum_parameters.hasMoreElements())
            {
                it.businesslogic.ireport.JRSubreportParameter parameter2 = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
                 Vector row = new Vector();
                  row.addElement(parameter2);
                row.addElement(parameter2.getExpression());
                dtm.addRow(row);
            }
        }
    }//GEN-LAST:event_jButtonModParameterActionPerformed

    private void jButtonAddParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAddParameterActionPerformed
        
        if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)enum.nextElement();
        
        JRSubreportParameterDialog jrpd = new JRSubreportParameterDialog(null, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            it.businesslogic.ireport.JRSubreportParameter parameter = jrpd.getParameter();
            element.getSubreportParameters().addElement( parameter );
            javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
            dtm.addRow(new Object[]{parameter, parameter.getExpression()});
        }
    }//GEN-LAST:event_jButtonAddParameterActionPerformed

    private void jComboBoxSubreportExpressionClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxSubreportExpressionClassActionPerformed
         if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxSubreportExpressionClass.getSelectedItem() == null || (jComboBoxSubreportExpressionClass.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            SubReportElement element = (SubReportElement)enum.nextElement();
            element.setSubreportExpressionClass(""+ jComboBoxSubreportExpressionClass.getSelectedItem());            
        }  
        
        this.jComboBoxSubreportExpressionClass.removeItem("");
    }//GEN-LAST:event_jComboBoxSubreportExpressionClassActionPerformed

    private void jCheckBoxSubreportCacheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxSubreportCacheActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            SubReportElement element = (SubReportElement)enum.nextElement();
            element.setIsUsingCache(jCheckBoxSubreportCache.isSelected());
        }  
    }//GEN-LAST:event_jCheckBoxSubreportCacheActionPerformed

    private void jComboBoxSubreportConnectionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxSubreportConnectionTypeActionPerformed
         if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        SubReportElement element = (SubReportElement)enum.nextElement();
            
        if (jComboBoxSubreportConnectionType.getSelectedIndex() == 0)
        {
            element.setUseConnection(false);
            element.setConnectionExpression("");
            element.setDataSourceExpression("");
            jRTextExpressionAreaTextConnectionExpression.setText("");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
        }
        else if (jComboBoxSubreportConnectionType.getSelectedIndex() == 1)
        {
            element.setUseConnection(true);
            element.setDataSourceExpression("");
            element.setConnectionExpression("$P{REPORT_CONNECTION}");
            jRTextExpressionAreaTextConnectionExpression.setText("$P{REPORT_CONNECTION}");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
        }
        else if (jComboBoxSubreportConnectionType.getSelectedIndex() == 2)
        {
            element.setUseConnection(false);
            element.setDataSourceExpression("$P{MyDataource}");
            element.setConnectionExpression("");
            jRTextExpressionAreaTextConnectionExpression.setText("$P{MyDataource}");
            jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
            jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
        }
        
    }//GEN-LAST:event_jComboBoxSubreportConnectionTypeActionPerformed

    private void jComboBoxPatternInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jComboBoxPatternInputMethodTextChanged
        //System.out.println("Text changed:"+jComboBoxPattern.getSelectedItem());
    }//GEN-LAST:event_jComboBoxPatternInputMethodTextChanged

    private void jComboBoxPatternActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPatternActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPdfEncoding.getSelectedItem() == null || (jComboBoxPdfEncoding.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        
        Object pattern = jComboBoxPattern.getSelectedItem();
            
        if (pattern instanceof PdfEncoding)
                pattern = ""+ ((PdfEncoding)pattern).getEncoding();
            else
                pattern = ""+ pattern+"";
        while (enum.hasMoreElements())
        {            
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setPattern(""+ pattern+"");
        }  
        setPdfEncodingComboBox(true,(String)pattern, jComboBoxPattern);
    }//GEN-LAST:event_jComboBoxPatternActionPerformed

    private void jCheckBoxBlankWhenNullActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxBlankWhenNullActionPerformed
       if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setBlankWhenNull(jCheckBoxBlankWhenNull.isSelected());
        }  
    }//GEN-LAST:event_jCheckBoxBlankWhenNullActionPerformed

    private void jCheckBoxStretchWithOverflowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxStretchWithOverflowActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setStretchWithOverflow(jCheckBoxStretchWithOverflow.isSelected());
        }  
    }//GEN-LAST:event_jCheckBoxStretchWithOverflowActionPerformed

    private void jComboBoxTextFieldGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTextFieldGroupActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTextFieldGroup.getSelectedItem() == null || (jComboBoxTextFieldGroup.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setGroup(""+ jComboBoxTextFieldGroup.getSelectedItem());            
        }  
        
        this.jComboBoxTextFieldGroup.removeItem("");
    }//GEN-LAST:event_jComboBoxTextFieldGroupActionPerformed

    private void jComboBoxTextFieldEvaluationTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTextFieldEvaluationTimeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTextFieldEvaluationTime.getSelectedItem() == null || (jComboBoxTextFieldEvaluationTime.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setEvaluationTime(""+ jComboBoxTextFieldEvaluationTime.getSelectedItem());            
        }  
        
        this.jComboBoxTextFieldEvaluationTime.removeItem("");
    }//GEN-LAST:event_jComboBoxTextFieldEvaluationTimeActionPerformed

    private void jComboBoxTextFieldExpressionClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTextFieldExpressionClassActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTextFieldExpressionClass.getSelectedItem() == null || (jComboBoxTextFieldExpressionClass.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setClassExpression(""+ jComboBoxTextFieldExpressionClass.getSelectedItem());            
        }  
        
        this.jComboBoxTextFieldExpressionClass.removeItem("");
    }//GEN-LAST:event_jComboBoxTextFieldExpressionClassActionPerformed

    private void jCheckBoxPDFEmbeddedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPDFEmbeddedActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setPdfEmbedded(jCheckBoxPDFEmbedded.isSelected());
        }  
    }//GEN-LAST:event_jCheckBoxPDFEmbeddedActionPerformed

    private void jComboBoxPdfEncodingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPdfEncodingActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPdfEncoding.getSelectedItem() == null || (jComboBoxPdfEncoding.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            Object encoding = jComboBoxPdfEncoding.getSelectedItem();
            if (encoding instanceof PdfEncoding)
                element.setPdfEncoding(""+ ((PdfEncoding)encoding).getEncoding() );
            else
                element.setPdfEncoding(""+ encoding+"");
        }  
    }//GEN-LAST:event_jComboBoxPdfEncodingActionPerformed

    private void jComboBoxVAlignActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxVAlignActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxVAlign.getSelectedItem() == null || (jComboBoxVAlign.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setVerticalAlign(""+ jComboBoxVAlign.getSelectedItem());            
        }  
        
        this.jComboBoxVAlign.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxVAlignActionPerformed

    private void jComboBoxHAlignActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxHAlignActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxHAlign.getSelectedItem() == null || (jComboBoxHAlign.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setAlign(""+ jComboBoxHAlign.getSelectedItem());            
        }  
        
        this.jComboBoxHAlign.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxHAlignActionPerformed

    private void jComboBoxLineSpacingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLineSpacingActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLineSpacing.getSelectedItem() == null || (jComboBoxLineSpacing.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setLineSpacing(""+ jComboBoxLineSpacing.getSelectedItem());            
        }  
        
        this.jComboBoxLineSpacing.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxLineSpacingActionPerformed

    private void jCheckBoxStrokeTroughActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxStrokeTroughActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setStrikeTrought(jCheckBoxStrokeTrough.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxStrokeTroughActionPerformed

    private void jCheckBoxUnderlineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxUnderlineActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setUnderline(jCheckBoxUnderline.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxUnderlineActionPerformed

    private void jCheckBoxItalicActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxItalicActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setItalic(jCheckBoxItalic.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxItalicActionPerformed

    private void jCheckBoxBoldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxBoldActionPerformed
         if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setBold(jCheckBoxBold.isSelected());
            element.setFont(null);
            /* Adjust PDF font...*/
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxBoldActionPerformed

    private void jNumberComboBoxSizeItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jNumberComboBoxSizeItemStateChanged
        jNumberComboBoxSizeActionPerformed(new java.awt.event.ActionEvent(jNumberComboBoxSize,0,""));
    }//GEN-LAST:event_jNumberComboBoxSizeItemStateChanged

    private void jComboBoxTTFFontActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxTTFFontActionPerformed
        
         if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxTTFFont.getSelectedItem() == null || (jComboBoxTTFFont.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            Object font = jComboBoxTTFFont.getSelectedItem();
            if (font instanceof IRFont)
            {
                element.setPDFFontName(((IRFont)font).getFile().getName());            
            }
        }  
        
        this.jComboBoxTTFFont.removeItem("");
    }//GEN-LAST:event_jComboBoxTTFFontActionPerformed

    private void jTextAreaTextInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jTextAreaTextInputMethodTextChanged
        
    }//GEN-LAST:event_jTextAreaTextInputMethodTextChanged

    private void jComboBoxFontNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFontNameActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxFontName.getSelectedItem() == null || (jComboBoxFontName.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setFontName(""+ jComboBoxFontName.getSelectedItem());            
        }  
        
        this.jComboBoxFontName.removeItem("");
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxFontNameActionPerformed

    private void jNumberComboBoxSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberComboBoxSizeActionPerformed
         if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jNumberComboBoxSize.getValue() ==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setFontSize((int)jNumberComboBoxSize.getValue());            
        }  
        
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberComboBoxSizeActionPerformed

    private void jComboBoxPDFFontNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPDFFontNameActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPDFFontName.getSelectedItem() == null || (jComboBoxPDFFontName.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        String fontName = ""+ jComboBoxPDFFontName.getSelectedItem();
        //System.out.println(fontName);
        if (fontName != null && fontName.equals("External TTF font..."))
        {
             this.jComboBoxTTFFont.setEnabled(true);
             this.jLabelTTF.setEnabled(true);
             jComboBoxTTFFontActionPerformed(evt);
        }          
        else
        {
             this.jComboBoxTTFFont.setEnabled(false);
             this.jLabelTTF.setEnabled(false);
             Enumeration enum = jrf.getSelectedElements().elements();
             while (enum.hasMoreElements())
             {
                TextReportElement element = (TextReportElement)enum.nextElement();
                element.setPDFFontName(fontName);            
             }  
        }
               
        this.jComboBoxPDFFontName.removeItem("");
        this.jComboBoxTTFFont.removeItem("");
        //jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxPDFFontNameActionPerformed

    private void jButtonFindImageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonFindImageActionPerformed
        String fileName = "";
        javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
        jfc.setDialogTitle("Load XML jasperreports file....");
        jfc.setFileFilter( new javax.swing.filechooser.FileFilter() {
              public boolean accept(java.io.File file) {
                      String filename = file.getName();
                      return (filename.endsWith(".jpg") || 
                              filename.endsWith(".jpeg") || 
                              filename.endsWith(".gif") ||
                              file.isDirectory()) ;
              }
              public String getDescription() {
                       return "Image *.gif|*.jpg";
              }
        });

        jfc.setMultiSelectionEnabled(false);
        jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
        if  (jfc.showOpenDialog( null) == javax.swing.JOptionPane.OK_OPTION)
        {
            this.jRTextExpressionAreaImageExpression.setText("\""+ Misc.string_replace("\\\\","\\",jfc.getSelectedFile().getPath() +"\""));
        }
    }//GEN-LAST:event_jButtonFindImageActionPerformed

    private void jCheckBoxImageCacheActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxImageCacheActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setIsUsingCache( jCheckBoxImageCache.isSelected() );            
        }  
    }//GEN-LAST:event_jCheckBoxImageCacheActionPerformed

    private void jComboBoxImageGroupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxImageGroupActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxImageGroup.getSelectedItem() == null || (jComboBoxImageGroup.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setEvaluationGroup(""+ jComboBoxImageGroup.getSelectedItem());            
        }  
        
        this.jComboBoxImageGroup.removeItem("");
    }//GEN-LAST:event_jComboBoxImageGroupActionPerformed

    private void jComboBoxEvaluationTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxEvaluationTimeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxEvaluationTime.getSelectedItem() == null || (jComboBoxEvaluationTime.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setEvaluationTime(""+ jComboBoxEvaluationTime.getSelectedItem());            
        }  
        
        this.jComboBoxEvaluationTime.removeItem("");
    }//GEN-LAST:event_jComboBoxEvaluationTimeActionPerformed

    private void jComboBoxImageExpressionClassActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxImageExpressionClassActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxImageExpressionClass.getSelectedItem() == null || (jComboBoxImageExpressionClass.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setImageClass(""+ jComboBoxImageExpressionClass.getSelectedItem());            
        }  
        
        this.jComboBoxImageExpressionClass.removeItem("");    
    }//GEN-LAST:event_jComboBoxImageExpressionClassActionPerformed

    private void jComboBoxHorizontalAlignmentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxHorizontalAlignmentActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxHorizontalAlignment.getSelectedItem() == null || (jComboBoxHorizontalAlignment.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setHorizontalAlignment(""+ jComboBoxHorizontalAlignment.getSelectedItem());            
        }  
        
        this.jComboBoxHorizontalAlignment.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxHorizontalAlignmentActionPerformed

    private void jComboBoxVerticalAlignmentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxVerticalAlignmentActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxVerticalAlignment.getSelectedItem() == null || (jComboBoxVerticalAlignment.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setVerticalAlignment(""+ jComboBoxVerticalAlignment.getSelectedItem());            
        }  
        
        this.jComboBoxVerticalAlignment.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxVerticalAlignmentActionPerformed

    private void jComboBoxScaleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxScaleActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxScale.getSelectedItem() == null || (jComboBoxScale.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setScaleImage(""+ jComboBoxScale.getSelectedItem());            
        }  
        
        this.jComboBoxScale.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxScaleActionPerformed

    private void jComboBoxLineDirectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxLineDirectionActionPerformed
         if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxLineDirection.getSelectedItem() == null || (jComboBoxLineDirection.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            LineReportElement element = (LineReportElement)enum.nextElement();
            element.direction = ""+ jComboBoxLineDirection.getSelectedItem();            
        }  
        
        this.jComboBoxLineDirection.removeItem("");    
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jComboBoxLineDirectionActionPerformed

    private void jNumberFieldRadiusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldRadiusActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            RectangleReportElement element = (RectangleReportElement)enum.nextElement();
            element.radius = (int)jNumberFieldRadius.getValue();            
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldRadiusActionPerformed

    private void jTabbedPaneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jTabbedPaneStateChanged
        if (this.isInit()) return;
        if (jTabbedPane.getSelectedComponent() != null)
        {
            lastSelectedPanel = (javax.swing.JPanel)jTabbedPane.getSelectedComponent();
            lastSelectedPaneName = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());

        }
    }//GEN-LAST:event_jTabbedPaneStateChanged

    private void jComboBoxFillActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFillActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxFill.getSelectedItem() == null || (jComboBoxFill.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            GraphicReportElement element = (GraphicReportElement)enum.nextElement();
            element.setFill(""+ jComboBoxFill.getSelectedItem());            
        }  
        
        this.jComboBoxFill.removeItem("");   
    }//GEN-LAST:event_jComboBoxFillActionPerformed

    private void jComboBoxStretchTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxStretchTypeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxStretchType.getSelectedItem() == null || (jComboBoxStretchType.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            GraphicReportElement element = (GraphicReportElement)enum.nextElement();
            element.setStretchType(""+ jComboBoxStretchType.getSelectedItem());            
        }  
        
        this.jComboBoxStretchType.removeItem("");    
    }//GEN-LAST:event_jComboBoxStretchTypeActionPerformed

    private void jComboBoxPenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPenActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPen.getSelectedItem() == null || (jComboBoxPen.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            GraphicReportElement element = (GraphicReportElement)enum.nextElement();
            element.setGraphicElementPen(""+ jComboBoxPen.getSelectedItem());            
        }  
        
        this.jComboBoxPen.removeItem("");    
        jrf.getJPanelReport().repaint();
        
    }//GEN-LAST:event_jComboBoxPenActionPerformed

    private void jComboBoxGroupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxGroupsActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.printWhenGroupChanges = ""+ jComboBoxGroups.getSelectedItem();            
        }  
    }//GEN-LAST:event_jComboBoxGroupsActionPerformed

    private void jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged
        
    }//GEN-LAST:event_jRTextExpressionAreaPrintWhenExpressionInputMethodTextChanged

    private void jComboBoxPositionTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxPositionTypeActionPerformed
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxPositionType.getSelectedItem() == null || (jComboBoxPositionType.getSelectedItem()+"").equals("")) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.positionType = ""+ jComboBoxPositionType.getSelectedItem();            
        }  
        
        this.jComboBoxPositionType.removeItem("");
    }//GEN-LAST:event_jComboBoxPositionTypeActionPerformed

    private void jCheckBoxPrintRepeatedValuesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPrintRepeatedValuesActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.isPrintRepeatedValues = jCheckBoxPrintRepeatedValues.isSelected();            
        }  
    }//GEN-LAST:event_jCheckBoxPrintRepeatedValuesActionPerformed

    private void jCheckBoxPrintWhenDetailOverflowsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPrintWhenDetailOverflowsActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.isPrintWhenDetailOverflows = jCheckBoxPrintWhenDetailOverflows.isSelected();            
        }  
    }//GEN-LAST:event_jCheckBoxPrintWhenDetailOverflowsActionPerformed

    private void jCheckBoxPrintInFirstWholeBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxPrintInFirstWholeBandActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.isPrintInFirstWholeBand = jCheckBoxPrintInFirstWholeBand.isSelected();            
        }  

    }//GEN-LAST:event_jCheckBoxPrintInFirstWholeBandActionPerformed

    private void jCheckBoxRemoveLineWhenBlankActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxRemoveLineWhenBlankActionPerformed
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.isRemoveLineWhenBlank = jCheckBoxRemoveLineWhenBlank.isSelected();            
        }  

        //jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxRemoveLineWhenBlankActionPerformed

    private void jCheckBoxTransparentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxTransparentActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.setTransparent(( (jCheckBoxTransparent.isSelected()) ? "Transparent" : "Opaque") );            
        }  

        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jCheckBoxTransparentActionPerformed

    private void jComboBoxBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxBandActionPerformed
       if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0 || jComboBoxBand.getSelectedItem() == null || (jComboBoxBand.getSelectedIndex() == 0 && (jComboBoxBand.getSelectedItem()+"").trim().equals("") )) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.setBand((Band) jComboBoxBand.getSelectedItem() ) ;  
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED)); 
            
        }  
        // Update coords...
        jrf.getJPanelReport().repaint();
        
        enum = jrf.getSelectedElements().elements();
                
        boolean isTheFirstElement = true;
        Band last_band = null;
        int y_location = 0;
        while (enum.hasMoreElements())
        {
           ReportElement re = (ReportElement)enum.nextElement();
           // 1. Set element properties...
           // For each panel, search 
           if (last_band == null || last_band != re.getBand())
           {
               y_location = this.jrf.getReport().getBandYLocation(re.getBand());
               last_band = re.getBand();
           }
                                        
           this.setElementNumber(isTheFirstElement, re.getWidth(), jNumberFieldWidth);
           this.setElementNumber(isTheFirstElement, re.getHeight(), jNumberFieldHeight);
           this.setElementNumber(isTheFirstElement, re.getPosition().x - 10 - this.jrf.getReport().getLeftMargin(), jNumberFieldLeft);
           this.setElementNumber(isTheFirstElement, re.getPosition().y - y_location - 10, jNumberFieldTop);
           
           this.setCheckBox(isTheFirstElement, re.getTransparent().equals("Transparent"),jCheckBoxTransparent);
           isTheFirstElement=false;
        }
        
        if (!(""+this.jComboBoxBand.getSelectedItem()).equals("")) 
        {
              this.jComboBoxBand.removeItem("");
        }                
    }//GEN-LAST:event_jComboBoxBandActionPerformed

    private void jNumberFieldHeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldHeightActionPerformed
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.trasform( new Point(0, (int)jNumberFieldHeight.getValue()- element.getHeight() ), TransformationType.TRANSFORMATION_RESIZE_S);            
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED)); 
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldHeightActionPerformed

    private void jNumberFieldLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldLeftActionPerformed
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.trasform( new Point( (int)jNumberFieldLeft.getValue()- (element.getPosition().x-10- jrf.getReport().getLeftMargin()) ,0 ), TransformationType.TRANSFORMATION_MOVE);            
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED)); 
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldLeftActionPerformed

    private void jNumberFieldWidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldWidthActionPerformed
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.trasform( new Point( (int)jNumberFieldWidth.getValue()- element.getWidth(),0 ), TransformationType.TRANSFORMATION_RESIZE_E);            
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED)); 
        }
        
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldWidthActionPerformed

    private void jNumberFieldTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldTopActionPerformed
        
        if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        Band last_band = null;
        int y_location = 0;
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            // 1. Set element properties...
            // For each panel, search 
            if (last_band == null || last_band != element.getBand())
            {
                y_location = this.jrf.getReport().getBandYLocation(element.getBand());
                last_band = element.getBand();
            }
            
            element.trasform( new Point(0, (int)jNumberFieldTop.getValue()- (element.getPosition().y - 10 - this.jrf.getReport().getBandYLocation(last_band)) ) , TransformationType.TRANSFORMATION_MOVE);      
            jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(jrf , element , ReportElementChangedEvent.CHANGED)); 
            
        }  
        jrf.getJPanelReport().repaint();
    }//GEN-LAST:event_jNumberFieldTopActionPerformed

    private void jButtonBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBackgroundActionPerformed
        java.awt.Color color = javax.swing.JColorChooser.showDialog( null, "Select background color...",
                                    this.jButtonBackground.getBackground());
        if (color  != null)
        {
            this.jButtonBackground.setBackground(color);
             if (jrf == null || jrf.getSelectedElements().size()==0) return;
                // Set the new value for all selected elements...
            Enumeration enum = jrf.getSelectedElements().elements();
            while (enum.hasMoreElements())
            {
                ReportElement element = (ReportElement)enum.nextElement();
                element.bgcolor =  color;            
            }  
            jrf.getJPanelReport().repaint();
        }        
    }//GEN-LAST:event_jButtonBackgroundActionPerformed

    private void jButtonForegroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonForegroundActionPerformed
        java.awt.Color color = javax.swing.JColorChooser.showDialog( null, "Select foreground color...",
                                    this.jButtonForeground.getBackground());
        if (color  != null)
        {
            this.jButtonForeground.setBackground(color);
            
             if (jrf == null || jrf.getSelectedElements().size()==0) return;
                // Set the new value for all selected elements...
            Enumeration enum = jrf.getSelectedElements().elements();
            while (enum.hasMoreElements())
            {
                ReportElement element = (ReportElement)enum.nextElement();
                element.fgcolor =  color;            
            }  
            jrf.getJPanelReport().repaint();
        }
    }//GEN-LAST:event_jButtonForegroundActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ElementPropertiesDialog(new javax.swing.JFrame(), true).show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldWidth;
    private javax.swing.JComboBox jComboBoxLineSpacing;
    private javax.swing.JSeparator jSeparator2;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldChartWidth;
    private javax.swing.JPanel jPanelLine;
    private javax.swing.JPanel jPanelImage;
    private javax.swing.JLabel jLabelTTF;
    private javax.swing.JLabel jLabel35;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaTextFieldExpression;
    private javax.swing.JComboBox jComboBoxTextFieldEvaluationTime;
    private javax.swing.JComboBox jComboBoxImageExpressionClass;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JButton jButtonChartW41;
    private javax.swing.JCheckBox jCheckBoxChartLegend;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaSubreportExpression;
    private javax.swing.JLabel jLabel44;
    private javax.swing.JCheckBox jCheckBoxUnderline;
    private javax.swing.JComboBox jComboBoxLineDirection;
    private javax.swing.JLabel jLabel37;
    private javax.swing.JComboBox jComboBoxVAlign;
    private javax.swing.JComboBox jComboBoxLinkType;
    private javax.swing.JComboBox jComboBoxPdfEncoding;
    private javax.swing.JToggleButton jToggleButtonPie3D;
    private javax.swing.JCheckBox jCheckBoxItalic;
    private javax.swing.JLabel jLabel34;
    private javax.swing.JComboBox jComboBoxFontName;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaAnchorName;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldChartHeight;
    private javax.swing.JSeparator jSeparator3;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaTextConnectionExpression;
    private javax.swing.JComboBox jComboBoxHorizontalAlignment;
    private javax.swing.JToggleButton jToggleButtonVerticalBar;
    private javax.swing.JComboBox jComboBoxGroups;
    private javax.swing.JComboBox jComboBoxFill;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JButton jButtonChartH21;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JComboBox jComboBoxSubreportExpressionClass;
    private javax.swing.JPanel jPanelGraphicselement;
    private javax.swing.JTextArea jTextAreaText;
    private javax.swing.JLabel jLabel32;
    private javax.swing.JCheckBox jCheckBoxBlankWhenNull;
    private javax.swing.JComboBox jComboBoxStretchType;
    private javax.swing.JCheckBox jCheckBoxPrintRepeatedValues;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JCheckBox jCheckBoxRemoveLineWhenBlank;
    private javax.swing.JComboBox jComboBoxSubreportConnectionType;
    private javax.swing.JComboBox jComboBoxImageGroup;
    private javax.swing.JCheckBox jCheckBoxPrintWhenDetailOverflows;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JButton jButtonModParameter;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JComboBox jComboBoxHAlign;
    private javax.swing.JPanel jPanelTextField;
    private javax.swing.JComboBox jComboBoxTextFieldGroup;
    private javax.swing.JPanel jPanelText;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JButton jButtonFindImage;
    private javax.swing.JCheckBox jCheckBoxStrokeTrough;
    private javax.swing.JCheckBox jCheckBoxStretchWithOverflow;
    private javax.swing.JLabel jLabel36;
    private javax.swing.JButton jButtonAddParameter;
    private javax.swing.JLabel jLabel28;
    private javax.swing.JComboBox jComboBoxPDFFontName;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JButton jButtonBackground;
    private javax.swing.JComboBox jComboBoxTTFFont;
    private javax.swing.JCheckBox jCheckBoxPDFEmbedded;
    private javax.swing.JTextField jTextFieldChartTitle;
    private javax.swing.JLabel jLabel40;
    private javax.swing.JComboBox jComboBoxEvaluationTime;
    private javax.swing.JComboBox jComboBoxBand;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabelPage;
    private javax.swing.JToggleButton jToggleButtonPie;
    private javax.swing.ButtonGroup buttonGroupCharts;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaReference;
    private it.businesslogic.ireport.gui.JNumberComboBox jNumberComboBoxSize;
    private javax.swing.JPanel jPanelSubreport2;
    private javax.swing.JButton jButtonRemParameter;
    private javax.swing.JCheckBox jCheckBoxBold;
    private javax.swing.JLabel jLabel38;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaPage;
    private javax.swing.JComboBox jComboBoxPositionType;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JButton jButtonForeground;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JCheckBox jCheckBoxPrintInFirstWholeBand;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JButton jButtonChartH11;
    private javax.swing.JPanel jPanelHyperLink;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel jLabel41;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldRadius;
    private javax.swing.JPanel jPanelSubreport1;
    private javax.swing.JLabel jLabel29;
    private javax.swing.JLabel jLabel39;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel42;
    private javax.swing.JComboBox jComboBoxScale;
    private javax.swing.JComboBox jComboBoxReportFont;
    private javax.swing.JButton jButtonChartW11;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaPrintWhenExpression;
    private javax.swing.JPanel jPanelRectangle;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel4;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaImageExpression;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JCheckBox jCheckBoxSubreportCache;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaAnchor;
    private javax.swing.JLabel jLabel33;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JButton jButtonChartW21;
    private javax.swing.JLabel jLabel43;
    private javax.swing.JCheckBox jCheckBoxTransparent;
    private javax.swing.JTabbedPane jTabbedPane;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldLeft;
    private javax.swing.JLabel jLabel30;
    private javax.swing.JTable jTableSubreportParameters;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldHeight;
    private javax.swing.JButton jButtonChartH41;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelChart;
    private javax.swing.JLabel jLabel45;
    private javax.swing.JLabel jLabelReference;
    private javax.swing.JScrollPane jScrollPane2;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaSubreportMapExpression;
    private javax.swing.JComboBox jComboBoxTextFieldExpressionClass;
    private javax.swing.JComboBox jComboBoxVerticalAlignment;
    private javax.swing.JComboBox jComboBoxPen;
    private javax.swing.JComboBox jComboBoxPattern;
    private javax.swing.JToggleButton jToggleButtonVerticalBar3D;
    private javax.swing.JSeparator jSeparator1;
    private it.businesslogic.ireport.gui.JNumberField jNumberFieldTop;
    private javax.swing.JPanel jPanelCommon;
    private javax.swing.JPanel jPanelFont;
    private javax.swing.JLabel jLabelAnchor;
    private javax.swing.JLabel jLabel31;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JCheckBox jCheckBoxImageCache;
    // End of variables declaration//GEN-END:variables

    private boolean init;    
    
    /**
     *  Set the report form to work with...
     */
    public void setJReportFrame(JReportFrame jrf)
    {
        this.jrf = jrf;
        if (jrf == null) 
        {
            setVisible(false);
            this.jTabbedPane.removeAll();
            return;
        }
        
        this.setTitle(jrf.getReport().getName());
        updateBands();
        updateGroups();
        updateReportFonts();
        updateSelection();
    }    
    
    /**
     *  This method responde to a virtual event like "element selection changed"
     */
    public void updateSelection()
    {
        if (!this.isVisible()) return;
        
        
        jTabbedPane.removeAll();
        if (jrf == null || jrf.getSelectedElements().size() == 0)
        {
            return;
        }
        else
        {
            
                updateBands();
                updateGroups();
                updateReportFonts();
                this.setInit(true);
                
                Enumeration enum = jrf.getSelectedElements().elements();
                
                boolean isTheFirstElement = true;
                Band last_band = null;
                int y_location = 0;
                //______ COMMON ATTRIBUTES __________
                boolean sameTransparent = true;
                boolean sameWidth = true;
                boolean sameHeight = true;
                boolean sameTop = true;
                boolean sameLeft = true;
                boolean sameBand = true;
                boolean sameRemoveLineWhenBlank = true;
                boolean samePrintInFirstWholeBand = true;
                boolean samePrintWhenDetailOverflows = true;
                boolean samePrintRepeatedValues = true;
                boolean samePositionType = true;
                boolean sameBackgroud = true;
                boolean sameForecolor = true;
                boolean samePrintWhenGroupChanges = true;
                boolean samePrintWhenExpression = true;
                //______ GRAPHIC ELEMENT ATTRIBUTES __________
                boolean areAllGraphicsElements = true;
                boolean samePen = true;
                boolean sameStretchType = true;
                boolean sameFill = true;
                //______ RECTANGLE ELEMENT ATTRIBUTES __________
                boolean areAllRectangleElements = true;
                boolean sameRadius = true;
                //______ LINE ELEMENT ATTRIBUTES __________
                boolean areAllLineElements = true;
                boolean sameLineDirection = true;
                //______ IMAGE ELEMENT ATTRIBUTES __________
                boolean areAllImageElements = true;
                boolean sameScaleImage = true;
                boolean sameImageExpression = true;
                boolean sameImageGroup = true;
                boolean sameEvaluationTime = true;
                boolean sameVerticalAlignment = true;
                boolean sameHorizontalAlignment = true;
                boolean sameImageCache = true;
                boolean sameImageExpressionClass = true;
                //______ TEXT ELEMENT ATTRIBUTES __________
                boolean areAllTextElements = true;
                boolean sameReportFont = true;
                boolean sameFontName = true;
                boolean samePDFFontName = true;
                boolean sameTTFFont = true;
                boolean sameFontSize = true;
                boolean sameIsBold = true;
                boolean sameIsItalic = true;
                boolean sameIsUnderline = true;
                boolean sameIsStrokeTrough = true;
                boolean sameTextVAlign = true;
                boolean sameTextHAlign = true;
                boolean sameTextLineSpacing = true;
                boolean sameIsPdfEmbedded = true;
                boolean samePdfEncoding = true;
                //______ STATIC ELEMENT ATTRIBUTES __________
                boolean areAllStaticTextElements = true;
                boolean sameText = true;
                //______ TEXTFIELD ELEMENT ATTRIBUTES __________
                boolean areAllTextFieldElements = true;
                boolean sameTextExpressionClass = true;
                boolean sameTextExpression = true;
                boolean sameTextEvaluationTime = true;
                boolean sameTextGroup = true;
                boolean sameTextStretchWithOverflow = true;
                boolean sameTextBlankWhenNull = true;
                boolean sameTextPattern = true;
                //______ HyperLinkable ELEMENT ATTRIBUTES __________
                boolean areAllHyperLinkableElements = true;
                boolean sameHyperLinkAnchorName = true;
                boolean sameHyperLinkType = true;
                boolean sameHyperLinkAnchor = true;
                boolean sameHyperLinkPage = true;
                boolean sameHyperLinkReference = true;
                
                boolean isSubreportElement = false;
                boolean isChartElement = false;
               
                if (!jComboBoxPositionType.getItemAt(0).equals(""))
                    this.jComboBoxPositionType.insertItemAt("",0);
                if (!jComboBoxPen.getItemAt(0).equals(""))
                    this.jComboBoxPen.insertItemAt("",0);
                if (!jComboBoxStretchType.getItemAt(0).equals(""))
                    this.jComboBoxStretchType.insertItemAt("",0);
                if (!jComboBoxFill.getItemAt(0).equals(""))
                    this.jComboBoxFill.insertItemAt("",0);
                if (!jComboBoxLineDirection.getItemAt(0).equals(""))
                    this.jComboBoxLineDirection.insertItemAt("",0);
                if (!jComboBoxScale.getItemAt(0).equals(""))
                    this.jComboBoxScale.insertItemAt("",0);
                if (!jComboBoxImageExpressionClass.getItemAt(0).equals(""))
                    this.jComboBoxImageExpressionClass.insertItemAt("",0);
                if (!jComboBoxVerticalAlignment.getItemAt(0).equals(""))
                    this.jComboBoxVerticalAlignment.insertItemAt("",0);
                if (!jComboBoxHorizontalAlignment.getItemAt(0).equals(""))
                    this.jComboBoxHorizontalAlignment.insertItemAt("",0);
                if (!jComboBoxEvaluationTime.getItemAt(0).equals(""))
                    this.jComboBoxEvaluationTime.insertItemAt("",0);
                if (jComboBoxReportFont.getItemCount() == 0 || !jComboBoxReportFont.getItemAt(0).equals(""))
                    this.jComboBoxReportFont.insertItemAt("",0);
                if (!jComboBoxPDFFontName.getItemAt(0).equals(""))
                    this.jComboBoxPDFFontName.insertItemAt("",0);
                if (jComboBoxTTFFont.getItemCount() == 0 || !jComboBoxTTFFont.getItemAt(0).equals(""))
                    this.jComboBoxTTFFont.insertItemAt("",0);
                if (jComboBoxHAlign.getItemCount() == 0 || !jComboBoxHAlign.getItemAt(0).equals(""))
                    this.jComboBoxHAlign.insertItemAt("",0);
                if (jComboBoxVAlign.getItemCount() == 0 || !jComboBoxVAlign.getItemAt(0).equals(""))
                    this.jComboBoxVAlign.insertItemAt("",0);
                if (jComboBoxLineSpacing.getItemCount() == 0 || !jComboBoxLineSpacing.getItemAt(0).equals(""))
                    this.jComboBoxLineSpacing.insertItemAt("",0);
                if (jComboBoxPdfEncoding.getItemCount() == 0 || !jComboBoxPdfEncoding.getItemAt(0).equals(""))
                    this.jComboBoxPdfEncoding.insertItemAt("",0);                
                if (jComboBoxTextFieldEvaluationTime.getItemCount() == 0 || !jComboBoxTextFieldEvaluationTime.getItemAt(0).equals(""))
                    this.jComboBoxTextFieldEvaluationTime.insertItemAt("",0);
                if (jComboBoxTextFieldExpressionClass.getItemCount() == 0 || !jComboBoxTextFieldExpressionClass.getItemAt(0).equals(""))
                    this.jComboBoxTextFieldExpressionClass.insertItemAt("",0);
                if (jComboBoxTextFieldGroup.getItemCount() == 0 || !jComboBoxTextFieldGroup.getItemAt(0).equals(""))
                    this.jComboBoxTextFieldGroup.insertItemAt("",0);
                if (jComboBoxPattern.getItemCount() == 0 || !jComboBoxPattern.getItemAt(0).equals(""))
                    this.jComboBoxPattern.insertItemAt("",0);
                 if (jComboBoxLinkType.getItemCount() == 0 || !jComboBoxLinkType.getItemAt(0).equals(""))
                    this.jComboBoxLinkType.insertItemAt("",0);
                
                jComboBoxTTFFont.setEnabled(false);
                jLabelTTF.setEnabled(false);
                
                while (enum.hasMoreElements())
                {
                    ReportElement re = (ReportElement)enum.nextElement();
                    // 1. Set element properties...
                    // For each panel, search 
                    if (last_band == null || last_band != re.getBand())
                    {
                        y_location = this.jrf.getReport().getBandYLocation(re.getBand());
                        last_band = re.getBand();
                    }
                                        
                    if (sameWidth)  sameWidth = this.setElementNumber(isTheFirstElement, re.getWidth(), jNumberFieldWidth);
                    if (sameHeight)  sameHeight = this.setElementNumber(isTheFirstElement, re.getHeight(), jNumberFieldHeight);
                    if (sameLeft)  sameLeft = this.setElementNumber(isTheFirstElement, re.getPosition().x - 10 - this.jrf.getReport().getLeftMargin(), jNumberFieldLeft);
                    if (sameTop)  sameTop = this.setElementNumber(isTheFirstElement, re.getPosition().y - y_location - 10, jNumberFieldTop);
                    if (sameTransparent) sameTransparent = this.setCheckBox(isTheFirstElement, re.getTransparent().equals("Transparent"), jCheckBoxTransparent);
                    if (sameBand) sameBand = this.setComboBox(isTheFirstElement, re.getBand(), jComboBoxBand );
                    if (sameRemoveLineWhenBlank) sameRemoveLineWhenBlank = this.setCheckBox(isTheFirstElement, re.isRemoveLineWhenBlank, jCheckBoxRemoveLineWhenBlank);
                    if (samePrintInFirstWholeBand) samePrintInFirstWholeBand = this.setCheckBox(isTheFirstElement, re.isPrintInFirstWholeBand, jCheckBoxPrintInFirstWholeBand);
                    if (samePrintWhenDetailOverflows) samePrintWhenDetailOverflows = this.setCheckBox(isTheFirstElement, re.isPrintWhenDetailOverflows, jCheckBoxPrintWhenDetailOverflows);
                    if (samePrintRepeatedValues) samePrintRepeatedValues = this.setCheckBox(isTheFirstElement, re.isPrintRepeatedValues, jCheckBoxPrintRepeatedValues);           
                    if (samePositionType) samePositionType = this.setComboBoxText(isTheFirstElement, re.positionType, jComboBoxPositionType );
                    if (sameBackgroud) sameBackgroud= setElementColor(isTheFirstElement, re.bgcolor, jButtonBackground);
                    if (sameForecolor) sameForecolor = setElementColor(isTheFirstElement, re.fgcolor, jButtonForeground);
                    if (samePrintWhenExpression) samePrintWhenExpression = setTextArea(isTheFirstElement, re.printWhenExpression, jRTextExpressionAreaPrintWhenExpression);
                    if (samePrintWhenGroupChanges) samePrintWhenGroupChanges = this.setComboBoxText(isTheFirstElement, Misc.nvl( re.printWhenGroupChanges,""), jComboBoxGroups);
                    
                    // Tab Graphics Element
                    if (areAllGraphicsElements && (re instanceof GraphicReportElement))
                    {
                        GraphicReportElement gre = (GraphicReportElement)re;
                        if (samePen) samePen = this.setComboBoxText(isTheFirstElement, gre.getGraphicElementPen() , jComboBoxPen );
                        if (sameStretchType) sameStretchType = this.setComboBoxText(isTheFirstElement, gre.getStretchType() , jComboBoxStretchType );
                        if (sameFill) sameFill = this.setComboBoxText(isTheFirstElement, gre.getFill() , jComboBoxFill );
                    }
                    else
                    {
                        areAllGraphicsElements = false;
                    }
                    
                    // Tab Rectangle Element
                    if (areAllRectangleElements && (re instanceof RectangleReportElement))
                    {
                        RectangleReportElement rre = (RectangleReportElement)re;
                        if (sameRadius)  sameRadius = this.setElementNumber(isTheFirstElement, rre.radius, jNumberFieldRadius);
                        
                    }
                    else
                    {
                        areAllRectangleElements = false;
                    }
                    
                    // Tab Line Element
                    if (areAllLineElements && (re instanceof LineReportElement))
                    {
                        LineReportElement lre = (LineReportElement)re;
                        if (sameLineDirection) samePen = this.setComboBoxText(isTheFirstElement, lre.direction , jComboBoxLineDirection );
                    }
                    else
                    {
                        areAllLineElements = false;
                    }
                    
                    // Tab Image Element
                    if (areAllImageElements && (re instanceof ImageReportElement ) && !(re instanceof ChartReportElement ))
                    {
                        ImageReportElement ire = (ImageReportElement)re;
                        if (sameScaleImage) sameScaleImage = this.setComboBoxText(isTheFirstElement, ire.getScaleImage() , jComboBoxScale );
                        if (sameImageExpression) sameImageExpression = setTextArea(isTheFirstElement, ire.getImageExpression(), jRTextExpressionAreaImageExpression);
                        if (sameImageGroup) sameImageGroup = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getEvaluationGroup(),""), jComboBoxImageGroup);
                        if (sameEvaluationTime) sameEvaluationTime = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getEvaluationTime(),""), jComboBoxEvaluationTime);
                        if (sameVerticalAlignment) sameVerticalAlignment = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getVerticalAlignment(),""), jComboBoxVerticalAlignment);
                        if (sameHorizontalAlignment) sameHorizontalAlignment = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getHorizontalAlignment(),""), jComboBoxHorizontalAlignment);
                        if (sameImageCache) sameImageCache = this.setCheckBox(isTheFirstElement, ire.isIsUsingCache(), jCheckBoxImageCache );
                        if (sameImageExpressionClass) sameImageExpressionClass = this.setComboBoxText(isTheFirstElement, Misc.nvl( ire.getImageClass(),""), jComboBoxImageExpressionClass);
                    }
                    else
                    {
                        areAllImageElements = false;
                    }
                    
                    // Tab Font Element
                    if (areAllTextElements && (re instanceof TextReportElement))
                    {
                        TextReportElement tre = (TextReportElement)re;
                        if (sameReportFont) sameReportFont = this.setComboBoxText(isTheFirstElement, tre.getReportFont() , jComboBoxReportFont );
                        if (sameFontName) sameFontName = setComboBoxText(isTheFirstElement, tre.getFontName() , jComboBoxFontName);
                        if (samePDFFontName) 
                        {
                            if (tre.getPDFFontName().toUpperCase().endsWith(".TTF"))
                                samePDFFontName = this.setComboBoxText(isTheFirstElement, "External TTF font..." , jComboBoxPDFFontName );
                            else
                                samePDFFontName = this.setComboBoxText(isTheFirstElement, tre.getPDFFontName() , jComboBoxPDFFontName );
                        }
                        if (sameFontSize) sameFontSize = this.setElementComboNumber(isTheFirstElement, tre.getFontSize() , jNumberComboBoxSize );
                        if (sameIsBold) sameIsBold = this.setCheckBox(isTheFirstElement, tre.isBold(), jCheckBoxBold );
                        if (sameIsItalic) sameIsItalic = this.setCheckBox(isTheFirstElement, tre.isItalic(), jCheckBoxItalic );
                        if (sameIsUnderline) sameIsUnderline = this.setCheckBox(isTheFirstElement, tre.isUnderline(), jCheckBoxUnderline );
                        if (sameIsStrokeTrough) sameIsStrokeTrough = this.setCheckBox(isTheFirstElement, tre.isStrikeTrought(),  jCheckBoxStrokeTrough );
                        if (sameTextVAlign) sameTextVAlign = this.setComboBoxText(isTheFirstElement, tre.getVerticalAlign(), jComboBoxVAlign );
                        if (sameTextHAlign) sameTextHAlign = this.setComboBoxText(isTheFirstElement, tre.getAlign() , jComboBoxHAlign );
                        if (sameTextLineSpacing) sameTextHAlign = this.setComboBoxText(isTheFirstElement, tre.getLineSpacing() , jComboBoxLineSpacing );
                        if (sameIsPdfEmbedded) sameIsPdfEmbedded = this.setCheckBox(isTheFirstElement, tre.isPdfEmbedded(),  jCheckBoxPDFEmbedded );
                        if (samePdfEncoding) samePdfEncoding = this.setPdfEncodingComboBox(isTheFirstElement, tre.getPdfEncoding() , jComboBoxPdfEncoding );

                        if (samePDFFontName && tre.getPDFFontName().toUpperCase().endsWith(".TTF"))
                        {
                            jComboBoxTTFFont.setEnabled(true);
                            jLabelTTF.setEnabled(true);
                            if (sameTTFFont)  this.setFontComboBox(isTheFirstElement, tre.getPDFFontName() , jComboBoxTTFFont );
                        }
                        else
                        {
                            jComboBoxTTFFont.setEnabled(false);
                            jLabelTTF.setEnabled(false);
                        }
                    }
                    else
                    {
                        areAllTextElements = false;
                    }
                    
                    // Tab StaticText Element
                    if (areAllStaticTextElements && (re instanceof StaticTextReportElement))
                    {
                        TextReportElement tre = (TextReportElement)re;
                        if (sameText) sameText = this.setJTextArea (isTheFirstElement, tre.getText() , jTextAreaText );
                    }
                    else
                    {
                        areAllStaticTextElements = false;
                    }
                    
                    // Tab TextField Element
                    if (areAllTextFieldElements && (re instanceof TextFieldReportElement))
                    {
                        TextFieldReportElement tre = (TextFieldReportElement)re;
                        if (sameTextExpression) sameText = this.setTextArea(isTheFirstElement, tre.getText() , jRTextExpressionAreaTextFieldExpression );
                        if (sameTextExpressionClass) sameTextExpressionClass  = this.setComboBoxText(isTheFirstElement, tre.getClassExpression(), jComboBoxTextFieldExpressionClass );
                        if (sameTextEvaluationTime) sameTextEvaluationTime = this.setComboBoxText(isTheFirstElement, tre.getEvaluationTime(), jComboBoxTextFieldEvaluationTime );
                        if (sameTextGroup) sameTextGroup = this.setComboBoxText(isTheFirstElement, tre.getGroup(), jComboBoxTextFieldGroup );
                        if (sameTextStretchWithOverflow)  sameTextStretchWithOverflow = this.setCheckBox(isTheFirstElement, tre.isStretchWithOverflow(),  jCheckBoxStretchWithOverflow);
                        if (sameTextBlankWhenNull) sameTextBlankWhenNull = this.setCheckBox(isTheFirstElement, tre.isBlankWhenNull(),  jCheckBoxBlankWhenNull);  
                        if (sameTextPattern) sameTextPattern = this.setPdfEncodingComboBox(isTheFirstElement, tre.getPattern(),  jComboBoxPattern);   
                    }
                    else
                    {
                        areAllTextFieldElements = false;
                    }
                    
                    if (areAllHyperLinkableElements && (re instanceof HyperLinkableReportElement))
                    {
                        HyperLinkableReportElement hlre = (HyperLinkableReportElement)re;
                        if (sameHyperLinkAnchorName) sameHyperLinkAnchorName = setTextArea(isTheFirstElement, hlre.getAnchorNameExpression(), jRTextExpressionAreaAnchorName);
                        if (sameHyperLinkType) sameHyperLinkType = this.setComboBoxText(isTheFirstElement, hlre.getHyperlinkType(), jComboBoxLinkType);
                        if (sameHyperLinkType)
                        {
                            if (sameHyperLinkAnchor) sameHyperLinkAnchor = setTextArea(isTheFirstElement, hlre.getHyperlinkAnchorExpression(), jRTextExpressionAreaAnchor);
                            if (sameHyperLinkPage) sameHyperLinkPage = setTextArea(isTheFirstElement, hlre.getHyperlinkPageExpression(), jRTextExpressionAreaPage);
                            if (sameHyperLinkReference) sameHyperLinkReference = setTextArea(isTheFirstElement, hlre.getHyperlinkReferenceExpression(), jRTextExpressionAreaReference);
                        }
                        else
                        {
                            jRTextExpressionAreaAnchor.setText("");
                            jRTextExpressionAreaAnchor.setText("");
                            jRTextExpressionAreaPage.setText("");
                            jRTextExpressionAreaReference.setText("");
                        }                       
                    }
                    else
                    {
                        areAllHyperLinkableElements = false;
                    }
                    
                    if (isTheFirstElement && !enum.hasMoreElements() && re instanceof SubReportElement)
                    {
                        isSubreportElement = true;
                        SubReportElement sre = (SubReportElement)re;
                        this.setTextArea(isTheFirstElement, sre.getParametersMapExpression(), jRTextExpressionAreaSubreportMapExpression );
                        this.setComboBoxText(isTheFirstElement, sre.getSubreportExpressionClass(), jComboBoxSubreportExpressionClass);
                        this.setTextArea(isTheFirstElement, sre.getSubreportExpression(), jRTextExpressionAreaSubreportExpression);
                        if (!sre.isUseConnection() &&  Misc.nvl( sre.getDataSourceExpression(),"").trim().equals(""))
                        {
                            this.jComboBoxSubreportConnectionType.setSelectedIndex(0);
                            this.jRTextExpressionAreaTextConnectionExpression.setEnabled(false);
                            this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.LIGHT_GRAY);
                            this.jRTextExpressionAreaTextConnectionExpression.setText("");
                        }
                        else if (sre.isUseConnection())
                        {
                            this.jComboBoxSubreportConnectionType.setSelectedIndex(1);
                            this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                            this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                            this.jRTextExpressionAreaTextConnectionExpression.setText( sre.getConnectionExpression());
                        }
                        else
                        {
                            this.jComboBoxSubreportConnectionType.setSelectedIndex(2);
                            this.jRTextExpressionAreaTextConnectionExpression.setEnabled(true);
                            this.jRTextExpressionAreaTextConnectionExpression.setBackground(Color.WHITE);
                            this.jRTextExpressionAreaTextConnectionExpression.setText( sre.getDataSourceExpression());
                        }
                        
                        jCheckBoxSubreportCache.setSelected( sre.isIsUsingCache());
                        
                        //Add parameters...
                        javax.swing.table.DefaultTableModel dtm = (javax.swing.table.DefaultTableModel)jTableSubreportParameters.getModel();
                        dtm.setRowCount(0);
                        
                        java.util.Enumeration enum_parameters = sre.getSubreportParameters().elements();
                        while (enum_parameters.hasMoreElements())
                        {
                            it.businesslogic.ireport.JRSubreportParameter parameter = (it.businesslogic.ireport.JRSubreportParameter)enum_parameters.nextElement();
                            Vector row = new Vector();
                            row.addElement(parameter);
                            row.addElement(parameter.getExpression());
                            dtm.addRow(row);
                        }
                        
                    }
                    else
                        isSubreportElement = false;

                    if (isTheFirstElement && !enum.hasMoreElements() && re instanceof ChartReportElement)
                    {
                        isChartElement = true;
                        ChartReportElement cre = (ChartReportElement)re;
                        this.setTextField(isTheFirstElement, cre.getTitle(), jTextFieldChartTitle);
                        this.setCheckBox(isTheFirstElement, cre.isLegend(), jCheckBoxChartLegend);
                        jToggleButtonVerticalBar.setSelected(false);
                        jToggleButtonVerticalBar3D.setSelected(false);
                        jToggleButtonPie.setSelected(false);
                        jToggleButtonPie3D.setSelected(false);
                        
                        if (cre.getChartType() == IReportChartFactory.VERTICAL_BAR_CHART) jToggleButtonVerticalBar.setSelected(true);
                        else if (cre.getChartType() == IReportChartFactory.VERTICAL_BAR_CHART_3D) jToggleButtonVerticalBar3D.setSelected(true);
                        else if (cre.getChartType() == IReportChartFactory.PIE_CHART) jToggleButtonPie.setSelected(true);
                        else if (cre.getChartType() == IReportChartFactory.PIE_CHART_3D) jToggleButtonPie3D.setSelected(true);

                        setElementNumber(isTheFirstElement, cre.getChartWidth(), jNumberFieldChartWidth );
                        setElementNumber(isTheFirstElement, cre.getChartHeight(), jNumberFieldChartHeight );
                        
                    }
                    else
                        isChartElement = false;
                    
                    isTheFirstElement=false;
                }
                
               
                
                // If not useful, remove blank combo entries...
                if (this.jComboBoxBand.getSelectedIndex() != 0) 
                {
                    this.jComboBoxBand.removeItemAt(0);
                }
                if (this.jComboBoxPositionType.getSelectedIndex() != 0) 
                {
                    this.jComboBoxPositionType.removeItemAt(0);
                }
                
                if (this.jComboBoxLineDirection.getSelectedIndex() != 0)  this.jComboBoxLineDirection.removeItemAt(0);
                if (this.jComboBoxPen.getSelectedIndex() != 0)  this.jComboBoxPen.removeItemAt(0);
                if (this.jComboBoxStretchType.getSelectedIndex() != 0)  this.jComboBoxStretchType.removeItemAt(0);
                if (this.jComboBoxFill.getSelectedIndex() != 0)  this.jComboBoxFill.removeItemAt(0);
                if (this.jComboBoxScale.getSelectedIndex() != 0)  this.jComboBoxScale.removeItemAt(0);
                if (this.jComboBoxVerticalAlignment.getSelectedIndex() != 0)  this.jComboBoxVerticalAlignment.removeItemAt(0);
                if (this.jComboBoxHorizontalAlignment.getSelectedIndex() != 0)  this.jComboBoxHorizontalAlignment.removeItemAt(0);
                if (this.jComboBoxImageExpressionClass.getSelectedIndex() != 0)  this.jComboBoxImageExpressionClass.removeItemAt(0);
                if (this.jComboBoxEvaluationTime.getSelectedIndex() != 0)  this.jComboBoxEvaluationTime.removeItemAt(0);
                if (this.jComboBoxPDFFontName.getSelectedIndex() != 0)  this.jComboBoxPDFFontName.removeItemAt(0);
                if (this.jComboBoxTTFFont.getSelectedIndex() != 0)  this.jComboBoxTTFFont.removeItemAt(0);
                //if (this.jComboBoxReportFont.getSelectedIndex() != 0)  this.jComboBoxReportFont.removeItemAt(0);
                if (this.jComboBoxHAlign.getSelectedIndex() != 0)  this.jComboBoxHAlign.removeItemAt(0);
                if (this.jComboBoxVAlign.getSelectedIndex() != 0)  this.jComboBoxVAlign.removeItemAt(0);
                if (this.jComboBoxLineSpacing.getSelectedIndex() != 0)  this.jComboBoxLineSpacing.removeItemAt(0);
                if (this.jComboBoxTextFieldEvaluationTime.getSelectedIndex() != 0)  this.jComboBoxTextFieldEvaluationTime.removeItemAt(0);
                if (this.jComboBoxTextFieldExpressionClass.getSelectedIndex() != 0)  this.jComboBoxTextFieldExpressionClass.removeItemAt(0);
                //if (this.jComboBoxSubreportExpressionClass.getSelectedIndex() != 0)  this.jComboBoxTextFieldExpressionClass.removeItemAt(0);
                if (this.jComboBoxLinkType.getSelectedIndex() != 0)
                {
                    this.jComboBoxLinkType.removeItemAt(0);
                    if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("None"))
                        {
                            this.jRTextExpressionAreaAnchor.setEnabled(false);
                            this.jLabelAnchor.setEnabled(false);
                            this.jRTextExpressionAreaPage.setEnabled(false);
                            this.jLabelPage.setEnabled(false);
                            this.jRTextExpressionAreaReference.setEnabled(false);
                            this.jLabelReference.setEnabled(false);
                        }
                        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("Reference"))
                        {
                            this.jRTextExpressionAreaAnchor.setEnabled(false);
                            this.jLabelAnchor.setEnabled(false);
                            this.jRTextExpressionAreaPage.setEnabled(false);
                            this.jLabelPage.setEnabled(false);
                            this.jRTextExpressionAreaReference.setEnabled(true);
                            this.jLabelReference.setEnabled(true);
                        }
                        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalAnchor"))
                        {
                            this.jRTextExpressionAreaAnchor.setEnabled(true);
                            this.jLabelAnchor.setEnabled(true);
                            this.jRTextExpressionAreaPage.setEnabled(false);
                            this.jLabelPage.setEnabled(false);
                            this.jRTextExpressionAreaReference.setEnabled(false);
                            this.jLabelReference.setEnabled(false);
                        }
                        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("LocalPage"))
                        {
                            this.jRTextExpressionAreaAnchor.setEnabled(false);
                            this.jLabelAnchor.setEnabled(false);
                            this.jRTextExpressionAreaPage.setEnabled(true);
                            this.jLabelPage.setEnabled(true);
                            this.jRTextExpressionAreaReference.setEnabled(false);
                            this.jLabelReference.setEnabled(false);
                        }
                        
                        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemoteAnchor"))
                        {
                            this.jRTextExpressionAreaAnchor.setEnabled(true);
                            this.jLabelAnchor.setEnabled(true);
                             this.jRTextExpressionAreaPage.setEnabled(false);
                            this.jLabelPage.setEnabled(false);
                            this.jRTextExpressionAreaReference.setEnabled(true);
                            this.jLabelReference.setEnabled(true);
                        }
                        else if (((String)this.jComboBoxLinkType.getSelectedItem()).equals("RemotePage"))
                        {
                            this.jRTextExpressionAreaAnchor.setEnabled(false);
                            this.jLabelAnchor.setEnabled(false);
                            this.jRTextExpressionAreaPage.setEnabled(true);
                            this.jLabelPage.setEnabled(true);
                            this.jRTextExpressionAreaReference.setEnabled(true);
                            this.jLabelReference.setEnabled(true);
                        }
                }
                else
                {
                    this.jRTextExpressionAreaAnchor.setEnabled(false);
                    this.jLabelAnchor.setEnabled(false);
                    this.jRTextExpressionAreaPage.setEnabled(false);
                    this.jLabelPage.setEnabled(false);
                    this.jRTextExpressionAreaReference.setEnabled(false);
                    this.jLabelReference.setEnabled(false);
                }
                jTabbedPane.add("Common", jPanelCommon);   
                if (areAllGraphicsElements) jTabbedPane.add("Graphics Element", jPanelGraphicselement);
                if (areAllRectangleElements) jTabbedPane.add("Rectangle", jPanelRectangle);
                if (areAllLineElements) jTabbedPane.add("Line", jPanelLine );
                if (areAllImageElements) jTabbedPane.add("Image", jPanelImage );
                if (areAllTextElements) jTabbedPane.add("Font", jPanelFont);
                if (areAllStaticTextElements) jTabbedPane.add("Static Text", jPanelText);
                if (areAllTextFieldElements) jTabbedPane.add("Text Field", jPanelTextField);
                if (areAllHyperLinkableElements) jTabbedPane.add("Hyper Link", jPanelHyperLink);
                if (isSubreportElement) jTabbedPane.add("Subreport", jPanelSubreport1);
                if (isSubreportElement) jTabbedPane.add("Subreport (Other)", jPanelSubreport2);
                if (isChartElement) jTabbedPane.add("Chart", jPanelChart);
                if (lastSelectedPanel != null)
                
                try {
                    jTabbedPane.setSelectedComponent( lastSelectedPanel);
                } catch (Exception ex)
                {
                    lastSelectedPanel = jPanelCommon;
                }
                jTabbedPane.updateUI();
                this.setInit(false);
        }
    }
    
    /**
     *  This method populate the groups comboboxes...
     */
    public void updateGroups()
    {
        this.setInit(true);
        // Use the name of the group and not the group object....
        Vector group_names = new Vector();
        Enumeration enum = jrf.getReport().getGroups().elements();
        while (enum.hasMoreElements())
        {
            group_names.addElement(""+enum.nextElement());
        }
        Misc.updateComboBox( jComboBoxGroups, group_names,true);
        Misc.updateComboBox( jComboBoxImageGroup , group_names,true);
        Misc.updateComboBox( jComboBoxTextFieldGroup , group_names,true);
        this.setInit(false);
    }
    
     /**
     *  This method populate the report fonts comboboxes...
     */
    public void updateReportFonts()
    {
        this.setInit(true);
        // Use the name of the group and not the group object....
        Vector font_names = new Vector();
        Enumeration enum = jrf.getReport().getFonts().elements();
        while (enum.hasMoreElements())
        {
            font_names.addElement(""+enum.nextElement());
        }
        Misc.updateStringComboBox(jComboBoxReportFont, font_names,true);
        this.setInit(false);
    }
    
    /**
     *  This method populate the bands combobox...
     */
    public void updateBands()
    {
        this.setInit(true);
        Misc.updateComboBox( jComboBoxBand, jrf.getReport().getBands(), true);
        this.setInit(false);
    }    
    
    public void updateFonts(Vector iRFonts)
    {
        this.setInit(true);
        Misc.updateComboBox( jComboBoxTTFFont, iRFonts, false);
        this.setInit(false);
    }    
    
    protected boolean setElementNumber( boolean firstTime, double value, JNumberField numberField )
    {
      if (( ! firstTime ) && (!(numberField.getValue() == value)))
      {
        numberField.setText("");
        return false;
      }
      else
      {
          try {
            numberField.setValue( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setElementComboNumber( boolean firstTime, double value, JNumberComboBox numberField )
    {
      if (( ! firstTime ) && (!(numberField.getValue() == value)))
      {
        numberField.setSelectedItem("");
        return false;
      }
      else
      {
          try {
            numberField.setValue( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setCheckBox( boolean firstTime, boolean value, javax.swing.JCheckBox checkField )
    {       
      if (( ! firstTime ) && (!(checkField.isSelected() == value)))
      {
        checkField.setSelected(false);
        return false;
      }
      else
      {
          try {
            checkField.setSelected( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setComboBox( boolean firstTime, Object value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!(comboField.getSelectedItem() == value)))
      {
        comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
            comboField.setSelectedItem( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setFontComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!(comboField.getSelectedItem()!=null && comboField.getSelectedItem() instanceof IRFont && ((IRFont)comboField.getSelectedItem()).getFile().equals(value))))
      {
        if (comboField.getItemCount() > 0)
            comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
              for (int i=0; i<comboField.getItemCount(); ++i)
              {
                  if (comboField.getItemAt(i) instanceof IRFont && ((IRFont)comboField.getItemAt(i)).getFile().getName().equals(value) )
                  {
                      comboField.setSelectedIndex(i);
                      return true;
                   }
              }	 
              if (comboField.getItemCount() > 0)
                comboField.setSelectedIndex(0);
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setPdfEncodingComboBox( boolean firstTime, String value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!(comboField.getSelectedItem()!=null && ( (comboField.getSelectedItem() instanceof PdfEncoding && ((PdfEncoding)comboField.getSelectedItem()).getEncoding().equalsIgnoreCase(value)) || (comboField.getSelectedItem()+"").equals(value) ))))
      {
        if (comboField.getItemCount() > 0)
            comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
              for (int i=0; i<comboField.getItemCount(); ++i)
              {
                  if (comboField.getItemAt(i) instanceof PdfEncoding && ((PdfEncoding)comboField.getItemAt(i)).getEncoding().equals(value) )
                  {
                      comboField.setSelectedIndex(i);
                      return true;
                   }
              }	 
              comboField.setSelectedItem(value);   
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    protected boolean setComboBoxText( boolean firstTime, String value, javax.swing.JComboBox comboField )
    {       
      if (( ! firstTime ) && (!( Misc.nvl(comboField.getSelectedItem(),"").equalsIgnoreCase(value))))
      {
        comboField.setSelectedIndex(0);
        return false;
      }
      else
      {
          try {
            comboField.setSelectedItem( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
    public void setVisible(boolean visible)
    {
        if (visible == isVisible()) return;
        super.setVisible(visible);
        if (visible == true) 
        {
            this.updateSelection();
        }
    }
    
    /** Getter for property init.
     * @return Value of property init.
     *
     */
    public boolean isInit() {
        return init;
    }
    
    /** Setter for property init.
     * @param init New value of property init.
     *
     */
    public void setInit(boolean init) {
        this.init = init;
    }
    
    
    protected boolean setElementColor( boolean firstTime, Color value, javax.swing.JButton colorField )
    {       
      if (( ! firstTime ) && (!(colorField.getBackground() == value)))
      {
        colorField.setBackground( Color.GRAY);
        return false;
      }
      else
      {
          try {
            colorField.setBackground( value );		 
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
    
     protected boolean setTextArea( boolean firstTime, String value, JRTextExpressionArea textField )
    {       
      if (( ! firstTime ) && (!(textField.getText().equals(value) )))
      {
        textField.setText("");
        return false;
      }
      else
      {
          try {
            textField.setText( value );		
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
     
      protected boolean setJTextArea( boolean firstTime, String value, javax.swing.JTextArea textField )
    {       
      if (( ! firstTime ) && (!(textField.getText().equals(value) )))
      {
        textField.setText("");
        return false;
      }
      else
      {
          try {
            textField.setText( value );		
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
     
     protected boolean setTextField( boolean firstTime, String value, javax.swing.JTextField textField )
    {       
      if (( ! firstTime ) && (!(textField.getText().equals(value) )))
      {
        textField.setText("");
        return false;
      }
      else
      {
          try {
            textField.setText( value );		
          } catch (Exception ex){
            ex.printStackTrace();
          }
      }
      return true;
    }
     
     public void jRTextExpressionAreaPrintWhenExpressionTextChanged()
     {
         if (this.isInit()) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ReportElement element = (ReportElement)enum.nextElement();
            element.printWhenExpression = jRTextExpressionAreaPrintWhenExpression.getText();
            //System.out.println("associato testo: "+element.printWhenExpression);
        }  
     }
     
     public void jRTextExpressionAreaImageExpressionTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            ImageReportElement element = (ImageReportElement)enum.nextElement();
            element.setImageExpression( jRTextExpressionAreaImageExpression.getText());
        }  
        jrf.getJPanelReport().repaint();
     }
     public void jTextAreaTextChanged()
     {
        if (this.isInit()) return;
        
        // Set band to all....
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        // Set the new value for all selected elements...
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextReportElement element = (TextReportElement)enum.nextElement();
            element.setText(""+ jTextAreaText.getText());            
        }  
        jrf.getJPanelReport().repaint();
     }
     
     public void jRTextExpressionAreaTextFieldExpressionTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
            TextFieldReportElement element = (TextFieldReportElement)enum.nextElement();
            element.setText(""+jRTextExpressionAreaTextFieldExpression.getText());
        }  
        jrf.getJPanelReport().repaint();
     }
     
    public void jRTextExpressionAreaSubreportExpressionTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           SubReportElement element = (SubReportElement)enum.nextElement();
            element.setSubreportExpression(""+jRTextExpressionAreaSubreportExpression.getText());
        }  
        jrf.getJPanelReport().repaint();
     }
    
    public void jRTextExpressionAreaTextConnectionExpressionTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           SubReportElement element = (SubReportElement)enum.nextElement();
           if (element.isUseConnection())
             element.setConnectionExpression(""+jRTextExpressionAreaTextConnectionExpression.getText());
           else
             element.setDataSourceExpression(""+jRTextExpressionAreaTextConnectionExpression.getText());
        }  
        jrf.getJPanelReport().repaint();
     }
    
    
    
    public void jRTextExpressionAreaSubreportMapExpressionTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           SubReportElement element = (SubReportElement)enum.nextElement();
           element.setParametersMapExpression(""+jRTextExpressionAreaSubreportMapExpression.getText());
            jrf.getJPanelReport().repaint();
        }
    }
    
    public void jRTextExpressionAreaAnchorNameTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
           element.setAnchorNameExpression(""+jRTextExpressionAreaAnchorName.getText());
        }
    }
    
    public void jRTextExpressionAreaAnchorTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
           element.setHyperlinkAnchorExpression(""+jRTextExpressionAreaAnchor.getText());
        }
    }
    
    public void jRTextExpressionAreaPageTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
           element.setHyperlinkPageExpression(""+jRTextExpressionAreaPage.getText());
        }
    }
    
     public void jRTextExpressionAreaReferenceTextChanged()
     {
         if (this.isInit()) return;
        Enumeration enum = jrf.getSelectedElements().elements();
        while (enum.hasMoreElements())
        {
           HyperLinkableReportElement element = (HyperLinkableReportElement)enum.nextElement();
           element.setHyperlinkReferenceExpression(""+jRTextExpressionAreaReference.getText());
        }
    }
     
     public void jTextFieldChartTitleTextChanged()
     {
         
          if (this.isInit()) return;
         
         if (jrf == null || jrf.getSelectedElements().size()==0) return;
        
        Enumeration enum = jrf.getSelectedElements().elements();
        ChartReportElement element = (ChartReportElement)enum.nextElement();
    
        element.setTitle(  jTextFieldChartTitle.getText() );
        jrf.getJPanelReport().repaint();
    }
    
    public void gotoTab(int tabCode )
    {
        try {
            switch (tabCode)
            {
                case GRAPHICS_TAB:
                    jTabbedPane.setSelectedComponent( jPanelGraphicselement );
                    break;
                case RECTANGLE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelRectangle);
                    break;
                case LINE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelLine );
                    break;
                case IMAGE_TAB:
                    jTabbedPane.setSelectedComponent( jPanelImage );
                    break;
                case FONT_TAB:
                    jTabbedPane.setSelectedComponent( jPanelFont );
                    break;
                case STATITEXT_TAB:
                    jTabbedPane.setSelectedComponent( jPanelText );
                    break;
                case TEXTFIELD_TAB:
                    jTabbedPane.setSelectedComponent( jPanelTextField );
                    break;
                case HYPERLINK_TAB:
                    jTabbedPane.setSelectedComponent( jPanelHyperLink );
                    break;
                case SUBREPORT1_TAB:
                    jTabbedPane.setSelectedComponent( jPanelSubreport1 );
                    break;
                case SUBREPORT2_TAB:
                    jTabbedPane.setSelectedComponent( jPanelSubreport2 );
                    break;
                case CHART_TAB:
                    jTabbedPane.setSelectedComponent( jPanelChart );
                    break;
                case COMMON_TAB:
                default:
                    jTabbedPane.setSelectedComponent( jPanelCommon );
                    break;
            }
        
        } catch (Exception ex) {}
    }
        
}
