/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.digester.xmlrules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.digester.AbstractObjectCreationFactory;
import org.apache.commons.digester.CallMethodRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.FactoryCreateRule;
import org.apache.commons.digester.ObjectCreateRule;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.RuleSetBase;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.SetNextRule;
import org.apache.commons.digester.SetPropertiesRule;
import org.apache.commons.digester.SetPropertyRule;
import org.apache.commons.digester.SetTopRule;
import org.apache.commons.digester.xmlrules.CircularIncludeException;
import org.apache.commons.digester.xmlrules.DigesterRulesSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DigesterRuleParser
extends RuleSetBase {
    public static final String DIGESTER_PUBLIC_ID = "-//Jakarta Apache //DTD digester-rules XML V1.0//EN";
    private String digesterDtdUrl;
    protected Digester targetDigester;
    protected PatternStack patternStack;
    private Set includedFiles = new HashSet();
    static /* synthetic */ Class class$org$apache$commons$digester$Rule;

    public DigesterRuleParser() {
        this.patternStack = new PatternStack();
    }

    public DigesterRuleParser(Digester targetDigester) {
        this.targetDigester = targetDigester;
        this.patternStack = new PatternStack();
    }

    private DigesterRuleParser(Digester targetDigester, PatternStack stack, Set includedFiles) {
        this.targetDigester = targetDigester;
        this.patternStack = stack;
        this.includedFiles = includedFiles;
    }

    public void setTarget(Digester d) {
        this.targetDigester = d;
    }

    public void setDigesterRulesDTD(String dtdURL) {
        this.digesterDtdUrl = dtdURL;
    }

    protected String getDigesterRulesDTD() {
        return this.digesterDtdUrl;
    }

    public void add(Rule rule) {
        this.targetDigester.addRule(this.patternStack.toString(), rule);
    }

    public void addRuleInstances(Digester digester) {
        String ruleClassName = (class$org$apache$commons$digester$Rule == null ? (class$org$apache$commons$digester$Rule = DigesterRuleParser.class$("org.apache.commons.digester.Rule")) : class$org$apache$commons$digester$Rule).getName();
        digester.register(DIGESTER_PUBLIC_ID, this.getDigesterRulesDTD());
        digester.addRule("*/pattern", new PatternRule(digester, "value"));
        digester.addRule("*/include", new IncludeRule(digester));
        digester.addFactoryCreate("*/call-method-rule", new CallMethodRuleFactory());
        digester.addRule("*/call-method-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/call-method-rule", "add", ruleClassName);
        digester.addFactoryCreate("*/factory-create-rule", new FactoryCreateRuleFactory());
        digester.addRule("*/factory-create-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/factory-create-rule", "add", ruleClassName);
        digester.addFactoryCreate("*/object-create-rule", new ObjectCreateRuleFactory());
        digester.addRule("*/object-create-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/object-create-rule", "add", ruleClassName);
        digester.addFactoryCreate("*/set-properties-rule", new SetPropertiesRuleFactory());
        digester.addRule("*/set-properties-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/set-properties-rule", "add", ruleClassName);
        digester.addRule("*/set-properties-rule/alias", new SetPropertiesAliasRule(digester));
        digester.addFactoryCreate("*/set-property-rule", new SetPropertyRuleFactory());
        digester.addRule("*/set-property-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/set-property-rule", "add", ruleClassName);
        digester.addFactoryCreate("*/set-top-rule", new SetTopRuleFactory());
        digester.addRule("*/set-top-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/set-top-rule", "add", ruleClassName);
        digester.addFactoryCreate("*/set-next-rule", new SetNextRuleFactory());
        digester.addRule("*/set-next-rule", new PatternRule(digester, "pattern"));
        digester.addSetNext("*/set-next-rule", "add", ruleClassName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DIGESTER_PUBLIC_ID = DIGESTER_PUBLIC_ID;
    }

    protected class SetPropertiesAliasRule
    extends Rule {
        public SetPropertiesAliasRule(Digester digester) {
            super(digester);
        }

        public void begin(Attributes attributes) {
            String attrName = attributes.getValue("attr-name");
            String propName = attributes.getValue("prop-name");
            SetPropertiesRule rule = (SetPropertiesRule)this.digester.peek();
            rule.addAlias(attrName, propName);
        }
    }

    protected class SetNextRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetNextRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String methodName = attributes.getValue("methodname");
            String paramType = attributes.getValue("paramtype");
            return paramType == null || paramType.length() == 0 ? new SetNextRule(DigesterRuleParser.this.targetDigester, methodName) : new SetNextRule(DigesterRuleParser.this.targetDigester, methodName, paramType);
        }
    }

    protected class SetTopRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetTopRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String methodName = attributes.getValue("methodname");
            String paramType = attributes.getValue("paramtype");
            return paramType == null || paramType.length() == 0 ? new SetTopRule(DigesterRuleParser.this.targetDigester, methodName) : new SetTopRule(DigesterRuleParser.this.targetDigester, methodName, paramType);
        }
    }

    protected class SetPropertyRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetPropertyRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String name = attributes.getValue("name");
            String value = attributes.getValue("value");
            return new SetPropertyRule(DigesterRuleParser.this.targetDigester, name, value);
        }
    }

    protected class SetPropertiesRuleFactory
    extends AbstractObjectCreationFactory {
        protected SetPropertiesRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            return new SetPropertiesRule(DigesterRuleParser.this.targetDigester);
        }
    }

    protected class ObjectCreateRuleFactory
    extends AbstractObjectCreationFactory {
        protected ObjectCreateRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String className = attributes.getValue("classname");
            String attrName = attributes.getValue("attrname");
            return attrName == null || attrName.length() == 0 ? new ObjectCreateRule(DigesterRuleParser.this.targetDigester, className) : new ObjectCreateRule(DigesterRuleParser.this.targetDigester, className, attrName);
        }
    }

    protected class FactoryCreateRuleFactory
    extends AbstractObjectCreationFactory {
        protected FactoryCreateRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            String className = attributes.getValue("classname");
            String attrName = attributes.getValue("attrname");
            return attrName == null || attrName.length() == 0 ? new FactoryCreateRule(DigesterRuleParser.this.targetDigester, className) : new FactoryCreateRule(DigesterRuleParser.this.targetDigester, className, attrName);
        }
    }

    protected class CallParamRuleFactory
    extends AbstractObjectCreationFactory {
        protected CallParamRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            int paramNumber = Integer.parseInt(attributes.getValue("paramnumber"));
            String methodName = attributes.getValue("attrname");
            CallMethodRule callMethodRule = new CallMethodRule(DigesterRuleParser.this.targetDigester, methodName, paramNumber);
            return callMethodRule;
        }
    }

    protected class CallMethodRuleFactory
    extends AbstractObjectCreationFactory {
        protected CallMethodRuleFactory() {
        }

        public Object createObject(Attributes attributes) {
            CallMethodRule callMethodRule = null;
            String methodName = attributes.getValue("methodname");
            if (attributes.getValue("paramcount") == null) {
                callMethodRule = new CallMethodRule(methodName);
            } else {
                int paramCount = Integer.parseInt(attributes.getValue("paramcount"));
                String paramTypesAttr = attributes.getValue("paramtypes");
                if (paramTypesAttr == null || paramTypesAttr.length() == 0) {
                    callMethodRule = new CallMethodRule(DigesterRuleParser.this.targetDigester, methodName, paramCount);
                } else {
                    ArrayList<String> paramTypes = new ArrayList<String>();
                    StringTokenizer tokens = new StringTokenizer(paramTypesAttr, " \t\n\r,");
                    while (tokens.hasMoreTokens()) {
                        paramTypes.add(tokens.nextToken());
                    }
                    callMethodRule = new CallMethodRule(DigesterRuleParser.this.targetDigester, methodName, paramCount, paramTypes.toArray(new String[0]));
                }
            }
            return callMethodRule;
        }
    }

    private class RulesPrefixAdapter
    implements Rules {
        private Rules delegate;
        private String prefix;

        public RulesPrefixAdapter(String patternPrefix, Rules rules) {
            this.prefix = patternPrefix;
            this.delegate = rules;
        }

        public void add(String pattern, Rule rule) {
            this.delegate.add(this.prefix + pattern, rule);
        }

        public void clear() {
            this.delegate.clear();
        }

        public Digester getDigester() {
            return this.delegate.getDigester();
        }

        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        public List match(String pattern) {
            return this.delegate.match(pattern);
        }

        public List match(String namespaceURI, String pattern) {
            return this.delegate.match(namespaceURI, pattern);
        }

        public List rules() {
            return this.delegate.rules();
        }

        public void setDigester(Digester digester) {
            this.delegate.setDigester(digester);
        }

        public void setNamespaceURI(String namespaceURI) {
            this.delegate.setNamespaceURI(namespaceURI);
        }
    }

    private class IncludeRule
    extends Rule {
        public IncludeRule(Digester digester) {
            super(digester);
        }

        public void begin(Attributes attributes) throws Exception {
            String className;
            String fileName = attributes.getValue("path");
            if (fileName != null && fileName.length() > 0) {
                this.includeXMLRules(fileName);
            }
            if ((className = attributes.getValue("class")) != null && className.length() > 0) {
                this.includeProgrammaticRules(className);
            }
        }

        private void includeXMLRules(String fileName) throws IOException, SAXException, CircularIncludeException {
            URL fileURL = DigesterRuleParser.this.getClass().getClassLoader().getResource(fileName);
            if (fileURL == null) {
                throw new FileNotFoundException("File \"" + fileName + "\" not found.");
            }
            fileName = fileURL.toExternalForm();
            if (!DigesterRuleParser.this.includedFiles.add(fileName)) {
                throw new CircularIncludeException(fileName);
            }
            DigesterRuleParser includedSet = new DigesterRuleParser(DigesterRuleParser.this.targetDigester, DigesterRuleParser.this.patternStack, DigesterRuleParser.this.includedFiles);
            includedSet.setDigesterRulesDTD(DigesterRuleParser.this.getDigesterRulesDTD());
            Digester digester = new Digester();
            digester.addRuleSet(includedSet);
            digester.push(DigesterRuleParser.this);
            digester.parse(fileName);
            DigesterRuleParser.this.includedFiles.remove(fileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void includeProgrammaticRules(String className) throws ClassNotFoundException, ClassCastException, InstantiationException, IllegalAccessException {
            Class<?> cls = Class.forName(className);
            DigesterRulesSource rulesSource = (DigesterRulesSource)cls.newInstance();
            Rules digesterRules = DigesterRuleParser.this.targetDigester.getRules();
            RulesPrefixAdapter prefixWrapper = new RulesPrefixAdapter(DigesterRuleParser.this.patternStack.toString(), digesterRules);
            DigesterRuleParser.this.targetDigester.setRules(prefixWrapper);
            try {
                rulesSource.getRules(DigesterRuleParser.this.targetDigester);
                Object var7_6 = null;
                DigesterRuleParser.this.targetDigester.setRules(digesterRules);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                DigesterRuleParser.this.targetDigester.setRules(digesterRules);
                throw throwable;
            }
        }
    }

    private class PatternRule
    extends Rule {
        private String attrName;
        private String pattern = null;

        public PatternRule(Digester digester, String attrName) {
            super(digester);
            this.attrName = attrName;
        }

        public void begin(Attributes attributes) {
            this.pattern = attributes.getValue(this.attrName);
            if (this.pattern != null) {
                DigesterRuleParser.this.patternStack.push(this.pattern);
            }
        }

        public void end() {
            if (this.pattern != null) {
                DigesterRuleParser.this.patternStack.pop();
            }
        }
    }

    protected class PatternStack
    extends ArrayStack {
        protected PatternStack() {
        }

        public String toString() {
            StringBuffer str = new StringBuffer();
            int i = 0;
            while (i < this.size()) {
                String elem = this.get(i).toString();
                if (elem.length() > 0) {
                    if (str.length() > 0) {
                        str.append('/');
                    }
                    str.append(elem);
                }
                ++i;
            }
            return str.toString();
        }
    }
}

