/*
 * Decompiled with CFR 0.152.
 */
package dori.jasper.view;

import dori.jasper.engine.JRException;
import dori.jasper.engine.JasperPrint;
import dori.jasper.view.JRViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JasperViewer
extends JFrame {
    private boolean isExitOnClose = true;
    private JPanel pnlMain;

    public JasperViewer(String sourceFile, boolean isXMLFile) throws JRException {
        this.isExitOnClose = true;
        this.initComponents();
        JRViewer viewer = new JRViewer(sourceFile, isXMLFile);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperViewer(InputStream is, boolean isXMLFile) throws JRException {
        this.isExitOnClose = true;
        this.initComponents();
        JRViewer viewer = new JRViewer(is, isXMLFile);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperViewer(JasperPrint jasperPrint) throws JRException {
        this.isExitOnClose = true;
        this.initComponents();
        JRViewer viewer = new JRViewer(jasperPrint);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperViewer(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        JRViewer viewer = new JRViewer(sourceFile, isXMLFile);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperViewer(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        JRViewer viewer = new JRViewer(is, isXMLFile);
        this.pnlMain.add((Component)viewer, "Center");
    }

    public JasperViewer(JasperPrint jasperPrint, boolean isExitOnClose) throws JRException {
        this.isExitOnClose = isExitOnClose;
        this.initComponents();
        JRViewer viewer = new JRViewer(jasperPrint);
        this.pnlMain.add((Component)viewer, "Center");
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.setTitle("JasperViewer");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JasperViewer.this.exitForm(evt);
            }
        });
        this.pnlMain.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.pnlMain, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(750, 550));
        this.setLocation((screenSize.width - 750) / 2, (screenSize.height - 550) / 2);
    }

    private void exitForm(WindowEvent evt) {
        if (this.isExitOnClose) {
            System.exit(0);
        } else {
            this.setVisible(false);
            this.dispose();
        }
    }

    public static void main(String[] args) {
        String fileName = null;
        boolean isXMLFile = false;
        if (args.length == 0) {
            JasperViewer.usage();
            return;
        }
        int k = 0;
        while (args.length > k) {
            if (args[k].startsWith("-F")) {
                fileName = args[k].substring(2);
            }
            if (args[k].startsWith("-XML")) {
                isXMLFile = true;
            }
            ++k;
        }
        try {
            JasperViewer.viewReport(fileName, isXMLFile);
        }
        catch (JRException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("JasperViewer usage:");
        System.out.println("\tjava JasperViewer -XML -Ffile");
    }

    public static void viewReport(String sourceFile, boolean isXMLFile) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(sourceFile, isXMLFile, true);
        jasperViewer.show();
    }

    public static void viewReport(InputStream is, boolean isXMLFile) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(is, isXMLFile, true);
        jasperViewer.show();
    }

    public static void viewReport(JasperPrint jasperPrint) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, true);
        jasperViewer.show();
    }

    public static void viewReport(String sourceFile, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(sourceFile, isXMLFile, isExitOnClose);
        jasperViewer.show();
    }

    public static void viewReport(InputStream is, boolean isXMLFile, boolean isExitOnClose) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(is, isXMLFile, isExitOnClose);
        jasperViewer.show();
    }

    public static void viewReport(JasperPrint jasperPrint, boolean isExitOnClose) throws JRException {
        JasperViewer jasperViewer = new JasperViewer(jasperPrint, isExitOnClose);
        jasperViewer.show();
    }
}

