/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.DefaultDrawingSupplier;
import org.jfree.chart.renderer.DrawingSupplier;
import org.jfree.chart.renderer.PaintTable;
import org.jfree.chart.renderer.Renderer;
import org.jfree.chart.renderer.ShapeTable;
import org.jfree.chart.renderer.StrokeTable;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtils;

public class AbstractRenderer
implements Renderer,
Serializable {
    public static final Paint DEFAULT_PAINT = Color.blue;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    private transient Plot plot = null;
    private DrawingSupplier supplier = new DefaultDrawingSupplier();
    private transient Paint defaultPaint;
    private boolean paintTableActive = true;
    private PaintTable paintTable = new PaintTable();
    private transient Paint defaultOutlinePaint;
    private boolean outlinePaintTableActive = false;
    private PaintTable outlinePaintTable = null;
    private transient Stroke defaultStroke;
    private boolean strokeTableActive = false;
    private StrokeTable strokeTable = null;
    private transient Stroke defaultOutlineStroke;
    private boolean outlineStrokeTableActive = false;
    private StrokeTable outlineStrokeTable = null;
    private transient Shape defaultShape;
    private boolean shapeTableActive = true;
    private ShapeTable shapeTable;
    private transient ChartRenderingInfo info = null;
    private transient PropertyChangeSupport listeners;

    public AbstractRenderer() {
        this.defaultPaint = DEFAULT_PAINT;
        this.defaultOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.defaultStroke = DEFAULT_STROKE;
        this.defaultOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.shapeTable = new ShapeTable();
        this.defaultShape = DEFAULT_SHAPE;
        this.listeners = new PropertyChangeSupport(this);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public ChartRenderingInfo getInfo() {
        return this.info;
    }

    public void setInfo(ChartRenderingInfo chartRenderingInfo) {
        this.info = chartRenderingInfo;
    }

    public DrawingSupplier getDrawingSupplier() {
        return this.supplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.supplier = drawingSupplier;
    }

    public boolean isPaintTableActive() {
        return this.paintTableActive;
    }

    public void setPaintTableActive(boolean bl) {
        this.paintTableActive = bl;
        if (bl && this.paintTable == null) {
            this.paintTable = new PaintTable();
        }
    }

    public Paint getItemPaint(int n, int n2, int n3) {
        return this.getSeriesPaint(n, n2);
    }

    public Paint getSeriesPaint(int n, int n2) {
        Paint paint = this.defaultPaint;
        if (this.paintTableActive && (paint = this.paintTable.getPaint(n, n2)) == null) {
            paint = this.supplier.getNextPaint();
            this.paintTable.setPaint(n, n2, paint);
        }
        return paint;
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.setSeriesPaint(0, n, paint);
    }

    public void setSeriesPaint(int n, int n2, Paint paint) {
        this.setPaintTableActive(true);
        this.paintTable.setPaint(n, n2, paint);
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public void setDefaultPaint(Paint paint) {
        this.defaultPaint = paint;
    }

    public boolean isOutlinePaintTableActive() {
        return this.outlinePaintTableActive;
    }

    public void setOutlinePaintTableActive(boolean bl) {
        this.outlinePaintTableActive = bl;
        if (bl && this.outlinePaintTable == null) {
            this.outlinePaintTable = new PaintTable();
        }
    }

    public Paint getItemOutlinePaint(int n, int n2, int n3) {
        return this.getSeriesOutlinePaint(n, n2);
    }

    public Paint getSeriesOutlinePaint(int n, int n2) {
        Paint paint = this.defaultOutlinePaint;
        if (this.outlinePaintTableActive && (paint = this.outlinePaintTable.getPaint(n, n2)) == null) {
            paint = this.supplier.getNextOutlinePaint();
            this.outlinePaintTable.setPaint(n, n2, paint);
        }
        return paint;
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.setSeriesOutlinePaint(0, n, paint);
    }

    public void setSeriesOutlinePaint(int n, int n2, Paint paint) {
        this.setOutlinePaintTableActive(true);
        this.outlinePaintTable.setPaint(n, n2, paint);
    }

    public Paint getDefaultOutlinePaint() {
        return this.defaultOutlinePaint;
    }

    public void setDefaultOutlinePaint(Paint paint) {
        this.defaultOutlinePaint = paint;
    }

    public boolean isStrokeTableActive() {
        return this.strokeTableActive;
    }

    public void setStrokeTableActive(boolean bl) {
        this.strokeTableActive = bl;
        if (bl && this.strokeTable == null) {
            this.strokeTable = new StrokeTable();
        }
    }

    public Stroke getItemStroke(int n, int n2, int n3) {
        return this.getSeriesStroke(n, n2);
    }

    public Stroke getSeriesStroke(int n, int n2) {
        Stroke stroke = this.defaultStroke;
        if (this.strokeTableActive && (stroke = this.strokeTable.getStroke(n, n2)) == null) {
            stroke = this.supplier.getNextStroke();
            this.strokeTable.setStroke(n, n2, stroke);
        }
        return stroke;
    }

    public void setSeriesStroke(int n, Stroke stroke) {
        this.setSeriesStroke(0, n, stroke);
    }

    public void setSeriesStroke(int n, int n2, Stroke stroke) {
        this.setStrokeTableActive(true);
        this.strokeTable.setStroke(n, n2, stroke);
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void setDefaultStroke(Stroke stroke) {
        this.defaultStroke = stroke;
    }

    public boolean isOutlineStrokeTableActive() {
        return this.outlineStrokeTableActive;
    }

    public void setOutlineStrokeTableActive(boolean bl) {
        this.outlineStrokeTableActive = bl;
        if (bl && this.outlineStrokeTable == null) {
            this.outlineStrokeTable = new StrokeTable();
        }
    }

    public Stroke getItemOutlineStroke(int n, int n2, int n3) {
        return this.getSeriesOutlineStroke(n, n2);
    }

    public Stroke getSeriesOutlineStroke(int n, int n2) {
        Stroke stroke = this.defaultOutlineStroke;
        if (this.outlineStrokeTableActive && (stroke = this.outlineStrokeTable.getStroke(n, n2)) == null) {
            stroke = this.supplier.getNextOutlineStroke();
            this.outlineStrokeTable.setStroke(n, n2, stroke);
        }
        return stroke;
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.setSeriesOutlineStroke(0, n, stroke);
    }

    public void setSeriesOutlineStroke(int n, int n2, Stroke stroke) {
        this.setOutlineStrokeTableActive(true);
        this.outlineStrokeTable.setStroke(n, n2, stroke);
    }

    public Stroke getDefaultOutlineStroke() {
        return this.defaultOutlineStroke;
    }

    public void setDefaultOutlineStroke(Stroke stroke) {
        this.defaultOutlineStroke = stroke;
    }

    protected synchronized Shape createTransformedShape(Shape shape, double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public boolean isShapeTableActive() {
        return this.shapeTableActive;
    }

    public void setShapeTableActive(boolean bl) {
        this.shapeTableActive = bl;
    }

    public Shape getItemShape(int n, int n2, int n3) {
        return this.getSeriesShape(n, n2);
    }

    public Shape getSeriesShape(int n, int n2) {
        Shape shape = this.defaultShape;
        if (this.shapeTableActive && (shape = this.shapeTable.getShape(n, n2)) == null) {
            shape = this.supplier.getNextShape();
            this.shapeTable.setShape(n, n2, shape);
        }
        return shape;
    }

    public void setSeriesShape(int n, Shape shape) {
        this.setSeriesShape(0, n, shape);
    }

    public void setSeriesShape(int n, int n2, Shape shape) {
        this.setShapeTableActive(true);
        this.shapeTable.setShape(n, n2, shape);
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public void setDefaultShape(Shape shape) {
        this.defaultShape = shape;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof AbstractRenderer) {
            AbstractRenderer abstractRenderer = (AbstractRenderer)object;
            boolean bl = true;
            boolean bl2 = ObjectUtils.equalOrBothNull((Object)this.supplier, (Object)abstractRenderer.supplier);
            boolean bl3 = ObjectUtils.equalOrBothNull((Object)this.defaultPaint, (Object)abstractRenderer.defaultPaint);
            boolean bl4 = this.paintTableActive == abstractRenderer.isPaintTableActive();
            boolean bl5 = ObjectUtils.equalOrBothNull((Object)this.paintTable, (Object)abstractRenderer.paintTable);
            boolean bl6 = ObjectUtils.equalOrBothNull((Object)this.defaultOutlinePaint, (Object)abstractRenderer.defaultOutlinePaint);
            boolean bl7 = this.outlinePaintTableActive == abstractRenderer.isOutlinePaintTableActive();
            boolean bl8 = ObjectUtils.equalOrBothNull((Object)this.outlinePaintTable, (Object)abstractRenderer.outlinePaintTable);
            boolean bl9 = ObjectUtils.equalOrBothNull((Object)this.defaultStroke, (Object)abstractRenderer.defaultStroke);
            boolean bl10 = this.strokeTableActive == abstractRenderer.isStrokeTableActive();
            boolean bl11 = ObjectUtils.equalOrBothNull((Object)this.strokeTable, (Object)abstractRenderer.strokeTable);
            boolean bl12 = ObjectUtils.equalOrBothNull((Object)this.defaultOutlineStroke, (Object)abstractRenderer.defaultOutlineStroke);
            boolean bl13 = this.outlineStrokeTableActive == abstractRenderer.isOutlineStrokeTableActive();
            boolean bl14 = ObjectUtils.equalOrBothNull((Object)this.outlineStrokeTable, (Object)abstractRenderer.outlineStrokeTable);
            boolean bl15 = ObjectUtils.equalOrBothNull((Object)this.defaultShape, (Object)abstractRenderer.defaultShape);
            boolean bl16 = this.shapeTableActive == abstractRenderer.isShapeTableActive();
            boolean bl17 = ObjectUtils.equalOrBothNull((Object)this.shapeTable, (Object)abstractRenderer.shapeTable);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl17;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.defaultPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.defaultOutlinePaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.defaultStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.defaultOutlineStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeShape((Shape)this.defaultShape, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.defaultPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.defaultOutlinePaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.defaultStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.defaultOutlineStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.defaultShape = SerialUtilities.readShape((ObjectInputStream)objectInputStream);
    }
}

