/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.RegularTimePeriod;

public class Minute
extends RegularTimePeriod
implements Serializable {
    public static final int FIRST_MINUTE_IN_HOUR = 0;
    public static final int LAST_MINUTE_IN_HOUR = 59;
    private static final long MILLISECONDS_PER_MINUTE = 60000L;
    private Hour hour;
    private int minute;

    public Minute() {
        this(new Date());
    }

    public Minute(int n, Hour hour) {
        this.minute = n;
        this.hour = hour;
    }

    public Minute(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Minute(Date date, TimeZone timeZone) {
        int n;
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.minute = n = calendar.get(12);
        this.hour = new Hour(date, timeZone);
    }

    public Hour getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public RegularTimePeriod previous() {
        Hour hour;
        Minute minute = this.minute != 0 ? new Minute(this.minute - 1, this.hour) : ((hour = (Hour)this.hour.previous()) != null ? new Minute(59, hour) : null);
        return minute;
    }

    public RegularTimePeriod next() {
        Hour hour;
        Minute minute = this.minute != 59 ? new Minute(this.minute + 1, this.hour) : ((hour = (Hour)this.hour.next()) != null ? new Minute(0, hour) : null);
        return minute;
    }

    public long getSerialIndex() {
        return this.hour.getSerialIndex() * 60L + (long)this.minute;
    }

    public long getFirstMillisecond(Calendar calendar) {
        int n = this.hour.getDay().getYear();
        int n2 = this.hour.getDay().getMonth() - 1;
        int n3 = this.hour.getDay().getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour.getHour(), this.minute, 0);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public long getLastMillisecond(Calendar calendar) {
        int n = this.hour.getDay().getYear();
        int n2 = this.hour.getDay().getMonth() - 1;
        int n3 = this.hour.getDay().getDayOfMonth();
        calendar.clear();
        calendar.set(n, n2, n3, this.hour.getHour(), this.minute, 59);
        calendar.set(14, 999);
        return calendar.getTime().getTime();
    }

    public boolean equals(Object object) {
        if (object instanceof Minute) {
            Minute minute = (Minute)object;
            return this.minute == minute.getMinute() && this.hour.equals(minute.getHour());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Minute) {
            Minute minute = (Minute)object;
            n = this.getHour().compareTo(minute.getHour());
            if (n == 0) {
                n = this.minute - minute.getMinute();
            }
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public static Minute parseMinute(String string) {
        Minute minute = null;
        String string2 = (string = string.trim()).substring(0, Math.min(10, string.length()));
        Day day = Day.parseDay(string2);
        if (day != null) {
            String string3;
            int n;
            String string4 = string.substring(Math.min(string2.length() + 1, string.length()), string.length());
            String string5 = (string4 = string4.trim()).substring(0, Math.min(2, string4.length()));
            int n2 = Integer.parseInt(string5);
            if (n2 >= 0 && n2 <= 23 && (n = Integer.parseInt(string3 = string4.substring(Math.min(string5.length() + 1, string4.length()), string4.length()))) >= 0 && n <= 59) {
                minute = new Minute(n, new Hour(n2, day));
            }
        }
        return minute;
    }
}

