/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.gjt.mm.mysql.Buffer;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.ResultSet;
import org.gjt.mm.mysql.Statement;

public class PreparedStatement
extends Statement {
    private static SimpleDateFormat _TSDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String _Sql;
    private String[] _TemplateStrings;
    protected String[] _ParameterStrings;
    protected InputStream[] _ParameterStreams;
    protected boolean[] _IsStream;
    protected Connection _Conn;
    private boolean _do_concat = false;
    private boolean _has_limit_clause = false;
    private byte[] _bi = new byte[4096];
    private static NumberFormat _DoubleFormatter = NumberFormat.getNumberInstance(Locale.US);

    public PreparedStatement(Connection connection, String string, String string2) throws SQLException {
        super(connection, string2);
        int n;
        if (string.indexOf("||") != -1) {
            this._do_concat = true;
        }
        this._has_limit_clause = string.toUpperCase().indexOf("LIMIT") != -1;
        Vector<String> vector = new Vector<String>();
        boolean bl = false;
        int n2 = 0;
        this._Sql = string;
        this._Conn = connection;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this._Sql.length()) {
            n = this._Sql.charAt(n5);
            if (n == 39 && n3 == 92 && n4 == 92) {
                bl = !bl;
            } else if (n == 39 && n3 != 92) {
                boolean bl2 = bl = !bl;
            }
            if (n == 63 && !bl) {
                vector.addElement(this._Sql.substring(n2, n5));
                n2 = n5 + 1;
            }
            n4 = n3;
            n3 = n;
            ++n5;
        }
        vector.addElement(this._Sql.substring(n2, this._Sql.length()));
        this._TemplateStrings = new String[vector.size()];
        this._ParameterStrings = new String[vector.size() - 1];
        this._ParameterStreams = new InputStream[vector.size() - 1];
        this._IsStream = new boolean[vector.size() - 1];
        this.clearParameters();
        n5 = 0;
        while (n5 < this._TemplateStrings.length) {
            this._TemplateStrings[n5] = (String)vector.elementAt(n5);
            ++n5;
        }
        n = 0;
        while (n < this._ParameterStrings.length) {
            this._IsStream[n] = false;
            ++n;
        }
    }

    public java.sql.ResultSet executeQuery() throws SQLException {
        boolean bl = this._escapeProcessing;
        this._escapeProcessing = false;
        Buffer buffer = new Buffer(this._Conn.getNetBufferLength(), this._Conn.getMaxAllowedPacket());
        buffer.buf[buffer.pos++] = 3;
        String string = null;
        if (this._Conn.useUnicode()) {
            string = this._Conn.getEncoding();
        }
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (this._ParameterStrings[n] == null && this._IsStream[n] && this._ParameterStreams[n] == null) {
                    throw new SQLException("No value specified for parameter " + (n + 1), "07001");
                }
                if (string != null) {
                    buffer.writeStringNoNull(this._TemplateStrings[n], string);
                } else {
                    buffer.writeStringNoNull(this._TemplateStrings[n]);
                }
                if (this._IsStream[n]) {
                    buffer.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[n]));
                } else {
                    if (bl) {
                        this._ParameterStrings[n] = this._Escaper.escapeSQL(this._ParameterStrings[n]);
                    }
                    if (string != null) {
                        buffer.writeStringNoNull(this._ParameterStrings[n], string);
                    } else {
                        buffer.writeStringNoNull(this._ParameterStrings[n]);
                    }
                }
                ++n;
            }
            if (string != null) {
                buffer.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length], string);
            } else {
                buffer.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + string + "'");
        }
        if (this._Results != null) {
            this._Results.close();
        }
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                string2 = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (this._has_limit_clause) {
                    this._Results = this._Conn.execSQL(null, this._max_rows, buffer);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + 50000000, -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    this._Results = this._Conn.execSQL(null, -1, buffer);
                    if (string2 != null) {
                        this._Conn.setCatalog(string2);
                    }
                }
            } else {
                this._Results = this._Conn.execSQL(null, -1, buffer);
            }
            if (string2 != null) {
                this._Conn.setCatalog(string2);
            }
        }
        this._last_insert_id = this._Results.getUpdateID();
        this._NextResults = this._Results;
        this._Results.setConnection(this._Conn);
        this._escapeProcessing = bl;
        return (java.sql.ResultSet)((Object)this._Results);
    }

    public int executeUpdate() throws SQLException {
        boolean bl = this._escapeProcessing;
        this._escapeProcessing = false;
        Buffer buffer = new Buffer(this._Conn.getNetBufferLength(), this._Conn.getMaxAllowedPacket());
        buffer.buf[buffer.pos++] = 3;
        String string = null;
        if (this._Conn.useUnicode()) {
            string = this._Conn.getEncoding();
        }
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (this._ParameterStrings[n] == null && this._IsStream[n] && this._ParameterStreams[n] == null) {
                    throw new SQLException("No value specified for parameter " + (n + 1), "07001");
                }
                if (string != null) {
                    buffer.writeStringNoNull(this._TemplateStrings[n], string);
                } else {
                    buffer.writeStringNoNull(this._TemplateStrings[n]);
                }
                if (this._IsStream[n]) {
                    buffer.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[n]));
                } else {
                    if (bl) {
                        this._ParameterStrings[n] = this._Escaper.escapeSQL(this._ParameterStrings[n]);
                    }
                    if (string != null) {
                        buffer.writeStringNoNull(this._ParameterStrings[n], string);
                    } else {
                        buffer.writeStringNoNull(this._ParameterStrings[n]);
                    }
                }
                ++n;
            }
            if (string != null) {
                buffer.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length], string);
            } else {
                buffer.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + string + "'");
        }
        ResultSet resultSet = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                string2 = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            resultSet = this._Conn.execSQL(null, -1, buffer);
            if (string2 != null) {
                this._Conn.setCatalog(string2);
            }
        }
        if (resultSet.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this._update_count = resultSet.getUpdateCount();
        int n = 0;
        n = this._update_count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._update_count;
        this._last_insert_id = resultSet.getUpdateID();
        this._escapeProcessing = bl;
        return n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.set(n, "null");
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.set(n, bl ? "'t'" : "'f'");
    }

    public void setByte(int n, byte by) throws SQLException {
        this.set(n, new Integer(by).toString());
    }

    public void setShort(int n, short s) throws SQLException {
        this.set(n, new Integer(s).toString());
    }

    public void setInt(int n, int n2) throws SQLException {
        this.set(n, new Integer(n2).toString());
    }

    public void setLong(int n, long l) throws SQLException {
        this.set(n, new Long(l).toString());
    }

    public void setFloat(int n, float f) throws SQLException {
        this.set(n, new Float(f).toString());
    }

    public void setDouble(int n, double d) throws SQLException {
        this.set(n, _DoubleFormatter.format(d));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull(n, 3);
            return;
        }
        this.set(n, bigDecimal.toString());
    }

    public void setString(int n, String string) throws SQLException {
        if (string == null) {
            this.set(n, "null");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\'');
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (c == '\\' || c == '\'' || c == '\"') {
                stringBuffer.append('\\');
            }
            stringBuffer.append(c);
            ++n2;
        }
        stringBuffer.append('\'');
        this.set(n, stringBuffer.toString());
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (byArray == null) {
            this.setNull(n, -2);
            return;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.setBinaryStream(n, byteArrayInputStream, byArray.length);
    }

    public void setDate(int n, Date date) throws SQLException {
        if (date == null) {
            this.setNull(n, 91);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("''yyyy-MM-dd''");
        this.set(n, simpleDateFormat.format(date));
    }

    public void setTime(int n, Time time) throws SQLException {
        if (time == null) {
            this.setNull(n, 92);
            return;
        }
        this.set(n, "'" + time.toString() + "'");
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(n, 93);
            return;
        }
        String string = "'" + _TSDF.format(timestamp) + "'";
        this.set(n, string);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, 12);
            return;
        }
        this.setBinaryStream(n, inputStream, n2);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (inputStream == null) {
            this.setNull(n, -2);
            return;
        }
        if (n < 1 || n > this._TemplateStrings.length) {
            throw new SQLException("Parameter index out of range (" + n + " > " + this._TemplateStrings.length + ")", "S1009");
        }
        this._ParameterStreams[n - 1] = inputStream;
        this._IsStream[n - 1] = true;
    }

    public void clearParameters() throws SQLException {
        int n = 0;
        while (n < this._ParameterStrings.length) {
            this._ParameterStrings[n] = null;
            this._ParameterStreams[n] = null;
            this._IsStream[n] = false;
            ++n;
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (object == null) {
            this.setNull(n, 1111);
            return;
        }
        try {
            switch (n2) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    Number number;
                    if (object instanceof Boolean) {
                        number = (Boolean)object != false ? new Integer(1) : new Integer(0);
                    } else if (object instanceof String) {
                        switch (n2) {
                            case -6: 
                            case 4: 
                            case 5: {
                                number = Integer.valueOf((String)object);
                                break;
                            }
                            case -5: {
                                number = Long.valueOf((String)object);
                                break;
                            }
                            case 7: {
                                number = Float.valueOf((String)object);
                                break;
                            }
                            case 6: 
                            case 8: {
                                number = Double.valueOf((String)object);
                                break;
                            }
                            default: {
                                number = new BigDecimal((String)object);
                                break;
                            }
                        }
                    } else {
                        number = (Number)object;
                    }
                    switch (n2) {
                        case -6: 
                        case 4: 
                        case 5: {
                            this.setInt(n, number.intValue());
                            return;
                        }
                        case -5: {
                            this.setLong(n, number.longValue());
                            return;
                        }
                        case 7: {
                            this.setFloat(n, number.floatValue());
                            return;
                        }
                        case 6: 
                        case 8: {
                            this.setDouble(n, number.doubleValue());
                            return;
                        }
                    }
                    if (number instanceof BigDecimal) {
                        this.setBigDecimal(n, (BigDecimal)number);
                        return;
                    }
                    if (number instanceof BigInteger) {
                        this.setBigDecimal(n, new BigDecimal((BigInteger)number, n3));
                        return;
                    }
                    this.setBigDecimal(n, new BigDecimal(number.doubleValue()));
                    return;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.setString(n, object.toString());
                    return;
                }
                case -4: 
                case -3: 
                case -2: {
                    if (object instanceof String) {
                        this.setBytes(n, ((String)object).getBytes());
                        return;
                    }
                    this.setBytes(n, (byte[])object);
                    return;
                }
                case 91: 
                case 93: {
                    java.util.Date date;
                    if (object instanceof String) {
                        ParsePosition parsePosition = new ParsePosition(0);
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateTimePattern((String)object, false));
                        date = ((DateFormat)simpleDateFormat).parse((String)object, parsePosition);
                    } else {
                        date = (java.util.Date)object;
                    }
                    switch (n2) {
                        case 91: {
                            if (date instanceof Date) {
                                this.setDate(n, (Date)date);
                                return;
                            }
                            this.setDate(n, new Date(date.getTime()));
                            return;
                        }
                        case 93: {
                            if (date instanceof Timestamp) {
                                this.setTimestamp(n, (Timestamp)date);
                                return;
                            }
                            this.setTimestamp(n, new Timestamp(date.getTime()));
                            return;
                        }
                        default: {
                            return;
                        }
                    }
                }
                case 92: {
                    if (object instanceof String) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.getDateTimePattern((String)object, true));
                        this.setTime(n, new Time(simpleDateFormat.parse((String)object).getTime()));
                        return;
                    }
                    this.setTime(n, (Time)object);
                    return;
                }
                case 1111: {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(object);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                        byteArrayOutputStream.flush();
                        ((OutputStream)byteArrayOutputStream).close();
                        byte[] byArray = byteArrayOutputStream.toByteArray();
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                        this.setBinaryStream(n, byteArrayInputStream, -1);
                        return;
                    }
                    catch (Exception exception) {
                        throw new SQLException("Invalid argument value: " + exception.getClass().getName(), "S1009");
                    }
                }
            }
            throw new SQLException("Unknown Types value", "S1000");
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw new SQLException("Cannot convert " + object.getClass().toString() + " to SQL type requested", "S1000");
        }
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (object == null) {
            this.setNull(n, 1111);
            return;
        }
        if (object instanceof String) {
            this.setString(n, (String)object);
            return;
        }
        if (object instanceof BigDecimal) {
            this.setBigDecimal(n, (BigDecimal)object);
            return;
        }
        if (object instanceof Short) {
            this.setShort(n, (Short)object);
            return;
        }
        if (object instanceof Integer) {
            this.setInt(n, (Integer)object);
            return;
        }
        if (object instanceof Long) {
            this.setLong(n, (Long)object);
            return;
        }
        if (object instanceof Float) {
            this.setFloat(n, ((Float)object).floatValue());
            return;
        }
        if (object instanceof Double) {
            this.setDouble(n, (Double)object);
            return;
        }
        if (object instanceof byte[]) {
            this.setBytes(n, (byte[])object);
            return;
        }
        if (object instanceof Date) {
            this.setDate(n, (Date)object);
            return;
        }
        if (object instanceof Time) {
            this.setTime(n, (Time)object);
            return;
        }
        if (object instanceof Timestamp) {
            this.setTimestamp(n, (Timestamp)object);
            return;
        }
        if (object instanceof Boolean) {
            this.setBoolean(n, (Boolean)object);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
            byteArrayOutputStream.flush();
            ((OutputStream)byteArrayOutputStream).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.setBinaryStream(n, byteArrayInputStream, -1);
            return;
        }
        catch (Exception exception) {
            throw new SQLException("Invalid argument value: " + exception.getClass().getName(), "S1009");
        }
    }

    public synchronized boolean execute() throws SQLException {
        boolean bl = this._escapeProcessing;
        this._escapeProcessing = false;
        Buffer buffer = new Buffer(this._Conn.getNetBufferLength(), this._Conn.getMaxAllowedPacket());
        buffer.buf[buffer.pos++] = 3;
        String string = null;
        if (this._Conn.useUnicode()) {
            string = this._Conn.getEncoding();
        }
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (this._ParameterStrings[n] == null && this._IsStream[n] && this._ParameterStreams[n] == null) {
                    throw new SQLException("No value specified for parameter " + (n + 1));
                }
                if (string != null) {
                    buffer.writeStringNoNull(this._TemplateStrings[n], string);
                } else {
                    buffer.writeStringNoNull(this._TemplateStrings[n]);
                }
                if (this._IsStream[n]) {
                    buffer.writeBytesNoNull(this.streamToBytes(this._ParameterStreams[n]));
                } else {
                    if (bl) {
                        this._ParameterStrings[n] = this._Escaper.escapeSQL(this._ParameterStrings[n]);
                    }
                    if (string != null) {
                        buffer.writeStringNoNull(this._ParameterStrings[n], string);
                    } else {
                        buffer.writeStringNoNull(this._ParameterStrings[n]);
                    }
                }
                ++n;
            }
            if (string != null) {
                buffer.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length], string);
            } else {
                buffer.writeStringNoNull(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SQLException("Unsupported character encoding '" + string + "'");
        }
        ResultSet resultSet = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                string2 = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (this._has_limit_clause) {
                    resultSet = this._Conn.execSQL(null, this._max_rows, buffer);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + 50000000, -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    resultSet = this._Conn.execSQL(null, -1, buffer);
                }
            } else {
                resultSet = this._Conn.execSQL(null, -1, buffer);
            }
            if (string2 != null) {
                this._Conn.setCatalog(string2);
            }
        }
        this._last_insert_id = resultSet.getUpdateID();
        if (resultSet != null) {
            this._Results = resultSet;
        }
        this._escapeProcessing = bl;
        resultSet.setConnection(this._Conn);
        return resultSet != null && resultSet.reallyResult();
    }

    public String toString() {
        String string = null;
        if (this._Conn.useUnicode()) {
            string = this._Conn.getEncoding();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(": ");
        try {
            int n = 0;
            while (n < this._ParameterStrings.length) {
                if (string != null) {
                    stringBuffer.append(new String(this._TemplateStrings[n].getBytes(), string));
                } else {
                    stringBuffer.append(this._TemplateStrings[n]);
                }
                if (this._ParameterStrings[n] == null && this._IsStream[n] && this._ParameterStreams[n] == null) {
                    stringBuffer.append("** NOT SPECIFIED **");
                } else if (this._IsStream[n]) {
                    stringBuffer.append("** STREAM DATA **");
                } else {
                    if (this._escapeProcessing) {
                        try {
                            this._ParameterStrings[n] = this._Escaper.escapeSQL(this._ParameterStrings[n]);
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (string != null) {
                        stringBuffer.append(new String(this._ParameterStrings[n].getBytes(), string));
                    } else {
                        stringBuffer.append(this._ParameterStrings[n]);
                    }
                }
                ++n;
            }
            if (string != null) {
                stringBuffer.append(new String(this._TemplateStrings[this._ParameterStrings.length].getBytes(), string));
            } else {
                stringBuffer.append(this._TemplateStrings[this._ParameterStrings.length]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            stringBuffer.append("\n\n** WARNING **\n\n Unsupported character encoding '");
            stringBuffer.append(string);
            stringBuffer.append("'");
        }
        return stringBuffer.toString();
    }

    private final void set(int n, String string) throws SQLException {
        if (n < 1 || n > this._TemplateStrings.length) {
            throw new SQLException("Parameter index out of range (" + n + " > " + this._TemplateStrings.length + ").", "S1009");
        }
        this._ParameterStrings[n - 1] = string;
    }

    private final int readblock(InputStream inputStream, byte[] byArray) throws SQLException {
        try {
            return inputStream.read(byArray);
        }
        catch (Throwable throwable) {
            throw new SQLException("Error reading from InputStream " + throwable.getClass().getName(), "S1000");
        }
    }

    private final void escapeblock(byte[] byArray, ByteArrayOutputStream byteArrayOutputStream, int n) {
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            if (by == 0) {
                byteArrayOutputStream.write(92);
                byteArrayOutputStream.write(48);
            } else {
                if (by == 92 || by == 39 || by == 34) {
                    byteArrayOutputStream.write(92);
                }
                byteArrayOutputStream.write(by);
            }
            ++n2;
        }
    }

    private final synchronized byte[] streamToBytes(InputStream inputStream) throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = this.readblock(inputStream, this._bi);
        byteArrayOutputStream.write(39);
        while (n > 0) {
            this.escapeblock(this._bi, byteArrayOutputStream, n);
            n = this.readblock(inputStream, this._bi);
        }
        byteArrayOutputStream.write(39);
        return byteArrayOutputStream.toByteArray();
    }

    private final char getSuccessor(char c, int n) {
        if (c == 'y' && n == 2) {
            return 'X';
        }
        if (c == 'y' && n < 4) {
            return 'y';
        }
        if (c == 'y') {
            return 'M';
        }
        if (c == 'M' && n == 2) {
            return 'Y';
        }
        if (c == 'M' && n < 3) {
            return 'M';
        }
        if (c == 'M') {
            return 'd';
        }
        if (c == 'd' && n < 2) {
            return 'd';
        }
        if (c == 'd') {
            return 'h';
        }
        if (c == 'h' && n < 2) {
            return 'h';
        }
        if (c == 'h') {
            return 'm';
        }
        if (c == 'm' && n < 2) {
            return 'm';
        }
        if (c == 'm') {
            return 's';
        }
        if (c == 's' && n < 2) {
            return 's';
        }
        return 'W';
    }

    private final String getDateTimePattern(String string, boolean bl) throws Exception {
        Enumeration enumeration;
        char c;
        int n;
        Object[] objectArray;
        int n2;
        StringReader stringReader = new StringReader(String.valueOf(string) + " ");
        Vector<Object[]> vector = new Vector<Object[]>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        Object[] objectArray2 = new Object[]{new Character('y'), new StringBuffer(), new Integer(0)};
        vector.addElement(objectArray2);
        if (bl) {
            objectArray2 = new Object[]{new Character('h'), new StringBuffer(), new Integer(0)};
            vector.addElement(objectArray2);
        }
        while ((n2 = stringReader.read()) != -1) {
            char c2 = (char)n2;
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                objectArray = (Object[])vector.elementAt(n4);
                n = (Integer)objectArray[2];
                c = this.getSuccessor(((Character)objectArray[0]).charValue(), n);
                if (!Character.isLetterOrDigit(c2)) {
                    if (c == ((Character)objectArray[0]).charValue() && c != 'S') {
                        vector2.addElement(objectArray);
                    } else {
                        ((StringBuffer)objectArray[1]).append(c2);
                        if (c == 'X' || c == 'Y') {
                            objectArray[2] = new Integer(4);
                        }
                    }
                } else {
                    if (c == 'X') {
                        c = 'y';
                        objectArray2 = new Object[3];
                        objectArray2[1] = new StringBuffer(((StringBuffer)objectArray[1]).toString()).append('M');
                        objectArray2[0] = new Character('M');
                        objectArray2[2] = new Integer(1);
                        vector.addElement(objectArray2);
                    } else if (c == 'Y') {
                        c = 'M';
                        objectArray2 = new Object[3];
                        objectArray2[1] = new StringBuffer(((StringBuffer)objectArray[1]).toString()).append('d');
                        objectArray2[0] = new Character('d');
                        objectArray2[2] = new Integer(1);
                        vector.addElement(objectArray2);
                    }
                    ((StringBuffer)objectArray[1]).append(c);
                    if (c == ((Character)objectArray[0]).charValue()) {
                        objectArray[2] = new Integer(n + 1);
                    } else {
                        objectArray[0] = new Character(c);
                        objectArray[2] = new Integer(1);
                    }
                }
                ++n4;
            }
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                objectArray = (Object[])enumeration.nextElement();
                vector.removeElement(objectArray);
            }
            vector2.removeAllElements();
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            objectArray = (Object[])enumeration.nextElement();
            c = ((Character)objectArray[0]).charValue();
            boolean bl3 = this.getSuccessor(c, n = ((Integer)objectArray[2]).intValue()) != c;
            boolean bl4 = (c == 's' || c == 'm' || c == 'h' && bl) && bl3;
            boolean bl5 = bl3 && c == 'd' && !bl;
            boolean bl6 = bl2 = ((StringBuffer)objectArray[1]).toString().indexOf(87) != -1;
            if ((bl4 || bl5) && !bl2) continue;
            vector2.addElement(objectArray);
        }
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            vector.removeElement(enumeration2.nextElement());
        }
        vector2.removeAllElements();
        objectArray = (Object[])vector.firstElement();
        StringBuffer stringBuffer = (StringBuffer)objectArray[1];
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    static {
        _DoubleFormatter.setGroupingUsed(false);
        _DoubleFormatter.setMaximumFractionDigits(8);
    }
}

