/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.data.DateRange;
import org.jfree.data.Range;

public abstract class DateAxis
extends ValueAxis
implements Serializable {
    public static final DateRange DEFAULT_DATE_RANGE = new DateRange();
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE_IN_MILLISECONDS = 2.0;
    public static final DateTickUnit DEFAULT_DATE_TICK_UNIT = new DateTickUnit(2, 1, new SimpleDateFormat());
    public static final Date DEFAULT_ANCHOR_DATE = new Date();
    private DateTickUnit tickUnit;
    private DateFormat dateFormatOverride;
    private Date anchorDate;
    private boolean tickMarksAtStartOfUnit = true;

    protected DateAxis(String string) {
        super(string, DateAxis.createStandardDateTickUnits());
        this.setTickUnit(DEFAULT_DATE_TICK_UNIT, false, false);
        this.setAnchorDate(DEFAULT_ANCHOR_DATE);
        this.setAutoRangeMinimumSize(2.0);
        this.dateFormatOverride = null;
    }

    public DateTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateTickUnit dateTickUnit) {
        this.setTickUnit(dateTickUnit, true, true);
    }

    public void setTickUnit(DateTickUnit dateTickUnit, boolean bl, boolean bl2) {
        this.tickUnit = dateTickUnit;
        if (bl2) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public DateFormat getDateFormatOverride() {
        return this.dateFormatOverride;
    }

    public void setDateFormatOverride(DateFormat dateFormat) {
        this.dateFormatOverride = dateFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getAnchorDate() {
        return this.anchorDate;
    }

    public void setAnchorDate(Date date) {
        this.anchorDate = date;
        double d = date.getTime();
        super.setAnchorValue(d);
    }

    public void setAnchorValue(double d) {
        long l = (long)d;
        this.anchorDate.setTime(l);
        super.setAnchorValue(d);
    }

    public void setRange(Range range) {
        if (range == null) {
            throw new IllegalArgumentException("DateAxis.setRange(...): null not permitted.");
        }
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        this.setAutoRange(false, false);
        this.setRangeAttribute(range);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setRange(Date date, Date date2) {
        if (date.getTime() >= date2.getTime()) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower not before upper.");
        }
        this.setRange(new DateRange(date, date2));
    }

    public void setRange(double d, double d2) {
        if (d >= d2) {
            throw new IllegalArgumentException("DateAxis.setRange(...): lower >= upper.");
        }
        this.setRange(new DateRange(d, d2));
    }

    public Date getMinimumDate() {
        Date date = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getLowerDate();
        } else {
            date = new Date((long)range.getLowerBound());
        }
        return date;
    }

    public void setMinimumDate(Date date) {
        this.setRangeAttribute(new DateRange(date, this.getMaximumDate()));
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date getMaximumDate() {
        Date date = null;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getUpperDate();
        } else {
            date = new Date((long)range.getUpperBound());
        }
        return date;
    }

    public boolean isTickMarksAtStartOfUnit() {
        return this.tickMarksAtStartOfUnit;
    }

    public void setTickMarksAtStartOfUnit(boolean bl) {
        this.tickMarksAtStartOfUnit = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void setMaximumDate(Date date) {
        this.setRangeAttribute(new DateRange(this.getMinimumDate(), date));
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Date calculateLowestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.nextStandardDate(this.getMinimumDate(), dateTickUnit);
    }

    public Date calculateHighestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.previousStandardDate(this.getMaximumDate(), dateTickUnit);
    }

    protected Date previousStandardDate(Date date, DateTickUnit dateTickUnit) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = dateTickUnit.getCount();
        int n2 = calendar.get(dateTickUnit.getCalendarField());
        int n3 = n * (n2 / n);
        switch (dateTickUnit.getUnit()) {
            case 6: {
                int n4 = calendar.get(1);
                int n5 = calendar.get(2);
                int n6 = calendar.get(5);
                int n7 = calendar.get(11);
                int n8 = calendar.get(12);
                int n9 = calendar.get(13);
                calendar.set(n4, n5, n6, n7, n8, n9);
                calendar.set(14, n3);
                return calendar.getTime();
            }
            case 5: {
                int n10 = calendar.get(1);
                int n11 = calendar.get(2);
                int n12 = calendar.get(5);
                int n13 = calendar.get(11);
                int n14 = calendar.get(12);
                int n15 = this.tickMarksAtStartOfUnit ? 0 : 500;
                calendar.set(14, n15);
                calendar.set(n10, n11, n12, n13, n14, n3);
                return calendar.getTime();
            }
            case 4: {
                int n16 = calendar.get(1);
                int n17 = calendar.get(2);
                int n18 = calendar.get(5);
                int n19 = calendar.get(11);
                int n20 = this.tickMarksAtStartOfUnit ? 0 : 30;
                calendar.clear(14);
                calendar.set(n16, n17, n18, n19, n3, n20);
                return calendar.getTime();
            }
            case 3: {
                int n21 = calendar.get(1);
                int n22 = calendar.get(2);
                int n23 = calendar.get(5);
                int n24 = this.tickMarksAtStartOfUnit ? 0 : 30;
                calendar.clear(14);
                calendar.set(n21, n22, n23, n3, n24, 0);
                return calendar.getTime();
            }
            case 2: {
                int n25 = calendar.get(1);
                int n26 = calendar.get(2);
                int n27 = this.tickMarksAtStartOfUnit ? 0 : 12;
                calendar.clear(14);
                calendar.set(n25, n26, n3, n27, 0, 0);
                return calendar.getTime();
            }
            case 1: {
                int n28 = calendar.get(1);
                int n29 = this.tickMarksAtStartOfUnit ? 1 : 15;
                calendar.clear(14);
                calendar.set(n28, n3, n29, 0, 0, 0);
                return calendar.getTime();
            }
            case 0: {
                int n30 = this.tickMarksAtStartOfUnit ? 1 : 7;
                calendar.clear(14);
                calendar.set(n3, 0, n30, 0, 0, 0);
                return calendar.getTime();
            }
        }
        return null;
    }

    protected Date nextStandardDate(Date date, DateTickUnit dateTickUnit) {
        Date date2 = this.previousStandardDate(date, dateTickUnit);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        calendar.add(dateTickUnit.getCalendarField(), dateTickUnit.getCount());
        return calendar.getTime();
    }

    public static TickUnits createStandardDateTickUnits() {
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new DateTickUnit(6, 1, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 5, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 10, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 25, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 50, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 100, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 250, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(6, 500, new SimpleDateFormat("HH:mm:ss.SSS")));
        tickUnits.add(new DateTickUnit(5, 1, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(5, 5, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(5, 10, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(5, 30, new SimpleDateFormat("HH:mm:ss")));
        tickUnits.add(new DateTickUnit(4, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 2, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 5, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 10, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 15, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 20, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(4, 30, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 1, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 2, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 4, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 6, new SimpleDateFormat("HH:mm")));
        tickUnits.add(new DateTickUnit(3, 12, new SimpleDateFormat("d-MMM, HH:mm")));
        tickUnits.add(new DateTickUnit(2, 1, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 2, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 7, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(2, 15, new SimpleDateFormat("d-MMM")));
        tickUnits.add(new DateTickUnit(1, 1, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(1, 2, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(1, 6, new SimpleDateFormat("MMM-yyyy")));
        tickUnits.add(new DateTickUnit(0, 1, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 2, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 5, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 10, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 25, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 50, new SimpleDateFormat("yyyy")));
        tickUnits.add(new DateTickUnit(0, 100, new SimpleDateFormat("yyyy")));
        return tickUnits;
    }

    public void setAxisRange(double d, double d2) {
        this.setRange(d, d2);
    }
}

