/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.VerticalAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.VerticalValuePlot;
import org.jfree.data.DateRange;
import org.jfree.data.Range;

public class VerticalDateAxis
extends DateAxis
implements VerticalAxis,
Serializable {
    private boolean verticalLabel = true;

    public VerticalDateAxis(String string) {
        super(string);
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean bl) {
        if (this.verticalLabel != bl) {
            this.verticalLabel = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateDateToJava2D(Date date, Rectangle2D rectangle2D) {
        return this.translateValueToJava2D(date.getTime(), rectangle2D);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = rectangle2D.getMinY();
        double d5 = rectangle2D.getMaxY();
        if (this.isInverted()) {
            return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = range.getLowerBound();
        double d2 = range.getUpperBound();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (this.isInverted()) {
            return d + ((double)f - d3) / (d4 - d3) * (d2 - d);
        }
        return d2 - ((double)f - d3) / (d4 - d3) * (d2 - d);
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof VerticalValuePlot) {
            long l;
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)plot);
            Range range = verticalValuePlot.getVerticalDataRange(this);
            if (range == null) {
                range = new DateRange();
            }
            long l2 = (long)range.getUpperBound();
            long l3 = (long)this.getFixedAutoRange();
            if ((double)l3 > 0.0) {
                l = l2 - l3;
            } else {
                long l4;
                l = (long)range.getLowerBound();
                double d = l2 - l;
                if (d < (double)(l4 = (long)this.getAutoRangeMinimumSize())) {
                    long l5 = (long)((double)l4 - d) / 2L;
                    l2 += l5;
                    l -= l5;
                }
                l2 += (long)(d * this.getUpperMargin());
                l -= (long)(d * this.getLowerMargin());
            }
            this.setRangeAttribute(new DateRange(new Date(l), new Date(l2)));
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2);
        }
        Rectangle2D rectangle2D3 = null;
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.calculateHighestVisibleTickValue(dateTickUnit);
        while (date.before(date2)) {
            double d = this.translateDateToJava2D(date, rectangle2D2);
            String string = dateTickUnit.dateToString(date);
            rectangle2D3 = font.getStringBounds(string, graphics2D.getFontRenderContext());
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            float f = n == 3 ? (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.getTickLabelInsets().right) : (float)(rectangle2D2.getMaxX() + (double)this.getTickLabelInsets().left);
            float f2 = (float)(d + (double)(lineMetrics.getAscent() / 2.0f));
            Tick tick = new Tick(date, string, f, f2);
            this.getTicks().add(tick);
            date = dateTickUnit.addToDate(date);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        double d;
        double d2;
        double d3;
        if (!this.isVisible()) {
            return;
        }
        this.drawVerticalLabel(this.getLabel(), this.isVerticalLabel(), graphics2D, rectangle2D, rectangle2D2, n);
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
        if (n == 3) {
            d3 = rectangle2D2.getMinX();
            d2 = this.getTickMarkOutsideLength();
            d = this.getTickMarkInsideLength();
        } else {
            d3 = rectangle2D2.getMaxX();
            d2 = this.getTickMarkInsideLength();
            d = this.getTickMarkOutsideLength();
        }
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            Line2D.Double double_ = new Line2D.Double(d3 - d2, f, d3 + d, f);
            graphics2D.draw(double_);
        }
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        Cloneable cloneable;
        if (!this.isVisible()) {
            return 0.0;
        }
        if (this.getFixedDimension() > 0.0) {
            return this.getFixedDimension();
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            cloneable = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = insets.left + insets.right;
            d = this.verticalLabel ? (d += ((RectangularShape)cloneable).getHeight()) : (d += ((RectangularShape)cloneable).getWidth());
        }
        cloneable = this.getTickLabelInsets();
        double d2 = ((Insets)cloneable).left + ((Insets)cloneable).right;
        if (this.isTickLabelsVisible()) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d2 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return d + d2;
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        Cloneable cloneable;
        if (!this.isVisible()) {
            return 0.0;
        }
        if (this.getFixedDimension() > 0.0) {
            return this.getFixedDimension();
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            cloneable = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d2 = insets.left + insets.right;
            d2 = this.verticalLabel ? (d2 += ((RectangularShape)cloneable).getHeight()) : (d2 += ((RectangularShape)cloneable).getWidth());
        }
        cloneable = this.getTickLabelInsets();
        double d3 = ((Insets)cloneable).left + ((Insets)cloneable).right;
        if (this.isTickLabelsVisible()) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d);
            this.refreshTicks(graphics2D, rectangle2D, double_, n);
            d3 += this.getMaxTickLabelWidth(graphics2D, double_);
        }
        return d2 + d3;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = this.getTickLabelFont().getLineMetrics("123", fontRenderContext).getHeight() + (float)this.getTickLabelInsets().top + (float)this.getTickLabelInsets().bottom;
        double d2 = this.translateValueToJava2D(0.0, rectangle2D2);
        TickUnits tickUnits = this.getStandardTickUnits();
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnits.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.translateValueToJava2D(dateTickUnit.getSize(), rectangle2D2);
        double d4 = Math.abs(d3 - d2);
        int n = (int)(d / d4 * dateTickUnit.getSize());
        NumberTickUnit numberTickUnit = new NumberTickUnit(n, null);
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnits.getCeilingTickUnit(numberTickUnit);
        this.setTickUnit(dateTickUnit2, false, false);
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalValuePlot;
    }
}

