/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.CrosshairInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractXYItemRenderer;
import org.jfree.chart.renderer.HighLow;
import org.jfree.chart.renderer.XYItemRenderer;
import org.jfree.chart.tooltips.XYToolTipGenerator;
import org.jfree.data.HighLowDataset;
import org.jfree.data.XYDataset;

public class HighLowRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Serializable {
    public HighLowRenderer() {
        this((XYToolTipGenerator)null);
    }

    public HighLowRenderer(XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Rectangle2D rectangle2D2 = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        HighLowDataset highLowDataset = (HighLowDataset)xYDataset;
        Number number = highLowDataset.getXValue(n2, n3);
        Number number2 = highLowDataset.getHighValue(n2, n3);
        Number number3 = highLowDataset.getLowValue(n2, n3);
        Number number4 = highLowDataset.getOpenValue(n2, n3);
        Number number5 = highLowDataset.getCloseValue(n2, n3);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d4 = valueAxis2.translateValueToJava2D(number4.doubleValue(), rectangle2D);
        double d5 = valueAxis2.translateValueToJava2D(number5.doubleValue(), rectangle2D);
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getSeriesStroke(n, n2);
        HighLow highLow = new HighLow(d, d2, d3, d4, d5, stroke, paint);
        Line2D line2D = highLow.getOpenTickLine();
        Line2D line2D2 = highLow.getLine();
        Line2D line2D3 = highLow.getCloseTickLine();
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(line2D);
        graphics2D.draw(line2D2);
        graphics2D.draw(line2D3);
        if (entityCollection != null) {
            if (rectangle2D2 == null) {
                rectangle2D2 = highLow.getBounds();
            }
            String string = "";
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(rectangle2D2, string, string2, n2, n3);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

