/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.Format;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.Marker;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.BarRenderer;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.chart.tooltips.CategoryToolTipGenerator;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;
import org.jfree.data.Range;

public class HorizontalBarRenderer
extends BarRenderer
implements CategoryItemRenderer,
Serializable {
    public HorizontalBarRenderer() {
        this(null, null);
    }

    public HorizontalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public HorizontalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public HorizontalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, chartRenderingInfo);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            double d = 0.0;
            double d2 = 0.0;
            if (n > 1) {
                d = categoryAxis.getCategoryMargin();
            }
            if (n2 > 1) {
                d2 = this.getItemMargin();
            }
            double d3 = rectangle2D.getHeight() * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d - d2);
            if (n2 * n > 0) {
                this.setBarWidth(d3 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                this.setBarWidth(d3);
            }
        }
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d, rectangle2D.getMaxX(), d);
        Paint paint = categoryPlot.getDomainGridlinePaint();
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = categoryPlot.getRangeGridlinePaint();
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            Object object;
            Object object2;
            Object object3;
            double d;
            double d2 = number.doubleValue();
            double d3 = 0.0;
            double d4 = this.getLowerClip();
            double d5 = this.getUpperClip();
            if (d5 <= 0.0) {
                if (d2 >= d5) {
                    return;
                }
                d3 = d5;
                if (d2 <= d4) {
                    d2 = d4;
                }
            } else if (d4 <= 0.0) {
                if (d2 >= d5) {
                    d2 = d5;
                } else if (d2 <= d4) {
                    d2 = d4;
                }
            } else {
                if (d2 <= d4) {
                    return;
                }
                d3 = d4;
                if (d2 >= d5) {
                    d2 = d5;
                }
            }
            double d6 = valueAxis.translateValueToJava2D(d3, rectangle2D);
            double d7 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            double d8 = Math.min(d6, d7);
            double d9 = Math.abs(d7 - d6);
            double d10 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
            int n4 = this.getRowCount();
            int n5 = this.getColumnCount();
            if (n4 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n5 * (n4 - 1));
                d10 += (double)n2 * (this.getBarWidth() + d);
            } else {
                d10 += (double)n2 * this.getBarWidth();
            }
            d = this.getBarWidth();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d8, d10, d9, d);
            graphics2D.setPaint(this.getItemPaint(n, n2, n3));
            graphics2D.fill(double_);
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_);
                if (categoryPlot.getValueLabelsVisible()) {
                    object3 = categoryPlot.getValueLabelFont();
                    graphics2D.setFont((Font)object3);
                    object2 = categoryPlot.getValueLabelPaint();
                    graphics2D.setPaint((Paint)object2);
                    object = categoryPlot.getValueLabelFormatter();
                    graphics2D.drawString(((Format)object).format(number), (int)(d8 + d9 * 0.9), (int)d10 - 5);
                }
            }
            if (this.getInfo() != null && (object3 = this.getInfo().getEntityCollection()) != null) {
                object2 = null;
                if (this.getToolTipGenerator() != null) {
                    object2 = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                object = null;
                if (this.getURLGenerator() != null) {
                    object = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, (String)object2, (String)object, n2, categoryDataset.getColumnKey(n3), n3);
                object3.addEntity(categoryItemEntity);
            }
        }
    }
}

