/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.VerticalBarRenderer;
import org.jfree.chart.tooltips.CategoryToolTipGenerator;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.CategoryDataset;

public class StackedVerticalBarRenderer
extends VerticalBarRenderer
implements Serializable {
    private boolean linkingLines = false;
    private transient double[] pointsRegister = null;

    public StackedVerticalBarRenderer() {
        this(null, null);
    }

    public StackedVerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public StackedVerticalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public StackedVerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public int getRangeType() {
        return 1;
    }

    public boolean hasLinkingLines() {
        return this.linkingLines;
    }

    public void setLinkingLines(boolean bl) {
        this.linkingLines = bl;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, chartRenderingInfo);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            int n = categoryDataset.getColumnCount();
            double d = 0.0;
            if (n > 1) {
                d = categoryAxis.getCategoryMargin();
            }
            double d2 = rectangle2D.getWidth() * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d);
            if (n > 0) {
                this.setBarWidth(d2 / (double)n);
            } else {
                this.setBarWidth(d2);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Paint paint = this.getItemPaint(n, n2, n3);
        Paint paint2 = this.getItemOutlinePaint(n, n2, n3);
        if (this.hasLinkingLines() && this.pointsRegister == null) {
            this.pointsRegister = new double[categoryDataset.getColumnCount() * categoryDataset.getRowCount() * 2];
        }
        double d = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            Number number = categoryDataset.getValue(n4, n3);
            if (number != null) {
                double d4 = number.doubleValue();
                if (d4 > 0.0) {
                    d2 += d4;
                } else {
                    d3 += d4;
                }
            }
            ++n4;
        }
        boolean bl = false;
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            EntityCollection entityCollection;
            Object object;
            double d5;
            double d6;
            double d7;
            double d8 = number.doubleValue();
            if (d8 > 0.0) {
                d7 = valueAxis.translateValueToJava2D(d2, rectangle2D);
                d6 = valueAxis.translateValueToJava2D(d2 + d8, rectangle2D);
                d5 = Math.min(d7, d6);
                bl = true;
            } else {
                d7 = valueAxis.translateValueToJava2D(d3, rectangle2D);
                d6 = valueAxis.translateValueToJava2D(d3 + d8, rectangle2D);
                d5 = Math.min(d7, d6);
            }
            double d9 = this.getBarWidth();
            double d10 = Math.abs(d6 - d7);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d, d5, d9, d10);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (d9 > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_);
            }
            if (this.hasLinkingLines()) {
                if (n3 == 0) {
                    this.pointsRegister[2 * n2] = d + d9;
                    this.pointsRegister[2 * n2 + 1] = bl ? d5 : d5 + d10;
                } else {
                    double d11;
                    int n5 = n3 * categoryDataset.getRowCount() * 2 + 2 * n2;
                    this.pointsRegister[n5] = d + d9;
                    if (bl) {
                        d11 = this.pointsRegister[n5 - 2 * categoryDataset.getRowCount()];
                        if (d11 > 0.0) {
                            object = new Line2D.Double(d, d5, d11, this.pointsRegister[n5 - 2 * categoryDataset.getRowCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object);
                        }
                        this.pointsRegister[n5 + 1] = d5;
                    } else {
                        d11 = this.pointsRegister[n5 - 2 * categoryDataset.getRowCount()];
                        if (d11 > 0.0) {
                            object = new Line2D.Double(d, d5 + d10, d11, this.pointsRegister[n5 - 2 * categoryDataset.getRowCount() + 1]);
                            graphics2D.setPaint(Color.black);
                            graphics2D.draw((Shape)object);
                        }
                        this.pointsRegister[n5 + 1] = d5 + d10;
                    }
                }
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                object = new CategoryItemEntity(double_, string, string2, n2, categoryDataset.getColumnKey(n3), n3);
                entityCollection.addEntity((ChartEntity)object);
            }
        }
    }
}

