/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.pdf.hyphenation.Hyphenation;
import com.lowagie.text.pdf.hyphenation.HyphenationException;
import com.lowagie.text.pdf.hyphenation.HyphenationTree;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class Hyphenator {
    static Hashtable hyphenTrees = new Hashtable();
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean errorDump = false;
    private static String hyphenDir = "";
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$com$lowagie$text$pdf$hyphenation$Hyphenator;

    public Hyphenator(String string, String string2, int n, int n2) {
        this.hyphenTree = Hyphenator.getHyphenationTree(string, string2);
        this.remainCharCount = n;
        this.pushCharCount = n2;
    }

    public static HyphenationTree getHyphenationTree(String string, String string2) {
        String string3 = string;
        if (string2 != null && !string2.equals("none")) {
            string3 = string3 + "_" + string2;
        }
        if (hyphenTrees.containsKey(string3)) {
            return (HyphenationTree)hyphenTrees.get(string3);
        }
        if (hyphenTrees.containsKey(string)) {
            return (HyphenationTree)hyphenTrees.get(string);
        }
        HyphenationTree hyphenationTree = Hyphenator.getFopHyphenationTree(string3);
        if (hyphenationTree == null && hyphenDir != null) {
            hyphenationTree = Hyphenator.getUserHyphenationTree(string3, hyphenDir);
        }
        if (hyphenationTree != null) {
            hyphenTrees.put(string3, hyphenationTree);
        } else {
            System.out.println("Couldn't find hyphenation pattern " + string3);
        }
        return hyphenationTree;
    }

    private static InputStream getResourceStream(String string) {
        InputStream inputStream = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (method != null) {
                ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                inputStream = classLoader.getResourceAsStream("hyph/" + string + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = (class$com$lowagie$text$pdf$hyphenation$Hyphenator == null ? (class$com$lowagie$text$pdf$hyphenation$Hyphenator = Hyphenator.class$("com.lowagie.text.pdf.hyphenation.Hyphenator")) : class$com$lowagie$text$pdf$hyphenation$Hyphenator).getResourceAsStream("hyph/" + string + ".hyp");
        }
        return inputStream;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getFopHyphenationTree(String var0) {
        var1_1 = null;
        var2_2 = null;
        try {
            block13: {
                block14: {
                    block15: {
                        var2_2 = Hyphenator.getResourceStream(var0);
                        if (var2_2 != null) break block13;
                        if (var0.length() != 5) break block14;
                        var2_2 = Hyphenator.getResourceStream(var0.substring(0, 2));
                        if (var2_2 == null) break block15;
                        System.out.println("Couldn't find hyphenation pattern  " + var0 + "\nusing general language pattern " + var0.substring(0, 2) + " instead.");
                        break block13;
                    }
                    if (Hyphenator.errorDump) {
                        System.out.println("Couldn't find precompiled hyphenation pattern " + var0 + ".hyp");
                    }
                    var3_3 = null;
                    var5_6 = null;
                    if (var2_2 == null) return var3_3;
                    ** GOTO lbl51
                }
                if (Hyphenator.errorDump) {
                    System.out.println("Couldn't find precompiled hyphenation pattern " + var0 + ".hyp");
                }
                var3_4 = null;
                ** GOTO lbl57
            }
            var1_1 = new HyphenationTree();
            var1_1.loadInternalPatterns(var2_2);
            ** GOTO lbl65
        }
        catch (Exception var3_5) {
            var3_5.printStackTrace();
            var5_9 = null;
            if (var2_2 == null) return var1_1;
            try {
                var2_2.close();
                return var1_1;
            }
            catch (IOException var6_14) {
                System.out.println("can't close hyphenation stream");
                return var1_1;
            }
        }
        {
            catch (Throwable var4_16) {
                var5_10 = null;
                if (var2_2 == null) throw var4_16;
                ** try [egrp 2[TRYBLOCK] [2 : 212->219)] { 
lbl46:
                // 1 sources

                var2_2.close();
                throw var4_16;
lbl48:
                // 1 sources

                catch (IOException var6_15) {
                    System.out.println("can't close hyphenation stream");
                }
                throw var4_16;
            }
lbl51:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [2 : 212->219)] { 
lbl52:
            // 1 sources

            var2_2.close();
            return var3_3;
lbl54:
            // 1 sources

            catch (IOException var6_11) {
                System.out.println("can't close hyphenation stream");
            }
            return var3_3;
lbl57:
            // 1 sources

            var5_7 = null;
            if (var2_2 == null) return var3_4;
            ** try [egrp 2[TRYBLOCK] [2 : 212->219)] { 
lbl60:
            // 1 sources

            var2_2.close();
            return var3_4;
lbl62:
            // 1 sources

            catch (IOException var6_12) {
                System.out.println("can't close hyphenation stream");
            }
            return var3_4;
lbl65:
            // 1 sources

            var5_8 = null;
            if (var2_2 == null) return var1_1;
            try {}
            catch (IOException var6_13) {}
            System.out.println("can't close hyphenation stream");
            return var1_1;
            var2_2.close();
            return var1_1;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HyphenationTree getUserHyphenationTree(String string, String string2) {
        HyphenationTree hyphenationTree = null;
        File file = new File(string2, string + ".hyp");
        if (file.exists()) {
            ObjectInputStream objectInputStream = null;
            objectInputStream = new ObjectInputStream(new FileInputStream(file));
            hyphenationTree = (HyphenationTree)objectInputStream.readObject();
            Object var7_6 = null;
            if (objectInputStream == null) return hyphenationTree;
            try {
                objectInputStream.close();
                return hyphenationTree;
            }
            catch (IOException iOException) {}
            return hyphenationTree;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var7_7 = null;
                    if (objectInputStream == null) return hyphenationTree;
                    try {
                        objectInputStream.close();
                        return hyphenationTree;
                    }
                    catch (IOException iOException) {}
                    return hyphenationTree;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (objectInputStream == null) throw throwable;
                try {
                    objectInputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        file = new File(string2, string + ".hyp");
        if (file.exists()) {
            hyphenationTree = new HyphenationTree();
            if (errorDump) {
                System.out.println("reading " + string2 + string + ".hyp");
            }
            try {
                hyphenationTree.loadInternalPatterns(file.getPath());
                if (!errorDump) return hyphenationTree;
                System.out.println("Stats: ");
                hyphenationTree.printStats();
                return hyphenationTree;
            }
            catch (HyphenationException hyphenationException) {
                if (!errorDump) return null;
                System.out.println("Can't load user patterns from file " + string2 + string + ".hyp");
                return null;
            }
        }
        if (!errorDump) return null;
        System.out.println("Tried to load " + file.toString() + "\nCannot find compiled nor xml file for " + "hyphenation pattern" + string);
        return null;
    }

    public static Hyphenation hyphenate(String string, String string2, String string3, int n, int n2) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2);
        if (hyphenationTree == null) {
            System.out.println("Error building hyphenation tree for language " + string);
            return null;
        }
        return hyphenationTree.hyphenate(string3, n, n2);
    }

    public static Hyphenation hyphenate(String string, String string2, char[] cArray, int n, int n2, int n3, int n4) {
        HyphenationTree hyphenationTree = Hyphenator.getHyphenationTree(string, string2);
        if (hyphenationTree == null) {
            System.out.println("Error building hyphenation tree for language " + string);
            return null;
        }
        return hyphenationTree.hyphenate(cArray, n, n2, n3, n4);
    }

    public void setMinRemainCharCount(int n) {
        this.remainCharCount = n;
    }

    public void setMinPushCharCount(int n) {
        this.pushCharCount = n;
    }

    public void setLanguage(String string, String string2) {
        this.hyphenTree = Hyphenator.getHyphenationTree(string, string2);
    }

    public Hyphenation hyphenate(char[] cArray, int n, int n2) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(cArray, n, n2, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String string) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(string, this.remainCharCount, this.pushCharCount);
    }

    public static String getHyphenDir() {
        return hyphenDir;
    }

    public static void setHyphenDir(String string) {
        hyphenDir = string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

