/*
 * MainFrame.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 5 febbraio 2003, 12.45
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;
import javax.swing.tree.*;
import java.util.*;
import java.io.*;
import javax.swing.*;
import java.awt.event.*;


import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.*;
import org.xml.sax.SAXException;
/**
 * This class is the core of the GUI of iReport. From this class we control all
 * events related to the open and close files, handling of properties files,
 * handling JMDIDestopPane, Menus....
 *
 * @author  Administrator
 */
public class MainFrame extends javax.swing.JFrame implements ReportListener, Runnable
{
   
   public int docCounter=0;
   
   private Thread checkModifiedFielsThread = null;
   public static String constTitle = "iReport 0.2.3.0 - ";
   private String homeDirectory = ".";
   private java.util.Vector toolBarControls;
   private ElementPropertiesDialog elementPropertiesDialog;
   private ValuesDialog valuesDialog;
   private GroupsDialog groupsDialog;
   private BandsDialog bandsDialog;
   private FontsDialog fontsDialog;
   private ReportQueryDialog reportQueryDialog;
   private Vector ttfFonts;
   private Vector connections;
   private Properties properties;
   private Vector recentFilesList;
   private Vector favoriteFilesList;
   private Vector recentProjectsList;
   private Vector clipboards[];
   private int activeClipboard = 0;
   private boolean catchFormActivated = true;
   private boolean embeddedIreport = false;
   
   private boolean dontHandleEvent;
   
   private StringBuffer outputBuffer;
   
   public static final String IREPORT_HOME_DIR;
   
   public static final String IREPORT_RECENT_FILES_FILE;
   
   public static final String IREPORT_FAVORITE_FILES_FILE;
   
   public static final String IREPORT_RECENT_PROJECTS_FILE;
   
   public static final String IREPORT_CONFIG_FILE;
  
   public static final String IREPORT_DEFAULT_HOME_DIR;
   
   public static final int IREPORT_JAVA_VIEWER = 1;
   
   public static final int IREPORT_PDF_VIEWER = 2;
   
   public static final int IREPORT_HTML_VIEWER = 4;
   
   public static final int IREPORT_XLS_VIEWER = 8;
   
   public static final int IREPORT_CSV_VIEWER = 16;
   
   public static final int IREPORT_JASPER_VIEWER = 32;
   
   ///static section used to init some variables.
   static
   {
      IREPORT_HOME_DIR = System.getProperty("user.home") + File.separator + ".ireport";
      IREPORT_RECENT_FILES_FILE = IREPORT_HOME_DIR + File.separator + "recentFiles.xml";
      IREPORT_RECENT_PROJECTS_FILE = IREPORT_HOME_DIR + File.separator + "recentProjects.xml";
      IREPORT_FAVORITE_FILES_FILE = IREPORT_HOME_DIR + File.separator + "favoriteFiles.xml";
      IREPORT_CONFIG_FILE = IREPORT_HOME_DIR + File.separator + "config.xml";
      IREPORT_DEFAULT_HOME_DIR = System.getProperty("user.home");
      try
      {
         //nothing in here yet.
      }
      catch(Throwable e)
      {
         e.printStackTrace(System.err);
      }
   }//end static section for simple init
   
   /** Creates new form MainFrame */
   public MainFrame()
   {
      try
      {
         UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
         
      }catch(Exception e)
      {e.printStackTrace();}
      initComponents();
      
      outputBuffer = new StringBuffer();
      connections = new Vector();
      properties = new Properties();
      recentFilesList = new Vector();
      favoriteFilesList = new Vector();
      recentProjectsList = new Vector();
      
      this.ttfFonts = FontListLoader.loadTTFFonts();
      
      if (ttfFonts == null) ttfFonts = new Vector();
      
      System.setProperty("org.xml.sax.driver","org.apache.xerces.parsers.SAXParser");
      
      //jMDIDesktopPane.addInternalFrameActivatedListener(this);
      this.setTitle(constTitle+ " (c) 2002-2003 by Giulio Toffoli");
      toolBarControls = new java.util.Vector();
      
      elementPropertiesDialog = new ElementPropertiesDialog(this,false);
      elementPropertiesDialog.updateFonts(ttfFonts);
      valuesDialog = new ValuesDialog(this,false);
      groupsDialog = new GroupsDialog(this,false);
      bandsDialog = new BandsDialog(this,false);
      fontsDialog = new FontsDialog(this,false);
      reportQueryDialog = new ReportQueryDialog(this,false);
      
      jNumberComboBoxZoom.addValueChangedListener(new ValueChangedListener()
      {
         public void valueChanged(ValueChangedEvent evt)
         {
            jNumberComboBoxZoomValueChanged(evt);
         }
      });
      
      jMDIDesktopPane.addInternalFrameActivatedListener(new InternalFrameActivatedListener()
      {
         public void internalFrameActivated( InternalFrameActivatedEvent evt)
         {
            jMDIDesktopPaneInternalFrameActivated(evt);
         }
      });
      
      toolBarControls.addElement( this.jButtonNew);
      toolBarControls.addElement( this.jButtonOpen);
      toolBarControls.addElement( this.jButtonSave);
      toolBarControls.addElement( null);
      toolBarControls.addElement( this.jButtonCut);
      toolBarControls.addElement( this.jButtonCopy);
      toolBarControls.addElement( this.jButtonPaste);
      toolBarControls.addElement( null);
      toolBarControls.addElement( this.jToggleButtonPointer);
      toolBarControls.addElement( this.jToggleButtonLineTool);
      toolBarControls.addElement( this.jToggleButtonRectTool);
      toolBarControls.addElement( this.jToggleButtonRectRoundTool);
      toolBarControls.addElement( this.jToggleButtonEllipseTool);
      toolBarControls.addElement( this.jToggleButtonImageTool);
      toolBarControls.addElement( this.jToggleButtonStaticTextTool);
      toolBarControls.addElement( this.jToggleButtonTextFieldTool);
      toolBarControls.addElement( this.jToggleButtonSubreportTool);
      toolBarControls.addElement( this.jToggleButtonChartTool);
      toolBarControls.addElement( null);
      toolBarControls.addElement( this.jButtonParameters);
      toolBarControls.addElement( this.jButtonGroups);
      toolBarControls.addElement( this.jButtonBands);
      toolBarControls.addElement( this.jButtonDatabase);
      toolBarControls.addElement( null);
      toolBarControls.addElement( this.jPanelZoom);
      toolBarControls.addElement( null);
      toolBarControls.addElement( this.jButtonCompiler);
      
      toolBarControls.addElement(this.jButtonRun1);
      toolBarControls.addElement(this.jButtonRun2);
      toolBarControls.addElement( null);
      toolBarControls.addElement(this.jButtonAlignLeft);
      toolBarControls.addElement(this.jButtonAlignCenter);
      toolBarControls.addElement(this.jButtonAlignRight);
      toolBarControls.addElement(this.jButtonAlignJustify);
      
      jNumberComboBoxZoom.addEntry("50%",50);
      jNumberComboBoxZoom.addEntry("75%",75);
      jNumberComboBoxZoom.addEntry("100%",100);
      jNumberComboBoxZoom.addEntry("150%",150);
      jNumberComboBoxZoom.addEntry("200%",200);
      jNumberComboBoxZoom.addEntry("Fit to page",100);
      //java.awt.Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
      //this.setSize(dim);
      
      DefaultTreeSelectionModel dtsm = (DefaultTreeSelectionModel)jTreeDocument.getSelectionModel();
      dtsm.setSelectionMode( DefaultTreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION );
      
      jPanelToolBarComponentResized(new java.awt.event.ComponentEvent(jPanelToolBar,0));
      
      // This try is of java <1.4 comatibility
      try
      {
         this.setExtendedState(MAXIMIZED_BOTH);
      } catch (java.lang.NoSuchMethodError ex)
      {}
      
      java.awt.Image def = Misc.loadImageFromResources("it/businesslogic/ireport/icons/layout/img.gif");
      try
      {
         java.awt.MediaTracker mt = new java.awt.MediaTracker( new javax.swing.JPanel() );
         mt.addImage(def,0);
         mt.waitForID(0);
      } catch (Exception ex)
      {}
      ImageReportElement.setImgDef(def);
      //jNumberComboBoxZoom.setPostfix("%");
      
      javax.swing.tree.DefaultMutableTreeNode root = new javax.swing.tree.DefaultMutableTreeNode("Opened files");
      javax.swing.tree.DefaultMutableTreeNode rootDoc = new javax.swing.tree.DefaultMutableTreeNode("Document");
      javax.swing.tree.DefaultTreeModel model = new javax.swing.tree.DefaultTreeModel(root);
      javax.swing.tree.DefaultTreeModel modelDoc = new javax.swing.tree.DefaultTreeModel(rootDoc);
      
      javax.swing.ToolTipManager.sharedInstance().registerComponent(jTreeFiles);
      jTreeFiles.setModel( model );
      jTreeFiles.setCellRenderer( new ProjectExplorerTreeCellRenderer());
      
      jTreeDocument.setModel( modelDoc );
      jTreeDocument.setCellRenderer( new DocumentStructureTreeCellRenderer());
      
      
      loadiReportConfiguration();
      loadFileLists();
      
      updateRecentFileMenu(jMenuRecentFiles, getRecentFilesList() );
      updateRecentProjectMenu(jMenuRecentProjects, getRecentProjectsList());
      
      //IRCompilerDocument doc = new IRCompilerDocument();
      
      //this.jEditorPaneOutput.setDocument(doc );
      this.jEditorPaneOutput.setContentType("text/html");
      
      this.jEditorPaneOutput.addHyperlinkListener( new javax.swing.event.HyperlinkListener()
      {
         public void hyperlinkUpdate(javax.swing.event.HyperlinkEvent e)
         {
            if (e.getEventType() == javax.swing.event.HyperlinkEvent.EventType.ACTIVATED)
            {
               if (!parseError(e.getURL()))
                  JOptionPane.showMessageDialog(null," HyperlinkEvent " + e.getURL() );
               
            }
         }
      });
      
      jMenuItemUndo.setAccelerator( javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_Z, KeyEvent.CTRL_DOWN_MASK));
      jMenuItemRedo.setAccelerator( javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_Y, KeyEvent.CTRL_DOWN_MASK));
      jCheckBoxMenuItemEMM.setAccelerator( javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_M, KeyEvent.CTRL_DOWN_MASK));
      jMenuItemCut.setAccelerator( javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_X, KeyEvent.CTRL_DOWN_MASK));
      jMenuItemCopy.setAccelerator( javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_C, KeyEvent.CTRL_DOWN_MASK));
      jMenuItemPaste.setAccelerator( javax.swing.KeyStroke.getKeyStroke(KeyEvent.VK_V, KeyEvent.CTRL_DOWN_MASK));
      
      clipboards = new Vector[5];
      for (int i=0; i<5; ++i)
      {
         clipboards[i] = new Vector();
      }
      this.setReportViewer(this.getReportViewer());
      this.disableSaveAllSpecific();
      this.disableSaveSpecific();
      logOnConsole("iReport home (ireport.home system property): "+this.getHomeDirectory()+"\n");
      logOnConsole("iReport default compile directory: " + this.getDefaultCompilationDirectory()+"\n");
      logOnConsole("iReport user home directory: iReport compiles here if there are no settings or " +
                   "the user hasn't selected to compile to the report directory: " + IREPORT_DEFAULT_HOME_DIR + "\n");
   }
   
   /**
    * Retrive the first unused mane like untitled_report_XXX
    */
   public String getFirstNameFree()
   {
      JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
      
      for (int k=1; ; k++)
      {
         String name = "untitled_report_" + k;
         boolean found = false;
         for (int i=0; i<frames.length ; ++i)
         {
            if (frames[i] instanceof JReportFrame)
            {
               JReportFrame jrf = (JReportFrame)frames[i];
               if (jrf.getReport().getName().equalsIgnoreCase(name))
               {
                  found = true;
                  break;
               }
            }
         }
         if (!found)
         {
            return name;
         }
      }
   }
   
   
   public void setFileListActivatedFrame(JReportFrame jrf)
   {
      // remove the frame from the documnets list....
      DefaultTreeModel dtm = (DefaultTreeModel)jTreeFiles.getModel();
      Enumeration opened_entries = ((DefaultMutableTreeNode)dtm.getRoot()).children();
      while (opened_entries.hasMoreElements())
      {
         DefaultMutableTreeNode documentEntryNode = (DefaultMutableTreeNode)opened_entries.nextElement();
         if (documentEntryNode.getUserObject() instanceof DocumentTreeEntry)
         {
            DocumentTreeEntry dte = (DocumentTreeEntry)documentEntryNode.getUserObject();
            if (dte.getJrf() == jrf)
            {
               jTreeFiles.setSelectionPath(new TreePath(new Object[]
               {dtm.getRoot(), documentEntryNode}));
               jTreeFiles.updateUI();
               break;
            }
         }
         
      }
   }
   
   public void updateMenuWindowList()
   {
      // Remove all menus...
      java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
      int i = 0;
      for (int k = 0;  k<menus.length ; ++k)
      {
         if ((menus[k] instanceof JRadioButtonMenuItemMDIFrame) &&
         ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() != null &&
         ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().isValid() &&
         ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().isVisible())
         {
            JRadioButtonMenuItemMDIFrame menuItem = (JRadioButtonMenuItemMDIFrame)menus[k];
            menuItem.setText( (i+1) + ". " + menuItem.getFrame().getTitle() );
            menuItem.setMnemonic((int)(((i+1)+"").charAt(0)) );
            menuItem.setFont(new java.awt.Font("Dialog", 0, 11));
            menuItem.setAccelerator( javax.swing.KeyStroke.getKeyStroke((int)(((i+1)+"").charAt(0)),java.awt.Event.META_MASK));
            i++;
            //System.out.println("Menu "+menuItem.getText());
         }
      }
      
   }
   
   
   public void jMenuWindowListActionPerformed(java.awt.event.ActionEvent evt)
   {
      if (evt.getSource() != null &&
      evt.getSource() instanceof JRadioButtonMenuItemMDIFrame)
      {
         JRadioButtonMenuItemMDIFrame mdm = (JRadioButtonMenuItemMDIFrame)evt.getSource();
         try
         {
            
            mdm.getFrame().setSelected(true);
         } catch (Exception ex)
         {}
      }
      
   }
   
   public void jMDIDesktopPaneInternalFrameActivated(InternalFrameActivatedEvent evt)
   {
      if (evt.getJMDIFrame() != null && evt.getAction() == InternalFrameActivatedEvent.CLOSED)
      {
         // remove the frame from the documnets list....
         DefaultTreeModel dtm = (DefaultTreeModel)jTreeFiles.getModel();
         Enumeration opened_entries = ((DefaultMutableTreeNode)dtm.getRoot()).children();
         while (opened_entries.hasMoreElements())
         {
            DefaultMutableTreeNode documentEntryNode = (DefaultMutableTreeNode)opened_entries.nextElement();
            if (documentEntryNode.getUserObject() instanceof DocumentTreeEntry)
            {
               DocumentTreeEntry dte = (DocumentTreeEntry)documentEntryNode.getUserObject();
               if (dte.getJrf() == evt.getJMDIFrame())
               {
                  ((DefaultMutableTreeNode)dtm.getRoot()).remove(documentEntryNode);
                  jTreeFiles.updateUI();
                  
                  break;
               }
            }
            
         }
         // Remove from window list...
         java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
         for (int k = menus.length-1;  k>=0 ; --k)
         {
            if (menus[k] instanceof JRadioButtonMenuItemMDIFrame &&
            ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == evt.getJMDIFrame())
            {
               this.jMenuWindow.remove(menus[k]);
            }
         }
         updateMenuWindowList();
         return;
      }
      
      if (evt.getJMDIFrame() == null)
      {
         this.setTitle(constTitle);
         setActiveReportForm( null );
         return;
      }
      
      
      this.setTitle(constTitle + " ["+ evt.getJMDIFrame().getTitle() + "]");
      jMDIMenuBar.restoreButtonsPosition();
      //System.out.println("Value setted!");
      if (evt.getJMDIFrame() instanceof JReportFrame)
      {
         
         JReportFrame jrf = (JReportFrame)evt.getJMDIFrame();
         this.jNumberComboBoxZoom.setValue(jrf.getZoomFactor()*100);
         // Set the fit to page value...
         setFileListActivatedFrame(jrf);
         updateFitToPage(jrf);
         
         // Enable all buttons and menus...
         setActiveReportForm( jrf );
         
      }
      else
      {
         //System.out.println("Chiusetutte lengthfinestre!");
         setActiveReportForm( null );
      }
   }
   
   private void setActiveReportForm(JReportFrame jrf)
   {
      boolean enabled = true;
      if (jrf == null)
      {
         enabled = false;
      }
      else
      {
         this.setTitle(constTitle + " ["+ jrf.getReport().getName() + " "+ jrf.getReport().getWidth()+"x"+jrf.getReport().getHeight()+" "+jrf.getReport().getFilename()+" ]");
      }
      
      if (jrf != null)
      {
         java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
         for (int k = menus.length-1;  k>=0 ; --k)
         {
            if (menus[k] instanceof JRadioButtonMenuItemMDIFrame &&
            ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jrf)
            {
               ((JRadioButtonMenuItemMDIFrame)menus[k]).setSelected(true);
            }
         }
      }
      
      
      
      this.elementPropertiesDialog.setJReportFrame(jrf);
      this.valuesDialog.setJReportFrame(jrf);
      this.groupsDialog.setJReportFrame(jrf);
      this.bandsDialog.setJReportFrame(jrf);
      this.fontsDialog.setJReportFrame(jrf);
      this.reportQueryDialog.setJReportFrame(jrf);
      
      updateDocumentStructureTree( jrf);
      updateUndoMenu(jrf);
      updateCutAndPasteMenu(jrf);
      // Toolbar...
      this.jButtonBands.setEnabled(enabled);
      this.jButtonDatabase.setEnabled(enabled);
      this.jButtonParameters.setEnabled(enabled);
      this.jButtonGroups.setEnabled(enabled);
      this.jButtonCompiler.setEnabled(enabled);
      this.jButtonRun1.setEnabled(enabled);
      this.jButtonRun2.setEnabled(enabled);
      this.jButtonAlignLeft.setEnabled(enabled);
      this.jButtonAlignCenter.setEnabled(enabled);
      this.jButtonAlignRight.setEnabled(enabled);
      this.jButtonAlignJustify.setEnabled(enabled);
      
      this.jToggleButtonEllipseTool.setEnabled(enabled);
      this.jToggleButtonImageTool.setEnabled(enabled);
      this.jToggleButtonLineTool.setEnabled(enabled);
      
      this.jToggleButtonPointer.setEnabled(enabled);
      this.jToggleButtonRectRoundTool.setEnabled(enabled);
      this.jToggleButtonRectTool.setEnabled(enabled);
      this.jButtonSave.setEnabled(enabled);
      this.jToggleButtonStaticTextTool.setEnabled(enabled);
      this.jToggleButtonSubreportTool.setEnabled(enabled);
      this.jToggleButtonChartTool.setEnabled(enabled);
      this.jToggleButtonTextFieldTool.setEnabled(enabled);
      this.jMenuItemXMLSource.setEnabled(enabled);
      this.jCheckBoxMenuItemEMM.setEnabled(enabled);
      this.jCheckBoxMenuItemGrid.setEnabled(enabled);
      this.jCheckBoxMenuItemSnapToGrid.setEnabled(enabled);
      this.jMenuAdd.setEnabled(true);
      
      this.jMenuItemBands.setEnabled(enabled);
      this.jMenuItemGroups.setEnabled(enabled);
      this.jMenuItemReportProperties.setEnabled(enabled);
      this.jMenuItemElementProperties.setEnabled(enabled);
      this.jMenuItemFields.setEnabled(enabled);
      this.jMenuItemVariables.setEnabled(enabled);
      this.jMenuItemParameters.setEnabled(enabled);
      this.jMenuItemReportQuery.setEnabled(enabled);
      this.jMenuItemReportQuery2.setEnabled(enabled);
      this.jMenuItemFonts.setEnabled(enabled);
      
      jMDIDesktopPane.setPreferredSize(new java.awt.Dimension(100,10));
      jMDIDesktopPane.setMinimumSize(new java.awt.Dimension(100,10));
      //jMDIDesktopPane.setPreferredSize(new Dimension(100,100));
      setActiveTool(this.jToggleButtonPointer);
      if (!enabled)  this.jToggleButtonPointer.setSelected(false);
      if(jrf != null)
      {
         Report r = jrf.getReport();
         if( r.isModified() )
         {
            this.enableSaveSpecific();
            this.enableSaveAllSpecific();
         }//end if report modified
         else
         {
            this.disableSaveSpecific();
            if( this.isSaveAllRequired() )
            {
               this.enableSaveAllSpecific();
            }
            else
            {
               this.disableSaveAllSpecific();
            }
         }//end else report modified
      }//end if jrf is null
   }//end setActiveReportForm
   
   public void updateDocumentStructureTree(JReportFrame jrf)
   {
      // Update the document tree structure...
      ((DefaultMutableTreeNode)this.jTreeDocument.getModel().getRoot()).removeAllChildren();
      
      if (jrf != null)
      {
         this.setDontHandleEvent(true);
         
         Enumeration bands = jrf.getReport().getBands().elements();
         while (bands.hasMoreElements())
         {
            Band band = (Band)bands.nextElement();
            DefaultMutableTreeNode bandNode = new DefaultMutableTreeNode(band);
            Enumeration elements = jrf.getReport().getElements().elements();
            while (elements.hasMoreElements())
            {
               ReportElement element = (ReportElement)elements.nextElement();
               if (element.getBand() == band)
                  bandNode.add( new DefaultMutableTreeNode(element));
            }
            
            ((DefaultMutableTreeNode)this.jTreeDocument.getModel().getRoot()).add( bandNode);
         }
         
         this.setDontHandleEvent(false);
         reportElementsSelectionChanged(new ReportElementsSelectionEvent(jrf,  jrf.getSelectedElements()));
      }
      
      
      
      jTreeDocument.updateUI();
   }
   
   public boolean isEMMActive()
   {
      return this.jCheckBoxMenuItemEMM.isSelected();
   }
   
   public void setActiveTool( int tool )
   {
      if (tool == 0)
         setActiveTool(this.jToggleButtonPointer);
   }
   private void setActiveTool( java.awt.Component tool )
   {
      try
      {
         this.jToggleButtonEllipseTool.setSelected(  (tool ==this.jToggleButtonEllipseTool) );
         this.jToggleButtonImageTool.setSelected(  (tool ==this.jToggleButtonImageTool) );
         this.jToggleButtonLineTool.setSelected(  (tool ==this.jToggleButtonLineTool) );
         this.jToggleButtonPointer.setSelected(  (tool ==this.jToggleButtonPointer) );
         this.jToggleButtonRectRoundTool.setSelected(  (tool ==this.jToggleButtonRectRoundTool) );
         this.jToggleButtonRectTool.setSelected(  (tool ==this.jToggleButtonRectTool) );
         this.jToggleButtonStaticTextTool.setSelected(  (tool ==this.jToggleButtonStaticTextTool) );
         this.jToggleButtonSubreportTool.setSelected(  (tool ==this.jToggleButtonSubreportTool) );
         this.jToggleButtonChartTool.setSelected(  (tool ==this.jToggleButtonChartTool) );
         this.jToggleButtonTextFieldTool.setSelected(  (tool ==this.jToggleButtonTextFieldTool) );
      } catch (Exception ex)
      {}
   }
   
   public void updateFitToPage(JReportFrame jrf)
   {
      int w = jrf.getReport().getWidth();
      double s = (jrf.getReportPanel().getWidth()-20)/(double)w;
      jNumberComboBoxZoom.addEntry("Fit to page", s*100);
   }
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      buttonGroupExportType = new javax.swing.ButtonGroup();
      buttonGroupFramesList = new javax.swing.ButtonGroup();
      jPanelToolBar = new javax.swing.JPanel();
      jPanelZoom = new javax.swing.JPanel();
      jNumberComboBoxZoom = new it.businesslogic.ireport.gui.JNumberComboBox();
      jButtonNew = new javax.swing.JButton();
      jButtonOpen = new javax.swing.JButton();
      jButtonSave = new javax.swing.JButton();
      jButtonCut = new javax.swing.JButton();
      jButtonCopy = new javax.swing.JButton();
      jButtonPaste = new javax.swing.JButton();
      jToggleButtonPointer = new javax.swing.JToggleButton();
      jToggleButtonLineTool = new javax.swing.JToggleButton();
      jToggleButtonRectTool = new javax.swing.JToggleButton();
      jToggleButtonRectRoundTool = new javax.swing.JToggleButton();
      jToggleButtonEllipseTool = new javax.swing.JToggleButton();
      jToggleButtonImageTool = new javax.swing.JToggleButton();
      jToggleButtonStaticTextTool = new javax.swing.JToggleButton();
      jToggleButtonTextFieldTool = new javax.swing.JToggleButton();
      jToggleButtonSubreportTool = new javax.swing.JToggleButton();
      jButtonBands = new javax.swing.JButton();
      jButtonGroups = new javax.swing.JButton();
      jButtonParameters = new javax.swing.JButton();
      jButtonDatabase = new javax.swing.JButton();
      jButtonAlignLeft = new javax.swing.JButton();
      jButtonAlignCenter = new javax.swing.JButton();
      jButtonAlignRight = new javax.swing.JButton();
      jButtonAlignJustify = new javax.swing.JButton();
      jButtonCompiler = new javax.swing.JButton();
      jButtonRun1 = new javax.swing.JButton();
      jButtonRun2 = new javax.swing.JButton();
      jToggleButtonChartTool = new javax.swing.JToggleButton();
      jSplitPaneV = new javax.swing.JSplitPane();
      jPanelMaster = new javax.swing.JPanel();
      jSplitPaneHorizontal = new javax.swing.JSplitPane();
      jMDIDesktopPane = new it.businesslogic.ireport.gui.JMDIDesktopPane();
      jTabbedPaneExplorer = new javax.swing.JTabbedPane();
      jPanelFiles = new javax.swing.JPanel();
      jScrollPaneFiles = new javax.swing.JScrollPane();
      jTreeFiles = new javax.swing.JTree();
      jPanelDocumentStructure = new javax.swing.JPanel();
      jScrollPane1 = new javax.swing.JScrollPane();
      jTreeDocument = new javax.swing.JTree();
      jPanelSouth = new javax.swing.JPanel();
      jScrollPaneOutput = new javax.swing.JScrollPane();
      jEditorPaneOutput = new javax.swing.JEditorPane();
      jPanelProcesses = new javax.swing.JPanel();
      jTabbedPane1 = new javax.swing.JTabbedPane();
      jScrollProcesses = new javax.swing.JScrollPane();
      jListThreads = new javax.swing.JList();
      jMDIMenuBar = new it.businesslogic.ireport.gui.JMDIMenuBar();
      jMenuFile = new javax.swing.JMenu();
      jMenuItemNewDocument = new javax.swing.JMenuItem();
      jMenuItemWizard = new javax.swing.JMenuItem();
      jMenuItemOpen = new javax.swing.JMenuItem();
      jMenuItemQOpen = new javax.swing.JMenuItem();
      jSeparator16 = new javax.swing.JSeparator();
      jMenuItemSave = new javax.swing.JMenuItem();
      jMenuItemSaveAs = new javax.swing.JMenuItem();
      jMenuItemSaveAll = new javax.swing.JMenuItem();
      jSeparator3 = new javax.swing.JSeparator();
      jMenuRecentFiles = new javax.swing.JMenu();
      jMenuRecentProjects = new javax.swing.JMenu();
      jMenuItemFavorites = new javax.swing.JMenuItem();
      jSeparator15 = new javax.swing.JSeparator();
      jMenuItemQuit = new javax.swing.JMenuItem();
      jMenuEdit = new javax.swing.JMenu();
      jMenuItemUndo = new javax.swing.JMenuItem();
      jMenuItemRedo = new javax.swing.JMenuItem();
      jSeparator1 = new javax.swing.JSeparator();
      jMenuItemCut = new javax.swing.JMenuItem();
      jMenuItemCopy = new javax.swing.JMenuItem();
      jMenuItemPaste = new javax.swing.JMenuItem();
      jMenuItemDelete = new javax.swing.JMenuItem();
      jSeparator2 = new javax.swing.JSeparator();
      jCheckBoxMenuItemEMM = new javax.swing.JCheckBoxMenuItem();
      jCheckBoxMenuItemSnapToGrid = new javax.swing.JCheckBoxMenuItem();
      jMenuAdd = new javax.swing.JMenu();
      jMenuItemNullElement = new javax.swing.JMenuItem();
      jMenuItemLine = new javax.swing.JMenuItem();
      jMenuItemRectangle = new javax.swing.JMenuItem();
      jMenuItemRoundRectangle = new javax.swing.JMenuItem();
      jMenuItemEllipse = new javax.swing.JMenuItem();
      jMenuItemStaticText = new javax.swing.JMenuItem();
      jMenuItemTextField = new javax.swing.JMenuItem();
      jMenuItemSubreport = new javax.swing.JMenuItem();
      jMenuItemXMLSource = new javax.swing.JMenuItem();
      jMenuItem1 = new javax.swing.JMenuItem();
      jMenuView = new javax.swing.JMenu();
      jCheckBoxMenuItemGrid = new javax.swing.JCheckBoxMenuItem();
      jSeparator4 = new javax.swing.JSeparator();
      jCheckBoxMenuItemOutput = new javax.swing.JCheckBoxMenuItem();
      jCheckBoxMenuItemExplorer = new javax.swing.JCheckBoxMenuItem();
      jSeparator12 = new javax.swing.JSeparator();
      jMenuItemReportProperties = new javax.swing.JMenuItem();
      jMenuItemReportQuery = new javax.swing.JMenuItem();
      jMenuItemFields = new javax.swing.JMenuItem();
      jMenuItemVariables = new javax.swing.JMenuItem();
      jMenuItemParameters = new javax.swing.JMenuItem();
      jMenuItemFonts = new javax.swing.JMenuItem();
      jSeparator6 = new javax.swing.JSeparator();
      jMenuItemBands = new javax.swing.JMenuItem();
      jMenuItemGroups = new javax.swing.JMenuItem();
      jSeparator7 = new javax.swing.JSeparator();
      jMenuItemElementProperties = new javax.swing.JMenuItem();
      jMenuItemElementsBrowser = new javax.swing.JMenuItem();
      jMenuSearch = new javax.swing.JMenu();
      jMenuItemFind = new javax.swing.JMenuItem();
      jMenuItemFindNext = new javax.swing.JMenuItem();
      jMenuItemFindPrev = new javax.swing.JMenuItem();
      jMenuItemReplace = new javax.swing.JMenuItem();
      jMenuProjects = new javax.swing.JMenu();
      jMenuItemNewProject = new javax.swing.JMenuItem();
      jMenuItemOpenProject = new javax.swing.JMenuItem();
      jMenuItemCloseProject = new javax.swing.JMenuItem();
      jSeparator13 = new javax.swing.JSeparator();
      jMenuItemAddFileToProject = new javax.swing.JMenuItem();
      jMenuItemProjectOptions = new javax.swing.JMenuItem();
      jMenuBuild = new javax.swing.JMenu();
      jMenuItemCompile = new javax.swing.JMenuItem();
      jMenuItemCompileAll = new javax.swing.JMenuItem();
      jSeparator10 = new javax.swing.JSeparator();
      jMenuItemExecute = new javax.swing.JMenuItem();
      jMenuItemExecuteDB = new javax.swing.JMenuItem();
      jSeparator11 = new javax.swing.JSeparator();
      jRadioButtonMenuItemPreviewPDF = new javax.swing.JRadioButtonMenuItem();
      jRadioButtonMenuItemPreviewHTML = new javax.swing.JRadioButtonMenuItem();
      jRadioButtonMenuItemPreviewJAVA = new javax.swing.JRadioButtonMenuItem();
      jRadioButtonMenuItemPreviewXLS = new javax.swing.JRadioButtonMenuItem();
      jRadioButtonMenuItemPreviewCSV = new javax.swing.JRadioButtonMenuItem();
      jRadioButtonMenuItemPreviewInternalViewer = new javax.swing.JRadioButtonMenuItem();
      jSeparator14 = new javax.swing.JSeparator();
      jMenuItemActiveConnection = new javax.swing.JMenuItem();
      jMenuFormat = new javax.swing.JMenu();
      jMenuAlign = new javax.swing.JMenu();
      jMenuItemAlignLeft = new javax.swing.JMenuItem();
      jMenuItemAlignRight = new javax.swing.JMenuItem();
      jMenuItemAlignTop = new javax.swing.JMenuItem();
      jMenuItemAlignBottom = new javax.swing.JMenuItem();
      jSeparator19 = new javax.swing.JSeparator();
      jMenuItemAlignVerticalAxis = new javax.swing.JMenuItem();
      jMenuItemAlignHorizontalAxis = new javax.swing.JMenuItem();
      jSeparator20 = new javax.swing.JSeparator();
      jMenuItemAlignToBandTop = new javax.swing.JMenuItem();
      jMenuItemAlignToBandBottom = new javax.swing.JMenuItem();
      jMenuSize = new javax.swing.JMenu();
      jMenuItemSameWidth = new javax.swing.JMenuItem();
      jMenuItemSameWidthMax = new javax.swing.JMenuItem();
      jMenuItemSameWidthMin = new javax.swing.JMenuItem();
      jSeparator17 = new javax.swing.JSeparator();
      jMenuItemSameHeight = new javax.swing.JMenuItem();
      jMenuItemSameHeightMin = new javax.swing.JMenuItem();
      jMenuItemSameHeightMax = new javax.swing.JMenuItem();
      jSeparator18 = new javax.swing.JSeparator();
      jMenuItemSameSize = new javax.swing.JMenuItem();
      jMenuPosition = new javax.swing.JMenu();
      jMenuItemCenterH = new javax.swing.JMenuItem();
      jMenuItemCenterV = new javax.swing.JMenuItem();
      jMenuItemCenterInBand = new javax.swing.JMenuItem();
      jMenuItemCenterBackground = new javax.swing.JMenuItem();
      jMenuItemJoinLeft = new javax.swing.JMenuItem();
      jMenuItemJoinRight = new javax.swing.JMenuItem();
      jSeparator5 = new javax.swing.JSeparator();
      jMenuHSpacing = new javax.swing.JMenu();
      jMenuItemHSMakeEqual = new javax.swing.JMenuItem();
      jMenuItemHSIncrease = new javax.swing.JMenuItem();
      jMenuItemHSDecrease = new javax.swing.JMenuItem();
      jMenuItemHSRemove = new javax.swing.JMenuItem();
      jMenuVSpacing = new javax.swing.JMenu();
      jMenuItemVSMakeEqual = new javax.swing.JMenuItem();
      jMenuItemVSIncrease = new javax.swing.JMenuItem();
      jMenuItemVSDecrease = new javax.swing.JMenuItem();
      jMenuItemVSRemove = new javax.swing.JMenuItem();
      jSeparator8 = new javax.swing.JSeparator();
      jMenuItemBringToFront = new javax.swing.JMenuItem();
      jMenuItemSendToBack = new javax.swing.JMenuItem();
      jMenuDatabase = new javax.swing.JMenu();
      jMenuItemConnections = new javax.swing.JMenuItem();
      jSeparator9 = new javax.swing.JSeparator();
      jMenuItemReportQuery2 = new javax.swing.JMenuItem();
      jMenuTools = new javax.swing.JMenu();
      jMenuItemOptions = new javax.swing.JMenuItem();
      jMenuItemCompatibility = new javax.swing.JMenuItem();
      jMenuWindow = new javax.swing.JMenu();
      jMenuItemCascade = new javax.swing.JMenuItem();
      jMenuItemTileHorizontal = new javax.swing.JMenuItem();
      jMenuItemTileVertical = new javax.swing.JMenuItem();
      jMenuItemtileAnodine = new javax.swing.JMenuItem();
      jMenuItemNextWin = new javax.swing.JMenuItem();
      jMenuItemPrevWin = new javax.swing.JMenuItem();
      jSeparator21 = new javax.swing.JSeparator();
      jMenuHelp = new javax.swing.JMenu();
      jMenuItemHelp = new javax.swing.JMenuItem();
      jMenuItemAbout = new javax.swing.JMenuItem();

      FormListener formListener = new FormListener();

      setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
      setTitle("iReport 0.0.9");
      setIconImage(getIconImage());
      addWindowListener(formListener);

      jPanelToolBar.setLayout(null);

      jPanelToolBar.setMaximumSize(new java.awt.Dimension(32000, 32000));
      jPanelToolBar.setMinimumSize(new java.awt.Dimension(36, 500));
      jPanelToolBar.setPreferredSize(new java.awt.Dimension(200, 36));
      jPanelToolBar.addComponentListener(formListener);

      jPanelZoom.setLayout(null);

      jPanelZoom.setBorder(new javax.swing.border.EtchedBorder());
      jNumberComboBoxZoom.setPostfix("%");
      jPanelZoom.add(jNumberComboBoxZoom);
      jNumberComboBoxZoom.setBounds(4, 4, 82, 24);

      jPanelToolBar.add(jPanelZoom);
      jPanelZoom.setBounds(400, 0, 90, 32);

      jButtonNew.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/new1.jpg")));
      jButtonNew.setToolTipText("New report");
      jButtonNew.setBorder(null);
      jButtonNew.setBorderPainted(false);
      jButtonNew.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/new2.jpg")));
      jButtonNew.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/new3.jpg")));
      jButtonNew.setSelectedIcon(new javax.swing.ImageIcon(""));
      jButtonNew.addActionListener(formListener);

      jPanelToolBar.add(jButtonNew);
      jButtonNew.setBounds(0, 0, 32, 32);

      jButtonOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/open1.jpg")));
      jButtonOpen.setToolTipText("Open report");
      jButtonOpen.setBorder(null);
      jButtonOpen.setBorderPainted(false);
      jButtonOpen.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/open2.jpg")));
      jButtonOpen.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/open3.jpg")));
      jButtonOpen.addActionListener(formListener);

      jPanelToolBar.add(jButtonOpen);
      jButtonOpen.setBounds(50, 0, 32, 32);

      jButtonSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/save1.jpg")));
      jButtonSave.setToolTipText("Save report");
      jButtonSave.setBorder(null);
      jButtonSave.setBorderPainted(false);
      jButtonSave.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/save2.jpg")));
      jButtonSave.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/save3.jpg")));
      jButtonSave.setEnabled(false);
      jButtonSave.addActionListener(formListener);

      jPanelToolBar.add(jButtonSave);
      jButtonSave.setBounds(40, 0, 32, 32);

      jButtonCut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/cut1.jpg")));
      jButtonCut.setToolTipText("Cut");
      jButtonCut.setBorder(null);
      jButtonCut.setBorderPainted(false);
      jButtonCut.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/cut2.jpg")));
      jButtonCut.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/cut3.jpg")));
      jButtonCut.setEnabled(false);
      jButtonCut.addActionListener(formListener);

      jPanelToolBar.add(jButtonCut);
      jButtonCut.setBounds(50, 0, 32, 32);

      jButtonCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/copy1.jpg")));
      jButtonCopy.setToolTipText("Copy");
      jButtonCopy.setBorder(null);
      jButtonCopy.setBorderPainted(false);
      jButtonCopy.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/copy2.jpg")));
      jButtonCopy.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/copy3.jpg")));
      jButtonCopy.setEnabled(false);
      jButtonCopy.addActionListener(formListener);

      jPanelToolBar.add(jButtonCopy);
      jButtonCopy.setBounds(0, 0, 32, 32);

      jButtonPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/paste1.jpg")));
      jButtonPaste.setToolTipText("Paste");
      jButtonPaste.setBorder(null);
      jButtonPaste.setBorderPainted(false);
      jButtonPaste.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/paste2.jpg")));
      jButtonPaste.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/paste3.jpg")));
      jButtonPaste.setEnabled(false);
      jButtonPaste.addActionListener(formListener);

      jPanelToolBar.add(jButtonPaste);
      jButtonPaste.setBounds(80, 0, 32, 32);

      jToggleButtonPointer.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer1.jpg")));
      jToggleButtonPointer.setToolTipText("Pointer");
      jToggleButtonPointer.setBorder(null);
      jToggleButtonPointer.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer2.jpg")));
      jToggleButtonPointer.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer3.jpg")));
      jToggleButtonPointer.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/pointer3.jpg")));
      jToggleButtonPointer.setEnabled(false);
      jToggleButtonPointer.addActionListener(formListener);
      jToggleButtonPointer.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonPointer);
      jToggleButtonPointer.setBounds(100, 0, 32, 32);

      jToggleButtonLineTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool1.jpg")));
      jToggleButtonLineTool.setToolTipText("Line tool");
      jToggleButtonLineTool.setBorder(null);
      jToggleButtonLineTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool2.jpg")));
      jToggleButtonLineTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool3.jpg")));
      jToggleButtonLineTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/lineTool3.jpg")));
      jToggleButtonLineTool.setEnabled(false);
      jToggleButtonLineTool.addActionListener(formListener);
      jToggleButtonLineTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonLineTool);
      jToggleButtonLineTool.setBounds(100, 0, 32, 32);

      jToggleButtonRectTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool1.jpg")));
      jToggleButtonRectTool.setToolTipText("Rectangle tool");
      jToggleButtonRectTool.setBorder(null);
      jToggleButtonRectTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool2.jpg")));
      jToggleButtonRectTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool3.jpg")));
      jToggleButtonRectTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rectTool3.jpg")));
      jToggleButtonRectTool.setEnabled(false);
      jToggleButtonRectTool.addActionListener(formListener);
      jToggleButtonRectTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonRectTool);
      jToggleButtonRectTool.setBounds(110, 0, 32, 32);

      jToggleButtonRectRoundTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool1.jpg")));
      jToggleButtonRectRoundTool.setToolTipText("Round rectangle tool");
      jToggleButtonRectRoundTool.setBorder(null);
      jToggleButtonRectRoundTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool2.jpg")));
      jToggleButtonRectRoundTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool3.jpg")));
      jToggleButtonRectRoundTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/roundRectTool3.jpg")));
      jToggleButtonRectRoundTool.setEnabled(false);
      jToggleButtonRectRoundTool.addActionListener(formListener);
      jToggleButtonRectRoundTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonRectRoundTool);
      jToggleButtonRectRoundTool.setBounds(110, 0, 32, 32);

      jToggleButtonEllipseTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool1.jpg")));
      jToggleButtonEllipseTool.setToolTipText("Ellipse tool");
      jToggleButtonEllipseTool.setBorder(null);
      jToggleButtonEllipseTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool2.jpg")));
      jToggleButtonEllipseTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool3.jpg")));
      jToggleButtonEllipseTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/ellipseTool3.jpg")));
      jToggleButtonEllipseTool.setEnabled(false);
      jToggleButtonEllipseTool.addActionListener(formListener);
      jToggleButtonEllipseTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonEllipseTool);
      jToggleButtonEllipseTool.setBounds(110, 0, 32, 32);

      jToggleButtonImageTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool1.jpg")));
      jToggleButtonImageTool.setToolTipText("Image tool");
      jToggleButtonImageTool.setBorder(null);
      jToggleButtonImageTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool2.jpg")));
      jToggleButtonImageTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool3.jpg")));
      jToggleButtonImageTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/imageTool3.jpg")));
      jToggleButtonImageTool.setEnabled(false);
      jToggleButtonImageTool.addActionListener(formListener);
      jToggleButtonImageTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonImageTool);
      jToggleButtonImageTool.setBounds(110, 0, 32, 32);

      jToggleButtonStaticTextTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool1.jpg")));
      jToggleButtonStaticTextTool.setToolTipText("Static text tool");
      jToggleButtonStaticTextTool.setBorder(null);
      jToggleButtonStaticTextTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool2.jpg")));
      jToggleButtonStaticTextTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool3.jpg")));
      jToggleButtonStaticTextTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/textTool3.jpg")));
      jToggleButtonStaticTextTool.setEnabled(false);
      jToggleButtonStaticTextTool.addActionListener(formListener);
      jToggleButtonStaticTextTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonStaticTextTool);
      jToggleButtonStaticTextTool.setBounds(110, 0, 32, 32);

      jToggleButtonTextFieldTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool1.jpg")));
      jToggleButtonTextFieldTool.setToolTipText("Textfield tool");
      jToggleButtonTextFieldTool.setBorder(null);
      jToggleButtonTextFieldTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool2.jpg")));
      jToggleButtonTextFieldTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool3.jpg")));
      jToggleButtonTextFieldTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/fieldTool3.jpg")));
      jToggleButtonTextFieldTool.setEnabled(false);
      jToggleButtonTextFieldTool.addActionListener(formListener);
      jToggleButtonTextFieldTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonTextFieldTool);
      jToggleButtonTextFieldTool.setBounds(110, 0, 32, 32);

      jToggleButtonSubreportTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool1.jpg")));
      jToggleButtonSubreportTool.setToolTipText("Subreport tool");
      jToggleButtonSubreportTool.setBorder(null);
      jToggleButtonSubreportTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool2.jpg")));
      jToggleButtonSubreportTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool3.jpg")));
      jToggleButtonSubreportTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/subreportTool3.jpg")));
      jToggleButtonSubreportTool.setEnabled(false);
      jToggleButtonSubreportTool.addActionListener(formListener);
      jToggleButtonSubreportTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonSubreportTool);
      jToggleButtonSubreportTool.setBounds(110, 0, 32, 32);

      jButtonBands.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/bands1.jpg")));
      jButtonBands.setToolTipText("Bands");
      jButtonBands.setBorder(null);
      jButtonBands.setBorderPainted(false);
      jButtonBands.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/bands2.jpg")));
      jButtonBands.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/bands3.jpg")));
      jButtonBands.setEnabled(false);
      jButtonBands.addActionListener(formListener);

      jPanelToolBar.add(jButtonBands);
      jButtonBands.setBounds(0, 0, 32, 32);

      jButtonGroups.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/groups1.jpg")));
      jButtonGroups.setToolTipText("Groups");
      jButtonGroups.setBorder(null);
      jButtonGroups.setBorderPainted(false);
      jButtonGroups.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/groups2.jpg")));
      jButtonGroups.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/groups3.jpg")));
      jButtonGroups.setEnabled(false);
      jButtonGroups.addActionListener(formListener);

      jPanelToolBar.add(jButtonGroups);
      jButtonGroups.setBounds(0, 0, 32, 32);

      jButtonParameters.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/parameters1.jpg")));
      jButtonParameters.setToolTipText("Parameters");
      jButtonParameters.setBorder(null);
      jButtonParameters.setBorderPainted(false);
      jButtonParameters.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/parameters2.jpg")));
      jButtonParameters.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/parameters3.jpg")));
      jButtonParameters.setEnabled(false);
      jButtonParameters.addActionListener(formListener);

      jPanelToolBar.add(jButtonParameters);
      jButtonParameters.setBounds(0, 0, 32, 32);

      jButtonDatabase.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/database1.jpg")));
      jButtonDatabase.setToolTipText("Database");
      jButtonDatabase.setBorder(null);
      jButtonDatabase.setBorderPainted(false);
      jButtonDatabase.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/database2.jpg")));
      jButtonDatabase.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/database3.jpg")));
      jButtonDatabase.setEnabled(false);
      jButtonDatabase.addActionListener(formListener);

      jPanelToolBar.add(jButtonDatabase);
      jButtonDatabase.setBounds(0, 0, 32, 32);

      jButtonAlignLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignLeft1.jpg")));
      jButtonAlignLeft.setToolTipText("Align left");
      jButtonAlignLeft.setBorder(null);
      jButtonAlignLeft.setBorderPainted(false);
      jButtonAlignLeft.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignLeft2.jpg")));
      jButtonAlignLeft.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignLeft3.jpg")));
      jButtonAlignLeft.setEnabled(false);
      jButtonAlignLeft.addActionListener(formListener);

      jPanelToolBar.add(jButtonAlignLeft);
      jButtonAlignLeft.setBounds(0, 0, 32, 32);

      jButtonAlignCenter.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignCenter1.jpg")));
      jButtonAlignCenter.setToolTipText("Align center");
      jButtonAlignCenter.setBorder(null);
      jButtonAlignCenter.setBorderPainted(false);
      jButtonAlignCenter.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignCenter2.jpg")));
      jButtonAlignCenter.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignCenter3.jpg")));
      jButtonAlignCenter.setEnabled(false);
      jButtonAlignCenter.addActionListener(formListener);

      jPanelToolBar.add(jButtonAlignCenter);
      jButtonAlignCenter.setBounds(0, 0, 32, 32);

      jButtonAlignRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignRight1.jpg")));
      jButtonAlignRight.setToolTipText("Align right");
      jButtonAlignRight.setBorder(null);
      jButtonAlignRight.setBorderPainted(false);
      jButtonAlignRight.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignRight2.jpg")));
      jButtonAlignRight.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignRight3.jpg")));
      jButtonAlignRight.setEnabled(false);
      jButtonAlignRight.addActionListener(formListener);

      jPanelToolBar.add(jButtonAlignRight);
      jButtonAlignRight.setBounds(0, 0, 32, 32);

      jButtonAlignJustify.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignJustify1.jpg")));
      jButtonAlignJustify.setToolTipText("Align justify");
      jButtonAlignJustify.setBorder(null);
      jButtonAlignJustify.setBorderPainted(false);
      jButtonAlignJustify.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignJustify2.jpg")));
      jButtonAlignJustify.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/alignJustify3.jpg")));
      jButtonAlignJustify.setEnabled(false);
      jButtonAlignJustify.addActionListener(formListener);

      jPanelToolBar.add(jButtonAlignJustify);
      jButtonAlignJustify.setBounds(0, 0, 32, 32);

      jButtonCompiler.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/comp1.jpg")));
      jButtonCompiler.setToolTipText("Compile the report");
      jButtonCompiler.setBorder(null);
      jButtonCompiler.setBorderPainted(false);
      jButtonCompiler.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/comp2.jpg")));
      jButtonCompiler.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/comp3.jpg")));
      jButtonCompiler.setEnabled(false);
      jButtonCompiler.addActionListener(formListener);

      jPanelToolBar.add(jButtonCompiler);
      jButtonCompiler.setBounds(0, 0, 32, 32);

      jButtonRun1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/run1.jpg")));
      jButtonRun1.setToolTipText("Run report using an empty datasource");
      jButtonRun1.setBorder(null);
      jButtonRun1.setBorderPainted(false);
      jButtonRun1.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/run2.jpg")));
      jButtonRun1.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/run3.jpg")));
      jButtonRun1.setEnabled(false);
      jButtonRun1.addActionListener(formListener);

      jPanelToolBar.add(jButtonRun1);
      jButtonRun1.setBounds(0, 0, 32, 32);

      jButtonRun2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rundb1.jpg")));
      jButtonRun2.setToolTipText("Run report using a connection");
      jButtonRun2.setBorder(null);
      jButtonRun2.setBorderPainted(false);
      jButtonRun2.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rundb2.jpg")));
      jButtonRun2.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/rundb3.jpg")));
      jButtonRun2.setEnabled(false);
      jButtonRun2.addActionListener(formListener);

      jPanelToolBar.add(jButtonRun2);
      jButtonRun2.setBounds(0, 0, 32, 32);

      jToggleButtonChartTool.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart1.jpg")));
      jToggleButtonChartTool.setToolTipText("Chart tool");
      jToggleButtonChartTool.setBorder(null);
      jToggleButtonChartTool.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart2.jpg")));
      jToggleButtonChartTool.setPressedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart3.jpg")));
      jToggleButtonChartTool.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/chart3.jpg")));
      jToggleButtonChartTool.setEnabled(false);
      jToggleButtonChartTool.addChangeListener(formListener);
      jToggleButtonChartTool.addItemListener(formListener);

      jPanelToolBar.add(jToggleButtonChartTool);
      jToggleButtonChartTool.setBounds(110, 0, 32, 32);

      getContentPane().add(jPanelToolBar, java.awt.BorderLayout.NORTH);

      jSplitPaneV.setDividerSize(8);
      jSplitPaneV.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
      jSplitPaneV.setResizeWeight(1.0);
      jSplitPaneV.setOneTouchExpandable(true);
      jPanelMaster.setLayout(new java.awt.BorderLayout());

      jPanelMaster.setMinimumSize(new java.awt.Dimension(750, 100));
      jPanelMaster.setPreferredSize(new java.awt.Dimension(750, 550));
      jSplitPaneHorizontal.setDividerSize(8);
      jSplitPaneHorizontal.setOneTouchExpandable(true);
      jSplitPaneHorizontal.setRightComponent(jMDIDesktopPane);

      jTabbedPaneExplorer.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
      jTabbedPaneExplorer.setFont(new java.awt.Font("Dialog", 0, 11));
      jTabbedPaneExplorer.setPreferredSize(new java.awt.Dimension(150, 10));
      jTabbedPaneExplorer.addChangeListener(formListener);

      jPanelFiles.setLayout(new java.awt.BorderLayout());

      jPanelFiles.setBackground(new java.awt.Color(255, 255, 255));
      jScrollPaneFiles.setBackground(new java.awt.Color(255, 255, 255));
      jScrollPaneFiles.setMinimumSize(new java.awt.Dimension(0, 0));
      jTreeFiles.addMouseListener(formListener);
      jTreeFiles.addTreeSelectionListener(formListener);

      jScrollPaneFiles.setViewportView(jTreeFiles);

      jPanelFiles.add(jScrollPaneFiles, java.awt.BorderLayout.CENTER);

      jTabbedPaneExplorer.addTab("Files", jPanelFiles);

      jPanelDocumentStructure.setLayout(new java.awt.BorderLayout());

      jPanelDocumentStructure.setBackground(new java.awt.Color(255, 255, 255));
      jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
      jTreeDocument.addTreeSelectionListener(formListener);

      jScrollPane1.setViewportView(jTreeDocument);

      jPanelDocumentStructure.add(jScrollPane1, java.awt.BorderLayout.CENTER);

      jTabbedPaneExplorer.addTab("Document structure", jPanelDocumentStructure);

      jSplitPaneHorizontal.setLeftComponent(jTabbedPaneExplorer);

      jPanelMaster.add(jSplitPaneHorizontal, java.awt.BorderLayout.CENTER);

      jSplitPaneV.setTopComponent(jPanelMaster);

      jPanelSouth.setLayout(new java.awt.BorderLayout());

      jScrollPaneOutput.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
      jScrollPaneOutput.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
      jScrollPaneOutput.setMinimumSize(new java.awt.Dimension(22, 75));
      jScrollPaneOutput.setPreferredSize(new java.awt.Dimension(3, 100));
      jEditorPaneOutput.setBackground(new java.awt.Color(204, 204, 204));
      jEditorPaneOutput.setEditable(false);
      jEditorPaneOutput.setFont(new java.awt.Font("Courier New", 0, 12));
      jScrollPaneOutput.setViewportView(jEditorPaneOutput);

      jPanelSouth.add(jScrollPaneOutput, java.awt.BorderLayout.CENTER);

      jPanelProcesses.setLayout(new java.awt.BorderLayout());

      jPanelProcesses.setMinimumSize(new java.awt.Dimension(10, 1));
      jPanelProcesses.setPreferredSize(new java.awt.Dimension(120, 1));
      jTabbedPane1.setTabPlacement(javax.swing.JTabbedPane.BOTTOM);
      jTabbedPane1.setFont(new java.awt.Font("Dialog", 0, 11));
      jScrollProcesses.setViewportView(jListThreads);

      jTabbedPane1.addTab("Active Threads", jScrollProcesses);

      jPanelProcesses.add(jTabbedPane1, java.awt.BorderLayout.CENTER);

      jPanelSouth.add(jPanelProcesses, java.awt.BorderLayout.EAST);

      jSplitPaneV.setBottomComponent(jPanelSouth);

      getContentPane().add(jSplitPaneV, java.awt.BorderLayout.CENTER);

      jMenuFile.setMnemonic('f');
      jMenuFile.setText("File");
      jMenuFile.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuFile.addActionListener(formListener);

      jMenuItemNewDocument.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemNewDocument.setText("New document");
      jMenuItemNewDocument.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/new.gif")));
      jMenuItemNewDocument.addActionListener(formListener);

      jMenuFile.add(jMenuItemNewDocument);

      jMenuItemWizard.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemWizard.setText("Report wizard...");
      jMenuItemWizard.setDisabledIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/wizard.gif")));
      jMenuItemWizard.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/wizard.gif")));
      jMenuItemWizard.addActionListener(formListener);

      jMenuFile.add(jMenuItemWizard);

      jMenuItemOpen.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemOpen.setText("Open");
      jMenuItemOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/open.gif")));
      jMenuItemOpen.addActionListener(formListener);

      jMenuFile.add(jMenuItemOpen);

      jMenuItemQOpen.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemQOpen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/open.gif")));
      jMenuItemQOpen.setText("Quick open...");
      jMenuFile.add(jMenuItemQOpen);

      jMenuFile.add(jSeparator16);

      jMenuItemSave.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/save.gif")));
      jMenuItemSave.setMnemonic('s');
      jMenuItemSave.setText("Save");
      jMenuItemSave.addActionListener(formListener);

      jMenuFile.add(jMenuItemSave);

      jMenuItemSaveAs.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSaveAs.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/save.gif")));
      jMenuItemSaveAs.setText("Save as...");
      jMenuItemSaveAs.addActionListener(formListener);

      jMenuFile.add(jMenuItemSaveAs);

      jMenuItemSaveAll.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSaveAll.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/saveall.gif")));
      jMenuItemSaveAll.setText("Save all");
      jMenuItemSaveAll.addActionListener(formListener);

      jMenuFile.add(jMenuItemSaveAll);

      jMenuFile.add(jSeparator3);

      jMenuRecentFiles.setText("Recent Files");
      jMenuRecentFiles.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuFile.add(jMenuRecentFiles);

      jMenuRecentProjects.setText("Recent Projects");
      jMenuRecentProjects.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuFile.add(jMenuRecentProjects);

      jMenuItemFavorites.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFavorites.setText("Favorite Files...");
      jMenuFile.add(jMenuItemFavorites);

      jMenuFile.add(jSeparator15);

      jMenuItemQuit.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemQuit.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
      jMenuItemQuit.setMnemonic('q');
      jMenuItemQuit.setText("Quit");
      jMenuItemQuit.addActionListener(formListener);

      jMenuFile.add(jMenuItemQuit);

      jMDIMenuBar.add(jMenuFile);

      jMenuEdit.setMnemonic('e');
      jMenuEdit.setText("Edit");
      jMenuEdit.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuEdit.addActionListener(formListener);

      jMenuItemUndo.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemUndo.setText("Undo");
      jMenuItemUndo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/undo.gif")));
      jMenuItemUndo.setEnabled(false);
      jMenuItemUndo.addActionListener(formListener);

      jMenuEdit.add(jMenuItemUndo);

      jMenuItemRedo.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemRedo.setText("Redo");
      jMenuItemRedo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/redo.gif")));
      jMenuItemRedo.setEnabled(false);
      jMenuItemRedo.addActionListener(formListener);

      jMenuEdit.add(jMenuItemRedo);

      jMenuEdit.add(jSeparator1);

      jMenuItemCut.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCut.setText("Cut");
      jMenuItemCut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.gif")));
      jMenuItemCut.setEnabled(false);
      jMenuItemCut.addActionListener(formListener);

      jMenuEdit.add(jMenuItemCut);

      jMenuItemCopy.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCopy.setText("Copy");
      jMenuItemCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.gif")));
      jMenuItemCopy.setEnabled(false);
      jMenuItemCopy.addActionListener(formListener);

      jMenuEdit.add(jMenuItemCopy);

      jMenuItemPaste.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemPaste.setText("Paste");
      jMenuItemPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.gif")));
      jMenuItemPaste.setEnabled(false);
      jMenuItemPaste.addActionListener(formListener);

      jMenuEdit.add(jMenuItemPaste);

      jMenuItemDelete.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemDelete.setText("Delete");
      jMenuItemDelete.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.gif")));
      jMenuItemDelete.setEnabled(false);
      jMenuItemDelete.addActionListener(formListener);

      jMenuEdit.add(jMenuItemDelete);

      jMenuEdit.add(jSeparator2);

      jCheckBoxMenuItemEMM.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxMenuItemEMM.setText("Disable elements mouse move");
      jCheckBoxMenuItemEMM.setEnabled(false);
      jMenuEdit.add(jCheckBoxMenuItemEMM);

      jCheckBoxMenuItemSnapToGrid.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxMenuItemSnapToGrid.setText("Snap To Grid");
      jCheckBoxMenuItemSnapToGrid.setEnabled(false);
      jCheckBoxMenuItemSnapToGrid.addActionListener(formListener);

      jMenuEdit.add(jCheckBoxMenuItemSnapToGrid);

      jMenuAdd.setText("Insert element...");
      jMenuAdd.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuAdd.setEnabled(false);
      jMenuItemNullElement.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemNullElement.setText("Null element (debug only)");
      jMenuItemNullElement.addActionListener(formListener);

      jMenuAdd.add(jMenuItemNullElement);

      jMenuItemLine.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemLine.setText("Line");
      jMenuItemLine.addActionListener(formListener);

      jMenuAdd.add(jMenuItemLine);

      jMenuItemRectangle.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemRectangle.setText("Rectangle");
      jMenuItemRectangle.addActionListener(formListener);

      jMenuAdd.add(jMenuItemRectangle);

      jMenuItemRoundRectangle.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemRoundRectangle.setText("Rounded rectangle");
      jMenuItemRoundRectangle.addActionListener(formListener);

      jMenuAdd.add(jMenuItemRoundRectangle);

      jMenuItemEllipse.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemEllipse.setText("Ellipse");
      jMenuItemEllipse.addActionListener(formListener);

      jMenuAdd.add(jMenuItemEllipse);

      jMenuItemStaticText.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemStaticText.setText("Static text");
      jMenuItemStaticText.addActionListener(formListener);

      jMenuAdd.add(jMenuItemStaticText);

      jMenuItemTextField.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemTextField.setText("Text field");
      jMenuItemTextField.addActionListener(formListener);

      jMenuAdd.add(jMenuItemTextField);

      jMenuItemSubreport.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSubreport.setText("Subreport");
      jMenuItemSubreport.addActionListener(formListener);

      jMenuAdd.add(jMenuItemSubreport);

      jMenuEdit.add(jMenuAdd);

      jMenuItemXMLSource.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemXMLSource.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/null.gif")));
      jMenuItemXMLSource.setText("Edit XML source...");
      jMenuItemXMLSource.setEnabled(false);
      jMenuItemXMLSource.addActionListener(formListener);

      jMenuEdit.add(jMenuItemXMLSource);

      jMenuItem1.setText("TextArea");
      jMenuItem1.addActionListener(formListener);

      jMenuEdit.add(jMenuItem1);

      jMDIMenuBar.add(jMenuEdit);

      jMenuView.setMnemonic('v');
      jMenuView.setText("View");
      jMenuView.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxMenuItemGrid.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxMenuItemGrid.setText("Show grid");
      jCheckBoxMenuItemGrid.setEnabled(false);
      jCheckBoxMenuItemGrid.addActionListener(formListener);

      jMenuView.add(jCheckBoxMenuItemGrid);

      jMenuView.add(jSeparator4);

      jCheckBoxMenuItemOutput.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxMenuItemOutput.setSelected(true);
      jCheckBoxMenuItemOutput.setText("Show output window");
      jCheckBoxMenuItemOutput.addActionListener(formListener);

      jMenuView.add(jCheckBoxMenuItemOutput);

      jCheckBoxMenuItemExplorer.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxMenuItemExplorer.setSelected(true);
      jCheckBoxMenuItemExplorer.setText("Show project browser");
      jCheckBoxMenuItemExplorer.addActionListener(formListener);

      jMenuView.add(jCheckBoxMenuItemExplorer);

      jMenuView.add(jSeparator12);

      jMenuItemReportProperties.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemReportProperties.setText("Report properties");
      jMenuItemReportProperties.setEnabled(false);
      jMenuItemReportProperties.addActionListener(formListener);

      jMenuView.add(jMenuItemReportProperties);

      jMenuItemReportQuery.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemReportQuery.setText("Report query");
      jMenuItemReportQuery.setEnabled(false);
      jMenuItemReportQuery.addActionListener(formListener);

      jMenuView.add(jMenuItemReportQuery);

      jMenuItemFields.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFields.setText("Report fields");
      jMenuItemFields.setEnabled(false);
      jMenuItemFields.addActionListener(formListener);

      jMenuView.add(jMenuItemFields);

      jMenuItemVariables.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemVariables.setText("Report variables");
      jMenuItemVariables.setEnabled(false);
      jMenuItemVariables.addActionListener(formListener);

      jMenuView.add(jMenuItemVariables);

      jMenuItemParameters.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemParameters.setText("Report parameters");
      jMenuItemParameters.setEnabled(false);
      jMenuItemParameters.addActionListener(formListener);

      jMenuView.add(jMenuItemParameters);

      jMenuItemFonts.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFonts.setText("Report fonts");
      jMenuItemFonts.setEnabled(false);
      jMenuItemFonts.addActionListener(formListener);

      jMenuView.add(jMenuItemFonts);

      jMenuView.add(jSeparator6);

      jMenuItemBands.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemBands.setText("Bands");
      jMenuItemBands.setEnabled(false);
      jMenuItemBands.addActionListener(formListener);

      jMenuView.add(jMenuItemBands);

      jMenuItemGroups.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemGroups.setText("Report groups");
      jMenuItemGroups.setEnabled(false);
      jMenuItemGroups.addActionListener(formListener);

      jMenuView.add(jMenuItemGroups);

      jMenuView.add(jSeparator7);

      jMenuItemElementProperties.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemElementProperties.setText("Element properties");
      jMenuItemElementProperties.setEnabled(false);
      jMenuItemElementProperties.addActionListener(formListener);

      jMenuView.add(jMenuItemElementProperties);

      jMenuItemElementsBrowser.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemElementsBrowser.setText("Elements browser");
      jMenuItemElementsBrowser.addActionListener(formListener);

      jMenuView.add(jMenuItemElementsBrowser);

      jMDIMenuBar.add(jMenuView);

      jMenuSearch.setMnemonic('s');
      jMenuSearch.setText("Search");
      jMenuSearch.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFind.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFind.setText("Find");
      jMenuItemFind.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/find.gif")));
      jMenuSearch.add(jMenuItemFind);

      jMenuItemFindNext.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFindNext.setText("Find next");
      jMenuItemFindNext.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/findnext.gif")));
      jMenuSearch.add(jMenuItemFindNext);

      jMenuItemFindPrev.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemFindPrev.setText("Find Prev");
      jMenuItemFindPrev.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/findprev.gif")));
      jMenuSearch.add(jMenuItemFindPrev);

      jMenuItemReplace.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemReplace.setText("Replace");
      jMenuItemReplace.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/findreplace.gif")));
      jMenuSearch.add(jMenuItemReplace);

      jMDIMenuBar.add(jMenuSearch);

      jMenuProjects.setMnemonic('p');
      jMenuProjects.setText("Project");
      jMenuProjects.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemNewProject.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemNewProject.setText("New project");
      jMenuItemNewProject.addActionListener(formListener);

      jMenuProjects.add(jMenuItemNewProject);

      jMenuItemOpenProject.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemOpenProject.setText("Open project");
      jMenuProjects.add(jMenuItemOpenProject);

      jMenuItemCloseProject.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCloseProject.setText("Close project");
      jMenuItemCloseProject.setEnabled(false);
      jMenuItemCloseProject.addActionListener(formListener);

      jMenuProjects.add(jMenuItemCloseProject);

      jMenuProjects.add(jSeparator13);

      jMenuItemAddFileToProject.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAddFileToProject.setText("Add report to project...");
      jMenuProjects.add(jMenuItemAddFileToProject);

      jMenuItemProjectOptions.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemProjectOptions.setText("Project options...");
      jMenuProjects.add(jMenuItemProjectOptions);

      jMDIMenuBar.add(jMenuProjects);

      jMenuBuild.setMnemonic('b');
      jMenuBuild.setText("Build");
      jMenuBuild.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCompile.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCompile.setText("Compile");
      jMenuBuild.add(jMenuItemCompile);

      jMenuItemCompileAll.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCompileAll.setText("Compile All");
      jMenuBuild.add(jMenuItemCompileAll);

      jMenuBuild.add(jSeparator10);

      jMenuItemExecute.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemExecute.setText("Execute report");
      jMenuItemExecute.addActionListener(formListener);

      jMenuBuild.add(jMenuItemExecute);

      jMenuItemExecuteDB.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemExecuteDB.setText("Execute report (using active conn.) ");
      jMenuItemExecuteDB.addActionListener(formListener);

      jMenuBuild.add(jMenuItemExecuteDB);

      jMenuBuild.add(jSeparator11);

      jRadioButtonMenuItemPreviewPDF.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButtonMenuItemPreviewPDF.setSelected(true);
      jRadioButtonMenuItemPreviewPDF.setText("PDF preview");
      buttonGroupExportType.add(jRadioButtonMenuItemPreviewPDF);
      jRadioButtonMenuItemPreviewPDF.addActionListener(formListener);

      jMenuBuild.add(jRadioButtonMenuItemPreviewPDF);

      jRadioButtonMenuItemPreviewHTML.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButtonMenuItemPreviewHTML.setText("HTML preview");
      buttonGroupExportType.add(jRadioButtonMenuItemPreviewHTML);
      jRadioButtonMenuItemPreviewHTML.addActionListener(formListener);

      jMenuBuild.add(jRadioButtonMenuItemPreviewHTML);

      jRadioButtonMenuItemPreviewJAVA.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButtonMenuItemPreviewJAVA.setText("JAVA 2D preview");
      buttonGroupExportType.add(jRadioButtonMenuItemPreviewJAVA);
      jRadioButtonMenuItemPreviewJAVA.addActionListener(formListener);

      jMenuBuild.add(jRadioButtonMenuItemPreviewJAVA);

      jRadioButtonMenuItemPreviewXLS.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButtonMenuItemPreviewXLS.setText("Excel preview");
      buttonGroupExportType.add(jRadioButtonMenuItemPreviewXLS);
      jRadioButtonMenuItemPreviewXLS.addActionListener(formListener);

      jMenuBuild.add(jRadioButtonMenuItemPreviewXLS);

      jRadioButtonMenuItemPreviewCSV.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButtonMenuItemPreviewCSV.setText("CSV preview");
      buttonGroupExportType.add(jRadioButtonMenuItemPreviewCSV);
      jRadioButtonMenuItemPreviewCSV.addActionListener(formListener);

      jMenuBuild.add(jRadioButtonMenuItemPreviewCSV);

      jRadioButtonMenuItemPreviewInternalViewer.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButtonMenuItemPreviewInternalViewer.setText("JRViewer preview");
      buttonGroupExportType.add(jRadioButtonMenuItemPreviewInternalViewer);
      jRadioButtonMenuItemPreviewInternalViewer.addActionListener(formListener);

      jMenuBuild.add(jRadioButtonMenuItemPreviewInternalViewer);

      jMenuBuild.add(jSeparator14);

      jMenuItemActiveConnection.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemActiveConnection.setText("Set active connection");
      jMenuItemActiveConnection.setToolTipText("Set the connection that must be used to fill this report");
      jMenuItemActiveConnection.addActionListener(formListener);

      jMenuBuild.add(jMenuItemActiveConnection);

      jMDIMenuBar.add(jMenuBuild);

      jMenuFormat.setMnemonic('o');
      jMenuFormat.setText("Format");
      jMenuFormat.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuAlign.setText("Align...");
      jMenuAlign.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignLeft.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignLeft.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_left.gif")));
      jMenuItemAlignLeft.setText("Align left");
      jMenuItemAlignLeft.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignLeft);

      jMenuItemAlignRight.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignRight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_right.gif")));
      jMenuItemAlignRight.setText("Align right");
      jMenuItemAlignRight.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignRight);

      jMenuItemAlignTop.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignTop.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_top.gif")));
      jMenuItemAlignTop.setText("Align top");
      jMenuItemAlignTop.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignTop);

      jMenuItemAlignBottom.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignBottom.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_align_bottom.gif")));
      jMenuItemAlignBottom.setText("Align bottom");
      jMenuItemAlignBottom.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignBottom);

      jMenuAlign.add(jSeparator19);

      jMenuItemAlignVerticalAxis.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignVerticalAxis.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_center_axis.gif")));
      jMenuItemAlignVerticalAxis.setText("Align vertical axis");
      jMenuItemAlignVerticalAxis.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignVerticalAxis);

      jMenuItemAlignHorizontalAxis.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignHorizontalAxis.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter_axis.gif")));
      jMenuItemAlignHorizontalAxis.setText("Align horizontal axis");
      jMenuItemAlignHorizontalAxis.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignHorizontalAxis);

      jMenuAlign.add(jSeparator20);

      jMenuItemAlignToBandTop.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignToBandTop.setText("Align to band top");
      jMenuItemAlignToBandTop.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignToBandTop);

      jMenuItemAlignToBandBottom.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemAlignToBandBottom.setText("Align to band bottom");
      jMenuItemAlignToBandBottom.addActionListener(formListener);

      jMenuAlign.add(jMenuItemAlignToBandBottom);

      jMenuFormat.add(jMenuAlign);

      jMenuSize.setText("Size...");
      jMenuSize.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameWidth.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameWidth.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize.gif")));
      jMenuItemSameWidth.setText("Same width");
      jMenuItemSameWidth.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameWidth);

      jMenuItemSameWidthMax.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameWidthMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_plus.gif")));
      jMenuItemSameWidthMax.setText("Same width (max)");
      jMenuItemSameWidthMax.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameWidthMax);

      jMenuItemSameWidthMin.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameWidthMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_hsize_min.gif")));
      jMenuItemSameWidthMin.setText("Same width (min)");
      jMenuItemSameWidthMin.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameWidthMin);

      jMenuSize.add(jSeparator17);

      jMenuItemSameHeight.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameHeight.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize.gif")));
      jMenuItemSameHeight.setText("Same height");
      jMenuItemSameHeight.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameHeight);

      jMenuItemSameHeightMin.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameHeightMin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_min.gif")));
      jMenuItemSameHeightMin.setText("Same height (min)");
      jMenuItemSameHeightMin.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameHeightMin);

      jMenuItemSameHeightMax.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameHeightMax.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_vsize_plus.gif")));
      jMenuItemSameHeightMax.setText("Same height (max)");
      jMenuItemSameHeightMax.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameHeightMax);

      jMenuSize.add(jSeparator18);

      jMenuItemSameSize.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSameSize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_same_size.gif")));
      jMenuItemSameSize.setText("Same size");
      jMenuItemSameSize.addActionListener(formListener);

      jMenuSize.add(jMenuItemSameSize);

      jMenuFormat.add(jMenuSize);

      jMenuPosition.setText("Position...");
      jMenuPosition.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCenterH.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCenterH.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_hcenter.gif")));
      jMenuItemCenterH.setText("Center horizontally (band based)");
      jMenuItemCenterH.addActionListener(formListener);

      jMenuPosition.add(jMenuItemCenterH);

      jMenuItemCenterV.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCenterV.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_vcenter.gif")));
      jMenuItemCenterV.setText("Center vertically (band based)");
      jMenuItemCenterV.addActionListener(formListener);

      jMenuPosition.add(jMenuItemCenterV);

      jMenuItemCenterInBand.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCenterInBand.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_ccenter.gif")));
      jMenuItemCenterInBand.setText("Center in band");
      jMenuItemCenterInBand.addActionListener(formListener);

      jMenuPosition.add(jMenuItemCenterInBand);

      jMenuItemCenterBackground.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCenterBackground.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/elem_bcenter.gif")));
      jMenuItemCenterBackground.setText("Center in background");
      jMenuItemCenterBackground.addActionListener(formListener);

      jMenuPosition.add(jMenuItemCenterBackground);

      jMenuItemJoinLeft.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemJoinLeft.setText("Join sides left");
      jMenuItemJoinLeft.addActionListener(formListener);

      jMenuPosition.add(jMenuItemJoinLeft);

      jMenuItemJoinRight.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemJoinRight.setText("Join sides right");
      jMenuItemJoinRight.addActionListener(formListener);

      jMenuPosition.add(jMenuItemJoinRight);

      jMenuFormat.add(jMenuPosition);

      jMenuFormat.add(jSeparator5);

      jMenuHSpacing.setText("Horizontal spacing...");
      jMenuHSpacing.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHSMakeEqual.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHSMakeEqual.setText("Make equal");
      jMenuItemHSMakeEqual.addActionListener(formListener);

      jMenuHSpacing.add(jMenuItemHSMakeEqual);

      jMenuItemHSIncrease.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHSIncrease.setText("Increase");
      jMenuItemHSIncrease.addActionListener(formListener);

      jMenuHSpacing.add(jMenuItemHSIncrease);

      jMenuItemHSDecrease.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHSDecrease.setText("Decrease");
      jMenuItemHSDecrease.addActionListener(formListener);

      jMenuHSpacing.add(jMenuItemHSDecrease);

      jMenuItemHSRemove.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHSRemove.setText("Remove");
      jMenuItemHSRemove.addActionListener(formListener);

      jMenuHSpacing.add(jMenuItemHSRemove);

      jMenuFormat.add(jMenuHSpacing);

      jMenuVSpacing.setText("Vertical spacing");
      jMenuVSpacing.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemVSMakeEqual.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemVSMakeEqual.setText("Make equal");
      jMenuItemVSMakeEqual.addActionListener(formListener);

      jMenuVSpacing.add(jMenuItemVSMakeEqual);

      jMenuItemVSIncrease.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemVSIncrease.setText("Increase");
      jMenuItemVSIncrease.addActionListener(formListener);

      jMenuVSpacing.add(jMenuItemVSIncrease);

      jMenuItemVSDecrease.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemVSDecrease.setText("Decrease");
      jMenuItemVSDecrease.addActionListener(formListener);

      jMenuVSpacing.add(jMenuItemVSDecrease);

      jMenuItemVSRemove.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemVSRemove.setText("Remove");
      jMenuItemVSRemove.addActionListener(formListener);

      jMenuVSpacing.add(jMenuItemVSRemove);

      jMenuFormat.add(jMenuVSpacing);

      jMenuFormat.add(jSeparator8);

      jMenuItemBringToFront.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemBringToFront.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/sendtofront.gif")));
      jMenuItemBringToFront.setText("Bring to front");
      jMenuItemBringToFront.addActionListener(formListener);

      jMenuFormat.add(jMenuItemBringToFront);

      jMenuItemSendToBack.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemSendToBack.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/sendtoback.gif")));
      jMenuItemSendToBack.setText("Send to back");
      jMenuItemSendToBack.addActionListener(formListener);

      jMenuFormat.add(jMenuItemSendToBack);

      jMDIMenuBar.add(jMenuFormat);

      jMenuDatabase.setMnemonic('d');
      jMenuDatabase.setText("Datasource");
      jMenuDatabase.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemConnections.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemConnections.setText("Connections / Datasources");
      jMenuItemConnections.addActionListener(formListener);

      jMenuDatabase.add(jMenuItemConnections);

      jMenuDatabase.add(jSeparator9);

      jMenuItemReportQuery2.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemReportQuery2.setText("Report query");
      jMenuItemReportQuery2.addActionListener(formListener);

      jMenuDatabase.add(jMenuItemReportQuery2);

      jMDIMenuBar.add(jMenuDatabase);

      jMenuTools.setMnemonic('t');
      jMenuTools.setText("Tools");
      jMenuTools.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemOptions.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemOptions.setText("Options...");
      jMenuItemOptions.addActionListener(formListener);

      jMenuTools.add(jMenuItemOptions);

      jMenuItemCompatibility.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCompatibility.setText("Compatibility...");
      jMenuItemCompatibility.addActionListener(formListener);

      jMenuTools.add(jMenuItemCompatibility);

      jMDIMenuBar.add(jMenuTools);

      jMenuWindow.setMnemonic('w');
      jMenuWindow.setText("Window");
      jMenuWindow.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCascade.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemCascade.setText("Cascade");
      jMenuItemCascade.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_cascade.gif")));
      jMenuItemCascade.addActionListener(formListener);

      jMenuWindow.add(jMenuItemCascade);

      jMenuItemTileHorizontal.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemTileHorizontal.setText("Tile horizontal");
      jMenuItemTileHorizontal.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_htile.gif")));
      jMenuItemTileHorizontal.addActionListener(formListener);

      jMenuWindow.add(jMenuItemTileHorizontal);

      jMenuItemTileVertical.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemTileVertical.setText("Tile vertical");
      jMenuItemTileVertical.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_vtile.gif")));
      jMenuItemTileVertical.addActionListener(formListener);

      jMenuWindow.add(jMenuItemTileVertical);

      jMenuItemtileAnodine.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemtileAnodine.setText("Tile anodine");
      jMenuItemtileAnodine.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_atile.gif")));
      jMenuItemtileAnodine.addActionListener(formListener);

      jMenuWindow.add(jMenuItemtileAnodine);

      jMenuItemNextWin.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemNextWin.setText("Next Window");
      jMenuItemNextWin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_next.gif")));
      jMenuItemNextWin.addActionListener(formListener);

      jMenuWindow.add(jMenuItemNextWin);

      jMenuItemPrevWin.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemPrevWin.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/win_prev.gif")));
      jMenuItemPrevWin.setText("Previous Window");
      jMenuItemPrevWin.addActionListener(formListener);

      jMenuWindow.add(jMenuItemPrevWin);

      jMenuWindow.add(jSeparator21);

      jMDIMenuBar.add(jMenuWindow);

      jMenuHelp.setMnemonic('h');
      jMenuHelp.setText("Help");
      jMenuHelp.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHelp.setFont(new java.awt.Font("Dialog", 0, 11));
      jMenuItemHelp.setText("Help...");
      jMenuHelp.add(jMenuItemHelp);

      jMenuItemAbout.setFont(new java.awt.Font("Dialog", 1, 11));
      jMenuItemAbout.setText("About iReport...");
      jMenuItemAbout.addActionListener(formListener);

      jMenuHelp.add(jMenuItemAbout);

      jMDIMenuBar.add(jMenuHelp);

      setJMenuBar(jMDIMenuBar);

      pack();
   }

   // Code for dispatching events from components to event handlers.

   private class FormListener implements java.awt.event.ActionListener, java.awt.event.ComponentListener, java.awt.event.ItemListener, java.awt.event.MouseListener, java.awt.event.WindowListener, javax.swing.event.ChangeListener, javax.swing.event.TreeSelectionListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == jMenuFile)
         {
            MainFrame.this.jMenuFileActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemNewDocument)
         {
            MainFrame.this.jMenuItemNewDocumentActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemWizard)
         {
            MainFrame.this.jMenuItemWizardActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemOpen)
         {
            MainFrame.this.jMenuItemOpenActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSave)
         {
            MainFrame.this.jMenuItemSaveActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSaveAs)
         {
            MainFrame.this.jMenuItemSaveAsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSaveAll)
         {
            MainFrame.this.jMenuItemSaveAllActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemQuit)
         {
            MainFrame.this.jMenuItemQuitActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuEdit)
         {
            MainFrame.this.jMenuEditActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemUndo)
         {
            MainFrame.this.jMenuItemUndoActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemRedo)
         {
            MainFrame.this.jMenuItemRedoActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCut)
         {
            MainFrame.this.jMenuItemCutActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCopy)
         {
            MainFrame.this.jMenuItemCopyActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemPaste)
         {
            MainFrame.this.jMenuItemPasteActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemDelete)
         {
            MainFrame.this.jMenuItemDeleteActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxMenuItemSnapToGrid)
         {
            MainFrame.this.jCheckBoxMenuItemSnapToGridActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemNullElement)
         {
            MainFrame.this.jMenuItemNullElementActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemLine)
         {
            MainFrame.this.jMenuItemLineActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemRectangle)
         {
            MainFrame.this.jMenuItemRectangleActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemRoundRectangle)
         {
            MainFrame.this.jMenuItemRoundRectangleActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemEllipse)
         {
            MainFrame.this.jMenuItemEllipseActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemStaticText)
         {
            MainFrame.this.jMenuItemStaticTextActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemTextField)
         {
            MainFrame.this.jMenuItemTextFieldActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSubreport)
         {
            MainFrame.this.jMenuItemSubreportActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemXMLSource)
         {
            MainFrame.this.jMenuItemXMLSourceActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItem1)
         {
            MainFrame.this.jMenuItem1ActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxMenuItemGrid)
         {
            MainFrame.this.jCheckBoxMenuItemGridActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxMenuItemOutput)
         {
            MainFrame.this.jCheckBoxMenuItemOutputActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxMenuItemExplorer)
         {
            MainFrame.this.jCheckBoxMenuItemExplorerActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemReportProperties)
         {
            MainFrame.this.jMenuItemReportPropertiesActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemReportQuery)
         {
            MainFrame.this.jMenuItemReportQueryActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemFields)
         {
            MainFrame.this.jMenuItemFieldsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemVariables)
         {
            MainFrame.this.jMenuItemVariablesActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemParameters)
         {
            MainFrame.this.jMenuItemParametersActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemFonts)
         {
            MainFrame.this.jMenuItemFontsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemBands)
         {
            MainFrame.this.jMenuItemBandsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemGroups)
         {
            MainFrame.this.jMenuItemGroupsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemElementProperties)
         {
            MainFrame.this.jMenuItemElementPropertiesActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemElementsBrowser)
         {
            MainFrame.this.jMenuItemElementsBrowserActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemNewProject)
         {
            MainFrame.this.jMenuItemNewProjectActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCloseProject)
         {
            MainFrame.this.jMenuItemCloseProjectActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemExecute)
         {
            MainFrame.this.jMenuItemExecuteActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemExecuteDB)
         {
            MainFrame.this.jMenuItemExecuteDBActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButtonMenuItemPreviewPDF)
         {
            MainFrame.this.jRadioButtonMenuItemPreviewPDFActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButtonMenuItemPreviewInternalViewer)
         {
            MainFrame.this.jRadioButtonMenuItemPreviewInternalViewerActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemActiveConnection)
         {
            MainFrame.this.jMenuItemActiveConnectionActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignLeft)
         {
            MainFrame.this.jMenuItemAlignLeftActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignRight)
         {
            MainFrame.this.jMenuItemAlignRightActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignTop)
         {
            MainFrame.this.jMenuItemAlignTopActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignBottom)
         {
            MainFrame.this.jMenuItemAlignBottomActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignVerticalAxis)
         {
            MainFrame.this.jMenuItemAlignVerticalAxisActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignHorizontalAxis)
         {
            MainFrame.this.jMenuItemAlignHorizontalAxisActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignToBandTop)
         {
            MainFrame.this.jMenuItemAlignToBandTopActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAlignToBandBottom)
         {
            MainFrame.this.jMenuItemAlignToBandBottomActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameWidth)
         {
            MainFrame.this.jMenuItemSameWidthActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameWidthMax)
         {
            MainFrame.this.jMenuItemSameWidthMaxActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameWidthMin)
         {
            MainFrame.this.jMenuItemSameWidthMinActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameHeight)
         {
            MainFrame.this.jMenuItemSameHeightActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameHeightMin)
         {
            MainFrame.this.jMenuItemSameHeightMinActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameHeightMax)
         {
            MainFrame.this.jMenuItemSameHeightMaxActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSameSize)
         {
            MainFrame.this.jMenuItemSameSizeActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCenterH)
         {
            MainFrame.this.jMenuItemCenterHActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCenterV)
         {
            MainFrame.this.jMenuItemCenterVActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCenterInBand)
         {
            MainFrame.this.jMenuItemCenterInBandActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCenterBackground)
         {
            MainFrame.this.jMenuItemCenterBackgroundActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemJoinLeft)
         {
            MainFrame.this.jMenuItemJoinLeftActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemJoinRight)
         {
            MainFrame.this.jMenuItemJoinRightActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemHSMakeEqual)
         {
            MainFrame.this.jMenuItemHSMakeEqualActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemHSIncrease)
         {
            MainFrame.this.jMenuItemHSIncreaseActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemHSDecrease)
         {
            MainFrame.this.jMenuItemHSDecreaseActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemHSRemove)
         {
            MainFrame.this.jMenuItemHSRemoveActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemVSMakeEqual)
         {
            MainFrame.this.jMenuItemVSMakeEqualActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemVSIncrease)
         {
            MainFrame.this.jMenuItemVSIncreaseActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemVSDecrease)
         {
            MainFrame.this.jMenuItemVSDecreaseActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemVSRemove)
         {
            MainFrame.this.jMenuItemVSRemoveActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemBringToFront)
         {
            MainFrame.this.jMenuItemBringToFrontActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemSendToBack)
         {
            MainFrame.this.jMenuItemSendToBackActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemConnections)
         {
            MainFrame.this.jMenuItemConnectionsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemReportQuery2)
         {
            MainFrame.this.jMenuItemReportQuery2ActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemOptions)
         {
            MainFrame.this.jMenuItemOptionsActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCompatibility)
         {
            MainFrame.this.jMenuItemCompatibilityActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemCascade)
         {
            MainFrame.this.jMenuItemCascadeActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemTileHorizontal)
         {
            MainFrame.this.jMenuItemTileHorizontalActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemTileVertical)
         {
            MainFrame.this.jMenuItemTileVerticalActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemtileAnodine)
         {
            MainFrame.this.jMenuItemtileAnodineActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemNextWin)
         {
            MainFrame.this.jMenuItemNextWinActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemPrevWin)
         {
            MainFrame.this.jMenuItemPrevWinActionPerformed(evt);
         }
         else if (evt.getSource() == jMenuItemAbout)
         {
            MainFrame.this.jMenuItemAboutActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonNew)
         {
            MainFrame.this.jButtonNewActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonOpen)
         {
            MainFrame.this.jButtonOpenActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonSave)
         {
            MainFrame.this.jButtonSaveActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonCut)
         {
            MainFrame.this.jButtonCutActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonCopy)
         {
            MainFrame.this.jButtonCopyActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonPaste)
         {
            MainFrame.this.jButtonPasteActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonPointer)
         {
            MainFrame.this.jToggleButtonPointerActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonLineTool)
         {
            MainFrame.this.jToggleButtonLineToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonRectTool)
         {
            MainFrame.this.jToggleButtonRectToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonRectRoundTool)
         {
            MainFrame.this.jToggleButtonRectRoundToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonEllipseTool)
         {
            MainFrame.this.jToggleButtonEllipseToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonImageTool)
         {
            MainFrame.this.jToggleButtonImageToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonStaticTextTool)
         {
            MainFrame.this.jToggleButtonStaticTextToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonTextFieldTool)
         {
            MainFrame.this.jToggleButtonTextFieldToolActionPerformed(evt);
         }
         else if (evt.getSource() == jToggleButtonSubreportTool)
         {
            MainFrame.this.jToggleButtonSubreportToolActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBands)
         {
            MainFrame.this.jButtonBandsActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonGroups)
         {
            MainFrame.this.jButtonGroupsActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonParameters)
         {
            MainFrame.this.jButtonParametersActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonDatabase)
         {
            MainFrame.this.jButtonDatabaseActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonAlignLeft)
         {
            MainFrame.this.jButtonAlignLeftActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonAlignCenter)
         {
            MainFrame.this.jButtonAlignCenterActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonAlignRight)
         {
            MainFrame.this.jButtonAlignRightActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonAlignJustify)
         {
            MainFrame.this.jButtonAlignJustifyActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonCompiler)
         {
            MainFrame.this.jButtonCompilerActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonRun1)
         {
            MainFrame.this.jButtonRun1ActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonRun2)
         {
            MainFrame.this.jButtonRun2ActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButtonMenuItemPreviewHTML)
         {
            MainFrame.this.jRadioButtonMenuItemPreviewHTMLActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButtonMenuItemPreviewJAVA)
         {
            MainFrame.this.jRadioButtonMenuItemPreviewJAVAActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButtonMenuItemPreviewXLS)
         {
            MainFrame.this.jRadioButtonMenuItemPreviewXLSActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButtonMenuItemPreviewCSV)
         {
            MainFrame.this.jRadioButtonMenuItemPreviewCSVActionPerformed(evt);
         }
      }

      public void componentHidden(java.awt.event.ComponentEvent evt)
      {
      }

      public void componentMoved(java.awt.event.ComponentEvent evt)
      {
      }

      public void componentResized(java.awt.event.ComponentEvent evt)
      {
         if (evt.getSource() == jPanelToolBar)
         {
            MainFrame.this.jPanelToolBarComponentResized(evt);
         }
      }

      public void componentShown(java.awt.event.ComponentEvent evt)
      {
      }

      public void itemStateChanged(java.awt.event.ItemEvent evt)
      {
         if (evt.getSource() == jToggleButtonPointer)
         {
            MainFrame.this.jToggleButtonPointerItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonLineTool)
         {
            MainFrame.this.jToggleButtonLineToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonRectTool)
         {
            MainFrame.this.jToggleButtonRectToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonRectRoundTool)
         {
            MainFrame.this.jToggleButtonRectRoundToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonEllipseTool)
         {
            MainFrame.this.jToggleButtonEllipseToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonImageTool)
         {
            MainFrame.this.jToggleButtonImageToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonStaticTextTool)
         {
            MainFrame.this.jToggleButtonStaticTextToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonTextFieldTool)
         {
            MainFrame.this.jToggleButtonTextFieldToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonSubreportTool)
         {
            MainFrame.this.jToggleButtonSubreportToolItemStateChanged(evt);
         }
         else if (evt.getSource() == jToggleButtonChartTool)
         {
            MainFrame.this.jToggleButtonChartToolItemStateChanged(evt);
         }
      }

      public void mouseClicked(java.awt.event.MouseEvent evt)
      {
         if (evt.getSource() == jTreeFiles)
         {
            MainFrame.this.jTreeFilesMouseClicked(evt);
         }
      }

      public void mouseEntered(java.awt.event.MouseEvent evt)
      {
      }

      public void mouseExited(java.awt.event.MouseEvent evt)
      {
      }

      public void mousePressed(java.awt.event.MouseEvent evt)
      {
      }

      public void mouseReleased(java.awt.event.MouseEvent evt)
      {
      }

      public void windowActivated(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == MainFrame.this)
         {
            MainFrame.this.formWindowActivated(evt);
         }
      }

      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }

      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == MainFrame.this)
         {
            MainFrame.this.exitForm(evt);
         }
      }

      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }

      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }

      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }

      public void windowOpened(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == MainFrame.this)
         {
            MainFrame.this.formWindowOpened(evt);
         }
      }

      public void stateChanged(javax.swing.event.ChangeEvent evt)
      {
         if (evt.getSource() == jToggleButtonChartTool)
         {
            MainFrame.this.jToggleButtonChartToolStateChanged(evt);
         }
         else if (evt.getSource() == jTabbedPaneExplorer)
         {
            MainFrame.this.jTabbedPaneExplorerStateChanged(evt);
         }
      }

      public void valueChanged(javax.swing.event.TreeSelectionEvent evt)
      {
         if (evt.getSource() == jTreeFiles)
         {
            MainFrame.this.jTreeFilesValueChanged(evt);
         }
         else if (evt.getSource() == jTreeDocument)
         {
            MainFrame.this.jTreeDocumentValueChanged(evt);
         }
      }
   }//GEN-END:initComponents

   private void jRadioButtonMenuItemPreviewCSVActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonMenuItemPreviewCSVActionPerformed
   {//GEN-HEADEREND:event_jRadioButtonMenuItemPreviewCSVActionPerformed
      this.setReportViewer(IREPORT_CSV_VIEWER);
   }//GEN-LAST:event_jRadioButtonMenuItemPreviewCSVActionPerformed

   private void jRadioButtonMenuItemPreviewXLSActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonMenuItemPreviewXLSActionPerformed
   {//GEN-HEADEREND:event_jRadioButtonMenuItemPreviewXLSActionPerformed
      this.setReportViewer(IREPORT_XLS_VIEWER);
   }//GEN-LAST:event_jRadioButtonMenuItemPreviewXLSActionPerformed

   private void jRadioButtonMenuItemPreviewJAVAActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonMenuItemPreviewJAVAActionPerformed
   {//GEN-HEADEREND:event_jRadioButtonMenuItemPreviewJAVAActionPerformed
      this.setReportViewer(IREPORT_JAVA_VIEWER);
   }//GEN-LAST:event_jRadioButtonMenuItemPreviewJAVAActionPerformed

   private void jRadioButtonMenuItemPreviewHTMLActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jRadioButtonMenuItemPreviewHTMLActionPerformed
   {//GEN-HEADEREND:event_jRadioButtonMenuItemPreviewHTMLActionPerformed
      this.setReportViewer(IREPORT_HTML_VIEWER);
   }//GEN-LAST:event_jRadioButtonMenuItemPreviewHTMLActionPerformed
   
   private void jMenuItemQuitActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemQuitActionPerformed
   {//GEN-HEADEREND:event_jMenuItemQuitActionPerformed
      this.closeApplication();
   }//GEN-LAST:event_jMenuItemQuitActionPerformed
   
    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
       ExpressionEditor edit = new ExpressionEditor();
       edit.setVisible(true);
    }//GEN-LAST:event_jMenuItem1ActionPerformed
    
    private void jButtonAlignJustifyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAlignJustifyActionPerformed
       setElementsValue("setAlign", "Justify");
    }//GEN-LAST:event_jButtonAlignJustifyActionPerformed
    
    private void jButtonAlignRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAlignRightActionPerformed
       setElementsValue("setAlign", "Right");
    }//GEN-LAST:event_jButtonAlignRightActionPerformed
    
    private void jButtonAlignCenterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAlignCenterActionPerformed
       setElementsValue("setAlign", "Center");
    }//GEN-LAST:event_jButtonAlignCenterActionPerformed
    
    private void jButtonAlignLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonAlignLeftActionPerformed
       setElementsValue("setAlign", "Left");
    }//GEN-LAST:event_jButtonAlignLeftActionPerformed
    
    private void formWindowActivated(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowActivated
       // Checking for documents update outside iReport...
       
       if (!catchFormActivated) return;
       catchFormActivated = false;
       if (checkModifiedFielsThread == null || !checkModifiedFielsThread.isAlive())
       {
          checkModifiedFielsThread= new Thread( this );
          checkModifiedFielsThread.start();
       }
    }//GEN-LAST:event_formWindowActivated
    
    
    public void checkForModifiedFiles()
    {
       //if (!catchFormActivated) return;
       catchFormActivated = false;
       
       javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
       for (int i=0; i< frames.length; ++i)
       {
          if (frames[i]  instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)frames[i];
             if (jrf.getReport().getFilename() != null &&
             !jrf.getReport().getFilename().trim().equals(""))
             {
                long time = Misc.getLastWriteTime(jrf.getReport().getFilename());
                if (jrf.getReport().getLoadTime() < time )
                {
                   System.out.println("Trovato: "+jrf.getReport().getFilename());
                   
                   int res = javax.swing.JOptionPane.showConfirmDialog(null, jrf.getReport().getFilename()+"\n\nThis file has been modified outside iReport.Do you want reload it?","iReport",javax.swing.JOptionPane.INFORMATION_MESSAGE);
                   
                   
                   if (res == javax.swing.JOptionPane.OK_OPTION)
                   {
                      
                      String filename = jrf.getReport().getFilename();
                      Report report = new Report(filename);
                      report.setUsingMultiLineExpressions(this.isUsingMultiLineExpressions());
                      openNewReportWindow( report );
                      jrf.doDefaultCloseAction();
                      
                   }
                   else
                   {
                      jrf.getReport().setLoadTime(time);
                   }
                }
             }
          }
       }
       catchFormActivated = true;
    }
    
    /**
     *Used to determine if a save all is required.
     */
    public boolean isSaveAllRequired()
    {
       boolean ret = false;
       javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
       for (int i=0; i< frames.length; ++i)
       {
          if (frames[i]  instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)frames[i];
             Report checkMe = jrf.getReport();
             if( checkMe == null )
             {
                ret = ( ret || false );
             }
             else
             {
                ret = ( ret || checkMe.isModified() );
             }
             
          }//end if instance of JReportFrame
       }//end for frames
       return ret;
    }//end isSaveAllRequired
    
    private void jMenuItemXMLSourceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemXMLSourceActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          if (jrf.getReport().getFilename() == null ||
          jrf.getReport().getFilename().equals(""))
          {
             int res = javax.swing.JOptionPane.showConfirmDialog(this, "You must save your file before editing it with an external editor!\nSave it now ?","",javax.swing.JOptionPane.INFORMATION_MESSAGE);
             if (res == javax.swing.JOptionPane.OK_OPTION)
             {
                jMenuItemSaveActionPerformed(evt);
             }
             else
                return;
          }
          else
          {
             int res = javax.swing.JOptionPane.showConfirmDialog(this, "The document could have been modified!\nWould you like to save it before launching the external editor?","",javax.swing.JOptionPane.INFORMATION_MESSAGE);
             if (res == javax.swing.JOptionPane.OK_OPTION)
             {
                jMenuItemSaveActionPerformed(evt);
             }
          }
          if (jrf.getReport().getFilename() == null ||
          jrf.getReport().getFilename().equals("")) return;
          
          Runtime rt = Runtime.getRuntime();
          String editor = "notepad.exe";
          try
          {
             if (this.getProperties().getProperty("ExternalEditor")!=null)
                editor = (String)this.getProperties().getProperty("ExternalEditor");
             if (editor == null || editor.equals(""))
             {
                this.logOnConsole("Using notepad.exe as default editor!",false);
                editor = "notepad.exe";
             }
             
             rt.exec(editor+ " \"" +jrf.getReport().getFilename()+"\"");
          } catch (Exception ex)
          {
             javax.swing.JOptionPane.showMessageDialog(this, "An exception is occured executing:\n"+ editor+ " \"" +jrf.getReport().getFilename()+"\"","",javax.swing.JOptionPane.ERROR_MESSAGE);
          }
       }
    }//GEN-LAST:event_jMenuItemXMLSourceActionPerformed
    
    private void jMenuItemVSRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemVSRemoveActionPerformed
       formatMenuPerformed( OperationType.REMOVE_SPACE_V);
    }//GEN-LAST:event_jMenuItemVSRemoveActionPerformed
    
    private void jMenuItemVSDecreaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemVSDecreaseActionPerformed
       formatMenuPerformed( OperationType.DECREASE_SPACE_V);
    }//GEN-LAST:event_jMenuItemVSDecreaseActionPerformed
    
    private void jMenuItemVSMakeEqualActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemVSMakeEqualActionPerformed
       formatMenuPerformed( OperationType.EQUALS_SPACE_V);
    }//GEN-LAST:event_jMenuItemVSMakeEqualActionPerformed
    
    private void jMenuItemHSRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHSRemoveActionPerformed
       formatMenuPerformed( OperationType.REMOVE_SPACE_H);
    }//GEN-LAST:event_jMenuItemHSRemoveActionPerformed
    
    private void jMenuItemHSIncreaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHSIncreaseActionPerformed
       formatMenuPerformed( OperationType.INCREASE_SPACE_H);
    }//GEN-LAST:event_jMenuItemHSIncreaseActionPerformed
    
    private void jMenuItemHSMakeEqualActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHSMakeEqualActionPerformed
       formatMenuPerformed( OperationType.EQUALS_SPACE_H);
    }//GEN-LAST:event_jMenuItemHSMakeEqualActionPerformed
    
    private void jMenuItemJoinRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemJoinRightActionPerformed
       formatMenuPerformed( OperationType.JOIN_RIGHT);
    }//GEN-LAST:event_jMenuItemJoinRightActionPerformed
    
    private void jMenuItemJoinLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemJoinLeftActionPerformed
       formatMenuPerformed( OperationType.JOIN_LEFT);
    }//GEN-LAST:event_jMenuItemJoinLeftActionPerformed
    
    private void jMenuItemCenterBackgroundActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCenterBackgroundActionPerformed
       formatMenuPerformed( OperationType.CENTER_IN_BACKGROUND);
    }//GEN-LAST:event_jMenuItemCenterBackgroundActionPerformed
    
    private void jMenuItemCenterInBandActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCenterInBandActionPerformed
       formatMenuPerformed( OperationType.CENTER_IN_BAND);
    }//GEN-LAST:event_jMenuItemCenterInBandActionPerformed
    
    private void jMenuItemCenterVActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCenterVActionPerformed
       formatMenuPerformed( OperationType.CENTER_IN_BAND_V);
    }//GEN-LAST:event_jMenuItemCenterVActionPerformed
    
    private void jMenuItemCenterHActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCenterHActionPerformed
       formatMenuPerformed( OperationType.CENTER_IN_BAND_H);
    }//GEN-LAST:event_jMenuItemCenterHActionPerformed
    
    private void jMenuItemSameSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameSizeActionPerformed
       formatMenuPerformed( OperationType.SAME_SIZE);
    }//GEN-LAST:event_jMenuItemSameSizeActionPerformed
    
    private void jMenuItemSameHeightMaxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameHeightMaxActionPerformed
       formatMenuPerformed( OperationType.SAME_HEIGHT_MAX);
    }//GEN-LAST:event_jMenuItemSameHeightMaxActionPerformed
    
    private void jMenuItemSameHeightMinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameHeightMinActionPerformed
       formatMenuPerformed( OperationType.SAME_HEIGHT_MIN);
    }//GEN-LAST:event_jMenuItemSameHeightMinActionPerformed
    
    private void jMenuItemSameHeightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameHeightActionPerformed
       formatMenuPerformed( OperationType.SAME_HEIGHT);
    }//GEN-LAST:event_jMenuItemSameHeightActionPerformed
    
    private void jMenuItemSameWidthMinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameWidthMinActionPerformed
       formatMenuPerformed( OperationType.SAME_WIDTH_MIN);
    }//GEN-LAST:event_jMenuItemSameWidthMinActionPerformed
    
    private void jMenuItemSameWidthMaxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameWidthMaxActionPerformed
       formatMenuPerformed( OperationType.SAME_WIDTH_MAX);
    }//GEN-LAST:event_jMenuItemSameWidthMaxActionPerformed
    
    private void jMenuItemSameWidthActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSameWidthActionPerformed
       formatMenuPerformed( OperationType.SAME_WIDTH);
    }//GEN-LAST:event_jMenuItemSameWidthActionPerformed
    
    private void jMenuItemAlignToBandBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignToBandBottomActionPerformed
       formatMenuPerformed( OperationType.ALIGN_BOTTOM_TO_BAND);
    }//GEN-LAST:event_jMenuItemAlignToBandBottomActionPerformed
    
    private void jMenuItemAlignToBandTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignToBandTopActionPerformed
       formatMenuPerformed( OperationType.ALIGN_TOP_TO_BAND);
    }//GEN-LAST:event_jMenuItemAlignToBandTopActionPerformed
    
    private void jMenuItemAlignHorizontalAxisActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignHorizontalAxisActionPerformed
       formatMenuPerformed( OperationType.ALIGN_HORIZONTAL_AXIS);
    }//GEN-LAST:event_jMenuItemAlignHorizontalAxisActionPerformed
    
    private void jMenuItemAlignVerticalAxisActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignVerticalAxisActionPerformed
       formatMenuPerformed( OperationType.ALIGN_VERTICAL_AXIS);
    }//GEN-LAST:event_jMenuItemAlignVerticalAxisActionPerformed
    
    private void jMenuItemAlignBottomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignBottomActionPerformed
       formatMenuPerformed( OperationType.ALIGN_BOTTOM);
    }//GEN-LAST:event_jMenuItemAlignBottomActionPerformed
    
    private void jMenuItemAlignTopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignTopActionPerformed
       formatMenuPerformed( OperationType.ALIGN_TOP);
    }//GEN-LAST:event_jMenuItemAlignTopActionPerformed
    
    private void jMenuItemAlignRightActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignRightActionPerformed
       formatMenuPerformed( OperationType.ALIGN_RIGHT);
    }//GEN-LAST:event_jMenuItemAlignRightActionPerformed
    
    public void formatMenuPerformed(int operationType)
    {
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.makeOperation( operationType );
          if (jrf.getSelectedElements().size()>0)
             updateDocumentStructureTree(jrf);
       }
    }
    
    private void jMenuItemAlignLeftActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAlignLeftActionPerformed
       // Align all element to left....
       formatMenuPerformed( OperationType.ALIGN_LEFT);
    }//GEN-LAST:event_jMenuItemAlignLeftActionPerformed
    
    private void jRadioButtonMenuItemPreviewInternalViewerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemPreviewInternalViewerActionPerformed
      this.setReportViewer(IREPORT_JASPER_VIEWER);
    }//GEN-LAST:event_jRadioButtonMenuItemPreviewInternalViewerActionPerformed
    
    private void jMenuItemSendToBackActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSendToBackActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.sendToBack();
          if (jrf.getSelectedElements().size()>0)
             updateDocumentStructureTree(jrf);
       }
    }//GEN-LAST:event_jMenuItemSendToBackActionPerformed
    
    private void jMenuItemBringToFrontActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemBringToFrontActionPerformed
       
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.bringToFront();
          if (jrf.getSelectedElements().size()>0)
             updateDocumentStructureTree(jrf);
       }
    }//GEN-LAST:event_jMenuItemBringToFrontActionPerformed
    
    private void jMenuItemWizardActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemWizardActionPerformed
       
       if (this.getProperties().get("DefaultConnection") == null ||
       !( this.getProperties().get("DefaultConnection") instanceof it.businesslogic.ireport.connection.JDBCConnection) )
       {
          javax.swing.JOptionPane.showMessageDialog(this, "Before start the Wizard, you must configure a JDBC connection\nand set it the active connection.\n\nIf you have already created and tested a JDBC connection go to the menu\nbuild->set active connection and select your entry.\nIf you have not yet setup a JDBC connection go to\nDatasources->Connection/Datasources to create one.","",javax.swing.JOptionPane.ERROR_MESSAGE);
          return;
       }
       
       WizardDialog wd = new WizardDialog(this,true);
       wd.show();
       if (wd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
       {
          Report report = wd.getReport();
          if (report != null)
          {
             // Name the report...
             
             openNewReportWindow(report);
          }
       }
       
    }//GEN-LAST:event_jMenuItemWizardActionPerformed
    
    private void jMenuItemReportPropertiesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReportPropertiesActionPerformed
       
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          ReportPropertiesFrame rpf = new ReportPropertiesFrame();
          rpf.setModal(true);
          
          rpf.setBottomMargin( jrf.getReport().getBottomMargin());
          rpf.setColumns( jrf.getReport().getColumnCount());
          rpf.setColumnsSpacing( jrf.getReport().getColumnSpacing());
          rpf.setColumnsWidth( jrf.getReport().getColumnWidth());
          //rpf.setGlobalUnit( jrf.getReport().getGlobalUnit());
          rpf.setLeftMargin(jrf.getReport().getLeftMargin());
          rpf.setOrientation( jrf.getReport().getOrientation());
          rpf.setPrintOrder( jrf.getReport().getPrintOrder());
          rpf.setReportFormat( jrf.getReport().getReportFormat());
          rpf.setReportHeight( jrf.getReport().getHeight());
          rpf.setReportName( jrf.getReport().getName());
          rpf.setReportWidth( jrf.getReport().getWidth());
          rpf.setRightMargin( jrf.getReport().getRightMargin());
          rpf.setScriptletClass( jrf.getReport().getScriptletClass());
          rpf.setSummaryOnNewPage( jrf.getReport().isIsSummaryNewPage());
          rpf.setTitleOnNewPage(jrf.getReport().isIsTitleNewPage());
          rpf.setTopMargin( jrf.getReport().getTopMargin());
          rpf.setWhenNoDataType( jrf.getReport().getWhenNoDataType());
          rpf.setXmlEncoding( jrf.getReport().getEncoding());
          
          System.out.println("Il nome :"+rpf.getReportName()+" (old)");
          rpf.show();
          if (rpf.getDialogResult() == JOptionPane.OK_OPTION)
          {
             // Change report...
             jrf.getReport().setDirty(true);
             //javax.swing.JOptionPane.showMessageDialog(null,""+rpf.getReportName());
             // First all fields that don't modify layout...
             jrf.getReport().setWidth(rpf.getReportWidth());
             jrf.getReport().setHeight(rpf.getReportHeight());
             jrf.getReport().setOrientation(rpf.getOrientation());
             jrf.getReport().setName(rpf.getReportName());
             int oldTop = jrf.getReport().getTopMargin();
             jrf.getReport().setTopMargin(rpf.getTopMargin());
             int differenceY = jrf.getReport().getTopMargin() - oldTop;
             
             
             
             
             int oldLeft = jrf.getReport().getLeftMargin();
             jrf.getReport().setLeftMargin(rpf.getLeftMargin());
             int differenceX = jrf.getReport().getLeftMargin() - oldLeft;
             if (differenceX != 0 || differenceY != 0)
             {
                Enumeration enum = jrf.getReport().getElements().elements();
                while (enum.hasMoreElements())
                {
                   ReportElement re = (ReportElement)enum.nextElement();
                   re.trasform(new java.awt.Point(differenceX,differenceY), TransformationType.TRANSFORMATION_MOVE);
                }
             }
             
             jrf.getReport().setRightMargin(rpf.getRightMargin());
             jrf.getReport().setBottomMargin(rpf.getBottomMargin());
             jrf.getReport().setColumnCount(rpf.getColumns());
             jrf.getReport().setColumnWidth(rpf.getColumnsWidth());
             jrf.getReport().setColumnSpacing(rpf.getColumnsSpacing());
             jrf.getReport().setIsSummaryNewPage(rpf.isSummaryOnNewPage());
             jrf.getReport().setIsTitleNewPage(rpf.isTitleOnNewPage());
             jrf.getReport().setWhenNoDataType(rpf.getWhenNoDataType());
             jrf.getReport().setScriptletClass(rpf.getScriptletClass());
             jrf.getReport().setEncoding(rpf.getXmlEncoding());
             jrf.getReport().setPrintOrder(rpf.getPrintOrder());
             jrf.getReport().setReportFormat(rpf.getReportFormat());
             
             this.setTitle(constTitle + " ["+ jrf.getReport().getName() + " "+ jrf.getReport().getWidth()+"x"+jrf.getReport().getHeight()+" "+jrf.getReport().getFilename()+" ]");
             jrf.updateTitle();
             // Aggiorniamo il menu attivo...
             java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
             int frame = 0;
             for (int k = 0;  k<menus.length ; ++k)
             {
                //javax.swing.JOptionPane.showMessageDialog(this,"Menu: " + menus[k] );
                
                
                if (menus[k] instanceof JRadioButtonMenuItemMDIFrame)
                {
                   frame++;
                   
                   JRadioButtonMenuItemMDIFrame mri = (JRadioButtonMenuItemMDIFrame)menus[k];
                   //((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jrf)
                   if ( mri.isSelected() )
                   {
                      //javax.swing.JOptionPane.showMessageDialog( this, "Selected" + frame +" "+text);
                      mri.setText(frame + ". " + jrf.getTitle());
                      break;
                   }
                }
             }
             
             
             jrf.setIsDocDirty(true);
             jrf.getJPanelReport().repaint();
          }
       }
    }//GEN-LAST:event_jMenuItemReportPropertiesActionPerformed
    
    private void jMenuItemGroupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemGroupsActionPerformed
       jButtonGroupsActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemGroupsActionPerformed
    
    private void jMenuItemBandsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemBandsActionPerformed
       jButtonBandsActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemBandsActionPerformed
    
    private void jMenuItemElementsBrowserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemElementsBrowserActionPerformed
       this.jTabbedPaneExplorer.setSelectedComponent(jPanelDocumentStructure );
    }//GEN-LAST:event_jMenuItemElementsBrowserActionPerformed
    
    private void jMenuItemElementPropertiesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemElementPropertiesActionPerformed
       this.getElementPropertiesDialog().setVisible(true);
       this.getElementPropertiesDialog().updateSelection();
    }//GEN-LAST:event_jMenuItemElementPropertiesActionPerformed
    
    private void jMenuItemParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemParametersActionPerformed
       jButtonParametersActionPerformed(evt);
       this.getValuesDialog().gotoTab("Parameters");
    }//GEN-LAST:event_jMenuItemParametersActionPerformed
    
    private void jMenuItemVariablesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemVariablesActionPerformed
       jButtonParametersActionPerformed(evt);
       this.getValuesDialog().gotoTab("Variables");
    }//GEN-LAST:event_jMenuItemVariablesActionPerformed
    
    private void jMenuItemFieldsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemFieldsActionPerformed
       jButtonParametersActionPerformed(evt);
       this.getValuesDialog().gotoTab("Fields");
    }//GEN-LAST:event_jMenuItemFieldsActionPerformed
    
    private void jMenuItemReportQueryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReportQueryActionPerformed
       jButtonDatabaseActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemReportQueryActionPerformed
    
    private void jMenuItemExecuteDBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemExecuteDBActionPerformed
       jButtonRun2ActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemExecuteDBActionPerformed
    
    private void jMenuItemExecuteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemExecuteActionPerformed
       jButtonRun1ActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemExecuteActionPerformed
    
    private void jButtonPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonPasteActionPerformed
       jMenuItemPasteActionPerformed(evt);
    }//GEN-LAST:event_jButtonPasteActionPerformed
    
    private void jButtonCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCopyActionPerformed
       jMenuItemCopyActionPerformed(evt);
    }//GEN-LAST:event_jButtonCopyActionPerformed
    
    private void jButtonCutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCutActionPerformed
       jMenuItemCutActionPerformed(evt);
    }//GEN-LAST:event_jButtonCutActionPerformed
    
    private void jMenuItemPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemPasteActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.paste();
       }
    }//GEN-LAST:event_jMenuItemPasteActionPerformed
    
    private void jMenuItemCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCopyActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.copy();
          if (getClipBoard().size()>0)
          {
             this.jMenuItemPaste.setEnabled(true);
             this.jButtonPaste.setEnabled(true);
          }
          else
          {
             this.jMenuItemPaste.setEnabled(false);
             this.jButtonPaste.setEnabled(false);
          }
       }
    }//GEN-LAST:event_jMenuItemCopyActionPerformed
    
    private void jMenuItemCutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCutActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.cut();
       }
    }//GEN-LAST:event_jMenuItemCutActionPerformed
    
    private void jButtonRun2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRun2ActionPerformed
       
       // 1. Get active report...
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          if (Misc.nvl(this.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"))
             jMenuItemSaveActionPerformed(new java.awt.event.ActionEvent(jMenuItemSave,0,"Save"));
          //1. Save the report if needed....
          if (jrf.getReport().isDirty() ||
          jrf.getReport().getFilename() == null ||
          jrf.getReport().getFilename().trim().equals(""))
          {
             this.logOnConsole("Action aborted by user.\n");
             return;
          }
          
          this.jEditorPaneOutput.setContentType("text/html");
          outputBuffer.setLength(0);
          logOnConsole("");
          //1. Compile....
          IReportCompiler ic = new IReportCompiler();
          ic.setCommand( IReportCompiler.CMD_COMPILE | IReportCompiler.CMD_EXPORT);
          HashMap hm = new HashMap();
          hm.put( ic.USE_EMPTY_DATASOURCE, "false");
          IReportConnection connection = (IReportConnection)this.getProperties().get("DefaultConnection");
          
          
          //if (connection instanceof  it.businesslogic.ireport.connection.JDBCConnection)
          //{
          //    javax.swing.JOptionPane.showMessageDialog(null, ((it.businesslogic.ireport.connection.JDBCConnection)connection).getJDBCDriver());
          //}
          
          hm.put( ic.USE_CONNECTION, "true");
          hm.put( ic.CONNECTION, connection);
          
          if (jRadioButtonMenuItemPreviewCSV.isSelected()) hm.put( ic.OUTPUT_FORMAT, "csv");
          else if (jRadioButtonMenuItemPreviewHTML.isSelected()) hm.put( ic.OUTPUT_FORMAT, "html");
          else if (jRadioButtonMenuItemPreviewXLS.isSelected()) hm.put( ic.OUTPUT_FORMAT, "xls");
          //else if (jRadioButtonMenuItemPreviewJAVA.isSelected()) hm.put( ic.OUTPUT_FORMAT, "java");
          else if (jRadioButtonMenuItemPreviewInternalViewer.isSelected()) hm.put( ic.OUTPUT_FORMAT, "jrviewer");
          else
             hm.put( ic.OUTPUT_FORMAT, "pdf");
          
          ic.setProperties(hm);
          ic.setJrf(jrf);
          ic.setMainFrame(this);
          
          ic.start();
       }
    }//GEN-LAST:event_jButtonRun2ActionPerformed
    
    private void jMenuItemDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteActionPerformed
       
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          
          jrf.deleteSelectedElements();
       }
       
    }//GEN-LAST:event_jMenuItemDeleteActionPerformed
    
    private void jMenuItemRedoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRedoActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          
          jrf.redo();
          this.updateUndoMenu(jrf);
       }
    }//GEN-LAST:event_jMenuItemRedoActionPerformed
    
    private void jMenuItemUndoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemUndoActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          
          jrf.undo();
          this.updateUndoMenu(jrf);
       }
    }//GEN-LAST:event_jMenuItemUndoActionPerformed
    
    private void jTreeDocumentValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_jTreeDocumentValueChanged
       
       if (dontHandleEvent) return;
       
       // Get active jrf...
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          //dontHandleEvent = true;
          try
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             Vector elementsToSelect = new Vector();
             
             TreePath[] path = jTreeDocument.getSelectionPaths();
             
             
             for (int i=0; i<path.length; ++i)
             {
                DefaultMutableTreeNode elementNode = (DefaultMutableTreeNode)path[i].getLastPathComponent();
                if (elementNode.getUserObject() instanceof ReportElement)
                {
                   elementsToSelect.addElement( (ReportElement)elementNode.getUserObject());
                   
                }
                else if (path.length == 1)
                {
                   jrf.setSelectedElement(null);
                   return;
                }
             }
             
             jrf.setSelectedElement(null);
             Enumeration enum = elementsToSelect.elements();
             while (enum.hasMoreElements())
             {
                jrf.addSelectedElement((ReportElement)enum.nextElement());
             }
          } catch (Exception ex)
          {}
          //
       }
       
    }//GEN-LAST:event_jTreeDocumentValueChanged
    
    private void jTreeFilesValueChanged(javax.swing.event.TreeSelectionEvent evt) {//GEN-FIRST:event_jTreeFilesValueChanged
       // Select all selected elements...
       
       
    }//GEN-LAST:event_jTreeFilesValueChanged
    
    private void jMenuItemAboutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemAboutActionPerformed
       IReportAbout ra = new IReportAbout(this, true);
       ra.show();
    }//GEN-LAST:event_jMenuItemAboutActionPerformed
    
    private void jButtonRun1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonRun1ActionPerformed
       
       // 1. Get active report...
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          if (Misc.nvl(this.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"))
             jMenuItemSaveActionPerformed(new java.awt.event.ActionEvent(jMenuItemSave,0,"Save"));
          //1. Save the report if needed....
          if (jrf.getReport().isDirty() ||
          jrf.getReport().getFilename() == null ||
          jrf.getReport().getFilename().trim().equals(""))
          {
             this.logOnConsole("Action aborted by user.\n");
             return;
          }
          
          this.jEditorPaneOutput.setContentType("text/html");
          outputBuffer.setLength(0);
          logOnConsole("");
          //1. Compile....
          IReportCompiler ic = new IReportCompiler();
          ic.setCommand( IReportCompiler.CMD_COMPILE | IReportCompiler.CMD_EXPORT);
          HashMap hm = new HashMap();
          hm.put( ic.USE_EMPTY_DATASOURCE, "true");
          
          if (jRadioButtonMenuItemPreviewCSV.isSelected()) hm.put( ic.OUTPUT_FORMAT, "csv");
          else if (jRadioButtonMenuItemPreviewHTML.isSelected()) hm.put( ic.OUTPUT_FORMAT, "html");
          else if (jRadioButtonMenuItemPreviewXLS.isSelected()) hm.put( ic.OUTPUT_FORMAT, "xls");
          //else if (jRadioButtonMenuItemPreviewJAVA.isSelected()) hm.put( ic.OUTPUT_FORMAT, "java");
          else if (jRadioButtonMenuItemPreviewInternalViewer.isSelected()) hm.put( ic.OUTPUT_FORMAT, "jrviewer");
          else
             hm.put( ic.OUTPUT_FORMAT, "pdf");
          
          ic.setProperties(hm);
          ic.setJrf(jrf);
          ic.setMainFrame(this);
          
          ic.start();
       }
    }//GEN-LAST:event_jButtonRun1ActionPerformed
    
    private void jMenuItemPrevWinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemPrevWinActionPerformed
       // Remove all menus...
       java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
       int firstFrame = -1;
       for (int k = 0;  k<menus.length ; ++k)
       {
          if (menus[k] instanceof JRadioButtonMenuItemMDIFrame)
          {
             if (firstFrame == -1) firstFrame = k;
             if ( ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jMDIDesktopPane.getSelectedFrame())
             {
                // The next if exists, is the right menu..
                k--;
                if (k>=firstFrame && menus[k] instanceof JRadioButtonMenuItemMDIFrame)
                {
                   try
                   {
                      ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().setSelected(true);
                   } catch (Exception ex)
                   {}
                }
                else if (menus[menus.length-1] instanceof JRadioButtonMenuItemMDIFrame)
                {
                   try
                   {
                      ((JRadioButtonMenuItemMDIFrame)menus[menus.length-1]).getFrame().setSelected(true);
                   } catch (Exception ex)
                   {}
                }
                return;
             }
          }
       }
    }//GEN-LAST:event_jMenuItemPrevWinActionPerformed
    
    private void jMenuItemNextWinActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNextWinActionPerformed
       
       
       // Remove all menus...
       java.awt.Component[] menus = this.jMenuWindow.getMenuComponents();
       int firstFrame = -1;
       for (int k = 0;  k<menus.length ; ++k)
       {
          if (menus[k] instanceof JRadioButtonMenuItemMDIFrame)
          {
             if (firstFrame == -1) firstFrame = k;
             if ( ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame() == jMDIDesktopPane.getSelectedFrame())
             {
                // The next if exists, is the right menu..
                k++;
                if (k<menus.length && menus[k] instanceof JRadioButtonMenuItemMDIFrame)
                {
                   try
                   {
                      ((JRadioButtonMenuItemMDIFrame)menus[k]).getFrame().setSelected(true);
                   } catch (Exception ex)
                   {}
                }
                else if (firstFrame != -1)
                {
                   try
                   {
                      ((JRadioButtonMenuItemMDIFrame)menus[firstFrame]).getFrame().setSelected(true);
                   } catch (Exception ex)
                   {}
                }
                return;
             }
          }
       }
       
        /*
        JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
        if (frames.length < 2) return;
        for (int i=0; i<frames.length; ++i)
        {
            if (frames[i] == jMDIDesktopPane.getSelectedFrame())
            {
                i++;
                if (i == frames.length) i=0;
                try {
                frames[i].setSelected(true);
                } catch (Exception ex){}
                return;
            }
        }
         */
       
    }//GEN-LAST:event_jMenuItemNextWinActionPerformed
    
    private void jMenuItemtileAnodineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemtileAnodineActionPerformed
       jMDIDesktopPane.tileAnodine();
    }//GEN-LAST:event_jMenuItemtileAnodineActionPerformed
    
    private void jMenuItemTileVerticalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemTileVerticalActionPerformed
       jMDIDesktopPane.tileVertically();
    }//GEN-LAST:event_jMenuItemTileVerticalActionPerformed
    
    private void jMenuItemTileHorizontalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemTileHorizontalActionPerformed
       jMDIDesktopPane.tileHorizontally();
    }//GEN-LAST:event_jMenuItemTileHorizontalActionPerformed
    
    private void jMenuItemCascadeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCascadeActionPerformed
       // Dispose all frames in cascade....
       // The active frame must be the last....
       jMDIDesktopPane.cascade();
    }//GEN-LAST:event_jMenuItemCascadeActionPerformed
    
    private void jRadioButtonMenuItemPreviewPDFActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButtonMenuItemPreviewPDFActionPerformed
      this.setReportViewer(IREPORT_PDF_VIEWER);
    }//GEN-LAST:event_jRadioButtonMenuItemPreviewPDFActionPerformed
    
    private void jTreeFilesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTreeFilesMouseClicked
       if (evt.getClickCount() == 2 && evt.getButton() == java.awt.event.MouseEvent.BUTTON1)
       {
          TreePath path = jTreeFiles.getSelectionPath();
          if (path == null) return;
          TreeNode node = (TreeNode)path.getLastPathComponent();
          if (node instanceof DefaultMutableTreeNode)
          {
             DefaultMutableTreeNode nodem = (DefaultMutableTreeNode)node;
             Object obj = nodem.getUserObject();
             if (obj != null && obj instanceof DocumentTreeEntry)
             {
                DocumentTreeEntry dtn = (DocumentTreeEntry)obj;
                if (dtn.getJrf() != null)
                {
                   //
                   try
                   {
                      dtn.getJrf().setSelected(true);
                   } catch (Exception ex)
                   {};
                   //dtn.getJrf().updateUI();
                   //jMDIDesktopPane.internalFrameActivated(dtn.getJrf());
                   //this.logOnConsole("Activated :"+dtn.getJrf().getReport().getFilename()+"\n");
                }
             }
          }
       }
       else System.out.println("Mouse clicked...");
       
       
    }//GEN-LAST:event_jTreeFilesMouseClicked
    
    private void jMenuItemFontsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemFontsActionPerformed
       this.fontsDialog.setVisible(true);
    }//GEN-LAST:event_jMenuItemFontsActionPerformed
    
    private void jMenuItemActiveConnectionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemActiveConnectionActionPerformed
       ActiveConnectionDialog acd = new ActiveConnectionDialog(this, true);
       acd.show();
       if (acd.getDialogResult() == JOptionPane.OK_OPTION)
       {
          this.getProperties().put( "DefaultConnection",acd.getIReportConnection());
          
          this.saveiReportConfiguration();
          
       }
    }//GEN-LAST:event_jMenuItemActiveConnectionActionPerformed
    
    private void jTabbedPaneExplorerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jTabbedPaneExplorerStateChanged
       if (jTabbedPaneExplorer.getSelectedComponent() instanceof ProjectPane)
       {
          jMenuItemCloseProject.setEnabled(true);
       }
       else
       {
          jMenuItemCloseProject.setEnabled(false);
       }
    }//GEN-LAST:event_jTabbedPaneExplorerStateChanged
    
    private void jMenuItemCloseProjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCloseProjectActionPerformed
       // Close the active project...
       if (jTabbedPaneExplorer.getSelectedComponent() instanceof ProjectPane)
       {
          // ProjectPane.close();
          jTabbedPaneExplorer.remove(jTabbedPaneExplorer.getSelectedComponent());
       }
       
       
    }//GEN-LAST:event_jMenuItemCloseProjectActionPerformed
    
    private void jMenuItemNewProjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewProjectActionPerformed
       
       ProjectDialog pd = new ProjectDialog(this, true);
       pd.show();
       if (pd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
       {
          /* Code to handle the new project... */
          ProjectInfo pi = new ProjectInfo();
          pi.setName( pd.getProjectName() );
          pi.setSourcesDir( pd.getSourcesDir() );
          pi.setOutputDir( pd.getOutputDir() );
          pi.setConnection( pd.getConnection() );
          ProjectPane pp = new ProjectPane(pi);
          this.jTabbedPaneExplorer.addTab("Project "+pi, pp);
          this.jTabbedPaneExplorer.setSelectedComponent(pp);
       }
    }//GEN-LAST:event_jMenuItemNewProjectActionPerformed
    
    private void jToggleButtonChartToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonChartToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.CHART_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonChartTool);
       }
    }//GEN-LAST:event_jToggleButtonChartToolItemStateChanged
    
    private void jToggleButtonChartToolStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jToggleButtonChartToolStateChanged
       
       
    }//GEN-LAST:event_jToggleButtonChartToolStateChanged
    
    private void jMenuItemConnectionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemConnectionsActionPerformed
       ConnectionsDialog cd = new ConnectionsDialog(this,true);
       cd.show();
    }//GEN-LAST:event_jMenuItemConnectionsActionPerformed
    
    private void jMenuItemReportQuery2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemReportQuery2ActionPerformed
       this.jButtonDatabaseActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemReportQuery2ActionPerformed
    
    private void jMenuItemCompatibilityActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCompatibilityActionPerformed
       CompatibilityDialog cd = new CompatibilityDialog(this,true);
       cd.show();
    }//GEN-LAST:event_jMenuItemCompatibilityActionPerformed
    
    private void jMenuItemOptionsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOptionsActionPerformed
       OptionsDialog od = new OptionsDialog(this,true);
       od.loadConfiguration();
       od.show();
    }//GEN-LAST:event_jMenuItemOptionsActionPerformed
    
    private void jCheckBoxMenuItemOutputActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemOutputActionPerformed
       if (jCheckBoxMenuItemOutput.isSelected())
       {
          jSplitPaneV.add("bottom", jPanelSouth );
          jSplitPaneV.setDividerSize(8);
       }
       else
       {
          jSplitPaneV.remove( jPanelSouth);
          jSplitPaneV.setDividerSize(0);
       }
       
    }//GEN-LAST:event_jCheckBoxMenuItemOutputActionPerformed
    
    private void jCheckBoxMenuItemExplorerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemExplorerActionPerformed
       if (jCheckBoxMenuItemExplorer.isSelected())
       {
          jSplitPaneHorizontal.add("left", jTabbedPaneExplorer);
          jSplitPaneHorizontal.setDividerSize(8);
       }
       else
       {
          jSplitPaneHorizontal.remove( jTabbedPaneExplorer);
          jSplitPaneHorizontal.setDividerSize(0);
       }
    }//GEN-LAST:event_jCheckBoxMenuItemExplorerActionPerformed
    
    private void jMenuItemHSDecreaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemHSDecreaseActionPerformed
       formatMenuPerformed( OperationType.DECREASE_SPACE_H);
    }//GEN-LAST:event_jMenuItemHSDecreaseActionPerformed
    
    private void jMenuItemVSIncreaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemVSIncreaseActionPerformed
       formatMenuPerformed( OperationType.INCREASE_SPACE_V);
    }//GEN-LAST:event_jMenuItemVSIncreaseActionPerformed
    
    private void jButtonDatabaseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDatabaseActionPerformed
       this.getReportQueryDialog().setVisible(true);
    }//GEN-LAST:event_jButtonDatabaseActionPerformed
    
    private void jMenuItemSaveAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveAllActionPerformed
       javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
       for (int i=0; i< frames.length; ++i)
       {
          if (frames[i]  instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)frames[i];
             if (jrf.getReport().getFilename() == null ||
             jrf.getReport().getFilename().trim().equals(""))
             {
                // Choose a file name....
                javax.swing.JFileChooser jfc = new javax.swing.JFileChooser(getCurrentDirectory());
                
                
                
                jfc.setDialogTitle("Save report as XML jasperreports file....");
                jfc.setFileFilter( new javax.swing.filechooser.FileFilter()
                {
                   public boolean accept(java.io.File file)
                   {
                      String filename = file.getName();
                      return (filename.endsWith(".xml") || file.isDirectory()) ;
                   }
                   public String getDescription()
                   {
                      return "JasperReports XML *.xml";
                   }
                });
                
                
                jfc.setMultiSelectionEnabled(false);
                
                jfc.setDialogType( javax.swing.JFileChooser.SAVE_DIALOG);
                if  (jfc.showSaveDialog(this) != javax.swing.JOptionPane.OK_OPTION)
                {
                   //if we saved or didn't save the current file
                   javax.swing.JInternalFrame current = jMDIDesktopPane.getSelectedFrame();
                   if( current instanceof JReportFrame )
                   {
                      JReportFrame crf = (JReportFrame)current;
                      if( crf.getReport().isModified() )
                      {
                         this.enableSaveSpecific();
                      }
                      else
                      {
                         this.disableSaveSpecific();
                      }
                   }
                   return;
                }
                setCurrentDirectory( jfc.getSelectedFile(), true);
                jrf.getReport().setFilename( jfc.getSelectedFile().getPath());
             }
             
             //saveBackup( jrf.getReport().getFilename());
             jrf.getReport().saveXMLFile();
             jrf.getReport().setModified(false);
             //this.addToRecentFileList(rp.filename);
             //saveProperties();
             //this.updateRecentFileList();
          }//end if instance of
       }//end for loop frames
       this.disableSaveAllSpecific();
       this.disableSaveSpecific();
    }//GEN-LAST:event_jMenuItemSaveAllActionPerformed
    
    private void jMenuItemSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveAsActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          // Choose a new file name....
          javax.swing.JFileChooser jfc = new javax.swing.JFileChooser(getCurrentDirectory());
          jfc.setDialogTitle("Save report as XML jasperreports file as....");
          jfc.setFileFilter( new javax.swing.filechooser.FileFilter()
          {
             public boolean accept(java.io.File file)
             {
                String filename = file.getName();
                return (filename.endsWith(".xml") || file.isDirectory()) ;
             }
             public String getDescription()
             {
                return "JasperReports XML *.xml";
             }
          });
          jfc.setMultiSelectionEnabled(false);
          
          jfc.setDialogType( javax.swing.JFileChooser.SAVE_DIALOG);
          if  (jfc.showSaveDialog( null) != javax.swing.JOptionPane.OK_OPTION) return;
          setCurrentDirectory( jfc.getSelectedFile(), true);
          String f = jfc.getSelectedFile().getPath();
          jrf.getReport().setFilename( (f.endsWith(".xml")?f:f+".xml") );
          
          //saveBackup( jrf.getReport().getFilename());
          jrf.getReport().saveXMLFile();
          jrf.getReport().setModified(false);
          jrf.updateTitle();	
	  updateMenuWindowList();
   	  setActiveReportForm(jrf);
          this.disableSaveSpecific();
          if(this.isSaveAllRequired())
          {
             this.enableSaveAllSpecific();
          }
          else
          {
             this.disableSaveAllSpecific();
          }
          recentFilesList.insertElementAt(jrf.getReport().getFilename(),0);
          this.updateRecentFileMenu(jMenuRecentFiles, recentFilesList );
          saveFileList(recentFilesList, "recentFiles.xml");
//          this.addToRecentFileList(rp.filename);
          //saveProperties();
          //this.updateRecentFileList();
       }
    }//GEN-LAST:event_jMenuItemSaveAsActionPerformed
  
    private void jButtonOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOpenActionPerformed
       this.jMenuItemOpenActionPerformed(evt);
    }//GEN-LAST:event_jButtonOpenActionPerformed
    
    private void jButtonCompilerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCompilerActionPerformed
       // 1. Get active report...
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          if (Misc.nvl(this.getProperties().getProperty("SaveBeforeCompiling"), "true").equals("true"))
             jMenuItemSaveActionPerformed(new java.awt.event.ActionEvent(jMenuItemSave,0,"Save"));
          //1. Save the report if needed....
          if (jrf.getReport().isDirty() ||
          jrf.getReport().getFilename() == null ||
          jrf.getReport().getFilename().trim().equals(""))
          {
             this.logOnConsole("Action aborted by user.\n");
             return;
          }
          
          this.jEditorPaneOutput.setContentType("text/html");
          outputBuffer.setLength(0);
          logOnConsole("");
          //1. Compile....
          IReportCompiler ic = new IReportCompiler();
          ic.setCommand( IReportCompiler.CMD_COMPILE);
          ic.setJrf(jrf);
          ic.setMainFrame(this);
          ic.start();
       }
       
       
    }//GEN-LAST:event_jButtonCompilerActionPerformed
    
    private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveActionPerformed
       jMenuItemSaveActionPerformed(evt);
    }//GEN-LAST:event_jButtonSaveActionPerformed
    
    private void jMenuItemSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSaveActionPerformed
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          if (jrf.getReport().getFilename() == null ||
          jrf.getReport().getFilename().trim().equals(""))
          {
             // Choose a file name....
             javax.swing.JFileChooser jfc = new javax.swing.JFileChooser(getCurrentDirectory());
             jfc.setDialogTitle("Save report as XML jasperreports file....");
             jfc.setFileFilter( new javax.swing.filechooser.FileFilter()
             {
                public boolean accept(java.io.File file)
                {
                   String filename = file.getName();
                   return (filename.endsWith(".xml") || file.isDirectory()) ;
                }
                public String getDescription()
                {
                   return "JasperReports XML *.xml";
                }
             });
             
             jfc.setMultiSelectionEnabled(false);
             
             jfc.setDialogType( javax.swing.JFileChooser.SAVE_DIALOG);
             if  (jfc.showSaveDialog( null) != javax.swing.JOptionPane.OK_OPTION) return;
             setCurrentDirectory( jfc.getSelectedFile(), true);
             String f = jfc.getSelectedFile().getPath();
             jrf.getReport().setFilename( (f.endsWith(".xml")?f:f+".xml") );
             recentFilesList.insertElementAt(jrf.getReport().getFilename(),0);
             this.updateRecentFileMenu(jMenuRecentFiles, recentFilesList );
             saveFileList(recentFilesList, "recentFiles.xml");
          }
          
          saveBackup( jrf.getReport().getFilename());
          jrf.getReport().saveXMLFile();
          jrf.getReport().setDirty(false);
          jrf.getReport().setModified(false);
          this.disableSaveSpecific();
          if(this.isSaveAllRequired())
          {
             this.enableSaveAllSpecific();
          }
          else
          {
             this.disableSaveAllSpecific();
          }
          //this.addToRecentFileList(rp.filename);
          //saveProperties();
          //this.updateRecentFileList();
          
       }
    }//GEN-LAST:event_jMenuItemSaveActionPerformed
    
    private void jCheckBoxMenuItemSnapToGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemSnapToGridActionPerformed
       // Set SnapToGrid to all reports form..
       javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
       for (int i=0; i< frames.length; ++i)
       {
          if (frames[i]  instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)frames[i];
             jrf.setSnapToGrid(jCheckBoxMenuItemSnapToGrid.isSelected() );
          }
       }
    }//GEN-LAST:event_jCheckBoxMenuItemSnapToGridActionPerformed
    
    private void jCheckBoxMenuItemGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxMenuItemGridActionPerformed
       
       javax.swing.JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
       for (int i=0; i< frames.length; ++i)
       {
          if (frames[i]  instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)frames[i];
             jrf.setShowGrid(jCheckBoxMenuItemGrid.isSelected() );
          }
       }
    }//GEN-LAST:event_jCheckBoxMenuItemGridActionPerformed
    
    private void jButtonBandsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBandsActionPerformed
       getBandsDialog().setVisible(true);
    }//GEN-LAST:event_jButtonBandsActionPerformed
    
    private void jButtonGroupsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonGroupsActionPerformed
       getGroupsDialog().setVisible(true);
    }//GEN-LAST:event_jButtonGroupsActionPerformed
    
    private void jButtonParametersActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonParametersActionPerformed
       // Show values frame...
       getValuesDialog().setVisible(true);
       
    }//GEN-LAST:event_jButtonParametersActionPerformed
    
    private void jMenuItemOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemOpenActionPerformed
       // Select an XMl file...
       String fileName = "";
       javax.swing.JFileChooser jfc = new javax.swing.JFileChooser(getCurrentDirectory());
       
       jfc.setDialogTitle("Load XML jasperreports file....");
       
       jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter()
       {
          public boolean accept(java.io.File file)
          {
             String filename = file.getName();
             return (filename.toLowerCase().endsWith(".jasper") || file.isDirectory()) ;
          }
          public String getDescription()
          {
             return "JasperReports compiled *.jasper";
          }
       });
       
       jfc.setFileFilter( new javax.swing.filechooser.FileFilter()
       {
          public boolean accept(java.io.File file)
          {
             String filename = file.getName();
             return (filename.endsWith(".xml") || file.isDirectory()) ;
          }
          public String getDescription()
          {
             return "JasperReports XML *.xml";
          }
       });
       
       
       
       jfc.setMultiSelectionEnabled(true);
       jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
       if  (jfc.showOpenDialog( null) == javax.swing.JOptionPane.OK_OPTION)
       {
          java.io.File[] files = jfc.getSelectedFiles();
          for (int i=0; i<files.length; ++i)
          {
             Report report = new Report(files[i].getPath());
             report.setUsingMultiLineExpressions(this.isUsingMultiLineExpressions());
             openNewReportWindow( report );
          }
          setCurrentDirectory( jfc.getSelectedFile(), true);
       }
       
    }//GEN-LAST:event_jMenuItemOpenActionPerformed
    
    private void jToggleButtonSubreportToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonSubreportToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.SUBREPORT_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonSubreportTool);
       }
    }//GEN-LAST:event_jToggleButtonSubreportToolItemStateChanged
    
    private void jToggleButtonSubreportToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonSubreportToolActionPerformed
       jToggleButtonSubreportTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonSubreportToolActionPerformed
    
    private void jToggleButtonTextFieldToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonTextFieldToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.TEXTFIELD_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonTextFieldTool);
       }
    }//GEN-LAST:event_jToggleButtonTextFieldToolItemStateChanged
    
    private void jToggleButtonTextFieldToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonTextFieldToolActionPerformed
       jToggleButtonTextFieldTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonTextFieldToolActionPerformed
    
    private void jToggleButtonStaticTextToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonStaticTextToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.STATICTEXT_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonStaticTextTool);
       }
    }//GEN-LAST:event_jToggleButtonStaticTextToolItemStateChanged
    
    private void jToggleButtonStaticTextToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonStaticTextToolActionPerformed
       jToggleButtonStaticTextTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonStaticTextToolActionPerformed
    
    private void jToggleButtonImageToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonImageToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.IMAGE_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonImageTool);
       }
    }//GEN-LAST:event_jToggleButtonImageToolItemStateChanged
    
    private void jToggleButtonImageToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonImageToolActionPerformed
       jToggleButtonImageTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonImageToolActionPerformed
    
    private void jToggleButtonEllipseToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonEllipseToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.ELLIPSE_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonEllipseTool);
       }
    }//GEN-LAST:event_jToggleButtonEllipseToolItemStateChanged
    
    private void jToggleButtonEllipseToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonEllipseToolActionPerformed
       jToggleButtonEllipseTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonEllipseToolActionPerformed
    
    private void jToggleButtonRectRoundToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonRectRoundToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.ROUND_RECTANGLE_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonRectRoundTool);
       }
    }//GEN-LAST:event_jToggleButtonRectRoundToolItemStateChanged
    
    private void jToggleButtonRectRoundToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonRectRoundToolActionPerformed
       jToggleButtonRectRoundTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonRectRoundToolActionPerformed
    
    private void jToggleButtonRectToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonRectToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.RECTANGLE_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonRectTool);
       }
    }//GEN-LAST:event_jToggleButtonRectToolItemStateChanged
    
    private void jToggleButtonRectToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonRectToolActionPerformed
       jToggleButtonRectTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonRectToolActionPerformed
    
    private void jToggleButtonLineToolActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonLineToolActionPerformed
       jToggleButtonLineTool.setSelected(true);
    }//GEN-LAST:event_jToggleButtonLineToolActionPerformed
    
    private void jToggleButtonLineToolItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonLineToolItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.LINE_ELEMENT);
             jrf.setLensMode(false);
          }
          setActiveTool(jToggleButtonLineTool);
       }
    }//GEN-LAST:event_jToggleButtonLineToolItemStateChanged
    
    private void jToggleButtonPointerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jToggleButtonPointerActionPerformed
       jToggleButtonPointer.setSelected(true);
    }//GEN-LAST:event_jToggleButtonPointerActionPerformed
    
    private void jToggleButtonPointerItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jToggleButtonPointerItemStateChanged
       if (evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
       {
          
          if (jMDIDesktopPane.getSelectedFrame() != null &&
          jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
          {
             JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
             jrf.setNewObjectType( ReportElementType.NONE);
             jrf.setLensMode(false);
          }
          if (jToggleButtonPointer.isEnabled())
          {
             setActiveTool( jToggleButtonPointer );
          }
       }
    }//GEN-LAST:event_jToggleButtonPointerItemStateChanged
    
    private void jButtonNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewActionPerformed
       this.jMenuItemNewDocumentActionPerformed(evt);
    }//GEN-LAST:event_jButtonNewActionPerformed
    
    public void setCutCopyEnabled(boolean enabled)
    {
       this.jButtonCut.setEnabled(enabled);
       this.jMenuItemCut.setEnabled(enabled);
       
       this.jButtonCopy.setEnabled(enabled);
       this.jMenuItemCopy.setEnabled(enabled);
       
       this.jMenuItemDelete.setEnabled(enabled);
    }
    
    public void setPasteEnebled(boolean enabled)
    {
       this.jButtonPaste.setEnabled(enabled);
       this.jMenuItemPaste.setEnabled(enabled);
    }
    
    public void setUndoEnebled(boolean enabled)
    {
       this.jMenuItemUndo.setEnabled(enabled);
    }
    
    public void setRedoEnebled(boolean enabled)
    {
       this.jMenuItemRedo.setEnabled(enabled);
    }
    
    public void setSaveEnebled(boolean enabled)
    {
       this.jButtonSave.setEnabled( enabled);
       this.jMenuItemSave.setEnabled( enabled);
    }
    
    private void jMenuItemSubreportActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemSubreportActionPerformed
       jToggleButtonSubreportToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonSubreportTool,0,jToggleButtonSubreportTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemSubreportActionPerformed
    
    private void jMenuItemTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemTextFieldActionPerformed
       jToggleButtonTextFieldToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonTextFieldTool,0,jToggleButtonTextFieldTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemTextFieldActionPerformed
    
    private void jMenuItemStaticTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemStaticTextActionPerformed
       jToggleButtonStaticTextToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonStaticTextTool,0,jToggleButtonStaticTextTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemStaticTextActionPerformed
    
    private void jMenuItemEllipseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEllipseActionPerformed
       jToggleButtonEllipseToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonEllipseTool,0,jToggleButtonEllipseTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemEllipseActionPerformed
    
    private void jMenuItemRoundRectangleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRoundRectangleActionPerformed
       jToggleButtonRectRoundToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonRectRoundTool,0,jToggleButtonRectRoundTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemRoundRectangleActionPerformed
    
    private void jMenuItemRectangleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRectangleActionPerformed
       jToggleButtonRectToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonRectTool,0,jToggleButtonRectTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemRectangleActionPerformed
    
    private void jMenuItemLineActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemLineActionPerformed
       jToggleButtonLineToolItemStateChanged(new java.awt.event.ItemEvent(jToggleButtonLineTool,0,jToggleButtonLineTool, java.awt.event.ItemEvent.SELECTED));
    }//GEN-LAST:event_jMenuItemLineActionPerformed
    
    private void jMenuItemNullElementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNullElementActionPerformed
       
    }//GEN-LAST:event_jMenuItemNullElementActionPerformed
    
    private void jMenuEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuEditActionPerformed
       // Add your handling code here:
    }//GEN-LAST:event_jMenuEditActionPerformed
    
    private void jNumberComboBoxZoomValueChanged(ValueChangedEvent evt)
    {
       //System.out.println("Zoom changed to" + evt.getNewValue());
       if (jMDIDesktopPane.getSelectedFrame() != null &&
       jMDIDesktopPane.getSelectedFrame() instanceof JReportFrame)
       {
          JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
          jrf.setZoomFactor(this.jNumberComboBoxZoom.getValue()/100.0);
       }
    }
    
    /**
     *  This method adjust JImageButtons position in according with buttons array.
     *  A null entry is interpreted as a 8 pixel space.
     */
    private void jPanelToolBarComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_jPanelToolBarComponentResized
       // Add your handling code here:
       if (toolBarControls == null ) return;
       int actualWidth=0;
       int actualHeight=0;
       int availWidth = this.jPanelToolBar.getWidth();
       
       java.util.Enumeration enum = toolBarControls.elements();
       while (enum.hasMoreElements())
       {
          Object obj = enum.nextElement();
          if (obj == null || ! (obj instanceof javax.swing.JComponent))
          {
             if (actualWidth > 0)
             {
                actualWidth += 8;
             }
          }
          else
          {
             javax.swing.JComponent ctl = (javax.swing.JComponent)obj;
             if ((actualWidth + ctl.getWidth()) > availWidth && (ctl.getWidth()+0 <= availWidth))
             {
                // Go to the next row...
                actualHeight += 32;
                actualWidth = 0;
             }
             ctl.setLocation(actualWidth,actualHeight);
             actualWidth += ctl.getWidth();
          }
       }
       jPanelToolBar.setSize( this.jPanelToolBar.getWidth(), (actualHeight+34));
       jPanelToolBar.setPreferredSize(new java.awt.Dimension( this.jPanelToolBar.getWidth(), (actualHeight)+34));
       jPanelToolBar.updateUI();
    }//GEN-LAST:event_jPanelToolBarComponentResized
    
    private void jMenuItemNewDocumentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewDocumentActionPerformed
       
       // Get info about the new report....
       // 1. Display the ReportProperties frame in dialog mode.
       //    Will be proposed default values...
       ReportPropertiesFrame rpf = new ReportPropertiesFrame();
       rpf.setModal(true);
       // find the first name free...
       String name = getFirstNameFree();
       rpf.setReportName( name);
       rpf.show();
       if (rpf.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
       {
          // The user has clicked on OK...
          // Storing in a new report the report characteristics.
          Report newReport = new Report();
          newReport.setUsingMultiLineExpressions(this.isUsingMultiLineExpressions());
          newReport.setWidth(rpf.getReportWidth());
          newReport.setHeight(rpf.getReportHeight());
          newReport.setOrientation(rpf.getOrientation());
          newReport.setName(rpf.getReportName());
          newReport.setTopMargin(rpf.getTopMargin());
          newReport.setLeftMargin(rpf.getLeftMargin());
          newReport.setRightMargin(rpf.getRightMargin());
          newReport.setBottomMargin(rpf.getBottomMargin());
          newReport.setColumnCount(rpf.getColumns());
          newReport.setColumnWidth(rpf.getColumnsWidth());
          newReport.setColumnSpacing(rpf.getColumnsSpacing());
          newReport.setIsSummaryNewPage(rpf.isSummaryOnNewPage());
          newReport.setIsTitleNewPage(rpf.isTitleOnNewPage());
          newReport.setWhenNoDataType(rpf.getWhenNoDataType());
          newReport.setScriptletClass(rpf.getScriptletClass());
          newReport.setEncoding(rpf.getXmlEncoding());
          newReport.setPrintOrder(rpf.getPrintOrder());
          newReport.setReportFormat(rpf.getReportFormat());
          /* todo newReport.setPageName(rpf.getPageName());  */
          openNewReportWindow( newReport );
       }
    }//GEN-LAST:event_jMenuItemNewDocumentActionPerformed
    
    public void openNewReportWindow( Report newReport )
    {
       // Create a new document frame....
       // ...that rappresent the report document created...
       JReportFrame jrf = new JReportFrame(newReport);
       
       jrf.addReportListener(this);
       
       
       
       // this is for JMDIFrame design...
       // jMDIMenuBar could be retrived from the jrf parent, contained in the JFrame
       // that store the JDesktopPane parent...
       jrf.setMenu( this.jMDIMenuBar );
       // Set default, but we starting the frame maximized by default...
       jrf.setBounds(10,10,700,500);
       // We must set the frame visible before adding it to the jMDIDesktopPane...
       jrf.setVisible(true);
       
       if (jrf.getReport().getFilename() != null &&
       !jrf.getReport().getFilename().trim().equals("") )
       {
          recentFilesList.remove( jrf.getReport().getFilename());
          recentFilesList.insertElementAt(jrf.getReport().getFilename(),0);
          this.updateRecentFileMenu(jMenuRecentFiles, recentFilesList );
          saveFileList(recentFilesList, "recentFiles.xml");
       }
       
       jMDIDesktopPane.add(jrf, javax.swing.JLayeredPane.DEFAULT_LAYER);
       
       jMDIDesktopPane.getDesktopManager().activateFrame(jrf);
       
       // Count all frames...
       
       int f_num = jMDIDesktopPane.getAllFrames().length;
       JRadioButtonMenuItemMDIFrame menuItem = new JRadioButtonMenuItemMDIFrame((JMDIFrame)jrf, f_num + ". " + jrf.getTitle() );
       menuItem.setSelected(true);
       menuItem.setMnemonic((int)((f_num+"").charAt(0)) );
       menuItem.setFont(new java.awt.Font("Dialog", 0, 11));
       menuItem.setAccelerator( javax.swing.KeyStroke.getKeyStroke((int)((f_num+"").charAt(0)),java.awt.Event.META_MASK));
       
       this.jMenuWindow.insert(menuItem, this.jMenuWindow.getMenuComponentCount());
       menuItem.addActionListener(new java.awt.event.ActionListener()
       {
          public void actionPerformed(java.awt.event.ActionEvent evt)
          {
             jMenuWindowListActionPerformed(evt);
          }
       });
       buttonGroupFramesList.add(menuItem);
       //updateMenuWindowList();
       
       // After activation, we try to maximize the window....
       try
       {
          jrf.setSelected(true);
          //if (jMDIMenuBar.getMaximizedFrame()  != null)
          jrf.setMaximum(true);
          String report_name = jrf.getReport().getName();
          DocumentTreeEntry dte = new DocumentTreeEntry(jrf,jrf.getReport().getName());
          javax.swing.tree.DefaultTreeModel dtm = (javax.swing.tree.DefaultTreeModel) jTreeFiles.getModel();
          ((javax.swing.tree.DefaultMutableTreeNode)dtm.getRoot()).add(
          new javax.swing.tree.DefaultMutableTreeNode(dte));
          setFileListActivatedFrame(jrf);
          jTreeFiles.updateUI();
       } catch (java.beans.PropertyVetoException ex)
       { /* Nothing to do */}
       
       
       // This call fix a bug in the code to show control box buttons on menu panel...
       jMDIMenuBar.restoreButtonsPosition();
       if( newReport.getFilename() != null && newReport.getFilename().length() > 0)
       {
          if(newReport.isModified())
          {
             this.enableSaveSpecific();
             this.enableSaveAllSpecific();
          }
          else
          {
             this.disableSaveSpecific();
             if(this.isSaveAllRequired())
             {
                this.enableSaveAllSpecific();
             }
             else
             {
                this.disableSaveAllSpecific();
             }
          }
       }
       else
       {
          this.enableSaveSpecific();
          this.enableSaveAllSpecific();
       }
    }
    private void jMenuFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuFileActionPerformed
       // Add your handling code here:
       jMDIMenuBar.restoreButtonsPosition();
    }//GEN-LAST:event_jMenuFileActionPerformed
    
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
       
       // This try is of java <1.4 comatibility
       try
       {
          this.getExtendedState();
       } catch (java.lang.NoSuchMethodError ex)
       {
          java.awt.Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
          java.awt.Point p = new java.awt.Point();
          p.x = Math.max( 0, (dim.width -this.getWidth())/2 );
          p.y = Math.max( 0, (dim.height -this.getHeight())/2 );
          this.setLocation(p);
       }
       //this.setSize(dim);
       //this.getContentPane().repaint();
       //this.update(this.getGraphics());
       //this.setState(java.awt.Frame.MAXIMIZED_HORIZ);
    }//GEN-LAST:event_formWindowOpened
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
       closeApplication();
    }//GEN-LAST:event_exitForm
    
    private void closeApplication()
    {
       try
       {
          this.saveiReportConfiguration();
       }
       catch(Throwable e)
       {
         e.printStackTrace(System.err);
       }
       if( this.isSaveAllRequired() )
       {
          String message = "There are unsaved files.  Would you like to save them before exiting?";
          String caption = "Unsaved files";
          int ret = javax.swing.JOptionPane.showConfirmDialog(this, message, caption, javax.swing.JOptionPane.YES_NO_CANCEL_OPTION);
          switch(ret)
          {
             case javax.swing.JOptionPane.YES_OPTION:
                java.awt.event.ActionEvent ae = new java.awt.event.ActionEvent(jMenuItemSaveAll,0, this.jMenuItemSaveAll.getActionCommand());
                jMenuItemSaveAllActionPerformed(ae);
                return;
             case javax.swing.JOptionPane.NO_OPTION:
                break;
             case javax.swing.JOptionPane.CANCEL_OPTION:
                return;
          }
       }
       this.dispose();
       if(!isEmbedded())
       {
        System.exit(0);
       }
    }
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
       new MainFrame().show();
    }
    
    
    private static byte[] getBytesFromInputStream(java.io.InputStream in, int length)  throws java.io.IOException
    {
       java.io.DataInputStream din = new java.io.DataInputStream(in);
       byte[] bytecodes = new byte[length];
       try
       {
          din.readFully(bytecodes);
       } finally
       {
          if (din != null) din.close();
       }
       return bytecodes;
    }
    
    /** Gets the image to be displayed in the minimized icon
     * for this frame.
     * @return    the icon image for this frame, or <code>null</code>
     *                    if this frame doesn't have an icon image.
     * @see       #setIconImage(Icon)
     *
     */
    public java.awt.Image getIconImage()
    {
       try
       {
          ClassLoader cl = this.getClass().getClassLoader();
          //java.io.InputStream in = new java.io.FileInputStream( cl.getResource("it/businesslogic/ireport/icons/iconsmall.jpg").getPath() );
          java.io.InputStream in = cl.getResourceAsStream("it/businesslogic/ireport/icons/iconsmall.jpg");
          byte[] data = getBytesFromInputStream(in, in.available());
          return java.awt.Toolkit.getDefaultToolkit().createImage(data);
       } catch (Exception ex)
       {ex.getMessage();
        ex.printStackTrace();
       }
       return null;
    }
    
    /** Getter for property elementPropertiesFrame.
     * @return Value of property elementPropertiesFrame.
     *
     */
    public ElementPropertiesDialog getElementPropertiesDialog()
    {
       return elementPropertiesDialog;
    }
    
    /** Setter for property elementPropertiesFrame.
     * @param elementPropertiesFrame New value of property elementPropertiesFrame.
     *
     */
    public void setElementPropertiesDialog(ElementPropertiesDialog elementPropertiesDialog)
    {
       this.elementPropertiesDialog = elementPropertiesDialog;
    }
    
    /** Getter for property valuesDialog.
     * @return Value of property valuesDialog.
     *
     */
    public it.businesslogic.ireport.gui.ValuesDialog getValuesDialog()
    {
       return valuesDialog;
    }
    
    /** Setter for property valuesDialog.
     * @param valuesDialog New value of property valuesDialog.
     *
     */
    public void setValuesDialog(it.businesslogic.ireport.gui.ValuesDialog valuesDialog)
    {
       this.valuesDialog = valuesDialog;
    }
    
    /** Getter for property groupsDialog.
     * @return Value of property groupsDialog.
     *
     */
    public it.businesslogic.ireport.gui.GroupsDialog getGroupsDialog()
    {
       return groupsDialog;
    }
    
    /** Setter for property groupsDialog.
     * @param groupsDialog New value of property groupsDialog.
     *
     */
    public void setGroupsDialog(it.businesslogic.ireport.gui.GroupsDialog groupsDialog)
    {
       this.groupsDialog = groupsDialog;
    }
    
    /** Getter for property bandsDialog.
     * @return Value of property bandsDialog.
     *
     */
    public BandsDialog getBandsDialog()
    {
       return bandsDialog;
    }
    
    /** Setter for property bandsDialog.
     * @param bandsDialog New value of property bandsDialog.
     *
     */
    public void setBandsDialog(BandsDialog bandsDialog)
    {
       this.bandsDialog = bandsDialog;
    }
    
    /** Getter for property reportQueryDialog.
     * @return Value of property reportQueryDialog.
     *
     */
    public it.businesslogic.ireport.gui.ReportQueryDialog getReportQueryDialog()
    {
       return reportQueryDialog;
    }
    
    /** Setter for property reportQueryDialog.
     * @param reportQueryDialog New value of property reportQueryDialog.
     *
     */
    public void setReportQueryDialog(it.businesslogic.ireport.gui.ReportQueryDialog reportQueryDialog)
    {
       this.reportQueryDialog = reportQueryDialog;
    }
    
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.ButtonGroup buttonGroupExportType;
   protected javax.swing.ButtonGroup buttonGroupFramesList;
   protected javax.swing.JButton jButtonAlignCenter;
   protected javax.swing.JButton jButtonAlignJustify;
   protected javax.swing.JButton jButtonAlignLeft;
   protected javax.swing.JButton jButtonAlignRight;
   protected javax.swing.JButton jButtonBands;
   protected javax.swing.JButton jButtonCompiler;
   protected javax.swing.JButton jButtonCopy;
   protected javax.swing.JButton jButtonCut;
   protected javax.swing.JButton jButtonDatabase;
   protected javax.swing.JButton jButtonGroups;
   protected javax.swing.JButton jButtonNew;
   protected javax.swing.JButton jButtonOpen;
   protected javax.swing.JButton jButtonParameters;
   protected javax.swing.JButton jButtonPaste;
   protected javax.swing.JButton jButtonRun1;
   protected javax.swing.JButton jButtonRun2;
   protected javax.swing.JButton jButtonSave;
   protected javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemEMM;
   protected javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemExplorer;
   protected javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemGrid;
   protected javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemOutput;
   protected javax.swing.JCheckBoxMenuItem jCheckBoxMenuItemSnapToGrid;
   protected javax.swing.JEditorPane jEditorPaneOutput;
   protected javax.swing.JList jListThreads;
   protected it.businesslogic.ireport.gui.JMDIDesktopPane jMDIDesktopPane;
   protected it.businesslogic.ireport.gui.JMDIMenuBar jMDIMenuBar;
   protected javax.swing.JMenu jMenuAdd;
   protected javax.swing.JMenu jMenuAlign;
   protected javax.swing.JMenu jMenuBuild;
   protected javax.swing.JMenu jMenuDatabase;
   protected javax.swing.JMenu jMenuEdit;
   protected javax.swing.JMenu jMenuFile;
   protected javax.swing.JMenu jMenuFormat;
   protected javax.swing.JMenu jMenuHSpacing;
   protected javax.swing.JMenu jMenuHelp;
   protected javax.swing.JMenuItem jMenuItem1;
   protected javax.swing.JMenuItem jMenuItemAbout;
   protected javax.swing.JMenuItem jMenuItemActiveConnection;
   protected javax.swing.JMenuItem jMenuItemAddFileToProject;
   protected javax.swing.JMenuItem jMenuItemAlignBottom;
   protected javax.swing.JMenuItem jMenuItemAlignHorizontalAxis;
   protected javax.swing.JMenuItem jMenuItemAlignLeft;
   protected javax.swing.JMenuItem jMenuItemAlignRight;
   protected javax.swing.JMenuItem jMenuItemAlignToBandBottom;
   protected javax.swing.JMenuItem jMenuItemAlignToBandTop;
   protected javax.swing.JMenuItem jMenuItemAlignTop;
   protected javax.swing.JMenuItem jMenuItemAlignVerticalAxis;
   protected javax.swing.JMenuItem jMenuItemBands;
   protected javax.swing.JMenuItem jMenuItemBringToFront;
   protected javax.swing.JMenuItem jMenuItemCascade;
   protected javax.swing.JMenuItem jMenuItemCenterBackground;
   protected javax.swing.JMenuItem jMenuItemCenterH;
   protected javax.swing.JMenuItem jMenuItemCenterInBand;
   protected javax.swing.JMenuItem jMenuItemCenterV;
   protected javax.swing.JMenuItem jMenuItemCloseProject;
   protected javax.swing.JMenuItem jMenuItemCompatibility;
   protected javax.swing.JMenuItem jMenuItemCompile;
   protected javax.swing.JMenuItem jMenuItemCompileAll;
   protected javax.swing.JMenuItem jMenuItemConnections;
   protected javax.swing.JMenuItem jMenuItemCopy;
   protected javax.swing.JMenuItem jMenuItemCut;
   protected javax.swing.JMenuItem jMenuItemDelete;
   protected javax.swing.JMenuItem jMenuItemElementProperties;
   protected javax.swing.JMenuItem jMenuItemElementsBrowser;
   protected javax.swing.JMenuItem jMenuItemEllipse;
   protected javax.swing.JMenuItem jMenuItemExecute;
   protected javax.swing.JMenuItem jMenuItemExecuteDB;
   protected javax.swing.JMenuItem jMenuItemFavorites;
   protected javax.swing.JMenuItem jMenuItemFields;
   protected javax.swing.JMenuItem jMenuItemFind;
   protected javax.swing.JMenuItem jMenuItemFindNext;
   protected javax.swing.JMenuItem jMenuItemFindPrev;
   protected javax.swing.JMenuItem jMenuItemFonts;
   protected javax.swing.JMenuItem jMenuItemGroups;
   protected javax.swing.JMenuItem jMenuItemHSDecrease;
   protected javax.swing.JMenuItem jMenuItemHSIncrease;
   protected javax.swing.JMenuItem jMenuItemHSMakeEqual;
   protected javax.swing.JMenuItem jMenuItemHSRemove;
   protected javax.swing.JMenuItem jMenuItemHelp;
   protected javax.swing.JMenuItem jMenuItemJoinLeft;
   protected javax.swing.JMenuItem jMenuItemJoinRight;
   protected javax.swing.JMenuItem jMenuItemLine;
   protected javax.swing.JMenuItem jMenuItemNewDocument;
   protected javax.swing.JMenuItem jMenuItemNewProject;
   protected javax.swing.JMenuItem jMenuItemNextWin;
   protected javax.swing.JMenuItem jMenuItemNullElement;
   protected javax.swing.JMenuItem jMenuItemOpen;
   protected javax.swing.JMenuItem jMenuItemOpenProject;
   protected javax.swing.JMenuItem jMenuItemOptions;
   protected javax.swing.JMenuItem jMenuItemParameters;
   protected javax.swing.JMenuItem jMenuItemPaste;
   protected javax.swing.JMenuItem jMenuItemPrevWin;
   protected javax.swing.JMenuItem jMenuItemProjectOptions;
   protected javax.swing.JMenuItem jMenuItemQOpen;
   protected javax.swing.JMenuItem jMenuItemQuit;
   protected javax.swing.JMenuItem jMenuItemRectangle;
   protected javax.swing.JMenuItem jMenuItemRedo;
   protected javax.swing.JMenuItem jMenuItemReplace;
   protected javax.swing.JMenuItem jMenuItemReportProperties;
   protected javax.swing.JMenuItem jMenuItemReportQuery;
   protected javax.swing.JMenuItem jMenuItemReportQuery2;
   protected javax.swing.JMenuItem jMenuItemRoundRectangle;
   protected javax.swing.JMenuItem jMenuItemSameHeight;
   protected javax.swing.JMenuItem jMenuItemSameHeightMax;
   protected javax.swing.JMenuItem jMenuItemSameHeightMin;
   protected javax.swing.JMenuItem jMenuItemSameSize;
   protected javax.swing.JMenuItem jMenuItemSameWidth;
   protected javax.swing.JMenuItem jMenuItemSameWidthMax;
   protected javax.swing.JMenuItem jMenuItemSameWidthMin;
   protected javax.swing.JMenuItem jMenuItemSave;
   protected javax.swing.JMenuItem jMenuItemSaveAll;
   protected javax.swing.JMenuItem jMenuItemSaveAs;
   protected javax.swing.JMenuItem jMenuItemSendToBack;
   protected javax.swing.JMenuItem jMenuItemStaticText;
   protected javax.swing.JMenuItem jMenuItemSubreport;
   protected javax.swing.JMenuItem jMenuItemTextField;
   protected javax.swing.JMenuItem jMenuItemTileHorizontal;
   protected javax.swing.JMenuItem jMenuItemTileVertical;
   protected javax.swing.JMenuItem jMenuItemUndo;
   protected javax.swing.JMenuItem jMenuItemVSDecrease;
   protected javax.swing.JMenuItem jMenuItemVSIncrease;
   protected javax.swing.JMenuItem jMenuItemVSMakeEqual;
   protected javax.swing.JMenuItem jMenuItemVSRemove;
   protected javax.swing.JMenuItem jMenuItemVariables;
   protected javax.swing.JMenuItem jMenuItemWizard;
   protected javax.swing.JMenuItem jMenuItemXMLSource;
   protected javax.swing.JMenuItem jMenuItemtileAnodine;
   protected javax.swing.JMenu jMenuPosition;
   protected javax.swing.JMenu jMenuProjects;
   protected javax.swing.JMenu jMenuRecentFiles;
   protected javax.swing.JMenu jMenuRecentProjects;
   protected javax.swing.JMenu jMenuSearch;
   protected javax.swing.JMenu jMenuSize;
   protected javax.swing.JMenu jMenuTools;
   protected javax.swing.JMenu jMenuVSpacing;
   protected javax.swing.JMenu jMenuView;
   protected javax.swing.JMenu jMenuWindow;
   protected it.businesslogic.ireport.gui.JNumberComboBox jNumberComboBoxZoom;
   protected javax.swing.JPanel jPanelDocumentStructure;
   protected javax.swing.JPanel jPanelFiles;
   protected javax.swing.JPanel jPanelMaster;
   protected javax.swing.JPanel jPanelProcesses;
   protected javax.swing.JPanel jPanelSouth;
   protected javax.swing.JPanel jPanelToolBar;
   protected javax.swing.JPanel jPanelZoom;
   protected javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewCSV;
   protected javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewHTML;
   protected javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewInternalViewer;
   protected javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewJAVA;
   protected javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewPDF;
   protected javax.swing.JRadioButtonMenuItem jRadioButtonMenuItemPreviewXLS;
   protected javax.swing.JScrollPane jScrollPane1;
   protected javax.swing.JScrollPane jScrollPaneFiles;
   protected javax.swing.JScrollPane jScrollPaneOutput;
   protected javax.swing.JScrollPane jScrollProcesses;
   protected javax.swing.JSeparator jSeparator1;
   protected javax.swing.JSeparator jSeparator10;
   protected javax.swing.JSeparator jSeparator11;
   protected javax.swing.JSeparator jSeparator12;
   protected javax.swing.JSeparator jSeparator13;
   protected javax.swing.JSeparator jSeparator14;
   protected javax.swing.JSeparator jSeparator15;
   protected javax.swing.JSeparator jSeparator16;
   protected javax.swing.JSeparator jSeparator17;
   protected javax.swing.JSeparator jSeparator18;
   protected javax.swing.JSeparator jSeparator19;
   protected javax.swing.JSeparator jSeparator2;
   protected javax.swing.JSeparator jSeparator20;
   protected javax.swing.JSeparator jSeparator21;
   protected javax.swing.JSeparator jSeparator3;
   protected javax.swing.JSeparator jSeparator4;
   protected javax.swing.JSeparator jSeparator5;
   protected javax.swing.JSeparator jSeparator6;
   protected javax.swing.JSeparator jSeparator7;
   protected javax.swing.JSeparator jSeparator8;
   protected javax.swing.JSeparator jSeparator9;
   protected javax.swing.JSplitPane jSplitPaneHorizontal;
   protected javax.swing.JSplitPane jSplitPaneV;
   protected javax.swing.JTabbedPane jTabbedPane1;
   protected javax.swing.JTabbedPane jTabbedPaneExplorer;
   protected javax.swing.JToggleButton jToggleButtonChartTool;
   protected javax.swing.JToggleButton jToggleButtonEllipseTool;
   protected javax.swing.JToggleButton jToggleButtonImageTool;
   protected javax.swing.JToggleButton jToggleButtonLineTool;
   protected javax.swing.JToggleButton jToggleButtonPointer;
   protected javax.swing.JToggleButton jToggleButtonRectRoundTool;
   protected javax.swing.JToggleButton jToggleButtonRectTool;
   protected javax.swing.JToggleButton jToggleButtonStaticTextTool;
   protected javax.swing.JToggleButton jToggleButtonSubreportTool;
   protected javax.swing.JToggleButton jToggleButtonTextFieldTool;
   protected javax.swing.JTree jTreeDocument;
   protected javax.swing.JTree jTreeFiles;
   // End of variables declaration//GEN-END:variables
    
    
    /* This method load:
     *  recent file list
     *  recent project list
     *  favorites files list
     */
    public void loadFileLists()
    {
       
       loadFileList(this.getRecentFilesList(), IREPORT_RECENT_FILES_FILE);
       loadFileList(this.getRecentProjectsList(), IREPORT_RECENT_PROJECTS_FILE);
       loadFileList(this.getFavoriteFilesList() , IREPORT_FAVORITE_FILES_FILE);
    }
    
    private void loadFileList(Vector v, String xmlFile)
    {
       File file = null;
       try
       {
          file = new File(xmlFile);
       } catch (Exception ex)
       {}
       if (file == null || !file.exists() || file.isDirectory())
       {
          try
          {
             outputBuffer.setLength(0);
             logOnConsole("Error loading Configuration file: "+xmlFile+"\n");
          } catch (Exception exsx)
          {}
          return;
       }
       //  Create a Xerces DOM Parser
       DOMParser parser = new DOMParser();
       //  Parse the Document
       //  and traverse the DOM
       try
       {
          
          parser.setEntityResolver( new org.xml.sax.EntityResolver()
          {
             /* Code by Teodor Danciu */
             public org.xml.sax.InputSource resolveEntity(
             String publicId,
             String systemId
             ) throws SAXException//, java.io.IOException
             {
                org.xml.sax.InputSource inputSource = null;
                
                if (systemId != null)
                {
                   String dtd = null;
                   
                   if (
                   systemId.equals("http://ireport.sourceforge.net/dtds/iReportFilesList.dtd")
                   )
                   {
                      dtd = "it/businesslogic/ireport/dtds/iReportFilesList.dtd";
                   }
                   else
                   {
                      return new org.xml.sax.InputSource(systemId);
                   }
                   
                   ClassLoader classLoader = this.getClass().getClassLoader();
                   
                   java.net.URL url = null;
                   
                   
                   if (classLoader != null)
                   {
                      url = classLoader.getResource(dtd);
                   }
                   if (url == null)
                   {
                      classLoader = this.getClass().getClassLoader();
                   }
                   
                   java.io.InputStream is = classLoader.getResourceAsStream(dtd);
                   if (is != null)
                   {
                      java.io.InputStreamReader isr = new java.io.InputStreamReader(is);
                      inputSource = new org.xml.sax.InputSource(isr);
                   }
                   
                }
                
                return inputSource;
             }
          });
          /* End Code by Teodor Danciu */
          parser.parse( new java.io.File(xmlFile).toURI().toString() );
          Document document = parser.getDocument();
          
          // Traverse the tree until we don't find a iReportFilesList element...
          Node fileList = goToNodeElement("iReportFilesList",document.getDocumentElement());
          if (fileList == null) return;
          NodeList list = fileList.getChildNodes();
          for (int i=0; i < list.getLength(); ++i)
          {
             Node child = list.item(i);
             if (child.getNodeType() == Node.ELEMENT_NODE && child.getNodeName().equals("iReportFile"))
             {
                String fileName = Report.readPCDATA(child);
                if (fileName != null && fileName.trim().length()>0)
                {
                   v.addElement( fileName );
                }
             }
             
          }
          
       } catch (Exception ex)
       {
       }
    }
    
    static public Node goToNodeElement(String name, Node node )
    {
       if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("iReportFilesList"))
       {
          return node;
       }
       
       NodeList list = node.getChildNodes();
       for (int i=0; i < list.getLength(); ++i)
       {
          Node child = goToNodeElement(name, list.item(i) );
          if (child != null) return child;
       }
       
       return null;
    }
    
    /* iReport configuration loader...
     */
    public void loadiReportConfiguration()
    {
       loadiReportConfiguration( IREPORT_CONFIG_FILE );
    }
    
         /* iReport configuration loader...
          */
    public void loadiReportConfiguration(String xmlFile)
    {
       
       // Adding default properties...
       properties.put("RecentFilesLength","10");
       properties.put("ViewRules","true");
       properties.put("GridSize","10");
       properties.put("ViewBorderForTextElements","true");
       properties.put("DefaultTemplate","");
       properties.put("DefaultCompilationDirectory","");
       properties.put("BackupPolicy","2");
       properties.put("DefaultBackupDirectory","");
       properties.put("ExternalEditor","");
       properties.put("ExternalPDFViewer","");
       properties.put("ExternalHTMLViewer","");
       properties.put("ExternalXLSViewer","");
       properties.put("ExternalCSVViewer","");
       properties.put("ViewBorderForTextElements","true");
       properties.put("ViewBorderColor","1");
       properties.put("DefaultUnit","cm");
       properties.put("SaveBeforeCompiling","true");
       properties.put("ViewBorderColor","-6710887");
       
       File file = null;
       try
       {
          file = new File(xmlFile);
       } catch (Exception ex)
       {}
       if (file == null || !file.exists() || file.isDirectory())
       {
          try
          {
             outputBuffer.setLength(0);
             logOnConsole("Error loading iReport Configuration file: "+xmlFile+"\nUsing default parameters.");
          } catch (Exception exsx)
          {}
          return;
       }
       //  Create a Xerces DOM Parser
       DOMParser parser = new DOMParser();
       //  Parse the Document
       //  and traverse the DOM
       try
       {
          
          parser.setEntityResolver( new org.xml.sax.EntityResolver()
          {
             /* Code by Teodor Danciu */
             public org.xml.sax.InputSource resolveEntity(
             String publicId,
             String systemId
             ) throws SAXException//, java.io.IOException
             {
                org.xml.sax.InputSource inputSource = null;
                
                if (systemId != null)
                {
                   String dtd = null;
                   
                   if (
                   systemId.equals("http://ireport.sourceforge.net/dtds/iReportProperties.dtd")
                   )
                   {
                      dtd = "it/businesslogic/ireport/dtds/iReportProperties.dtd";
                   }
                   else
                   {
                      return new org.xml.sax.InputSource(systemId);
                   }
                   
                   
                   ClassLoader classLoader = this.getClass().getClassLoader();
                   
                   java.net.URL url = null;
                   
                   
                   if (classLoader != null)
                   {
                      url = classLoader.getResource(dtd);
                   }
                   if (url == null)
                   {
                      classLoader = this.getClass().getClassLoader();
                   }
                   
                   java.io.InputStream is = classLoader.getResourceAsStream(dtd);
                   if (is != null)
                   {
                      java.io.InputStreamReader isr = new java.io.InputStreamReader(is);
                      inputSource = new org.xml.sax.InputSource(isr);
                   }
                   
                }
                
                return inputSource;
             }
          });
          /* End Code by Teodor Danciu */
          parser.parse( new java.io.File(xmlFile).toURI().toString() );
          Document document = parser.getDocument();
          
          traverse(document.getDocumentElement());
          
          String defaultConnection = Misc.nvl(properties.get("DefaultConnection"),"");
          
          //properties.put("DefaultConnection", null); // No default connection...
          if (!defaultConnection.equals(""))
          {
             // Looking for a connection width this name..,
             Enumeration enum = getConnections().elements();
             while (enum.hasMoreElements())
             {
                IReportConnection irc = (IReportConnection)enum.nextElement();
                if (Misc.nvl(irc.getName(),"").equals( defaultConnection ))
                {
                   properties.put("DefaultConnection", irc);
                   break;
                }
             }
          }
          
          String currentDirectory = Misc.nvl(properties.get("CurrentDirectory"),"");
          if (!currentDirectory.equals(""))
          {
             this.setCurrentDirectory(new java.io.File( currentDirectory ), false);
          }
      
          //I changed this from the working directory to the ireport IREPORT_DEFAULT_HOME_DIR
          setHomeDirectory(Misc.nvl(System.getProperty("ireport.home"), IREPORT_DEFAULT_HOME_DIR));
          
       } catch (SAXException e)
       {
          System.err.println(e);
       } catch (java.io.IOException e)
       {
          System.err.println(e);
       }
    }
    
    /**
     *  Set the current directory.
     *  If save = true, the config file is updates...
     */
    public File setCurrentDirectory( File f, boolean save)
    {
       String currentDirectory = "";
       if( f == null ) return f;
       if( f.isDirectory() )
       {
          currentDirectory = f.getAbsolutePath();
       } else
       {
          currentDirectory = f.getParentFile().getAbsolutePath();
       }
       
       if (save)
       {
          getProperties().put("CurrentDirectory", currentDirectory);
          this.saveiReportConfiguration();
       }
       return f;
    }
    
    private void traverse(Node node)
    {
       //System.out.println("traverse");
       if (node.getNodeType() == Node.ELEMENT_NODE && node.getNodeName().equals("iReportProperties"))
       {
          //System.out.println("iReportProperties");
          // Get childs....
          NodeList children = node.getChildNodes();
          if (children != null)
          {
             for (int k=0; k< children.getLength(); k++)
             {
                Node nodeChild = (Node)children.item(k);
                if (nodeChild.getNodeType() == Node.ELEMENT_NODE && nodeChild.getNodeName().equals("iReportProperty"))
                {
                   
                   // Take the CDATA...
                   String paramName = "";
                   NamedNodeMap nnm = nodeChild.getAttributes();
                   if ( nnm.getNamedItem("name") != null) paramName = nnm.getNamedItem("name").getNodeValue();
                   //System.out.println("     iReportProperty "+nnm.getNamedItem("name").getNodeValue());
                   properties.put(paramName,  readPCDATA(nodeChild) );
                   
                }
                else if (nodeChild.getNodeType() == Node.ELEMENT_NODE && nodeChild.getNodeName().equals("iReportConnection"))
                {
                   // Take the CDATA...
                   String connectionName = "";
                   String connectionClass = "";
                   HashMap hm = new HashMap();
                   NamedNodeMap nnm = nodeChild.getAttributes();
                   if ( nnm.getNamedItem("name") != null) connectionName = nnm.getNamedItem("name").getNodeValue();
                   if ( nnm.getNamedItem("connectionClass") != null) connectionClass = nnm.getNamedItem("connectionClass").getNodeValue();
                   
                   // Get all connections parameters...
                   NodeList list_child = nodeChild.getChildNodes();
                   for (int ck=0; ck< list_child.getLength(); ck++)
                   {
                      String parameterName = "";
                      Node child_child = (Node)list_child.item(ck);
                      if (child_child.getNodeType() == Node.ELEMENT_NODE && child_child.getNodeName().equals("connectionParameter"))
                      {
                         
                         NamedNodeMap nnm2 = child_child.getAttributes();
                         if ( nnm2.getNamedItem("name") != null)
                            parameterName = nnm2.getNamedItem("name").getNodeValue();
                         hm.put( parameterName,readPCDATA(child_child));
                      }
                   }
                   try
                   {
                      IReportConnection con = (IReportConnection) Class.forName(connectionClass).newInstance();
                      con.loadProperties(hm);
                      con.setName(connectionName);
                      connections.addElement( con );
                   } catch (Exception ex)
                   {
                      try
                      {
                         logOnConsole("Error loading " +connectionName+"\n"+ex.getMessage()+"\n");
                         
                      } catch (Exception exsx)
                      {}
                   }
                }
             }
          }
       }
    }
    /** Getter for property connections.
     * @return Value of property connections.
     *
     */
    public java.util.Vector getConnections()
    {
       return connections;
    }
    
    /** Setter for property connections.
     * @param connections New value of property connections.
     *
     */
    public void setConnections(java.util.Vector connections)
    {
       this.connections = connections;
    }
    
    /** Getter for property properties.
     * @return Value of property properties.
     *
     */
    public Properties getProperties()
    {
       return properties;
    }
    
    /** Setter for property properties.
     * @param properties New value of property properties.
     *
     */
    public void setProperties(Properties properties)
    {
       this.properties = properties;
    }
    
    private String readPCDATA(Node textNode)
    {
       NodeList list_child = textNode.getChildNodes();
       for (int ck=0; ck< list_child.getLength(); ck++)
       {
          Node child_child = (Node)list_child.item(ck);
          if (child_child.getNodeType() == Node.CDATA_SECTION_NODE ||
          child_child.getNodeType() == Node.TEXT_NODE)
          {
             return (String)child_child.getNodeValue();
          }
       }
       return "";
    }
    
    public boolean saveiReportConfiguration()
    {
       // Get the path of this class...
       // this.getClass().getResource("MainFrame");
       File dir = new File(IREPORT_HOME_DIR);
       try
       {
          if (dir.exists())
          {
             if (!dir.isDirectory() )
             {
                javax.swing.JOptionPane.showMessageDialog( null, dir.getPath() +" is not a directory!\nPlease rename this file and retry to save config!","",JOptionPane.ERROR_MESSAGE);
                return false;
             }
          }
          else
          {
             dir.mkdirs();
          }
       } catch (Exception ex)
       {
          javax.swing.JOptionPane.showMessageDialog( null, "An error is occurred saving iReport config:\n"+ex.getMessage()+"\nPlease try to save config again!","",JOptionPane.ERROR_MESSAGE);
          return false;
       }
       
       return saveiReportConfiguration( IREPORT_CONFIG_FILE );
    }
    public boolean saveiReportConfiguration(String xmlFile)
    {
       try
       {
          PrintWriter pw = new PrintWriter( new FileWriter(xmlFile) );
          // Find iReport configuration in the home directory...
          // 1. Save all properties using am XML style...
          pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
          pw.println("<!-- iReport 2 Configuration file - " + new Date() + " -->");
          pw.println("<!DOCTYPE iReportProperties PUBLIC \"-//iReport/DTD iReport Configuration//EN\" \"http://ireport.sourceforge.net/dtds/iReportProperties.dtd\">");
          pw.println("<iReportProperties>");
          
          Enumeration enum = this.getProperties().keys();
          while (enum.hasMoreElements())
          {
             String key = (String)enum.nextElement();
             pw.println("\t<iReportProperty name=\""+ key +"\"><![CDATA["+ this.getProperties().get(key) +"]]></iReportProperty>");
          }
          
          enum = this.getConnections().elements();
          while (enum.hasMoreElements())
          {
             IReportConnection con = (IReportConnection)enum.nextElement();
             con.save(pw);
          }
          
          pw.println("</iReportProperties>");
          pw.close();
       } catch (Exception ex)
       {
          //ex.printStackTrace(s
          try
          {
             logOnConsole("Error saving iReport Configuration file: "+xmlFile+"\n"+ex.getMessage()+"\n");
             
          } catch (Exception exsx)
          {}
          return false;
       }
       try
       {
          logOnConsole("iReport configuration file "+ xmlFile + " successfully updated!\n");
       } catch (Exception ex)
       { }
       return true;
    }
    
    
    
    public boolean saveFileList( Vector v, String xmlFile)
    {
       // Get the path of this class...
       // this.getClass().getResource("MainFrame");
       File dir = new File( IREPORT_HOME_DIR );
       try
       {
          if (dir.exists())
          {
             if (!dir.isDirectory() )
             {
                javax.swing.JOptionPane.showMessageDialog( null, dir.getPath() +" is not a directory!\nPlease rename this file and retry to save config!","",JOptionPane.ERROR_MESSAGE);
                return false;
             }
          }
          else
          {
             dir.mkdirs();
          }
       } catch (Exception ex)
       {
          javax.swing.JOptionPane.showMessageDialog( null, "An error is occurred saving iReport config:\n"+ex.getMessage()+"\nPlease try to save config again!","",JOptionPane.ERROR_MESSAGE);
          return false;
       }
       
       xmlFile = dir.getPath()+ File.separatorChar + xmlFile;
       
       try
       {
          PrintWriter pw = new PrintWriter( new FileWriter(xmlFile) );
          // Find iReport configuration in the home directory...
          // 1. Save all properties using am XML style...
          pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
          pw.println("<!-- iReport 2 file list - " + new Date() + " -->");
          pw.println("<!DOCTYPE iReportFilesList PUBLIC \"-//iReport/DTD iReport Configuration//EN\" \"http://ireport.sourceforge.net/dtds/iReportFilesList.dtd\">");
          pw.println("<iReportFilesList>");
          
          Enumeration enum = v.elements();
          int i=0;
          int max_files = 10;
          try
          {
             max_files = Integer.parseInt(getProperties().getProperty("RecentFilesLength"));
          } catch (Exception ex)
          {
             getProperties().setProperty("RecentFilesLength","10");
          }
          
          while (i < max_files && enum.hasMoreElements())
          {
             String file = (String)enum.nextElement();
             pw.println("\t<iReportFile><![CDATA["+ file +"]]></iReportFile>");
             i++;
          }
          pw.println("</iReportFilesList>");
          pw.close();
       } catch (Exception ex)
       {
          //ex.printStackTrace(s
          try
          {
             logOnConsole("Error saving iReport file: "+xmlFile+"\n"+ex.getMessage()+"\n");
             
          } catch (Exception exsx)
          {}
          return false;
       }
       try
       {
          logOnConsole("iReport file "+ xmlFile + " successfully updated!\n");
       } catch (Exception ex)
       { }
       return true;
    }
    
    
    
    public void logOnConsole(String noHTML)
    {
       logOnConsole(noHTML,false);
    }
    public void logOnConsole(String s, boolean isHTML)
    {
       try
       {
          this.jEditorPaneOutput.setContentType("text/html");
          if (!isHTML)
          {
             s = Misc.string_replace("&gt;",">",s);
             s = Misc.string_replace("&lt;","<",s);
             s = Misc.string_replace("&nbsp;"," ",s);
             s = Misc.string_replace("&nbsp;&nbsp;&nbsp;&nbsp;","\t",s);
             s = Misc.string_replace("<br>", "\n", s);
          }
          
          outputBuffer.append(s);
          //String text = Misc.string_replace("","</body></html>",this.jEditorPaneOutput.getText());
          
          //s =  + s+"</body></html>";
          this.jEditorPaneOutput.setText("<html><body><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td nowrap><font face=\"Courier New\" size=\"3\">" + outputBuffer + "</font></td></tr></table></body></html>");
          //this.jEditorPaneOutput.getDocument().insertString(this.jEditorPaneOutput.getDocument().getLength(), s ,  null);
          
       } catch (Exception exsx)
       {
          JOptionPane.showMessageDialog(null,""+exsx.getMessage());
       }
    }
    
    /** Getter for property ttfFonts.
     * @return Value of property ttfFonts.
     *
     */
    public java.util.Vector getTtfFonts()
    {
       return ttfFonts;
    }
    
    /** Setter for property ttfFonts.
     * @param ttfFonts New value of property ttfFonts.
     *
     */
    public void setTtfFonts(java.util.Vector ttfFonts)
    {
       this.ttfFonts = ttfFonts;
    }
    
    /** This method parse an error encoded using an url.
     *  The url must be in the form:
     *  http://{error|warinig}:{JReportFrame ID}/{expression}
     *
     *  error: referred to an expression field
     *  warning: referred to an element position warning
     *
     *  Possible expressions for error:
     *  variableInitialValue_<VARIABLE_NAME>
     *  textField_<TEXTFIELD NUMBER>
     *  printWhen_<PRINT WHEN EXPRESSION NUMBER>(*)
     *  parameterDefaultValue_<PARAMETER NAME>
     *  parameter_<PARAMETER NAME>
     *
     *  Possible expressions for warning:
     *  y=<Y>,height=<Height>,band-height=<Band-Height>
     *
     *  (*) The printWhen expression are considered only if not blank.
     *  The search order is this: bands, elements
     */
    public boolean  parseError(java.net.URL url)
    {
       if (url == null) return false;
       
       // First of all activate the right frame...
       JInternalFrame[] frames = jMDIDesktopPane.getAllFrames();
       JReportFrame jrf = null;
       for (int k=0; k< frames.length; k++)
       {
          if (frames[k] instanceof JReportFrame)
          {
             if ( ((JReportFrame)frames[k]).getWindowID() == url.getPort())
             {
                jrf = (JReportFrame)frames[k];
                if ( !frames[k].isSelected() )
                {
                   try
                   {
                      frames[k].setSelected(true);
                   } catch (Exception ex)
                   {}
                }
             }
          }
       }
       if (jrf == null) return false;
       
       try
       {
          if (url.getHost().equalsIgnoreCase("error"))
          {
             String expression = url.getFile();
             
             if (expression!=null && expression.length() > 0)
             {
                // parse expression...
                if (expression.startsWith("/textField_"))
                {
                   int index = 0;
                   int number = Integer.parseInt( expression.substring(("/textField_").length()).trim());
                   Enumeration enum = jrf.getReport().getElements().elements();
                   while (enum.hasMoreElements())
                   {
                      ReportElement re = (ReportElement)enum.nextElement();
                      if (re instanceof TextFieldReportElement)
                      {
                         index++;
                         if (index == number)
                         {
                            jrf.setSelectedElement(re);
                            this.getElementPropertiesDialog().setVisible(true);
                            this.getElementPropertiesDialog().gotoTab( this.getElementPropertiesDialog().TEXTFIELD_TAB );
                            return true;
                         }
                      }
                   }
                }
                else if (expression.startsWith("/parameterDefaultValue_"))
                {
                   int index = 0;
                   String name = expression.substring(("/parameterDefaultValue_").length()).trim();
                   Enumeration enum = jrf.getReport().getParameters().elements();
                   while (enum.hasMoreElements())
                   {
                      it.businesslogic.ireport.JRParameter param = (it.businesslogic.ireport.JRParameter)enum.nextElement();
                      if (param.getName().equals(name))
                      {
                         this.getValuesDialog().setVisible(true);
                         this.getValuesDialog().modifyParameter(param );
                         return true;
                      }
                   }
                   
                }
             }
          }
          else if (url.getHost().equals("warning"))
          {
          }
       } catch (Exception ex)
       {}
       return false;
    }
    
    public void reportBandChanged(ReportBandChangedEvent evt)
    {
       
    }
    
    public void reportElementsChanged(ReportElementChangedEvent evt)
    {
       if (evt.getType() == ReportElementChangedEvent.CHANGED)
       {
          ReportElement re = evt.getElement();
          DefaultMutableTreeNode node = findElementTreeNode(re, true);
          if (node == null)
          {
             // This node has changed your band....
             // Find the node based on objects availables....
             node = findElementTreeNode(re, false);
             if (node == null) return; // This should not happen....
             // Remove from your parent....
             node.removeFromParent();
             // Add to the new parent...
             DefaultMutableTreeNode root = (DefaultMutableTreeNode)jTreeDocument.getModel().getRoot();
             for (int i=0; i<root.getChildCount(); ++i)
             {
                DefaultMutableTreeNode bandNode = (DefaultMutableTreeNode)root.getChildAt(i);
                if (bandNode.getUserObject() == re.band)
                {
                   bandNode.add( node );
                   this.setDontHandleEvent(true);
                   if (evt.getJReportFrame().getSelectedElements().contains( re ))
                   {
                      jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(new Object[]
                      {root, bandNode,node}));
                   }
                   this.setDontHandleEvent(false);
                   break;
                }
             }
          }
          jTreeDocument.updateUI();
       }
       else if (evt.getType() == ReportElementChangedEvent.REMOVED)
       {
          ReportElement re = evt.getElement();
          // find this element....
          DefaultMutableTreeNode node = findElementTreeNode(re,true);
          if (node != null)
          {
             node.removeFromParent();
             jTreeDocument.updateUI();
          }
       }
       else if (evt.getType() == ReportElementChangedEvent.ADDED)
       {
          ReportElement re = evt.getElement();
          // add it to your band...
          DefaultMutableTreeNode node = new DefaultMutableTreeNode(re);
          // Find the band node...
          DefaultMutableTreeNode root = (DefaultMutableTreeNode)jTreeDocument.getModel().getRoot();
          for (int i=0; i<root.getChildCount(); ++i)
          {
             DefaultMutableTreeNode bandNode = (DefaultMutableTreeNode)root.getChildAt(i);
             if (bandNode.getUserObject() == re.band)
             {
                bandNode.add( node );
                jTreeDocument.updateUI();
                break;
             }
          }
       }
       //we need to set the report to show it has been modified.
       Report mod = evt.getJReportFrame().getReport();
       mod.setModified(true);
       this.enableSaveSpecific();
       this.enableSaveAllSpecific();
    }//end reportElementsChanged
    
    /**
     *Used to enable anything strictly save related.  Not save all.
     */
    public void enableSaveSpecific()
    {
       //TODO add events to update gui when changes occur in expressions.
       //this had to be commented out until that day arrives.
       //brainjava will be working on this
       /*
       this.jButtonSave.setEnabled(true);
       this.jMenuItemSave.setEnabled(true);
        **/
    }
    
    /**
     *Used to disable anything Save.  Not save all.
     */
    public void disableSaveSpecific()
    {
    
       //TODO add more events so code can be comented back in
       //this had to be removed until events can be added to 
       //the expression updates so the gui will know changes have
       //occurred
       /*
       this.jButtonSave.setEnabled(false);
       this.jMenuItemSave.setEnabled(false);
        **/
    }//end disableSaveSpecific
    
    /**
     *Used to enable anything strictly save all related.  Not save.
     */
    public void enableSaveAllSpecific()
    {
       this.jMenuItemSaveAll.setEnabled(true);
    }//end enableSaveAllSpecific
    
    /**
     *Used to disable anything Save.  Not save all.
     */
    public void disableSaveAllSpecific()
    {
       this.jMenuItemSaveAll.setEnabled(false);
    }//end disableSaveAllSpecific
    
    /**
     *     If searchInYourBandOnly == true
     *     This method Look for the userObject re in elements contained in the same band
     *     of the element. This method MUST CHECK that the report IS in the band
     *     assigned. If not it must return null. The reason is that if the element
     *     is not found in your band, it has changed the band attribute and must be updated.
     */
    public DefaultMutableTreeNode findElementTreeNode( ReportElement re, boolean searchInYourBandOnly)
    {
       // looking for it in the tree...
       //1. Search the band...
       DefaultMutableTreeNode root = (DefaultMutableTreeNode)jTreeDocument.getModel().getRoot();
       for (int i=0; i<root.getChildCount(); ++i)
       {
          DefaultMutableTreeNode bandNode = (DefaultMutableTreeNode)root.getChildAt(i);
          if (!searchInYourBandOnly || bandNode.getUserObject() == re.band)
          {
             for (int k=0; k<bandNode.getChildCount(); ++k)
             {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)bandNode.getChildAt(k);
                if (child.getUserObject() == re)
                {
                   return child;
                }
             }
          }
       }
       return null;
    }
    
    
    /**     This method is called when a new element is selected,
     *     or deselected.
     *
     */
    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt)
    {
       
       setDontHandleEvent(true);
       TreePath[] path = jTreeDocument.getSelectionPaths();
       if (path != null && evt.getSelectedElements() != null && evt.getSelectedElements().size() == 0 && path.length == 1 &&
       ((DefaultMutableTreeNode) path[0].getLastPathComponent()).getUserObject() instanceof Band)
       {
          setDontHandleEvent(false);
          return;
       }
       
       jTreeDocument.getSelectionModel().clearSelection();
       setDontHandleEvent(false);
       Vector v = evt.getSelectedElements();
       Enumeration enum = v.elements();
       while (enum.hasMoreElements())
       {
          ReportElement re = (ReportElement)enum.nextElement();
          // looking for it in the tree...
          //1. Search the band...
          DefaultMutableTreeNode root = (DefaultMutableTreeNode)jTreeDocument.getModel().getRoot();
          for (int i=0; i<root.getChildCount(); ++i)
          {
             DefaultMutableTreeNode bandNode = (DefaultMutableTreeNode)root.getChildAt(i);
             if (bandNode.getUserObject() == re.band)
             {
                for (int k=0; k<bandNode.getChildCount(); ++k)
                {
                   DefaultMutableTreeNode child = (DefaultMutableTreeNode)bandNode.getChildAt(k);
                   if (child.getUserObject() == re)
                   {
                      setDontHandleEvent(true);
                      jTreeDocument.getSelectionModel().addSelectionPath(new TreePath(new Object[]
                      {root, bandNode,child}));
                      setDontHandleEvent(false);
                   }
                }
             }
          }
          
       }
       
    }
    
    /** Getter for property dontHandleEvent.
     * @return Value of property dontHandleEvent.
     *
     */
    public boolean isDontHandleEvent()
    {
       return dontHandleEvent;
    }
    
    /** Setter for property dontHandleEvent.
     * @param dontHandleEvent New value of property dontHandleEvent.
     *
     */
    public void setDontHandleEvent(boolean dontHandleEvent)
    {
       this.dontHandleEvent = dontHandleEvent;
    }
    
    /** Getter for property jTreeDocument.
     * @return Value of property jTreeDocument.
     *
     */
    public javax.swing.JTree getJTreeDocument()
    {
       return jTreeDocument;
    }
    
    /** Setter for property jTreeDocument.
     * @param jTreeDocument New value of property jTreeDocument.
     *
     */
    public void setJTreeDocument(javax.swing.JTree jTreeDocument)
    {
       this.jTreeDocument = jTreeDocument;
    }
    
    /** Getter for property recentFilesList.
     * @return Value of property recentFilesList.
     *
     */
    public java.util.Vector getRecentFilesList()
    {
       return recentFilesList;
    }
    
    /** Setter for property recentFilesList.
     * @param recentFilesList New value of property recentFilesList.
     *
     */
    public void setRecentFilesList(java.util.Vector recentFilesList)
    {
       this.recentFilesList = recentFilesList;
    }
    
    /** Getter for property recentProjectsList.
     * @return Value of property recentProjectsList.
     *
     */
    public java.util.Vector getRecentProjectsList()
    {
       return recentProjectsList;
    }
    
    /** Setter for property recentProjectsList.
     * @param recentProjectsList New value of property recentProjectsList.
     *
     */
    public void setRecentProjectsList(java.util.Vector recentProjectsList)
    {
       this.recentProjectsList = recentProjectsList;
    }
    
    /** Getter for property favoriteFilesList.
     * @return Value of property favoriteFilesList.
     *
     */
    public java.util.Vector getFavoriteFilesList()
    {
       return favoriteFilesList;
    }
    
    /** Setter for property favoriteFilesList.
     * @param favoriteFilesList New value of property favoriteFilesList.
     *
     */
    public void setFavoriteFilesList(java.util.Vector favoriteFilesList)
    {
       this.favoriteFilesList = favoriteFilesList;
    }
    
    private void jMenuItemRecentFileActionPerformed(java.awt.event.ActionEvent evt )
    {
       if (evt.getSource() instanceof JMenuItem)
       {
          JMenuItem menu = (JMenuItem)evt.getSource();
          
          // Is a recent file?!
          for (int i=0; i< jMenuRecentFiles.getMenuComponentCount(); ++ i)
          {
             if (jMenuRecentFiles.getMenuComponent(i) ==  menu)
             {
                // If not already Opened, open entry # i
                
                Report report = new Report( (String)recentFilesList.elementAt(i)) ;
                report.setUsingMultiLineExpressions(this.isUsingMultiLineExpressions());
                openNewReportWindow( report );
                if( report.isModified() )
                {
                   this.enableSaveSpecific();
                   this.enableSaveAllSpecific();
                }
                else
                {
                   this.disableSaveSpecific();
                   if( this.isSaveAllRequired() )
                   {
                      this.enableSaveAllSpecific();
                   }
                   else
                   {
                      this.disableSaveAllSpecific();
                   }
                }
                return;
             }
          }
       }
    }
    
    public void updateRecentFileMenu(JMenu menu, Vector v)
    {
       menu.removeAll();
       Enumeration enum = v.elements();
       int i=1;
       
       int k=0;
       int max_files = 10;
       try
       {
          max_files = Integer.parseInt(getProperties().getProperty("RecentFilesLength"));
       } catch (Exception ex)
       {
          getProperties().setProperty("RecentFilesLength","10");
       }
       
       while (k < max_files && enum.hasMoreElements())
       {
          
          JMenuItem subMenu = new JMenuItem( i+". "+Misc.getShortFileName((String)enum.nextElement()));
          System.out.println("ttt"+subMenu);
          subMenu.setFont(new java.awt.Font("Dialog", 0, 11));
          subMenu.addActionListener( new java.awt.event.ActionListener()
          {
             public void actionPerformed(java.awt.event.ActionEvent evt)
             {
                jMenuItemRecentFileActionPerformed(evt);
             }
             
          });
          menu.add(subMenu);
          i++;
          k++;
       }
    }
    
    public void updateRecentProjectMenu(JMenu menu, Vector v)
    {
    }
    public void updateUndoMenu(JReportFrame jrf)
    {
       
       if (jrf == null)
       {
          this.jMenuItemUndo.setEnabled(false);
          this.jMenuItemRedo.setEnabled(false);
          return;
       }
       if (jrf.getUndoOperation() != null)
       {
          this.jMenuItemUndo.setEnabled(true);
          this.jMenuItemUndo.setText("Undo " + jrf.getUndoOperation());
       }
       else
       {
          this.jMenuItemUndo.setEnabled(false);
          this.jMenuItemUndo.setText("Undo");
       }
       
       if (jrf.getRedoOperation() != null)
       {
          this.jMenuItemRedo.setEnabled(true);
          this.jMenuItemRedo.setText("Redo " + jrf.getRedoOperation());
       }
       else
       {
          this.jMenuItemRedo.setEnabled(false);
          this.jMenuItemRedo.setText("Redo");
       }
    }
    
    public void updateCutAndPasteMenu(JReportFrame jrf)
    {
       
       if (jrf == null)
       {
          setCutCopyEnabled(false);
          setPasteEnebled(false);
          return;
       }
       if (jrf.getSelectedElements().size() > 0)
       {
          setCutCopyEnabled(true);
          if (getClipBoard().size()>0)
             setPasteEnebled(true);
       }
       else
       {
          setCutCopyEnabled(false);
          if (getClipBoard().size()>0)
             setPasteEnebled(true);
       }
    }
    
    
    public void undo()
    {
       jMenuItemUndoActionPerformed(new java.awt.event.ActionEvent(jMenuItemUndo,0,""));
    }
    
    public void redo()
    {
       jMenuItemRedoActionPerformed(new java.awt.event.ActionEvent(jMenuItemUndo,0,""));
       
    }
    
    /**
     *     Update the jTreeDocumen (the tree with the opened files)
     */
    public void updateOpenedDocumentsList()
    {
       jTreeFiles.updateUI();
    }
    
    /** Getter for property activeClipboard.
     * @return Value of property activeClipboard.
     *
     */
    public int getActiveClipboard()
    {
       return activeClipboard;
    }
    
    /** Setter for property activeClipboard.
     * @param activeClipboard New value of property activeClipboard.
     *
     */
    public void setActiveClipboard(int activeClipboard)
    {
       this.activeClipboard = activeClipboard;
    }
    
    public Vector getClipBoard()
    {
       return clipboards[getActiveClipboard()];
    }
    
    public void setClipBoardContent(Vector elements)
    {
       clipboards[getActiveClipboard()] = elements;
    }
    
    /** Getter for property homeDirectory.
     * @return Value of property homeDirectory.
     *
     */
    public java.lang.String getHomeDirectory()
    {
       return homeDirectory;
    }
    
    /** Setter for property homeDirectory.
     * @param homeDirectory New value of property homeDirectory.
     *
     */
    public void setHomeDirectory(java.lang.String homeDirectory)
    {
       this.homeDirectory = homeDirectory;
    }
    
    public String getCurrentDirectory()
    {
       return "" + Misc.nvl( getProperties().getProperty("CurrentDirectory"), ".");
    }
    
    public void run()
    {
       this.checkForModifiedFiles();
    }
    
    
    public void saveBackup(String filename)
    {
       java.io.File f = new java.io.File(filename);
       if ( f.exists())
       {
          String path = f.getPath();
          String file = f.getName();
          
          if (getProperties().getProperty("DefaultBackupDirectory") != null &&
          (""+getProperties().getProperty("DefaultBackupDirectory")).length()>0)
             path = getProperties().getProperty("DefaultBackupDirectory");
          
          if (getProperties().getProperty("BackupPolicy") != null &&
          (""+getProperties().getProperty("BackupPolicy")).equalsIgnoreCase("0"))
          {
             return;
          } else if (getProperties().getProperty("BackupPolicy") != null &&
          (""+getProperties().getProperty("BackupPolicy")).equalsIgnoreCase("1"))
          {
             if (file.indexOf(".") > 0 && file.substring(file.indexOf(".")).length()>=3)
                file = file.substring(0,file.length()-3)+"bak";
             else
                file += ".bak";
          } else
          {
             file += ".bak";
          }
          try
          {
             //String back_path = getProperties().getProperty( "
             File f2 = new java.io.File( path + ((path.endsWith(java.io.File.separatorChar+"")) ? "" : ""+java.io.File.separatorChar) + file);
             if (f2.exists())
             {
                if (!f2.delete())
                {
                   logOnConsole("Can not delete " + f2+"<br>",true);
                }
             }
             
             f.renameTo( f2 );
             logOnConsole("Renamed " + f + " to " +  f2+"<br>",true);
             //com.ms.wfc.io.File.copyOver( filename, com.ms.wfc.io.File.combine(path,file));
          } catch (Exception ex)
          {
             javax.swing.JOptionPane.showMessageDialog(this, "An exception is occurred saving backup copy.\n"+ex.getMessage(),"",javax.swing.JOptionPane.ERROR_MESSAGE);
          }
       }
    }
    
    /* Thanks to James Fu */
    private void setElementValue(Object element, String method, String value)
    {
       try
       {
          java.lang.reflect.Method setMethod = element.getClass().getMethod(method, new Class[]
          {String.class});
          setMethod.invoke(element, new Object[]
          {value});
       }
       catch (Exception e)
       {
       }
    }
    /* Thanks to James Fu */
    public void setElementsValue(String method,String value )
    {
       JReportFrame jrf = (JReportFrame)jMDIDesktopPane.getSelectedFrame();
       
       // Set the new value for all selected elements...
       Enumeration enum = jrf.getSelectedElements().elements();
       while (enum.hasMoreElements())
       {
          TextReportElement element = (TextReportElement)enum.nextElement();
          setElementValue(element, method, value);
       }
       
       jrf.getJPanelReport().repaint();
    }
    
    //TODO         */
    ////////////////////////////////////////
    /*
     *
    The methods below which are being used for pref settings need to be moved
    to another location.  This is just a quick fix sort of thing.
       wade
     */
    ///////////////////////////////////////
    
    /**
     *Used to set the application preference/option/property UseMultiLineExpressions
     *@pram useMultiLineExpressions whether to use or not to use them.
     */
    public void setUsingMultiLineExpressions(boolean useMultiLineExpressions)
    {
       String boolVal = ""+useMultiLineExpressions;
       this.properties.setProperty("usingMultiLineExpressions", boolVal);
    }//end setUseMultiLineExpressions
    
    /**
     *Used to tell whether or not to be using multi line expressions.
     *@return whether multiline expressions are being used or not.
     */
    public boolean isUsingMultiLineExpressions()
    {
       boolean ret = false;
       String prop = this.properties.getProperty("usingMultiLineExpressions");
       if(prop != null)
       {
          ret = prop.trim().equalsIgnoreCase("true");
       }
       else
       {
          ret = false;
       }
       return ret;
    }//end isUsingMultiLineExpressions
    
    /**
     *Method used to tell compiler to use the directory the file being compiled in
     *for the compile directory.  This is for simplicity of development.
     *@param useCurrentFilesDirectoryForCompiles speaks for itself
     */
    public void setUsingCurrentFilesDirectoryForCompiles(boolean usingCurrentFilesDirectoryForCompiles)
    {
      this.properties.setProperty("useCurrentFilesDirectoryForCompiles", ""+usingCurrentFilesDirectoryForCompiles);
    }

    /**
     *Used to tell if the compiler should use the current files directory for the compile.
     *@return whether or not to use the current files directory for the compile.
     */
    public boolean isUsingCurrentFilesDirectoryForCompiles()
    {
      boolean ret = false;
      ret = this.properties.getProperty("useCurrentFilesDirectoryForCompiles", "false").trim().equalsIgnoreCase("true");
      return ret;
    }
    
    /**
     *Used to set the default compilation directory
     *@param defaultCompilationDirectory 
     */
    public void setDefaultCompilationDirectory(String defaultCompilationDirectory)
    {
      this.properties.setProperty("DefaultCompilationDirectory", defaultCompilationDirectory);
    }
    
    /**
     *Method used to get the default compilation directory
     *@return the default compilation directory for ireport
     */
    public String getDefaultCompilationDirectory()
    {
       String ret = this.properties.getProperty("DefaultCompilationDirectory", IREPORT_DEFAULT_HOME_DIR);
       if( ret.trim().length() > 0 )
       {
          
       }
       else
       {
         ret = IREPORT_DEFAULT_HOME_DIR;
       }
       return ret;
    }
    
    /**
     *Method used to translate properties that dictate where the compilation directory
     *should be so that the correct directory can be obtained and used.
     *@return the compilation directory to use for the reports.
     */
    public String getTranslatedCompileDirectory()
    {
      String ret = null;
      if( this.isUsingCurrentFilesDirectoryForCompiles() )
      {
         javax.swing.JInternalFrame f = this.jMDIDesktopPane.getSelectedFrame();
         if( f != null && f instanceof JReportFrame )
         {
            JReportFrame rf = (JReportFrame)f;
            String fileName = rf.getReport().getFilename();
            if( fileName != null )
            {
               java.io.File rfile = new java.io.File(fileName);
               ret = rfile.getParent();
            }
            else
            {
               ret = this.getDefaultCompilationDirectory();
            }
            
         }
         else
         {
            ret = this.getDefaultCompilationDirectory();
         }
      }
      else
      {
         ret = this.getDefaultCompilationDirectory();
      }
      return ret;
    }
    
    /**
     *Used to hold the viewer setting.
     *@param reportViewer the viewer to use
     */
    public void setReportViewer(int reportViewer)
    {
       switch( reportViewer )
       {
          case IREPORT_JAVA_VIEWER:
             this.jRadioButtonMenuItemPreviewJAVA.setSelected(true);
            break;
          case IREPORT_PDF_VIEWER:
             this.jRadioButtonMenuItemPreviewPDF.setSelected(true);
            break;
          case IREPORT_HTML_VIEWER:
             this.jRadioButtonMenuItemPreviewHTML.setSelected(true);
            break;            
          case IREPORT_XLS_VIEWER:
             this.jRadioButtonMenuItemPreviewXLS.setSelected(true);
            break;
          case IREPORT_CSV_VIEWER:
             this.jRadioButtonMenuItemPreviewCSV.setSelected(true);
            break;  
          case IREPORT_JASPER_VIEWER:
          default:
             reportViewer = IREPORT_JASPER_VIEWER;
             this.jRadioButtonMenuItemPreviewInternalViewer.setSelected(true);
             break;
       }//end switch report viewer
       this.properties.setProperty("DefaultReportViewer", ""+reportViewer);
       
    }//end setReportViewer
    
    /**
     *Used to get which viewer is in use
     *@returns the in representing the viewer in use.
     */
    public int getReportViewer()
    {
       int ret = IREPORT_JASPER_VIEWER;
       try
       {
         ret = Integer.parseInt(this.properties.getProperty("DefaultReportViewer", ""+IREPORT_JASPER_VIEWER));
       }
       catch(Throwable e)
       {
         //hmm, don't guess we care...we'll correct it internally.
       }
       switch( ret )
       {
          case IREPORT_JAVA_VIEWER:
            break;
          case IREPORT_PDF_VIEWER:
            break;
          case IREPORT_HTML_VIEWER:
            break;            
          case IREPORT_XLS_VIEWER:
            break;
          case IREPORT_CSV_VIEWER:
            break;  
          case IREPORT_JASPER_VIEWER:
          default:
             ret = IREPORT_JASPER_VIEWER;
             break;
       }//end switch report viewer       
       return ret;
    }//end getReportViewer
    public void setEmbeddedIreport(boolean status)
    {
       this.embeddedIreport = status;
    }//end setEmbeddedIreport
    public boolean isEmbedded()
    {
        return this.embeddedIreport;
    }//end isEmbedded
}//end class MainFrame
