/*
 * OptionsDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 14.22
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.util.*;
import javax.swing.*;
/**
 *
 * @author  Administrator
 */
public class OptionsDialog extends javax.swing.JDialog
{
   
   MainFrame mf = null;
   it.businesslogic.ireport.util.Unit[] units;
   /** Creates new form OptionsDialog */
   public OptionsDialog(java.awt.Frame parent, boolean modal)
   {
      super(parent, modal);
      this.mf = (MainFrame)parent;
      initComponents();
      this.setSize(400, 356);
      Misc.centerFrame(this);
      
      
      javax.swing.event.DocumentListener listener =  new javax.swing.event.DocumentListener()
      {
         public void changedUpdate(javax.swing.event.DocumentEvent evt)
         {
            enableApplyAndOk();
         }
         public void insertUpdate(javax.swing.event.DocumentEvent evt)
         {
            enableApplyAndOk();
         }
         public void removeUpdate(javax.swing.event.DocumentEvent evt)
         {
            enableApplyAndOk();
         }
      };
      
      this.jTextFieldBackupDirectory.getDocument().addDocumentListener(listener);
      this.jTextFieldCSVViewer.getDocument().addDocumentListener(listener);
      this.jTextFieldCompilationDir.getDocument().addDocumentListener(listener);
      this.jTextFieldEditor.getDocument().addDocumentListener(listener);
      this.jTextFieldHTMLViewer.getDocument().addDocumentListener(listener);
      this.jTextFieldPDFViewer.getDocument().addDocumentListener(listener);
      this.jTextFieldTemplate.getDocument().addDocumentListener(listener);
      this.jTextFieldXLSViewer.getDocument().addDocumentListener(listener);
      
      units = it.businesslogic.ireport.util.Unit.getStandardUnits();
      for (int i=0; i< units.length; ++i)
      {
         jComboBoxDefaultRulesUnit.addItem( units[i]+"" );
      }
   }
   
   /**
    *This method populate the frame element according with iReport properties...
    */
   public void loadConfiguration()
   {
      if (mf == null || mf.getProperties() == null)
      {
         return;
      }
      try
      {
         this.jNumberFieldRecentFilesListLenght.setValue(Integer.parseInt( Misc.nvl(mf.getProperties().getProperty("RecentFilesLength"),"10")));
         this.jNumberFieldGridSize.setValue( Integer.parseInt(Misc.nvl(mf.getProperties().getProperty("GridSize"),"10") ) );
         this.jTextFieldBackupDirectory.setText( Misc.nvl(mf.getProperties().getProperty("DefaultBackupDirectory"),""));
         this.jTextFieldCSVViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalCSVViewer"),""));
         this.jTextFieldPDFViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalPDFViewer"),""));
         this.jTextFieldXLSViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalXLSViewer"),""));
         this.jTextFieldHTMLViewer.setText( Misc.nvl(mf.getProperties().getProperty("ExternalHTMLViewer"),""));
         this.jTextFieldEditor.setText( Misc.nvl(mf.getProperties().getProperty("ExternalEditor"),""));
         this.jCheckBoxViewRules.setSelected( Misc.nvl(mf.getProperties().getProperty("ViewRules"),"true").equals("true"));
         this.jCheckBoxViewGrid.setSelected( Misc.nvl(mf.getProperties().getProperty("ViewGrid"),"false").equals("true"));
         this.jCheckBoxViewBorderText.setSelected( Misc.nvl(mf.getProperties().getProperty("ViewBorderForTextElements"),"true").equals("true"));
         this.jTextFieldCompilationDir.setText( mf.getDefaultCompilationDirectory() );
         this.jRadioButton1_NoBackup.setSelected( Misc.nvl(mf.getProperties().getProperty("BackupPolicy"),"3").equals("1"));
         this.jRadioButton2_ReplaceExtension.setSelected( Misc.nvl(mf.getProperties().getProperty("BackupPolicy"),"3").equals("2"));
         this.jRadioButton3_AppendExtension.setSelected( Misc.nvl(mf.getProperties().getProperty("BackupPolicy"),"3").equals("3"));
         this.jButtonBorderTextColor.setBackground(new java.awt.Color(Integer.parseInt( Misc.nvl(mf.getProperties().getProperty("ViewBorderColor"),"1") )));
         this.jTextFieldTemplate.setText( Misc.nvl(mf.getProperties().getProperty("DefaultTemplate"),"") );
         this.jCheckBoxAutosave.setSelected(Misc.nvl(mf.getProperties().getProperty("SaveBeforeCompiling"),"true").equals("true"));
         this.jCheckBoxUseMultiLineScripts.setSelected( mf.isUsingMultiLineExpressions() );
         this.jCheckBoxUseCurrentFilesDirectoryForCompiles.setSelected(mf.isUsingCurrentFilesDirectoryForCompiles());
         if(mf.isUsingCurrentFilesDirectoryForCompiles())
         {
            this.disableCompileDirectoryBrowse();
         }
         // Set default unit...
         for (int i=0; i< jComboBoxDefaultRulesUnit.getItemCount(); ++i)
         {
            if ( (jComboBoxDefaultRulesUnit.getItemAt(i)+"").equals( Misc.nvl(mf.getProperties().getProperty("DefaultUnit"),"cm") ) )
            {
               jComboBoxDefaultRulesUnit.setSelectedIndex( i);
               break;
            }
         }
         
      } catch (Exception ex)
      {
         ex.printStackTrace();
      }
      
      this.disableApplyAndOk();
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   private void initComponents()//GEN-BEGIN:initComponents
   {
      buttonGroup1 = new javax.swing.ButtonGroup();
      jTabbedPane1 = new javax.swing.JTabbedPane();
      jPanelGeneral = new javax.swing.JPanel();
      jPanel8 = new javax.swing.JPanel();
      jNumberFieldRecentFilesListLenght = new it.businesslogic.ireport.gui.JNumberField();
      jLabel6 = new javax.swing.JLabel();
      jCheckBoxViewRules = new javax.swing.JCheckBox();
      jCheckBoxViewGrid = new javax.swing.JCheckBox();
      jNumberFieldGridSize = new it.businesslogic.ireport.gui.JNumberField();
      jLabel7 = new javax.swing.JLabel();
      jLabel8 = new javax.swing.JLabel();
      jComboBoxDefaultRulesUnit = new javax.swing.JComboBox();
      jCheckBoxViewBorderText = new javax.swing.JCheckBox();
      jCheckBoxUseMultiLineScripts = new javax.swing.JCheckBox();
      jLabel10 = new javax.swing.JLabel();
      jButtonBorderTextColor = new javax.swing.JButton();
      jTextFieldTemplate = new javax.swing.JTextField();
      jButtonTemplate = new javax.swing.JButton();
      jLabel9 = new javax.swing.JLabel();
      jPanelComper = new javax.swing.JPanel();
      jPanel7 = new javax.swing.JPanel();
      jTextFieldCompilationDir = new javax.swing.JTextField();
      jButtonCompilationDir = new javax.swing.JButton();
      jCheckBoxAutosave = new javax.swing.JCheckBox();
      jCheckBoxUseCurrentFilesDirectoryForCompiles = new javax.swing.JCheckBox();
      jPanelBackup = new javax.swing.JPanel();
      jPanel6 = new javax.swing.JPanel();
      jTextFieldBackupDirectory = new javax.swing.JTextField();
      jButtonBackupDirectory = new javax.swing.JButton();
      jRadioButton1_NoBackup = new javax.swing.JRadioButton();
      jRadioButton2_ReplaceExtension = new javax.swing.JRadioButton();
      jRadioButton3_AppendExtension = new javax.swing.JRadioButton();
      jLabel5 = new javax.swing.JLabel();
      jPanelExternalPrograms = new javax.swing.JPanel();
      jPanel4 = new javax.swing.JPanel();
      jTextFieldEditor = new javax.swing.JTextField();
      jButtonBrowseEditor = new javax.swing.JButton();
      jPanel5 = new javax.swing.JPanel();
      jTextFieldPDFViewer = new javax.swing.JTextField();
      jButtonBrowseEditor1 = new javax.swing.JButton();
      jTextFieldHTMLViewer = new javax.swing.JTextField();
      jButtonBrowseEditor2 = new javax.swing.JButton();
      jTextFieldXLSViewer = new javax.swing.JTextField();
      jButtonBrowseEditor3 = new javax.swing.JButton();
      jLabel1 = new javax.swing.JLabel();
      jLabel2 = new javax.swing.JLabel();
      jLabel3 = new javax.swing.JLabel();
      jLabel4 = new javax.swing.JLabel();
      jTextFieldCSVViewer = new javax.swing.JTextField();
      jButtonBrowseEditor4 = new javax.swing.JButton();
      jPanel1 = new javax.swing.JPanel();
      jButtonCancel = new javax.swing.JButton();
      jButtonOK = new javax.swing.JButton();
      jButtonApply = new javax.swing.JButton();

      FormListener formListener = new FormListener();

      setTitle("iReport Options");
      setResizable(false);
      addWindowListener(formListener);

      jTabbedPane1.setFont(new java.awt.Font("Dialog", 0, 11));
      jPanelGeneral.setLayout(null);

      jPanel8.setLayout(null);

      jPanel8.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "General", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
      jPanel8.setFont(new java.awt.Font("Dialog", 0, 11));
      jNumberFieldRecentFilesListLenght.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
      try
      {
         jNumberFieldRecentFilesListLenght.setDecimals(0);
      } catch (java.beans.PropertyVetoException e1)
      {
         e1.printStackTrace();
      }
      try
      {
         jNumberFieldRecentFilesListLenght.setValue(10.0);
      } catch (java.beans.PropertyVetoException e1)
      {
         e1.printStackTrace();
      }
      jNumberFieldRecentFilesListLenght.addActionListener(formListener);

      jPanel8.add(jNumberFieldRecentFilesListLenght);
      jNumberFieldRecentFilesListLenght.setBounds(180, 26, 52, 21);

      jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel6.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      jLabel6.setText("Num of recent files in file menu");
      jPanel8.add(jLabel6);
      jLabel6.setBounds(24, 28, 156, 15);

      jCheckBoxViewRules.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxViewRules.setSelected(true);
      jCheckBoxViewRules.setText("View rules");
      jCheckBoxViewRules.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jCheckBoxViewRules.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      jCheckBoxViewRules.addItemListener(formListener);

      jPanel8.add(jCheckBoxViewRules);
      jCheckBoxViewRules.setBounds(58, 70, 134, 18);

      jCheckBoxViewGrid.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxViewGrid.setText("View grid");
      jCheckBoxViewGrid.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jCheckBoxViewGrid.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      jCheckBoxViewGrid.addActionListener(formListener);

      jPanel8.add(jCheckBoxViewGrid);
      jCheckBoxViewGrid.setBounds(26, 86, 166, 24);

      jNumberFieldGridSize.setHorizontalAlignment(javax.swing.JTextField.RIGHT);
      try
      {
         jNumberFieldGridSize.setDecimals(0);
      } catch (java.beans.PropertyVetoException e1)
      {
         e1.printStackTrace();
      }
      try
      {
         jNumberFieldGridSize.setValue(10.0);
      } catch (java.beans.PropertyVetoException e1)
      {
         e1.printStackTrace();
      }
      jNumberFieldGridSize.addActionListener(formListener);

      jPanel8.add(jNumberFieldGridSize);
      jNumberFieldGridSize.setBounds(180, 110, 52, 21);

      jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel7.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jLabel7.setText("Grid size");
      jPanel8.add(jLabel7);
      jLabel7.setBounds(58, 112, 118, 16);

      jLabel8.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel8.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jLabel8.setText("Default unit");
      jPanel8.add(jLabel8);
      jLabel8.setBounds(20, 50, 154, 16);

      jComboBoxDefaultRulesUnit.setFont(new java.awt.Font("Dialog", 0, 11));
      jComboBoxDefaultRulesUnit.addActionListener(formListener);

      jPanel8.add(jComboBoxDefaultRulesUnit);
      jComboBoxDefaultRulesUnit.setBounds(180, 48, 76, 20);

      jCheckBoxViewBorderText.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxViewBorderText.setText("View border for text elements");
      jCheckBoxViewBorderText.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jCheckBoxViewBorderText.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      jCheckBoxViewBorderText.addItemListener(formListener);

      jPanel8.add(jCheckBoxViewBorderText);
      jCheckBoxViewBorderText.setBounds(9, 132, 185, 24);

      jCheckBoxUseMultiLineScripts.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxUseMultiLineScripts.setText("Using multi line expressions");
      jCheckBoxUseMultiLineScripts.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jCheckBoxUseMultiLineScripts.setHorizontalTextPosition(javax.swing.SwingConstants.LEFT);
      jCheckBoxUseMultiLineScripts.addItemListener(formListener);

      jPanel8.add(jCheckBoxUseMultiLineScripts);
      jCheckBoxUseMultiLineScripts.setBounds(10, 155, 185, 24);

      jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel10.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
      jLabel10.setText("Text border color");
      jPanel8.add(jLabel10);
      jLabel10.setBounds(60, 180, 114, 16);

      jButtonBorderTextColor.setBackground(new java.awt.Color(128, 128, 128));
      jButtonBorderTextColor.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBorderTextColor.addActionListener(formListener);

      jPanel8.add(jButtonBorderTextColor);
      jButtonBorderTextColor.setBounds(180, 180, 54, 20);

      jPanelGeneral.add(jPanel8);
      jPanel8.setBounds(8, 8, 374, 215);

      jTextFieldTemplate.addActionListener(formListener);
      jTextFieldTemplate.addInputMethodListener(formListener);

      jPanelGeneral.add(jTextFieldTemplate);
      jTextFieldTemplate.setBounds(10, 245, 282, 21);

      jButtonTemplate.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonTemplate.setText("Browse");
      jButtonTemplate.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonTemplate.addActionListener(formListener);

      jPanelGeneral.add(jButtonTemplate);
      jButtonTemplate.setBounds(295, 245, 72, 20);

      jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel9.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
      jLabel9.setText("Use this file as template for new documents");
      jPanelGeneral.add(jLabel9);
      jLabel9.setBounds(10, 225, 282, 16);

      jTabbedPane1.addTab("General", jPanelGeneral);

      jPanelComper.setLayout(null);

      jPanel7.setLayout(null);

      jPanel7.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Default compilation directory", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
      jPanel7.setFont(new java.awt.Font("Dialog", 0, 11));
      jPanel7.add(jTextFieldCompilationDir);
      jTextFieldCompilationDir.setBounds(10, 24, 282, 21);

      jButtonCompilationDir.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonCompilationDir.setText("Browse");
      jButtonCompilationDir.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonCompilationDir.addActionListener(formListener);

      jPanel7.add(jButtonCompilationDir);
      jButtonCompilationDir.setBounds(293, 24, 72, 20);

      jPanelComper.add(jPanel7);
      jPanel7.setBounds(8, 12, 374, 56);

      jCheckBoxAutosave.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxAutosave.setText("Autosave before compiling");
      jCheckBoxAutosave.addActionListener(formListener);

      jPanelComper.add(jCheckBoxAutosave);
      jCheckBoxAutosave.setBounds(10, 90, 372, 24);

      jCheckBoxUseCurrentFilesDirectoryForCompiles.setFont(new java.awt.Font("Dialog", 0, 11));
      jCheckBoxUseCurrentFilesDirectoryForCompiles.setText("Use the reports directory for compiles");
      jCheckBoxUseCurrentFilesDirectoryForCompiles.addActionListener(formListener);

      jPanelComper.add(jCheckBoxUseCurrentFilesDirectoryForCompiles);
      jCheckBoxUseCurrentFilesDirectoryForCompiles.setBounds(10, 70, 372, 24);

      jTabbedPane1.addTab("Compiler", jPanelComper);

      jPanelBackup.setLayout(null);

      jPanel6.setLayout(null);

      jPanel6.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Backup files on save", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
      jPanel6.setFont(new java.awt.Font("Dialog", 0, 11));
      jPanel6.add(jTextFieldBackupDirectory);
      jTextFieldBackupDirectory.setBounds(10, 108, 282, 21);

      jButtonBackupDirectory.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBackupDirectory.setText("Browse");
      jButtonBackupDirectory.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonBackupDirectory.addActionListener(formListener);

      jPanel6.add(jButtonBackupDirectory);
      jButtonBackupDirectory.setBounds(292, 108, 72, 20);

      jRadioButton1_NoBackup.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButton1_NoBackup.setText("No backup");
      buttonGroup1.add(jRadioButton1_NoBackup);
      jRadioButton1_NoBackup.addActionListener(formListener);

      jPanel6.add(jRadioButton1_NoBackup);
      jRadioButton1_NoBackup.setBounds(16, 24, 338, 23);

      jRadioButton2_ReplaceExtension.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButton2_ReplaceExtension.setText("Replace extension with .bak");
      buttonGroup1.add(jRadioButton2_ReplaceExtension);
      jRadioButton2_ReplaceExtension.addActionListener(formListener);

      jPanel6.add(jRadioButton2_ReplaceExtension);
      jRadioButton2_ReplaceExtension.setBounds(16, 44, 338, 23);

      jRadioButton3_AppendExtension.setFont(new java.awt.Font("Dialog", 0, 11));
      jRadioButton3_AppendExtension.setSelected(true);
      jRadioButton3_AppendExtension.setText("Append .bak to existing extension");
      buttonGroup1.add(jRadioButton3_AppendExtension);
      jRadioButton3_AppendExtension.addActionListener(formListener);

      jPanel6.add(jRadioButton3_AppendExtension);
      jRadioButton3_AppendExtension.setBounds(16, 64, 338, 23);

      jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel5.setText("Default backup directory");
      jPanel6.add(jLabel5);
      jLabel5.setBounds(12, 92, 146, 15);

      jPanelBackup.add(jPanel6);
      jPanel6.setBounds(8, 12, 374, 142);

      jTabbedPane1.addTab("Backup", jPanelBackup);

      jPanelExternalPrograms.setLayout(null);

      jPanel4.setLayout(null);

      jPanel4.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "External editor", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
      jPanel4.setFont(new java.awt.Font("Dialog", 0, 11));
      jPanel4.add(jTextFieldEditor);
      jTextFieldEditor.setBounds(10, 24, 282, 21);

      jButtonBrowseEditor.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBrowseEditor.setText("Browse");
      jButtonBrowseEditor.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonBrowseEditor.addActionListener(formListener);

      jPanel4.add(jButtonBrowseEditor);
      jButtonBrowseEditor.setBounds(292, 24, 72, 20);

      jPanelExternalPrograms.add(jPanel4);
      jPanel4.setBounds(8, 12, 374, 56);

      jPanel5.setLayout(null);

      jPanel5.setBorder(new javax.swing.border.TitledBorder(new javax.swing.border.EtchedBorder(), "Viewers", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 0, 11)));
      jPanel5.setFont(new java.awt.Font("Dialog", 0, 11));
      jPanel5.add(jTextFieldPDFViewer);
      jTextFieldPDFViewer.setBounds(10, 32, 282, 21);

      jButtonBrowseEditor1.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBrowseEditor1.setText("Browse");
      jButtonBrowseEditor1.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonBrowseEditor1.addActionListener(formListener);

      jPanel5.add(jButtonBrowseEditor1);
      jButtonBrowseEditor1.setBounds(292, 32, 72, 20);

      jPanel5.add(jTextFieldHTMLViewer);
      jTextFieldHTMLViewer.setBounds(10, 68, 282, 21);

      jButtonBrowseEditor2.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBrowseEditor2.setText("Browse");
      jButtonBrowseEditor2.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonBrowseEditor2.addActionListener(formListener);

      jPanel5.add(jButtonBrowseEditor2);
      jButtonBrowseEditor2.setBounds(292, 68, 72, 20);

      jPanel5.add(jTextFieldXLSViewer);
      jTextFieldXLSViewer.setBounds(10, 104, 282, 21);

      jButtonBrowseEditor3.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBrowseEditor3.setText("Browse");
      jButtonBrowseEditor3.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonBrowseEditor3.addActionListener(formListener);

      jPanel5.add(jButtonBrowseEditor3);
      jButtonBrowseEditor3.setBounds(292, 104, 72, 20);

      jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel1.setText("PDF viewer");
      jPanel5.add(jLabel1);
      jLabel1.setBounds(12, 16, 146, 15);

      jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel2.setText("HTML viewer");
      jPanel5.add(jLabel2);
      jLabel2.setBounds(12, 52, 146, 15);

      jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel3.setText("XLS viewer");
      jPanel5.add(jLabel3);
      jLabel3.setBounds(12, 88, 146, 15);

      jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
      jLabel4.setText("CSV viewer");
      jPanel5.add(jLabel4);
      jLabel4.setBounds(12, 126, 146, 15);

      jPanel5.add(jTextFieldCSVViewer);
      jTextFieldCSVViewer.setBounds(10, 142, 282, 21);

      jButtonBrowseEditor4.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonBrowseEditor4.setText("Browse");
      jButtonBrowseEditor4.setMargin(new java.awt.Insets(2, 2, 2, 2));
      jButtonBrowseEditor4.addActionListener(formListener);

      jPanel5.add(jButtonBrowseEditor4);
      jButtonBrowseEditor4.setBounds(292, 142, 72, 20);

      jPanelExternalPrograms.add(jPanel5);
      jPanel5.setBounds(8, 72, 374, 180);

      jTabbedPane1.addTab("External programs", jPanelExternalPrograms);

      getContentPane().add(jTabbedPane1, java.awt.BorderLayout.CENTER);

      jPanel1.setLayout(null);

      jPanel1.setMinimumSize(new java.awt.Dimension(10, 30));
      jPanel1.setPreferredSize(new java.awt.Dimension(10, 30));
      jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonCancel.setMnemonic('c');
      jButtonCancel.setText("Cancel");
      jButtonCancel.addActionListener(formListener);

      jPanel1.add(jButtonCancel);
      jButtonCancel.setBounds(322, 4, 67, 25);

      jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonOK.setMnemonic('s');
      jButtonOK.setText("Save");
      jButtonOK.setEnabled(false);
      jButtonOK.addActionListener(formListener);

      jPanel1.add(jButtonOK);
      jButtonOK.setBounds(162, 4, 76, 25);

      jButtonApply.setFont(new java.awt.Font("Dialog", 0, 11));
      jButtonApply.setMnemonic('a');
      jButtonApply.setText("Apply");
      jButtonApply.setEnabled(false);
      jButtonApply.addActionListener(formListener);

      jPanel1.add(jButtonApply);
      jButtonApply.setBounds(241, 4, 80, 25);

      getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

      pack();
   }

   // Code for dispatching events from components to event handlers.

   private class FormListener implements java.awt.event.ActionListener, java.awt.event.InputMethodListener, java.awt.event.ItemListener, java.awt.event.WindowListener
   {
      public void actionPerformed(java.awt.event.ActionEvent evt)
      {
         if (evt.getSource() == jNumberFieldRecentFilesListLenght)
         {
            OptionsDialog.this.jNumberFieldRecentFilesListLenghtActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxViewGrid)
         {
            OptionsDialog.this.jCheckBoxViewGridActionPerformed(evt);
         }
         else if (evt.getSource() == jNumberFieldGridSize)
         {
            OptionsDialog.this.jNumberFieldGridSizeActionPerformed(evt);
         }
         else if (evt.getSource() == jComboBoxDefaultRulesUnit)
         {
            OptionsDialog.this.jComboBoxDefaultRulesUnitActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBorderTextColor)
         {
            OptionsDialog.this.jButtonBorderTextColorActionPerformed(evt);
         }
         else if (evt.getSource() == jTextFieldTemplate)
         {
            OptionsDialog.this.jTextFieldTemplateActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonTemplate)
         {
            OptionsDialog.this.jButtonTemplateActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonCompilationDir)
         {
            OptionsDialog.this.jButtonCompilationDirActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxAutosave)
         {
            OptionsDialog.this.jCheckBoxAutosaveActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBackupDirectory)
         {
            OptionsDialog.this.jButtonBackupDirectoryActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButton1_NoBackup)
         {
            OptionsDialog.this.jRadioButton1_NoBackupActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButton2_ReplaceExtension)
         {
            OptionsDialog.this.jRadioButton2_ReplaceExtensionActionPerformed(evt);
         }
         else if (evt.getSource() == jRadioButton3_AppendExtension)
         {
            OptionsDialog.this.jRadioButton3_AppendExtensionActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBrowseEditor)
         {
            OptionsDialog.this.jButtonBrowseEditorActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBrowseEditor1)
         {
            OptionsDialog.this.jButtonBrowseEditor1ActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBrowseEditor2)
         {
            OptionsDialog.this.jButtonBrowseEditor2ActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBrowseEditor3)
         {
            OptionsDialog.this.jButtonBrowseEditor3ActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonBrowseEditor4)
         {
            OptionsDialog.this.jButtonBrowseEditor4ActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonCancel)
         {
            OptionsDialog.this.jButtonCancelActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonOK)
         {
            OptionsDialog.this.jButtonOKActionPerformed(evt);
         }
         else if (evt.getSource() == jButtonApply)
         {
            OptionsDialog.this.jButtonApplyActionPerformed(evt);
         }
         else if (evt.getSource() == jCheckBoxUseCurrentFilesDirectoryForCompiles)
         {
            OptionsDialog.this.jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(evt);
         }
      }

      public void caretPositionChanged(java.awt.event.InputMethodEvent evt)
      {
      }

      public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt)
      {
         if (evt.getSource() == jTextFieldTemplate)
         {
            OptionsDialog.this.jTextFieldTemplateInputMethodTextChanged(evt);
         }
      }

      public void itemStateChanged(java.awt.event.ItemEvent evt)
      {
         if (evt.getSource() == jCheckBoxViewRules)
         {
            OptionsDialog.this.jCheckBoxViewRulesItemStateChanged(evt);
         }
         else if (evt.getSource() == jCheckBoxViewBorderText)
         {
            OptionsDialog.this.jCheckBoxViewBorderTextItemStateChanged(evt);
         }
         else if (evt.getSource() == jCheckBoxUseMultiLineScripts)
         {
            OptionsDialog.this.jCheckBoxUseMultiLineScriptsItemStateChanged(evt);
         }
      }

      public void windowActivated(java.awt.event.WindowEvent evt)
      {
      }

      public void windowClosed(java.awt.event.WindowEvent evt)
      {
      }

      public void windowClosing(java.awt.event.WindowEvent evt)
      {
         if (evt.getSource() == OptionsDialog.this)
         {
            OptionsDialog.this.closeDialog(evt);
         }
      }

      public void windowDeactivated(java.awt.event.WindowEvent evt)
      {
      }

      public void windowDeiconified(java.awt.event.WindowEvent evt)
      {
      }

      public void windowIconified(java.awt.event.WindowEvent evt)
      {
      }

      public void windowOpened(java.awt.event.WindowEvent evt)
      {
      }
   }//GEN-END:initComponents

    private void jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed
    {//GEN-HEADEREND:event_jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed
       if(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected())
       {
         this.disableCompileDirectoryBrowse();
       }
       else
       {
         this.enableCompileDirectoryBrowse();         
       }
       this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxUseCurrentFilesDirectoryForCompilesActionPerformed
    
    private void jCheckBoxUseMultiLineScriptsItemStateChanged(java.awt.event.ItemEvent evt)//GEN-FIRST:event_jCheckBoxUseMultiLineScriptsItemStateChanged
    {//GEN-HEADEREND:event_jCheckBoxUseMultiLineScriptsItemStateChanged
      this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxUseMultiLineScriptsItemStateChanged
    
    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
       if  ( jButtonApply.isEnabled())
          jButtonApplyActionPerformed(evt);
       
       if (mf != null) mf.saveiReportConfiguration();
       this.jButtonOK.setEnabled(false);
       this.setVisible(false);
       this.dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    private void jButtonApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyActionPerformed
       applyConfiguration();
       jButtonApply.setEnabled(false);
    }//GEN-LAST:event_jButtonApplyActionPerformed
    
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
       this.setVisible(false);
       this.dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed
    
    private void jButtonBrowseEditor4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor4ActionPerformed
       javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
       
       jfc.setDialogTitle("Choose an CSV viewer...");
       jfc.setMultiSelectionEnabled(false);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldCSVViewer.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonBrowseEditor4ActionPerformed
    
    private void jButtonBrowseEditor3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor3ActionPerformed
       javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
       
       jfc.setDialogTitle("Choose an XLS viewer...");
       jfc.setMultiSelectionEnabled(false);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldXLSViewer.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonBrowseEditor3ActionPerformed
    
    private void jButtonBrowseEditor2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor2ActionPerformed
       javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
       
       jfc.setDialogTitle("Choose an HTML viewer...");
       jfc.setMultiSelectionEnabled(false);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldHTMLViewer.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonBrowseEditor2ActionPerformed
    
    private void jButtonBrowseEditor1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditor1ActionPerformed
       javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
       
       jfc.setDialogTitle("Choose an PDF viewer...");
       jfc.setMultiSelectionEnabled(false);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldPDFViewer.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonBrowseEditor1ActionPerformed
    
    private void jButtonBrowseEditorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBrowseEditorActionPerformed
       javax.swing.JFileChooser jfc = new javax.swing.JFileChooser();
       
       jfc.setDialogTitle("Choose an editor...");
       jfc.setMultiSelectionEnabled(false);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldEditor.setText( jfc.getSelectedFile().getPath());
       }
       
    }//GEN-LAST:event_jButtonBrowseEditorActionPerformed
    
    private void jButtonBackupDirectoryActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBackupDirectoryActionPerformed
       JFileChooser jfc = new JFileChooser();
       jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldBackupDirectory.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonBackupDirectoryActionPerformed
    
    private void jButtonCompilationDirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCompilationDirActionPerformed
       
       JFileChooser jfc = new JFileChooser();
       jfc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldCompilationDir.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonCompilationDirActionPerformed
    
    private void jButtonTemplateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonTemplateActionPerformed
       // jfilechooser...
       JFileChooser jfc = new JFileChooser();
       jfc.setFileFilter( new javax.swing.filechooser.FileFilter()
       {
          public boolean accept(java.io.File file)
          {
             String filename = file.getName();
             return (filename.endsWith(".xml") || file.isDirectory()) ;
          }
          public String getDescription()
          {
             return "JasperReports XML *.xml";
          }
       });
       if (jfc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION)
       {
          jTextFieldTemplate.setText( jfc.getSelectedFile().getPath());
       }
    }//GEN-LAST:event_jButtonTemplateActionPerformed
    
    private void jRadioButton3_AppendExtensionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton3_AppendExtensionActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jRadioButton3_AppendExtensionActionPerformed
    
    private void jRadioButton2_ReplaceExtensionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2_ReplaceExtensionActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jRadioButton2_ReplaceExtensionActionPerformed
    
    private void jRadioButton1_NoBackupActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1_NoBackupActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jRadioButton1_NoBackupActionPerformed
    
    private void jCheckBoxAutosaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxAutosaveActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxAutosaveActionPerformed
    
    private void jTextFieldTemplateInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_jTextFieldTemplateInputMethodTextChanged
      this.enableApplyAndOk();
    }//GEN-LAST:event_jTextFieldTemplateInputMethodTextChanged
    
    private void jTextFieldTemplateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextFieldTemplateActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jTextFieldTemplateActionPerformed
    
    private void jButtonBorderTextColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonBorderTextColorActionPerformed
       JColorChooser jcc = new JColorChooser();
       java.awt.Color c = jcc.showDialog(null,"Select a color...", jButtonBorderTextColor.getBackground());
       if (c != null)
       {
          this.enableApplyAndOk();
          jButtonBorderTextColor.setBackground(c);
          jButtonBorderTextColor.updateUI();
       }
    }//GEN-LAST:event_jButtonBorderTextColorActionPerformed
    
    private void jCheckBoxViewBorderTextItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxViewBorderTextItemStateChanged
      this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxViewBorderTextItemStateChanged
    
    private void jNumberFieldGridSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldGridSizeActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jNumberFieldGridSizeActionPerformed
    
    private void jCheckBoxViewRulesItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCheckBoxViewRulesItemStateChanged
      this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxViewRulesItemStateChanged
    
    private void jComboBoxDefaultRulesUnitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxDefaultRulesUnitActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jComboBoxDefaultRulesUnitActionPerformed
    
    private void jNumberFieldRecentFilesListLenghtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jNumberFieldRecentFilesListLenghtActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jNumberFieldRecentFilesListLenghtActionPerformed
    
    private void jCheckBoxViewGridActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBoxViewGridActionPerformed
      this.enableApplyAndOk();
    }//GEN-LAST:event_jCheckBoxViewGridActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
       setVisible(false);
       dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[])
    {
       new OptionsDialog(new javax.swing.JFrame(), true).show();
    }
    
    
   // Variables declaration - do not modify//GEN-BEGIN:variables
   protected javax.swing.ButtonGroup buttonGroup1;
   protected javax.swing.JButton jButtonApply;
   protected javax.swing.JButton jButtonBackupDirectory;
   protected javax.swing.JButton jButtonBorderTextColor;
   protected javax.swing.JButton jButtonBrowseEditor;
   protected javax.swing.JButton jButtonBrowseEditor1;
   protected javax.swing.JButton jButtonBrowseEditor2;
   protected javax.swing.JButton jButtonBrowseEditor3;
   protected javax.swing.JButton jButtonBrowseEditor4;
   protected javax.swing.JButton jButtonCancel;
   protected javax.swing.JButton jButtonCompilationDir;
   protected javax.swing.JButton jButtonOK;
   protected javax.swing.JButton jButtonTemplate;
   protected javax.swing.JCheckBox jCheckBoxAutosave;
   protected javax.swing.JCheckBox jCheckBoxUseCurrentFilesDirectoryForCompiles;
   protected javax.swing.JCheckBox jCheckBoxUseMultiLineScripts;
   protected javax.swing.JCheckBox jCheckBoxViewBorderText;
   protected javax.swing.JCheckBox jCheckBoxViewGrid;
   protected javax.swing.JCheckBox jCheckBoxViewRules;
   protected javax.swing.JComboBox jComboBoxDefaultRulesUnit;
   protected javax.swing.JLabel jLabel1;
   protected javax.swing.JLabel jLabel10;
   protected javax.swing.JLabel jLabel2;
   protected javax.swing.JLabel jLabel3;
   protected javax.swing.JLabel jLabel4;
   protected javax.swing.JLabel jLabel5;
   protected javax.swing.JLabel jLabel6;
   protected javax.swing.JLabel jLabel7;
   protected javax.swing.JLabel jLabel8;
   protected javax.swing.JLabel jLabel9;
   protected it.businesslogic.ireport.gui.JNumberField jNumberFieldGridSize;
   protected it.businesslogic.ireport.gui.JNumberField jNumberFieldRecentFilesListLenght;
   protected javax.swing.JPanel jPanel1;
   protected javax.swing.JPanel jPanel4;
   protected javax.swing.JPanel jPanel5;
   protected javax.swing.JPanel jPanel6;
   protected javax.swing.JPanel jPanel7;
   protected javax.swing.JPanel jPanel8;
   protected javax.swing.JPanel jPanelBackup;
   protected javax.swing.JPanel jPanelComper;
   protected javax.swing.JPanel jPanelExternalPrograms;
   protected javax.swing.JPanel jPanelGeneral;
   protected javax.swing.JRadioButton jRadioButton1_NoBackup;
   protected javax.swing.JRadioButton jRadioButton2_ReplaceExtension;
   protected javax.swing.JRadioButton jRadioButton3_AppendExtension;
   protected javax.swing.JTabbedPane jTabbedPane1;
   protected javax.swing.JTextField jTextFieldBackupDirectory;
   protected javax.swing.JTextField jTextFieldCSVViewer;
   protected javax.swing.JTextField jTextFieldCompilationDir;
   protected javax.swing.JTextField jTextFieldEditor;
   protected javax.swing.JTextField jTextFieldHTMLViewer;
   protected javax.swing.JTextField jTextFieldPDFViewer;
   protected javax.swing.JTextField jTextFieldTemplate;
   protected javax.swing.JTextField jTextFieldXLSViewer;
   // End of variables declaration//GEN-END:variables
   /*
    public void setVisible(boolean visible)
    {
        if (visible == true && visible != this.isVisible()) loadConfiguration();
        super.setVisible( visible);
    }
    */
    
    public void applyConfiguration()
    {
       if (mf == null || mf.getProperties() == null)
       {
          return;
       }
       java.util.Properties prop = mf.getProperties();
       try
       {
          prop.put("RecentFilesLength", ""+(int)this.jNumberFieldRecentFilesListLenght.getValue());
          prop.put("GridSize",""+(int)this.jNumberFieldGridSize.getValue());
          prop.put("DefaultBackupDirectory",""+this.jTextFieldBackupDirectory.getText());
          prop.put("ExternalCSVViewer",""+this.jTextFieldCSVViewer.getText());
          prop.put("ExternalPDFViewer",""+this.jTextFieldPDFViewer.getText());
          prop.put("ExternalXLSViewer",""+this.jTextFieldXLSViewer.getText());
          prop.put("ExternalHTMLViewer",""+this.jTextFieldHTMLViewer.getText());
          prop.put("ExternalEditor",""+this.jTextFieldEditor.getText());
          prop.put("ViewRules",""+this.jCheckBoxViewRules.isSelected());
          prop.put("ViewGrid",""+this.jCheckBoxViewGrid.isSelected());
          prop.put("ViewBorderForTextElements",""+this.jCheckBoxViewBorderText.isSelected());
          prop.put("ViewRules",""+this.jCheckBoxViewRules.isSelected());
          prop.put("DefaultTemplate",""+this.jTextFieldTemplate.getText());
          prop.put("SaveBeforeCompiling",""+this.jCheckBoxAutosave.isSelected());
          prop.put("DefaultUnit",""+this.jComboBoxDefaultRulesUnit.getSelectedItem()+"" );
          //MainFrame and this code need to implement and use an object that houses the properties
          //object and have methods for these options.
          mf.setUsingMultiLineExpressions(this.jCheckBoxUseMultiLineScripts.isSelected());
          mf.setUsingCurrentFilesDirectoryForCompiles(this.jCheckBoxUseCurrentFilesDirectoryForCompiles.isSelected());
          mf.setDefaultCompilationDirectory(this.jTextFieldCompilationDir.getText());
          
          String policy = "3";
          if (this.jRadioButton1_NoBackup.isSelected())  policy = "1";
          if (this.jRadioButton2_ReplaceExtension.isSelected())  policy = "2";
          if (this.jRadioButton3_AppendExtension.isSelected())  policy = "3";
          
          prop.put("BackupPolicy", policy );
          prop.put("ViewBorderColor",""+this.jButtonBorderTextColor.getBackground().getRGB() );
          
       } catch (Exception ex)
       {}
       
       this.jButtonApply.setEnabled(false);
       
    }
    
    protected void enableCompileDirectoryBrowse()
    {
      this.jTextFieldCompilationDir.setEnabled(true);
      this.jButtonCompilationDir.setEnabled(true);
    }
 
    protected void disableCompileDirectoryBrowse()
    {
      this.jTextFieldCompilationDir.setEnabled(false);
      this.jButtonCompilationDir.setEnabled(false);       
    }

    protected void disableApplyAndOk()
    {
      this.jButtonApply.setEnabled(false);
      this.jButtonOK.setEnabled(false);
    }
    
    protected void disableApply()
    {
      this.jButtonOK.setEnabled(false);
    }
    
    protected void enableApplyAndOk()
    {
      this.jButtonApply.setEnabled(true);
      this.jButtonOK.setEnabled(true);
    }
    
    protected void enableApply()
    {
      this.jButtonOK.setEnabled(true);
    }    
    
}//end class OptionsDialog
