/*
 * ProjectDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 4 giugno 2003, 1.34
 */

package it.businesslogic.ireport.gui;
import it.businesslogic.ireport.util.*;
/**
 *
 * @author  Administrator
 */
public class ProjectDialog extends javax.swing.JDialog {
    
    /** Creates new form ProjectDialog */
    public ProjectDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setSize(400, 260);           
        Misc.centerFrame(this);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jLabel1 = new javax.swing.JLabel();
        jTextFieldProjectName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jTextFieldSourcesDir = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jLabel3 = new javax.swing.JLabel();
        jTextFieldOutputDir = new javax.swing.JTextField();
        jButton2 = new javax.swing.JButton();
        jLabel4 = new javax.swing.JLabel();
        jComboBoxConnection = new javax.swing.JComboBox();
        jButtonCancel = new javax.swing.JButton();
        jButtonSave = new javax.swing.JButton();

        getContentPane().setLayout(null);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Project name");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(6, 4, 190, 16);

        getContentPane().add(jTextFieldProjectName);
        jTextFieldProjectName.setBounds(4, 22, 352, 20);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setText("Sources directory");
        getContentPane().add(jLabel2);
        jLabel2.setBounds(8, 48, 198, 16);

        getContentPane().add(jTextFieldSourcesDir);
        jTextFieldSourcesDir.setBounds(6, 66, 274, 20);

        jButton1.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton1.setText("Browse");
        getContentPane().add(jButton1);
        jButton1.setBounds(282, 66, 73, 20);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setText("Output directory");
        getContentPane().add(jLabel3);
        jLabel3.setBounds(8, 90, 198, 16);

        getContentPane().add(jTextFieldOutputDir);
        jTextFieldOutputDir.setBounds(6, 108, 274, 20);

        jButton2.setFont(new java.awt.Font("Dialog", 0, 11));
        jButton2.setText("Browse");
        getContentPane().add(jButton2);
        jButton2.setBounds(282, 108, 73, 20);

        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setText("Default connection");
        getContentPane().add(jLabel4);
        jLabel4.setBounds(10, 134, 198, 16);

        getContentPane().add(jComboBoxConnection);
        jComboBoxConnection.setBounds(8, 152, 346, 22);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonCancel);
        jButtonCancel.setBounds(270, 196, 84, 25);

        jButtonSave.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonSave.setMnemonic('s');
        jButtonSave.setText("Save");
        jButtonSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSaveActionPerformed(evt);
            }
        });

        getContentPane().add(jButtonSave);
        jButtonSave.setBounds(184, 196, 82, 25);

        pack();
    }//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed

        
        
        
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSaveActionPerformed
        
        /* TODO: Check user inputs */
        this.setProjectName( this.jTextFieldProjectName.getText());
        this.setSourcesDir( this.jTextFieldSourcesDir.getText());
        this.setOutputDir( this.jTextFieldOutputDir.getText());
        this.setConnection(this.jComboBoxConnection.getSelectedItem()+"");
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        setVisible(false);
        dispose();
    }//GEN-LAST:event_jButtonSaveActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ProjectDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property connection.
     * @return Value of property connection.
     *
     */
    public java.lang.String getConnection() {
        return connection;
    }    
    
    /** Setter for property connection.
     * @param connection New value of property connection.
     *
     */
    public void setConnection(java.lang.String connection) {
        this.connection = connection;
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    /** Getter for property outputDir.
     * @return Value of property outputDir.
     *
     */
    public java.lang.String getOutputDir() {
        return outputDir;
    }
    
    /** Setter for property outputDir.
     * @param outputDir New value of property outputDir.
     *
     */
    public void setOutputDir(java.lang.String outputDir) {
        this.outputDir = outputDir;
    }
    
    /** Getter for property projectName.
     * @return Value of property projectName.
     *
     */
    public java.lang.String getProjectName() {
        return projectName;
    }
    
    /** Setter for property projectName.
     * @param projectName New value of property projectName.
     *
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    
    /** Getter for property sourcesDir.
     * @return Value of property sourcesDir.
     *
     */
    public java.lang.String getSourcesDir() {
        return sourcesDir;
    }
    
    /** Setter for property sourcesDir.
     * @param sourcesDir New value of property sourcesDir.
     *
     */
    public void setSourcesDir(java.lang.String sourcesDir) {
        this.sourcesDir = sourcesDir;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel4;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonSave;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton jButton1;
    private javax.swing.JTextField jTextFieldSourcesDir;
    private javax.swing.JComboBox jComboBoxConnection;
    private javax.swing.JTextField jTextFieldOutputDir;
    private javax.swing.JTextField jTextFieldProjectName;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
    
    private String projectName;
    
    private String sourcesDir;
    
    private String outputDir;
    
    private String connection;
    
}
