package it.businesslogic.ireport.util;

import java.awt.*;
import java.util.*;

public class Java2DUtil
{
  private static Stack clipBoundsStack = new Stack();

  public static void setClip(Graphics g, int x, int y, int width, int height)
  {
    setClip(g, new Rectangle(x, y, width, height));
  }

  public static void setClip(Graphics g, Rectangle clipBounds)
  {
    Rectangle currentClipBounds;

    clipBounds = new Rectangle(clipBounds);
    clipBounds.width += 1;
    clipBounds.height += 1;

    currentClipBounds = g.getClipBounds();
    if(currentClipBounds != null)
    {
      clipBounds = clipBounds.intersection(g.getClipBounds());
    }

    clipBoundsStack.push(currentClipBounds);
    g.setClip(clipBounds);
  }

  public static void resetClip(Graphics g)
  {
    g.setClip((Shape) clipBoundsStack.pop());
  }
}
