/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlInternalException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.lib.HsqlArrayList;

final class CompiledStatementExecutor {
    private Session session;
    private Result updateResult;
    private Result emptyResult;

    CompiledStatementExecutor(Session session) {
        this.session = session;
        this.updateResult = new Result(1);
        this.emptyResult = new Result(1);
    }

    Result execute(CompiledStatement compiledStatement) {
        Result result = null;
        DatabaseManager.gc();
        try {
            compiledStatement.materializeSubQueries();
            result = this.executeImpl(compiledStatement);
        }
        catch (Throwable throwable) {
            result = new Result(throwable, compiledStatement.sql);
        }
        compiledStatement.dematerializeSubQueries();
        if (result == null) {
            result = this.emptyResult;
        }
        return result;
    }

    private Result executeImpl(CompiledStatement compiledStatement) throws HsqlException {
        switch (compiledStatement.type) {
            case 5: {
                return this.executeSelectStatement(compiledStatement);
            }
            case 2: {
                return this.executeInsertSelectStatement(compiledStatement);
            }
            case 1: {
                return this.executeInsertValuesStatement(compiledStatement);
            }
            case 3: {
                return this.executeUpdateStatement(compiledStatement);
            }
            case 4: {
                return this.executeDeleteStatement(compiledStatement);
            }
            case 6: {
                return this.executeCallStatement(compiledStatement);
            }
            case 9: {
                return this.executeDDLStatement(compiledStatement);
            }
        }
        throw Trace.error(201);
    }

    private Result executeCallStatement(CompiledStatement compiledStatement) throws HsqlException {
        Expression expression = compiledStatement.expression;
        Object object = expression.getValue();
        if (object instanceof Result) {
            return (Result)object;
        }
        if (object instanceof jdbcResultSet) {
            return ((jdbcResultSet)object).rResult;
        }
        Result result = Result.newSingleColumnResult("@0", expression.getDataType());
        Object[] objectArray = new Object[]{object};
        result.metaData.sClassName[0] = expression.getValueClassName();
        result.add(objectArray);
        return result;
    }

    private Result executeDeleteStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.tf;
        int n = 0;
        if (tableFilter.findFirst()) {
            Expression expression = compiledStatement.condition;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            if (expression == null) {
                do {
                    hsqlArrayList.add(tableFilter.currentRow);
                } while (tableFilter.next());
                n = table.delete(hsqlArrayList, this.session);
            } else {
                do {
                    if (!expression.test()) continue;
                    hsqlArrayList.add(tableFilter.currentRow);
                } while (tableFilter.next());
                n = table.delete(hsqlArrayList, this.session);
            }
        }
        this.updateResult.iUpdateCount = n;
        return this.updateResult;
    }

    private Result executeInsertSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        int n;
        Table table = compiledStatement.targetTable;
        Select select = compiledStatement.select;
        int[] nArray = table.getColumnTypes();
        Result result = select.getResult(this.session.getMaxRows());
        Record record = result.rRoot;
        int[] nArray2 = compiledStatement.columnMap;
        boolean[] blArray = compiledStatement.checkColumns;
        int n2 = nArray2.length;
        this.session.beginNestedTransaction();
        try {
            while (record != null) {
                Object[] objectArray = table.getNewRow(blArray);
                for (int i = 0; i < n2; ++i) {
                    int n3 = nArray2[i];
                    objectArray[n3] = nArray[n3] != result.metaData.colType[i] ? Column.convertObject(record.data[i], nArray[n3]) : record.data[i];
                }
                record.data = objectArray;
                record = record.next;
            }
            n = table.insert(result, this.session);
            this.session.endNestedTransaction(false);
        }
        catch (HsqlException hsqlException) {
            this.session.endNestedTransaction(true);
            throw hsqlException;
        }
        this.updateResult.iUpdateCount = n;
        return this.updateResult;
    }

    private Result executeInsertValuesStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        Object[] objectArray = table.getNewRow(compiledStatement.checkColumns);
        int[] nArray = compiledStatement.columnMap;
        Expression[] expressionArray = compiledStatement.columnValues;
        int[] nArray2 = table.getColumnTypes();
        int n = expressionArray.length;
        for (int i = 0; i < n; ++i) {
            Expression expression = expressionArray[i];
            int n2 = nArray[i];
            objectArray[n2] = expression.getValue(nArray2[n2]);
        }
        table.insert(objectArray, this.session);
        this.updateResult.iUpdateCount = 1;
        return this.updateResult;
    }

    private Result executeSelectStatement(CompiledStatement compiledStatement) throws HsqlException {
        return compiledStatement.select.getResult(this.session.getMaxRows());
    }

    private Result executeUpdateStatement(CompiledStatement compiledStatement) throws HsqlException {
        Table table = compiledStatement.targetTable;
        TableFilter tableFilter = compiledStatement.tf;
        int n = 0;
        if (tableFilter.findFirst()) {
            int[] nArray = compiledStatement.columnMap;
            Expression[] expressionArray = compiledStatement.columnValues;
            Expression expression = compiledStatement.condition;
            int n2 = expressionArray.length;
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            Result result = new Result(1);
            int n3 = table.getColumnCount();
            int[] nArray2 = table.getColumnTypes();
            do {
                if (expression != null && !expression.test()) continue;
                try {
                    Row row = tableFilter.currentRow;
                    Object[] objectArray = table.getNewRow();
                    System.arraycopy(row.getData(), 0, objectArray, 0, n3);
                    for (int i = 0; i < n2; ++i) {
                        int n4 = nArray[i];
                        objectArray[n4] = expressionArray[i].getValue(nArray2[n4]);
                    }
                    hsqlArrayList.add(row);
                    result.add(objectArray);
                }
                catch (HsqlInternalException hsqlInternalException) {
                    // empty catch block
                }
            } while (tableFilter.next());
            this.session.beginNestedTransaction();
            try {
                n = table.update(hsqlArrayList, result, nArray, this.session);
                this.session.endNestedTransaction(false);
            }
            catch (HsqlException hsqlException) {
                this.session.endNestedTransaction(true);
                throw hsqlException;
            }
        }
        this.updateResult.iUpdateCount = n;
        return this.updateResult;
    }

    private Result executeDDLStatement(CompiledStatement compiledStatement) throws HsqlException {
        return this.session.sqlExecuteDirectNoPreChecks(compiledStatement.sql);
    }
}

