/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

final class CompiledStatementManager {
    Database database;
    IntValueHashMap sqlMap;
    IntKeyHashMap sqlLookup;
    IntKeyHashMap csidMap;
    IntKeyHashMap sessionMap;
    IntKeyIntValueHashMap useMap;
    private int next_cs_id;

    CompiledStatementManager(Database database) {
        this.database = database;
        this.sqlMap = new IntValueHashMap();
        this.sqlLookup = new IntKeyHashMap();
        this.csidMap = new IntKeyHashMap();
        this.sessionMap = new IntKeyHashMap();
        this.useMap = new IntKeyIntValueHashMap();
        this.next_cs_id = 0;
    }

    void reset() {
        this.sqlMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.sessionMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0;
    }

    void resetStatements() {
        Iterator iterator = this.csidMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = iterator.nextInt();
            this.csidMap.put(n, null);
        }
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    synchronized int getStatementID(String string) {
        return this.sqlMap.get((Object)string, -1);
    }

    synchronized CompiledStatement getStatement(int n) {
        return (CompiledStatement)this.csidMap.get(n);
    }

    synchronized String getSql(int n) {
        return (String)this.sqlLookup.get(n);
    }

    synchronized void linkSession(int n, int n2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionMap.get(n2);
        if (intKeyIntValueHashMap == null) {
            intKeyIntValueHashMap = new IntKeyIntValueHashMap();
            this.sessionMap.put(n2, intKeyIntValueHashMap);
        }
        int n3 = intKeyIntValueHashMap.get(n, 0);
        intKeyIntValueHashMap.put(n, n3 + 1);
        if (n3 == 0) {
            this.useMap.put(n, this.useMap.get(n, 0) + 1);
        }
    }

    synchronized int registerStatement(int n, CompiledStatement compiledStatement) {
        if (n < 0) {
            n = this.nextID();
            this.sqlMap.put(compiledStatement.sql, n);
            this.sqlLookup.put(n, compiledStatement.sql);
        }
        this.csidMap.put(n, compiledStatement);
        return n;
    }

    synchronized void freeStatement(int n, int n2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionMap.get(n2);
        int n3 = intKeyIntValueHashMap.get(n) - 1;
        if (n3 != 0) {
            intKeyIntValueHashMap.put(n, n3);
        } else {
            intKeyIntValueHashMap.remove(n);
            int n4 = this.useMap.get(n, 1) - 1;
            if (n4 == 0) {
                String string = (String)this.sqlLookup.remove(n);
                this.sqlMap.remove(string);
                this.csidMap.remove(n);
                this.useMap.remove(n);
            } else {
                this.useMap.put(n, n4);
            }
        }
    }

    synchronized void removeSession(int n) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionMap.remove(n);
        if (intKeyIntValueHashMap == null) {
            return;
        }
        Iterator iterator = intKeyIntValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.nextInt();
            int n3 = this.useMap.get(n2, 1) - 1;
            if (n3 == 0) {
                String string = (String)this.sqlLookup.remove(n2);
                this.sqlMap.remove(string);
                this.csidMap.remove(n2);
                this.useMap.remove(n2);
                continue;
            }
            this.useMap.put(n2, n3);
        }
    }
}

