/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputBinary;

public class HSQLClientConnection
implements SessionInterface {
    static final int BUFFER_SIZE = 4096;
    final byte[] mainBuffer = new byte[4096];
    private boolean isClosed;
    private Socket socket;
    protected OutputStream dataOutput;
    protected DataInputStream dataInput;
    protected RowOutputBinary rowOut;
    protected RowInputBinary rowIn;
    private Result resultOut;
    private final int sessionID;
    String host;
    int port;
    String path;
    String database;
    boolean isTLS;
    int databaseID;

    public HSQLClientConnection(String string, int n, String string2, String string3, boolean bl, String string4, String string5) throws HsqlException {
        this.host = string;
        this.port = n;
        this.path = string2;
        this.database = string3;
        this.isTLS = bl;
        this.initStructures();
        Result result = new Result(65543);
        result.mainString = string4;
        result.subString = string5;
        result.subSubString = string3;
        this.initConnection(string, n, bl);
        Result result2 = this.execute(result);
        if (result2.iMode == 2) {
            throw Trace.error(result2);
        }
        this.sessionID = result2.sessionID;
        this.databaseID = result2.databaseID;
    }

    private void initStructures() {
        this.rowOut = new RowOutputBinary(this.mainBuffer);
        this.rowIn = new RowInputBinary(this.rowOut);
        this.resultOut = new Result(3, 7);
        this.resultOut.metaData.sTable = new String[]{"", "", "", "", "", "", ""};
        this.resultOut.metaData.sLabel = this.resultOut.metaData.sTable;
        this.resultOut.metaData.sName = this.resultOut.metaData.sTable;
        this.resultOut.add(new Object[7]);
        this.resultOut.metaData.colType = new int[]{12, 12, 4, 4, 16, 16, 16};
    }

    protected void initConnection(String string, int n, boolean bl) throws HsqlException {
        this.openConnection(string, n, bl);
    }

    protected void openConnection(String string, int n, boolean bl) throws HsqlException {
        try {
            this.socket = HsqlSocketFactory.getInstance(bl).createSocket(string, n);
            this.dataOutput = new BufferedOutputStream(this.socket.getOutputStream());
            this.dataInput = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (Exception exception) {
            throw Trace.error(80);
        }
    }

    protected void closeConnection() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
    }

    public synchronized Result execute(Result result) throws HsqlException {
        try {
            result.sessionID = this.sessionID;
            result.databaseID = this.databaseID;
            this.write(result);
            return this.read();
        }
        catch (Exception exception) {
            throw Trace.error(3, exception.getMessage());
        }
    }

    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        try {
            this.resultOut.setResultType(65545);
            this.execute(this.resultOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object getAttribute(int n) throws HsqlException {
        this.resultOut.setResultType(7);
        Result result = this.execute(this.resultOut);
        return result.rRoot.data[n];
    }

    private void setAttribute(Object object, int n) throws HsqlException {
        this.resultOut.setResultType(6);
        ArrayUtil.fillArray(this.resultOut.rRoot.data, null);
        this.resultOut.rRoot.data[n] = object;
        Result result = this.execute(this.resultOut);
        if (result.iMode == 2) {
            throw Trace.error(result);
        }
    }

    public boolean isReadOnly() throws HsqlException {
        Object object = this.getAttribute(6);
        return (Boolean)object;
    }

    public void setReadOnly(boolean bl) throws HsqlException {
        this.setAttribute(bl ? Boolean.TRUE : Boolean.FALSE, 6);
    }

    public boolean isAutoCommit() throws HsqlException {
        Object object = this.getAttribute(4);
        return (Boolean)object;
    }

    public void setAutoCommit(boolean bl) throws HsqlException {
        this.setAttribute(bl ? Boolean.TRUE : Boolean.FALSE, 4);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Session getSession() {
        return null;
    }

    public void commit() throws HsqlException {
        this.resultOut.setResultType(66541);
        this.resultOut.iUpdateCount = 0;
        this.resultOut.setMainString("");
        this.execute(this.resultOut);
    }

    public void rollback() throws HsqlException {
        this.resultOut.setResultType(66541);
        this.resultOut.iUpdateCount = 1;
        this.resultOut.setMainString("");
        this.execute(this.resultOut);
    }

    public int getId() {
        return this.sessionID;
    }

    protected void write(Result result) throws IOException, HsqlException {
        Result.write(result, this.rowOut, this.dataOutput);
    }

    protected Result read() throws IOException, HsqlException {
        Result result = Result.read(this.rowIn, this.dataInput);
        this.rowOut.setBuffer(this.mainBuffer);
        this.rowIn.resetRow(this.mainBuffer.length);
        return result;
    }
}

