/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.hsqldb.Trace;

public class HsqlDateTime {
    private static java.sql.Date today = new java.sql.Date(0L);
    private static java.sql.Date tempDate = new java.sql.Date(0L);
    private static Calendar tempCal = new GregorianCalendar();
    private static final String sdftPattern = "HH:mm:ss";
    private static final String sdfdPattern = "yyyy-MM-dd";
    private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
    static SimpleDateFormat sdfd = new SimpleDateFormat("yyyy-MM-dd");
    static SimpleDateFormat sdft = new SimpleDateFormat("HH:mm:ss");
    static SimpleDateFormat sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");

    static Timestamp timestampValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        if (string.indexOf(45) == -1) {
            if ((string = string.toUpperCase()).equals("NOW") || string.equals("CURRENT_TIMESTAMP")) {
                return new Timestamp(System.currentTimeMillis());
            }
            if (string.equals("CURRENT_DATE") || string.equals("TODAY") || string.equals("SYSDATE")) {
                return new Timestamp(HsqlDateTime.getToday().getTime());
            }
            throw new IllegalArgumentException(Trace.getMessage(132));
        }
        string = string + "1970-01-01 00:00:00.000000000".substring(string.length());
        return Timestamp.valueOf(string);
    }

    public static Timestamp timestampValue(long l, int n) {
        Timestamp timestamp = new Timestamp(l);
        timestamp.setNanos(n);
        return timestamp;
    }

    public static java.sql.Date dateValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(133));
        }
        if (string.indexOf(45) == -1) {
            if ((string = string.toUpperCase()).equals("TODAY") || string.equals("CURRENT_DATE") || string.equals("SYSDATE")) {
                return HsqlDateTime.getToday();
            }
            throw new IllegalArgumentException(Trace.getMessage(134));
        }
        if (string.length() > sdfdPattern.length()) {
            return java.sql.Date.valueOf(string.substring(0, sdfdPattern.length()));
        }
        return java.sql.Date.valueOf(string);
    }

    public static Time timeValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Trace.getMessage(131));
        }
        if (string.toUpperCase().equals("CURRENT_TIME")) {
            long l = System.currentTimeMillis() - HsqlDateTime.getToday().getTime();
            l = l / 1000L * 1000L;
            return new Time(l);
        }
        return HsqlDateTime.getNormalisedTime(Time.valueOf(string));
    }

    public static Time getCurrentTime() {
        long l = System.currentTimeMillis() - HsqlDateTime.getToday().getTime();
        l = l / 1000L * 1000L;
        return new Time(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static java.sql.Date getDate(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar);
            Date date = sdfd.parse(string);
            return new java.sql.Date(date.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Time getTime(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar);
            Date date = sdft.parse(string);
            return new Time(date.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Timestamp getTimestamp(String string, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar);
            Date date = sdfts.parse(string.substring(0, sdftsPattern.length()));
            String string2 = string.substring(sdftsPattern.length(), string.length());
            Timestamp timestamp = new Timestamp(date.getTime());
            timestamp.setNanos(Integer.parseInt(string2));
            return timestamp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimestampString(Timestamp timestamp, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfts;
        synchronized (simpleDateFormat) {
            sdfts.setCalendar(calendar == null ? tempCal : calendar);
            return sdfts.format(new Date(timestamp.getTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTimeString(Time time, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdft;
        synchronized (simpleDateFormat) {
            sdft.setCalendar(calendar == null ? tempCal : calendar);
            return sdft.format(time);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDateString(java.sql.Date date, Calendar calendar) throws Exception {
        SimpleDateFormat simpleDateFormat = sdfd;
        synchronized (simpleDateFormat) {
            sdfd.setCalendar(calendar == null ? tempCal : calendar);
            return sdfd.format(date);
        }
    }

    static java.sql.Date getToday() {
        long l = System.currentTimeMillis();
        if (l - today.getTime() > 86400000L) {
            HsqlDateTime.resetToday();
        }
        return today;
    }

    public static void resetToDate(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
    }

    public static void resetToTime(Calendar calendar) {
        calendar.set(1, 0);
        calendar.set(2, 0);
        calendar.set(5, 0);
    }

    private static synchronized void resetToday() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        HsqlDateTime.resetToDate(gregorianCalendar);
        today = new java.sql.Date(gregorianCalendar.getTime().getTime());
    }

    private static void setTimeInMillis(Calendar calendar, long l) {
        calendar.setTimeInMillis(l);
    }

    private static long getTimeInMillis(Calendar calendar) {
        return calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Time getNormalisedTime(Time time) {
        Calendar calendar = tempCal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCal, time.getTime());
            tempCal.clear(1);
            tempCal.clear(2);
            tempCal.clear(5);
            long l = HsqlDateTime.getTimeInMillis(tempCal);
            return new Time(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Time getNormalisedTime(Timestamp timestamp) {
        Calendar calendar = tempCal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCal, timestamp.getTime());
            tempCal.clear(1);
            tempCal.clear(2);
            tempCal.clear(5);
            long l = HsqlDateTime.getTimeInMillis(tempCal);
            return new Time(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static java.sql.Date getNormalisedDate(Timestamp timestamp) {
        Calendar calendar = tempCal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCal, timestamp.getTime());
            tempCal.set(11, 0);
            tempCal.clear(12);
            tempCal.clear(13);
            tempCal.clear(14);
            long l = HsqlDateTime.getTimeInMillis(tempCal);
            return new java.sql.Date(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static java.sql.Date getNormalisedDate(java.sql.Date date) {
        Calendar calendar = tempCal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCal, date.getTime());
            tempCal.set(11, 0);
            tempCal.clear(12);
            tempCal.clear(13);
            tempCal.clear(14);
            long l = HsqlDateTime.getTimeInMillis(tempCal);
            return new java.sql.Date(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Timestamp getNormalisedTimestamp(Time time) {
        Calendar calendar = tempCal;
        synchronized (calendar) {
            long l = HsqlDateTime.getToday().getTime();
            HsqlDateTime.setTimeInMillis(tempCal, time.getTime());
            tempCal.clear(1);
            tempCal.clear(2);
            tempCal.clear(5);
            return new Timestamp(l += HsqlDateTime.getTimeInMillis(tempCal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Timestamp getNormalisedTimestamp(java.sql.Date date) {
        Calendar calendar = tempCal;
        synchronized (calendar) {
            HsqlDateTime.setTimeInMillis(tempCal, date.getTime());
            tempCal.set(11, 0);
            tempCal.clear(12);
            tempCal.clear(13);
            tempCal.clear(14);
            long l = HsqlDateTime.getTimeInMillis(tempCal);
            return new Timestamp(l);
        }
    }
}

