/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.HsqlSocketFactory;
import org.hsqldb.HsqlSocketRequestHandler;
import org.hsqldb.Result;
import org.hsqldb.ServerConnection;
import org.hsqldb.Trace;
import org.hsqldb.WebServer;
import org.hsqldb.WebServerConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.lib.java.javaSystem;
import org.hsqldb.resources.BundleHandler;

public class Server
implements HsqlSocketRequestHandler {
    static final String serverName = "HSQLDB/1.7.2";
    protected static final int serverBundleHandle = BundleHandler.getBundleHandle("org_hsqldb_Server_messages", null);
    HashSet serverConnSet;
    String[] dbAlias = new String[1];
    String[] dbType = new String[1];
    String[] dbPath = new String[1];
    int[] dbID = new int[1];
    HsqlProperties serverProperties;
    private int maxConnections;
    protected String serverId;
    protected int serverProtocol;
    protected ThreadGroup serverConnectionThreadGroup;
    protected HsqlSocketFactory socketFactory;
    protected ServerSocket socket;
    private Thread serverThread;
    private Throwable serverError;
    private volatile int serverState;
    private PrintWriter logWriter;
    private PrintWriter errWriter;

    public Server() {
        this(1);
    }

    protected Server(int n) {
        this.init(n);
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length > 0 && (string = stringArray[0]) != null && string.startsWith("-?")) {
            Server.printHelp("server.help");
            return;
        }
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        string = hsqlProperties.getProperty("server.database");
        if (string != null) {
            hsqlProperties.setProperty("server.database.0", string);
        }
        hsqlProperties.setPropertyIfNotExists("server.no_system_exit", "false");
        Server server = new Server();
        String string2 = server.getDefaultPropertiesPath();
        server.print("Startup sequence initiated from main() method");
        server.print("Loading properties from [" + string2 + ".properties]");
        if (!server.putPropertiesFromFile(string2)) {
            server.print("Could not load properties from file");
            server.print("Using cli/default properties only");
        }
        server.setProperties(hsqlProperties);
        server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void signalCloseAllServerConnections() {
        WrapperIterator wrapperIterator;
        this.trace("signalCloseAllServerConnections() entered");
        Object object = this.serverConnSet;
        synchronized (object) {
            wrapperIterator = new WrapperIterator(this.serverConnSet.toArray(null));
        }
        while (wrapperIterator.hasNext()) {
            object = (ServerConnection)wrapperIterator.next();
            this.trace("Closing " + object);
            ((ServerConnection)object).signalClose();
        }
        this.trace("signalCloseAllServerConnections() exited");
    }

    protected void finalize() throws Throwable {
        if (this.serverThread != null) {
            this.releaseServerSocket();
        }
    }

    public String getAddress() {
        return this.socket == null ? this.serverProperties.getProperty("server.address") : this.socket.getInetAddress().getHostAddress();
    }

    public String getDatabaseName(int n) {
        return this.serverProperties.getProperty("server.dbname." + n);
    }

    public String getDatabasePath(int n) {
        return this.serverProperties.getProperty("server.database." + n);
    }

    public int getDefaultPort(boolean bl) {
        return bl ? 554 : 9001;
    }

    public String getDefaultPropertiesPath() {
        return FileUtil.canonicalOrAbsolutePath("server");
    }

    public String getDefaultWebPage() {
        return "[IGNORED]";
    }

    public String getHelpString() {
        return BundleHandler.getString(serverBundleHandle, "server.help");
    }

    public PrintWriter getErrWriter() {
        return this.errWriter;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public int getPort() {
        return this.serverProperties.getIntegerProperty("server.port", this.getDefaultPort(this.isTls()));
    }

    public String getProductName() {
        return "HSQLDB server";
    }

    public String getProductVersion() {
        return "1.7.2";
    }

    public String getProtocol() {
        return this.isTls() ? "HSQLS" : "HSQL";
    }

    public Throwable getServerError() {
        return this.serverError;
    }

    public String getServerId() {
        return this.serverId;
    }

    public int getState() {
        return this.serverState;
    }

    public String getStateDescriptor() {
        String string;
        Throwable throwable = this.getServerError();
        switch (this.serverState) {
            case 16: {
                string = "SHUTDOWN";
                break;
            }
            case 4: {
                string = "OPENING";
                break;
            }
            case 8: {
                string = "CLOSING";
                break;
            }
            case 1: {
                string = "ONLINE";
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    public String getWebRoot() {
        return "[IGNORED]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) {
        String string;
        Runnable runnable;
        this.trace("handleConnection(" + socket + ") entered");
        if (!this.allowConnection(socket)) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.trace("allowConnection(): connection refused");
            this.trace("handleConnection() exited");
            return;
        }
        if (this.socketFactory != null) {
            this.socketFactory.configureSocket(socket);
        }
        if (this.serverProtocol == 1) {
            runnable = new ServerConnection(socket, this);
            string = runnable.getConnectionThreadName();
            HashSet hashSet = this.serverConnSet;
            synchronized (hashSet) {
                this.serverConnSet.add(runnable);
            }
        } else {
            runnable = new WebServerConnection(socket, (WebServer)this);
            string = ((WebServerConnection)runnable).getConnectionThreadName();
        }
        Thread thread = new Thread(this.serverConnectionThreadGroup, runnable, string);
        thread.start();
        this.trace("handleConnection() exited");
    }

    public boolean isNoSystemExit() {
        return this.serverProperties.isPropertyTrue("server.no_system_exit");
    }

    public boolean isRestartOnShutdown() {
        return this.serverProperties.isPropertyTrue("server.restart_on_shutdown");
    }

    public boolean isSilent() {
        return this.serverProperties.isPropertyTrue("server.silent");
    }

    public boolean isTls() {
        return this.serverProperties.isPropertyTrue("server.tls");
    }

    public boolean isTrace() {
        return this.serverProperties.isPropertyTrue("server.trace");
    }

    public boolean putPropertiesFromFile(String string) throws RuntimeException {
        string = StringUtil.isEmpty(string) ? this.getDefaultPropertiesPath() : FileUtil.canonicalOrAbsolutePath(string);
        this.trace("putPropertiesFromFile(): [" + string + ".properties]");
        HsqlProperties hsqlProperties = new HsqlProperties(string);
        boolean bl = false;
        try {
            bl = hsqlProperties.load();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bl) {
            this.setProperties(hsqlProperties);
        }
        return bl;
    }

    public void putPropertiesFromString(String string) throws RuntimeException {
        if (string == null || string.length() == 0) {
            return;
        }
        this.trace("putPropertiesFromString(): [" + string + "]");
        HsqlProperties hsqlProperties = HsqlProperties.delimitedArgPairsToProps(string, "=", ";", "server");
        this.setProperties(hsqlProperties);
    }

    public void setAddress(String string) throws RuntimeException {
        if (StringUtil.isEmpty(string)) {
            string = "0.0.0.0";
        }
        this.trace("setAddress(" + string + ")");
        this.serverProperties.setProperty("server.address", string);
    }

    public void setDatabaseName(int n, String string) throws RuntimeException {
        this.trace("setDatabaseName(" + n + "," + string + ")");
        this.serverProperties.setProperty("server.dbname." + n, string);
    }

    public void setDatabasePath(int n, String string) throws RuntimeException {
        this.trace("setDatabasePath(" + n + "," + string + ")");
        this.serverProperties.setProperty("server.database." + n, string);
    }

    public void setDefaultWebPage(String string) {
        this.trace("setDefaultWebPage(" + string + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.default_page", string);
    }

    public void setPort(int n) throws RuntimeException {
        this.trace("setPort(" + n + ")");
        this.serverProperties.setProperty("server.port", n);
    }

    public void setErrWriter(PrintWriter printWriter) {
        this.errWriter = printWriter;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this.logWriter = printWriter;
    }

    public void setNoSystemExit(boolean bl) {
        this.trace("setNoSystemExit(" + bl + ")");
        this.serverProperties.setProperty("server.no_system_exit", bl);
    }

    public void setRestartOnShutdown(boolean bl) {
        this.trace("setRestartOnShutdown(" + bl + ")");
        this.serverProperties.setProperty("server.restart_on_shutdown", bl);
    }

    public void setSilent(boolean bl) {
        this.trace("setSilent(" + bl + ")");
        this.serverProperties.setProperty("server.silent", bl);
    }

    public void setTls(boolean bl) {
        this.trace("setTls(" + bl + ")");
        this.serverProperties.setProperty("server.tls", bl);
    }

    public void setTrace(boolean bl) {
        this.trace("setTrace(" + bl + ")");
        this.serverProperties.setProperty("server.trace", bl);
        javaSystem.setLogToSystem(bl);
    }

    public void setWebRoot(String string) {
        string = new File(string).getAbsolutePath();
        this.trace("setWebRoot(" + string + ")");
        if (this.serverProtocol != 0) {
            return;
        }
        this.serverProperties.setProperty("server.root", string);
    }

    public void setProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties != null) {
            this.serverProperties.addProperties(hsqlProperties);
            this.translateAddressProperty(this.serverProperties);
        }
        this.maxConnections = hsqlProperties.getIntegerProperty("server.maxconnections", 16);
        javaSystem.setLogToSystem(this.isTrace());
    }

    public int start() {
        this.trace("start() entered");
        int n = this.getState();
        if (this.serverThread != null) {
            this.trace("start(): serverThread != null; no action taken");
            return n;
        }
        this.serverThread = new ServerThread("HSQLDB Server ");
        this.serverThread.start();
        this.trace("start() exiting");
        return n;
    }

    public int stop() {
        this.trace("stop() entered");
        int n = this.getState();
        if (this.serverThread == null) {
            this.trace("stop() serverThread is null; no action taken");
            return n;
        }
        this.releaseServerSocket();
        this.trace("stop() exiting");
        return n;
    }

    protected boolean allowConnection(Socket socket) {
        return true;
    }

    protected void init(int n) {
        this.serverState = 16;
        this.serverConnSet = new HashSet();
        this.serverId = this.toString();
        this.serverId = this.serverId.substring(this.serverId.lastIndexOf(46) + 1);
        this.serverProtocol = n;
        this.serverProperties = this.newDefaultProperties();
        this.logWriter = new PrintWriter(System.out);
        this.errWriter = new PrintWriter(System.err);
        javaSystem.setLogToSystem(this.isTrace());
    }

    protected synchronized void setState(int n) {
        this.serverState = n;
    }

    final void notify(int n, int n2) {
        this.trace("notifiy(" + n + "," + n2 + ") entered");
        if (n != 0) {
            return;
        }
        this.releaseDatabase(n2);
        boolean bl = true;
        for (int i = 0; i < this.dbID.length; ++i) {
            if (this.dbAlias[i] == null) continue;
            bl = false;
        }
        if (bl) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void releaseDatabase(int n) {
        WrapperIterator wrapperIterator;
        this.trace("releaseDatabase(" + n + ") entered");
        for (int i = 0; i < this.dbID.length; ++i) {
            if (this.dbID[i] != n) continue;
            this.dbID[i] = 0;
            this.dbAlias[i] = null;
            this.dbPath[i] = null;
            this.dbType[i] = null;
        }
        Object object = this.serverConnSet;
        synchronized (object) {
            wrapperIterator = new WrapperIterator(this.serverConnSet.toArray(null));
        }
        while (wrapperIterator.hasNext()) {
            object = (ServerConnection)wrapperIterator.next();
            if (((ServerConnection)object).dbID != n) continue;
            ((ServerConnection)object).signalClose();
            this.serverConnSet.remove(object);
        }
        this.trace("releaseDatabase(" + n + ") exiting");
    }

    protected synchronized void print(String string) {
        PrintWriter printWriter = this.logWriter;
        if (printWriter != null) {
            printWriter.println("[" + this.serverId + "]: " + string);
            printWriter.flush();
        }
    }

    final void printResource(String string) {
        if (serverBundleHandle < 0) {
            return;
        }
        String string2 = BundleHandler.getString(serverBundleHandle, string);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            this.print(stringTokenizer.nextToken());
        }
    }

    protected synchronized void printStackTrace(Throwable throwable) {
        if (this.errWriter != null) {
            throwable.printStackTrace(this.errWriter);
            this.errWriter.flush();
        }
    }

    final void printWithTimestamp(String string) {
        this.print(new Timestamp(System.currentTimeMillis()) + " " + string);
    }

    protected void trace(String string) {
        if (!this.isSilent()) {
            this.print("[" + Thread.currentThread() + "]: " + string);
        }
    }

    protected synchronized void printError(String string) {
        PrintWriter printWriter = this.errWriter;
        if (printWriter != null) {
            printWriter.print("[" + this.serverId + "]: ");
            printWriter.print("[" + Thread.currentThread() + "]: ");
            printWriter.println(string);
            printWriter.flush();
        }
    }

    final void traceRequest(int n, Result result) {
        if (this.isSilent()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append(':');
        block0 : switch (result.iMode) {
            case 65555: {
                stringBuffer.append("SQLCLI:SQLPREPARE ");
                stringBuffer.append(result.getMainString());
                break;
            }
            case 65547: {
                if (result.getSize() < 2) {
                    stringBuffer.append(result.getMainString());
                    break;
                }
                stringBuffer.append("SQLCLI:SQLEXECDIRECT:BATCHMODE\n");
                Iterator iterator = result.iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    stringBuffer.append(objectArray[0]).append('\n');
                }
                break;
            }
            case 65548: {
                stringBuffer.append("SQLCLI:SQLEXECUTE:");
                if (result.getSize() > 1) {
                    stringBuffer.append("BATCHMODE:");
                }
                stringBuffer.append(result.getStatementID());
                break;
            }
            case 65552: {
                stringBuffer.append("SQLCLI:SQLFREESTMT:");
                stringBuffer.append(result.getStatementID());
                break;
            }
            case 7: {
                stringBuffer.append("HSQLCLI:GETSESSIONATTR");
                break;
            }
            case 6: {
                stringBuffer.append("HSQLCLI:SETSESSIONATTR:");
                stringBuffer.append("AUTOCOMMIT ");
                stringBuffer.append(result.rRoot.data[4]);
                stringBuffer.append(" CONNECTION_READONLY ");
                stringBuffer.append(result.rRoot.data[6]);
                break;
            }
            case 66541: {
                stringBuffer.append("SQLCLI:SQLENDTRAN:");
                switch (result.getEndTranType()) {
                    case 0: {
                        stringBuffer.append("COMMIT");
                        break block0;
                    }
                    case 1: {
                        stringBuffer.append("ROLLBACK");
                        break block0;
                    }
                    case 4: {
                        stringBuffer.append("SAVEPOINT_NAME_RELEASE ");
                        stringBuffer.append(result.getMainString());
                        break block0;
                    }
                    case 2: {
                        stringBuffer.append("SAVEPOINT_NAME_ROLLBACK ");
                        stringBuffer.append(result.getMainString());
                        break block0;
                    }
                }
                stringBuffer.append(result.getEndTranType());
                break;
            }
            case 65610: {
                stringBuffer.append("SQLCLI:SQLSTARTTRAN");
                break;
            }
            case 65545: {
                stringBuffer.append("SQLCLI:SQLDISCONNECT");
                break;
            }
            case 66552: {
                stringBuffer.append("SQLCLI:SQLSETCONNECTATTR:");
                switch (result.getConnectionAttrType()) {
                    case 10027: {
                        stringBuffer.append("SQL_ATTR_SAVEPOINT_NAME ");
                        stringBuffer.append(result.getMainString());
                        break block0;
                    }
                }
                stringBuffer.append(result.getConnectionAttrType());
                break;
            }
            default: {
                stringBuffer.append("SQLCLI:MODE:");
                stringBuffer.append(result.iMode);
            }
        }
        this.print(stringBuffer.toString());
    }

    private final HsqlProperties newDefaultProperties() {
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.setProperty("server.restart_on_shutdown", false);
        hsqlProperties.setProperty("server.address", "0.0.0.0");
        hsqlProperties.setProperty("server.database.0", "test");
        hsqlProperties.setProperty("server.dbname.0", "");
        hsqlProperties.setProperty("server.no_system_exit", true);
        boolean bl = false;
        try {
            bl = System.getProperty("javax.net.ssl.keyStore") != null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsqlProperties.setProperty("server.port", this.getDefaultPort(bl));
        hsqlProperties.setProperty("server.silent", true);
        hsqlProperties.setProperty("server.tls", bl);
        hsqlProperties.setProperty("server.trace", false);
        hsqlProperties.setProperty("server.default_page", "index.html");
        hsqlProperties.setProperty("server.root", "./");
        return hsqlProperties;
    }

    final void openDatabases() throws HsqlException {
        int n;
        int n2 = "server.dbname.".length();
        this.trace("openDatabases() entered");
        String[] stringArray = new String[10];
        Enumeration enumeration = this.serverProperties.propertyNames();
        int n3 = 0;
        try {
            n = 0;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("server.dbname.")) continue;
                int n4 = Integer.parseInt(string.substring(n2));
                n3 = n4 < n3 ? n3 : n4;
                stringArray[n4] = this.serverProperties.getProperty(string);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.trace("dblist: " + arrayIndexOutOfBoundsException.toString());
        }
        this.dbAlias = new String[n3 + 1];
        this.dbType = new String[n3 + 1];
        this.dbPath = new String[n3 + 1];
        this.dbID = new int[n3 + 1];
        ArrayUtil.copyArray(stringArray, this.dbAlias, n3 + 1);
        for (n = 0; n < this.dbAlias.length; ++n) {
            HsqlProperties hsqlProperties = DatabaseManager.parseURL(this.getDatabasePath(n), false);
            this.dbPath[n] = hsqlProperties.getProperty("database");
            this.dbType[n] = hsqlProperties.getProperty("connection_type");
            this.trace("Opening database: [" + this.dbType[n] + this.dbPath[n] + "]");
            StopWatch stopWatch = new StopWatch();
            int n5 = DatabaseManager.getDatabase(this.dbType[n], this.dbPath[n], this, hsqlProperties);
            stopWatch.stop();
            this.dbID[n] = n5;
            String string = "Database [index=" + n + ", id=" + n5 + ", " + "db=" + this.dbType[n] + this.dbPath[n] + ", alias=" + this.dbAlias[n] + "] opened sucessfully";
            this.print(stopWatch.elapsedTimeToMessage(string));
        }
        this.trace("openDatabases() exiting");
    }

    private final void openServerSocket() throws Exception {
        this.trace("openServerSocket() entered");
        if (this.isTls()) {
            this.trace("Requesting TLS/SSL-encrypted JDBC");
        }
        StopWatch stopWatch = new StopWatch();
        this.socketFactory = HsqlSocketFactory.getInstance(this.isTls());
        String string = this.getAddress();
        int n = this.getPort();
        if (StringUtil.isEmpty(string) || "0.0.0.0".equalsIgnoreCase(string.trim())) {
            this.socket = this.socketFactory.createServerSocket(n);
        } else {
            try {
                this.socket = this.socketFactory.createServerSocket(n, string);
            }
            catch (UnknownHostException unknownHostException) {
                Object[] objectArray;
                int n2;
                Vector vector = Server.listLocalInetAddressNames();
                if (vector.size() > 0) {
                    n2 = 148;
                    objectArray = new Object[]{string, vector};
                } else {
                    n2 = 149;
                    objectArray = new Object[]{string};
                }
                throw new UnknownHostException(Trace.getMessage(n2, true, objectArray));
            }
        }
        this.socket.setSoTimeout(1000);
        this.trace("Got server socket: " + this.socket);
        this.print(stopWatch.elapsedTimeToMessage("Server socket opened successfully"));
        if (this.socketFactory.isSecure()) {
            this.print("Using TLS/SSL-encrypted JDBC");
        }
        this.trace("openServerSocket() exiting");
    }

    private final void printServerOnlineMessage() {
        String string = this.getProductName() + " " + this.getProductVersion() + " is online";
        this.printWithTimestamp(string);
        this.printResource("online.help");
    }

    private final void traceProperties() {
        if (this.isSilent()) {
            return;
        }
        Enumeration enumeration = this.serverProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.serverProperties.getProperty(string);
            this.trace(string + "=" + string2);
        }
    }

    private final void releaseServerSocket() {
        this.trace("releaseServerSocket() entered");
        if (this.socket != null) {
            this.trace("Releasing server socket: [" + this.socket + "]");
            this.setState(8);
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.printError("Exception closing server socket");
                this.printError("releaseServerSocket(): " + iOException);
            }
            this.socket = null;
        }
        this.trace("releaseServerSocket() exited");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run() {
        this.trace("run() entered");
        this.print("Initiating startup sequence...");
        this.traceProperties();
        StopWatch stopWatch = new StopWatch();
        this.setState(4);
        this.setServerError(null);
        try {
            this.openServerSocket();
        }
        catch (Exception exception) {
            this.setServerError(exception);
            this.printError("run()/openServerSocket(): ");
            this.printStackTrace(exception);
            this.shutdown(true);
            return;
        }
        String string = "HSQLDB Connections @" + Integer.toString(this.hashCode(), 16);
        ThreadGroup threadGroup = new ThreadGroup(string);
        threadGroup.setDaemon(false);
        this.serverConnectionThreadGroup = threadGroup;
        try {
            this.openDatabases();
        }
        catch (Exception exception) {
            this.setServerError(exception);
            this.printError("run()/openDatabases(): ");
            this.printStackTrace(exception);
            this.shutdown(true);
            return;
        }
        this.setState(1);
        this.print(stopWatch.elapsedTimeToMessage("Startup sequence completed"));
        this.printServerOnlineMessage();
        try {
            while (true) {
                try {
                    while (true) {
                        this.handleConnection(this.socket.accept());
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            if (this.getState() == 1) {
                this.setServerError(iOException);
                this.printError(this + ".run()/handleConnection(): ");
                this.printStackTrace(iOException);
            }
            this.shutdown(false);
        }
        catch (Throwable throwable) {
            try {
                this.trace(throwable.toString());
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                this.shutdown(false);
            }
        }
    }

    protected void setServerError(Throwable throwable) {
        this.serverError = throwable;
    }

    private final void shutdown(boolean bl) {
        int n;
        this.trace("shutdown() entered");
        StopWatch stopWatch = new StopWatch();
        this.print("Initiating shutdown sequence...");
        this.releaseServerSocket();
        DatabaseManager.deRegisterServer(this);
        for (n = 0; n < this.dbPath.length; ++n) {
            this.releaseDatabase(n);
        }
        if (this.serverConnectionThreadGroup != null) {
            if (!this.serverConnectionThreadGroup.isDestroyed()) {
                n = 0;
                while (this.serverConnectionThreadGroup.activeCount() > 0) {
                    try {
                        this.wait(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++n;
                }
                try {
                    this.serverConnectionThreadGroup.destroy();
                    this.trace(this.serverConnectionThreadGroup.getName() + " destroyed");
                }
                catch (Throwable throwable) {
                    this.trace(this.serverConnectionThreadGroup.getName() + " not destroyed");
                    this.trace(throwable.toString());
                }
            }
            this.serverConnectionThreadGroup = null;
        }
        this.serverThread = null;
        this.setState(16);
        this.print(stopWatch.elapsedTimeToMessage("Shutdown sequence completed"));
        if (this.isNoSystemExit()) {
            this.printWithTimestamp("SHUTDOWN : System.exit() was not called");
            this.trace("shutdown() exited");
        } else {
            this.printWithTimestamp("SHUTDOWN : System.exit() is called next");
            this.trace("shutdown() exiting...");
            try {
                System.exit(0);
            }
            catch (Throwable throwable) {
                this.trace(throwable.toString());
            }
        }
    }

    protected static void printHelp(String string) {
        System.out.print(BundleHandler.getString(serverBundleHandle, string));
    }

    public static Vector listLocalInetAddressNames() {
        InetAddress[] inetAddressArray;
        InetAddress inetAddress;
        HashSet hashSet = new HashSet();
        Vector<Object> vector = new Vector<Object>();
        try {
            int n;
            inetAddress = InetAddress.getLocalHost();
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int n;
            inetAddress = InetAddress.getByName(null);
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostAddress());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
            inetAddressArray = InetAddress.getAllByName(inetAddress.getHostName());
            for (n = 0; n < inetAddressArray.length; ++n) {
                hashSet.add(inetAddressArray[n].getHostAddress());
                hashSet.add(inetAddressArray[n].getHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            hashSet.add(InetAddress.getByName("loopback").getHostAddress());
            hashSet.add(InetAddress.getByName("loopback").getHostName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        return vector;
    }

    private void translateAddressProperty(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        String string = hsqlProperties.getProperty("server.address");
        if (StringUtil.isEmpty(string)) {
            hsqlProperties.setProperty("server.address", "0.0.0.0");
        }
    }

    private class ServerThread
    extends Thread {
        ServerThread(String string) {
            super(string);
            this.setName(string + '@' + Integer.toString(Server.this.hashCode(), 16));
        }

        public void run() {
            Server.this.run();
            Server.this.trace("ServerThread.run() exited");
        }
    }
}

