/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Trace;
import org.hsqldb.UserManager;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

class User {
    private boolean isAdministrator;
    private boolean isSys;
    private IntValueHashMap rightsMap = new IntValueHashMap();
    private String sName;
    private String sPassword;
    private User uPublic;

    User(String string, String string2, boolean bl, User user) {
        this.sName = string;
        this.setPassword(string2);
        this.isAdministrator = bl;
        this.isSys = string.equals("SYS");
        this.uPublic = user;
    }

    String getName() {
        return this.sName;
    }

    String getPassword() {
        return this.sPassword;
    }

    IntValueHashMap getRights() {
        return this.rightsMap;
    }

    void setPassword(String string) {
        this.sPassword = string;
    }

    void checkPassword(String string) throws HsqlException {
        Trace.check(string.equals(this.sPassword), 33);
    }

    void grant(Object object, int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.rightsMap.get(object, 0);
        this.rightsMap.put(object, n2 |= n);
    }

    void revoke(Object object, int n) {
        if (n == 0) {
            return;
        }
        int n2 = this.rightsMap.get(object, 0);
        if (n2 == 0) {
            return;
        }
        if ((n = n2 & 15 - n) == 0) {
            this.rightsMap.remove(object);
        } else {
            this.rightsMap.put(object, n);
        }
    }

    void revokeDbObject(Object object) {
        this.rightsMap.remove(object);
    }

    void revokeAll() {
        this.rightsMap.clear();
        this.isAdministrator = false;
    }

    void check(Object object, int n) throws HsqlException {
        if (!this.isAccessible(object, n)) {
            throw Trace.error(33);
        }
    }

    boolean isAccessible(Object object, int n) {
        if (this.isAdministrator) {
            return true;
        }
        if (object instanceof String && (((String)object).startsWith("org.hsqldb.Library") || ((String)object).startsWith("java.lang.Math"))) {
            return true;
        }
        int n2 = this.rightsMap.get(object, 0);
        if (n2 != 0) {
            return (n2 & n) != 0;
        }
        return this.uPublic == null ? false : this.uPublic.isAccessible(object, n);
    }

    boolean isAccessible(Object object) {
        return this.isAccessible(object, 15);
    }

    void checkAdmin() throws HsqlException {
        Trace.check(this.isAdmin(), 33);
    }

    boolean isAdmin() {
        return this.isAdministrator;
    }

    boolean isSys() {
        return this.isSys;
    }

    HashSet getGrantedClassNames(boolean bl) {
        int n;
        Object object;
        IntValueHashMap intValueHashMap = this.rightsMap;
        HashSet hashSet = new HashSet();
        Iterator iterator = this.rightsMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof String) || (n = intValueHashMap.get(object, 0)) != 15) continue;
            hashSet.add(object);
        }
        if (bl && this.uPublic != null) {
            intValueHashMap = this.uPublic.rightsMap;
            iterator = intValueHashMap.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!(object instanceof String) || (n = intValueHashMap.get(object, 0)) != 15) continue;
                hashSet.add(object);
            }
        }
        return hashSet;
    }

    String[] listTablePrivileges(HsqlNameManager.HsqlName hsqlName) {
        return UserManager.getRightsArray(this.rightsMap.get((Object)hsqlName, 0));
    }

    String getAlterUserDDL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ALTER").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.sName).append(' ');
        stringBuffer.append("SET").append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append('\"').append(this.sPassword).append('\"');
        return stringBuffer.toString();
    }

    String getCreateUserDDL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("CREATE").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.sName).append(' ');
        stringBuffer.append("PASSWORD").append(' ');
        stringBuffer.append('\"').append(this.sPassword).append('\"');
        if (this.isAdministrator) {
            stringBuffer.append(' ').append("ADMIN");
        }
        return stringBuffer.toString();
    }

    String getConnectStatement() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CONNECT").append(' ');
        stringBuffer.append("USER").append(' ');
        stringBuffer.append(this.sName);
        return stringBuffer.toString();
    }
}

