/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.jdbc.jdbcResultSet;
import org.hsqldb.jdbc.jdbcUtil;

public class jdbcStatement
implements Statement {
    boolean isClosed;
    private boolean isEscapeProcessing = true;
    protected jdbcConnection connection;
    protected int maxRows;
    protected Result resultIn;
    protected int rsType = 1003;
    protected Result resultOut = new Result(65547);
    protected Result batchResultOut = new Result(8);

    public ResultSet executeQuery(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        return new jdbcResultSet(this, this.resultIn, this.connection.connProperties);
    }

    public int executeUpdate(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        if (this.resultIn == null || this.resultIn.iMode == 3) {
            throw new SQLException(Trace.getMessage(142));
        }
        if (this.resultIn.iMode == 2) {
            jdbcUtil.throwError(this.resultIn);
        }
        return this.resultIn.getUpdateCount();
    }

    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.batchResultOut = null;
        this.connection = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw jdbcUtil.sqlException(62);
        }
    }

    public int getMaxRows() throws SQLException {
        this.checkClosed();
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw jdbcUtil.sqlException(62);
        }
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
        this.isEscapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.checkClosed();
        if (n < 0) {
            throw jdbcUtil.sqlException(62);
        }
    }

    public void cancel() throws SQLException {
        this.checkClosed();
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    public boolean execute(String string) throws SQLException {
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        this.fetchResult(string);
        return this.resultIn.iMode == 3;
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.resultIn == null || this.resultIn.iMode != 3 ? null : new jdbcResultSet(this, this.resultIn, this.connection.connProperties);
    }

    public int getUpdateCount() throws SQLException {
        return this.resultIn == null || this.resultIn.iMode == 3 ? -1 : this.resultIn.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        this.checkClosed();
        this.resultIn = null;
        return false;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.checkClosed();
        if (n != 1000) {
            throw jdbcUtil.notSupported;
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    public void setFetchSize(int n) throws SQLException {
        this.checkClosed();
    }

    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkClosed();
        return 1007;
    }

    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    public void addBatch(String string) throws SQLException {
        this.checkClosed();
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.batchResultOut.add(new Object[]{string});
    }

    public void clearBatch() throws SQLException {
        this.checkClosed();
        this.batchResultOut.clear();
    }

    public int[] executeBatch() throws SQLException {
        int[] nArray;
        this.checkClosed();
        this.connection.clearWarningsNoCheck();
        int n = this.batchResultOut.getSize();
        if (n == 0) {
            throw jdbcUtil.sqlException(62, "Empty batch");
        }
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.batchResultOut);
        }
        catch (HsqlException hsqlException) {
            this.batchResultOut.clear();
            throw jdbcUtil.sqlException(hsqlException);
        }
        this.batchResultOut.clear();
        if (this.resultIn.iMode == 2) {
            jdbcUtil.throwError(this.resultIn);
        }
        if ((nArray = this.resultIn.getUpdateCounts()).length != n) {
            throw new BatchUpdateException(nArray);
        }
        return nArray;
    }

    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.connection;
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public boolean execute(String string, int n) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw jdbcUtil.notSupported;
    }

    public int getResultSetHoldability() throws SQLException {
        return 1;
    }

    jdbcStatement(jdbcConnection jdbcConnection2, int n) {
        this.connection = jdbcConnection2;
        this.rsType = n;
    }

    boolean isClosed() {
        return this.isClosed;
    }

    void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw jdbcUtil.sqlException(126);
        }
        if (this.connection.isClosed) {
            throw jdbcUtil.sqlException(2);
        }
    }

    private void fetchResult(String string) throws SQLException {
        if (this.isEscapeProcessing) {
            string = this.connection.nativeSQL(string);
        }
        this.resultIn = null;
        this.resultOut.setMainString(string);
        this.resultOut.setMaxRows(this.maxRows);
        try {
            this.resultIn = this.connection.sessionProxy.execute(this.resultOut);
            if (this.resultIn.iMode == 2) {
                throw new HsqlException(this.resultIn);
            }
        }
        catch (HsqlException hsqlException) {
            throw jdbcUtil.sqlException(hsqlException);
        }
    }
}

