/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HsqlHeap;
import org.hsqldb.lib.ObjectComparator;

public class HsqlArrayHeap
implements HsqlHeap {
    protected ObjectComparator oc;
    protected int count;
    protected Object[] heap;

    public HsqlArrayHeap(int n, ObjectComparator objectComparator) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException("" + n);
        }
        if (objectComparator == null) {
            throw new IllegalArgumentException("null comparator");
        }
        this.heap = new Object[n];
        this.oc = objectComparator;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.count; ++i) {
            this.heap[i] = null;
        }
        this.count = 0;
    }

    public synchronized void add(Object object) throws IllegalArgumentException, RuntimeException {
        if (object == null) {
            throw new IllegalArgumentException("heap does not accept null.");
        }
        if (this.isFull()) {
            throw new RuntimeException("heap is full.");
        }
        if (this.count >= this.heap.length) {
            this.increaseCapacity();
        }
        int n = this.count++;
        while (n > 0) {
            int n2 = n - 1 >> 1;
            try {
                if (this.oc.compare(object, this.heap[n2]) >= 0) {
                    break;
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception.toString());
            }
            this.heap[n] = this.heap[n2];
            n = n2;
        }
        this.heap[n] = object;
    }

    public synchronized boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized boolean isFull() {
        return this.count == Integer.MAX_VALUE;
    }

    public synchronized Object peek() {
        return this.heap[0];
    }

    public synchronized Object remove() {
        int n;
        if (this.count == 0) {
            return null;
        }
        int n2 = 0;
        Object object = this.heap[n2];
        --this.count;
        if (this.count == 0) {
            this.heap[0] = null;
            return object;
        }
        Object object2 = this.heap[this.count];
        this.heap[this.count] = null;
        while ((n = (n2 << 1) + 1) < this.count) {
            int n3;
            int n4 = (n2 << 1) + 2;
            int n5 = n3 = n4 >= this.count || this.oc.compare(this.heap[n], this.heap[n4]) < 0 ? n : n4;
            if (this.oc.compare(object2, this.heap[n3]) <= 0) break;
            this.heap[n2] = this.heap[n3];
            n2 = n3;
        }
        this.heap[n2] = object2;
        return object;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" : size=");
        stringBuffer.append(this.count);
        stringBuffer.append(' ');
        stringBuffer.append('[');
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append(this.heap[i]);
            if (i + 1 >= this.count) continue;
            stringBuffer.append(',');
            stringBuffer.append(' ');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private void increaseCapacity() {
        Object[] objectArray = this.heap;
        this.heap = new Object[3 * this.heap.length / 2 + 1];
        System.arraycopy(objectArray, 0, this.heap, 0, this.count);
    }
}

